<?php
/*
Plugin Name: Serveropsghq Security
Description: Security Hardening - DO NOT DEACTIVATE!!
Author: Serveropsghq
Author URI: https://velocityhost.com.au
Version: 1
Requires at least: 5
Tested up to: 5.5
Requires PHP: 7.0
Domain Path: languages
Text Domain: Velocity Digital
*/





// DO NOT LOAD DIRECTLY
	if ( ! defined( 'ABSPATH' ) ) {
		die( '-1' );
	}


// KILL XMLRPC
	add_filter( 'xmlrpc_enabled', '__return_false' );


// Kill X-PINGBACK TO HEADER
	add_filter( 'wp_headers', 'disable_x_pingback' );
	function disable_x_pingback( $headers ) {
	    unset( $headers['X-Pingback'] );

		return $headers;
		}


// BLOCK NO-REFERRER REQUESTS
function check_referrer() {
	if (!isset($_SERVER['HTTP_REFERER']) || $_SERVER['HTTP_REFERER'] == '') {
		wp_die(__('Please do not access this file directly.'));
	}
}
add_action('check_comment_flood', 'check_referrer');


/* ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||| */
/* |||||||||||||||||||||||||||||||||||||||||||||| CUSTOM LOGIN SECURITY |||||||||||||||||||||||||||||||||||||||||||||||||| */
/* ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||| */

// REMOVE LOGIN SHAKE
	function my_login_head() {
		remove_action('login_head', 'wp_shake_js', 12);
		}
	add_action('login_head', 'my_login_head');


// LOGIN ERROR MESSAGE
	function no_wordpress_errors(){
		return 'You should not be here, go away!';
		}
	add_filter( 'login_errors', 'no_wordpress_errors' );


// REMOVE 'LOST PASSWORD'
	function remove_lostpassword_text ( $text ) {
	     if ($text == 'Lost your password?'){$text = '';}
		 return $text;
		 }
	add_filter( 'gettext', 'remove_lostpassword_text' );


// REMOVE 'REGISTER' TEXT
	function remove_register_text ( $text ) {
		 if ($text == 'Register'){$text = '';}
		 return $text;
		 }
	add_filter( 'gettext', 'remove_register_text' );

// DISABLE APPLICATION PASSWORDS JEFF STARR
	add_filter('wp_is_application_passwords_available', '__return_false');


/* ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||| */
/* |||||||||||||||||||||||||||||||||||||||||||||| CUSTOM LOGIN SECURITY |||||||||||||||||||||||||||||||||||||||||||||||||| */
/* ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||| */

// REMOVE URL FIELD FROM COMMENT FORM
	add_action( 'after_setup_theme', 'tu_add_comment_url_filter' );
		function tu_add_comment_url_filter() {
		add_filter( 'comment_form_default_fields', 'tu_disable_comment_url', 20 );
		}

		function tu_disable_comment_url($fields) {
		unset($fields['url']);
		return $fields;
		}



/* ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||| */
/* |||||||||||||||||||||||||||||||||||||||||| FULL DISABLE WP 5.5 FEATURES ||||||||||||||||||||||||||||||||||||||||||||||| */
/* ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||| */
 
 // DISABLE PLUGIN AUTO-UPDATE UI ELEMENTS WP 5.5+
 	add_filter( 'plugins_auto_update_enabled', '__return_false' );

 // DISABLE PLUGIN AUTO-UPDATE WP 5.5+
 	add_filter( 'auto_update_plugin', '__return_false' );
 
// DISABLE THEME AUTO-UPDATE UI ELEMENTS WP 5.5+
	add_filter( 'themes_auto_update_enabled', '__return_false' ); 
 
// DISABLE THEME AUTO-UPDATE WP 5.5+
	add_filter( 'auto_update_theme', '__return_false' );
	



/* Stop Adding Functions Below this Line */
?>