# Contributing to RxPHP

Thank you for taking the time to contribute.

Here are some guidelines that you can follow:

## <a name="rules"></a> Coding Rules
These rules are to ensure consistency throughout the source code and with other ReactiveX [projects](http://reactivex.io/languages.html), please keep these rules in mind as you are working:

* All features or bug fixes **must be tested**.
* Test coverage should be equal to or greater than the [RxJS v4 tests](https://github.com/Reactive-Extensions/RxJS/tree/master/tests/observable).
* Test coverage must be 100% by lines.
* We follow the [PSR2](http://www.php-fig.org/psr/psr-2/) coding style guide.
* New operators should be composed with existing operators unless non-composed performance gains are demonstrable.
* Examples for operators should be based upon the RxJS v4 [operators](https://github.com/Reactive-Extensions/RxJS/tree/master/doc/api/core/operators).
* When at all possible, operator definitions and behavior should mirror RxJS or RxJava.

If you have any questions or need help with your contribution, please feel free to open a PR or an issue and ask for help.
