<?php

// Defines
define( 'FL_CHILD_THEME_DIR', get_stylesheet_directory() );
define( 'FL_CHILD_THEME_URL', get_stylesheet_directory_uri() );

// Classes
require_once 'classes/class-fl-child-theme.php';

// Actions
add_action( 'wp_enqueue_scripts', 'FLChildTheme::enqueue_scripts', 1000 );

//Add all custom functions to Serveropsghq Functions plugin
/*  Comment Form Redirection Fix */
function wpse_58613_comment_redirect( $location ) {
    if ( isset( $_POST['my_redirect_to'] ) ) // Don't use "redirect_to", internal WP var
        $location = $_POST['my_redirect_to'];

    return $location;
}
add_filter( 'comment_post_redirect', 'wpse_58613_comment_redirect' );
/** Creating ACF options page for Header & footer injections */ 
add_action('acf/init', 'my_acf_op_init');
function my_acf_op_init()
{
	// Check function exists.
	if (function_exists('acf_add_options_sub_page')) {
		// Add parent.
		$parent = acf_add_options_page(array(
			'page_title' => __('Theme General Settings'),
			'menu_title' => __('Header & footer inserter'),
			'menu_slug'  => __('theme-settings'),
			'redirect'   => false,
		));
	}
}
/** Adding custom code in header */
add_action ( 'wp_head', 'hook_inHeader' );
function hook_inHeader() {
    $themeHeaderData = get_fields( 'options' );
    if (isset($themeHeaderData['header_section_code']) && !empty($themeHeaderData['header_section_code'])) :
        // Add custom head code
        echo $themeHeaderData['header_section_code'];
    endif;
}
/** Adding custom code in footer */
add_action ( 'wp_footer', 'hook_inFooter' );
function hook_inFooter() {
    $themeFooterData = get_fields( 'options' );
    if (isset($themeFooterData['footer_section_code']) && !empty($themeFooterData['footer_section_code'])) :
        // Add custom footer code
        echo $themeFooterData['footer_section_code']; 
    endif;
}
/** Add code after opening body tag.  */
add_action( 'wp_body_open', 'custom_body_open_code' );
function custom_body_open_code() {
    $themeBodyData = get_fields( 'options' );
    if (isset($themeBodyData['body_section_code']) && !empty($themeBodyData['body_section_code'])) :
        // Add custom code inside body tag
        echo $themeBodyData['body_section_code']; 
    endif;
}
// Gravity Forms: Auto-scroll to form on page after confirmation
add_filter( 'gform_confirmation_anchor', '__return_true' );

// exclude current post form the recent post bar
function be_exclude_current_post( $args ) {
    if( is_singular() && !isset( $args['post__in'] ) )
        $args['post__not_in'] = array( get_the_ID() );
    return $args;
}
add_filter( 'widget_posts_args', 'be_exclude_current_post' );

/*
** Gravity Forms - Disable Autocomplete
*/
add_filter( 'gform_form_tag', 'gform_form_tag_autocomplete', 11, 2 );
function gform_form_tag_autocomplete( $form_tag, $form )
{
if ( is_admin() ) return $form_tag;
if ( GFFormsModel::is_html5_enabled() )
{
$form_tag = str_replace( '>', ' autocomplete="off">', $form_tag );
}
return $form_tag;
}

/*remove blog in courses page slug*/
add_action( 'init', 'create_post_type' );
function create_post_type() {
  register_post_type( 'courses',
      array(
          'public' => true,
          'has_archive' => true,
          'rewrite' => array(
			'with_front' => false,
			'slug'       => 'courses'
		)
      )
  );
}