<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Silence is golden.
}
?>
<?php get_header(); ?>

<?php 
if (  is_home()) { ?>
    <div class="fs-blog-banner">
    <h1 class="blog-heading">Blogs</h1>
</div>
<?php 
}
?>
<div class="fl-archive <?php FLLayout::container_class(); ?>">
	<div class="<?php FLLayout::row_class(); ?>">

		<?php FLTheme::sidebar( 'left' ); ?>

		<div class="fl-content <?php FLLayout::content_class(); ?>"<?php FLTheme::print_schema( ' itemscope="itemscope" itemtype="https://schema.org/Blog"' ); ?>>

			<?php FLTheme::archive_page_header(); ?>

			<?php if ( have_posts() ) : ?>

				<?php
				while ( have_posts() ) :
					the_post();
					?>
					<?php get_template_part( 'content', get_post_format() ); ?>
				<?php endwhile; ?>

				<?php

                the_posts_pagination(array(

                    'prev_text' => '<i class="fa fa-angle-left"></i>' . '<span class="screen-reader-text">' . __('Previous page', 'yourtheme') . '</span>',
                    'next_text' => '<span class="screen-reader-text">' . __('Next page', 'yourtheme') . '</span>' . '<i class="fa fa-angle-right"></i>',
                    'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('Page', 'yourtheme') . ' </span>',

                )); ?>
                <?php // FLTheme::archive_nav(); 
                ?>

			<?php else : ?>

				<?php get_template_part( 'content', 'no-results' ); ?>

			<?php endif; ?>

		</div>

		<?php FLTheme::sidebar( 'right' ); ?>

	</div>
</div>

<?php get_footer(); ?>
