<?php


namespace WPStaging\Framework\CloningProcess\SearchReplace;


class SearchReplaceService
{
    private $excludedStrings = array(
        'Admin_custome_login_Slidshow',
        'Admin_custome_login_Social',
        'Admin_custome_login_logo',
        'Admin_custome_login_text',
        'Admin_custome_login_login',
        'Admin_custome_login_top',
        'Admin_custome_login_dashboard',
        'Admin_custome_login_Version',
        'upload_path',
        'wpstg_existing_clones_beta',
        'wpstg_existing_clones',
        'wpstg_settings',
        'wpstg_license_status',
        'wpstg_tmp_data',
        'siteurl',
        'home'
    );

    public function excludedStrings()
    {
        return $this->excludedStrings;
    }

    public function generatePatterns($string)
    {
        return array(
            '%2F%2F' . str_replace('/', '%2F', $string), // HTML entitity for WP Backery Page Builder Plugin
            '\/\/' . str_replace('/', '\/', $string), // Escaped \/ used by revslider and several visual editors
            '//' . $string // //example.com
        );
    }
}