<?php

namespace WPStaging\Framework\Filesystem\Filters;

class PathExcludeFilter extends \FilterIterator
{
    protected $exclude = array();

    public function __construct(\Iterator $iterator, $exclude = array())
    {
        parent::__construct($iterator);
        $this->exclude = $exclude;
    }

    public function accept()
    {
        $path = $this->getInnerIterator()->getPathname();

        //  new line character on linux
        if (false !== strpos($path, "\n")) {
            return false;
        }
        // new line character on Windows
        if (false !== strpos($path, "\r")) {
            return false;
        }

        if (in_array(wpstg_replace_windows_directory_separator($path), $this->exclude)) {
            return false;
        }

        return true;
    }
}
