<?php
require_once( get_template_directory() . '/functions-case.php' );
require_once( get_template_directory() . '/functions-option.php' );

function addStylesheets() {
	wp_enqueue_style( 'landingPage', get_template_directory_uri() . '/css/landing-adworld.css', array(), false, 'all' );
}

add_action( 'wp_enqueue_scripts', 'addStylesheets' );

if ( function_exists( 'acf_add_options_page' ) ) {
	acf_add_options_page();
}

register_nav_menus( array(
	'header' => 'Header menu',
	'footer' => 'Footer menu'
) );

add_filter( 'nav_menu_css_class', 'so_37823371_menu_item_class', 10, 4 );

function so_37823371_menu_item_class( $classes, $item, $args, $depth ) {
	$classes[] = 'nav-item';

	return $classes;
}

add_filter( 'nav_menu_css_class', 'special_nav_class', 10, 2 );

function special_nav_class( $classes, $item ) {
	if ( in_array( 'current-menu-item', $classes ) ) {
		$classes[] = 'active ';
	}

	return $classes;
}

function mytheme_post_thumbnails() {
	add_theme_support( 'post-thumbnails' );
}

add_action( 'after_setup_theme', 'mytheme_post_thumbnails' );

function wpse250243_comment_form_default_fields( $fields ) {
	$commenter     = wp_get_current_commenter();
	$user          = wp_get_current_user();
	$user_identity = $user->exists() ? $user->display_name : '';
	$req           = get_option( 'require_name_email' );
	$aria_req      = ( $req ? " aria-required='true'" : '' );
	$html_req      = ( $req ? " required='required'" : '' );
	$html5         = current_theme_supports( 'html5', 'comment-form' ) ? 'html5' : false;

	$fields = [
		'author'        => '<div class="contact-form"><input id="author" name="author" class="comnt_input" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" maxlength="245"' . $aria_req . $html_req . ' placeholder="Name*"/>',
		'company'       => '<input id="url" class="comnt_input" name="company" ' . ( $html5 ? 'type="url"' : 'type="text"' ) . ' value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" maxlength="200" required="required"  placeholder="Company*"/>',
		'email'         => '<input id="email" class="comnt_input" name="email" ' . ( $html5 ? 'type="email"' : 'type="text"' ) . ' value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30" maxlength="100" aria-describedby="email-notes"' . $aria_req . $html_req . ' placeholder="Email*"/>',
		'comment_field' => '<textarea id="comment" class="comnt_input" name="comment" cols="10" rows="2" maxlength="65525" aria-required="true" placeholder="Write Your Comment"></textarea></div>',
	];

	return $fields;
}

add_filter( 'comment_form_default_fields', 'wpse250243_comment_form_default_fields' );

function wpse250243_comment_form_defaults( $defaults ) {
	if ( isset( $defaults['comment_field'] ) ) {
		$defaults['comment_field'] = '';
	}

	return $defaults;
}

add_filter( 'comment_form_defaults', 'wpse250243_comment_form_defaults', 10, 1 );
add_filter( 'big_image_size_threshold', '__return_false' );

if ( ! is_admin() ) {
	function wpb_search_filter( $query ) {
		if ( @$_GET['global'] != 'true' ) {
			if ( $query->is_search ) {
				$query->set( 'post_type', 'post' );
			}

			return $query;
		}

	}

	add_filter( 'pre_get_posts', 'wpb_search_filter' );
}

function wp_get_menu_array( $current_menu ) {
	$array_menu = wp_get_nav_menu_items( $current_menu );
	$menu       = array();
	foreach ( $array_menu as $m ) {
		if ( empty( $m->menu_item_parent ) ) {
			$menu[ $m->ID ]             = array();
			$menu[ $m->ID ]['ID']       = $m->ID;
			$menu[ $m->ID ]['title']    = $m->title;
			$menu[ $m->ID ]['url']      = $m->url;
			$menu[ $m->ID ]['children'] = array();
		}
	}
	$submenu = array();
	foreach ( $array_menu as $m ) {
		if ( $m->menu_item_parent ) {
			$submenu[ $m->ID ]                                  = array();
			$submenu[ $m->ID ]['ID']                            = $m->ID;
			$submenu[ $m->ID ]['title']                         = $m->title;
			$submenu[ $m->ID ]['url']                           = $m->url;
			$menu[ $m->menu_item_parent ]['children'][ $m->ID ] = $submenu[ $m->ID ];
		}
	}

	return $menu;
}

function aakash_check_active_menu( $menu_item ) {
	$actual_link = ( isset( $_SERVER['HTTPS'] ) ? "https" : "http" ) . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	if ( $actual_link == $menu_item['url'] ) {
		return 'active1';
	}

	return '';
}

function ac_render( $slug, $name = null, $variablesArray = [] ) {

	do_action( "get_template_part_{$slug}", $slug, $name );

	$templates = array();
	$name      = (string) $name;
	if ( '' !== $name ) {
		$templates[] = "{$slug}-{$name}.php";
	}
	$templates[] = "{$slug}.php";
	$template    = \locate_template( $templates, false, false );

	if ( empty( $template ) ) {
		return;
	}
	global $posts, $post, $wp_did_header, $wp_query, $wp_rewrite, $wpdb, $wp_version, $wp, $id, $comment, $user_ID;

	if ( is_array( $wp_query->query_vars ) ) {
		\extract( $wp_query->query_vars, EXTR_SKIP );
	}

	if ( isset( $s ) ) {
		$s = \esc_attr( $s );
	}

	foreach ( $variablesArray as $variableName => $value ) {
		if ( ! isVariableNameValid( $variableName ) ) {
			trigger_error( 'Variable names must be valid. Skipping "' . $variableName . '" because it is not a valid variable name.' );
			continue;
		}

		if ( isset( $$variableName ) ) {
			trigger_error( "$variableName already existed, probably set by WordPress, so it wasn't set to $value like you wanted. Instead it is set to: " . print_r( $$variableName, true ) );
			continue;
		}
		$$variableName = $value;
	}

	require $template;
}

function isVariableNameValid( $variableName ) {
	if ( preg_match( '/^[a-zA-Z_][a-zA-Z0-9_\x7f-\xff]*/', $variableName ) ) {
		return true;
	}

	return false;
}

@ini_set( 'upload_max_size', '64M' );
@ini_set( 'post_max_size', '64M' );
@ini_set( 'max_execution_time', '300' );
?>