<?php
//Header for the website
$alt_footer   = get_field( 'alt_header_and_footer' );
$themeData    = get_fields( 'options' );
$current_page = get_queried_object();

/*echo '<pre style="height: 600px">';
print_r($themeData);
echo '</pre>';*/
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Google Tag Manager -->
    <script>(function (w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start':
                    new Date().getTime(), event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s), dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', 'GTM-NZGGQ4H');</script>
    <!-- End Google Tag Manager -->

	<?php wp_head(); ?>
    <!-- Google Tag Manager -->


    <!-- Aakash started here -->
    <title><?php wp_title(); ?></title>
    <meta charset="utf-8">
    <!-- <meta name="viewport" content="width=device-width, initial-scale=1"> -->
    <meta name="google-site-verification" content="moSKz5BST9KQ79mLhu_rSQzCv4kiOlqHRv71F3gPU5I"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <link rel="icon" href=<?php echo get_template_directory_uri() . "/images/logo/favicon.png"; ?> type="image/x-icon"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link href="https://fonts.googleapis.com/css?family=Roboto:100,300,400,500,700,900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href=<?php echo get_template_directory_uri() . "/css/bootstrap.min.css"; ?>>
    <link rel="stylesheet" href=<?php echo get_template_directory_uri() . "/css/magnific-popup.min.css"; ?>>
    <link rel="stylesheet" href=<?php echo get_template_directory_uri() . "/css/style.css"; ?>>
    <link rel="stylesheet" href=<?php echo get_template_directory_uri() . "/css/landing.css"; ?>>
    <link rel="stylesheet" href=<?php echo get_template_directory_uri() . "/css/responsive.css"; ?>>
    <link rel="stylesheet" href=<?php echo get_template_directory_uri() . "/css/animate.css"; ?>>
    <link rel="stylesheet" href= <?php echo get_template_directory_uri() . "/css/form.css"; ?>>

	<?php
	if ( $current_page->post_title == 'Adworld' ):
		?>
        <link rel="stylesheet" href=<?php echo get_template_directory_uri() . "/css/landing-adworld.css"; ?>>
	<?php
	endif;
	?>
    <!-- owl core CSS -->
    <link rel="stylesheet"
          href=<?php echo get_template_directory_uri() . "/owlcarousel/assets/owl.carousel.min.css"; ?>>
    <link rel="stylesheet"
          href=<?php echo get_template_directory_uri() . "/owlcarousel/assets/owl.theme.default.min.css"; ?>>


    <script>
        !function () {
            var analytics = window.analytics = window.analytics || [];
            if (!analytics.initialize) if (analytics.invoked) window.console && console.error && console.error("Segment snippet included twice."); else {
                analytics.invoked = !0;
                analytics.methods = ["trackSubmit", "trackClick", "trackLink", "trackForm", "pageview", "identify", "reset", "group", "track", "ready", "alias", "debug", "page", "once", "off", "on", "addSourceMiddleware", "addDestinationMiddleware"];
                analytics.factory = function (e) {
                    return function () {
                        var t = Array.prototype.slice.call(arguments);
                        t.unshift(e);
                        analytics.push(t);
                        return analytics
                    }
                };
                for (var e = 0; e < analytics.methods.length; e++) {
                    var t = analytics.methods[e];
                    analytics[t] = analytics.factory(t)
                }
                analytics.load = function (e, t) {
                    var n = document.createElement("script");
                    n.type = "text/javascript";
                    n.async = !0;
                    n.src = "https://cdn.segment.com/analytics.js/v1/" + e + "/analytics.min.js";
                    var a = document.getElementsByTagName("script")[0];
                    a.parentNode.insertBefore(n, a);
                    analytics._loadOptions = t
                };
                analytics.SNIPPET_VERSION = "4.1.0";
                analytics.load("Xz6aMOyHmqqQM2sBv476DmZtEFSjnTaX");
                analytics.page();
            }
        }();
    </script>
    <script>
        (function () {
            var zi = document.createElement('script');
            zi.type = 'text/javascript';
            zi.async = true;
            zi.referrerPolicy = 'unsafe-url';
            zi.src = 'https://ws.zoominfo.com/pixel/615d603839247c001cc34064';
            var s = document.getElementsByTagName('script')[0];
            s.parentNode.insertBefore(zi, s);
        })();
    </script>
</head>
<body <?php body_class(); ?>>
<!-- Google Tag Manager (noscript) -->
<noscript>
    <iframe src="https://www.googletagmanager.com/ns.html?id=GTM-NZGGQ4H"
            height="0" width="0" style="display:none;visibility:hidden"></iframe>
</noscript>
<!-- End Google Tag Manager (noscript) -->
<div id="particles-js"></div>


<?php if ( is_page( 732 ) || is_page( 730 ) || is_page( 728 ) ) { ?>

    <div class="landing_header">
        <div class="conatiner">
            <a href="<?php echo site_url(); ?>">
				<?php $logoI = get_field( 'header_logo', 'options' ); ?>
                <img src="<?php echo $logoI['url']; ?>" alt="<?php echo $logoI['alt']; ?>">
            </a>
        </div>
    </div>
	<?php
} elseif ( $alt_footer ) {
	?>
    <!--Start, Header-->
    <header>
        <navbar class="navbar ">
            <div class="container">
                <a class="navbar-brand logo" href="<?php echo get_site_url(); ?>">
					<?php $logoI = get_field( 'header_logo', 'options' ); ?>
                    <img src="<?php echo $logoI['url']; ?>" alt="<?php echo $logoI['alt']; ?>">
                </a>
                <ul class="list-inline social-link mb-0">
					<?php
					$social_media = $themeData['landing_page_header']['social_media_links'];
					foreach ( $social_media as $value ):
						?>
                        <li class="list-inline-item">
                            <a href="<?php echo ! empty( $value['social_media_link'] ) ? $value['social_media_link'] : 'javascript:void(0)' ?>">
                                <i class="fa <?php echo isset( $value['social_media_icon'] ) ? $value['social_media_icon'] : '' ?>"></i>
                            </a>
                        </li>
					<?php
					endforeach;
					?>
                </ul>
            </div>
        </navbar>
    </header>
    <!--End, Header-->
<?php } else { ?>

    <!-- Header -->
    <header class="header">

        <nav class="navbar navbar-expand-lg navbar-light fixed-top main_nav landing_for">
            <div class="container">

                <a class="navbar-brand" href="<?php echo get_site_url(); ?>">
					<?php $logoI = get_field( 'header_logo', 'options' ); ?>
                    <img src="<?php echo $logoI['url']; ?>" alt="<?php echo $logoI['alt']; ?>">
                </a>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav"
                        aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarNav">
                    <!-- new code started here -->
					<?php
					$menu = 'Main Menu';

					$menu_items = wp_get_menu_array( $menu );
					?>
                    <ul class="navbar-nav ml-auto menu_link">
						<?php foreach ( $menu_items as $item ) {
							if ( isset( $item['title'] ) ) {
								?>
                                <li class="nav-item drop_hover <?php echo aakash_check_active_menu( $item ) ?>">
                                    <a href="<?= $item['url'] ?>" title="<?= $item['title'] ?>"
                                       class="nav-link"><?= $item['title'] ?> </a>
                                    <i class="fa fa-plus menu_toggle"></i>
									<?php if ( ! empty( $item['children'] ) ) { ?>
                                        <ul class="drop_menu">
											<?php foreach ( $item['children'] as $child ) {
												if ( array_key_exists( $child['ID'], $menu_items ) ) {
													$class = "submenu";
												} else {
													$class = "nav-item";
												}
												?>
                                                <li class="<?php echo $class; ?>"><a href="<?= $child['url'] ?>"
                                                                                     title="<?= $child['title'] ?>"><?= $child['title'] ?></a>
                                                </li>
											<?php } ?>
                                        </ul>
									<?php } ?>
                                </li>
							<?php }
						}
						?>

                        <!-- new coded ended here -->

                        <li class="nav-item" onclick="add_search()">
                            <a class="nav-link search_btn" href="javascript:void(0);">
                                <i class="fa fa-search"></i>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>

    </header>
    <!-- Header End --->

    <div class="sticky_button btn_options">
        <a href="<?php echo get_permalink( 185 ); ?>" class="btn btn-success btn_design">Let's Talk</a>
    </div>

    <!-- Search -->
    <div class="advance_search" id="search-btn">
        <div class="card">
            <form class="advance_form searchform" id="searchform" role="search" method="get"
                  action="<?php echo home_url( '/' ); ?>">
                <fieldset>
                    <input type="hidden" name="global" value="true">
                    <input class="form-control mr-2" id="s" type="text" name="s" placeholder="Search Here..."
                           value="<?php the_search_query(); ?>">
                    <div class="login-form-field-border"></div>
                    <button type="submit" id="searchsubmit"><i class="fa fa-search"></i></button>
                </fieldset>
            </form>
        </div>
        <span class="close_btn"><i class="fa fa-close"></i></span>
    </div>

<?php } ?>

<script>
    function add_search() {
        document.getElementById("search-btn").style.opacity = '1';
        document.getElementById("search-btn").style.transition = '0.5s all ease-out';
    }
</script>

<!-- Search End -->