<?php
/**
 * The template for displaying search results pages.
 *
 * @package WordPress
 * @subpackage Twenty_Fifteen
 * @since Twenty Fifteen 1.0
 */

get_header();
global $wp_query;
?>

<div class="site_wrap">

<section class="section search_value">
	<div class="container">
		<div class="search_vbx">
			<div class="section_head text-left">
				<h3 class="wow slideInLeft" data-wow-duration="2s" data-wow-delay="0.5" style="max-width: 100% !important;"><?php echo $wp_query->found_posts; ?> <?php _e( 'Search Results Found For', 'locale' ); ?>: "<?php the_search_query(); ?>"</h3>
			</div>
			<?php if (have_posts()): ?>
			<ul>
				<?php while ( have_posts() ) { the_post(); ?>
				<li>
					<div class="d-flex justify-content-start">
						<div class="img_bx mr-3">
							<?php if (has_post_thumbnail(get_the_ID())): ?>
								<?php the_post_thumbnail('medium') ?>
							<?php else: ?>
							<img src="<?php echo get_template_directory_uri().'/icons/photo.png';?>">
							<?php endif ?>
						</div>
						<div class="img_content">
							<a href="<?php echo get_permalink(); ?>" class="title"><strong><?php the_title();?></strong></a>
							<!-- <p class="des"><?php //echo (strlen(get_the_excerpt() > 200)) ? substr(get_the_excerpt(), 0, 200).'...' : ''; ?></p> -->
							<a href="<?php echo get_permalink(); ?>" class="read_btn">Read More</a>
						</div>
					</div>
				</li>
				<?php } ?>
			</ul>
			<?php endif ?>
			<div class="pagination">
				<?php echo paginate_links(); ?>
			</div>
		</div>
	</div>
</section>
</div>
<?php get_footer();?>
