<?php
$current_cat_id  = get_query_var('cat');
$current_tag_id = get_queried_object()->term_id;
global $wp;
$url = home_url( $wp->request );
$lastURI = explode('/',$url);
$urilast = $lastURI[4];

if($current_cat_id!=null) {
	$paged = (get_query_var('paged')) ? get_query_var('paged') : 0;
	$args = [
		'post_type' => 'post',
		'posts_per_page'=>8,
		'paged'=>$paged,
		'tax_query' => [
			[
				'taxonomy' => 'category',
				'terms' => $current_cat_id,
				'include_children' => false 
			],
		],
	];
	$blogsdata = get_posts($args);
	$count = count(get_posts($args));
} else {
$paged = (get_query_var('paged')) ? get_query_var('paged') : 0;
	$args = [
		'post_type' => 'post',
		'posts_per_page'=>8,
		'paged'=>$paged,
		'tax_query' => [
			'relation' => 'OR',
			[
				'taxonomy' => 'post_tag',
				'terms' => $current_tag_id,
				'include_children' => false 
			],
			[
				'taxonomy' => 'resource',
				'terms' => $current_tag_id,
				'include_children' => false
			]
		],
	];
	$args_c = [
		'post_type' => 'post',
		'posts_per_page'=>8,
		'paged'=>$paged,
		'tax_query' => [
			'relation' => 'OR',
			[
				'taxonomy' => 'post_tag',
				'terms' => $current_tag_id,
				'include_children' => false 
			],
			[
				'taxonomy' => 'resource',
				'terms' => $current_tag_id,
				'include_children' => false 
			]
		],
	];
	$blogsdata = get_posts($args_c);
	$count = count(get_posts($args));
}
?>
<style >
	@media screen and (max-width:990px) {
		.sidebar_panel {
    		padding-top: 30px !important;
		}
	}
	@media screen and (max-width:575px) {
		.column_left {
    		padding-right: 15px !important;
		}
		.column_right {
			padding-left: 15px !important;
		}
		.sidebar_panel {
			padding-top: 30px !important;
		}
	}
	.column_left {
    	padding-right: 30px;
	}
	.column_right {
    	padding-left: 30px;
	}
</style>
<div class="site_wrap">
	<section class="blog_listwrap">
		<h1>Our Best Practices</h1>
		<ul>
			<li><a href="<?php echo get_site_url()?>/resources" ><p>View All</p></a></li>
			<?php $maintypes = get_categories( ['taxonomy'=>'resource']);				
				foreach($maintypes as $maintypes) { ?>
					<a href="<?php echo get_category_link($maintypes->term_id);?>" class="<?php if($urilast==strtolower($maintypes->name)){echo "active_blog";}?>"><li><p><?php echo $maintypes->name?> </p></a></li>
			<?php } ?>
			<a href="<?php echo site_url().'/case-studies' ?>"><li><p>Case Studies</p></a></li>
		</ul>
	</section>
	<section class="section">
   		<div class="container">
	   		<div class="row">
		   		<div class="col-lg-8 col-md-12 col-sm-12 col-12 border-right column_left">
			   		<div class="row">
						<?php 
						if(!empty($blogsdata)){
						foreach ($blogsdata as $key => $value) { ?>
							<div class="col-lg-6 col-md-6 col-sm-12 col-12">
								<div class="news_box">
									<div class="news_img"> 
									<?php $data = wp_get_attachment_image_src( get_post_thumbnail_id( $value->ID ), 'single-post-thumbnail' ); ?>
										<a href="<?php echo site_url();?>/<?php echo $value->post_name;?>"><img class="img-fluid" src="<?php echo $data[0];?>"></a>
										<div class="news_date">
											<div class="date_box">
												<h2><span class="large"><?php echo date('d',strtotime($value->post_date));?></span><br><?php echo date('M',strtotime($value->post_date));?></h2>
											</div>
										</div>
									</div>
									<div class="news_detail">
										<h3><a href="<?php echo site_url();?>/<?php echo $value->post_name;?>" style="color:#000;"><?php echo strip_tags(@$value->post_title);?></a></h3>
										<p><?php echo substr(strip_tags($value->post_content), 0, 90);?>...</p>
										<a href="<?php echo site_url();?>/<?php echo $value->post_name;?>">Read More
										<i class="fa fa-arrow-right" aria-hidden="true"></i></a> 
									</div> 
								</div>
							</div>
						<?php } } ?>
						</div>
						<?php 
							echo "<div class='pagination' style='display:flex;justify-content:center;'>" . paginate_links(array(
								'total' => $wp_query->max_num_pages,
								'prev_text' => __('Previous'),
								'next_text' => __('Next')
							)) . "</div>";
						?>
		   			</div>
		   		<div class="col-lg-4 col-md-12 col-sm-12 col-12 column_right">
			   		<div class="sidebar_panel">
				   		<div class="panel_box search_wrap">
				   			<form id="searchid" class="side_search" method="get" action="<?php echo home_url('/'); ?>">
								<input type="text" id="search_input" class="search_input" name="s" placeholder="Search Blog..." value="<?php the_search_query(); ?>" required>
								<span><i  id="searchsubmit" class="fa fa-search"></i></span>
							</form>
				   		</div>
				   		<div class="panel_box subs_wrap">
					   		<div class="side_title">
						   		<h5>Newsletter</h5>
						   		<div class="border_side"></div>
					   		</div>
					   		<?php echo do_shortcode('[mc4wp_form id="369"]');?>
				   		</div>
				   		<div class="panel_box tags_wrap">
					   		<div class="side_title">
						   		<h5>Categories</h5>
						   		<div class="border_side"></div>
					   		</div>
					   		<div class="sidebar-item category">
						   		<div class="sidebar-info">
									<ul>
										<?php 
										$categories = get_categories();
										foreach($categories as $category) {
											echo '<li><a href="' . get_category_link($category->term_id) . '">' . $category->name . '<span class="categories_left">'.$category->category_count.'</span></a></li>';
										} ?>
									</ul>
						   		</div>
						 	</div>
				   		</div>
				   		<div class="panel_box tags_wrap">
					   		<div class="side_title">
						   		<h5>Tags</h5>
						   		<div class="border_side"></div>
					   		</div>
					   		<div class="sidebar-item tags">
						   		<div class="sidebar-info sidebar-info-scroll">
									<ul>
									<?php $tags = get_tags();
									$num_tags= count($tags);
									if($num_tags>0){
										foreach($tags as $k=>$val){ ?>
										<li><a href="<?php echo get_tag_link($val->term_id);?>"><?php echo $val->name;?></a></li>		
									<?php } } ?>						
									</ul>
						   		</div>
					   		</div>
				   		</div>					
			   		</div>
		   		</div>
	   		</div>					
   		</div>
	</section>
</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
<script>
jQuery(document).on('click','#searchsubmit',function(){
	var name=$('#search_input').val();
	var trimmedName = name.trim();
	if(trimmedName.length == 0){
		$("#search_input").prop('required',true);
	}
	else {
		jQuery('#searchid').submit();	
	}
})
</script>