<?php
    $author = get_user_by( 'slug', get_query_var( 'author_name' ) );
	$author_id = $author->ID;
	$args = array(
		'author'        =>  $author_id,
		'orderby'       =>  'post_date',
		'order'         =>  'ASC',
		'post_type'	=> 'post',
		'posts_per_page' => 8
	);
	
	
	 $authordata = get_posts($args);
?>

<style>
	.img_bx_info img {
	    border-radius: 10px;
	}
	.info_author h3{
		font-size: 1.313rem;
	    font-weight: 300;
	    line-height: 1.3;
	}
	.info_author h2{
		font-size: 2rem;
    	font-weight: 700;
    	padding-bottom: 5px;
		margin-bottom: 10px;
		position: relative;
	}
    .info_author h2::after {
    content: '';
    width: 200px;
    height: 2px;
    background: linear-gradient(45deg, rgba(38, 129, 180,1) 0%, rgba(62, 171, 77,1) 100%);
    position: absolute;
    bottom: -2px;
    left: 0px;
    }
	.info_author p{
		color: #77778d;
	    font-size: 14px;
	    line-height: 26px;
	    text-align: justify;
	}
	.read_more a{
		color: #41ad49;
    	font-size: 15px;
	}
	.blog_listwrap h3 {
    color: #fff;
    font-size: 36px;
    text-align: center;
    margin-bottom: 30px;
    text-transform: uppercase;
	}
</style>

<div class="site_wrap">

<section class="blog_listwrap">
	<h3><?php echo get_the_author_meta( 'display_name', $author_id)?></h3>
</section>

<section class="section">
	<div class="container">
		<div class="row align-items-center">
			<div class="col-lg-3 col-md-4 col-sm-12 col-12 mb-3  mb-4">
				<div class="img_bx_info ">
					<img src="<?php echo esc_url( get_avatar_url( $author_id ) ); ?>" class="img-fluid">
				</div>
			</div>
			<div class="col-lg-9 col-md-8 col-sm-12 col-12 mb-5">
				<div class="info_author ">
					<h2><?php echo get_the_author_meta( 'display_name', $author_id)?></h2>
					<h3>GrowthNatives Founder & CEO</h3>
					<p><?php echo get_the_author_meta( 'description', $author_id)?></p>
					<!-- <div class="read_more">
						<a href="javascript:void();" title="Read more">Read more
						<i class="fa fa-angle-double-right ml-2"></i>
					</a>
					</div> -->
				</div>
			</div>
			<div class="col-lg-12 col-md-12 col-sm-12 col-12">
				<div class="row">
				<!-- start here -->
				<?php
				   if(!empty($authordata)){
					   foreach ($authordata as $key => $value) {
						   ?>
							   <div class="col-lg-4 col-md-4 col-sm-12 col-12 ">
								   <div class="news_box">
									   <div class="news_img"> 
										   <?php 
											   $data = wp_get_attachment_image_src( get_post_thumbnail_id( $value->ID ), 'single-post-thumbnail' );
										   ?>
										   <a href="<?php echo site_url();?>/<?php echo $value->post_name;?>"><img class="img-fluid" src="<?php echo $data[0];?>"></a>
										   <div class="news_date">
										   <div class="date_box">
											   <h2><span class="large"><?php echo date('d',strtotime($value->post_date));?></span><br><?php echo date('M',strtotime($value->post_date));?></h2>
										   </div>
										   </div>
									   </div>
									    <div class="news_detail">
										   <h3><a href="<?php echo site_url();?>/<?php echo $value->post_name;?>" style="color:#000;"><?php echo strip_tags(@$value->post_title);?></a></h3>
										  <p><?php echo substr(strip_tags($value->post_content), 0, 90);?>...</p>
										    <a href="<?php echo site_url();?>/<?php echo $value->post_name;?>">Read More
											<i class="fa fa-arrow-right" aria-hidden="true"></i></a> 
									   </div> 
								   </div>
							   </div>
						   <?php } } ?>
			   </div>
			   <?php 
						echo "<div class='pagination' style='display:flex;justify-content:center;'>" . paginate_links(array(
							'total' => $wp_query->max_num_pages,
							'prev_text' => __('Previous'),
							'next_text' => __('Next')
						)) . "</div>";
				?>
				<!-- end here -->
				</div>
			</div>					
	</div>
</section>
</div>