<?php 
/* Component Created to Display section with Image Cards 

@params $backgroundImage - contains the information of the image uploaded
@params $cards - Contains array of cards

Usage: 

ac_render( 'template-parts/Components/Section/with','Cards');

*/  
?>
<?php if(!empty($cards)): ?>
<section class="section result revenue-section" style="background-image:url('<?php echo $backgroundImage['url'] ?? '';?>')">
	<div class="container">
		<div class="row">
			<?php foreach($cards as $card => $value): ?>
				<?php if(is_array($value['image'])): ?>
				<div class="col-lg-4 col-md-12 text-center pt-4">
					<a href="#<?php echo $value['target_id'] ?? ''; ?>">
						<div class="three_box_content wow slideInLeft" >
							<img src="<?php echo esc_html($value['image']['url'] ?? '') ?>" alt="<?php echo esc_html($value['image']['alt'] ?? '') ?>" title="<?php echo esc_html($value['image']['title'] ?? '') ?>">
							<h4 class="text-white"><?php echo esc_html($value['text'] ?? ''); ?></h4>
						</div>
					</a>
				</div>
				<?php endif; ?>
			<?php endforeach; ?>
		</div>
	</div>
</section>
<?php endif; ?>