<?php 
/* Component Created to Display Header section with background Image 

@params $backgroundImage - contains the information of the image uploaded
@params $heading - Contains heading of the banner
@params $subHeading - Contains Sub heading in the banner
@params $carousal - Array Of Images to be used in carousal
@params $listPoints - Array Of Points to be used in Section

Usage: 

ac_render( 'template-parts/Components/Section/with','Carousal');

*/  
?>
<?php if(!empty($heading) && !empty($subHeading)): ?>
<section class="section slider-section" style="background-image:url('<?php echo $backgroundImage['url'] ?? '';?>')">
	<div class="container">
		<div class="row">
		<div class="col-lg-12 col-md-12 col-sm-12 col-12">
				<div class="d-slider-nov slider-right">
					<h3><?php echo esc_html($heading ?? '');?></h3>
					<p class="pt-3 pb-2"><?php echo esc_html($subHeading ?? '');?></p>
					<?php if(!empty($listPoints)): ?>
					<ul>
						<?php foreach($listPoints as $points => $value): ?>
							<li><?php echo esc_html($value['point'] ?? '') ?></li>
						<?php endforeach; ?>
					</ul>
					<?php endif; ?>
				</div>
			</div>
			<div class="col-lg-12 col-md-12 col-sm-12 col-12">
				<div class="left-image pb-4">
					<?php if(!empty($carousal)): $i=0; ?>
					<div class="owl-carousel owl-theme" id="matrix-slider">
						<?php foreach ($carousal as $images => $image):?>
						<?php if(is_array($image['image'])): ?>
							<div class="item <?php ($i%2==0) ? 'black' : '' ?>"><img src="<?php echo esc_html($image['image']['url'] ?? '')?>" alt="<?php echo esc_html($image['image']['alt'] ?? '')?>" title="<?php echo esc_html($image['image']['title'] ?? '')?>"></div>
						<?php endif; ?>
						<?php endforeach; ?>
					</div>
					<?php endif; ?>
				</div>
			</div>
			
		</div>
	</div>
</section>
<?php endif; ?>