<?php 
/* Component Created to Display Header section with background Image 

@params $sectionRepeaters - Array of Elements used to make a section

Usage: 

ac_render( 'template-parts/Components/Section/with','HeadingImage');

*/  
?>
<?php if(!empty($sectionRepeaters)): ?>
	<?php foreach($sectionRepeaters as $sections => $section): ?>
		<section class="section <?php echo ($section['color']=="Black") ? ' bg-black' : '' ;?>" id="<?php echo $section['target'] ?? ''; ?>">
			<div class="container">
				<div class="row">
					<div class="col-md-12">
						<div class="revenue-div">
							<h3><?php echo esc_html($section['heading'] ?? '' ); ?></h3>
							<p class="pt-3 pb-4"><?php echo wp_kses($section['description'] ?? '', array('br'=>true)); ?></p>
						</div>
						<?php if(is_array($section['image'])): ?>
						<div class="main-image-sec ">
							<img src="<?php echo esc_html($section['image']['url'] ?? '' ); ?>" alt="<?php echo esc_html($section['image']['alt'] ?? '' ); ?>">
						</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</section>
	<?php endforeach; ?>
<?php endif; ?>