<?php
/* Template Name: Blogs */
get_header();
?>
    <div class="site_wrap resources">
        <section class="blog_listwrap">
            <div class="container h-100">
                <div class="row align-items-center h-100">
                    <div class="col-md-6 col-12 order-md-1 order-0">
                        <div class="resources-banner-image">
                            <?php
                            $banner_image = get_field('banner_image')
                            ?>
                            <img src="<?php echo $banner_image['url'] ?>" alt="<?php echo $banner_image['alt'] ?>">
                        </div>
                    </div>
                    <div class="col-md-6 col-12">
                        <div class="resources-banner-text">
                            <h1><?php the_field('banner_heading') ?></h1>
                            <?php
                            the_field('banner_description');
                            ?>
                        </div>
                    </div>
                </div>
                <div class="blogs-links">
                    <ul class="blogs-links-ul">
                        <li><a href="<?php echo get_site_url() . '/resources' ?>" class="active_blog">All</a></li>
                        <?php
                        $maintypes = get_categories(['taxonomy' => 'resource']);
                        foreach ($maintypes as $maintype) { ?>
                            <li><a href="<?php echo get_category_link($maintype->term_id); ?>">
                                    <?php echo $maintype->name ?>
                                </a></li>
                        <?php } ?>
                        <li><a href="<?php echo site_url() . '/case-studies' ?>">Case Studies</a></li>
                    </ul>
                    <div class="blogs-search">
                        <form class="searchbox" method="get" action="<?php echo home_url('/'); ?>"
                              data-hs-cf-bound="true" id="searchbox_blog">
                            <input type="search" placeholder="Search......" name="s" class="searchbox-input"
                                   onkeyup="buttonUp();" value="<?php the_search_query(); ?>" required>

                            <input type="submit" class="searchbox-submit" value="GO">
                            <span class="searchbox-icon">
                                <i class="fa fa-search"></i></span>
                        </form>
                        <div class="dropdown-list filter-dropdown-list">
                            <button class="dropdown-toggle-list" type="button">
                                Filter By Category <i class="fa fa-chevron-down" aria-hidden="true"></i>
                            </button>
                            <ul class="dropdown-menu-list">
                                <?php
                                $categories = get_terms(array('taxonomy' => 'category', 'hide_empty' => true));
                                foreach ($categories as $category):
                                    ?>
                                    <li>
                                        <a class="dropdown-item"
                                           href="<?php echo get_category_link($category->term_id); ?>">
                                            <?php echo $category->name ?>
                                        </a>
                                    </li>
                                <?php
                                endforeach;
                                ?>
                            </ul>
                        </div>
                        <div class="dropdown-list menu-dropdown-list">
                            <button class="dropdown-toggle-list" type="button">
                                All <i class="fa fa-chevron-down" aria-hidden="true"></i>
                            </button>
                            <ul class="dropdown-menu-list">
                                <li><a href="<?php echo get_site_url() . '/resources' ?>">All</a></li>
                                <?php
                                foreach ($maintypes as $maintype) : ?>
                                    <li>
                                        <a href="<?php echo get_category_link($maintype->term_id); ?>">
                                            <?php echo $maintype->name ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                                <li><a href="<?php echo site_url() . '/case-studies' ?>">Case Studies</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php
        $paged = (get_query_var('paged')) ? get_query_var('paged') : 0;
        $countpost = get_posts(['posts_per_page' => -1]);
        $blogsdata = get_posts(['posts_per_page' => 6, 'paged' => $paged]);
       /* echo "<pre style='height: 600px'>";
        echo get_the_author_meta('display_name', 22);
        print_r($blogsdata);
        echo "</pre>";*/

        $featured = get_posts(['posts_per_page' => 1,]);
        ?>
        <section class="section resources-section">
            <div class="container">
                <!-- start feature post -->
                <div class="heading ">
                    <h2 class="section-heading">Featured Knowledge Bites</h2>
                </div>
                <?php
                foreach ($featured as $key => $value):
                    $imageId = get_post_thumbnail_id($value->ID);
                    $imageTitle = get_post_meta($imageId, '_wp_attachment_image_alt', TRUE);
                    $postCategory = get_the_category($value->ID);
                    ?>
                    <div class="feature-blogs">
                        <div class="feature-blog-image">
                            <?php
                            $data = wp_get_attachment_image_src(get_post_thumbnail_id($value->ID), 'single-post-thumbnail');
                            ?>
                            <a href="<?php echo site_url(); ?>/<?php echo $value->post_name; ?>">
                                <img src="<?php echo $data[0]; ?>"
                                     alt="<?php echo $imageTitle; ?>">
                            </a>
                        </div>
                        <div class="feature-blog-content">
                            <h4>
                                <a href="<?php echo site_url(); ?>/<?php echo $value->post_name; ?>">
                                    <?php echo str_replace(['<strong>', '</strong>'], '', @$value->post_title); ?>
                                </a>
                            </h4>
                            <ul class="entry-meta-tag">
                                <?php
                                foreach ($postCategory as $category):
                                    ?>
                                    <li>
                                        <a href="<?php echo get_category_link($category->term_id); ?>"><?php echo $category->name ?></a>
                                    </li>
                                <?php
                                endforeach;
                                ?>
                            </ul>
                            <p><?php echo substr(strip_tags($value->post_content), 0, 90); ?>...</p>
                            <h6><?php echo get_the_author_meta('display_name', $value->post_author); ?></h6>
                            <ul class="entry-meta">
                                <li><?php echo date('F d , Y', strtotime($value->post_date)); ?></li>
                            </ul>
                        </div>
                    </div>
                <?php
                endforeach;
                ?>
                <!-- end feature post -->
                <!-- start resources post -->
                <div class="heading">
                    <h2 class="section-heading">More Articles</h2>
                </div>
                <div class="row align-items-stretch">
                    <?php if (!empty($blogsdata)) {
                        foreach ($blogsdata as $key => $value) {
                            $imageId = get_post_thumbnail_id($value->ID);
                            $imageTitle = get_post_meta($imageId, '_wp_attachment_image_alt', TRUE);
//                            $postTags = get_the_tags($value->ID);
                            $postCategory = get_the_category($value->ID);
                            ?>
                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                <div class="news_box">
                                    <div class="news_img">
                                        <?php
                                        $data = wp_get_attachment_image_src(get_post_thumbnail_id($value->ID), 'single-post-thumbnail');
                                        ?>
                                        <a href="<?php echo site_url(); ?>/<?php echo $value->post_name; ?>">
                                            <img class="img-fluid" src="<?php echo $data[0]; ?>"
                                                 alt="<?php echo $imageTitle; ?>">
                                        </a>
                                        <!-- <div class="news_date">
									<div class="date_box">
										<h2><span class="large"><?php //echo date('d',strtotime($value->post_date));?></span><br><?php //echo date('M',strtotime($value->post_date));?></h2>
									</div>
								</div> -->
                                    </div>
                                    <div class="news_detail">
                                        <h3><a href="<?php echo site_url(); ?>/<?php echo $value->post_name; ?>"
                                               style="color:#000;"><?php echo str_replace(['<strong>', '</strong>'], '', @$value->post_title); ?></a>
                                        </h3>

                                        <ul class="entry-meta-tag">
                                            <?php
                                            foreach ($postCategory as $category):
                                                ?>
                                                <li>
                                                    <a href="<?php echo get_category_link($category->term_id); ?>"><?php echo $category->name ?></a>
                                                </li>
                                            <?php
                                            endforeach;
                                            ?>
                                        </ul>
                                        <p><?php echo substr(strip_tags($value->post_content), 0, 90); ?>...</p>

                                    </div>
                                    <div class="blog-meta-detail">
                                        <h6><?php echo get_the_author_meta('display_name', $value->post_author); ?></h6>

                                        <ul class="entry-meta">
                                            <li><?php echo date('F d , Y', strtotime($value->post_date)); ?></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        <?php }
                    } ?>
                </div>
                <!-- end resources post -->
                <div class="load-more-button">
                    <a href="<?php echo get_site_url() ?>/resource/blogs" class="btn-load-more">View all</a>
                </div>
            </div>
        </section>
        <section class="free-audit-section">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-10 col-md-9 col-sm-8 col-12">
                        <h4><?php the_field('scale_brand_heading'); ?></h4>
                        <!--                        <p>--><?php //the_field('scale_brand_subheading'); ?><!--</p>-->
                    </div>
                    <div class="col-lg-2 col-md-3 col-sm-4 col-12">
                        <?php
                        $button = get_field('scale_brand_button')
                        ?>
                        <a href="<?php echo !empty($button['button_link']) ? $button['button_link']['url'] : 'javascript:void(0)' ?>"
                           class="btn-outline-button btn-white"><?php echo $button['button_name'] ?></a>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <!-- <script>
    jQuery(document).on('click','#searchsubmit',function(){
        var name=$('#search_input').val();
        var trimmedName = name.trim();
        if(trimmedName.length == 0) {
            $("#search_input").prop('required',true);
        }
        else {
            jQuery('#searchid').submit();
        }
    })
    </script> -->
    <script>
        $(document).ready(function () {
            var submitIcon = $('#searchbox_blog .searchbox-icon');
            var inputBox = $('#searchbox_blog .searchbox-input');
            var searchBox = $('#searchbox_blog');
            var isOpen = false;
            submitIcon.click(function () {
                if (isOpen == false) {
                    searchBox.addClass('searchbox-open');
                    inputBox.focus();
                    isOpen = true;
                } else {
                    /*searchBox.removeClass('searchbox-open');
                    inputBox.focusout();
                    isOpen = false;*/
                    if (inputBox.val().length !== 0) {
                        searchBox.submit();
                    }
                }
            });
            submitIcon.mouseup(function () {
                return false;
            });
            searchBox.mouseup(function () {
                return false;
            });
            $(document).mouseup(function () {
                if (isOpen == true) {
                    $('#searchbox_blog .searchbox-icon').css('display', 'block');
                    submitIcon.click();
                }
            });
        });

        function buttonUp() {
            var inputVal = $('#searchbox_blog .searchbox-input').val();
            inputVal = $.trim(inputVal).length;
            if (inputVal !== 0) {
                $('#searchbox_blog .searchbox-icon').css('display', 'none');
            } else {
                $('#searchbox_blog .searchbox-input').val('');
                $('#searchbox_blog .searchbox-icon').css('display', 'block');
            }
        }

    </script>
<?php get_footer(); ?>