<?php
/*
Template Name: Digital Marketing LP
*/
get_header();
?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
      integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
<style>
    /**************************** Google fonts import ****************************/
    @import url('https://fonts.googleapis.com/css2?family=Roboto&display=swap');
    @import url('https://fonts.googleapis.com/css2?family=Roboto+Condensed&display=swap');


    body,
    html {
        margin-top: 0;
        padding: 0 !important;
        width: 100%;
        height: 100%;
        font-family: 'Roboto', sans-serif;
    }

    h1 {
        font-size: 44px;
        margin: 0;
    }

    h2 {
        font-size: 34px;
        margin: 0;
    }

    h3 {
        font-size: 30px;
        margin: 0;
    }

    h4 {
        font-size: 28px;
        margin: 0;
    }

    h5 {
        font-size: 20px;
        margin: 0;
    }

    h6 {
        font-size: 18px;
        margin: 0;
    }

    p {
        font-size: 18px;
        margin: 0;
    }

    ul {
        padding: 0;
        margin: 0;
    }

    li {
        font-size: 18px;
        list-style: none;
    }

    a {
        font-size: 18px;
    }

    .header:first-of-type {
        display: none;
    }

    /* color-css starts */

    .blue-btn, .white-btn, .grey-btn {
        padding: 0;
        border: none;
        margin: 100px auto 0;
        display: flex;
        background: none;
        align-items: center;
        justify-content: center;
        width: auto;
    }

    .blue-btn a, .white-btn a {
        text-decoration: none;
        font-size: 18px;
        border: 2px solid #fff;
        border-radius: 26px;
        padding: 10px 30px;
        color: #fff;
        font-weight: 500;
        transition: 0.3s all;
        display: block;
    }

    .grey-btn a {
        text-decoration: none;
        font-size: 18px;
        border: 2px solid #7B7B7B;
        border-radius: 26px;
        padding: 10px 30px;
        color: #7B7B7B;
        font-weight: 500;
        transition: 0.3s all;
    }

    .grey-btn:hover a {
        background: #7B7B7B;
        border-color: #7B7B7B;
        transition: 0.3s all;
        color: #fff;
    }

    .blue-btn:hover a {
        background: #007EBF;
        border-color: #007EBF;
        transition: 0.3s all;
    }

    .white-btn:hover a {
        color: #1E1E20;
        background: #fff;
        border-color: #fff;
        transition: 0.3s all;
    }

    .blue-green-gradient {
        background: -webkit-linear-gradient(#007ebf, #41ad49);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }

    .color-white {
        color: #fff;
    }

    .color-dark-grey {
        color: #1E1E1E;
    }

    .color-light-grey {
        color: #C7C7C7;
    }

    .color-grey {
        color: #6E6E6E;
    }

    .color-blue {
        color: #007EBF;
    }

    .color-black {
        color: #000;
    }

    .bg-black {
        background-color: #000;
    }

    .bg-grey {
        background: #1E1E1E;
    }

    .bg-light-grey {
        color: #1e1e1e7d;
    }

    .bg-white {
        color: #fff;
    }


    .heading {
        font-weight: 700;
        text-align: center;
        margin: 0 0 30px 0;
    }

    .paragraph {
        font-weight: 400;
        margin: 0 0 50px 0;
        text-align: center;
    }

    .bg-black {
        color: #000;
    }

    .spacing {
        padding: 100px 0;
    }

    .heading-margin {
        font-weight: 700;
        text-align: center;
        margin: 0 0 50px;
    }

    .max-content {
        max-width: 85%;
        width: 100%;
        margin: 0 auto 50px;
    }

    /*header starts*/
    /*   .header ul {
           display: flex;
           align-items: center;
           justify-content: unset;
       }

       .header ul li:not(:last-child) {
           padding: 0 50px 0 0;
       }

       .header ul li a {
           font-size: 25px;
       }*/

    /*header ends */


    /*    banner starts */
    .inner-banner {
        position: relative;
        height: auto;
        padding: 220px 0 100px 0;
    }

    .inner-banner .container {
        position: relative;
    }

    .inner-banner-content h1 {
        font-weight: 700;
    }


    .inner-banner-description p {
        padding: 30px 0 50px;
        font-size: 22px;
        width: 77%;
    }

    .inner-banner .row {
        padding: 0;
        align-items: start;
    }


    .inner-banner-description h3 {
        width: 570px;
    }

    .inner-list {
        padding: 30px 0 0 0;
    }

    .inner-list li {
        font-size: 22px;
        position: relative;
        padding: 0 0 15px 20px;
    }

    .inner-list li:last-child {
        padding-bottom: 0;
    }

    .inner-list li:before {
        content: '\f101';
        position: absolute;
        top: 0;
        left: 0;
        font-size: 20px;
        color: #007EBF;
        font-family: FontAwesome;
    }

    .inner-img {
        padding-top: 50px;
        width: 180px;
    }

    .inner-img:nth-of-type(2n) {
        width: 120px;
    }

    .inner-img img {
        width: 100%;
    }

    ul.banner-bottom-content {
        display: flex;
        align-items: center;
        justify-content: space-between;
        position: absolute;
        bottom: 0;
        width: 100%;
        left: 0;
    }

    .banner-logo-img {
        align-items: center;
        display: flex;
        justify-content: start;
    }

    .banner-logo-img .inner-img:first-child {
        padding: 50px 0px 0 0;
        margin: 0 50px 0 0;
    }

    .sticky_button .btn_design {
        display: none;
    }

    .salesforce-form {
        background: #1d1d1d;
        border-radius: 20px;
        box-shadow: 0px 10px 70px #000000;
    }

    .salesforce-form h4 {
        background-color: #000;
        border-top-left-radius: 20px;
        border-top-right-radius: 20px;
        text-align: center;
        padding: 30px 35px;
    }

    .salesforce-form .hbspt-form {
        padding: 20px 30px 50px;
    }

    .study-content.bg-grey {
        padding: 70px 80px 70px 50px;
        max-height: 100%;
        height: 100%;
        border-radius: 6px;
    }

    /*    banner ends */

    /*process starts*/

    .process .process-card .card {
        height: 100%;
        max-height: initial;
        max-width: 380px;
        background-color: transparent;
        width: 100%;
        margin: auto;
        padding: 0 0 30px 0;
        text-align: center;
    }

    .process .row .col-md-4.col-12:last-child .card, .process .row .col-md-4.col-12:nth-last-child(2) .card,
    .process .row .col-md-4.col-12:nth-last-child(3) .card {
        padding: 0;
    }

    .process-card .card-img {
        width: 200px;
        margin: auto;
    }

    .process-card .card-body {
        padding: 0;
    }

    .process-card .card-img img {
        width: 100%;
    }

    .process .process-card .card h4 {
        width: 100%;
        margin: auto;
        text-transform: capitalize;
        font-weight: 700;
    }

    /* process ends */

    /* yr text  */
    .yr-text {
        text-align: center;
    }

    .yr-text h3 {
        font-size: 60px;
        margin: 0 0 20px 0;
        font-weight: 700;
    }

    .yr-text h4 {
        font-weight: 400;
    }


    /*case study starts*/
    .study-content h3 {
        text-align: left;
        font-weight: 500;
    }

    .study-content p {
        text-align: left;
        font-weight: 400;

    }

    .case-study .row {
        padding: 0;
        justify-content: space-between;
        align-items: stretch;
    }

    .case-study .study-content .blue-btn {
        margin: 0;
        justify-content: start;
        width: auto;
        display: inline-block;
    }


    .study-img {
        width: auto;
        padding: 0 10px 0 0;
    }

    .case-study .row .col-md-5.col-12 {
        padding: 0 15px 0 0;
    }

    .case-study .row .col-md-7.col-12 {
        padding: 0 0 0 15px;
    }


    .study-img img {
        width: 100%;
    }

    /*case study ends*/
    /*bottom bar starts*/
    .bottom-bar {
        padding: 20px 0;
        border: 1px solid #1E1E20;
    }

    .bottom-bar ul {
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .bottom-bar ul li {
        padding: 0 30px;
    }

    .bottom-bar ul li:not(:last-child) {

        border-right: 1px solid #1E1E20;
    }

    .bottom-bar ul li a {
        padding: 7px 25px 6px 25px;
        text-decoration: none;
        font-size: 14px;
    }

    .bottom-bar ul li a:hover {
        background: -webkit-linear-gradient(#007ebf, #41ad49);
        -webkit-background-clip: text;
        transition: all 0.5s;
        -webkit-text-fill-color: transparent;
    }

    .copyright {
        padding: 15px 0;
    }

    .copyright p {
        font-size: 14px;
    }

    .copyright ul {
        text-align: right;
        margin-bottom: 0;
        padding: 0;
    }

    .copyright ul li {
        list-style: none;
        display: inline-block;
        font-size: 15px;
        margin-right: 12px;
    }

    /*bottom bar ends*/


    .growth-card .card {
        background: #1E1E20;
        justify-content: center;
        height: 100%;
        align-items: center;
        min-height: 300px;
        padding: 20px 30px;
        max-height: 350px;
        transition: all 0.5s;
        border: unset;
        border-radius: 6px;
    }

    .growth-card .card-img {
        width: 102px;
        height: 102px;
        margin: 0 0 30px;
    }

    .growth-card .card-img img {
        width: 100%;
        height: 100%;
        object-fit: contain;
    }

    .growth-card .card-body {
        flex: unset;
        padding: 0;
    }

    .growth-hacking h5 {
        text-align: center;
        line-height: 1.8;
    }

    .growth-hacking .row .col-md-4.col-12:not(:last-child) {
        margin: 0px 0px 50px;

    }

    .growth-hacking .row .col-md-4.col-12 {
        padding: 0 20px;

    }

    .growth-hacking .row .col-md-4.col-12:nth-last-child(2), .growth-hacking .row .col-md-4.col-12:nth-last-child(3) {
        margin: 0;
    }


    .happy-client {
        position: relative;
    }

    .happy-client .container {
        position: relative;
    }

    .quote-img {
        position: absolute;
        top: 5%;
        right: 0;
    }

    .quote-img svg {
        width: 83px;
        margin: 0 26px 0 0;
    }

    .happy-client-carousel {
        margin: 0 auto;
        max-width: 100%;
        width: 100%;
        padding-top: 70px;
    }

    .happy-client-carousel .owl-carousel {
        display: block;
        width: 100%;
        z-index: 1;
    }

    .happy-client-carousel .item {
        margin: 0px;
        overflow: hidden;
        background: #1E1E20 0% 0% no-repeat padding-box;
        border-radius: 10px;
    }

    .happy-client .happy-client-carousel .row {
        padding-left: 0;
        border-radius: 20px;
        margin: 16px;
        box-shadow: 0 3px 19px 3px #000000;
    }

    .happy-client-carousel .item .row .col-md-4, .happy-client-carousel .item .row .col-md-8 {
        padding: 0;
    }

    .client-play-button {
        position: relative;
        height: 100%;
    }

    .client-img {
        width: auto;
        overflow: hidden;
        border-radius: 8px;
        height: 100%;
    }

    .client-img img {
        position: relative;
        object-fit: cover;
        height: 100%;
        width: 100%;
        transition: 0.5s all ease-in-out;
    }

    .client-img img:hover {
        transform: scale(1.1);
    }

    .play-button {
        position: absolute;
        top: 50%;
        right: 0;
        transform: translate(50%, -50%);
        -webkit-transform: translate(50%, -50%);
        z-index: 99;
        padding: 10px 0;
        width: 150px;
        outline: none !important;
    }

    .play-button a {
        outline: none !important;

    }

    .happy-client a {
        font-size: 16px;
        letter-spacing: 1.8px;
        font-weight: bold;
        text-transform: uppercase;
        text-decoration: none;
        padding-top: 5px;
    }

    .happy-client .play-button svg {
        width: unset;
    }

    .client-text {
        padding: 22px 30px 22px 70px;
        align-items: center;
        position: relative;
    }

    .happy-client p {
        font-size: 20px;
    }

    .happy-client h5 {
        font-size: 24px;
        letter-spacing: 2.8px;
        text-transform: uppercase;
        font-weight: bold;
        padding-top: 30px;
    }

    .happy-client a {
        font-size: 16px;
        letter-spacing: 1.8px;
        font-weight: bold;
        text-transform: uppercase;
        text-decoration: none;
        padding-top: 5px;
    }

    .happy-client a:hover {
        color: #c7c7c7;
    }

    .happy-client .owl-theme .owl-dots .owl-dot span {
        background: #007EBF !important;
        opacity: 0.4;
    }

    /*  .client-text {
          padding: 0px 35px 0 40px;
          align-items: center;
          position: relative;
      }

      .happy-clients .row .col-md-6.col-12 {
          padding: 0;
      }

      .happy-clients .row {
          border: 1px dashed #c7c7c7;
          border-width: 2px;
          padding: 60px 0;
          position: relative;
          border-radius: 10px;
      }

      .happy-clients .row:before {
          content: '\f10d';
          font-family: FontAwesome;
          position: absolute;
          left: 20px;
          top: 20px;
          background-color: #1E1E1E;
          color: #C7C7C7;
          font-size: 60px;
          width: 85px;
          display: flex;
          transform: translate(-50px, -50px);
          height: 85px;
          justify-content: center;
          align-items: center;
      }

      .happy-clients .row:after {
          content: '\f10e';
          font-family: FontAwesome;
          position: absolute;
          right: -90px;
          bottom: -90px;
          background-color: #1E1E1E;
          color: #C7C7C7;
          font-size: 60px;
          display: flex;
          width: 85px;
          transform: translate(-50px, -50px);
          height: 85px;
          justify-content: center;
          align-items: center;
      }

      .happy-clients .row .col-md-6.col-12:first-child .client-text {
          height: 100%;
          border-right: 2px dashed #C7C7C7;
          position: relative;
          border-width: 2px;
      }

      .client-text h5 {
          margin: 0 0 50px 0;
          font-weight: 400;
          min-height: 240px;
          line-height: 1.5;
      }

      .client-text h4 {
          font-size: 24px;
          letter-spacing: 2.8px;
          text-transform: uppercase;
          font-weight: 700;
      }

      .client-text a {
          font-size: 16px;
          letter-spacing: 1.8px;
          font-weight: bold;
          text-transform: uppercase;
          text-decoration: none;
          padding-top: 5px;
      }

      .happy-client a:hover {
          color: #c7c7c7;
      }
  */
    .scale-brand {
        background: transparent linear-gradient(90deg, #007EBF 0%, #007FBF 29%, #0087AB 34%, #008F97 41%, #009585 47%, #009C74 54%,
        #22A164 61%, #32A657 69%, #3CAA4E 77%, #40AC4A 87%, #41AD49 100%) 0% 0% no-repeat padding-box;
        padding: 50px 0;
    }

    .scale-brand-text h2 {
        text-align: left;
        text-transform: capitalize;
        letter-spacing: 2.6px;
        font-family: 'Roboto';
        font-weight: 700;
    }

    .scale-brand-text h5 {
        text-align: left;
        letter-spacing: unset;
        padding-top: 15px;
        font-weight: 400;
    }

    .scale-brand .white-btn {
        margin: 0;
    }

    .scale-brand .row {
        align-items: center;
    }

    /*   DM LP */
    .outer_footer, .outer_bottom {
        display: none;
    }

    path#Polygon_1 {
        fill: #007EBF;
    }

    circle#Ellipse_12-2 {
        opacity: 1 !important;
        fill: #fff;
    }

    #youtube-modal .modal-dialog {
        max-width: max-content;
        margin: 1.75rem auto;
    }


    #youtube-modal .modal-content {
        top: 10px;
    }

    #youtube-modal .modal-body {
        padding: 0;
        line-height: 0;
        width: 75vw;
        height: 75vh;
    }

    #youtube-modal .modal-body iframe {
        width: 100%;
        height: 100%;
    }

    .happy-client-carousel .owl-theme .owl-nav.disabled + .owl-dots {
        margin-top: 100px;
    }

    #youtube-modal .btn-close {
        position: absolute;
        right: -22px;
        z-index: 1;
        font-size: 13px;
        top: -15px;
        padding: 15px;
        border-radius: 30px;
        opacity: 1;
        background-color: #fff;
        transform: translate(0px);
    }

    .happy-client .owl-theme .owl-dots .owl-dot.active span, .owl-theme .owl-dots .owl-dot:hover span {
        background: #007EBF !important;
        opacity: 1;
    }
</style>
<!--header starts -->

<header class="header">

    <nav class="navbar navbar-expand-lg navbar-light fixed-top main_nav landing_for">
        <div class="container">

            <a class="navbar-brand" href="https://growthnatives.com">
                <img src="https://growthnatives.com/wp-content/uploads/2020/01/logo.png" alt="logo">
            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav"
                    aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

        </div>
    </nav>

</header>

<!--header ends -->

<!-- banner starts -->

<section class="inner-banner bg-grey">
    <div class="container">
        <div class="row">
            <div class="col-md-7">
                <div class="inner-banner-content color-white">
                    <h1 class="color-blue">Unearth The TRUE POTENTIAL <br> of Your Digital Marketing <br> Campaigns</h1>
                </div>
                <div class="inner-banner-description ">
                    <p class="color-light-grey">Partner with a passionate team to improve visibility, traffic, and
                        engagement. Let every dollar spent on your campaign yield maximum ROI.</p>
                    <h3 class="color-white">What does our audit include?</h3>
                </div>


                <ul class="inner-list color-white">
                    <li> Technical SEO Analysis</li>
                    <li> Backlink Health Analysis</li>
                    <li> Content Gap Analysis</li>
                    <li> UI/UX Recommendations</li>
                    <li> Google Ads Account Heath</li>
                    <li> Linkedin Ads Account Health</li>
                    <li> Facebook Ads Account Health</li>
                    <li> Competitor Benchmarking (SEO & PPC)</li>
                </ul>
                <!--   <div class="banner-logo-img">
                       <div class="inner-img">
                           <img src="https://growthnatives.com/wp-content/uploads/2021/10/salesforce-partner-logo.png"
                                alt="salesforce-partner-logo">
                       </div>
                       <div class="inner-img">
                           <img src="https://growthnatives.com/wp-content/uploads/2022/05/Industries-CPQ-Developer.png"
                                alt="Industries-CPQ-Developer">
                       </div>
                   </div>-->

            </div>
            <div class="col-md-5" id="scroll-top-form">
                <div class="salesforce-form">
                    <h4 class=" color-white">I’m Ready For A Free Audit</h4>
                    <script charset="utf-8" type="text/javascript" src="//js.hsforms.net/forms/v2.js"></script>
                    <script>
                        hbspt.forms.create({
                            region: "na1",
                            portalId: "7118070",
                            formId: "94d067fb-f381-4dac-91ad-9d21ca1f6192"
                        });
                    </script>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- banner ends -->


<!-- digital marketing audit starts -->

<section class="growth-hacking spacing bg-black">
    <div class="container">
        <div class="content">
            <h2 class="heading color-white">Why You Need A Digital Marketing Audit</h2>
            <h4 class="paragraph color-light-grey  ">Reset your digital campaigns, leverage growth
                opportunities, and be in sync with the fast-changing digital landscape. Get a 360-degree perspective of
                your campaign with actionable suggestions for perfection. Our comprehensive audit enables you to:</h4>
        </div>
        <div class="cards-row">
            <div class="row">
                <div class="col-md-4 col-12">
                    <div class="growth-card">
                        <div class="card">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/magnetism.png"
                                     alt="conversion-rate">
                            </div>
                            <div class="card-body">
                                <h5 class="card-h5-black color-light-grey">Improve campaign efficiency and generate more
                                    leads</h5>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="growth-card">
                        <div class="card">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/campaign-1.png"
                                     alt="solution">
                            </div>
                            <div class="card-body">
                                <h5 class="card-h5-black color-light-grey">Identify strengths in your campaign & boost
                                    them further</h5>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="growth-card">
                        <div class="card">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/digital-strategy.png"
                                     alt="organic">
                            </div>
                            <div class="card-body">
                                <h5 class="card-h5-black color-light-grey">Spot opportunities for transformation and
                                    finetune strategies</h5>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="growth-card">
                        <div class="card">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/search-engine.png"
                                     alt="organic">
                            </div>
                            <div class="card-body">
                                <h5 class="card-h5-black color-light-grey">Grow your search engine rankings and increase
                                    traffic</h5>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="growth-card">
                        <div class="card">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/coin.png"
                                     alt="organic">
                            </div>
                            <div class="card-body">
                                <h5 class="card-h5-black color-light-grey">Optimize campaign spending for increased
                                    returns</h5>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="growth-card">
                        <div class="card">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/campaign.png"
                                     alt="organic">
                            </div>
                            <div class="card-body">
                                <h5 class="card-h5-black color-light-grey">Find relevant gaps in your campaigns and fix
                                    them</h5>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>

<!-- digital marketing audit ends -->


<!-- happy clients starts -->

<div class="happy-client spacing bg-grey">
    <div class="container">
        <div class="row">
            <div class="col col-xs-12">
                <div class="happy-client-heading text-center text-white">
                    <h2 class="heading color-white">Our Happy Clients</h2>
                </div>
            </div>
        </div>
        <div class="quote-img">
            <svg xmlns="http://www.w3.org/2000/svg" width="97.457" height="83.536" viewBox="0 0 97.457 83.536">
                <path id="Union_10" data-name="Union 10"
                      d="M-12116.312-7288.6a27.878,27.878,0,0,0,27.849-27.843h-27.849v-41.767h41.77v41.767a41.814,41.814,0,0,1-41.77,41.77Zm-55.687,0a27.872,27.872,0,0,0,27.843-27.843H-12172v-41.767h41.766v41.767a41.813,41.813,0,0,1-41.766,41.77Z"
                      transform="translate(12172 7358.21)" fill="#444446"></path>
            </svg>

        </div>

        <div class="happy-client-carousel">
            <div class="owl-carousel owl-theme" id="happy-client-carousel">
                <div class="item">
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="client-play-button">
                                <div class="client-img">
                                    <img src="https://growthnatives.com/wp-content/uploads/2022/05/Jeremy-Young.jpg"
                                         alt="Happy Client">
                                </div>
                                <div class="play-button">
                                    <a href="" data-toggle="modal" data-target="#youtube-modal"
                                       datayoutube="//www.youtube.com/embed/9ep5nxtP_oU?autoplay=1">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             xmlns:xlink="http://www.w3.org/1999/xlink" width="146"
                                             height="146" viewBox="0 0 146 146">
                                            <defs>
                                                <filter id="Ellipse_12" x="0" y="0" width="146"
                                                        height="146" filterUnits="userSpaceOnUse">
                                                    <feOffset dy="10" input="SourceAlpha"></feOffset>
                                                    <feGaussianBlur stdDeviation="10"
                                                                    result="blur"></feGaussianBlur>
                                                    <feFlood flood-color="#2a2a2a"
                                                             flood-opacity="0.161"></feFlood>
                                                    <feComposite operator="in" in2="blur"></feComposite>
                                                    <feComposite in="SourceGraphic"></feComposite>
                                                </filter>
                                            </defs>
                                            <g id="Vid-Icon" transform="translate(30 20)">
                                                <g transform="matrix(1, 0, 0, 1, -30, -20)"
                                                   filter="url(#Ellipse_12)">
                                                    <circle id="Ellipse_12-2" data-name="Ellipse 12"
                                                            cx="43" cy="43" r="43"
                                                            transform="translate(30 20)" fill="#fff"
                                                            style="opacity: 0.4;"></circle>
                                                </g>
                                                <path id="Polygon_1" data-name="Polygon 1"
                                                      d="M17.177,7.44a5,5,0,0,1,8.646,0L38.635,29.488A5,5,0,0,1,34.312,37H8.688a5,5,0,0,1-4.323-7.512Z"
                                                      transform="translate(68 22) rotate(90)"
                                                      fill="#000000"></path>
                                            </g>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                            <div class="client-text">
                                <p class="color-light-grey">“Have been working with Growth Natives for
                                    several years and they have helped us tremendously in developing web
                                    applications, giving us great full-stack marketing services such as SEO
                                    and Digital Marketing that are top-notch. They are very kind people and
                                    always responsive, staying up until the wee hours of the night to have
                                    conference calls with us on the Pacific, West Coast. I highly recommend
                                    them for anything that you need in terms of programming skills,
                                    scripting, web development, and SEO services.”
                                </p>
                                <h5 class="color-blue">Jeremy Young</h5>
                                <a class="color-blue" href="https://gandergroup.com/" target="_blank">Gander Group</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="client-play-button">
                                <div class="client-img">
                                    <img src="https://growthnatives.com/wp-content/uploads/2022/05/Tarj-1-1.png"
                                         alt="Happy Client">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                            <div class="client-text">
                                <p class="color-light-grey">“We were looking for an experienced company that had
                                    expertise in all aspects of marketing and Growth Natives have surpassed all
                                    expectations, delivering tremendous results. They took the time to understand our
                                    business needs and tailored a package suitable for our eCommerce platform. Our
                                    revenue went up 52% within the first 30 days, our organic traffic and rankings
                                    improved significantly.”</p>
                                <h5 class="color-blue">Dr. Tarj Mavi</h5>
                                <a class="color-blue" href="http://lamav.com/" target="_blank">LAMAV.COM</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="client-play-button">
                                <div class="client-img">
                                    <img src="https://growthnatives.com/wp-content/uploads/2022/05/Mike-Mayhew.png"
                                         alt="Happy Client">


                                </div>
                            </div>
                        </div>
                        <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                            <div class="client-text">
                                <p class="color-light-grey">"Growth Natives was instrumental in identifying solutions
                                    for Lightspeed that allow us to improve the client experience while maintaining
                                    control over sensitive data that our clients entrust us to secure. We look forward
                                    to evolving our HubSpot solution with Growth Natives."</p>
                                <h5 class="color-blue">Mike Mayhew</h5>
                                <a class="color-blue" href="#">Lightspeed CTO</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="client-play-button">
                                <div class="client-img">
                                    <img src="https://growthnatives.com/wp-content/uploads/2022/05/Kevin-Fliess.jpg"
                                         alt="Kevin-Fliess">

                                </div>
                                <div class="play-button">
                                    <a href="" data-toggle="modal" data-target="#youtube-modal"
                                       datayoutube="//www.youtube.com/embed/Ww-_rW6w0pg?autoplay=1">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             xmlns:xlink="http://www.w3.org/1999/xlink" width="146"
                                             height="146" viewBox="0 0 146 146">
                                            <defs>
                                                <filter id="Ellipse_12" x="0" y="0" width="146"
                                                        height="146" filterUnits="userSpaceOnUse">
                                                    <feOffset dy="10" input="SourceAlpha"></feOffset>
                                                    <feGaussianBlur stdDeviation="10"
                                                                    result="blur"></feGaussianBlur>
                                                    <feFlood flood-color="#2a2a2a"
                                                             flood-opacity="0.161"></feFlood>
                                                    <feComposite operator="in" in2="blur"></feComposite>
                                                    <feComposite in="SourceGraphic"></feComposite>
                                                </filter>
                                            </defs>
                                            <g id="Vid-Icon" transform="translate(30 20)">
                                                <g transform="matrix(1, 0, 0, 1, -30, -20)"
                                                   filter="url(#Ellipse_12)">
                                                    <circle id="Ellipse_12-2" data-name="Ellipse 12"
                                                            cx="43" cy="43" r="43"
                                                            transform="translate(30 20)" fill="#fff"
                                                            style="opacity: 0.4;"></circle>
                                                </g>
                                                <path id="Polygon_1" data-name="Polygon 1"
                                                      d="M17.177,7.44a5,5,0,0,1,8.646,0L38.635,29.488A5,5,0,0,1,34.312,37H8.688a5,5,0,0,1-4.323-7.512Z"
                                                      transform="translate(68 22) rotate(90)"
                                                      fill="#000000"></path>
                                            </g>
                                        </svg>
                                    </a>
                                </div>

                            </div>
                        </div>
                        <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                            <div class="client-text">
                                <p class="color-light-grey">"Growth Natives has been an excellent partner as I could
                                    rebuild our entire web strategy and go-to-market motion. They deployed HubSpot and
                                    have been great partners on the WordPress side. Thanks to their collaborative
                                    approach and the work they have done with me and for me, we could successfully 3x-4x
                                    our lead generation in a very cost-effective manner. I like to think of Growth
                                    Natives as my secret weapon for they are technically adept, responsive, and an
                                    extension of your team. I plan to work with them in the future as well."</p>
                                <h5 class="color-blue">Kevin Fliess</h5>
                                <a class="color-blue" href="https://altum.com/" target="_blank">Altum</a>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>


<!-- happy clients ends -->

<!-- scale content starts -->

<div class="scale-brand">
    <div class="container">
        <div class="row">
            <div class="col-lg-9 col-md-12 col-sm-12 col-12">
                <div class="scale-brand-text">
                    <h2 class="color-white">Let's Supercharge Your Digital Marketing Campaign!</h2>
                    <h5 class="color-white">Leverage our expertise to unravel all hidden success opportunities.</h5>
                </div>
            </div>
            <div class="col-lg-3 col-md-12 col-sm-12 col-12">
                <div class=" white-btn">
                    <a href="javascript:void(0)">Get A Free Audit</a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- scale content ends -->


<!--bottom bar starts-->

<section class="bottom-bar color-white bg-black">
    <div class="container">
        <ul>
            <li>
                <a class="color-white" href="https://growthnatives.com/lets-talk/">Contact Us </a>
            </li>
            <li>
                <a class="color-white" href="https://growthnatives.com/resources/">Blogs</a>
            </li>
            <li>
                <a class="color-white" href="https://growthnatives.com/growth-natives-tcs/">Terms & Conditions </a>
            </li>

            <li>
                <a href="https://www.dmca.com/Protection/Status.aspx?ID=639f9bc7-120f-4893-ae6b-66cc4a2e041d&amp;refurl=https://growthnatives.com/growth-natives-tcs/">
                    <img src="https://growthnatives.com/wp-content/uploads/2022/05/dmca.png" alt="DMCA Protected">
                </a>
            </li>
        </ul>
    </div>
</section>

<!--bottom bar ends-->

<!--copyright starts-->

<section class="copyright color-white bg-grey">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-8 col-xs-12">
                <p class="color-white">Copyright © 2022 Growth Natives. All rights reserved.</p>
            </div>
            <div class="col-md-4 col-xs-12">
                <ul>
                    <li class="color-white">Follow Us:</li>
                    <li>
                        <a class="color-white" target="self" href="https://www.facebook.com/growthnatives">
                            <i class="fa fa-facebook" aria-hidden="true"></i> </a>
                    </li>
                    <li>
                        <a class="color-white" target="self" href="https://twitter.com/GrowthNatives">
                            <i class="fa fa-twitter" aria-hidden="true"></i> </a>
                    </li>
                    <li>
                        <a class="color-white" target="self"
                           href="https://www.linkedin.com/company/growthnatives/mycompany/verification/">
                            <i class="fa fa-linkedin" aria-hidden="true"></i> </a>
                    </li>
                    <li>
                        <a class="color-white" target="self" href="https://www.instagram.com/growthnatives/">
                            <i class="fa fa-instagram" aria-hidden="true"></i> </a>
                    </li>
                </ul>

            </div>
        </div>
    </div>
</section>

<!--copyright ends-->
<!-- modals -->
<div class="modal fade" id="youtube-modal" data-keyboard="false" tabindex="-1"
     aria-labelledby="youtube-modal"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close"></button>
            <div class="modal-body">
                <iframe id="youtube-video" src=""
                        title="YouTube video player" frameborder="0"
                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                        allowfullscreen></iframe>
            </div>
        </div>
    </div>
</div>


<style>
    @media screen and (max-width: 1650px) {

        h1 {
            font-size: 36px;
            margin: 0;
        }

        h2 {
            font-size: 28px;
            margin: 0;
        }

        h3 {
            font-size: 26px;
            margin: 0;
        }

        h4 {
            font-size: 24px;
            margin: 0;
        }

        h5 {
            font-size: 18px;
            margin: 0;
        }

        h6 {
            font-size: 16px;
            margin: 0;
        }

        p {
            font-size: 16px;
            margin: 0;
        }

        .spacing {
            padding: 85px 0;
        }

        .heading {
            text-align: center;
        }

        .paragraph {
            margin: 0 0 50px 0;
        }

        .blue-btn a {
            font-size: 16px;
        }


        .inner-banner {
            padding: 160px 0 85px 0;
        }

        .inner-banner-description p {
            font-size: 20px;
            width: auto;
        }

        .inner-list li {
            font-size: 20px;
        }

        .process-card .card-img {
            width: 150px;
        }

        .process .card-body {
            padding: 0;
        }

        .yr-text h3 {
            font-size: 45px;
        }

        .study-content.bg-grey {
            padding: 50px 40px;
            min-height: auto;
        }

        .case-study .row {
            padding: 0;
        }

        li {
            font-size: 14px;
            list-style: none;
        }

        .growth-hacking h5 {
            line-height: 1.3;
        }

        .client-text {
            padding: 22px 30px 22px 50px;
        }

        .happy-client p {
            font-size: 18px;
        }

        .quote-img svg {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .quote-img {
            top: 5%;
            width: 60px;
            height: 60px;
            margin: 0 26px 0 0;
        }

        .happy-client-carousel {
            padding-top: 40px;
        }

        .happy-client-carousel .owl-theme .owl-nav.disabled + .owl-dots {
            margin-top: 85px;
        }
    }

    @media screen and (max-width: 1199px) {
        h1 {
            font-size: 32px;
            margin: 0;
        }

        h2 {
            font-size: 24px;
            margin: 0;
        }

        h3 {
            font-size: 22px;
            margin: 0;
        }

        h4 {
            font-size: 20px;
            margin: 0;
        }

        h5 {
            font-size: 16px;
            margin: 0;
        }

        h6 {
            font-size: 15px;
            margin: 0;
        }

        p {
            font-size: 15px;
            margin: 0;
        }

        .spacing {
            padding: 70px 0;
        }

        .heading {
            margin: 0 0 15px 0;
        }

        .paragraph {
            margin: 0 0 25px 0;
        }

        .heading-margin {
            margin: 0 0 25px;
        }

        .blue-btn a {
            font-size: 15px;
            padding: 8px 30px;
        }

        .inner-banner-description p {
            font-size: 18px;
            padding: 15px 0 25px;
        }

        .inner-list {
            padding: 15px 0 0 0;
        }

        .process .process-card .card {
            padding: 0 0 25px 0;
        }

        .study-content.bg-grey {
            padding: 40px 30px;
        }

        .yr-text h3 {
            font-size: 35px;
            margin-bottom: 15px;
        }

        button.navbar-toggler {
            display: none;
        }

        .inner-list li {
            padding: 0 0 5px 20px;
        }


        .happy-client h5 {
            font-size: 22px;
            padding-top: 14px;
        }

        .happy-client p {
            font-size: 14px;
        }

        .client-text {
            padding: 22px 20px 22px 20px;
        }

        .growth-hacking .row .col-md-4.col-12 {
            padding: 0 10px;
        }

        .play-button {
            width: 95px;
        }

        .happy-client .play-button svg {
            width: 85px;
            opacity: 0.5;
        }
    }

    @media screen and (max-width: 991px) {
        h1 {
            font-size: 32px;
            margin: 0;
        }

        h2 {
            font-size: 24px;
            margin: 0;
        }

        h3 {
            font-size: 22px;
            margin: 0;
        }

        h4 {
            font-size: 20px;
            margin: 0;
        }

        h5 {
            font-size: 16px;
            margin: 0;
        }

        h6 {
            font-size: 15px;
            margin: 0;
        }

        p {
            font-size: 15px;
            margin: 0;
        }

        .spacing {
            padding: 70px 0;
        }

        .heading {
            margin: 0 0 15px 0;
        }

        .paragraph {
            margin: 0 0 25px 0;
        }


        .inner-banner .col-md-5 {
            -ms-flex: 0 0 100%;
            flex: 0 0 100%;
            max-width: 100%;
            padding: 0;
        }

        .inner-banner .row .col-md-7 {
            -ms-flex: 0 0 100%;
            flex: 0 0 100%;
            max-width: 100%;
            padding: 0 0 35px 0;
        }

        .inner-banner .row {
            padding: 0;
        }

        .team-img {
            width: 130px;
        }

        .process .process-card .card h5 {
            width: auto;
        }

        .yr-texth4 {
            font-size: 18px;
        }

        /*    .case-study .row{
                flex-direction: column;
            }
            .case-study .row .col-md-4 {
                -ms-flex: 0 0 100%;
                flex: 0 0 100%;
                max-width: 100%;
                padding: 0 0 35px;
            }

            */
        .case-study .row .col-md-5,
        .case-study .row .col-md-7 {
            flex: 0 0 50%;
            max-width: 50%;
        }

        .study-content.bg-grey {
            padding: 20px 20px;
        }

        .case-study .row .col-md-7.col-12 {
            padding: 0 0 0 15px;
            max-width: 51.666667%;
        }

        .bottom-bar ul li a {
            padding: 0;
        }

        button.navbar-toggler {
            display: none;
        }

        .growth-card .card-img {
            width: 72px;
            height: 72px;
            margin: 0 0 30px;
        }

        .growth-card .card {
            min-height: 240px;
            padding: 20px 10px;
            max-height: 350px;
        }

        .quote-img {
            top: 3%;
            width: 40px;
            height: 40px;
        }


        .scale-brand-text p {
            padding: 10px 0 10px;
        }

        .scale-brand-text h2, .scale-brand-text h5 {
            text-align: center;
        }

        .scale-brand-text h5 {
            padding: 15px;
        }

        .happy-client h5 {
            font-size: 20px;
            padding-top: 15px;
        }

        .inner-banner h1 br {
            display: none;
        }
    }


    @media screen and (max-width: 767px) {
        h1 {
            font-size: 28px;
            margin: 0;
        }

        h2 {
            font-size: 22px;
            margin: 0;
        }

        h3 {
            font-size: 20px;
            margin: 0;
        }

        h4 {
            font-size: 18px;
            margin: 0;
        }

        h5 {
            font-size: 15px;
            margin: 0;
        }

        h6 {
            font-size: 14px;
            margin: 0;
        }

        p {
            font-size: 14px;
            margin: 0;
        }

        .spacing {
            padding: 35px 0;
        }

        .heading {
            margin: 0 0 15px 0;
        }

        .paragraph {
            margin: 0 0 25px 0;
        }

        .inner-banner-description p {
            font-size: 16px;
        }

        .inner-list li {
            font-size: 16px;
        }

        .inner-list li:before {
            font-size: 16px;
        }

        .inner-banner {
            padding: 100px 0 30px 0;
        }

        .inner-banner .row .col-md-7 {
            padding: 0 15px 35px 15px;
        }

        .inner-banner .row .col-md-5 {
            padding: 0 15px 0 15px;
        }

        .inner-banner-description h3 {
            width: auto;
        }

        .inner-img {
            margin: auto;
        }

        .salesforce-form h4 {
            padding: 20px 15px;
        }

        ul.banner-bottom-content {
            display: none;
        }

        .yr-text h3 {
            font-size: 20px;
            margin-bottom: 10px;
        }

        .yr-text h4 {
            font-size: 14px;
        }

        .years-content .row .col-md-4:not(:last-child) {
            margin: 0 0 35px;
        }

        .case-study .row .col-md-5.col-12, .case-study .row .col-md-7.col-12 {
            flex: 0 0 100%;
            max-width: 100%;
            padding: 0 15px;
        }

        .case-study .row .col-12:not(:last-child) {
            padding: 0px 15px 35px 15px;
        }

        /*.case-study .study-content .blue-btn {
            margin: 15px auto 0;
        }*/
        .bottom-bar ul li:not(:last-child) {
            padding: 0 16px 0 16px;
        }

        .bottom-bar ul li:nth-last-child(2) {
            border: unset;
        }

        .copyright ul {
            text-align: center;
            padding: 7px 0px;
        }

        .bottom-bar ul {
            flex-wrap: wrap;
        }

        .bottom-bar ul li a img {
            padding-top: 15px;
        }

        .inner-banner .row {
            padding: 0;
        }

        .study-img {
            padding: 0;
        }

        .inner-img {
            padding-top: 30px;
        }

        .banner-logo-img {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .bottom-bar ul li a {
            padding: 0;
        }

        button.navbar-toggler {
            display: none;
        }

        .growth-hacking .row .col-md-4.col-12:not(:last-child), .growth-hacking .row .col-md-4.col-12:nth-last-child(2), .growth-hacking .row .col-md-4.col-12:nth-last-child(3) {
            margin: 0 0 20px;
        }


        .client-text {
            padding: 22px 20px 22px 20px;
        }

        .inner-banner-content h1 br {
            display: none;
        }

        .white-btn a {
            text-decoration: none;
            font-size: 14px;
        }

        .play-button {
            top: 100%;
            right: 50%;
            transform: translate(50%, -50%);
            -webkit-transform: translate(50%, -50%);
        }

        .happy-client .quote-img svg {
            padding: 5px;
        }
    }

    @media screen and (max-width: 600px) and (min-width: 500px) {
        #youtube-modal .modal-content {
            top: 25px;
        }

        #youtube-modal .modal-body {
            height: 70vh;
        }

        #youtube-modal .btn-close {
            top: -12px
        }
    }
</style>


<?php

get_footer();
?>

<script>
    jQuery(document).ready(function () {

        jQuery('#happy-client-carousel').owlCarousel({
            loop: true,
            margin: 10,
            nav: false,
            mouseDrag: true,
            autoplay: false,
            autoplayTimeout: 4000,
            responsive: {
                0: {
                    items: 1,
                    dots: true
                },
                600: {
                    items: 1,
                    dots: true
                },
                1000: {
                    items: 1,
                    dots: true
                }
            }
        });
        jQuery('.happy-client-carousel .play-button > a').click(function (e) {
            const youtube_link = e.currentTarget.attributes['datayoutube'].value
            jQuery('#youtube-modal .modal-body iframe').attr('src', youtube_link)
        })
        jQuery('#youtube-modal').on('hidden.bs.modal', function () {
            jQuery('#youtube-video').attr('src', '')
        });
    });

</script>
