<?php
/* Template Name: Marketing Automation Audit*/

get_header();
$fieldsData = get_fields();
//echo '<pre>';  print_r($fieldsData);
?>

    <header class="header header-marketo">

        <nav class="navbar navbar-expand-lg navbar-light fixed-top main_nav landing_for ">
            <div class="container">

                <a class="navbar-brand" href="<?php echo get_site_url(); ?>">

                    <img src="<?php echo get_site_url(); ?>/wp-content/uploads/2020/04/logo.png" alt="logo">
                </a>
                <!-- <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
					<span class="navbar-toggler-icon"></span>
				</button>-->
                <div class="collapse navbar-collapse marketing-header">
                    <!-- new code started here -->
                    <ul class="navbar-nav ml-auto menu_link">
                        <li class="nav-item drop_hover ">
                            <a href="https://www.facebook.com/growthnatives" title="Facebook" class="nav-link"
                               target="_blank">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/facebook.png"
                                     alt="Facebook-icon">
                            </a>
                            <i class="fa fa-plus menu_toggle"></i>
                        </li>

                        <li class="nav-item drop_hover ">
                            <a href="https://www.instagram.com/growthnatives/" title="Instagram" class="nav-link"
                               target="_blank">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/instagram.png"
                                     alt="Instagram-icon">
                            </a>
                            <i class="fa fa-plus menu_toggle"></i>
                        </li>
                        <li class="nav-item drop_hover ">
                            <a href="https://www.linkedin.com/company/growthnatives/mycompany/?viewAsMember=true"
                               title="Linkedin" class="nav-link" target="_blank">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/linkedin.png"
                                     alt="Linkedin-icon">
                            </a>
                            <i class="fa fa-plus menu_toggle"></i>

                        </li>

                    </ul>
                </div>
            </div>
        </nav>

    </header>


    <div class="site_wrap">
        <div class="slider_image marketing-automation-slider">
            <div class="container">
                <div class="slider_image_txt">
                    <h1><?php echo isset($fieldsData['banner']) ? $fieldsData['banner'] : ''; ?> </h1>
                </div>
            </div>
        </div>
        <section class="section marketing-aduit-info">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 col-12">
                        <div class="marketing-aduit-info-text mr-lg-5 mr-0">
                            <?php echo isset($fieldsData['short_info']) ? $fieldsData['short_info'] : ''; ?>

                            <div class="Healt-checklist">
                                <?php echo isset($fieldsData['marketing_automation_listing']) ? $fieldsData['marketing_automation_listing'] : ''; ?>

                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-12">
                        <div class="ml-lg-5 ml-0 mt-lg-0 mt-5">
                            <div class="automation-health-check-form">
                                <h3>Sign-up for a FREE Marketing Automation Health Check</h3>
                                <script charset="utf-8" type="text/javascript"
                                        src="//js.hsforms.net/forms/shell.js"></script>
                                <script>
                                    hbspt.forms.create({
                                        region: "na1",
                                        portalId: "7118070",
                                        formId: "068bb29c-4a4e-44ee-a544-e4e93dbef7a0"
                                    });
                                </script>
                            </div>
                            <div class="marketing-testmonial">
                                <h3><?php echo isset($fieldsData['heading_testimonial']) ? $fieldsData['heading_testimonial'] : ''; ?></h3>
                                <div class="owl-carousel owl-theme" id="marketing-aduit-testmonial">
                                    <?php
                                    $testimonial = $fieldsData['testimonial'];
                                    foreach ($testimonial as $value):
                                        ?>
                                        <div class="item">
                                            <div class="marketing-testmonial-text">
                                                <div class="quote-icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="quote-icon-svg"
                                                         viewBox="0 0 44.624 38.249">
                                                        <defs>
                                                            <style>
                                                                .a {
                                                                    fill: #007ebf;
                                                                }
                                                            </style>
                                                        </defs>
                                                        <path class="a"
                                                              d="M233.882,29.235V48.359h12.75a12.764,12.764,0,0,1-12.75,12.75v6.375a19.145,19.145,0,0,0,19.124-19.124V29.235Z"
                                                              transform="translate(-208.383 -29.235)"/>
                                                        <path class="a"
                                                              d="M0,48.359H12.75A12.764,12.764,0,0,1,0,61.109v6.375A19.145,19.145,0,0,0,19.124,48.359V29.235H0Z"
                                                              transform="translate(0 -29.235)"/>
                                                    </svg>
                                                </div>
                                                <?php
                                                echo $value['short_info']
                                                ?>
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div class="testmonial-name">
                                                        <h5><?php echo $value['name'] ?></h5>
                                                        <?php
                                                        if (!empty($value['website_name'])):
                                                            ?>
                                                            <p><?php echo $value['website_name'] ?></p>
                                                        <?php
                                                        endif;
                                                        ?>
                                                        <div class="client-logo">
                                                            <img src=" <?php echo $value['client_logo']['url']; ?>"
                                                                 alt="<?php echo $value['client_logo']['alt']; ?>"
                                                                 title="<?php echo $value['client_logo']['title']; ?>">
                                                        </div>
                                                    </div>
                                                    <div class="testmonial-profile">
                                                        <img src=" <?php echo $value['profile_picture']['url']; ?>"
                                                             alt="<?php echo $value['profile_picture']['alt']; ?>"
                                                             title="<?php echo $value['profile_picture']['title']; ?>">
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    <?php
                                    endforeach;
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mt-5">
                    <?php
                    foreach ($fieldsData['brand_logos'] as $brand) :
                        $imageurl = isset($brand['image']['url']) ? $brand['image']['url'] : '';
                        $imagealt = isset($brand['image']['alt']) ? $brand['image']['alt'] : '';
                        $imagetitle = isset($brand['image']['title']) ? $brand['image']['title'] : '';
                        ?>
                        <div class="col-md-3 col-sm-6 col-12">
                            <div class="logo-trust-markers text-center mt-4">
                                <img class="img-fluid" src="<?php echo $imageurl; ?>" alt="<?php echo $imagealt; ?>"
                                     title="<?php echo $imagetitle; ?>">
                            </div>
                        </div>
                    <?php
                    endforeach;
                    ?>
                </div>
            </div>
        </section>
    </div>
<?php get_Footer(); ?>