<?php
/*
Template Name: Salesforce CPQ Consultation
*/
get_header();
?>
<style>
    /**************************** Google fonts import ****************************/
    @import url('https://fonts.googleapis.com/css2?family=Roboto&display=swap');
    @import url('https://fonts.googleapis.com/css2?family=Roboto+Condensed&display=swap');


    body,
    html {
        margin-top: 0;
        padding: 0 !important;
        width: 100%;
        height: 100%;
        font-family: 'Roboto', sans-serif;
    }

    h1 {
        font-size: 44px;
        margin: 0;
    }

    h2 {
        font-size: 34px;
        margin: 0;
    }

    h3 {
        font-size: 30px;
        margin: 0;
    }

    h4 {
        font-size: 28px;
        margin: 0;
    }

    h5 {
        font-size: 20px;
        margin: 0;
    }

    h6 {
        font-size: 18px;
        margin: 0;
    }

    p {
        font-size: 18px;
        margin: 0;
    }

    ul {
        padding: 0;
        margin: 0;
    }

    li {
        font-size: 18px;
        list-style: none;
    }

    /* color-css starts */

    .blue-btn, .white-btn, .grey-btn {
        padding: 0;
        border: none;
        margin: 100px auto 0;
        display: flex;
        background: none;
        align-items: center;
        justify-content: center;
        width: auto;
    }

    .blue-btn a, .white-btn a {
        text-decoration: none;
        font-size: 18px;
        border: 2px solid #fff;
        border-radius: 26px;
        padding: 10px 30px;
        color: #fff;
        font-weight: 500;
        transition: 0.3s all;
        display: block;
    }

    .grey-btn a {
        text-decoration: none;
        font-size: 18px;
        border: 2px solid #7B7B7B;
        border-radius: 26px;
        padding: 10px 30px;
        color: #7B7B7B;
        font-weight: 500;
        transition: 0.3s all;
    }

    .grey-btn:hover a {
        background: #7B7B7B;
        border-color: #7B7B7B;
        transition: 0.3s all;
        color: #fff;
    }

    .blue-btn:hover a {
        background: #007EBF;
        border-color: #007EBF;
        transition: 0.3s all;
    }

    .white-btn:hover a {
        color: #1E1E20;
        background: #fff;
        border-color: #fff;
        transition: 0.3s all;
    }

    .blue-green-gradient {
        background: -webkit-linear-gradient(#007ebf, #41ad49);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }

    .color-white {
        color: #fff;
    }

    .color-dark-grey {
        color: #1E1E1E;
    }

    .color-light-grey {
        color: #C7C7C7;
    }

    .color-grey {
        color: #6E6E6E;
    }

    .color-blue {
        color: #007EBF;
    }

    .color-black {
        color: #000;
    }

    .bg-black {
        background-color: #000;
    }

    .bg-grey {
        background: #1E1E1E;
    }

    .bg-light-grey {
        color: #1e1e1e7d;
    }

    .bg-white {
        color: #fff;
    }


    .heading {
        font-weight: 700;
        text-align: center;
        margin: 0 0 30px 0;
    }

    .paragraph {
        font-weight: 400;
        margin: 0 0 50px 0;
        text-align: center;
    }

    .bg-black {
        color: #000;
    }

    .spacing {
        padding: 100px 0;
    }

    /*header starts*/
    /*   .header ul {
           display: flex;
           align-items: center;
           justify-content: unset;
       }

       .header ul li:not(:last-child) {
           padding: 0 50px 0 0;
       }

       .header ul li a {
           font-size: 25px;
       }*/

    /*header ends */


    /*    banner starts */
    .inner-banner {
        position: relative;
        height: auto;
        padding: 220px 0 52px 0;
    }

    .inner-banner .container {
        position: relative;
    }

    .inner-banner-content h1 {
        font-weight: 700;
    }


    .inner-banner-description p {
        padding: 30px 0 50px;
        font-size: 22px;
        width: 77%;
    }

    .inner-banner .row {
        padding: 0 0 200px 0;
        align-items: start;
    }


    .inner-banner-description h3 {
        width: 570px;
    }

    .inner-list {
        padding: 30px 0 0 0;
    }

    .inner-list li {
        font-size: 22px;
        position: relative;
        padding: 0 0 15px 20px;
    }

    .inner-list li:last-child {
        padding-bottom: 0;
    }

    .inner-list li:before {
        content: '\f101';
        position: absolute;
        top: 0;
        left: 0;
        font-size: 20px;
        color: #007EBF;
        font-family: FontAwesome;
    }

    .inner-img {
        padding-top: 50px;
        width: 180px;
    }

    .inner-img:nth-of-type(2n) {
        width: 120px;
    }

    .inner-img img {
        width: 100%;
    }

    ul.banner-bottom-content {
        display: flex;
        align-items: center;
        justify-content: space-between;
        position: absolute;
        bottom: 0;
        width: 100%;
        left: 0;
    }
    .banner-logo-img {
        align-items: center;
        display: flex;
        justify-content: start;
    }
    .banner-logo-img .inner-img:first-child {
        padding: 50px 0px 0 0;
        margin: 0 50px 0 0;
    }
    .sticky_button .btn_design{
        display: none;
    }
    .salesforce-form {
        background: #1d1d1d;
        border-radius: 20px;
        box-shadow: 0px 10px 70px #000000;
    }

    .salesforce-form h4 {
        background-color: #000;
        border-top-left-radius: 20px;
        border-top-right-radius: 20px;
        text-align: center;
        padding: 30px 35px;
    }

    .salesforce-form .hbspt-form {
        padding: 20px 30px 50px;
    }

    .study-content.bg-grey {
        padding: 70px 80px 70px 50px;
        max-height: 100%;
        height: 100%;
        border-radius: 6px;
    }

    /*    banner ends */

    /*process starts*/

    .process .process-card .card {
        height: 100%;
        max-height: initial;
        max-width: 380px;
        background-color: transparent;
        width: 100%;
        margin: auto;
        padding: 0 0 30px 0;
        text-align: center;
    }

    .process .row .col-md-4.col-12:last-child .card, .process .row .col-md-4.col-12:nth-last-child(2) .card,
    .process .row .col-md-4.col-12:nth-last-child(3) .card {
        padding: 0;
    }

    .process-card .card-img {
        width: 200px;
        margin: auto;
    }

    .process-card .card-body {
        padding: 0;
    }

    .process-card .card-img img {
        width: 100%;
    }

    .process .process-card .card h4 {
        width: 100%;
        margin: auto;
        text-transform: capitalize;
        font-weight: 700;
    }

    /* process ends */

    /* yr text  */
    .yr-text {
        text-align: center;
    }

    .yr-text h3 {
        font-size: 60px;
        margin: 0 0 20px 0;
        font-weight: 700;
    }

    .yr-text h4 {
        font-weight: 400;
    }


    /*case study starts*/
    .study-content h3 {
        text-align: left;
        font-weight: 500;
    }

    .study-content p {
        text-align: left;
        font-weight: 400;

    }

    .case-study .row {
        padding: 0;
        justify-content: space-between;
        align-items: stretch;
    }

    .case-study .study-content .blue-btn {
        margin: 0;
        justify-content: start;
        width: auto;
        display: inline-block;
    }


    .study-img {
        width: auto;
        padding: 0 10px 0 0;
    }

    .case-study .row .col-md-5.col-12 {
        padding: 0 15px 0 0;
    }

    .case-study .row .col-md-7.col-12 {
        padding: 0 0 0 15px;
    }


    .study-img img {
        width: 100%;
    }

    /*case study ends*/
    /*bottom bar starts*/
    .bottom-bar {
        padding: 20px 0;
        border: 1px solid #1E1E20;
    }

    .bottom-bar ul {
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .bottom-bar ul li {
        padding: 0 30px;
    }

    .bottom-bar ul li:not(:last-child) {

        border-right: 1px solid #1E1E20;
    }

    .bottom-bar ul li a {
        padding: 7px 25px 6px 25px;
        text-decoration: none;
        font-size: 14px;
    }

    .bottom-bar ul li a:hover {
        background: -webkit-linear-gradient(#007ebf, #41ad49);
        -webkit-background-clip: text;
        transition: all 0.5s;
        -webkit-text-fill-color: transparent;
    }

    .copyright {
        padding: 15px 0;
    }

    .copyright p {
        font-size: 14px;
    }

    .copyright ul {
        text-align: right;
        margin-bottom: 0;
        padding: 0;
    }

    .copyright ul li {
        list-style: none;
        display: inline-block;
        font-size: 15px;
        margin-right: 12px;
    }

    /*bottom bar ends*/


    /*   salesforce */


</style>
<!--header starts -->
<header class="header">

    <nav class="navbar navbar-expand-lg navbar-light fixed-top main_nav landing_for">
        <div class="container">

            <a class="navbar-brand" href="https://growthnatives.com">
                <img src="https://growthnatives.com/wp-content/uploads/2020/01/logo.png" alt="logo">
            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav"
                    aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

        </div>
    </nav>

</header>
<!--header ends -->

<!-- banner starts -->
<section class="inner-banner bg-grey">
    <div class="container">
        <div class="row">
            <div class="col-md-7">
                <div class="inner-banner-content color-white">
                    <h1 class="color-blue">Salesforce CPQ Consultation</h1>
                </div>
                <div class="inner-banner-description ">
                    <p class="color-light-grey">Get a trusted consultation from a certified Salesforce CPQ expert.
                        Whether you are exploring, implementing, or expanding a Salesforce CPQ solution we are ready to
                        provide the required expertise and support.
                    </p>
                    <h3 class="color-white">Why Choose Growth Natives As Your CPQ Partner?</h3>
                </div>
                <ul class="inner-list color-white">
                    <li>60+ certified Salesforce experts</li>
                    <li>Decades of CPQ experience</li>
                    <li>100% track record for meeting SLAs</li>
                    <li>Certified Salesforce CPQ Partner</li>
                    <li>Focus on quality and customer success</li>
                    <li>Global delivery team for best results</li>
                </ul>
                <div class="banner-logo-img">
                    <div class="inner-img">
                        <img src="https://growthnatives.com/wp-content/uploads/2021/10/salesforce-partner-logo.png"
                             alt="salesforce-partner-logo">
                    </div>
                    <div class="inner-img">
                        <img src="https://growthnatives.com/wp-content/uploads/2022/05/Industries-CPQ-Developer.png"
                             alt="Industries-CPQ-Developer">
                    </div>
                </div>

            </div>

            <div class="col-md-5" id="scroll-top-form">
                <div class="salesforce-form">
                    <h4 class=" color-white">Get FREE CPQ Consultation</h4>
                    <script charset="utf-8" type="text/javascript" src="//js.hsforms.net/forms/v2.js"></script>
                    <script>
                        hbspt.forms.create({
                            region: "na1",
                            portalId: "7118070",
                            formId: "dfbd7704-0840-435d-8f14-b39413ee1162"
                        });
                    </script>
                </div>
            </div>
        </div>
        <ul class="banner-bottom-content">
            <li>
                <a href="https://www.glassdoor.co.in/Overview/Working-at-Growth-Natives-EI_IE3818104.11,25.htm?countryRedirect=true"
                   target="_blank">
                    <div class="team-img">
                        <img src="https://growthrevamp.demandtech.org/wp-content/uploads/2022/03/Group-86569.svg"
                             alt="glassdoor">
                    </div>
                </a>
            </li>
            <li>
                <a href="https://www.comparably.com/companies/growth-natives" target="_blank">
                    <div class="team-img">
                        <img src="https://growthrevamp.demandtech.org/wp-content/uploads/2022/03/comparably.svg"
                             alt="comparably">
                    </div>
                </a>
            </li>
            <li>
                <a href="https://clutch.co/profile/growth-natives#summary" target="_blank">
                    <div class="team-img">
                        <img src="https://growthrevamp.demandtech.org/wp-content/uploads/2022/03/Group-86575.svg"
                             alt="clutch">
                    </div>
                </a>
            </li>
            <li>
                <a href="https://www.google.com/maps/place/Growth+Natives/@47.630593,-122.2291827,17z/data=!3m1!4b1!4m5!3m4!1s0x54906dadfedd1f79:0xfee4f7da522fccd8!8m2!3d47.630593!4d-122.226994"
                   target="_blank">
                    <div class="team-img">
                        <img src="https://growthrevamp.demandtech.org/wp-content/uploads/2022/03/Group-86576.svg"
                             alt="google">
                    </div>
                </a>
            </li>
        </ul>
    </div>
</section>
<!-- banner ends -->


<!-- Process With CPQ starts -->
<section class="process bg-black spacing">
    <div class="container">
        <div class="content">
            <h2 class="heading color-white">
                Speed Up Your Quote-To-Cash Process With CPQ
            </h2>
            <h5 class="paragraph color-light-grey">
                With Salesforce CPQ, it’s easy to deliver fast and secure sales quotes, contracts, and invoices.
            </h5>
        </div>
        <div class="growth-card">
            <div class="row">

                <div class="col-md-4 col-12">
                    <div class="process-card">
                        <div class="card">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/pricing.png"
                                     alt="pricing">
                            </div>
                            <div class="card-body">
                                <h4 class="card-h5-black color-blue">Pricing & Quoting</h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="process-card">
                        <div class="card">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/guided-sellin.png"
                                     alt="guided-selling">
                            </div>
                            <div class="card-body">
                                <h4 class="card-h5-black color-blue">Guided Selling</h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="process-card">
                        <div class="card">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/bundles.png"
                                     alt="bundles">
                            </div>
                            <div class="card-body">
                                <h4 class="card-h5-black color-blue">Product Bundles</h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="process-card">
                        <div class="card">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/proposals.png"
                                     alt="proposals">
                            </div> 
                            <div class="card-body">
                                <h4 class="card-h5-black color-blue ">Generate Proposals</h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="process-card">
                        <div class="card">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/subscription.png"
                                     alt="subscription">
                            </div>
                            <div class="card-body">
                                <h4 class="card-h5-black color-blue">Subscription Billing</h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="process-card">
                        <div class="card">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/revenue.png"
                                     alt="revenue">
                            </div>
                            <div class="card-body">
                                <h4 class="card-h5-black color-blue">Streamline Revenue Recognition</h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="process-card">
                        <div class="card">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/signature.png"
                                     alt="signature">
                            </div>
                            <div class="card-body">
                                <h4 class="card-h5-black color-blue">Signature Plugins</h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="process-card">
                        <div class="card">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/renewals.png"
                                     alt="renewals">
                            </div>
                            <div class="card-body">
                                <h4 class="card-h5-black color-blue">Renewals And Amendments</h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="process-card">
                        <div class="card">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/partner.png"
                                     alt="partner">
                            </div>
                            <div class="card-body">
                                <h4 class="card-h5-black color-blue">Partner Community</h4>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>
</section>
<!-- Process With CPQ ends -->


<!--years content starts-->
<section class="years-content spacing bg-grey">
    <div class="container">
        <div class="content">
            <div class="row">
                <div class="col-md-4 col-12">
                    <div class="yr-text">
                        <h3 class="color-white   ">70+</h3>
                        <h4 class="color-light-grey">Customers</h4>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="yr-text">
                        <h3 class="color-white ">200+</h3>
                        <h4 class="color-light-grey">Successful Projects</h4>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="yr-text">
                        <h3 class="color-white ">25+</h3>
                        <h4 class="color-light-grey">Salesforce Certifications</h4>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--years content ends-->

<!-- case study starts -->
<section class="case-study spacing bg-black">
    <div class="container">
        <div class="content">
            <h2 class="heading color-white">
                Case Study
            </h2>
            <h5 class="paragraph color-light-grey">
                With Salesforce CPQ, it’s easy to deliver fast and secure sales quotes, contracts, and invoices.
            </h5>
        </div>
        <div class="row">
            <div class="col-md-5 col-12">
                <div class="study-img">
                    <img src="https://growthnatives.com/wp-content/uploads/2022/05/case-study-conultation.png"
                         alt="case-study-consultation">
                </div>
            </div>
            <div class="col-md-7 col-12">
                <div class="study-content bg-grey">
                    <h3 class="heading color-blue">Reduced Customer’s Cycle Time By 75% With A Custom Salesforce CPQ
                        Solution</h3>
                    <p class="heading color-light-grey">
                        Learn how we worked closely with this company to analyze their use cases and business scenarios
                        and cultivate the best solution for their brain technology business.
                    </p>
                    <button class="blue-btn">
                        <a href="https://growthnatives.com/salesforce-cpq-case-study/" target="_self">
                            Read More </a>
                    </button>
                </div>

            </div>
        </div>
    </div>
</section>


<!-- case study ends -->


<!--bottom bar starts-->
<section class="bottom-bar color-white bg-black">
    <div class="container">
        <ul>
            <li>
                <a class="color-white" href="https://growthnatives.com/lets-talk/">Contact Us </a>
            </li>
            <li>
                <a class="color-white" href="https://growthnatives.com/resources/">Blogs</a>
            </li>
            <li>
                <a class="color-white" href="https://growthnatives.com/growth-natives-tcs/">Terms & Conditions </a>
            </li>

            <li>
                <a href="https://www.dmca.com/Protection/Status.aspx?ID=639f9bc7-120f-4893-ae6b-66cc4a2e041d&amp;refurl=https://growthnatives.com/growth-natives-tcs/">
                    <img src="https://growthnatives.com/wp-content/uploads/2022/05/dmca.png" alt="DMCA Protected">
                </a>
            </li>
        </ul>
    </div>
</section>
<!--bottom bar ends-->

<!--copyright starts-->
<section class="copyright color-white bg-grey">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-8 col-xs-12">
                <p class="color-white">Copyright © 2022 Growth Natives. All rights reserved.</p>
            </div>
            <div class="col-md-4 col-xs-12">
                <ul>
                    <li class="color-white">Follow Us:</li>
                    <li>
                        <a class="color-white" target="self" href="https://www.facebook.com/growthnatives">
                            <i class="fa fa-facebook" aria-hidden="true"></i> </a>
                    </li>
                    <li>
                        <a class="color-white" target="self" href="https://twitter.com/GrowthNatives">
                            <i class="fa fa-twitter" aria-hidden="true"></i> </a>
                    </li>
                    <li>
                        <a class="color-white" target="self"
                           href="https://www.linkedin.com/company/growthnatives/mycompany/verification/">
                            <i class="fa fa-linkedin" aria-hidden="true"></i> </a>
                    </li>
                    <li>
                        <a class="color-white" target="self" href="https://www.instagram.com/growthnatives/">
                            <i class="fa fa-instagram" aria-hidden="true"></i> </a>
                    </li>
                </ul>

            </div>
        </div>
    </div>
</section>
<!--copyright ends-->


<style>
    @media screen and (max-width: 1650px) {

        h1 {
            font-size: 36px;
            margin: 0;
        }

        h2 {
            font-size: 28px;
            margin: 0;
        }

        h3 {
            font-size: 26px;
            margin: 0;
        }

        h4 {
            font-size: 24px;
            margin: 0;
        }

        h5 {
            font-size: 18px;
            margin: 0;
        }

        h6 {
            font-size: 16px;
            margin: 0;
        }

        p {
            font-size: 16px;
            margin: 0;
        }

        .spacing {
            padding: 85px 0;
        }

        .heading {
            text-align: center;
        }

        .paragraph {
            margin: 0 0 50px 0;
        }

        .blue-btn a {
            font-size: 16px;
        }


        .inner-banner {
            padding: 160px 0 30px 0;
        }

        .inner-banner-description p {
            font-size: 20px;
            width: auto;
        }

        .inner-list li {
            font-size: 20px;
        }

        .process-card .card-img {
            width: 150px;
        }

        .process .card-body {
            padding: 0;
        }

        .yr-text h3 {
            font-size: 45px;
        }

        .study-content.bg-grey {
            padding: 50px 40px;
            min-height: auto;
        }

        .case-study .row {
            padding: 0;
        }

        li {
            font-size: 14px;
            list-style: none;
        }
    }

    @media screen and (max-width: 1199px) {
        h1 {
            font-size: 32px;
            margin: 0;
        }

        h2 {
            font-size: 24px;
            margin: 0;
        }

        h3 {
            font-size: 22px;
            margin: 0;
        }

        h4 {
            font-size: 20px;
            margin: 0;
        }

        h5 {
            font-size: 16px;
            margin: 0;
        }

        h6 {
            font-size: 15px;
            margin: 0;
        }

        p {
            font-size: 15px;
            margin: 0;
        }

        .spacing {
            padding: 70px 0;
        }

        .heading {
            margin: 0 0 15px 0;
        }

        .paragraph {
            margin: 0 0 25px 0;
        }

        .blue-btn a {
            font-size: 15px;
            padding: 8px 30px;
        }

        .inner-banner-description p {
            font-size: 18px;
            padding: 15px 0 25px;
        }

        .inner-list {
            padding: 15px 0 0 0;
        }

        .process .process-card .card {
            padding: 0 0 25px 0;
        }

        .study-content.bg-grey {
            padding: 40px 30px;
        }

        .yr-text h3 {
            font-size: 35px;
            margin-bottom: 15px;
        }

        button.navbar-toggler {
            display: none;
        }
    }

    @media screen and (max-width: 991px) {
        h1 {
            font-size: 32px;
            margin: 0;
        }

        h2 {
            font-size: 24px;
            margin: 0;
        }

        h3 {
            font-size: 22px;
            margin: 0;
        }

        h4 {
            font-size: 20px;
            margin: 0;
        }

        h5 {
            font-size: 16px;
            margin: 0;
        }

        h6 {
            font-size: 15px;
            margin: 0;
        }

        p {
            font-size: 15px;
            margin: 0;
        }

        .spacing {
            padding: 70px 0;
        }

        .heading {
            margin: 0 0 15px 0;
        }

        .paragraph {
            margin: 0 0 25px 0;
        }


        .inner-banner .col-md-5 {
            -ms-flex: 0 0 100%;
            flex: 0 0 100%;
            max-width: 100%;
            padding: 0;
        }

        .inner-banner .row .col-md-7 {
            -ms-flex: 0 0 100%;
            flex: 0 0 100%;
            max-width: 100%;
            padding: 0 0 35px 0;
        }

        .inner-banner .row {
            padding: 0 0 155px 0;
        }

        .team-img {
            width: 130px;
        }

        .process .process-card .card h5 {
            width: auto;
        }

        .yr-texth4 {
            font-size: 18px;
        }

        /*    .case-study .row{
                flex-direction: column;
            }
            .case-study .row .col-md-4 {
                -ms-flex: 0 0 100%;
                flex: 0 0 100%;
                max-width: 100%;
                padding: 0 0 35px;
            }

            */
        .case-study .row .col-md-5,
        .case-study .row .col-md-7 {
            flex: 0 0 50%;
            max-width: 50%;
        }

        .study-content.bg-grey {
            padding: 20px 20px;
        }

        .case-study .row .col-md-7.col-12 {
            padding: 0 0 0 15px;
            max-width: 51.666667%;
        }

        .bottom-bar ul li a {
            padding: 0;
        }

        button.navbar-toggler {
            display: none;
        }

    }


    @media screen and (max-width: 767px) {
        h1 {
            font-size: 28px;
            margin: 0;
        }

        h2 {
            font-size: 22px;
            margin: 0;
        }

        h3 {
            font-size: 20px;
            margin: 0;
        }

        h4 {
            font-size: 18px;
            margin: 0;
        }

        h5 {
            font-size: 15px;
            margin: 0;
        }

        h6 {
            font-size: 14px;
            margin: 0;
        }

        p {
            font-size: 14px;
            margin: 0;
        }

        .spacing {
            padding: 35px 0;
        }

        .heading {
            margin: 0 0 15px 0;
        }

        .paragraph {
            margin: 0 0 25px 0;
        }

        .inner-banner-description p {
            font-size: 16px;
        }

        .inner-list li {
            font-size: 16px;
        }

        .inner-list li:before {
            font-size: 16px;
        }

        .inner-banner {
            padding: 100px 0 30px 0;
        }

        .inner-banner .row .col-md-7 {
            padding: 0 15px 35px 15px;
        }

        .inner-banner .row .col-md-5 {
            padding: 0 15px 0 15px;
        }

        .inner-banner-description h3 {
            width: auto;
        }

        .inner-img {
            margin: auto;
        }

        .salesforce-form h4 {
            padding: 20px 15px;
        }

        ul.banner-bottom-content {
            display: none;
        }

        .yr-text h3 {
            font-size: 20px;
            margin-bottom: 10px;
        }

        .yr-text h4 {
            font-size: 14px;
        }

        .years-content .row .col-md-4:not(:last-child) {
            margin: 0 0 35px;
        }

        .case-study .row .col-md-5.col-12, .case-study .row .col-md-7.col-12 {
            flex: 0 0 100%;
            max-width: 100%;
            padding: 0 15px;
        }

        .case-study .row .col-12:not(:last-child) {
            padding: 0px 15px 35px 15px;
        }

        /*.case-study .study-content .blue-btn {
            margin: 15px auto 0;
        }*/
        .bottom-bar ul li:not(:last-child) {
            padding: 0 16px 0 16px;
        }

        .bottom-bar ul li:nth-last-child(2) {
            border: unset;
        }

        .copyright ul {
            text-align: center;
            padding: 7px 0px;
        }

        .bottom-bar ul {
            flex-wrap: wrap;
        }

        .bottom-bar ul li a img {
            padding-top: 15px;
        }

        .inner-banner .row {
            padding: 0;
        }

        .study-img {
            padding: 0;
        }

        .inner-img {
            padding-top: 30px;
        }

        .banner-logo-img {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .bottom-bar ul li a {
            padding: 0;
        }

        button.navbar-toggler {
            display: none;
        }
    }
</style>



