<?php
/*
Template Name: sales CPQ
*/
get_header();
$themeData = get_fields();
/*echo "<pre>";
echo print_r($themeData);
echo "</pre>";*/
?>
<?php
if ( have_rows( 'salesforce_cpq_case_study_flexibility' ) ):
	while ( have_rows( 'salesforce_cpq_case_study_flexibility' ) ):
		the_row();
		?>
		<?php
		if ( get_row_layout() == 'banner' ):
			?>
            <section class="banner-salesforce spacing">
                <div class="blog_listwrap">
                    <div class="container h-100">
                        <div class="row align-items-start h-100">
                            <div class="col-md-6 col-12 order-md-1 order-0">
                                <div class="resources-banner-image">
									<?php
									$banner_image = get_sub_field( 'banner_image' )
									?>
                                    <img src="<?php echo $banner_image['url'] ?>"
                                         alt="<?php echo $banner_image['alt'] ?>">
                                </div>
                            </div>
                            <div class="col-md-6 col-12">
                                <div class="resources-banner-text">
                                    <h1><?php echo get_sub_field( 'heading' ) ?></h1>
									<?php
									echo get_sub_field( 'sub_heading' );
									?>
                                </div>
                            </div>
                        </div>
                        <div class="company-logos-slider">
							<?php
							$images = get_sub_field( 'image_repeater' );
							foreach ( $images as $key => $value ):
								?>
                                <a href="<?php echo ! empty ( $value['image_link']['url'] ) ? $value['image_link']['url'] : 'javascript:void(0)' ?>">
                                    <img src="<?php echo $value['image']['url'] ?>" alt="<?php echo $value['alt'] ?>"
                                         title="<?php echo $value['image']['title'] ?>"/></a>
							<?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </section>
		<?php
		endif;
		?>
		<?php
		if ( get_row_layout() == 'background_and_problem' ):
			?>
            <!--Background & Problem Statement-->
            <section class="problem-statement spacing">
                <div class="container">
                    <h2 class="heading-bg-black"><?php echo get_sub_field( 'heading' ); ?></h2>
                    <div class="row">
						<?php
						$sub_section1 = get_sub_field( 'sub_section_1' )
						?>
                        <div class="col-lg-5 col-md-5 col-12">
                            <div class="problem-img">
                                <img src="<?php echo $sub_section1['image']['url'] ?>"
                                     alt="<?php echo $sub_section1['image']['alt'] ?>">
                            </div>
                        </div>
                        <div class=" col-lg-6 col-md-6 col-12">
                            <div class="text-content">
								<?php
								echo $sub_section1['text_content'];
								?>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="text-content">
								<?php
								$sub_section2 = get_sub_field( 'sub_section_2' )
								?>
								<?php
								echo $sub_section2['text_content'];
								?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--Background & Problem Statement-->
		<?php
		endif;
		?>
		<?php
		if ( get_row_layout() == 'the_growth_natives_solution_1' ):
			?>
            <!--The Growth Natives Team’s Solution 1-->
            <section class="team-solution-1 spacing">
                <div class="container">
                    <h2 class="heading-bg-black"><?php echo get_sub_field( 'heading' ) ?></h2>
                    <div class="row">
                        <div class="col-lg-6 col-md-6 col-12">
                            <div class="text-content">
								<?php
								$sub_section1 = get_sub_field( 'sub_section_1' );
								echo $sub_section1['text_content']
								?>
                                <!--<p>
                                    Growth Natives team worked closely with the client to analyze their use-cases and
                                    business
                                    scenarios
                                    to cultivate the best solution for their brain technology business. Our team
                                    followed the Agile
                                    approach to design and development to create a customized solution for the client.
                                </p>
                                <p>
                                    Our team delivered the desired solution with the following process:
                                </p>-->
                            </div>
                        </div>
                        <div class=" col-lg-5 col-md-5  col-12">
                            <div class="team-img">
                                <img src="<?php echo $sub_section1['image']['url'] ?>"
                                     alt="<?php echo $sub_section1['image']['alt'] ?>">
                            </div>
                        </div>
                        <div class="col-lg-12">
							<?php
							echo get_sub_field( 'list' );
							?>
                        </div>
                    </div>
                </div>
            </section>
            <!--The Growth Natives Team’s Solution End-->
		<?php
		endif;
		?>
		<?php
		if ( get_row_layout() == 'the_growth_natives_solution_2' ):
			?>
            <!--The Growth Natives Team’s Solution-2-->
            <section class="team-solution-2 spacing">
                <div class="container">
                    <h2 class="heading-bg-black"><?php echo get_sub_field( 'heading' ) ?></h2>
					<?php
					if ( ! empty( get_sub_field( 'sub_heading' ) ) ):
						?>
                        <p><?php echo get_sub_field( 'sub_heading' ) ?></p>
					<?php
					endif;
					?>

                    <div class="row justify-content-center">
						<?php
						$cards = get_sub_field( 'card_repeater' )
						?>
						<?php
						foreach ( $cards as $value ):
							?>
                            <div class="col-lg-4 col-md-6">
                                <div class="card">
                                    <div class="card-image">
                                        <figure>
                                            <img src="<?php echo $value['icon']['url'] ?>"
                                                 alt="<?php echo $value['icon']['alt'] ?>">
                                        </figure>
                                    </div>
                                    <div class="card-body">
										<?php
										echo $value['text_content']
										?>
                                    </div>
                                </div>
                            </div>
						<?php
						endforeach;
						?>
                    </div>
                </div>
            </section>
            <!--The Growth Natives Team’s Solution End-->
		<?php
		endif;
		?>
		<?php
		if ( get_row_layout() == 'get_in_touch' ):
			?>
            <section>
                <div class="scale-brand">
                    <div class="container">
                        <div class="row align-items-center">
                            <div class="col-lg-10 col-md-12 col-sm-12 col-12">
                                <div class="scale-brand-text">
                                    <h3><?php echo get_sub_field( 'heading' ) ?></h3>
                                    <!--<p>Learn how you can take your marketing up a notch with our GrowthPod
                                        methodology.</p>-->
                                </div>
                            </div>
							<?php
							$button = get_sub_field( 'button_group' )
							?>
                            <div class="col-lg-2 col-md-12 col-sm-12 col-12">
                                <div class="scale-brand-button">
                                    <a href=""><?php echo $button['button_name'] ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- scale-brand ends -->
            </section>
		<?php
		endif;
		?>
	<?php
	endwhile;
endif;
?>

<?php
get_footer();
