<?php 
 /* Template Name: Web&mobile Development */ 

	get_header();
	$fieldsData = get_fields();
?>
<style>
/*web and mobile development page css Start */ 
.webdev-page .slider-dev {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 100%;
    height: 500px;
	text-align:center;
}
.webdev-page .slider-dev {
    text-align: center;
}
.webdev-page .slider-dev .slider-content-dev h1 {
    font-family: 'Roboto', sans-serif;
}
.lets-talk-dev a {
    color: #3FAC48;
    position: relative;
	cursor:pointer;
}
.lets-talk-dev a::after {
    content: '';
    background-image: url(https://growthnatives.com/wp-content/uploads/2021/03/feather-arrow-right.png);
    background-size: cover;
    width: 24px;
    height: 13px;
    position: absolute;
    right: -30px;
    top: 2px;
}
.lets-talk-dev {
    padding: 10px 0px;
}
.dev-clone {
    display: flex;
    width: 100%;
    align-items: center;
    height: 500px;
    background-color: #050505;
    background-position: center center;
    background-size: cover;
    background-repeat: no-repeat;
}
.web-page-content {
    color: #fff;
}
.webdev-page .sub-heading p {
    font-size: 16px;
    margin-bottom: 10px;
}
.qucik-points ul {
    padding: 0 15px;
}	
.qucik-points ul li{
	font-size:16px;
}
.dev-clone h2 {
    padding: 0 0 20px;
    color: #fff;
}
.dev-clone h3 {
    padding: 0 0 20px;
    color: #fff;
}
.tech-stack{
	background-color:#000000;
	color:#fff;
}
.space-develop{
	padding:50px 0px;
}
.sub-heading-devp h2 {
    padding: 0 0 15px;
}
.sub-heading-devp p {
    padding: 0 0 15px;
	width:55%;
}
.dev-clone:nth-child(odd) .row {
	flex-direction: column-reverse;
}
.tech-stack-outer {
    display: flex;
    flex-wrap: wrap;
    align-items: center;
    justify-content: space-around;
	padding: 30px 0 0;
}
.tech-stack-box {
    width: 15%;
    margin: 0 0 14px;
}
.tech-stack-box img {
    width: 100%;
    padding: 10px;
}
.Project-image-outer {
    background-position: center;
    background-size: cover;
    background-repeat: no-repeat;
    height: 500px;
    display: flex;
    align-items: center;
    padding: 0 50px;
}
#reacent-project .active .item{
  opacity:1;
  transform:scale(1);
} 
.project-info {
    width: 50%;
}
.project-info h4 {
    padding: 0px 0 15px;
}
.sub-info {
    padding: 0 0 15px;
}
.go-website {
    padding: 20px 0;
}
.go-website a {
    color:#fff;
}
.go-website a:hover {
    color:#3FAC48 ;
}
.owl-reacent {
    padding-top: 40px;
}
.lets-talk-dev a:hover {
    color: #006ea7;
}
#reacent-project .owl-nav button.owl-next, #reacent-project .owl-nav button.owl-prev, #reacent-project button.owl-dot {
    color: #44ab4d;
    border: 1px solid #44ab4d;
    width: 25px;
    border-radius: 20px;
    height: 25px;
    box-shadow: none;
	outline: none;
}
#reacent-project .owl-nav {
    width: 780px;
    margin: auto;
    text-align: left;
    max-width: 100%;
    margin-top: 20px;
}
#reacent-project .owl-nav button.owl-next:hover, #reacent-project .owl-nav button.owl-prev:hover {
    background: #007ebe;
    color: #ffffff;
    border-color: #007ebe;
}
.lets-talk-dev a:hover {
    color: #007ebe;
}
#reacent-project .go-website a{
	position:relative;
}
/*#reacent-project .go-website a::after {
    content: '';
    background-image: url(https://growthnatives.com/wp-content/uploads/2021/03/Icon-feather-arrow-right.png);
    background-size: cover;
    width: 24px;
    height: 13px;
    position: absolute;
    right: -30px;
    top: 2px;
}*/
.page-id-3237 .button-web {
    display: none;
}
@media screen and (max-width:767px) {
	.tech-stack-box {
		width: 50%;
		text-align: center;
	}
	.tech-stack-box img {
    width: 80%;
}
.sub-heading-devp p {
    font-size: 15px;
    width: 100%;
}
.webdev-page .slider-dev .slider-content-dev h1 {
    font-size: 22px;
}
.Project-image-outer {
    height: 100%;
    overflow: hidden;
    padding: 0px 10px;
}
.project-info {
    width: 100%;
    padding: 15px 0;
}
.Project-image-outer {
    background: #1077af;
}
}
/*web and mobile development page css End */ 
</style>
<div class="site_wrap">
	<div class="webdev-page">
		<!--==Slider section===-->
		<section class="slider-dev">
			<div class="container">
				<div class="row">
					<div class="col-md-12"> 
						<div class="slider-content-dev">
							<h1><?php the_field('slider_content'); ?></h1>
						</div>
						<div class="lets-talk-dev">
							<a href="<?php the_field('lets_talk_url'); ?>"><?php the_field('lets_talk_content'); ?></a>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!--==Slider section end==-->
		<!--==Web Development Services section===-->
		<?php foreach( $fieldsData['web_services_repeate'] as $web_services_repeate ): ?>
		<section class="web-development-services dev-clone" style="background-image:url('<?php echo $web_services_repeate['service_background_image']['url']?>');">
			<div class="container">
				<div class="row">
					<div class="col-md-6 col-sm-12 col-xs-12">
					</div>
					<div class="col-md-6 col-sm-12 col-xs-12">
						<div class="web-page-content">
							<h2><?php echo $web_services_repeate['service_heading']; ?></h2>
							<div class="sub-heading">
							<?php echo $web_services_repeate['service_paragraph']; ?>
								
							</div>
							<div class="qucik-points">
							<?php echo $web_services_repeate['service_points']; ?>
								
							</div>
							<div class="lets-talk-dev button-web">
								<a href="<?php echo $web_services_repeate['service_page_url']; ?>"><?php echo $web_services_repeate['button_text']; ?></a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<?php endforeach; ?>
		<!--==Web Development Services section end===-->
		<!--==Tech Stack section ===-->
		<section class="tech-stack space-develop">
			<div class="container">
				<div class="row">
					<div class="col-md-12">
						<div class="sub-heading-devp">
							<h2><?php the_field('tech_stack_heading'); ?> </h2>
							<?php the_field('tech_stack_paragraph'); ?>
							
						</div>
					</div>
					<div class="tech-stack-outer">
						<?php foreach( $fieldsData['tech_stack_images'] as $tech_stack_images ): ?>
							<div class="tech-stack-box">
								<figure>
									 <img  src="<?php echo $tech_stack_images['tech_stack_images']['url']?>" alt="<?php echo $tech_stack_images['tech_stack_images']['alt']?>" title="<?php echo $tech_stack_images['tech_stack_images']['title']?>">
									
								</figure>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
			
		</section>
		<!--==Tech Stack section end ===-->
		<!--==Recent Web Development Projects section ===-->
		<section class="tech-stack space-develop">
			<div class="container">
				<div class="row">
					<div class="col-md-12">
						<div class="sub-heading-devp">
							<h2><?php the_field('recent_project_heading'); ?> </h2>
							<?php the_field('recent_project_paragraph'); ?>
							
						</div>
					</div>
				</div>
			</div>
			<div class="owl-reacent">
				<div class="owl-carousel owl-theme" id="reacent-project">
					<?php foreach( $fieldsData['recent_project_repeat'] as $recent_project_repeat ): ?>
						<div class="item">
							<div class="Project-image-outer" style="background-image:url('<?php echo $recent_project_repeat['recent_project_background_image']['url']?>');">
								<div class="project-info">
									<h4><?php echo $recent_project_repeat['project_heading']; ?></h4>
									<p class="sub-info" ><?php echo $recent_project_repeat['project_sub_heading']; ?></p>
									<?php echo $recent_project_repeat['project_information']; ?>
									
									<div class="go-website">
										<a href="<?php echo $recent_project_repeat['website_url']; ?>" target="_blank" ><?php echo $recent_project_repeat['button_label']; ?> <span><?php echo $recent_project_repeat['arrow_pointer']; ?></span></a>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
		</section>
		<!--==Recent Web Development Projects section ===-->
		
<!-- Our Customers Love Us -->
<section class="section bg_client">
    <div class="container">
        <div class="row">
            <div class="col-md-12 heading text-center">
                <h2><?php echo  get_field('our_customer_loves_us_title');?></h2>
            </div>
        </div>
		<div class="owl-carousel owl-theme" id="owl-client-slider">
            <?php  $clientSay = get_field('our_customer_loves_us_detail'); 
              foreach ($clientSay as $cst) {  ?>
            <div class="item">
				<div class="row">
					<div class="col-lg-3 col-md-12 col-sm-12 col-12 offset-lg-1 p-0">
						<div class="client-image">
							<img src="<?php  echo $cst['image']['url']; ?>" alt="<?php  echo $cst['image']['alt']; ?>">
						</div>
                        <?php if(isset($cst['video_url']) && !empty($cst['video_url'])) { ?>
						<div class="play-icon">
							<a id="play-video" class="popup-youtube video-play-button" href="<?php  echo $cst['video_url']; ?>"><span></span></a>
						</div>
                        <?php } ?>
					</div>
					<div class="col-lg-7 col-md-12 col-sm-12 col-12 client-outer">
						<div class="client-say">
							<p><?php  echo $cst['review']; ?></p>
							<h5 class="pt-2 pb-2"><?php  echo $cst['name']; ?></h5>
							<a href="<?php  echo $cst['website']; ?>" target="_blank"><?php  echo $cst['website']; ?></a>
						</div>
					</div>
				</div>
			</div>
          <?php  }  ?>
		</div>
	</div>
</section>
	</div>
</div>


<?php get_Footer(); ?>
