<?php
/*
Template Name: Testimonial LP
*/
get_header();
?>
<style>
    /**************************** Google fonts import ****************************/
    @import url('https://fonts.googleapis.com/css2?family=Roboto&display=swap');
    @import url('https://fonts.googleapis.com/css2?family=Roboto+Condensed&display=swap');


    body,
    html {
        margin-top: 0;
        padding: 0 !important;
        width: 100%;
        height: 100%;
        outline: none;
        font-family: 'Roboto', sans-serif;
    }

    h1 {
        font-size: 44px;
        margin: 0;
        position: relative;
    }

    h2 {
        font-size: 34px;
        margin: 0;
    }

    h3 {
        font-size: 30px;
        margin: 0;
    }

    h4 {
        font-size: 28px;
        margin: 0;
    }

    h5 {
        font-size: 20px;
        margin: 0;
    }

    h6 {
        font-size: 18px;
        margin: 0;
    }

    p {
        font-size: 18px;
        margin: 0;
    }

    ul {
        padding: 0;
        margin: 0;
    }

    li {
        font-size: 18px;
        list-style: none;
    }

    /* color-css starts */

    .blue-btn, .white-btn, .grey-btn {
        padding: 0;
        border: none;
        margin: 100px auto 0;
        display: flex;
        background: none;
        align-items: center;
        justify-content: center;
        width: auto;
    }

    .blue-btn a, .white-btn a {
        text-decoration: none;
        font-size: 18px;
        border: 2px solid #fff;
        border-radius: 26px;
        padding: 10px 30px;
        color: #fff;
        font-weight: 500;
        transition: 0.3s all;
        display: block;
    }

    .grey-btn a {
        text-decoration: none;
        font-size: 18px;
        border: 2px solid #7B7B7B;
        border-radius: 26px;
        padding: 10px 30px;
        color: #7B7B7B;
        font-weight: 500;
        transition: 0.3s all;
    }

    .grey-btn:hover a {
        background: #7B7B7B;
        border-color: #7B7B7B;
        transition: 0.3s all;
        color: #fff;
    }

    .blue-btn:hover a {
        background: #007EBF;
        border-color: #007EBF;
        transition: 0.3s all;
    }

    .white-btn:hover a {
        color: #1E1E20;
        background: #fff;
        border-color: #fff;
        transition: 0.3s all;
    }

    .blue-green-gradient {
        background: -webkit-linear-gradient(#007ebf, #41ad49);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }

    .color-white {
        color: #fff;
    }

    .color-dark-grey {
        color: #1E1E1E;
    }

    .color-light-grey {
        color: #C7C7C7;
    }

    .color-grey {
        color: #6E6E6E;
    }

    .color-blue {
        color: #007EBF;
    }

    .color-black {
        color: #000;
    }

    .bg-black {
        background-color: #000;
    }

    .bg-grey {
        background: #1E1E1E;
    }

    .bg-light-grey {
        color: #1e1e1e7d;
    }

    .bg-white {
        color: #fff;
    }


    .heading {
        font-weight: 700;
        text-align: center;
        margin: 0 0 30px 0;
    }

    .paragraph {
        font-weight: 400;
        margin: 0 0 50px 0;
        text-align: center;
    }

    .bg-black {
        color: #000;
    }

    .spacing {
        padding: 100px 0;
    }

    /*header starts*/
    /*   .header ul {
           display: flex;
           align-items: center;
           justify-content: unset;
       }

       .header ul li:not(:last-child) {
           padding: 0 50px 0 0;
       }

       .header ul li a {
           font-size: 25px;
       }*/

    /*header ends */


    /*    banner starts */
    .inner-banner {
        position: relative;
        height: auto;
        padding: 220px 0 150px 0;
    }

    .inner-banner .container {
        position: relative;
    }

    .inner-banner-content h1 {
        font-weight: 700;
        padding: 0 0 30px;
    }

    .inner-banner-content h1:after {
        content: '';
        position: absolute;
        width: 60px;
        height: 5px;
        bottom: 0;
        background: #007EBF;
        left: 0;
        border-radius: 2px;
    }

    .inner-banner-description p {
        padding: 30px 0 50px;
        font-size: 22px;
        width: 77%;
    }

    .inner-banner .row {
        padding: 0;
        align-items: center;
    }


    .inner-banner-description h3 {
        width: 570px;
    }

    .inner-list {
        padding: 30px 0 0 0;
    }

    .inner-list li {
        font-size: 22px;
        position: relative;
        padding: 0 0 15px 20px;
    }

    .inner-list li:last-child {
        padding-bottom: 0;
    }

    .inner-list li:before {
        content: '\f101';
        position: absolute;
        top: 0;
        left: 0;
        font-size: 20px;
        color: #007EBF;
        font-family: FontAwesome;
    }

    .inner-img {
        padding-top: 50px;
        width: 180px;
    }

    .inner-img:nth-of-type(2n) {
        width: 120px;
    }

    .inner-img img {
        width: 100%;
    }

    ul.banner-bottom-content {
        display: flex;
        align-items: center;
        justify-content: space-between;
        position: absolute;
        bottom: 0;
        width: 100%;
        left: 0;
    }

    .banner-logo-img {
        align-items: center;
        display: flex;
        justify-content: start;
    }

    .banner-logo-img .inner-img:first-child {
        padding: 50px 0px 0 0;
        margin: 0 50px 0 0;
    }

    .sticky_button .btn_design {
        display: none;
    }

    .salesforce-form {
        background: #1d1d1d;
        border-radius: 20px;
        box-shadow: 0px 10px 70px #000000;
    }

    .salesforce-form h4 {
        background-color: #000;
        border-top-left-radius: 20px;
        border-top-right-radius: 20px;
        text-align: center;
        padding: 30px 35px;
    }

    .salesforce-form .hbspt-form {
        padding: 20px 30px 50px;
    }

    .study-content.bg-grey {
        padding: 70px 80px 70px 50px;
        max-height: 100%;
        height: 100%;
        border-radius: 6px;
    }

    /*    banner ends */

    /*process starts*/

    .process .process-card .card {
        height: 100%;
        max-height: initial;
        max-width: initial;
        background-color: transparent;
        width: 100%;
        margin: auto;
        padding: 0;
        text-align: center;
    }

    .process .row .col-md-4.col-12:last-child .card, .process .row .col-md-4.col-12:nth-last-child(2) .card,
    .process .row .col-md-4.col-12:nth-last-child(3) .card {
        padding: 0;
    }

    .process-card .card-img {
        width: 200px;
        margin: auto;
    }

    .process-card .card-body {
        padding: 0;
    }

    .process-card .card-img img {
        width: 100%;
    }

    .process .process-card .card h4 {
        width: 100%;
        margin: auto;
        text-transform: capitalize;
        font-weight: 700;
    }

    /* process ends */

    /* yr text  */
    .yr-text {
        text-align: center;
    }

    .yr-text h3 {
        font-size: 60px;
        margin: 0 0 20px 0;
        font-weight: 700;
    }

    .yr-text h4 {
        font-weight: 400;
    }


    /*case study starts*/
    .study-content h3 {
        text-align: left;
        font-weight: 500;
    }

    .study-content p {
        text-align: left;
        font-weight: 400;

    }

    .case-study .row {
        padding: 0;
        justify-content: space-between;
        align-items: stretch;
    }

    .case-study .study-content .blue-btn {
        margin: 0;
        justify-content: start;
        width: auto;
        display: inline-block;
    }


    .study-img {
        width: auto;
        padding: 0 10px 0 0;
    }

    .case-study .row .col-md-5.col-12 {
        padding: 0 15px 0 0;
    }

    .case-study .row .col-md-7.col-12 {
        padding: 0 0 0 15px;
    }


    .study-img img {
        width: 100%;
    }

    /*case study ends*/
    /*bottom bar starts*/
    .bottom-bar {
        padding: 20px 0;
        border: 1px solid #1E1E20;
    }

    .bottom-bar ul {
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .bottom-bar ul li {
        padding: 0 30px;
    }

    .bottom-bar ul li:not(:last-child) {

        border-right: 1px solid #1E1E20;
    }

    .bottom-bar ul li a {
        padding: 7px 25px 6px 25px;
        text-decoration: none;
        font-size: 14px;
    }

    .bottom-bar ul li a:hover {
        background: -webkit-linear-gradient(#007ebf, #41ad49);
        -webkit-background-clip: text;
        transition: all 0.5s;
        -webkit-text-fill-color: transparent;
    }

    .copyright {
        padding: 15px 0;
    }

    .copyright p {
        font-size: 14px;
    }

    .copyright ul {
        text-align: right;
        margin-bottom: 0;
        padding: 0;
    }

    .copyright ul li {
        list-style: none;
        display: inline-block;
        font-size: 15px;
        margin-right: 12px;
    }

    /*bottom bar ends*/


    /*   salesforce */

    /*    testimonial starts */
    .inner-banner .blue-btn {
        margin: 0;
        justify-content: left;
        outline: unset;
    }

    .modal-content {

        width: auto;
    }

    .testimonial-banner-img {
        text-align: center;
    }

    div#youtube-modal {
        padding-right: 0;
    }

    #youtube-modal .modal-dialog {
        max-width: 85%;
        justify-content: center;
        margin: 1.75rem auto;
        top: 20px;
    }

    .play-button:focus-visible, .play-button:focus {
        outline: none;
    }

    .card-video {
        height: 415px;
        padding: 10px;
        border-radius: 8px;
        background: #1E1E20;
    }

    .max-content {
        width: 100%;
        max-width: 75%;
        line-height: 1.5;
        margin: 0 auto 50px;
    }

    iframe {
        border-radius: 8px;
    }

    }
    /****************************happy clients starts****************************/


    .happy-client .container {
        position: relative;
    }

    .happy-client .container {
        position: relative;
    }

    .happy-client {
        background-color: #1E1E20;
        position: relative;
    }

    .happy-client .happy-client-carousel .row {
        padding-left: 0;
        border-radius: 20px;
        margin: 16px;
        box-shadow: 0 3px 19px 3px #000000;
    }


    .client-text {
        padding: 22px 30px 22px 70px;
        align-items: center;
        position: relative;
    }

    .client-play-button {
        position: relative;
        height: 100%;
    }

    .client-img {
        width: auto;
        overflow: hidden;
        border-radius: 8px;
        height: 100%;
    }

    .client-img img {
        object-fit: cover;
        height: 100%;
        width: 100%;
        transition: 0.5s all ease-in-out;
    }

    .client-img img:hover {
        transform: scale(1.1);
    }

    .play-button {
        position: absolute;
        top: 50%;
        right: 0;
        transform: translate(50%, -50%);
        z-index: 99;
        width: 150px;
        text-align: center;
    }


    .happy-client .heading-bg-black {
        font-weight: 700;
        text-align: center;
        margin: 0;
    }

    .quote-img {
        position: absolute;
        top: 5%;
        right: 0;
    }

    .happy-client-carousel .item {
        margin: 0;
        overflow: hidden;
        background: #1E1E20 0% 0% no-repeat padding-box;
        border-radius: 10px;
    }

    .happy-client p {
        font-size: 20px;
    }

    .happy-client h5 {
        font-size: 24px;
        letter-spacing: 2.8px;
        text-transform: uppercase;
        font-weight: bold;
        padding-top: 30px;
    }

    .happy-client a {
        font-size: 16px;
        letter-spacing: 1.8px;
        font-weight: bold;
        text-transform: uppercase;
        text-decoration: none;
        padding-top: 5px;
        display: block;
    }

    .happy-client a:hover {
        color: #c7c7c7;
    }

    .happy-client-carousel .owl-theme .owl-nav.disabled + .owl-dots {
        margin-top: 100px;
    }

    .happy-client-carousel {
        margin: 0 auto;
        max-width: 1200px;
        width: 100%;
        padding-top: 100px;
    }

    .happy-client .owl-theme .owl-dots .owl-dot.active span, .owl-theme .owl-dots .owl-dot:hover span {
        background: #007EBF !important;
        opacity: 1;
    }

    .happy-client .owl-theme .owl-dots .owl-dot span {
        background: #007EBF !important;
        opacity: 0.4;
    }

    .happy-client-carousel {
        margin: 0 auto;
        max-width: 100%;
        width: 100%;
        padding-top: 54px;
    }

    #youtube-modal .btn-close {
        position: absolute;
        right: -22px;
        z-index: 666666;
        font-size: 13px;
        top: -22px;
        padding: 15px;
        border-radius: 30px;
        background: transparent url("data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='white'><path d='M.293.293a1 1 0 011.414 0L8 6.586 14.293.293a1 1 0 111.414 1.414L9.414 8l6.293 6.293a1 1 0 01-1.414 1.414L8 9.414l-6.293 6.293a1 1 0 01-1.414-1.414L6.586 8 .293 1.707a1 1 0 010-1.414z'/></svg>") center/1em auto no-repeat;
        background-color: #000;
        transform: translate(0);
        border: 1px solid #fff;
    }

    .happy-client-carousel .owl-carousel {
        display: block;
        width: 100%;
        z-index: 1;
    }

    #youtube-modal .modal-dialog {
        max-width: 85%;
        margin: 1.75rem auto;
    }

    #youtube-video {
        border-radius: 0;
    }

    #youtube-modal .modal-body {
        padding: 0;
        line-height: 0;
        width: 75vw;
        height: 80vh;
    }

    #youtube-modal .modal-body iframe {
        width: 100%;
        height: 100%;
    }

    footer.section.outer_footer, .outer_bottom {
        display: none;
    }

    .happy-client-carousel .item .row .col-md-4, .happy-client-carousel .item .row .col-md-8 {
        padding: 0;
    }

    .quote-img svg {
        width: 83px;
        margin: 0 26px 0 0;
    }

    /**************************** happy client ends ****************************/

    /****************************audit section ****************************/
    .scale-brand {
        background: transparent linear-gradient(90deg, #007EBF 0%, #007FBF 29%, #0087AB 34%, #008F97 41%, #009585 47%, #009C74 54%, #22A164 61%, #32A657 69%, #3CAA4E 77%, #40AC4A 87%, #41AD49 100%) 0% 0% no-repeat padding-box;
        padding: 50px 0;
    }

    .scale-brand .row {
        align-items: center;
    }

    .scale-brand-text h4 {
        text-align: left;
        text-transform: capitalize;
        letter-spacing: 3.6px;
        font-family: 'Roboto';
        font-weight: bold;
    }

    .scale-brand-text p {
        font-size: 20px;
        text-align: left;
        letter-spacing: unset;
        padding-top: 15px;  
    }

    .scale-brand .white-btn {
        justify-content: end;
        margin: 0;
    }

    button.owl-dot:active, button.owl-dot:focus {
        outline: unset;
    }

    /****************************.scale-brand-button a {
		color: #fff;
		background-color: transparent;
		text-transform: capitalize;
		text-align: center;
		border: 2px solid #FFFFFF;
		border-radius: 26px;
		padding: 12px 30px;
		font-size: 18px;
		margin-top: 0;
	}

	.scale-brand-button a:hover {
		background-color: #fff;
		color: #000000;
	}****************************/


    /****************************audit section ends ****************************/


    /*    testimonial ends */


</style>
<!--header starts -->
<header class="header">

    <nav class="navbar navbar-expand-lg navbar-light fixed-top main_nav landing_for">
        <div class="container">

            <a class="navbar-brand" href="https://growthnatives.com">
                <img src="https://growthnatives.com/wp-content/uploads/2020/01/logo.png" alt="logo">
            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav"
                    aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

        </div>
    </nav>

</header>
<!--header ends -->

<!-- banner starts -->
<section class="inner-banner bg-grey">
    <div class="container">
        <div class="row">
            <div class="col-md-7 col-12">
                <div class="inner-banner-content color-white">
                    <h1 class="color-blue">Let Us Tell Your Brand Story</h1>
                </div>
                <div class="inner-banner-description ">
                    <p class="color-light-grey">We feel truly a pioneer in our industry when we empower other businesses
                        to embrace success.</p>
                </div>
                <!--    <button class="blue-btn">
						<a href="https://growthrevamp.demandtech.org/contact-us/" target="_self">
							Lorem ipsum </a>
					</button>-->


            </div>

            <div class="col-md-5 col-12" id="scroll-top-form">
                <div class="testimonial-banner-img">
                    <img src="https://growthnatives.com/wp-content/uploads/2022/07/Rating.png" alt="">
                </div>
            </div>
        </div>

    </div>
</section>
<!-- banner ends -->


<!-- Process With CPQ starts -->
<section class="process bg-black spacing">
    <div class="container">
        <div class="content">
            <h2 class="heading color-white">
                What Our Cherished Customers Say
            </h2>
            <h5 class="paragraph color-light-grey max-content">Our holistic approach to transforming your digital
                journey is futile without it producing the desired results for you. Fortunately, favorable results are
                one of our strong suits.</h5>
        </div>
        <div class="growth-card">
            <div class="row">

                <div class="col-md-6 col-12">
                    <div class="process-card">
                        <div class="card">
                            <div class="card-video">
                                <iframe style="width: 100%; height: 100%;"
                                        src="https://www.youtube.com/embed/g7KkkfHE9lc"
                                        title="ImageWare | Growth Natives" frameborder="0"
                                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                        allowfullscreen></iframe>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-12">
                    <div class="process-card">
                        <div class="card">
                            <div class="card-video">
                                <iframe style="width: 100%; height: 100%"
                                        src="https://www.youtube.com/embed/9ep5nxtP_oU"
                                        title="Gander Group | Growth Natives Customer Success Story | Development & Marketing"
                                        frameborder="0"
                                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                        allowfullscreen></iframe>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>
</section>
<!-- Process With CPQ ends -->

<!-- happy clients starts-->

<div class="happy-client spacing">
    <div class="container">
        <div class="row">
            <div class="col col-xs-12">
                <div class="happy-client-heading text-center text-white">
                    <h2 class="heading color-white">Our Happy Clients</h2>
                </div>
            </div>
        </div>
        <div class="quote-img">
            <svg xmlns="http://www.w3.org/2000/svg" width="97.457" height="83.536" viewBox="0 0 97.457 83.536">
                <path id="Union_10" data-name="Union 10"
                      d="M-12116.312-7288.6a27.878,27.878,0,0,0,27.849-27.843h-27.849v-41.767h41.77v41.767a41.814,41.814,0,0,1-41.77,41.77Zm-55.687,0a27.872,27.872,0,0,0,27.843-27.843H-12172v-41.767h41.766v41.767a41.813,41.813,0,0,1-41.766,41.77Z"
                      transform="translate(12172 7358.21)" fill="#444446"></path>
            </svg>

        </div>

        <div class="happy-client-carousel">
            <div class="owl-carousel owl-theme owl-loaded owl-drag" id="happy-client-carousel">
                <div class="item">
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="client-play-button">
                                <div class="client-img">
                                    <img alt="Happy Client"
                                         data-src="https://growthnatives.com/wp-content/uploads/2022/05/Jeremy-Young.jpg"
                                         class="lazyload"
                                         src="https://growthnatives.com/wp-content/uploads/2022/05/Jeremy-Young.jpg">
                                </div>
                                <div class="play-button">
                                    <a href="javascript:void(0)" data-toggle="modal" data-target="#youtube-modal"
                                       datayoutube="//www.youtube.com/embed/9ep5nxtP_oU?autoplay=1">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             xmlns:xlink="http://www.w3.org/1999/xlink" width="146"
                                             height="146" viewBox="0 0 146 146">
                                            <defs>
                                                <filter id="Ellipse_12" x="0" y="0" width="146"
                                                        height="146" filterUnits="userSpaceOnUse">
                                                    <feOffset dy="10" input="SourceAlpha"></feOffset>
                                                    <feGaussianBlur stdDeviation="10"
                                                                    result="blur"></feGaussianBlur>
                                                    <feFlood flood-color="#2a2a2a"
                                                             flood-opacity="0.161"></feFlood>
                                                    <feComposite operator="in" in2="blur"></feComposite>
                                                    <feComposite in="SourceGraphic"></feComposite>
                                                </filter>
                                            </defs>
                                            <g id="Vid-Icon" transform="translate(30 20)">
                                                <g transform="matrix(1, 0, 0, 1, -30, -20)"
                                                   filter="url(#Ellipse_12)">
                                                    <circle id="Ellipse_12-2" data-name="Ellipse 12"
                                                            cx="43" cy="43" r="43"
                                                            transform="translate(30 20)" fill="#fff"
                                                            style="opacity: 0.4;"></circle>
                                                </g>
                                                <path id="Polygon_1" data-name="Polygon 1"
                                                      d="M17.177,7.44a5,5,0,0,1,8.646,0L38.635,29.488A5,5,0,0,1,34.312,37H8.688a5,5,0,0,1-4.323-7.512Z"
                                                      transform="translate(68 22) rotate(90)"
                                                      fill="#000000"></path>
                                            </g>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                            <div class="client-text">
                                <p class="color-light-grey">“Have been working with Growth Natives for
                                    several years and they have helped us tremendously in developing web
                                    applications, giving us great full-stack marketing services such as SEO
                                    and Digital Marketing that are top-notch. They are very kind people and
                                    always responsive, staying up until the wee hours of the night to have
                                    conference calls with us on the Pacific, West Coast. I highly recommend
                                    them for anything that you need in terms of programming skills,
                                    scripting, web development, and SEO services.”
                                </p>
                                <h5 class="color-blue">Jeremy Young</h5>
                                <a class="color-blue" href="https://gandergroup.com/" target="_blank">Gander Group</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="client-play-button">
                                <div class="client-img">
                                    <img alt="Happy Client"
                                         data-src="https://growthnatives.com/wp-content/uploads/2022/05/Kevin-Fliess.jpg"
                                         class="lazyload"
                                         src="https://growthnatives.com/wp-content/uploads/2022/05/Kevin-Fliess.jpg">
                                </div>
                                <div class="play-button">
                                    <a href="javascript:void(0)" data-toggle="modal" data-target="#youtube-modal"
                                       datayoutube="//www.youtube.com/embed/Ww-_rW6w0pg?autoplay=1">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             xmlns:xlink="http://www.w3.org/1999/xlink" width="146"
                                             height="146" viewBox="0 0 146 146">
                                            <defs>
                                                <filter id="Ellipse_12" x="0" y="0" width="146"
                                                        height="146" filterUnits="userSpaceOnUse">
                                                    <feOffset dy="10" input="SourceAlpha"></feOffset>
                                                    <feGaussianBlur stdDeviation="10"
                                                                    result="blur"></feGaussianBlur>
                                                    <feFlood flood-color="#2a2a2a"
                                                             flood-opacity="0.161"></feFlood>
                                                    <feComposite operator="in" in2="blur"></feComposite>
                                                    <feComposite in="SourceGraphic"></feComposite>
                                                </filter>
                                            </defs>
                                            <g id="Vid-Icon" transform="translate(30 20)">
                                                <g transform="matrix(1, 0, 0, 1, -30, -20)"
                                                   filter="url(#Ellipse_12)">
                                                    <circle id="Ellipse_12-2" data-name="Ellipse 12"
                                                            cx="43" cy="43" r="43"
                                                            transform="translate(30 20)" fill="#fff"
                                                            style="opacity: 0.4;"></circle>
                                                </g>
                                                <path id="Polygon_1" data-name="Polygon 1"
                                                      d="M17.177,7.44a5,5,0,0,1,8.646,0L38.635,29.488A5,5,0,0,1,34.312,37H8.688a5,5,0,0,1-4.323-7.512Z"
                                                      transform="translate(68 22) rotate(90)"
                                                      fill="#000000"></path>
                                            </g>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                            <div class="client-text">
                                <p class="color-light-grey">“Growth Natives has been an excellent partner as
                                    I could rebuild our entire web strategy and go-to-market motion. They
                                    deployed HubSpot and have been great partners on the WordPress side.
                                    Thanks to their collaborative approach and the work they have done with
                                    me and for me, we could successfully 3x-4x our lead generation in a very
                                    cost-effective manner. I like to think of Growth Natives as my secret
                                    weapon for they are technically adept, responsive, and an extension of
                                    your team. I plan to work with them in the future as well.”
                                </p>
                                <h5 class="color-blue">Kevin Fliess</h5>
                                <a class="color-blue" href="https://altum.com/" target="_blank">Altum</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="client-play-button">
                                <div class="client-img">
                                    <img alt="Happy Client"
                                         data-src="https://growthnatives.com/wp-content/uploads/2022/05/Tarj-1-1.png"
                                         class=" ls-is-cached lazyloaded"
                                         src="https://growthnatives.com/wp-content/uploads/2022/05/Tarj-1-1.png">
                                </div>
                                <div class="play-button">
                                    <a href="javascript:void(0)" data-toggle="modal" data-target="#youtube-modal"
                                       datayoutube="">
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                            <div class="client-text">
                                <p class="color-light-grey">“We were looking for an experienced company that
                                    had expertise in all aspects of marketing and Growth Natives have
                                    surpassed all expectations, delivering tremendous results. They took the
                                    time to understand our business needs and tailored a package suitable
                                    for our eCommerce platform. Our revenue went up 52% within the first 30
                                    days, our organic traffic and rankings improved significantly.”
                                </p>
                                <h5 class="color-blue">Dr. Tarj Mavi</h5>
                                <a class="color-blue" href="http://lamav.com/" target="_blank">LAMAV.COM</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="client-play-button">
                                <div class="client-img">
                                    <img alt="Happy Client"
                                         data-src="https://growthnatives.com/wp-content/uploads/2022/05/Mike-Mayhew.png"
                                         class=" ls-is-cached lazyloaded"
                                         src="https://growthnatives.com/wp-content/uploads/2022/05/Mike-Mayhew.png">
                                </div>
                                <div class="play-button">
                                    <a href="javascript:void(0)" data-toggle="modal" data-target="#youtube-modal"
                                       datayoutube="">
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                            <div class="client-text">
                                <p class="color-light-grey">“Growth Natives was instrumental in identifying
                                    solutions for Lightspeed that allow us to improve the client experience
                                    while maintaining control over sensitive data that our clients entrust
                                    us to secure. We look forward to evolving our HubSpot solution with
                                    Growth Natives.”
                                </p>
                                <h5 class="color-blue">Mike Mayhew</h5>
                                <a class="color-blue" href="#">Lightspeed CTO</a>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </div>

    </div>
</div>


<!-- happy clients ends-->


<!--scale brand starts-->
<div class="scale-brand">
    <div class="container">
        <div class="row">
            <div class="col-lg-9 col-md-12 col-sm-12 col-12">
                <div class="scale-brand-text">
                    <h4 class="color-white">Schedule a 30-Minute Quick Consultation Today</h4>
                    <p class="color-white">Let’s discuss your pain points and how we can catapult your business to the
                        next level.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-12 col-sm-12 col-12">
                <div class=" white-btn">
                    <a href=" https://meetings.hubspot.com/taran8" target="_blank">Book A Consultation Now</a>
                </div>
            </div>
        </div>
    </div>
</div>
<!--scale brand ends-->


<!--bottom bar starts-->
<section class="bottom-bar color-white bg-black">
    <div class="container">
        <ul>
            <li>
                <a class="color-white" href="https://growthnatives.com/lets-talk/">Contact Us </a>
            </li>
            <li>
                <a class="color-white" href="https://growthnatives.com/resources/">Blogs</a>
            </li>
            <li>
                <a class="color-white" href="https://growthnatives.com/growth-natives-tcs/">Terms & Conditions </a>
            </li>

            <li>
                <a href="https://www.dmca.com/Protection/Status.aspx?ID=639f9bc7-120f-4893-ae6b-66cc4a2e041d&amp;refurl=https://growthnatives.com/growth-natives-tcs/">
                    <img src="https://growthnatives.com/wp-content/uploads/2022/05/dmca.png" alt="DMCA Protected">
                </a>
            </li>
        </ul>
    </div>
</section>
<!--bottom bar ends-->

<!--copyright starts-->
<section class="copyright color-white bg-grey">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-8 col-xs-12">
                <p class="color-white">Copyright © 2022 Growth Natives. All rights reserved.</p>
            </div>
            <div class="col-md-4 col-xs-12">
                <ul>
                    <li class="color-white">Follow Us:</li>
                    <li>
                        <a class="color-white" target="self" href="https://www.facebook.com/growthnatives">
                            <i class="fa fa-facebook" aria-hidden="true"></i> </a>
                    </li>
                    <li>
                        <a class="color-white" target="self" href="https://twitter.com/GrowthNatives">
                            <i class="fa fa-twitter" aria-hidden="true"></i> </a>
                    </li>
                    <li>
                        <a class="color-white" target="self"
                           href="https://www.linkedin.com/company/growthnatives/mycompany/verification/">
                            <i class="fa fa-linkedin" aria-hidden="true"></i> </a>
                    </li>
                    <li>
                        <a class="color-white" target="self" href="https://www.instagram.com/growthnatives/">
                            <i class="fa fa-instagram" aria-hidden="true"></i> </a>
                    </li>
                </ul>

            </div>
        </div>
    </div>
</section>
<!--copyright ends-->

<!--modal starts-->
<div class="modal fade" id="youtube-modal" data-keyboard="false" tabindex="-1" aria-labelledby="youtube-modal"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close"></button>
            <div class="modal-body">
                <iframe id="youtube-video" src="" title="YouTube video player"
                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                        allowfullscreen="" frameborder="0"></iframe>
            </div>
        </div>
    </div>
</div>

<!--modal ends-->

<style>
    @media screen and (max-width: 1650px) {

        h1 {
            font-size: 36px;
            margin: 0;
        }

        h2 {
            font-size: 28px;
            margin: 0;
        }

        h3 {
            font-size: 26px;
            margin: 0;
        }

        h4 {
            font-size: 24px;
            margin: 0;
        }

        h5 {
            font-size: 18px;
            margin: 0;
        }

        h6 {
            font-size: 16px;
            margin: 0;
        }

        p {
            font-size: 16px;
            margin: 0;
        }

        .spacing {
            padding: 85px 0;
        }

        .heading {
            text-align: center;
        }

        .paragraph {
            margin: 0 auto 50px;
        }

        .blue-btn a {
            font-size: 16px;
        }


        .inner-banner {
            padding: 160px 0 85px 0;
        }

        .inner-banner-description p {
            font-size: 20px;
            width: auto;
        }

        .inner-list li {
            font-size: 20px;
        }

        .process-card .card-img {
            width: 150px;
        }

        .process .card-body {
            padding: 0;
        }

        .yr-text h3 {
            font-size: 45px;
        }

        .study-content.bg-grey {
            padding: 50px 40px;
            min-height: auto;
        }

        .case-study .row {
            padding: 0;
        }

        li {
            font-size: 14px;
            list-style: none;
        }

        .quote-img svg {
            width: 63px;
            margin: 0 26px 0 0;
        }

        .blue-btn a, .white-btn a {
            text-decoration: none;
            font-size: 16px;
            border: 2px solid #fff;
            border-radius: 26px;
            padding: 10px 30px;
            color: #fff;
            font-weight: 500;
            transition: 0.3s all;
            display: block;
        }
    }

    @media screen and (max-width: 1199px) {
        h1 {
            font-size: 32px;
            margin: 0;
        }

        h2 {
            font-size: 24px;
            margin: 0;
        }

        h3 {
            font-size: 22px;
            margin: 0;
        }

        h4 {
            font-size: 20px;
            margin: 0;
        }

        h5 {
            font-size: 16px;
            margin: 0;
        }

        h6 {
            font-size: 15px;
            margin: 0;
        }

        p {
            font-size: 15px;
            margin: 0;
        }

        .spacing {
            padding: 70px 0;
        }

        .heading {
            margin: 0 0 15px 0;
        }

        .paragraph {
            margin: 0 auto 25px auto;
        }

        .blue-btn a {
            font-size: 15px;
            padding: 8px 30px;
        }

        .quote-img svg {
            width: 50px;
            margin: -15px 26px 0 0;
        }

        .happy-client p {
            font-size: 16px;
        }

        .happy-client h5 {
            font-size: 20px;
            padding-top: 30px;
        }

        .testimonial-banner-img {
            text-align: center;
            width: 200px;
            margin: auto;
        }

        .inner-banner {
            padding: 160px 0 70px 0;
        }

        .happy-client-carousel .owl-theme .owl-nav.disabled + .owl-dots {
            margin-top: 30px;
        }

        .testimonial-banner-img img {
            width: 100%;
        }

        .inner-banner-description p {
            font-size: 18px;
            padding: 15px 0 25px;
        }

        .inner-list {
            padding: 15px 0 0 0;
        }


        .study-content.bg-grey {
            padding: 40px 30px;
        }

        .yr-text h3 {
            font-size: 35px;
            margin-bottom: 15px;
        }

        button.navbar-toggler {
            display: none;
        }

        .scale-brand-text p {
            font-size: 16px;
        }

        .blue-btn a, .white-btn a {
            font-size: 12px;
        }

        ul.navbar-nav.ml-auto.menu_link {
            DISPLAY: NONE;
        }

        .play-button svg {
            width: 100px;
        }
    }

    @media screen and (max-width: 991px) {
        h1 {
            font-size: 32px;
            margin: 0;
        }

        h2 {
            font-size: 24px;
            margin: 0;
        }

        h3 {
            font-size: 22px;
            margin: 0;
        }

        h4 {
            font-size: 20px;
            margin: 0;
        }

        h5 {
            font-size: 16px;
            margin: 0;
        }

        h6 {
            font-size: 15px;
            margin: 0;
        }

        p {
            font-size: 15px;
            margin: 0;
        }

        .spacing {
            padding: 70px 0;
        }

        .heading {
            margin: 0 0 15px 0;
        }

        .paragraph {
            margin: 0 auto 25px auto;
        }

        .max-content {
            max-width: initial;
        }

        .inner-banner .col-md-5 {
            -ms-flex: 0 0 100%;
            flex: 0 0 50%;
            max-width: 100%;
            padding: 0;
        }

        .scale-brand-text h4 {
            text-align: center;
        }

        .scale-brand-text p {
            text-align: center;
        }

        .scale-brand .white-btn {
            justify-content: center;
            margin-top: 20px;
        }

        .inner-banner .row .col-md-7 {
            -ms-flex: 0 0 100%;
            flex: 0 0 50%;
            max-width: 100%;
            padding: 0 0 35px 0;
        }

        .testimonial-banner-img {
            text-align: left !important;
            width: 200px;
        }

        .inner-banner-description p br {
            display: none;
        }

        .card-video {
            height: 250px;
        }

        .team-img {
            width: 130px;
        }

        .process .process-card .card h5 {
            width: auto;
        }

        .yr-texth4 {
            font-size: 18px;
        }

        /*    .case-study .row{
                flex-direction: column;
            }
            .case-study .row .col-md-4 {
                -ms-flex: 0 0 100%;
                flex: 0 0 100%;
                max-width: 100%;
                padding: 0 0 35px;
            }

            */
        .case-study .row .col-md-5,
        .case-study .row .col-md-7 {
            flex: 0 0 50%;
            max-width: 50%;
        }

        .study-content.bg-grey {
            padding: 20px 20px;
        }

        .case-study .row .col-md-7.col-12 {
            padding: 0 0 0 15px;
            max-width: 51.666667%;
        }

        .bottom-bar ul li a {
            padding: 0;
        }

        button.navbar-toggler {
            display: none;
        }

        .inner-banner {
            padding: 100px 0 50px 0;
        }

        .client-text {
            padding: 20px 20px 20px 50px;
            align-items: center;
            position: relative;
        }

    }


    @media screen and (max-width: 767px) {
        h1 {
            font-size: 28px;
            margin: 0;
        }

        h2 {
            font-size: 22px;
            margin: 0;
        }

        h3 {
            font-size: 20px;
            margin: 0;
        }

        h4 {
            font-size: 18px;
            margin: 0;
        }

        h5 {
            font-size: 15px;
            margin: 0;
        }

        h6 {
            font-size: 14px;
            margin: 0;
        }

        p {
            font-size: 14px;
            margin: 0;
        }

        .spacing {
            padding: 35px 0;
        }

        .heading {
            margin: 0 0 15px 0;
        }

        .paragraph {
            margin: 0 auto 25px auto;
        }

        .inner-banner-description p {
            font-size: 16px;
        }

        .inner-list li {
            font-size: 16px;
        }

        .inner-list li:before {
            font-size: 16px;
        }

        .inner-banner {
            padding: 100px 0 30px 0;
        }

        .inner-banner .row .col-md-7 {
            padding: 0 15px 35px 15px;
        }

        .inner-banner .row .col-md-5 {
            padding: 0 15px 0 15px;
        }

        .inner-banner-description h3 {
            width: auto;
        }

        .inner-img {
            margin: auto;
        }

        .salesforce-form h4 {
            padding: 20px 15px;
        }

        ul.banner-bottom-content {
            display: none;
        }

        .yr-text h3 {
            font-size: 20px;
            margin-bottom: 10px;
        }

        .yr-text h4 {
            font-size: 14px;
        }

        .years-content .row .col-md-4:not(:last-child) {
            margin: 0 0 35px;
        }

        .case-study .row .col-md-5.col-12, .case-study .row .col-md-7.col-12 {
            flex: 0 0 100%;
            max-width: 100%;
            padding: 0 15px;
        }

        .case-study .row .col-12:not(:last-child) {
            padding: 0px 15px 35px 15px;
        }

        /*.case-study .study-content .blue-btn {
            margin: 15px auto 0;
        }*/
        .bottom-bar ul li:not(:last-child) {
            padding: 0 16px 0 16px;
        }

        .bottom-bar ul li:nth-last-child(2) {
            border: unset;
        }

        .copyright ul {
            text-align: center;
            padding: 7px 0px;
        }

        .bottom-bar ul {
            flex-wrap: wrap;
        }

        .bottom-bar ul li a img {
            padding-top: 15px;
        }

        .inner-banner .row {
            padding: 0;
        }

        .study-img {
            padding: 0;
        }

        .inner-img {
            padding-top: 30px;
        }

        .banner-logo-img {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .bottom-bar ul li a {
            padding: 0;
        }

        button.navbar-toggler {
            display: none;
        }

        .inner-banner .row .col-md-7, .inner-banner .row .col-md-7 {
            flex: auto;
            max-width: 100%;
        }

        .growth-card .row .col-12:nth-of-type(1) {
            margin: 0 0 20px 0px;
        }

        .quote-img {
            top: 3%;
        }

        .quote-img svg {
            width: 40px;
        }

        .client-text {
            padding: 52px 20px 22px 20px;
        }

        .play-button {
            position: absolute;
            top: 100%;
            transform: translate(-50%, -43%);
            z-index: 99;
            left: 50%;

        }
    }

    @media screen and (max-width: 900px) and (max-height: 600px) and (orientation: landscape) {
        #youtube-modal .modal-body {
            padding: 0;
            line-height: 0;
            width: 75vw;
            height: 65vh;
        }
    }

</style>

<script>

    jQuery(document).ready(function () {

        jQuery('#happy-client-carousel').owlCarousel({
            loop: true,
            margin: 10,
            nav: false,
            mouseDrag: true,
            autoplay: true,
            autoplayTimeout: 4000,
            responsive: {
                0: {
                    items: 1,
                    dots: true
                },
                600: {
                    items: 1,
                    dots: true
                },
                1000: {
                    items: 1,
                    dots: true
                }
            }
        });
        jQuery('.happy-client-carousel .play-button > a').click(function (e) {
            const youtube_link = e.currentTarget.attributes['datayoutube'].value
            jQuery('#youtube-modal .modal-body iframe').attr('src', youtube_link)
        })
        //to remove video on modal close
        jQuery('#youtube-modal').on('hidden.bs.modal', function () {
            jQuery('#youtube-video').attr('src', '')
        });
    });
</script>

<?php
get_footer();
?>


