<?php
/*
Template Name: Web Dev Audit
*/
get_header();
?>

<style>
    /*common css starts*/
    .color-white {
        color: #fff;
    }

    .color-dark-grey {
        color: #1E1E1E;
    }

    .color-light-grey {
        color: #C7C7C7;
    }

    .color-grey {
        color: #6E6E6E;
    }

    .color-blue {
        color: #007EBF;
    }

    .color-black {
        color: #000;
    }

    .bg-black {
        background-color: #000;
    }

    .bg-grey {
        background: #1E1E1E;
    }

    .bg-light-grey {
        color: #1e1e1e7d;
    }

    .bg-white {
        color: #fff;
    }

    .card:hover {
        transform: scale(1.05);
        transition: all 0.5s;
    }

    h1 {
        font-size: 94px;
        margin: 0;
        font-weight: 700;
    }

    h2 {
        font-size: 70px;
        margin: 0;
        font-weight: 600;

    }

    h3 {
        font-size: 50px;
        margin: 0;
    }

    h4 {
        font-size: 34px;
        margin: 0;
    }

    h5 {
        font-size: 24px;
        margin: 0;
    }

    h6 {
        font-size: 20px;
        margin: 0;
    }

    p {
        font-size: 20px;
        margin: 0;
    }

    ul {
        padding: 0;
        list-style: none;
        margin: 0;
    }

    a {
        text-decoration: none;
        font-size: 18px;
    }

    svg {
        width: unset;
    }

    .scale-brand .row {
        align-items: center;
    }

    .spacing {
        padding: 100px 0;
    }

    .heading {
        font-weight: 700;
        text-align: center;
        margin: 0 0 30px;
    }

    .heading-margin {
        font-weight: 700;
        text-align: center;
        margin: 0 0 50px;
    }


    .heading-no-margin {
        margin: 0;
        font-weight: 700;
        text-align: center;
    }

    .paragraph {
        text-align: center;
        margin: 0 0 50px;
        font-size: 28px;
    }

    .footer.spacing.color-white ~ div {
        display: none;
    }

    .footer + div {
        display: none;
    }

    .card-h5 {
        font-size: 28px;
        text-align: left;
        line-height: 1.5;
        font-weight: 700;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }

    .card-h5-black {
        font-size: 24px;
        text-align: center;
        font-weight: 500;
        line-height: 1.3;
    }

    .card-p {
        font-size: 24px;
        line-height: 1.5;
    }

    .card-p-black {
        font-size: 20px;
        text-align: center;
        font-weight: 400;
        line-height: 1.3;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
        display: -webkit-box;
    }

    .blue-btn, .white-btn, .grey-btn {
        padding: 0;
        border: none;
        margin: 100px auto 0;
        display: flex;
        background: none;
        align-items: center;
        justify-content: center;
        width: auto;
    }

    .blue-btn a, .white-btn a {
        text-decoration: none;
        font-size: 18px;
        border: 2px solid #fff;
        border-radius: 26px;
        padding: 10px 30px;
        color: #fff;
        font-weight: 500;
        transition: 0.3s all;
    }


    .white-btn:hover a {
        color: #1E1E20;
        background: #fff;
        border-color: #fff;
        transition: 0.3s all;
    }

    /*common css ends*/

    /* inner banner starts */
    .inner-banner {
        height: auto;
        padding: 130px 0 100px;
    }

    .inner-banner .container {
        height: 100%;
        position: relative;
    }

    .inner-banner .row {
        align-items: top;
        height: 100%;
    }


    .inner-banner-content h3 {
        position: relative;
        padding: 0 0 30px 0;
        font-weight: 700;
    }

    .inner-banner-content h3:after {
        content: '';
        position: absolute;
        width: 20%;
        height: 5px;
        bottom: 0;
        background: #007EBF;
        left: 0;
        border-radius: 2px;
    }

    /* inner banner ends */

    /*salesforce landing page starts */
    .salesforce-lp .inner-banner .row,
    .page-template-web-dev-audit .inner-banner .row {
        align-items: center;
        height: 100%;
    }

    .growth-card .card {
        background: #1E1E20;
        box-shadow: 0px 10px 30px #000000;
        justify-content: center;
        height: 100%;
        align-items: center;
        min-height: 400px;
        padding: 20px 25px;
        max-height: 400px;
        transition: all 0.5s;
    }

    .salesforce-lp .growth-card .card,
    .page-template-web-dev-audit .growth-card .card {
        min-height: 300px;
        padding: 20px 25px;
        max-height: 350px;
        transition: all 0.5s;
        box-shadow: 0 10px 20px #00000029;
        border-radius: 6px;
        border: 0;
    }

    .case-study .card:hover .image img {
        transform: scale(1.05);
        transition: all 0.5s;
    }

    .case-study .image img {
        height: 100%;
        width: 100%;
        object-fit: cover;
        transition: all 0.5s;
        border-radius: 8px;
    }

    .salesforce-lp .growth-hacking .row .col-md-4.col-12:nth-child(1),
    .page-template-web-dev-audit .growth-hacking .row .col-md-4.col-12:nth-child(1) {
        margin: 0 0 24px 0;
    }

    .salesforce-lp .growth-hacking h5, .page-template-web-dev-audit .growth-hacking h5 {
        width: 100%;
        max-width: 100%;
        height: 100%;
        min-height: 70px;
    }

    .salesforce-lp .inner-banner-description p,
    .page-template-web-dev-audit .inner-banner-description p {
        font-size: 24px;
        padding: 30px 40px 50px 0;
    }

    .salesforce-lp .inner-list,
    .page-template-web-dev-audit .inner-list {
        font-size: 20px;
        padding: 0 0 0 20px;
    }

    .salesforce-lp .inner-list li,
    .page-template-web-dev-audit .inner-list li {
        list-style: disc;
        padding: 0 0 10px 0px;
    }

    .salesforce-lp .inner-list li::marker,
    .page-template-web-dev-audit .inner-list li::marker {
        color: #007EBF;
    }

    .salesforce-lp header .navbar-expand-lg .navbar-collapse,
    .page-template-web-dev-audit header .navbar-expand-lg .navbar-collapse {
        display: none !important;
    }

    .salesforce-lp .scale-brand-text h4,
    .page-template-web-dev-audit .scale-brand-text h4 {
        padding: 0;
    }

    .salesforce-lp .footer,
    .page-template-web-dev-audit .footer {
        display: none;
    }

    .salesforce-form {
        background: #fff;
        padding: 30px;
        border-radius: 6px;
    }


    .salesforce-lp .inner-banner-content h3 br,
    .page-template-web-dev-audit .inner-banner-content h3 br {
        display: none;
    }

    /*salesforce landing page ends */


    /* case-study-starts */

    .case-study {
        background: #1E1E20;
    }


    .case-study .row {
        align-items: start;
        justify-content: space-evenly;
    }

    .case-study .card:hover {
        transform: unset;

    }

    .case-study .card {
        padding: 20px;
        background-color: #1E1E20;
        box-shadow: 0px 0px 30px #000000;
        transition: all 0.5s;
    }

    .case-study .card-body {
        flex: 1 1 auto;
        padding: 50px 30px 30px 30px;
    }


    .case-study .card-body .card-p {
        margin: 20px 0 30px 0;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
        display: -webkit-box;
        font-size: 20px;
    }

    .case-study .image {
        width: 100%;
        height: 350px;
        overflow: hidden;
    }

    .case-study .image img {
        height: 100%;
        width: 100%;
        object-fit: cover;
        border-radius: 8px;
    }


    .bottom-bar {
        text-align: center;
    }

    .bottom-bar ul {
        list-style: none;
        margin-bottom: 0;
        padding: 0;
    }


    .bottom-bar ul li {
        display: inline;
        position: relative;
        text-align: center;
        padding: 0 30px;
        border-right: 1px solid #1E1E20;
    }

    .bottom-bar ul li:last-child {
        border: none;
    }

    .bottom-bar {
        background: #000000;
        border: 1px solid #1E1E20;
        padding: 16px 0;
    }

    .bottom-bar ul li a {
        padding: 7px 25px 6px 25px;
        text-decoration: none;
        font-size: 14px;
        color: inherit;
    }

    .bottom-bar ul li:hover a {
        color: #3BA953;
    }

    .bottom-bar .row {
        justify-content: center;
    }

    .copyright {
        border-top: 1px solid #4a4747;
        padding: 15px 0;
        background: #222222;
    }

    .copyright p {
        font-size: 14px;
        margin-bottom: 0;
    }

    .copyright ul {
        text-align: right;
        margin-bottom: 0;
        padding: 0;
    }

    .copyright ul li {
        list-style: none;
        display: inline-block;
        font-size: 15px;
        margin-right: 12px;
    }


    .copyright ul li a:hover {
        color: #3BA953 !important;
    }

    .footer ul li a:hover {
        color: #3BA953;
    }

    .footer ul li:last-child {
        padding-bottom: 0;
    }

    .copyright i.fa {
        color: #fff;
    }


    .inner-banner-content h1 {
        font-size: 50px;
    }

    .growth-card .card-img {
        width: 102px;
        height: 102px;
        margin: 0 auto 30px;
    }

    .growth-card .card-img img {
        width: 100%;
        height: 100%;
        object-fit: contain;
    }

    .growth-card .card-body {
        flex: unset;
        padding: 0;
    }

    .outer_bottom, footer.section.outer_footer {
        display: none;
    }

    .scale-brand-text p {
        font-size: 20px;
        text-align: left;
        letter-spacing: unset;
        padding-top: 15px;
    }

    .read-link a {
        position: relative;
        color: #007EBF;
        font-weight: 700;
        padding: 0 15px 5px 0;
        font-size: 24px;
    }

    .read-link a:after {
        content: '';
        position: absolute;
        background-color: #007EBF;
        width: 0;
        left: 0;
        height: 2px;
        bottom: 0;

    }

    .read-link a:before {
        content: '\F105';
        position: absolute;
        font-family: 'FontAwesome';
        right: 0px;
    }

    .read-link:hover a:after {
        content: '';
        position: absolute;
        background-color: #007EBF;
        width: 100%;
        left: 0;
        height: 2px;
        bottom: 0;
        transition: 0.3s all;

    }

    .scale-brand .row {
        align-items: center;
    }

    .scale-brand .white-btn {
        justify-content: end;
        margin: 0;
    }

    .case-study .paragraph {
        letter-spacing: -0.3px;
    }
</style>


<!-- banner starts -->
<section class="inner-banner bg-grey">
    <div class="container">
        <div class="row">
            <div class="col-md-7">
                <div class="inner-banner-content color-white">
                    <h1>Turn Your Underperforming Website Into a HERO</h1>
                </div>
                <div class="inner-banner-description color-light-grey">
                    <p>Partner with us to increase visibility, improve user experience, and turn your website into the
                        fulcrum of your digital marketing campaign. What does the audit include?</p>
                </div>
                <ul class="inner-list color-light-grey">
                    <li>Overall website architecture analysis</li>
                    <li>UI/UX performance evaluation</li>
                    <li>SEO check</li>
                    <li>Plugin evaluation</li>
                    <li>ADA compliance check</li>
                    <li>Hosting & server assessment</li>
                    <li>Functionality and responsiveness analysis</li>
                </ul>

            </div>
            <div class="col-md-5" id="scroll-top-form">
                <div class="salesforce-form">
                    <h4 class="heading">Request A Free Demo</h4>
                    <script charset="utf-8" type="text/javascript" src="//js.hsforms.net/forms/shell.js"></script>
                    <script>
                        hbspt.forms.create({
                            region: "na1",
                            portalId: "7118070",
                            formId: "de5e4e63-07ad-4f98-86d4-ceb6e7769064"
                        });
                    </script>
                </div>

            </div>
        </div>
    </div>
</section>
<!-- banner ends -->

<!--demo include starts-->
<section class="growth-hacking spacing ">
    <div class="container">
        <div class="content">
            <h4 class="heading color-dark-grey">Why You Need A Website Audit</h4>
            <p class="paragraph color-grey">Each website has its own set of unique attributes and areas for improvement.
                With our comprehensive audit, get a complete insight into the health of your website ecosystem and
                prepare it for future success.</p>
        </div>
        <div class="cards-row">
            <div class="row">
                <div class="col-md-4 col-12">
                    <div class="growth-card">
                        <div class="card bg-white">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/Union-1.png"
                                     alt="technical-support">
                            </div>
                            <div class="card-body">
                                <h5 class="card-h5-black color-grey">Improve Website Performance and Loading Speed</h5>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="growth-card">
                        <div class="card  bg-white">
                            <div class="card-img">
                                <img src=" https://growthnatives.com/wp-content/uploads/2022/05/technical-support-1.png"
                                     alt="financial-profit">
                            </div>
                            <div class="card-body">
                                <h5 class="card-h5-black color-grey">Ensure Proper Plugin Setup and Implementation</h5>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="growth-card">
                        <div class="card  bg-white">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/architechture.png"
                                     alt="book">
                            </div>
                            <div class="card-body">
                                <h5 class="card-h5-black color-grey">Access Scope of Improvement in Website
                                    Architecture</h5>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-4 col-12">
                    <div class="growth-card">
                        <div class="card  bg-white">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/Page-1.png"
                                     alt="book">
                            </div>
                            <div class="card-body">
                                <h5 class="card-h5-black color-grey">Ensure ADA Compliance</h5>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-4 col-12">
                    <div class="growth-card">
                        <div class="card  bg-white">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/traffic-conversion.png"
                                     alt="book">
                            </div>
                            <div class="card-body">
                                <h5 class="card-h5-black color-grey">Identify Opportunities for Increasing
                                    Conversions</h5>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="growth-card">
                        <div class="card  bg-white">
                            <div class="card-img">
                                <img src="https://growthnatives.com/wp-content/uploads/2022/05/bounce.png"
                                     alt="book">
                            </div>
                            <div class="card-body">
                                <h5 class="card-h5-black color-grey">Reduce Bounce Rates and Abrupt Exits</h5>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>
<!--demo include ends-->

<!-- case studies starts -->
<section class="case-study spacing bg-grey">
    <div class="container">

        <div class="content">
            <h4 class="heading color-white">Case Studies</h4>
            <h5 class="paragraph color-light-grey">At Growth Natives, our web dev team digs deep to identify the
                bottlenecks in your website and unearth opportunities for improvement. Here are a few success stories
                from the projects we have completed so far.</h5>
        </div>
        <div class="row">

            <div class="col-md-6">
                <div class="card">
                    <div class="image">
                        <img width="605" height="688"
                             src="https://growthnatives.com/wp-content/uploads/2022/05/innerbeauty.png"
                             class="attachment-post-thumbnail size-post-thumbnail wp-post-image" alt="" loading="lazy"
                             srcset="https://growthnatives.com/wp-content/uploads/2022/05/innerbeauty.png"
                             sizes="(max-width: 605px) 100vw, 605px"></div>
                    <div class="card-body">
                        <h5 class="card-h5 color-white">120% Increase in Website Traffic of an Australian Laser Skin
                            Clinic</h5>
                        <p class="card-text card-p color-light-grey">Know how website optimization with interactive
                            designs and custom videos helped one of the established skin clinics boost customer
                            engagement and 2X online inquiries.</p>
                        <div class="read-link">
                            <a href="https://growthnatives.com/case-studies/lamav-case-study/">
                                Read more
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="image">
                        <img width="676" height="440"
                             src="https://growthnatives.com/wp-content/uploads/2022/05/skincare.png"
                             class="attachment-post-thumbnail size-post-thumbnail wp-post-image"
                             alt="portrait-successful-leader" loading="lazy"
                             srcset="https://growthnatives.com/wp-content/uploads/2022/05/skincare.png"
                             sizes="(max-width: 676px) 100vw, 676px"></div>
                    <div class="card-body">
                        <h5 class="card-h5 color-white">160% Increase in Sales of an Organic Skincare and Wellness
                            Brand</h5>
                        <p class="card-text card-p color-light-grey">Find out how this Australian skincare brand
                            experienced a transformation to website traffic to new customer sign-ups ratio by 50% by
                            optimizing and enhancing the website design.</p>
                        <div class="read-link">
                            <a href="https://growthnatives.com/case-studies/youbysia-case-study/">
                                Read more
                            </a>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </div>
</section>
<!-- case studies ends -->

<!-- ready to see starts -->
<div class="scale-brand">
    <div class="container">
        <div class="row">
            <div class="col-lg-9 col-md-12 col-sm-12 col-12">
                <div class="scale-brand-text">
                    <h4 class="color-white">Let's Revitalize Your Underperforming Website!</h4>
                    <p class="color-white">Let our WebDev experts assess your website to solve any bottlenecks for
                        good.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-12 col-sm-12 col-12">
                <div class=" white-btn">
                    <a href=" #scroll-top-form">I’d Like A Free Audit</a>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- ready to see ends -->

<div class="bottom-bar color-white">
    <div class="container">
        <div class="row">
            <ul>
                <li>
                    <a class="color-white" href="https://growthnatives.com/resources/">
                        Blogs </a>
                </li>
                <li>
                    <a class="color-white" href="https://growthnatives.com/about/">
                        About Us </a>
                </li>
                <li>
                    <a class="color-white" href="https://growthnatives.com/growth-natives-tcs/">
                        Terms & Conditons </a>
                </li>
                <li>
                    <a href="https://www.dmca.com/Protection/Status.aspx?ID=639f9bc7-120f-4893-ae6b-66cc4a2e041d&refurl=https://growthnatives.com/growth-natives-tcs/">
                        <img src="https://growthnatives.com/wp-content/uploads/2022/05/dmca.png"
                             alt="DMCA Protected">
                    </a>
                </li>
            </ul>
        </div>
    </div>
</div>

<div class="copyright color-white">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6 col-xs-12">
                <p>Copyright © 2022 Growth Natives. All rights reserved.</p>
                <!-- <p>Copyright © 2022 All Rights Reserved </p> -->
            </div>
            <div class="col-md-6 col-xs-12">
                <ul>
                    <li>Follow Us:</li>
                    <li>
                        <a class="color-white" target="self" href="https://www.facebook.com/growthnatives">
                            <i class="fa fa-facebook" aria-hidden="true"></i> </a>
                    </li>
                    <li>
                        <a class="color-white" target="self" href="https://twitter.com/GrowthNatives">
                            <i class="fa fa-twitter" aria-hidden="true"></i> </a>
                    </li>
                    <li>
                        <a class="color-white" target="self" href="https://www.linkedin.com/company/growthnatives/mycompany/verification/">
                            <i class="fa fa-linkedin" aria-hidden="true"></i> </a>
                    </li>
                    <li>
                        <a class="color-white" target="self" href="https://www.instagram.com/growthnatives/">
                            <i class="fa fa-instagram" aria-hidden="true"></i> </a>
                    </li>
                </ul>

            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>

<style>
    /*media queries*/
    @media screen and (max-width: 1650px) {

        /* common css */
        h1 {
            font-size: 74px;
            margin: 0;
        }

        h2 {
            font-size: 50px;
            margin: 0;
        }

        h3 {
            font-size: 34px;
            margin: 0;
        }

        h4 {
            font-size: 28px;
            margin: 0;
        }

        h5 {
            font-size: 20px;
            margin: 0;
        }

        h6 {
            font-size: 18px;
            margin: 0;
        }

        p {
            font-size: 16px;
            margin: 0;
        }

        ul {
            padding: 0;
            list-style: none;
            margin: 0;
        }

        a {
            text-decoration: none;
            font-size: 16px;
        }

        .spacing {
            padding: 85px 0;
        }


        .heading {
            margin: 0 0 30px;
        }

        .heading-margin {
            margin: 0 0 50px;
        }

        .heading-no-margin {
            margin: 0;
        }

        .paragraph {
            font-size: 20px;
        }

        .card-h5 {
            font-size: 20px;
        }

        .card-h5-black {
            font-size: 20px;
        }

        .card-p {
            font-size: 18px;
        }

        .card-p-black {
            font-size: 18px;
        }

        .card-heading {
            font-size: 20px;
        }

        .card-subheading {
            font-size: 16px;
        }

        .blue-btn, .white-btn, .grey-btn {
            margin-top: 0px;
        }

        /* common css */
        /* header */
        header {
            padding: 0;
        }

        .banner-top-content h3 {
            font-size: 52px;
            min-height: 120px;
        }

        .banner-top-content h4 {
            font-size: 28px;
        }

        nav.navbar.navbar-expand-lg.navbar-light {
            padding: 10px 0;
        }

        header .navbar-light .navbar-nav .nav-link {
            font-size: 14px;
            padding: 10px 20px;
            font-weight: 600;
        }

        .service-flex .nav-pills#parent-pills-tab .nav-link, .nav-pills#parent-pills-tab .show > .nav-link {
            margin: 0 0 10px;
        }

        .service-flex #parent-tab-content.tab-content {
            padding: 25px;
            min-height: 592px;
        }

        .service-flex #parent-tab-content.tab-content .nav-pills button {
            font-size: 18px;
            padding: 0 0 20px 20px;
            width: 100%;
        }

        .service-flex #parent-tab-content.tab-content .nav-pills button:before {
            font-size: 18px;
        }

        .service-flex .tab-content h6 {
            margin: 35px 0 35px 0;
            font-size: 18px;
        }


        .service-flex .nav-pills#parent-pills-tab .nav-link.active:before, .nav-pills#parent-pills-tab .show > .nav-link {
            border-width: 16.5px 25px 16.5px 0;
            right: -9%;
            transform: translateX(9%);
        }

        .sticky-heading {
            top: 70px;
        }

        .left-right, .right-left {
            padding: 85px 0;
        }

        .logos {
            width: 172px;
            padding: 10px;
        }

        .marketing-logo .row, .digital .marketing-logo .row {
            --bs-gutter-x: 0;
            padding: 0 90px 0 90px;
        }

        .happy-client-carousel {
            padding-top: 85px;
        }

        .quote-img {
            top: 5%;
            width: 60px;
            height: 60px;
            margin: 0 26px 0 0;
        }

        .quote-img svg {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .happy-client p {
            font-size: 18px;
        }

        .client-text {
            padding: 22px 30px 22px 50px;
        }


        .practices-card {
            min-height: 430px;
        }

        .scale-brand-text h3 {
            font-size: 40px;
        }

        .scale-brand-text p {
            font-size: 22px;
        }

        .scale-brand-button a {
            padding: 10px 20px;
            font-size: 16px;
        }

        .yr-text h4 {
            font-size: 40px;
        }

        .yr-text p {
            font-size: 20px;
            max-width: 65%;
        }

        .case-study .card-body {
            padding: 30px 20px 20px 20px;
        }


        /* marketing automation starts */
        ul.marketing-list li {
            font-size: 18px;
        }

        .marketing-services .right-left:nth-of-type(4) {
            padding: 85px 0 0;
        }

        /* marketing automation ends */
        /* blogs listing starts */
        .blogs .card-body h5 {
            padding: 20px 0 10px;
            font-size: 18px;
        }

        .pagination {
            padding: 85px 0 0 0;
        }

        .blogs .practices-card button.btn.submit {
            margin: 40px 0 0 0;
        }


        /* blogs listing ends */
        /* blog detail starts */
        .blog-detail .publish-detail {
            margin: 20px 0 35px;
        }

        .blog-detail .content h5:not(:last-child) {
            margin: 0 0 40px;
        }

        .blog-detail .content h5:nth-child(3) {
            margin: 0;
        }

        .blog-detail ul.blog-tags {
            margin: 20px 0 0;
        }

        /* blog detail ends */
        /*newsletter starts */
        .newsletter {
            padding: 0 0 85px;
        }

        /*newsletter ends */
        /*    press release starts */
        .horizontal-blog-card {
            padding: 85px 0 0;
        }

        .horizontal-blog-card .card {
            padding: 30px 45px;
        }

        .horizontal-blog-card .card-body {
            padding: 10px 0 10px 40px;
        }

        /*    press release ends */
        /*    leadeship starts */
        .follow-img {
            width: auto;
        }

        .founders-modal .modal-body {
            padding: 85px;
        }

        /*
        .founders-modal .content {
            padding: 20px 0px 0 0px;
        }

          .founders .row .col-md-5:not(:last-child) {
              margin-bottom: 20px;
          }
        .founders .card .card-body {
            padding: 0 20px;
        }
        */
        .natives-life-image {
            height: 350px;
        }

        .natives-life-black-bg p {
            padding: 10px 0;
        }

        .natives-life-black-bg .blue-btn a {
            padding: 5px 30px;
            font-size: 12px;
        }

        /*   leadership ends  */
        /*    salesforce landing page starts */
        .page-template-salesforce-lp .inner-banner,
        .page-template-web-dev-audit .inner-banner {
            height: 100%;
            padding: 120px 0 70px;
        }

        .inner-banner-content h3 br {
            display: none;
        }

        .page-template-salesforce-lp .inner-banner-description p,
        .page-template-web-dev-audit .inner-banner-description p {
            font-size: 20px;
        }

        .page-template-salesforce-lp .inner-list,
        .page-template-web-dev-audit .inner-list {
            font-size: 18px;
            padding: 0 0 0 15px;
        }

        .page-template-salesforce-lp .inner-banner, .page-template-web-dev-audit .inner-banner {
            height: auto;
            padding: 120px 0 70px;
        }

        /*    salesforce landing page ends */

        .inner-banner-content h1 {
            font-size: 34px;
        }
    }

    @media screen and (max-width: 1199px) {


        /* common css */
        h1 {
            font-size: 47px;
            margin: 0;
        }

        h2 {
            font-size: 40px;
            margin: 0;
        }

        h3 {
            font-size: 32px;
            margin: 0;
        }

        h4 {
            font-size: 26px;
            margin: 0;
        }

        h5 {
            font-size: 18px;
            margin: 0;
        }

        h6 {
            font-size: 16px;
            margin: 0;
        }

        p {
            font-size: 18px;
            margin: 0;
        }

        ul {
            padding: 0;
            list-style: none;
            margin: 0;
        }

        a {
            text-decoration: none;
            font-size: 20px;
        }

        .spacing {
            padding: 70px 0;
        }

        /*    .heading {
                font-weight: 700;
                text-align: center;
                margin: 0 0 30px;
            }

            .heading-bg-white {
                font-weight: 700;
                text-align: center;
                margin: 0 0 50px;
                color: #000;
            }

            .heading-img {
                font-weight: 700;
                text-align: center;
                margin: 0 0 50px;
            }

            .heading-bg-black {
                color: #fff;
                font-weight: 700;
                text-align: center;
                margin: 0 0 15px;
            }

            .paragraph {
                color: #6E6E73;
                text-align: center;
                margin: 0 0 50px;
            }

            .paragraph-bg-black {
                color: #FFFFFF;
                text-align: center;
                margin: 0 0 50px;
            }

            .card-h5 {
                font-size: 20px;
            }

            .card-h5-black {
                font-size: 18px;
            }

            .card-p {
                margin: 15px 0 25px 0;
                font-size: 18px;
            }

            .card-p-black {
                font-size: 16px;
            }*/
        .heading {
            margin: 0 0 30px;
        }

        .heading-margin {
            margin: 0 0 50px;
        }

        .heading-no-margin {
            margin: 0;
        }

        .paragraph {
            font-size: 18px;
        }

        .card-h5 {
            font-size: 20px;
        }

        .card-h5-black {
            font-size: 18px;
        }

        .card-p {
            font-size: 18px;
        }

        .card-p-black {
            font-size: 16px;
        }

        .card-heading {
            font-size: 20px;
        }

        .card-subheading {
            font-size: 16px;
        }


        .blue-btn a, .white-btn a, .grey-btn a {
            font-size: 16px;
            padding: 5px 20px;
        }

        /* common css */
        .banner {
            height: auto;
        }

        header li.nav-item:not(:last-child) {
            padding: 0 0 0 0;
        }

        header .navbar-light .navbar-nav .nav-link {
            font-size: 15px;
        }

        .navbar-nav li.nav-item.dropdown:nth-last-child(2) {
            width: 200px;
        }

        .megamenu-row a span {
            font-size: 14px;
        }

        .banner-top-content h3 {
            min-height: 160px;
        }

        .services h1 {
            font-size: 32px;
        }

        .service-flex .nav-pills#parent-pills-tab .nav-link.active:before, .nav-pills#parent-pills-tab .show > .nav-link {
            border-width: 10.5px 25px 10.5px 0;
            right: -40px;
            z-index: 15;
            transform: translateX(0);
        }

        .service-flex #parent-tab-content.tab-content .nav-pills button {
            font-size: 18px;
            align-items: start;
            padding: 0 0 20px 30px;
        }

        .service-flex .tab-content h6 {
            margin: 20px 0 30px 0;
            color: #6E6E73;
        }

        .service-flex #parent-tab-content.tab-content {
            min-height: 588px;
        }

        .sticky-heading {
            padding: 20px 0;
            top: 70px;
        }


        .happy-client-carousel {
            margin: 0 auto;
            max-width: 100%;
            width: 100%;
            padding-top: 0;
        }


        .happy-client p {
            font-size: 16px;
        }

        .happy-client-carousel .item {
            margin-top: 50px;
        }

        .play-button {
            width: 100px;
        }

        .happy-client-carousel .owl-theme .owl-nav.disabled + .owl-dots {
            margin-top: 50px;
        }

        .client-text {
            padding: 12px 30px 12px 50px;
        }

        .quote-img {
            top: 0;
            width: 65px;
            height: 65px;
        }

        .happy-client h5 {
            font-size: 22px;
            padding-top: 14px;
        }

        svg {
            width: 100%;
            height: 100%;
        }

        .scale-brand {
            padding: 35px 0;
        }

        .scale-brand-text h3 {
            font-size: 28px;
        }

        .scale-brand-text p {
            font-size: 20px;
        }

        .scale-brand-button a {
            padding: 6px 9px;
            font-size: 16px;
            margin-top: 0;
        }


        .about-you-list li {
            padding: 0 0 15px 25px;
            font-size: 20px;
        }

        .marketing-logo {
            position: unset;
            width: 100%;
            margin: 0px 0 50px 0;
            right: unset;
            transform: unset;
            max-width: 100%;
        }

        .marketing-logo .row, .digital .marketing-logo .row {
            padding: 0;
        }

        .img-div, .img-div-1 {
            float: right;
            max-width: 700px;
        }

        .marketing-content {
            left: unset;
            position: unset;
            top: unset;
            max-height: unset;
            transform: unset;
            max-width: 650px;
            width: 100%;
            margin: auto;
            padding: 40px 15px;
        }

        .marketing, .digital {
            position: relative;
            display: flex;
            width: 100%;
            flex-direction: column-reverse;
        }

        .digital .marketing-content {
            position: relative;
            right: 0;
            left: unset;
        }

        .left-right, .right-left {
            padding: 50px 0;
        }

        .customer-images .image {
            width: 180px;
        }

        .yr-text h4 {
            font-size: 32px;
        }

        .yr-text p {
            font-size: 18px;
            margin: auto;
            width: 100%;
            max-width: 70%;
        }

        .case-study .card-body {
            flex: 1 1 auto;
            padding: 30px 20px 20px 20px;
        }

        .practices-card {
            min-height: 380px;
        }

        .bottom-bar ul li:last-child {
            padding: 0px;
        }

        /*  marketing automation starts  */
        .inner-banner {
            height: 80%;
        }

        .inner-banner-description p {
            padding: 20px 0 40px 0;
        }


        .growth-card .card {
            min-height: 250px;
            max-height: 300px;
        }

        .growth-card .card-img {
            margin: 0 0 30px;
        }

        .marketing-solution .growth-card .card {
            min-height: 350px;
            max-height: 450px;
        }

        .marketing-solution .growth-card .card-img {
            width: 150px;
            height: 100px;
        }

        .marketing-services .right-left:nth-of-type(4) {
            padding: 50px 0 0;
        }

        /*  marketing automation ends  */
        /*    blog listing starts */
        .inner-banner .search-form-wrapper input.search-input {
            width: 20px;
        }

        .inner-banner ul .nav-item a.nav-link {
            font-size: 18px;
        }

        ul.blog-tags {
            margin: 15px 0 0;
        }

        .blogs .practices-card {
            padding: 13px 17px 25px;
        }

        .blogs .practices-card button.btn.submit {
            margin: 30px 0 0 0;
        }


        .pagination {
            padding: 70px 0 0 0;
        }

        /*    blog listing ends */
        /*    blog detail starts */
        .blog-detail .blog-detail-outer {
            max-width: 720px;
        }

        .blog-detail .content h5:not(:last-child) {
            margin: 0 0 25px;
        }

        /*    blog detail ends */
        /*newsletter starts*/
        .newsletter {
            padding: 0 0 70px;
        }

        /*newsletter ends*/
        /*    press release starts */
        .horizontal-blog-card {
            padding: 70px 0 0;
        }

        .horizontal-blog-card .card-body h6 {
            padding: 0px 0 10px;
        }

        /*    press release ends */
        /*    ebook detail starts */
        .ebook-list {
            padding: 25px 0 30px;
        }

        .ebook-img {
            width: 80%;
        }

        /*    ebook detail ends */
        /*    salesforce starts */
        .salesforce .salesforce-expertise .card-p-black {
            -webkit-line-clamp: 3;
            overflow: hidden !important;
            min-height: auto;
        }

        .choose-list li {
            font-size: 18px;
        }

        .salesforce-services .row .col-4 {
            width: 15%;
        }

        /*    salesforce ends */
        /*  leadership starts */
        .leadership .card:hover {
            transform: unset;
        }

        .founders-modal .modal-body {
            padding: 70px;
        }

        .natives-life .gn-life-img .row .col-md-7, .natives-life .gn-life-img .row .col-md-5 {
            padding: 5px;
        }

        .founders .card-img {
            height: auto;
        }

        .founders .card {
            min-height: auto;
        }

        .natives-life-image {
            height: 240px;
        }

        /*  leadership ends */
        /*    salesforce landing page starts */
        .inner-banner {
            padding: 150px 0 70px;
        }

        .page-template-salesforce-lp .inner-list,
        .page-template-web-dev-audit .inner-list {
            font-size: 20px;
            padding: 0 0 0 20px;
        }

        .page-template-salesforce-lp .inner-banner-description p,
        .page-template-web-dev-audit .inner-banner-description p {
            font-size: 20px;
            padding: 20px 0;
        }

        /*    salesforce landing page ends */
        .inner-banner-content h1 {
            font-size: 32px;
        }

        .read-link a {
            font-size: 18px;
        }.inner-banner-content h1 {
             font-size: 32px;
         }
    }

    @media screen and (max-width: 991px) {
        /* common css */
        h1 {
            font-size: 36px;
            margin: 0;
        }

        h2 {
            font-size: 38px;
            margin: 0;
        }

        h3 {
            font-size: 30px;
            margin: 0;
        }

        h4 {
            font-size: 24px;
            margin: 0;
        }

        h5 {
            font-size: 18px;
            margin: 0;
        }

        h6 {
            font-size: 16px;
            margin: 0;
        }

        p {
            font-size: 16px;
            margin: 0;
        }

        ul {
            padding: 0;
            list-style: none;
            margin: 0;
        }

        a {
            text-decoration: none;
            font-size: 16px;
        }

        .spacing {
            padding: 70px 0;
        }

        /* .heading {
             margin: 0 0 15px;
         }

         .heading-bg-white {
             margin: 0 0 25px;
         }

         .heading-img {
             margin: 0 0 25px;
         }

         .heading-bg-black {
             margin: 0 0 15px;
         }

         .paragraph {
             margin: 0 0 25px;
         }

         .paragraph-bg-black {
             margin: 0 0 25px;
         }

         .card-h5 {
             font-size: 18px;
         }

         .card-h5-black {
             font-size: 18px;
         }

         .card-p {
             margin: 10px 0 20px 0;
             font-size: 16px;
         }

         .card-p-black {
             font-size: 16px;
         }

         .card-heading {
             font-size: 18px;
         }

         .card-subheading {
             font-size: 16px;
         }*/
        .heading {
            margin: 0 0 15px;
        }

        .heading-margin {
            margin: 0 0 25px;
        }

        .heading-no-margin {
            margin: 0;
        }

        .paragraph {
            margin: 0 0 25px;
        }

        .card-h5 {
            font-size: 18px;
        }

        .card-h5-black {
            font-size: 16px;
        }

        .card-p {
            margin: 10px 0 20px 0;
            font-size: 16px;
        }

        .card-p-black {
            font-size: 16px;
        }

        .card-heading {
            font-size: 18px;
        }

        .card-subheading {
            font-size: 16px;
        }


        /* common css */
        header {
            display: block;
        }

        #wprmenu_bar .menu_title a {
            top: 0px;
        }


        ul.banner-bottom-content li {
            width: 20%;
        }

        .banner-top-content h3 {
            margin: 0 0 30px;
        }

        .banner .container {
            padding: 130px 0 35px;
        }

        .services h1 {
            font-size: 30px;
        }

        .services h5.paragraph br {
            display: none;
        }

        .service-flex .nav-pills#parent-pills-tab .nav-link, .nav-pills#parent-pills-tab .show > .nav-link {
            margin: 0 0 20px;
            box-shadow: 0 10px 20px #80808029;
        }

        .service-flex .nav-pills#parent-pills-tab .nav-link.active:before, .nav-pills#parent-pills-tab .show > .nav-link {
            border-width: 15.5px 20px 12.5px 0;
            right: -30px;
            transform: translateX(0);
        }

        .service-flex #parent-tab-content.tab-content {
            width: 48%;
            padding: 20px;
            box-shadow: 0 10px 20px #007ebf29;
            min-height: 606px;
        }

        .service-flex #parent-tab-content.tab-content .nav-pills button {
            font-size: 15px;
            padding: 0 0 15px 20px;
            text-align: left;
        }

        .service-flex .tab-content h6 {
            margin: 10px 0 15px 0;
            font-size: 15px;
            line-height: 1.3;
        }

        .service-flex .nav-logo {
            width: 50px;
            height: 50px;
        }

        .service-flex .nav-logo img, svg {
            width: 100%;
            height: 100%;
        }

        .service-flex h5 {
            font-size: 16px;
        }

        .service-flex .nav-pills#parent-pills-tab .nav-link.active, .nav-pills#parent-pills-tab .show > .nav-link {
            box-shadow: 0 5px 10px #007ebf29;
        }

        .read-link a {
            font-size: 16px;
        }

        .marketing-logo .logos {
            margin: 0 auto 10px;
        }

        .partners .image {
            width: 160px;
            height: 120px;
            margin: auto;
        }

        .partners h5.paragraph br {
            display: none;
        }

        .customer-images .image {
            width: 130px;
            height: 130px;
        }

        .happy-client h5 {
            font-size: 20px;
            letter-spacing: unset;
            padding-top: 15px;
        }

        .happy-client a {
            font-size: 16px;
            letter-spacing: unset;
        }

        .happy-client p {
            font-size: 14px;
        }

        .happy-client-carousel .item {
            margin-top: 30px;
        }

        .quote-img svg {
            width: 50px;
        }

        .client-img {
            height: 100%;
        }

        .client-img img {
            height: 100%;
            object-fit: cover;
        }

        .play-button {
            top: 50%;
            right: -15%;
            transform: translateY(-50%);
            width: 70px;
        }

        .info-section .heading h2 {
            font-size: 32px;
        }

        .practices-card {
            padding: 15px;
            min-height: 330px;
        }

        .best-practices .row {
            justify-content: center;
        }

        .practices-card {
            width: 49%;
        }

        .practices-card-outer .practices-card:not(:last-child) {
            margin: 0 0 25px 0;
        }

        .scale-brand-text h3 {
            font-size: 24px;
            padding-bottom: 10px;
        }

        .scale-brand-text p {
            font-size: 16px;
            padding: 0 0 10px;
        }

        .scale-brand-button a {
            padding: 6px 15px;
        }

        footer .row .col-sm-6.col-12:first-child, footer .row .col-sm-6.col-12:nth-child(2) {
            padding: 0 15px 20px 0;
        }

        .bottom-bar ul li:not(:last-child) {
            padding: 0 10px 0 0;
        }

        .inner-banner {
            height: auto;
            padding: 150px 0 0px;
        }

        .inner-banner-lottie {
            padding: 0 0 70px;
        }

        .inner-banner-lottie lottie-player {
            width: 250px;
        }

        .about-you-list li {
            font-size: 16px;
        }


        .yr-text p {
            font-size: 15px;
            max-width: 66%;
        }

        .yr-text h4 {
            font-size: 24px;
        }

        .case-study .image {
            width: 100%;
            height: auto;
            overflow: hidden;
        }


        /*  marketing automation starts  */
        .growth-card .card-img {
            width: 82px;
            height: 82px;
        }

        .marketing-services .container-fluid > .content {
            padding: 0px 35px;
        }

        .marketing-services .left-right p, .marketing-services .right-left p {
            margin: 15px 0;
        }

        .marketing-solution .row .col-md-4.col-12:last-child {
            margin: 22px 0 0 0;
        }

        .marketing-solution .row .col-md-4.col-12 {
            width: 49.333333%;
        }

        .marketing-automation .inner-banner .row .col-md-6:first-child {
            margin: 0px 0 70px;
        }

        .marketing-services .right-left:nth-of-type(4) {
            padding: 50px 0 0;
        }

        .marketing-solution .row {
            justify-content: center;
        }

        .scale-brand-text h4 {
            text-align: center;
        }

        .scale-brand-text p {
            text-align: center;
        }

        /*  marketing automation ends  */
        /*    blog listing starts */
        .inner-banner .navbar-collapse {
            display: block;
        }

        .inner-banner ul.navbar-nav {
            flex-direction: row;
            flex-wrap: wrap;
            justify-content: center;
        }

        .inner-banner .row .col-md-6:first-child {
            margin: 0px 0 200px;
        }

        .inner-banner li.nav-item:last-child {
            margin: 20px 0 0;
        }

        .blogs .date-time h6 {
            font-size: 15px;
        }

        .blogs .practices-card {
            width: 48%;
        }

        .blogs .practices-card-outer .practices-card:last-child {
            margin: 30px 0 0;
        }

        .inner-banner ul.navbar-nav li {
            position: relative;
            display: flex;
            align-items: center;
        }


        /*    blog listing ends */
        /* blog detail starts */
        .blog-detail .blog-detail-outer {
            max-width: 520px;
        }

        .newsletter .form-control {
            max-width: 320px;
            height: 45px;
            font-size: 18px;
        }

        .submit {
            font-size: 16px;
            height: 45px;
            width: 146px;
        }

        /* blog detail ends */
        /*newsletter starts*/
        .newsletter {
            padding: 0 0 35px;
        }

        /*newsletter ends*/
        /*    press release starts */
        .horizontal-blog-card .card-img {
            height: 300px;
        }

        /*    press release ends */
        /*leadership starts*/
        .founders-modal .modal-content {
            width: 90%;
            margin: auto;
        }

        .founders-modal .content {
            padding: 0 0 0 20px;
        }

        .founders-modal .modal-body {
            padding: 40px;
        }

        /*leadership ends*/
        /*  ebook detail starts   */
        .ebook-download .content .paragraph {
            font-size: 18px;
        }

        .ebook-list {
            padding: 15px 0 20px;
        }

        .ebook-download form input#download-ebook {
            width: auto;
            height: 45px;
        }

        .ebook-download .submit {
            width: auto;
        }

        .ebook-img {
            width: 100%;
        }

        /*  ebook detail ends   */
        /*    salesforce starts */
        .salesforce .marketing-services .heading-bg-black {
            margin: 0 0 25px;
        }

        .salesforce .marketing-services .heading-bg-black br {
            display: none;
        }

        .salesforce ul.marketing-list li {
            font-size: 16px;
        }

        .salesforce ul.marketing-list li:not(:first-child) {
            margin: 15px 0 0 0;
        }

        .salesforce-services .row .col-4 {
            width: 16%;
        }

        .content-img:nth-of-type(3) {
            margin: 0;
        }

        .salesforce-app .blue-btn {
            margin-top: 25px;
        }

        .choose-gn .heading {
            margin: 0 0 25px;
        }

        /*    salesforce ends */
        /*    salesforce landing page starts */
        .page-template-salesforce-lp .inner-banner,
        .page-template-web-dev-audit .inner-banner {
            height: auto;
            padding: 100px 0 0 0;
        }

        .page-template-salesforce-lp .growth-card .card,
        .page-template-web-dev-audit .growth-card .card {
            min-height: 220px;
        }

        .page-template-salesforce-lp .wprm-wrapper,
        .page-template-web-dev-audit .wprm-wrapper {
            display: none;
        }

        .page-template-salesforce-lp .scale-brand-text h4,
        .page-template-web-dev-audit .scale-brand-text h4 {
            padding: 0 0 25px;
        }

        /*    salesforce landing page ends */
        /*    thank you starts */
        .thanks {
            padding: 0;
            height: 100%;
            justify-content: center;
            display: flex;
            flex-direction: column;
        }

        .thanks .content p {
            padding: 0px 0 25px;
        }


        .page-template-salesforce-lp .inner-banner,
        .page-template-web-dev-audit .inner-banner {
            padding: 100px 0 70px 0;
        }


        .page-template-salesforce-lp .growth-card .card-img,
        .page-template-web-dev-audit .growth-card .card-img {
            width: 62px;
            height: 62px;
        }

        .page-template-salesforce-lp .growth-card .card-img img,
        .page-template-web-dev-audit .growth-card .card-img img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        /*    thank you ends  */
        .inner-banner-content h1 {
            font-size: 30px;
        }

        .case-study .card-body .card-p {
            margin: 10px 0 20px 0;
            font-size: 18px;
        }

        .scale-brand .white-btn {
            justify-content: center;
        }

        .navbar-toggler {
            display: none;
        }
        .page-template-salesforce-lp .inner-list, .page-template-web-dev-audit .inner-list {
            font-size: 18px;
            padding: 0 0 0 15px;
        }
        .page-template-salesforce-lp .inner-banner-description p, .page-template-web-dev-audit .inner-banner-description p{
            font-size: 18px;
            padding: 15px 0;
        }
        .inner-banner-content h1 {
            font-size: 30px;
        }
    }

    @media screen and (max-width: 767px) {

        /* common css */
        h1 {
            font-size: 28px;
            margin: 0;
        }

        h2 {
            font-size: 30px;
            margin: 0;
        }

        h3 {
            font-size: 24px;
            margin: 0;
        }

        h4 {
            font-size: 20px;
            margin: 0;
        }

        h5 {
            font-size: 16px;
            margin: 0;
        }

        h6 {
            font-size: 18px;
            margin: 0;
        }

        p {
            font-size: 16px;
            margin: 0;
        }

        ul {
            padding: 0;
            list-style: none;
            margin: 0;
        }

        a {
            text-decoration: none;
            font-size: 16px;
        }

        .spacing {
            padding: 35px 0;
        }

        /*

        .heading {
            margin: 0 0 15px;
        }

        .heading-bg-white {
            margin: 0 0 25px;
        }

        .heading-img {
            margin: 0 0 25px;
        }

        .heading-bg-black {
            margin: 0 0 15px;
        }

        .paragraph {
            margin: 0 0 25px;
            font-size: 16px;
        }

        .paragraph-bg-black {
            margin: 0 0 25px;
            font-size: 16px;
        }

        .spacing {
            padding: 35px 0;
        }

        .card-heading {
            font-size: 20px;
        }

        .card-subheading {
            font-size: 16px;
        }
        */
        .heading {
            margin: 0 0 15px;
        }

        .heading-margin {
            margin: 0 0 25px;
        }

        .heading-no-margin {
            margin: 0;
        }

        .paragraph {
            margin: 0 0 25px;
            font-size: 16px;
        }

        .card-h5 {
            font-size: 18px;
        }

        .card-h5-black {
            font-size: 18px;
        }

        .card-p {
            margin: 10px 0 20px 0;
            font-size: 16px;
        }

        .card-p-black {
            font-size: 16px;
        }

        .card-heading {
            font-size: 18px;
        }

        .card-subheading {
            font-size: 16px;
        }


        /* common css */
        header #wprmenu_bar {
            z-index: 99;
        }

        .sticky-heading {
            z-index: 99;
        }

        .banner {
            position: relative;
        }

        ul.banner-bottom-content {
            bottom: 0;
        }

        .banner-top-content h3 {
            font-size: 22px;
            min-height: 100px;
            letter-spacing: 4px;
        }

        ul.banner-bottom-content li {
            width: 30%;
        }

        .banner-bottom-content .team-img {
            width: auto;
        }

        .banner-bottom-content .team-img img {
            width: 100%;
        }

        ul.banner-bottom-content {
            margin: 70px 0 0;
            justify-content: space-evenly;
        }

        #youtube-modal .modal-dialog {
            max-width: max-content;
            margin: 1.75rem auto;
            top: 20px;
        }

        .bx-viewport:after {
            left: 50%;
            transform: translateX(-50%);
        }

        ul.banner-bottom-content li:nth-child(3), ul.banner-bottom-content li:nth-child(4) {
            display: none;
        }

        .accordion-body {
            padding: 15px 10px;
            border: 1px solid #80808024;
        }

        .accordion-button {
            color: #000;
            font-size: 15PX;
        }

        .accordion-button:not(.collapsed) {
            color: #007EBF;
        }

        .services h1 {
            font-size: 20px;
        }

        .service-flex {
            display: none;
        }

        .services .accordion span.nav-logo {
            width: 50px;
            height: auto;
        }

        .services .accordion span.nav-logo img {
            width: 100%;
        }

        .services .accordion-item h5 {
            color: #000;
        }

        .services .accordion-button {
            padding: 10px
        }

        .services .accordion-button:not(.collapsed) {
            background-color: #fff;

        }

        .services .nav-pills .nav-link.active, .services .nav-pills .nav-link {
            color: #007EBF;
            border: 0 solid transparent;
            border-radius: 0;
            background-color: transparent;
            position: relative;
            font-size: 15px;
            text-align: left;
            padding: 0 0 10px 25px;
        }

        .services .accordion button.nav-link:focus-visible {
            outline: none;
        }

        .services .accordion .tab-content h6 {
            font-size: 15px;
            padding: 20px 0 20px 0;
            margin: 0;
            color: #7B7B7B;
        }

        .services .accordion button.nav-link:before {
            content: '  101 ';
            font-family: 'FontAwesome';
            position: absolute;
            font-size: 18px;
            left: 0;
            line-height: 1.3;
            color: #7B7B7B;
        }

        .services .accordion button.nav-link.active:before {
            color: #007EBF;
        }

        .services .accordion button.nav-link {
            color: #7B7B7B;
        }

        .accordion-flush .accordion-item .accordion-button {
            box-shadow: 0 10px 20px #80808029;
        }

        .accordion-flush .accordion-item .accordion-button {
            box-shadow: 0 10px 20px #007ebf29;
        }

        .services .accordion button.nav-link:last-child {
            padding-bottom: 0;
        }


        .accordion-body .nav {
            display: flex;
            flex-direction: column;
            align-items: start;
        }


        .service-flex .nav#parent-pills-tab {
            flex-direction: column;
            width: 100%;
        }

        .service-flex .nav-pills#parent-pills-tab .nav-link.active:before, .nav-pills#parent-pills-tab .show > .nav-link {
            display: none;
        }

        .service-flex #parent-tab-content.tab-content {
            width: 100%;
        }

        .service-flex .nav-logo {
            width: 50px;
        }

        .service-flex #parent-tab-content.tab-content .nav-pills button {
            font-size: 16px;
            padding: 0 0 15px 25px;
        }

        .service-flex .tab-content h6 {
            font-size: 16px;
        }

        .service-tabs {
            display: none;
        }

        .accordion {
            display: block;
        }

        .awards .row {
            text-align: center;
        }

        .awards .content h3 {
            padding: 0 0 20px 0;
        }

        .awards .content h5 {
            margin-bottom: 25px;
        }

        .logos {
            width: 100px;
            height: 60px;
        }

        .partners .image {
            width: 100%;
            height: 100px;
            margin: auto;
        }

        .happy-client-carousel .owl-theme .owl-nav.disabled + .owl-dots {
            margin-top: 40px;
        }


        .quote-img {
            position: absolute;
            top: 5%;
            width: 35px;
            height: 25px;
            right: 0;
        }


        .happy-client-carousel .item {
            margin-top: 50px;
        }

        .play-button {
            top: 50%;
            right: 50%;
            transform: translate(50%, -50%);
            width: 70px;
        }

        .awards-img img {
            width: 80%;
        }

        .awards .content p {
            text-align: center;
            margin: 0 0 25px;
        }

        .client-text {
            padding: 0;
            align-items: center;
            position: relative;
        }

        .happy-client .client-text {
            font-size: 14px;
            padding: 20px;
        }

        .best-practices.spacing .heading h2 {
            font-size: 24px;
        }

        .sub-heading p {
            font-size: 16px;
        }


        .practices-card-outer {
            flex-direction: column;
        }

        .practices-card {
            padding: 15px;
            min-height: 330px;
            width: 100%;
        }

        .practices-card-outer .practices-card:not(:last-child) {
            margin-bottom: 20px;
        }

        .scale-brand-text h3 {
            font-size: 20px;
            padding-bottom: 10px;
        }

        .scale-brand-text p {
            font-size: 18px;
            padding: 0 0 20px;
        }


        footer .row .col-sm-6.col-12:first-child, footer .row .col-sm-6.col-12:nth-child(2), footer .row .col-sm-6.col-12:nth-child(3), footer .row .col-sm-6.col-12:nth-child(4) {
            padding: 0 15px 20px;
        }

        .heading4 {
            font-size: 18px;
            color: #fff;
            padding-top: 20px;
        }

        footer ul li {
            padding-bottom: 8px;
            padding: 5px 0 0 0;
        }


        .bottom-bar ul li {
            display: inline-block;
            position: relative;
            text-align: left;
            padding: 0px;
            border-right: 1px solid #1E1E20;
            margin: 0 10px 0 0;
        }

        .bottom-bar ul li:not(:last-child) {
            padding: 0;
        }

        .bottom-bar ul li a {
            padding: 10px;
        }

        .bottom-bar ul li:last-child {
            margin-top: 10px;
        }

        .copyright ul {
            text-align: center;
        }

        .copyright p {
            text-align: center;
        }

        lottie-player {
            width: 200px;
            height: auto;
            margin: 0 auto;
        }

        .get-started h5.form-heading {
            margin: 15px 0;
            font-size: 20px;
        }

        .left-right, .right-left {
            padding: 35px 0;
        }

        .marketing-logo .row .col-2 {
            width: auto;
        }

        .customer-images .image {
            width: 100px;
            height: 100px;
        }

        .customer-images .row {
            width: 100%;
            margin: auto;
        }

        .customer-images .row .col-md-3 {
            width: 100%;
            max-width: 50%;
        }

        .yr-text:after {
            display: none;
        }

        .yr-text h4 {
            width: 100px;
            text-align: center;
        }

        .case-study .row .col-md-6:not(:first-child) {
            margin: 50px 0 0 0;
        }

        .case-study .card-body {
            padding: 30px 10px 20px 10px;
        }

        .case-study .card-body .card-p {
            margin: 10px 0 10px 0;;
            padding: 0;
            font-size: 16px;
        }

        /*  marketing automation starts  */
        .growth-hacking .cards-row .row .col-md-4.col-12:not(:last-child), .marketing-solution .cards-row .row .col-md-4.col-12:not(:last-child) {
            margin: 0 0 20px;
        }

        .growth-hacking .growth-card .card-body h5 br {
            display: none;
        }

        .marketing-services .row .col-md-6.col-12:not(:last-child) {
            margin: 0 0 30px 0;
        }

        ul.marketing-list li {
            font-size: 14px;
        }

        .marketing-solution .row .col-md-4.col-12 {
            width: unset;
        }

        .marketing-services .right-left:nth-of-type(4) {
            padding: 35px 0 0;
        }

        .marketing-automation .awards .content h4 {
            text-align: center;
        }

        .marketing-solution .card h5 {
            min-height: auto;
        }

        .marketing-solution .row .col-md-4.col-12:last-child {
            margin: 0px 0 0 0;
        }

        .methodology lottie-player {
            width: auto;
            height: auto;
            margin: 0 auto;
        }

        /*  marketing automation ends  */
        /* blog listing starts */
        .inner-banner li.nav-item:last-child {
            margin: 0 0 20px;
        }

        .inner-banner ul .nav-item a.nav-link {
            font-size: 13px;
            margin: 0 0 5px;
        }

        .inner-banner {
            height: auto;
        }

        ul.navbar-nav li:last-child button {
            font-size: 13px;
        }

        ul.navbar-nav li:last-child .dropdown-toggle::after, .inner-banner ul .dropdown-toggle.show[aria-expanded=true]:after {
            font-size: 15px;
        }

        .inner-banner-lottie {
            display: none;
        }

        .blogs .practices-card {
            width: auto;
        }

        .blogs .practices-card-outer .practices-card:last-child {
            margin: 0;
        }

        .blogs .practices-card button.btn.submit {
            margin: 20px 0 0 0;
        }


        .pagination {
            padding: 35px 0 0 0;
        }

        /* blog listing ends */
        /* blog detail starts */
        .blog-detail .container {
            display: flex;
            flex-direction: column-reverse;
        }

        .blog-detail ul.social-links {
            position: relative;
            transform: unset;
            display: flex;
            flex-direction: row;
            padding: 35px 0 0px;
            align-items: center;
            justify-content: center;
        }

        .blog-detail .social-links li:not(:last-child) {
            margin: 0 5px 0 0;
        }

        .newsletter .container:before {
            font-size: 16px;
            width: 35px;
            height: 35px;
        }

        .newsletter form {
            flex-direction: column;
        }

        .newsletter .content {
            padding: 35px 20px;
        }

        .newsletter .form-control {
            margin: 0 0 20px 0;
            height: 40px;
            font-size: 16px;
        }

        .submit {
            font-size: 14px;
            height: 40px;
            width: 126px;
        }

        /* blog detail ends */
        /*   press release starts */
        .horizontal-blog-card {
            padding: 35px 0 0;
        }

        .horizontal-blog-card .card {
            padding: 20px 35px;
        }

        .horizontal-blog-card .card-body {
            padding: 10px 0 10px 0px;
        }

        /*   press release ends */
        /* ebook detail starts */
        .ebook-detail .inner-banner {
            height: 100%;
        }

        .ebook-download form input#download-ebook {
            width: 100%;
            margin: 0;
            height: 40px;
        }

        .ebook-download form {
            flex-direction: column;
        }

        .ebook-download .submit {
            width: 100%;
            margin: 20px 0;
        }

        .ebook-img {
            width: 60%;
        }

        /* ebook detail ends */
        /*    salesforce starts */
        .salesforce-expertise .cards-row .row .col-md-4.col-12:not(:last-child) {
            margin-bottom: 30px;
        }

        .choose-gn .blue-btn {
            margin-top: 35px;
        }

        .salesforce-services .row .col-4 {
            width: 30%;
        }

        .salesforce-app .row {
            flex-direction: column-reverse;
        }

        .salesforce-app .row .col-md-6.col-12:not(:first-child) {
            margin-bottom: 30px;
        }

        .salesforce ul.marketing-list li, .choose-list li, .salesforce-app .heading, .salesforce-app .content p {
            text-align: center;
        }

        .s-content h6 {
            font-size: 16px;
        }

        .salesforce-app .blue-btn {
            justify-content: center;
            width: 100%;
        }

        /*    salesforce ends */
        /*   leadership starts  */
        .founders-modal .modal-body {
            padding: 20px;
        }

        .founders-modal .modal-dialog {
            margin: 0
        }

        .founders-modal .modal-content {
            width: 90%;
            margin: 100px auto;
        }

        .founders-modal .modal-body {
            padding: 30px 25px;
        }

        .cross-btn {
            top: 2%;
            font-size: 15px;
        }

        .founders-modal .content {
            padding: 30px 0 0 0px;
        }

        .founders-modal .modal-body .content .heading {
            text-align: center;
        }

        .founders-modal .modal-body .content h6 {
            text-align: center;
        }

        .founders .col-md-5.col-12 {
            width: 100%;
        }

        .founders .row .col-md-5:not(:last-child) {
            margin: 0 0 20px 0;
        }

        .founders .card .card-body {
            padding: 0;
        }

        .founders .card .card-body h5,
        .founders .card .card-body p {
            text-align: center;
        }

        .natives-life-image {
            height: 120px;
        }

        /*    salesforce landing page starts */
        .page-template-salesforce-lp header,
        .page-template-web-dev-audit header {
            display: block;
        }

        .page-template-salesforce-lp .inner-banner,
        .page-template-web-dev-audit .inner-banner {
            padding: 35px 0 0 0;
        }

        .page-template-salesforce-lp .inner-banner .row .col-md-7,
        .page-template-salesforce-lp .inner-banner .row .col-md-5, .page-template-web-dev-audit .inner-banner .row .col-md-7,
        .page-template-web-dev-audit .inner-banner .row .col-md-5 {
            padding-bottom: 25px;
        }

        /*    salesforce landing page ends */
        /*    thank you starts */
        .thanks-img {
            width: 45px;
            height: 45px;
            margin: 0 auto 15px;
        }

        .thanks {
            padding: 130px 0 35px;
            height: auto;
        }

        .thank-you #wprmenu_bar div.hamburger {
            display: none;
        }

        .thank-you div#mg-wprm-wrap {
            display: none;
        }

        .thank-you html body div.wprm-wrapper {
            display: none;
        }

        /*    thank you ends */
        .inner-banner .row .col-md-7:not(:last-child) {
            padding-right: 35px;
        }

        .page-template-salesforce-lp .inner-banner, .page-template-web-dev-audit .inner-banner {
            height: auto;
            padding: 90px 0 0px 0;
        }

        .inner-banner-content h1 {
            font-size: 24px;
        }

        nav.navbar.navbar-expand-lg.navbar-light {
        padding: 10px;
        }
        .page-template-salesforce-lp .inner-list, .page-template-web-dev-audit .inner-list {
            font-size: 16px;
            padding: 0 0 0 15px;
        }
        .page-template-salesforce-lp .inner-banner-description p, .page-template-web-dev-audit .inner-banner-description p{
            font-size: 16px;
            padding: 10px 0;
        }.inner-banner-content h1 {
             font-size: 24px;
         }
    }
</style>