/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@wordpress/icons/build-module/icon/index.js":
/*!******************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/icon/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */

/** @typedef {{icon: JSX.Element, size?: number} & import('@wordpress/primitives').SVGProps} IconProps */

/**
 * Return an SVG icon.
 *
 * @param {IconProps} props icon is the SVG component to render
 *                          size is a number specifiying the icon size in pixels
 *                          Other props will be passed to wrapped SVG component
 *
 * @return {JSX.Element}  Icon component
 */

function Icon(_ref) {
  let {
    icon,
    size = 24,
    ...props
  } = _ref;
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(icon, {
    width: size,
    height: size,
    ...props
  });
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Icon);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/arrow-right.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/arrow-right.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const arrowRight = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M14.3 6.7l-1.1 1.1 4 4H4v1.5h13.3l-4.1 4.4 1.1 1.1 5.8-6.3z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (arrowRight);
//# sourceMappingURL=arrow-right.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/chevron-down.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/chevron-down.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const chevronDown = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M17.5 11.6L12 16l-5.5-4.4.9-1.2L12 14l4.5-3.6 1 1.2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (chevronDown);
//# sourceMappingURL=chevron-down.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/chevron-up.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/chevron-up.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const chevronUp = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M6.5 12.4L12 8l5.5 4.4-.9 1.2L12 10l-4.5 3.6-1-1.2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (chevronUp);
//# sourceMappingURL=chevron-up.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/close.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/close.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const close = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M13 11.8l6.1-6.3-1-1-6.1 6.2-6.1-6.2-1 1 6.1 6.3-6.5 6.7 1 1 6.5-6.6 6.5 6.6 1-1z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (close);
//# sourceMappingURL=close.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/link-off.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/link-off.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const linkOff = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M15.6 7.3h-.7l1.6-3.5-.9-.4-3.9 8.5H9v1.5h2l-1.3 2.8H8.4c-2 0-3.7-1.7-3.7-3.7s1.7-3.7 3.7-3.7H10V7.3H8.4c-2.9 0-5.2 2.3-5.2 5.2 0 2.9 2.3 5.2 5.2 5.2H9l-1.4 3.2.9.4 5.7-12.5h1.4c2 0 3.7 1.7 3.7 3.7s-1.7 3.7-3.7 3.7H14v1.5h1.6c2.9 0 5.2-2.3 5.2-5.2 0-2.9-2.4-5.2-5.2-5.2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (linkOff);
//# sourceMappingURL=link-off.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/link.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/link.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const link = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M15.6 7.2H14v1.5h1.6c2 0 3.7 1.7 3.7 3.7s-1.7 3.7-3.7 3.7H14v1.5h1.6c2.8 0 5.2-2.3 5.2-5.2 0-2.9-2.3-5.2-5.2-5.2zM4.7 12.4c0-2 1.7-3.7 3.7-3.7H10V7.2H8.4c-2.9 0-5.2 2.3-5.2 5.2 0 2.9 2.3 5.2 5.2 5.2H10v-1.5H8.4c-2 0-3.7-1.7-3.7-3.7zm4.6.9h5.3v-1.5H9.3v1.5z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (link);
//# sourceMappingURL=link.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/menu.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/menu.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const menu = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M5 5v1.5h14V5H5zm0 7.8h14v-1.5H5v1.5zM5 19h14v-1.5H5V19z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (menu);
//# sourceMappingURL=menu.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/plus.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/plus.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const plus = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M18 11.2h-5.2V6h-1.6v5.2H6v1.6h5.2V18h1.6v-5.2H18z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (plus);
//# sourceMappingURL=plus.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/settings.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/settings.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const settings = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M14.5 13.8c-1.1 0-2.1.7-2.4 1.8H4V17h8.1c.3 1 1.3 1.8 2.4 1.8s2.1-.7 2.4-1.8H20v-1.5h-3.1c-.3-1-1.3-1.7-2.4-1.7zM11.9 7c-.3-1-1.3-1.8-2.4-1.8S7.4 6 7.1 7H4v1.5h3.1c.3 1 1.3 1.8 2.4 1.8s2.1-.7 2.4-1.8H20V7h-8.1z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (settings);
//# sourceMappingURL=settings.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/styles.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/styles.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "styles": () => (/* binding */ styles)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const styles = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M12 4c-4.4 0-8 3.6-8 8v.1c0 4.1 3.2 7.5 7.2 7.9h.8c4.4 0 8-3.6 8-8s-3.6-8-8-8zm0 15V5c3.9 0 7 3.1 7 7s-3.1 7-7 7z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (styles);
//# sourceMappingURL=styles.js.map

/***/ }),

/***/ "./node_modules/animejs/lib/anime.es.js":
/*!**********************************************!*\
  !*** ./node_modules/animejs/lib/anime.es.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
 * anime.js v3.2.1
 * (c) 2020 Julian Garnier
 * Released under the MIT license
 * animejs.com
 */

// Defaults

var defaultInstanceSettings = {
  update: null,
  begin: null,
  loopBegin: null,
  changeBegin: null,
  change: null,
  changeComplete: null,
  loopComplete: null,
  complete: null,
  loop: 1,
  direction: 'normal',
  autoplay: true,
  timelineOffset: 0
};

var defaultTweenSettings = {
  duration: 1000,
  delay: 0,
  endDelay: 0,
  easing: 'easeOutElastic(1, .5)',
  round: 0
};

var validTransforms = ['translateX', 'translateY', 'translateZ', 'rotate', 'rotateX', 'rotateY', 'rotateZ', 'scale', 'scaleX', 'scaleY', 'scaleZ', 'skew', 'skewX', 'skewY', 'perspective', 'matrix', 'matrix3d'];

// Caching

var cache = {
  CSS: {},
  springs: {}
};

// Utils

function minMax(val, min, max) {
  return Math.min(Math.max(val, min), max);
}

function stringContains(str, text) {
  return str.indexOf(text) > -1;
}

function applyArguments(func, args) {
  return func.apply(null, args);
}

var is = {
  arr: function (a) { return Array.isArray(a); },
  obj: function (a) { return stringContains(Object.prototype.toString.call(a), 'Object'); },
  pth: function (a) { return is.obj(a) && a.hasOwnProperty('totalLength'); },
  svg: function (a) { return a instanceof SVGElement; },
  inp: function (a) { return a instanceof HTMLInputElement; },
  dom: function (a) { return a.nodeType || is.svg(a); },
  str: function (a) { return typeof a === 'string'; },
  fnc: function (a) { return typeof a === 'function'; },
  und: function (a) { return typeof a === 'undefined'; },
  nil: function (a) { return is.und(a) || a === null; },
  hex: function (a) { return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(a); },
  rgb: function (a) { return /^rgb/.test(a); },
  hsl: function (a) { return /^hsl/.test(a); },
  col: function (a) { return (is.hex(a) || is.rgb(a) || is.hsl(a)); },
  key: function (a) { return !defaultInstanceSettings.hasOwnProperty(a) && !defaultTweenSettings.hasOwnProperty(a) && a !== 'targets' && a !== 'keyframes'; },
};

// Easings

function parseEasingParameters(string) {
  var match = /\(([^)]+)\)/.exec(string);
  return match ? match[1].split(',').map(function (p) { return parseFloat(p); }) : [];
}

// Spring solver inspired by Webkit Copyright © 2016 Apple Inc. All rights reserved. https://webkit.org/demos/spring/spring.js

function spring(string, duration) {

  var params = parseEasingParameters(string);
  var mass = minMax(is.und(params[0]) ? 1 : params[0], .1, 100);
  var stiffness = minMax(is.und(params[1]) ? 100 : params[1], .1, 100);
  var damping = minMax(is.und(params[2]) ? 10 : params[2], .1, 100);
  var velocity =  minMax(is.und(params[3]) ? 0 : params[3], .1, 100);
  var w0 = Math.sqrt(stiffness / mass);
  var zeta = damping / (2 * Math.sqrt(stiffness * mass));
  var wd = zeta < 1 ? w0 * Math.sqrt(1 - zeta * zeta) : 0;
  var a = 1;
  var b = zeta < 1 ? (zeta * w0 + -velocity) / wd : -velocity + w0;

  function solver(t) {
    var progress = duration ? (duration * t) / 1000 : t;
    if (zeta < 1) {
      progress = Math.exp(-progress * zeta * w0) * (a * Math.cos(wd * progress) + b * Math.sin(wd * progress));
    } else {
      progress = (a + b * progress) * Math.exp(-progress * w0);
    }
    if (t === 0 || t === 1) { return t; }
    return 1 - progress;
  }

  function getDuration() {
    var cached = cache.springs[string];
    if (cached) { return cached; }
    var frame = 1/6;
    var elapsed = 0;
    var rest = 0;
    while(true) {
      elapsed += frame;
      if (solver(elapsed) === 1) {
        rest++;
        if (rest >= 16) { break; }
      } else {
        rest = 0;
      }
    }
    var duration = elapsed * frame * 1000;
    cache.springs[string] = duration;
    return duration;
  }

  return duration ? solver : getDuration;

}

// Basic steps easing implementation https://developer.mozilla.org/fr/docs/Web/CSS/transition-timing-function

function steps(steps) {
  if ( steps === void 0 ) steps = 10;

  return function (t) { return Math.ceil((minMax(t, 0.000001, 1)) * steps) * (1 / steps); };
}

// BezierEasing https://github.com/gre/bezier-easing

var bezier = (function () {

  var kSplineTableSize = 11;
  var kSampleStepSize = 1.0 / (kSplineTableSize - 1.0);

  function A(aA1, aA2) { return 1.0 - 3.0 * aA2 + 3.0 * aA1 }
  function B(aA1, aA2) { return 3.0 * aA2 - 6.0 * aA1 }
  function C(aA1)      { return 3.0 * aA1 }

  function calcBezier(aT, aA1, aA2) { return ((A(aA1, aA2) * aT + B(aA1, aA2)) * aT + C(aA1)) * aT }
  function getSlope(aT, aA1, aA2) { return 3.0 * A(aA1, aA2) * aT * aT + 2.0 * B(aA1, aA2) * aT + C(aA1) }

  function binarySubdivide(aX, aA, aB, mX1, mX2) {
    var currentX, currentT, i = 0;
    do {
      currentT = aA + (aB - aA) / 2.0;
      currentX = calcBezier(currentT, mX1, mX2) - aX;
      if (currentX > 0.0) { aB = currentT; } else { aA = currentT; }
    } while (Math.abs(currentX) > 0.0000001 && ++i < 10);
    return currentT;
  }

  function newtonRaphsonIterate(aX, aGuessT, mX1, mX2) {
    for (var i = 0; i < 4; ++i) {
      var currentSlope = getSlope(aGuessT, mX1, mX2);
      if (currentSlope === 0.0) { return aGuessT; }
      var currentX = calcBezier(aGuessT, mX1, mX2) - aX;
      aGuessT -= currentX / currentSlope;
    }
    return aGuessT;
  }

  function bezier(mX1, mY1, mX2, mY2) {

    if (!(0 <= mX1 && mX1 <= 1 && 0 <= mX2 && mX2 <= 1)) { return; }
    var sampleValues = new Float32Array(kSplineTableSize);

    if (mX1 !== mY1 || mX2 !== mY2) {
      for (var i = 0; i < kSplineTableSize; ++i) {
        sampleValues[i] = calcBezier(i * kSampleStepSize, mX1, mX2);
      }
    }

    function getTForX(aX) {

      var intervalStart = 0;
      var currentSample = 1;
      var lastSample = kSplineTableSize - 1;

      for (; currentSample !== lastSample && sampleValues[currentSample] <= aX; ++currentSample) {
        intervalStart += kSampleStepSize;
      }

      --currentSample;

      var dist = (aX - sampleValues[currentSample]) / (sampleValues[currentSample + 1] - sampleValues[currentSample]);
      var guessForT = intervalStart + dist * kSampleStepSize;
      var initialSlope = getSlope(guessForT, mX1, mX2);

      if (initialSlope >= 0.001) {
        return newtonRaphsonIterate(aX, guessForT, mX1, mX2);
      } else if (initialSlope === 0.0) {
        return guessForT;
      } else {
        return binarySubdivide(aX, intervalStart, intervalStart + kSampleStepSize, mX1, mX2);
      }

    }

    return function (x) {
      if (mX1 === mY1 && mX2 === mY2) { return x; }
      if (x === 0 || x === 1) { return x; }
      return calcBezier(getTForX(x), mY1, mY2);
    }

  }

  return bezier;

})();

var penner = (function () {

  // Based on jQuery UI's implemenation of easing equations from Robert Penner (http://www.robertpenner.com/easing)

  var eases = { linear: function () { return function (t) { return t; }; } };

  var functionEasings = {
    Sine: function () { return function (t) { return 1 - Math.cos(t * Math.PI / 2); }; },
    Circ: function () { return function (t) { return 1 - Math.sqrt(1 - t * t); }; },
    Back: function () { return function (t) { return t * t * (3 * t - 2); }; },
    Bounce: function () { return function (t) {
      var pow2, b = 4;
      while (t < (( pow2 = Math.pow(2, --b)) - 1) / 11) {}
      return 1 / Math.pow(4, 3 - b) - 7.5625 * Math.pow(( pow2 * 3 - 2 ) / 22 - t, 2)
    }; },
    Elastic: function (amplitude, period) {
      if ( amplitude === void 0 ) amplitude = 1;
      if ( period === void 0 ) period = .5;

      var a = minMax(amplitude, 1, 10);
      var p = minMax(period, .1, 2);
      return function (t) {
        return (t === 0 || t === 1) ? t : 
          -a * Math.pow(2, 10 * (t - 1)) * Math.sin((((t - 1) - (p / (Math.PI * 2) * Math.asin(1 / a))) * (Math.PI * 2)) / p);
      }
    }
  };

  var baseEasings = ['Quad', 'Cubic', 'Quart', 'Quint', 'Expo'];

  baseEasings.forEach(function (name, i) {
    functionEasings[name] = function () { return function (t) { return Math.pow(t, i + 2); }; };
  });

  Object.keys(functionEasings).forEach(function (name) {
    var easeIn = functionEasings[name];
    eases['easeIn' + name] = easeIn;
    eases['easeOut' + name] = function (a, b) { return function (t) { return 1 - easeIn(a, b)(1 - t); }; };
    eases['easeInOut' + name] = function (a, b) { return function (t) { return t < 0.5 ? easeIn(a, b)(t * 2) / 2 : 
      1 - easeIn(a, b)(t * -2 + 2) / 2; }; };
    eases['easeOutIn' + name] = function (a, b) { return function (t) { return t < 0.5 ? (1 - easeIn(a, b)(1 - t * 2)) / 2 : 
      (easeIn(a, b)(t * 2 - 1) + 1) / 2; }; };
  });

  return eases;

})();

function parseEasings(easing, duration) {
  if (is.fnc(easing)) { return easing; }
  var name = easing.split('(')[0];
  var ease = penner[name];
  var args = parseEasingParameters(easing);
  switch (name) {
    case 'spring' : return spring(easing, duration);
    case 'cubicBezier' : return applyArguments(bezier, args);
    case 'steps' : return applyArguments(steps, args);
    default : return applyArguments(ease, args);
  }
}

// Strings

function selectString(str) {
  try {
    var nodes = document.querySelectorAll(str);
    return nodes;
  } catch(e) {
    return;
  }
}

// Arrays

function filterArray(arr, callback) {
  var len = arr.length;
  var thisArg = arguments.length >= 2 ? arguments[1] : void 0;
  var result = [];
  for (var i = 0; i < len; i++) {
    if (i in arr) {
      var val = arr[i];
      if (callback.call(thisArg, val, i, arr)) {
        result.push(val);
      }
    }
  }
  return result;
}

function flattenArray(arr) {
  return arr.reduce(function (a, b) { return a.concat(is.arr(b) ? flattenArray(b) : b); }, []);
}

function toArray(o) {
  if (is.arr(o)) { return o; }
  if (is.str(o)) { o = selectString(o) || o; }
  if (o instanceof NodeList || o instanceof HTMLCollection) { return [].slice.call(o); }
  return [o];
}

function arrayContains(arr, val) {
  return arr.some(function (a) { return a === val; });
}

// Objects

function cloneObject(o) {
  var clone = {};
  for (var p in o) { clone[p] = o[p]; }
  return clone;
}

function replaceObjectProps(o1, o2) {
  var o = cloneObject(o1);
  for (var p in o1) { o[p] = o2.hasOwnProperty(p) ? o2[p] : o1[p]; }
  return o;
}

function mergeObjects(o1, o2) {
  var o = cloneObject(o1);
  for (var p in o2) { o[p] = is.und(o1[p]) ? o2[p] : o1[p]; }
  return o;
}

// Colors

function rgbToRgba(rgbValue) {
  var rgb = /rgb\((\d+,\s*[\d]+,\s*[\d]+)\)/g.exec(rgbValue);
  return rgb ? ("rgba(" + (rgb[1]) + ",1)") : rgbValue;
}

function hexToRgba(hexValue) {
  var rgx = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
  var hex = hexValue.replace(rgx, function (m, r, g, b) { return r + r + g + g + b + b; } );
  var rgb = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
  var r = parseInt(rgb[1], 16);
  var g = parseInt(rgb[2], 16);
  var b = parseInt(rgb[3], 16);
  return ("rgba(" + r + "," + g + "," + b + ",1)");
}

function hslToRgba(hslValue) {
  var hsl = /hsl\((\d+),\s*([\d.]+)%,\s*([\d.]+)%\)/g.exec(hslValue) || /hsla\((\d+),\s*([\d.]+)%,\s*([\d.]+)%,\s*([\d.]+)\)/g.exec(hslValue);
  var h = parseInt(hsl[1], 10) / 360;
  var s = parseInt(hsl[2], 10) / 100;
  var l = parseInt(hsl[3], 10) / 100;
  var a = hsl[4] || 1;
  function hue2rgb(p, q, t) {
    if (t < 0) { t += 1; }
    if (t > 1) { t -= 1; }
    if (t < 1/6) { return p + (q - p) * 6 * t; }
    if (t < 1/2) { return q; }
    if (t < 2/3) { return p + (q - p) * (2/3 - t) * 6; }
    return p;
  }
  var r, g, b;
  if (s == 0) {
    r = g = b = l;
  } else {
    var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
    var p = 2 * l - q;
    r = hue2rgb(p, q, h + 1/3);
    g = hue2rgb(p, q, h);
    b = hue2rgb(p, q, h - 1/3);
  }
  return ("rgba(" + (r * 255) + "," + (g * 255) + "," + (b * 255) + "," + a + ")");
}

function colorToRgb(val) {
  if (is.rgb(val)) { return rgbToRgba(val); }
  if (is.hex(val)) { return hexToRgba(val); }
  if (is.hsl(val)) { return hslToRgba(val); }
}

// Units

function getUnit(val) {
  var split = /[+-]?\d*\.?\d+(?:\.\d+)?(?:[eE][+-]?\d+)?(%|px|pt|em|rem|in|cm|mm|ex|ch|pc|vw|vh|vmin|vmax|deg|rad|turn)?$/.exec(val);
  if (split) { return split[1]; }
}

function getTransformUnit(propName) {
  if (stringContains(propName, 'translate') || propName === 'perspective') { return 'px'; }
  if (stringContains(propName, 'rotate') || stringContains(propName, 'skew')) { return 'deg'; }
}

// Values

function getFunctionValue(val, animatable) {
  if (!is.fnc(val)) { return val; }
  return val(animatable.target, animatable.id, animatable.total);
}

function getAttribute(el, prop) {
  return el.getAttribute(prop);
}

function convertPxToUnit(el, value, unit) {
  var valueUnit = getUnit(value);
  if (arrayContains([unit, 'deg', 'rad', 'turn'], valueUnit)) { return value; }
  var cached = cache.CSS[value + unit];
  if (!is.und(cached)) { return cached; }
  var baseline = 100;
  var tempEl = document.createElement(el.tagName);
  var parentEl = (el.parentNode && (el.parentNode !== document)) ? el.parentNode : document.body;
  parentEl.appendChild(tempEl);
  tempEl.style.position = 'absolute';
  tempEl.style.width = baseline + unit;
  var factor = baseline / tempEl.offsetWidth;
  parentEl.removeChild(tempEl);
  var convertedUnit = factor * parseFloat(value);
  cache.CSS[value + unit] = convertedUnit;
  return convertedUnit;
}

function getCSSValue(el, prop, unit) {
  if (prop in el.style) {
    var uppercasePropName = prop.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase();
    var value = el.style[prop] || getComputedStyle(el).getPropertyValue(uppercasePropName) || '0';
    return unit ? convertPxToUnit(el, value, unit) : value;
  }
}

function getAnimationType(el, prop) {
  if (is.dom(el) && !is.inp(el) && (!is.nil(getAttribute(el, prop)) || (is.svg(el) && el[prop]))) { return 'attribute'; }
  if (is.dom(el) && arrayContains(validTransforms, prop)) { return 'transform'; }
  if (is.dom(el) && (prop !== 'transform' && getCSSValue(el, prop))) { return 'css'; }
  if (el[prop] != null) { return 'object'; }
}

function getElementTransforms(el) {
  if (!is.dom(el)) { return; }
  var str = el.style.transform || '';
  var reg  = /(\w+)\(([^)]*)\)/g;
  var transforms = new Map();
  var m; while (m = reg.exec(str)) { transforms.set(m[1], m[2]); }
  return transforms;
}

function getTransformValue(el, propName, animatable, unit) {
  var defaultVal = stringContains(propName, 'scale') ? 1 : 0 + getTransformUnit(propName);
  var value = getElementTransforms(el).get(propName) || defaultVal;
  if (animatable) {
    animatable.transforms.list.set(propName, value);
    animatable.transforms['last'] = propName;
  }
  return unit ? convertPxToUnit(el, value, unit) : value;
}

function getOriginalTargetValue(target, propName, unit, animatable) {
  switch (getAnimationType(target, propName)) {
    case 'transform': return getTransformValue(target, propName, animatable, unit);
    case 'css': return getCSSValue(target, propName, unit);
    case 'attribute': return getAttribute(target, propName);
    default: return target[propName] || 0;
  }
}

function getRelativeValue(to, from) {
  var operator = /^(\*=|\+=|-=)/.exec(to);
  if (!operator) { return to; }
  var u = getUnit(to) || 0;
  var x = parseFloat(from);
  var y = parseFloat(to.replace(operator[0], ''));
  switch (operator[0][0]) {
    case '+': return x + y + u;
    case '-': return x - y + u;
    case '*': return x * y + u;
  }
}

function validateValue(val, unit) {
  if (is.col(val)) { return colorToRgb(val); }
  if (/\s/g.test(val)) { return val; }
  var originalUnit = getUnit(val);
  var unitLess = originalUnit ? val.substr(0, val.length - originalUnit.length) : val;
  if (unit) { return unitLess + unit; }
  return unitLess;
}

// getTotalLength() equivalent for circle, rect, polyline, polygon and line shapes
// adapted from https://gist.github.com/SebLambla/3e0550c496c236709744

function getDistance(p1, p2) {
  return Math.sqrt(Math.pow(p2.x - p1.x, 2) + Math.pow(p2.y - p1.y, 2));
}

function getCircleLength(el) {
  return Math.PI * 2 * getAttribute(el, 'r');
}

function getRectLength(el) {
  return (getAttribute(el, 'width') * 2) + (getAttribute(el, 'height') * 2);
}

function getLineLength(el) {
  return getDistance(
    {x: getAttribute(el, 'x1'), y: getAttribute(el, 'y1')}, 
    {x: getAttribute(el, 'x2'), y: getAttribute(el, 'y2')}
  );
}

function getPolylineLength(el) {
  var points = el.points;
  var totalLength = 0;
  var previousPos;
  for (var i = 0 ; i < points.numberOfItems; i++) {
    var currentPos = points.getItem(i);
    if (i > 0) { totalLength += getDistance(previousPos, currentPos); }
    previousPos = currentPos;
  }
  return totalLength;
}

function getPolygonLength(el) {
  var points = el.points;
  return getPolylineLength(el) + getDistance(points.getItem(points.numberOfItems - 1), points.getItem(0));
}

// Path animation

function getTotalLength(el) {
  if (el.getTotalLength) { return el.getTotalLength(); }
  switch(el.tagName.toLowerCase()) {
    case 'circle': return getCircleLength(el);
    case 'rect': return getRectLength(el);
    case 'line': return getLineLength(el);
    case 'polyline': return getPolylineLength(el);
    case 'polygon': return getPolygonLength(el);
  }
}

function setDashoffset(el) {
  var pathLength = getTotalLength(el);
  el.setAttribute('stroke-dasharray', pathLength);
  return pathLength;
}

// Motion path

function getParentSvgEl(el) {
  var parentEl = el.parentNode;
  while (is.svg(parentEl)) {
    if (!is.svg(parentEl.parentNode)) { break; }
    parentEl = parentEl.parentNode;
  }
  return parentEl;
}

function getParentSvg(pathEl, svgData) {
  var svg = svgData || {};
  var parentSvgEl = svg.el || getParentSvgEl(pathEl);
  var rect = parentSvgEl.getBoundingClientRect();
  var viewBoxAttr = getAttribute(parentSvgEl, 'viewBox');
  var width = rect.width;
  var height = rect.height;
  var viewBox = svg.viewBox || (viewBoxAttr ? viewBoxAttr.split(' ') : [0, 0, width, height]);
  return {
    el: parentSvgEl,
    viewBox: viewBox,
    x: viewBox[0] / 1,
    y: viewBox[1] / 1,
    w: width,
    h: height,
    vW: viewBox[2],
    vH: viewBox[3]
  }
}

function getPath(path, percent) {
  var pathEl = is.str(path) ? selectString(path)[0] : path;
  var p = percent || 100;
  return function(property) {
    return {
      property: property,
      el: pathEl,
      svg: getParentSvg(pathEl),
      totalLength: getTotalLength(pathEl) * (p / 100)
    }
  }
}

function getPathProgress(path, progress, isPathTargetInsideSVG) {
  function point(offset) {
    if ( offset === void 0 ) offset = 0;

    var l = progress + offset >= 1 ? progress + offset : 0;
    return path.el.getPointAtLength(l);
  }
  var svg = getParentSvg(path.el, path.svg);
  var p = point();
  var p0 = point(-1);
  var p1 = point(+1);
  var scaleX = isPathTargetInsideSVG ? 1 : svg.w / svg.vW;
  var scaleY = isPathTargetInsideSVG ? 1 : svg.h / svg.vH;
  switch (path.property) {
    case 'x': return (p.x - svg.x) * scaleX;
    case 'y': return (p.y - svg.y) * scaleY;
    case 'angle': return Math.atan2(p1.y - p0.y, p1.x - p0.x) * 180 / Math.PI;
  }
}

// Decompose value

function decomposeValue(val, unit) {
  // const rgx = /-?\d*\.?\d+/g; // handles basic numbers
  // const rgx = /[+-]?\d+(?:\.\d+)?(?:[eE][+-]?\d+)?/g; // handles exponents notation
  var rgx = /[+-]?\d*\.?\d+(?:\.\d+)?(?:[eE][+-]?\d+)?/g; // handles exponents notation
  var value = validateValue((is.pth(val) ? val.totalLength : val), unit) + '';
  return {
    original: value,
    numbers: value.match(rgx) ? value.match(rgx).map(Number) : [0],
    strings: (is.str(val) || unit) ? value.split(rgx) : []
  }
}

// Animatables

function parseTargets(targets) {
  var targetsArray = targets ? (flattenArray(is.arr(targets) ? targets.map(toArray) : toArray(targets))) : [];
  return filterArray(targetsArray, function (item, pos, self) { return self.indexOf(item) === pos; });
}

function getAnimatables(targets) {
  var parsed = parseTargets(targets);
  return parsed.map(function (t, i) {
    return {target: t, id: i, total: parsed.length, transforms: { list: getElementTransforms(t) } };
  });
}

// Properties

function normalizePropertyTweens(prop, tweenSettings) {
  var settings = cloneObject(tweenSettings);
  // Override duration if easing is a spring
  if (/^spring/.test(settings.easing)) { settings.duration = spring(settings.easing); }
  if (is.arr(prop)) {
    var l = prop.length;
    var isFromTo = (l === 2 && !is.obj(prop[0]));
    if (!isFromTo) {
      // Duration divided by the number of tweens
      if (!is.fnc(tweenSettings.duration)) { settings.duration = tweenSettings.duration / l; }
    } else {
      // Transform [from, to] values shorthand to a valid tween value
      prop = {value: prop};
    }
  }
  var propArray = is.arr(prop) ? prop : [prop];
  return propArray.map(function (v, i) {
    var obj = (is.obj(v) && !is.pth(v)) ? v : {value: v};
    // Default delay value should only be applied to the first tween
    if (is.und(obj.delay)) { obj.delay = !i ? tweenSettings.delay : 0; }
    // Default endDelay value should only be applied to the last tween
    if (is.und(obj.endDelay)) { obj.endDelay = i === propArray.length - 1 ? tweenSettings.endDelay : 0; }
    return obj;
  }).map(function (k) { return mergeObjects(k, settings); });
}


function flattenKeyframes(keyframes) {
  var propertyNames = filterArray(flattenArray(keyframes.map(function (key) { return Object.keys(key); })), function (p) { return is.key(p); })
  .reduce(function (a,b) { if (a.indexOf(b) < 0) { a.push(b); } return a; }, []);
  var properties = {};
  var loop = function ( i ) {
    var propName = propertyNames[i];
    properties[propName] = keyframes.map(function (key) {
      var newKey = {};
      for (var p in key) {
        if (is.key(p)) {
          if (p == propName) { newKey.value = key[p]; }
        } else {
          newKey[p] = key[p];
        }
      }
      return newKey;
    });
  };

  for (var i = 0; i < propertyNames.length; i++) loop( i );
  return properties;
}

function getProperties(tweenSettings, params) {
  var properties = [];
  var keyframes = params.keyframes;
  if (keyframes) { params = mergeObjects(flattenKeyframes(keyframes), params); }
  for (var p in params) {
    if (is.key(p)) {
      properties.push({
        name: p,
        tweens: normalizePropertyTweens(params[p], tweenSettings)
      });
    }
  }
  return properties;
}

// Tweens

function normalizeTweenValues(tween, animatable) {
  var t = {};
  for (var p in tween) {
    var value = getFunctionValue(tween[p], animatable);
    if (is.arr(value)) {
      value = value.map(function (v) { return getFunctionValue(v, animatable); });
      if (value.length === 1) { value = value[0]; }
    }
    t[p] = value;
  }
  t.duration = parseFloat(t.duration);
  t.delay = parseFloat(t.delay);
  return t;
}

function normalizeTweens(prop, animatable) {
  var previousTween;
  return prop.tweens.map(function (t) {
    var tween = normalizeTweenValues(t, animatable);
    var tweenValue = tween.value;
    var to = is.arr(tweenValue) ? tweenValue[1] : tweenValue;
    var toUnit = getUnit(to);
    var originalValue = getOriginalTargetValue(animatable.target, prop.name, toUnit, animatable);
    var previousValue = previousTween ? previousTween.to.original : originalValue;
    var from = is.arr(tweenValue) ? tweenValue[0] : previousValue;
    var fromUnit = getUnit(from) || getUnit(originalValue);
    var unit = toUnit || fromUnit;
    if (is.und(to)) { to = previousValue; }
    tween.from = decomposeValue(from, unit);
    tween.to = decomposeValue(getRelativeValue(to, from), unit);
    tween.start = previousTween ? previousTween.end : 0;
    tween.end = tween.start + tween.delay + tween.duration + tween.endDelay;
    tween.easing = parseEasings(tween.easing, tween.duration);
    tween.isPath = is.pth(tweenValue);
    tween.isPathTargetInsideSVG = tween.isPath && is.svg(animatable.target);
    tween.isColor = is.col(tween.from.original);
    if (tween.isColor) { tween.round = 1; }
    previousTween = tween;
    return tween;
  });
}

// Tween progress

var setProgressValue = {
  css: function (t, p, v) { return t.style[p] = v; },
  attribute: function (t, p, v) { return t.setAttribute(p, v); },
  object: function (t, p, v) { return t[p] = v; },
  transform: function (t, p, v, transforms, manual) {
    transforms.list.set(p, v);
    if (p === transforms.last || manual) {
      var str = '';
      transforms.list.forEach(function (value, prop) { str += prop + "(" + value + ") "; });
      t.style.transform = str;
    }
  }
};

// Set Value helper

function setTargetsValue(targets, properties) {
  var animatables = getAnimatables(targets);
  animatables.forEach(function (animatable) {
    for (var property in properties) {
      var value = getFunctionValue(properties[property], animatable);
      var target = animatable.target;
      var valueUnit = getUnit(value);
      var originalValue = getOriginalTargetValue(target, property, valueUnit, animatable);
      var unit = valueUnit || getUnit(originalValue);
      var to = getRelativeValue(validateValue(value, unit), originalValue);
      var animType = getAnimationType(target, property);
      setProgressValue[animType](target, property, to, animatable.transforms, true);
    }
  });
}

// Animations

function createAnimation(animatable, prop) {
  var animType = getAnimationType(animatable.target, prop.name);
  if (animType) {
    var tweens = normalizeTweens(prop, animatable);
    var lastTween = tweens[tweens.length - 1];
    return {
      type: animType,
      property: prop.name,
      animatable: animatable,
      tweens: tweens,
      duration: lastTween.end,
      delay: tweens[0].delay,
      endDelay: lastTween.endDelay
    }
  }
}

function getAnimations(animatables, properties) {
  return filterArray(flattenArray(animatables.map(function (animatable) {
    return properties.map(function (prop) {
      return createAnimation(animatable, prop);
    });
  })), function (a) { return !is.und(a); });
}

// Create Instance

function getInstanceTimings(animations, tweenSettings) {
  var animLength = animations.length;
  var getTlOffset = function (anim) { return anim.timelineOffset ? anim.timelineOffset : 0; };
  var timings = {};
  timings.duration = animLength ? Math.max.apply(Math, animations.map(function (anim) { return getTlOffset(anim) + anim.duration; })) : tweenSettings.duration;
  timings.delay = animLength ? Math.min.apply(Math, animations.map(function (anim) { return getTlOffset(anim) + anim.delay; })) : tweenSettings.delay;
  timings.endDelay = animLength ? timings.duration - Math.max.apply(Math, animations.map(function (anim) { return getTlOffset(anim) + anim.duration - anim.endDelay; })) : tweenSettings.endDelay;
  return timings;
}

var instanceID = 0;

function createNewInstance(params) {
  var instanceSettings = replaceObjectProps(defaultInstanceSettings, params);
  var tweenSettings = replaceObjectProps(defaultTweenSettings, params);
  var properties = getProperties(tweenSettings, params);
  var animatables = getAnimatables(params.targets);
  var animations = getAnimations(animatables, properties);
  var timings = getInstanceTimings(animations, tweenSettings);
  var id = instanceID;
  instanceID++;
  return mergeObjects(instanceSettings, {
    id: id,
    children: [],
    animatables: animatables,
    animations: animations,
    duration: timings.duration,
    delay: timings.delay,
    endDelay: timings.endDelay
  });
}

// Core

var activeInstances = [];

var engine = (function () {
  var raf;

  function play() {
    if (!raf && (!isDocumentHidden() || !anime.suspendWhenDocumentHidden) && activeInstances.length > 0) {
      raf = requestAnimationFrame(step);
    }
  }
  function step(t) {
    // memo on algorithm issue:
    // dangerous iteration over mutable `activeInstances`
    // (that collection may be updated from within callbacks of `tick`-ed animation instances)
    var activeInstancesLength = activeInstances.length;
    var i = 0;
    while (i < activeInstancesLength) {
      var activeInstance = activeInstances[i];
      if (!activeInstance.paused) {
        activeInstance.tick(t);
        i++;
      } else {
        activeInstances.splice(i, 1);
        activeInstancesLength--;
      }
    }
    raf = i > 0 ? requestAnimationFrame(step) : undefined;
  }

  function handleVisibilityChange() {
    if (!anime.suspendWhenDocumentHidden) { return; }

    if (isDocumentHidden()) {
      // suspend ticks
      raf = cancelAnimationFrame(raf);
    } else { // is back to active tab
      // first adjust animations to consider the time that ticks were suspended
      activeInstances.forEach(
        function (instance) { return instance ._onDocumentVisibility(); }
      );
      engine();
    }
  }
  if (typeof document !== 'undefined') {
    document.addEventListener('visibilitychange', handleVisibilityChange);
  }

  return play;
})();

function isDocumentHidden() {
  return !!document && document.hidden;
}

// Public Instance

function anime(params) {
  if ( params === void 0 ) params = {};


  var startTime = 0, lastTime = 0, now = 0;
  var children, childrenLength = 0;
  var resolve = null;

  function makePromise(instance) {
    var promise = window.Promise && new Promise(function (_resolve) { return resolve = _resolve; });
    instance.finished = promise;
    return promise;
  }

  var instance = createNewInstance(params);
  var promise = makePromise(instance);

  function toggleInstanceDirection() {
    var direction = instance.direction;
    if (direction !== 'alternate') {
      instance.direction = direction !== 'normal' ? 'normal' : 'reverse';
    }
    instance.reversed = !instance.reversed;
    children.forEach(function (child) { return child.reversed = instance.reversed; });
  }

  function adjustTime(time) {
    return instance.reversed ? instance.duration - time : time;
  }

  function resetTime() {
    startTime = 0;
    lastTime = adjustTime(instance.currentTime) * (1 / anime.speed);
  }

  function seekChild(time, child) {
    if (child) { child.seek(time - child.timelineOffset); }
  }

  function syncInstanceChildren(time) {
    if (!instance.reversePlayback) {
      for (var i = 0; i < childrenLength; i++) { seekChild(time, children[i]); }
    } else {
      for (var i$1 = childrenLength; i$1--;) { seekChild(time, children[i$1]); }
    }
  }

  function setAnimationsProgress(insTime) {
    var i = 0;
    var animations = instance.animations;
    var animationsLength = animations.length;
    while (i < animationsLength) {
      var anim = animations[i];
      var animatable = anim.animatable;
      var tweens = anim.tweens;
      var tweenLength = tweens.length - 1;
      var tween = tweens[tweenLength];
      // Only check for keyframes if there is more than one tween
      if (tweenLength) { tween = filterArray(tweens, function (t) { return (insTime < t.end); })[0] || tween; }
      var elapsed = minMax(insTime - tween.start - tween.delay, 0, tween.duration) / tween.duration;
      var eased = isNaN(elapsed) ? 1 : tween.easing(elapsed);
      var strings = tween.to.strings;
      var round = tween.round;
      var numbers = [];
      var toNumbersLength = tween.to.numbers.length;
      var progress = (void 0);
      for (var n = 0; n < toNumbersLength; n++) {
        var value = (void 0);
        var toNumber = tween.to.numbers[n];
        var fromNumber = tween.from.numbers[n] || 0;
        if (!tween.isPath) {
          value = fromNumber + (eased * (toNumber - fromNumber));
        } else {
          value = getPathProgress(tween.value, eased * toNumber, tween.isPathTargetInsideSVG);
        }
        if (round) {
          if (!(tween.isColor && n > 2)) {
            value = Math.round(value * round) / round;
          }
        }
        numbers.push(value);
      }
      // Manual Array.reduce for better performances
      var stringsLength = strings.length;
      if (!stringsLength) {
        progress = numbers[0];
      } else {
        progress = strings[0];
        for (var s = 0; s < stringsLength; s++) {
          var a = strings[s];
          var b = strings[s + 1];
          var n$1 = numbers[s];
          if (!isNaN(n$1)) {
            if (!b) {
              progress += n$1 + ' ';
            } else {
              progress += n$1 + b;
            }
          }
        }
      }
      setProgressValue[anim.type](animatable.target, anim.property, progress, animatable.transforms);
      anim.currentValue = progress;
      i++;
    }
  }

  function setCallback(cb) {
    if (instance[cb] && !instance.passThrough) { instance[cb](instance); }
  }

  function countIteration() {
    if (instance.remaining && instance.remaining !== true) {
      instance.remaining--;
    }
  }

  function setInstanceProgress(engineTime) {
    var insDuration = instance.duration;
    var insDelay = instance.delay;
    var insEndDelay = insDuration - instance.endDelay;
    var insTime = adjustTime(engineTime);
    instance.progress = minMax((insTime / insDuration) * 100, 0, 100);
    instance.reversePlayback = insTime < instance.currentTime;
    if (children) { syncInstanceChildren(insTime); }
    if (!instance.began && instance.currentTime > 0) {
      instance.began = true;
      setCallback('begin');
    }
    if (!instance.loopBegan && instance.currentTime > 0) {
      instance.loopBegan = true;
      setCallback('loopBegin');
    }
    if (insTime <= insDelay && instance.currentTime !== 0) {
      setAnimationsProgress(0);
    }
    if ((insTime >= insEndDelay && instance.currentTime !== insDuration) || !insDuration) {
      setAnimationsProgress(insDuration);
    }
    if (insTime > insDelay && insTime < insEndDelay) {
      if (!instance.changeBegan) {
        instance.changeBegan = true;
        instance.changeCompleted = false;
        setCallback('changeBegin');
      }
      setCallback('change');
      setAnimationsProgress(insTime);
    } else {
      if (instance.changeBegan) {
        instance.changeCompleted = true;
        instance.changeBegan = false;
        setCallback('changeComplete');
      }
    }
    instance.currentTime = minMax(insTime, 0, insDuration);
    if (instance.began) { setCallback('update'); }
    if (engineTime >= insDuration) {
      lastTime = 0;
      countIteration();
      if (!instance.remaining) {
        instance.paused = true;
        if (!instance.completed) {
          instance.completed = true;
          setCallback('loopComplete');
          setCallback('complete');
          if (!instance.passThrough && 'Promise' in window) {
            resolve();
            promise = makePromise(instance);
          }
        }
      } else {
        startTime = now;
        setCallback('loopComplete');
        instance.loopBegan = false;
        if (instance.direction === 'alternate') {
          toggleInstanceDirection();
        }
      }
    }
  }

  instance.reset = function() {
    var direction = instance.direction;
    instance.passThrough = false;
    instance.currentTime = 0;
    instance.progress = 0;
    instance.paused = true;
    instance.began = false;
    instance.loopBegan = false;
    instance.changeBegan = false;
    instance.completed = false;
    instance.changeCompleted = false;
    instance.reversePlayback = false;
    instance.reversed = direction === 'reverse';
    instance.remaining = instance.loop;
    children = instance.children;
    childrenLength = children.length;
    for (var i = childrenLength; i--;) { instance.children[i].reset(); }
    if (instance.reversed && instance.loop !== true || (direction === 'alternate' && instance.loop === 1)) { instance.remaining++; }
    setAnimationsProgress(instance.reversed ? instance.duration : 0);
  };

  // internal method (for engine) to adjust animation timings before restoring engine ticks (rAF)
  instance._onDocumentVisibility = resetTime;

  // Set Value helper

  instance.set = function(targets, properties) {
    setTargetsValue(targets, properties);
    return instance;
  };

  instance.tick = function(t) {
    now = t;
    if (!startTime) { startTime = now; }
    setInstanceProgress((now + (lastTime - startTime)) * anime.speed);
  };

  instance.seek = function(time) {
    setInstanceProgress(adjustTime(time));
  };

  instance.pause = function() {
    instance.paused = true;
    resetTime();
  };

  instance.play = function() {
    if (!instance.paused) { return; }
    if (instance.completed) { instance.reset(); }
    instance.paused = false;
    activeInstances.push(instance);
    resetTime();
    engine();
  };

  instance.reverse = function() {
    toggleInstanceDirection();
    instance.completed = instance.reversed ? false : true;
    resetTime();
  };

  instance.restart = function() {
    instance.reset();
    instance.play();
  };

  instance.remove = function(targets) {
    var targetsArray = parseTargets(targets);
    removeTargetsFromInstance(targetsArray, instance);
  };

  instance.reset();

  if (instance.autoplay) { instance.play(); }

  return instance;

}

// Remove targets from animation

function removeTargetsFromAnimations(targetsArray, animations) {
  for (var a = animations.length; a--;) {
    if (arrayContains(targetsArray, animations[a].animatable.target)) {
      animations.splice(a, 1);
    }
  }
}

function removeTargetsFromInstance(targetsArray, instance) {
  var animations = instance.animations;
  var children = instance.children;
  removeTargetsFromAnimations(targetsArray, animations);
  for (var c = children.length; c--;) {
    var child = children[c];
    var childAnimations = child.animations;
    removeTargetsFromAnimations(targetsArray, childAnimations);
    if (!childAnimations.length && !child.children.length) { children.splice(c, 1); }
  }
  if (!animations.length && !children.length) { instance.pause(); }
}

function removeTargetsFromActiveInstances(targets) {
  var targetsArray = parseTargets(targets);
  for (var i = activeInstances.length; i--;) {
    var instance = activeInstances[i];
    removeTargetsFromInstance(targetsArray, instance);
  }
}

// Stagger helpers

function stagger(val, params) {
  if ( params === void 0 ) params = {};

  var direction = params.direction || 'normal';
  var easing = params.easing ? parseEasings(params.easing) : null;
  var grid = params.grid;
  var axis = params.axis;
  var fromIndex = params.from || 0;
  var fromFirst = fromIndex === 'first';
  var fromCenter = fromIndex === 'center';
  var fromLast = fromIndex === 'last';
  var isRange = is.arr(val);
  var val1 = isRange ? parseFloat(val[0]) : parseFloat(val);
  var val2 = isRange ? parseFloat(val[1]) : 0;
  var unit = getUnit(isRange ? val[1] : val) || 0;
  var start = params.start || 0 + (isRange ? val1 : 0);
  var values = [];
  var maxValue = 0;
  return function (el, i, t) {
    if (fromFirst) { fromIndex = 0; }
    if (fromCenter) { fromIndex = (t - 1) / 2; }
    if (fromLast) { fromIndex = t - 1; }
    if (!values.length) {
      for (var index = 0; index < t; index++) {
        if (!grid) {
          values.push(Math.abs(fromIndex - index));
        } else {
          var fromX = !fromCenter ? fromIndex%grid[0] : (grid[0]-1)/2;
          var fromY = !fromCenter ? Math.floor(fromIndex/grid[0]) : (grid[1]-1)/2;
          var toX = index%grid[0];
          var toY = Math.floor(index/grid[0]);
          var distanceX = fromX - toX;
          var distanceY = fromY - toY;
          var value = Math.sqrt(distanceX * distanceX + distanceY * distanceY);
          if (axis === 'x') { value = -distanceX; }
          if (axis === 'y') { value = -distanceY; }
          values.push(value);
        }
        maxValue = Math.max.apply(Math, values);
      }
      if (easing) { values = values.map(function (val) { return easing(val / maxValue) * maxValue; }); }
      if (direction === 'reverse') { values = values.map(function (val) { return axis ? (val < 0) ? val * -1 : -val : Math.abs(maxValue - val); }); }
    }
    var spacing = isRange ? (val2 - val1) / maxValue : val1;
    return start + (spacing * (Math.round(values[i] * 100) / 100)) + unit;
  }
}

// Timeline

function timeline(params) {
  if ( params === void 0 ) params = {};

  var tl = anime(params);
  tl.duration = 0;
  tl.add = function(instanceParams, timelineOffset) {
    var tlIndex = activeInstances.indexOf(tl);
    var children = tl.children;
    if (tlIndex > -1) { activeInstances.splice(tlIndex, 1); }
    function passThrough(ins) { ins.passThrough = true; }
    for (var i = 0; i < children.length; i++) { passThrough(children[i]); }
    var insParams = mergeObjects(instanceParams, replaceObjectProps(defaultTweenSettings, params));
    insParams.targets = insParams.targets || params.targets;
    var tlDuration = tl.duration;
    insParams.autoplay = false;
    insParams.direction = tl.direction;
    insParams.timelineOffset = is.und(timelineOffset) ? tlDuration : getRelativeValue(timelineOffset, tlDuration);
    passThrough(tl);
    tl.seek(insParams.timelineOffset);
    var ins = anime(insParams);
    passThrough(ins);
    children.push(ins);
    var timings = getInstanceTimings(children, params);
    tl.delay = timings.delay;
    tl.endDelay = timings.endDelay;
    tl.duration = timings.duration;
    tl.seek(0);
    tl.reset();
    if (tl.autoplay) { tl.play(); }
    return tl;
  };
  return tl;
}

anime.version = '3.2.1';
anime.speed = 1;
// TODO:#review: naming, documentation
anime.suspendWhenDocumentHidden = true;
anime.running = activeInstances;
anime.remove = removeTargetsFromActiveInstances;
anime.get = getOriginalTargetValue;
anime.set = setTargetsValue;
anime.convertPx = convertPxToUnit;
anime.path = getPath;
anime.setDashoffset = setDashoffset;
anime.stagger = stagger;
anime.timeline = timeline;
anime.easing = parseEasings;
anime.penner = penner;
anime.random = function (min, max) { return Math.floor(Math.random() * (max - min + 1)) + min; };

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (anime);


/***/ }),

/***/ "./src/blocks/accordion/index.js":
/*!***************************************!*\
  !*** ./src/blocks/accordion/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");













const {
  RawHTML
} = wp.element;












var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)("post-grid/accordion", {
  title: "Accordion",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#2563eb',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      width: "24",
      height: "24",
      viewBox: "0 0 24 24",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: "M3 7.00003C2.44772 7.00003 2 7.44775 2 8.00003V16C2 16.5523 2.44772 17 3 17H21C21.5523 17 22 16.5523 22 16V8.00003C22 7.44775 21.5523 7.00003 21 7.00003H3ZM20.75 14.75C20.75 15.3023 20.3023 15.75 19.75 15.75H4.25C3.69772 15.75 3.25 15.3023 3.25 14.75V11.75C3.25 11.1977 3.69772 10.75 4.25 10.75H19.75C20.3023 10.75 20.75 11.1977 20.75 11.75V14.75Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: "M2 3C2 2.44772 2.44772 2 3 2H21C21.5523 2 22 2.44772 22 3V4.75C22 5.30228 21.5523 5.75 21 5.75H3C2.44772 5.75 2 5.30228 2 4.75V3Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: "M2 19.25C2 18.6977 2.44772 18.25 3 18.25H21C21.5523 18.25 22 18.6977 22 19.25V21C22 21.5523 21.5523 22 21 22H3C2.44772 22 2 21.5523 2 21V19.25Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          content: '',
          tag: 'div',
          class: 'pg-accordion'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    items: {
      type: 'array',
      default: [{
        isActive: false,
        headerText: 'What is Lorem Ipsum?',
        content: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.',
        icon: '',
        iconToggle: '',
        styles: {}
      }]
    },
    header: {
      type: 'object',
      default: {
        options: {
          text: 'What is Lorem Ipsum?',
          tag: 'div',
          class: 'pg-accordion-header'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    headerActive: {
      type: 'object',
      default: {
        options: {
          text: 'What is Lorem Ipsum?',
          tag: 'div',
          class: 'pg-accordion-header '
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    content: {
      type: 'object',
      default: {
        options: {
          text: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.',
          tag: 'div',
          class: 'pg-accordion-content'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    icon: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'fas fa-chevron-right',
          class: 'icon',
          positon: 'beforeHeader',
          enableToggle: 'yes'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          }
        }
      }
    },
    iconToggle: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'fas fa-chevron-down',
          class: 'iconToggle'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          }
        }
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var items = attributes.items;
    var wrapper = attributes.wrapper;
    var header = attributes.header;
    var headerActive = attributes.headerActive;
    var content = attributes.content;
    var icon = attributes.icon;
    var iconToggle = attributes.iconToggle;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType'];
    const [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(myStore.getBreakPoint());
    const [isLoading, setisLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [postGridData, setPostGridData] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(window.PostGridPluginData);
    const [isOpen, setisOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false); // Wrapper CSS Class Selectors

    var wrapperSelector = blockClass;
    var headerSelector = blockClass + ' .pg-accordion-header';
    var headerActiveSelector = blockClass + ' .pg-accordion-header.active';
    var contentSelector = blockClass + ' .pg-accordion-content';
    const iconSelector = blockClass + ' .icon-wrap';
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      }); //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      }); //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);
    var breakPointList = [{
      label: 'Select..',
      icon: '',
      value: ''
    }];

    for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"]) {
      var item = _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"][x];
      breakPointList.push({
        label: item.name,
        icon: item.icon,
        value: item.id
      });
    }

    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      var iconSrc = icon.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      setIconHtml(iconHtml);
    }, [icon]);
    const [iconToggleHtml, setIconToggleHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      var iconSrc = iconToggle.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      setIconToggleHtml(iconHtml);
    }, [iconToggle]);

    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }

    function onChangeIcon(arg) {
      var options = { ...icon.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        icon: { ...icon,
          options: options
        }
      });
    }

    function onChangeIconToggle(arg) {
      var options = { ...iconToggle.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        iconToggle: { ...iconToggle,
          options: options
        }
      });
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ wrapper: { ...wrapper } });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      // if (blockCssY.items[wrapperSelector] == undefined) {
      //   blockCssY.items[wrapperSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[wrapperSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[wrapperSelector][key] != undefined) {
      //   delete blockCssY.items[wrapperSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // sudoScourceX[key] = {};
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStyleHeader(sudoScource, newVal, attr) {
      // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, header);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ header: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ header: { ...header } });
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, header);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        header: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleHeader(sudoScource, key) {
      var object = myStore.deletePropertyDeep(header, [sudoScource, key, breakPointX]);
      setAttributes({
        header: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...header[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // header[sudoScource] = sudoScourceX;
      // setAttributes({ header: { ...header } });
      // if (blockCssY.items[headerSelector] == undefined) {
      //   blockCssY.items[headerSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[headerSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[headerSelector][key] != undefined) {
      //   delete blockCssY.items[headerSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleHeader(sudoScource, key) {
      // var sudoScourceX = { ...header[sudoScource] }
      // sudoScourceX[key] = {};
      // header[sudoScource] = sudoScourceX;
      // setAttributes({ header: { ...header } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, header);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        header: object
      });
    }

    function onChangeStyleContent(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, content);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        content: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, content);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ content: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleContent(sudoScource, key) {
      var object = myStore.deletePropertyDeep(content, [sudoScource, key, breakPointX]);
      setAttributes({
        content: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...content[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // content[sudoScource] = sudoScourceX;
      // setAttributes({ content: { ...content } });
      // if (blockCssY.items[contentSelector] == undefined) {
      //   blockCssY.items[contentSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[contentSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[contentSelector][key] != undefined) {
      //   delete blockCssY.items[contentSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleContent(sudoScource, key) {
      // var sudoScourceX = { ...content[sudoScource] }
      // sudoScourceX[key] = {};
      // content[sudoScource] = sudoScourceX;
      // setAttributes({ content: { ...content } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, content);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        content: object
      });
    }

    function onChangeStyleIcon(sudoScource, newVal, attr) {
      // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, icon);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ icon: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(icon, [sudoScource, key, breakPointX]);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...icon[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // icon[sudoScource] = sudoScourceX;
      // //sudoScourceX[attr][breakPointX] = newVal;
      // setAttributes({ icon: { ...icon } });
      // if (blockCssY.items[iconSelector] == undefined) {
      //   blockCssY.items[iconSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[iconSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[iconSelector][key] != undefined) {
      //   delete blockCssY.items[iconSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleIcon(sudoScource, key) {
      // var sudoScourceX = { ...icon[sudoScource] }
      // sudoScourceX[key] = {};
      // icon[sudoScource] = sudoScourceX;
      // setAttributes({ icon: { ...icon } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        icon: object
      });
    }

    function onChangeStyleHeaderActive(sudoScource, newVal, attr) {
      // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, headerActive);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ headerActive: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, headerActiveSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, headerActive);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        headerActive: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerActiveSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleHeaderActive(sudoScource, key) {
      var object = myStore.deletePropertyDeep(headerActive, [sudoScource, key, breakPointX]);
      setAttributes({
        headerActive: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerActiveSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...headerActive[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // headerActive[sudoScource] = sudoScourceX;
      // //sudoScourceX[attr][breakPointX] = newVal;
      // setAttributes({ headerActive: { ...headerActive } });
      // if (blockCssY.items[headerActiveSelector] == undefined) {
      //   blockCssY.items[headerActiveSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[headerActiveSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[headerActiveSelector][key] != undefined) {
      //   delete blockCssY.items[headerActiveSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleHeaderActive(sudoScource, key) {
      // var sudoScourceX = { ...headerActive[sudoScource] }
      // sudoScourceX[key] = {};
      // headerActive[sudoScource] = sudoScourceX;
      // setAttributes({ headerActive: { ...headerActive } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, headerActive);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        headerActive: object
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      //generateBlockCssY()
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    const colors = [{
      name: '9DD6DF',
      color: '#9DD6DF'
    }, {
      name: '18978F',
      color: '#18978F'
    }, {
      name: 'A084CF',
      color: '#A084CF'
    }, {
      name: 'DFBB9D',
      color: '#DFBB9D'
    }, {
      name: '774360',
      color: '#774360'
    }, {
      name: '3AB0FF',
      color: '#3AB0FF'
    }, {
      name: '51557E',
      color: '#51557E'
    }];
    const [setSome, setSomeState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)({});
    const [stateX, setStateX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('Old Value');
    const {
      __experimentalSetPreviewDeviceType: setPreviewDeviceType
    } = wp.data.dispatch('core/edit-post');

    function onChangeBreakPoint(x, index) {
      setPreviewDeviceType(x.value);
      var asdsdsd = wp.data.dispatch('postgrid-shop').setBreakPoint(x.value);
      asdsdsd.then(res => {
        setBreakPointX(res.breakpoint); //generateBlockCssY();

        myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      });
    }

    return [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.BlockControls, null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InspectorControls, {
      key: "general"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-2",
      title: "header",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Header",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_20__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: header.options.tag,
      options: [{
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...header.options,
          tag: newVal
        };
        setAttributes({
          header: { ...header,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: header,
      onChange: onChangeStyleHeader,
      onAdd: onAddStyleHeader,
      onRemove: onRemoveStyleHeader
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Header - Active",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_20__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: headerActive,
      onChange: onChangeStyleHeaderActive,
      onAdd: onAddStyleHeaderActive,
      onRemove: onRemoveStyleHeaderActive
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Content",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_20__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: content.options.tag,
      options: [{
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...content.options,
          tag: newVal
        };
        setAttributes({
          content: { ...content,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: content,
      onChange: onChangeStyleContent,
      onAdd: onAddStyleContent,
      onRemove: onRemoveStyleContent
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_20__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_16__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: onChangeIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Toggled Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_16__["default"], {
      library: iconToggle.options.library,
      srcType: iconToggle.options.srcType,
      iconSrc: iconToggle.options.iconSrc,
      onChange: onChangeIconToggle
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Icon postion"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: 'Choose...',
        value: ''
      }, {
        label: 'Before Header Text',
        value: 'beforeHeader'
      }, {
        label: 'After Header Text',
        value: 'afterHeader'
      }],
      onChange: newVal => {
        var options = { ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Enable Icon Toggle"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: icon.options.enableToggle,
      options: [{
        label: 'Yes',
        value: 'yes'
      }, {
        label: 'No',
        value: 'no'
      }],
      onChange: newVal => {
        var options = { ...icon.options,
          enableToggle: newVal
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Text "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, wrapperSelector, '{}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_13__["default"], {
      utm: {
        utm_source: 'BlockText',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: [blockId]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "bg-blue-500 p-2 px-5 text-white my-4 text-center cursor-pointer",
      onClick: ev => {
        var itemx = items.concat({
          isActive: false,
          headerText: 'What is Lorem Ipsum?',
          content: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.',
          icon: '',
          iconToggle: '',
          styles: {}
        });
        setAttributes({
          items: itemx
        });
      }
    }, "Add"), items.map((item, i) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: `${header.options.class} ${items[i].isActive ? 'active' : ''} cursor-pointer`,
        onClick: ev => {
          items[i].isActive = !items[i].isActive;
          var ssdsd = items.concat([]);
          setAttributes({
            items: ssdsd
          });
        }
      }, icon.options.position == 'beforeHeader' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, icon.options.enableToggle == 'yes' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, !items[i].isActive && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "icon-wrap",
        dangerouslySetInnerHTML: {
          __html: iconHtml
        }
      }), items[i].isActive && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "icon-wrap",
        dangerouslySetInnerHTML: {
          __html: iconToggleHtml
        }
      })), icon.options.enableToggle == 'no' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "icon-wrap",
        dangerouslySetInnerHTML: {
          __html: iconHtml
        }
      })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.RichText, {
        tagName: "span",
        value: item.headerText,
        allowedFormats: ['core/bold', 'core/italic', 'core/link'],
        onChange: content => {
          items[i].headerText = content;
          var ssdsd = items.concat([]);
          setAttributes({
            items: ssdsd
          });
        },
        placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Start Writing...')
      }), icon.options.position == 'afterHeader' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, icon.options.enableToggle == 'yes' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, !items[i].isActive && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "icon-wrap float-right",
        dangerouslySetInnerHTML: {
          __html: iconHtml
        }
      }), items[i].isActive && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "icon-wrap float-right",
        dangerouslySetInnerHTML: {
          __html: iconToggleHtml
        }
      })), icon.options.enableToggle == 'no' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "icon-wrap float-right",
        dangerouslySetInnerHTML: {
          __html: iconHtml
        }
      })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "text-lg cursor-pointer px-2 text-red-500  py-1 float-right icon-close",
        onClick: ev => {
          items.splice(i, 1);
          var ssdsd = items.concat([]);
          setAttributes({
            items: ssdsd
          });
          ev.preventDefault();
        }
      })), items[i].isActive && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: content.options.class
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.RichText, {
        tagName: "div",
        value: item.content,
        allowedFormats: ['core/bold', 'core/italic', 'core/link'],
        onChange: content => {
          items[i].content = content;
          var ssdsd = items.concat([]);
          setAttributes({
            items: ssdsd
          });
        },
        placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Start Writing...')
      })));
    })))];
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/archive-description/index.js":
/*!*************************************************!*\
  !*** ./src/blocks/archive-description/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link-off.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_css_display__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/css-display */ "./src/components/css-display/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");














const {
  RawHTML
} = wp.element;














var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__.registerBlockType)("post-grid/archive-description", {
  title: "Archive description",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#2563eb',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("svg", {
      width: "500",
      height: "500",
      viewBox: "0 0 500 500",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M25 95C25 92.2386 27.2386 90 30 90H470C472.761 90 475 92.2386 475 95V145C475 147.761 472.761 150 470 150H30C27.2386 150 25 147.761 25 145V95Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M25 234C25 231.239 27.2386 229 30 229H470C472.761 229 475 231.239 475 234V254C475 256.761 472.761 259 470 259H30C27.2386 259 25 256.761 25 254V234Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M25 298C25 295.239 27.2386 293 30 293H470C472.761 293 475 295.239 475 298V318C475 320.761 472.761 323 470 323H30C27.2386 323 25 320.761 25 318V298Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M25 362C25 359.239 27.2386 357 30 357H366C368.761 357 371 359.239 371 362V382C371 384.761 368.761 387 366 387H30C27.2386 387 25 384.761 25 382V362Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    archiveTitle: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          archiveType: 'auto',
          customLabel: 'Archive: %s',
          dateFormat: '',
          linkTo: '',
          // postUrl, customField, authorUrl, authorLink, homeUrl, custom
          linkToUrl: '',
          linkToMetaKey: '',
          linkTarget: '_blank',
          linkAttr: [],
          customUrl: '',
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          }
        }
      }
    },
    icon: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'far fa-calendar-alt',
          position: 'beforeArchiveTitle',

          /*before, after, prefix, postfix */
          class: 'postdate-icon'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          }
        }
      }
    },
    prefix: {
      type: 'object',
      default: {
        options: {
          text: '',
          class: 'prefix'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          }
        }
      }
    },
    postfix: {
      type: 'object',
      default: {
        options: {
          text: '',
          class: 'prefix'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          }
        }
      }
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    let archiveTitle = attributes.archiveTitle;
    var wrapper = attributes.wrapper;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var icon = attributes.icon;
    var prefix = attributes.prefix;
    var postfix = attributes.postfix;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType'];
    const [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(myStore.getBreakPoint());
    const [customTags, setCustomTags] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
    const [linkPickerPosttitle, setLinkPickerPosttitle] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    var archiveLinkToArgsBasic = {
      none: {
        label: 'No Link',
        value: ''
      },
      archiveUrl: {
        label: 'Archive URL',
        value: 'archiveUrl'
      },
      homeUrl: {
        label: 'Home URL',
        value: 'homeUrl'
      },
      customUrl: {
        label: 'Custom',
        value: 'customUrl'
      }
    };
    let archiveLinkToArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__.applyFilters)('archiveLinkToArgs', archiveLinkToArgsBasic);
    var archiveTypes = {
      'auto': {
        label: 'Auto Detect',
        value: 'auto'
      } // 'author': { label: 'Author', value: 'author' },
      // 'category': { label: 'Category', value: 'category' },
      // 'tag': { label: 'Tag', value: 'tag' },
      // 'taxonomy': { label: 'Taxonomy', value: 'taxonomy' },
      // 'search': { label: 'Search', value: 'search' },
      // 'index': { label: 'Index', value: 'index' },
      // 'year': { label: 'Year', value: 'year' },
      // 'month': { label: 'Month', value: 'month' },
      // 'date': { label: 'Date', value: 'date' },
      // 'wcCatalog': { label: 'WooCommerce Catalog', value: 'wcCatalog' },
      // 'wcSearch': { label: 'WooCommerce Search', value: 'wcSearch' },

    };
    var dateFormats = {
      'Y-M-d': {
        label: '2022-May-25',
        value: 'Y-M-d'
      },
      'Y-m-d': {
        label: '2022-05-25',
        value: 'Y-m-d'
      },
      'd-m-y': {
        label: '25-05-2022',
        value: 'd-m-y'
      },
      'd/m/y': {
        label: '25/05/2022',
        value: 'd/m/y'
      },
      'y-m-d': {
        label: '2022-05-25',
        value: 'y-m-d'
      },
      'y/m/d': {
        label: '2022/05/25',
        value: 'y/m/d'
      },
      'D M y': {
        label: 'Sun May 2022',
        value: 'D M y'
      },
      'D M d, y': {
        label: 'Sun May 11, 2022',
        value: 'D M d, y'
      },
      'M D d, y': {
        label: 'May Sun 11, 2022',
        value: 'M D d, y'
      },
      'M d, y': {
        label: 'May 11, 2022',
        value: 'M d, y'
      },
      'd M y': {
        label: '25 May 2022',
        value: 'd M y'
      }
    }; // Wrapper CSS Class Selectors

    const wrapperSelector = blockClass;
    var archiveTitleSelector = '';

    if (wrapper.options.tag.length != 0) {
      if (archiveTitle.options.linkTo.length > 0) {
        archiveTitleSelector = blockClass + ' a';
      } else {
        archiveTitleSelector = blockClass; //archiveTitleSelector = blockClass + ' .archiveTitle';
      }
    } else {
      archiveTitleSelector = blockClass;
    }

    const prefixSelector = blockClass + ' .prefix';
    const postfixSelector = blockClass + ' .postfix';
    const iconSelector = blockClass + ' .postdate-icon';
    const [archiveTitleEdited, setarchiveTitleEdited] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('Hello %s');

    function onChangeIcon(arg) {
      var options = { ...icon.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        icon: { ...icon,
          options: options
        }
      });
    }

    function setFieldLinkTo(option, index) {
      var options = { ...archiveTitle.options,
        linkTo: option.value
      };
      setAttributes({
        archiveTitle: { ...archiveTitle,
          options: options
        }
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      console.log(archiveTitle);
      var archiveType = archiveTitle.options.archiveType;

      if (archiveType == 'auto') {
        //archiveTitleEdited = archiveTitle.options.customLabel;
        setarchiveTitleEdited(archiveTitle.options.customLabel);
      }
    }, [archiveTitle]);

    function onAddStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // sudoScourceX[key] = {};
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStyleRedmore(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, readMore);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        readMore: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, redmoreSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...readMore[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, redmoreSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ readMore: { ...readMore } });
    }

    function onRemoveStyleRedmore(sudoScource, key) {
      var object = myStore.deletePropertyDeep(readMore, [sudoScource, key, breakPointX]);
      setAttributes({
        readMore: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, redmoreSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...readMore[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // readMore[sudoScource] = sudoScourceX;
      // setAttributes({ readMore: { ...readMore } });
      // if (blockCssY.items[redmoreSelector] == undefined) {
      //   blockCssY.items[redmoreSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[redmoreSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[redmoreSelector][key] != undefined) {
      //   delete blockCssY.items[redmoreSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleRedmore(sudoScource, key) {
      // var sudoScourceX = { ...readMore[sudoScource] }
      // sudoScourceX[key] = {};
      // readMore[sudoScource] = sudoScourceX;
      // setAttributes({ readMore: { ...readMore } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, readMore);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        readMore: object
      });
    }

    function onChangeStyleIcon(sudoScource, newVal, attr) {
      // var sudoScourceX = { ...icon[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ icon: { ...icon } });
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(icon, [sudoScource, key, breakPointX]);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...icon[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // icon[sudoScource] = sudoScourceX;
      // setAttributes({ icon: { ...icon } });
      // if (blockCssY.items[iconSelector] == undefined) {
      //   blockCssY.items[iconSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[iconSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[iconSelector][key] != undefined) {
      //   delete blockCssY.items[iconSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleIcon(sudoScource, key) {
      // var sudoScourceX = { ...icon[sudoScource] }
      // sudoScourceX[key] = {};
      // icon[sudoScource] = sudoScourceX;
      // setAttributes({ icon: { ...icon } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        icon: object
      });
    }

    function onChangeStylePrefix(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, prefix);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        prefix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...prefix[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ prefix: { ...prefix } });
    }

    function onRemoveStylePrefix(sudoScource, key) {
      var object = myStore.deletePropertyDeep(prefix, [sudoScource, key, breakPointX]);
      setAttributes({
        prefix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...prefix[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // prefix[sudoScource] = sudoScourceX;
      // //sudoScourceX[attr][breakPointX] = newVal;
      // setAttributes({ prefix: { ...prefix } });
      // if (blockCssY.items[prefixSelector] == undefined) {
      //   blockCssY.items[prefixSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[prefixSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[prefixSelector][key] != undefined) {
      //   delete blockCssY.items[prefixSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStylePrefix(sudoScource, key) {
      // var sudoScourceX = { ...prefix[sudoScource] }
      // sudoScourceX[key] = {};
      // prefix[sudoScource] = sudoScourceX;
      // setAttributes({ prefix: { ...prefix } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, prefix);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        prefix: object
      });
    }

    function onChangeStylePostfix(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, postfix);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        postfix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...postfix[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ postfix: { ...postfix } });
    }

    function onRemoveStylePostfix(sudoScource, key) {
      var object = myStore.deletePropertyDeep(postfix, [sudoScource, key, breakPointX]);
      setAttributes({
        postfix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...postfix[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // postfix[sudoScource] = sudoScourceX;
      // //sudoScourceX[attr][breakPointX] = newVal;
      // setAttributes({ postfix: { ...postfix } });
      // if (blockCssY.items[postfixSelector] == undefined) {
      //   blockCssY.items[postfixSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[postfixSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[postfixSelector][key] != undefined) {
      //   delete blockCssY.items[postfixSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStylePostfix(sudoScource, key) {
      // var sudoScourceX = { ...postfix[sudoScource] }
      // sudoScourceX[key] = {};
      // postfix[sudoScource] = sudoScourceX;
      // setAttributes({ postfix: { ...postfix } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, postfix);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        postfix: object
      });
    }

    function onChangeIconTypo(typoX) {
      setAttributes({
        icon: { ...icon,
          styles: typoX
        }
      });
      var newValuesObjX = {};
      var itemsX = blockCssY.items;

      if (typoX.fontSize[breakPointX] != undefined) {
        var fontSizeVal = typoX.fontSize[breakPointX].val ? typoX.fontSize[breakPointX].val : 16;
        var fontSizeUnit = typoX.fontSize[breakPointX].unit ? typoX.fontSize[breakPointX].unit : 'px';
        var fontSizeX = blockCssY.items[iconSelector] != undefined ? blockCssY.items[iconSelector]['font-size'] : {};
        fontSizeX[breakPointX] = fontSizeVal + fontSizeUnit; //blockCssY.items[iconSelector] = { ...blockCssY.items[iconSelector], 'font-size': fontSizeX };

        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'font-size': fontSizeX
        };
      }

      if (typoX.lineHeight[breakPointX] != undefined) {
        var lineHeightVal = typoX.lineHeight[breakPointX].val ? typoX.lineHeight[breakPointX].val : 16;
        var lineHeightUnit = typoX.lineHeight[breakPointX].unit ? typoX.lineHeight[breakPointX].unit : 'px';
        var lineHeightX = blockCssY.items[iconSelector]['line-height'] != undefined ? blockCssY.items[iconSelector]['line-height'] : {};
        lineHeightX[breakPointX] = lineHeightVal + lineHeightUnit; //blockCssY.items[iconSelector] = { ...blockCssY.items[iconSelector], 'line-height': lineHeightX };

        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'line-height': lineHeightX
        };
      }

      if (typoX.fontWeight[breakPointX] != undefined) {
        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'font-weight': typoX.fontWeight
        };
      }

      if (typoX.textDecoration[breakPointX] != undefined) {
        var str = {};
        var textDecorationX = typoX.textDecoration[breakPointX];
        var textDecorationXStr = textDecorationX.length > 0 ? textDecorationX.join(' ') : '';
        str[breakPointX] = textDecorationXStr;
        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'text-decoration': str
        };
      } //setAttributes({ blockCssY: { items: blockCssY.items } });


      setAttributes({
        blockCssY: {
          items: itemsX
        }
      });
    }

    String.prototype.strtr = function (dic) {
      const str = this.toString(),
            makeToken = inx => `{{###~${inx}~###}}`,
            tokens = Object.keys(dic).map((key, inx) => ({
        key,
        val: dic[key],
        token: makeToken(inx)
      })),
            tokenizedStr = tokens.reduce((carry, entry) => carry.replace(new RegExp(entry.key, "g"), entry.token), str);

      return tokens.reduce((carry, entry) => carry.replace(new RegExp(entry.token, "g"), entry.val), tokenizedStr);
    };

    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('');
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      var iconSrc = icon.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      console.log(iconHtml);
      setIconHtml(iconHtml);
    }, [icon]);
    const [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__.useEntityProp)('postType', postType, 'link', postId);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      }); // setAttributes({ archiveTitle: archiveTitle });
      // setAttributes({ wrapper: wrapper });
      //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      customTags['currentYear'] = '2022';
      customTags['currentMonth'] = '07';
      customTags['currentDay'] = '27';
      customTags['currentDate'] = '27';
      customTags['currentTime'] = '27';
      customTags['postPublishDate'] = '123';
      customTags['postModifiedDate'] = '123';
      customTags['termId'] = '';
      customTags['termTitle'] = '';
      customTags['termDescription'] = '';
      customTags['termPostCount'] = '';
      customTags['postTagTitle'] = 'First Tag Title';
      customTags['postTagsTitle'] = 'First Tag Title';
      customTags['postCategoryTitle'] = 'First Category Title';
      customTags['postCategoriesTitle'] = 'First Categories Title';
      customTags['postTermTitle'] = 'First Term Title';
      customTags['postTermsTitle'] = 'List of all terms title';
      customTags['postId'] = '123';
      customTags['postStatus'] = '123';
      customTags['authorId'] = '123';
      customTags['authorName'] = 'Nur Hasan';
      customTags['authorFirstName'] = 'Nur';
      customTags['authorLastName'] = 'Hasan';
      customTags['authorDescription'] = 'Hasan';
      customTags['excerpt'] = 'Here is the post excerpt';
      customTags['rankmathTitle'] = 'Hasan';
      customTags['rankmathPermalink'] = 'Hasan';
      customTags['rankmathExcerpt'] = 'Hasan';
      customTags['rankmathFocusKeyword'] = 'Hasan';
      customTags['rankmathFocusKeywords'] = 'Hasan';
      customTags['rankmathOrgname'] = 'Hasan';
      customTags['rankmathOrgurl'] = 'Hasan';
      customTags['rankmathOrglogo'] = 'Hasan';
      customTags['siteTitle'] = '';
      customTags['siteDescription'] = '';
      customTags['siteTagline'] = '';
      customTags['postMeta'] = '';
      customTags['separator'] = '';
      customTags['searchTerms'] = '';
      customTags['counter'] = '1';
    }, [clientId]);
    var breakPointList = [{
      label: 'Select..',
      icon: '',
      value: ''
    }];

    for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_9__["default"]) {
      var item = _breakpoints__WEBPACK_IMPORTED_MODULE_9__["default"][x];
      breakPointList.push({
        label: item.name,
        icon: item.icon,
        value: item.id
      });
    }

    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ wrapper: { ...wrapper } });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      // if (blockCssY.items[wrapperSelector] == undefined) {
      //   blockCssY.items[wrapperSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[wrapperSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[wrapperSelector][key] != undefined) {
      //   delete blockCssY.items[wrapperSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onChangeStyleArchiveTitle(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, archiveTitle);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        archiveTitle: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...archiveTitle[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ archiveTitle: { ...archiveTitle } });
    }

    function onRemoveStyleArchiveTitle(sudoScource, key) {
      var object = myStore.deletePropertyDeep(archiveTitle, [sudoScource, key, breakPointX]);
      setAttributes({
        archiveTitle: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...archiveTitle[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // archiveTitle[sudoScource] = sudoScourceX;
      // setAttributes({ archiveTitle: { ...archiveTitle } });
      // if (blockCssY.items[archiveTitleSelector] == undefined) {
      //   blockCssY.items[archiveTitleSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[archiveTitleSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[archiveTitleSelector][key] != undefined) {
      //   delete blockCssY.items[archiveTitleSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleArchiveTitle(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, archiveTitle);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        archiveTitle: object
      });
    }

    var [linkAttrItems, setlinkAttrItems] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({}); // Using the hook.

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      //generateBlockCssY()
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      }); //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      linkAttrObj();
    }, [archiveTitle]);

    var linkAttrObj = () => {
      var sdsd = {};
      archiveTitle.options.linkAttr.map(x => {
        if (x.val) sdsd[x.id] = x.val;
      });
      setlinkAttrItems(sdsd);
    };

    const colors = [{
      name: '9DD6DF',
      color: '#9DD6DF'
    }, {
      name: '18978F',
      color: '#18978F'
    }, {
      name: 'A084CF',
      color: '#A084CF'
    }, {
      name: 'DFBB9D',
      color: '#DFBB9D'
    }, {
      name: '774360',
      color: '#774360'
    }, {
      name: '3AB0FF',
      color: '#3AB0FF'
    }, {
      name: '51557E',
      color: '#51557E'
    }];
    const [setSome, setSomeState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
    const [stateX, setStateX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('Old Value');
    const {
      __experimentalSetPreviewDeviceType: setPreviewDeviceType
    } = wp.data.dispatch('core/edit-post');
    var postUrl = archiveTitle.options.customUrl != undefined && archiveTitle.options.customUrl.length > 0 ? archiveTitle.options.customUrl : currentPostUrl;
    const CustomTag = `${wrapper.options.tag}`;
    const CustomTagPostTitle = `${archiveTitle.options.tag}`;

    function onChangeTypo(typoX) {
      setAttributes({
        archiveTitle: { ...archiveTitle,
          styles: typoX
        }
      });
      var newValuesObjX = {};

      if (typoX.fontFamily[breakPointX] != undefined) {
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'font-family': typoX.fontFamily
        };
      }

      if (typoX.fontSize[breakPointX] != undefined) {
        var fontSizeVal = typoX.fontSize[breakPointX].val ? typoX.fontSize[breakPointX].val : 16;
        var fontSizeUnit = typoX.fontSize[breakPointX].unit ? typoX.fontSize[breakPointX].unit : 'px';
        var fontSizeX = blockCssY.items[archiveTitleSelector] != undefined ? blockCssY.items[archiveTitleSelector]['font-size'] : {};
        fontSizeX[breakPointX] = fontSizeVal + fontSizeUnit;
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'font-size': fontSizeX
        };
      }

      if (typoX.lineHeight[breakPointX] != undefined) {
        var lineHeightVal = typoX.lineHeight[breakPointX].val ? typoX.lineHeight[breakPointX].val : 0;
        var lineHeightUnit = typoX.lineHeight[breakPointX].unit ? typoX.lineHeight[breakPointX].unit : 'px';
        var lineHeightX = blockCssY.items[archiveTitleSelector]['line-height'] != undefined ? blockCssY.items[archiveTitleSelector]['line-height'] : {};
        lineHeightX[breakPointX] = lineHeightVal + lineHeightUnit;
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'line-height': lineHeightX
        };
      }

      if (typoX.letterSpacing[breakPointX] != undefined) {
        var letterSpacingVal = typoX.letterSpacing[breakPointX].val ? typoX.letterSpacing[breakPointX].val : 0;
        var letterSpacingUnit = typoX.letterSpacing[breakPointX].unit ? typoX.letterSpacing[breakPointX].unit : 'px';
        var letterSpacingX = blockCssY.items[archiveTitleSelector]['letter-spacing'] != undefined ? blockCssY.items[archiveTitleSelector]['letter-spacing'] : {};
        letterSpacingX[breakPointX] = letterSpacingVal + letterSpacingUnit;
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'letter-spacing': letterSpacingX
        };
      }

      if (typoX.fontWeight[breakPointX] != undefined) {
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'font-weight': typoX.fontWeight
        };
      }

      if (typoX.textDecoration[breakPointX] != undefined) {
        var str = {};
        var textDecorationX = typoX.textDecoration[breakPointX];
        var textDecorationXStr = textDecorationX.length > 0 ? textDecorationX.join(' ') : '';
        str[breakPointX] = textDecorationXStr; //typoX.textDecoration[breakPointX] = typoX.textDecoration[breakPointX].join(' ');

        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'text-decoration': str
        };
      }

      if (typoX.textTransform[breakPointX] != undefined) {
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'text-transform': typoX.textTransform
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function onChangeBreakPoint(x, index) {
      setPreviewDeviceType(x.value);
      var asdsdsd = wp.data.dispatch('postgrid-shop').setBreakPoint(x.value);
      asdsdsd.then(res => {
        setBreakPointX(res.breakpoint); //generateBlockCssY();

        myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      });
    }

    return [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.BlockControls, null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.InspectorControls, {
      key: "general"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "px-3",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'No Wrapper',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'span',
        value: 'SPAN'
      }, {
        label: 'div',
        value: 'DIV'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Archive Description",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Archive Type"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_17__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: archiveTypes,
      buttonTitle: "Choose",
      onChange: (option, index) => {
        var options = { ...archiveTitle.options,
          archiveType: option.value
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      },
      values: ''
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "bg-gray-500 text-white p-3 py-2"
    }, archiveTypes[archiveTitle.options.archiveType].label), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Label"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: archiveTitle.options.customLabel,
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          customLabel: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), (archiveTitle.options.archiveType == 'year' || archiveTitle.options.archiveType == 'month' || archiveTitle.options.archiveType == 'day') && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Date Format"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_17__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: dateFormats,
      buttonTitle: "Choose",
      onChange: (option, index) => {
        var options = { ...archiveTitle.options,
          dateFormat: option.value
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      },
      values: ''
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Format"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: archiveTitle.options.dateFormat,
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          dateFormat: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), dateFormats[archiveTitle.options.dateFormat] != undefined && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "p-2 my-3 bg-gray-500 text-white"
    }, dateFormats[archiveTitle.options.dateFormat].label)), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Link To"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_17__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: archiveLinkToArgs,
      buttonTitle: archiveTitle.options.linkTo.length == 0 ? 'Choose' : archiveLinkToArgs[archiveTitle.options.linkTo].label,
      onChange: setFieldLinkTo,
      values: []
    })), archiveTitle.options.linkTo == 'customField' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Field Key"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: archiveTitle.options.linkToMetaKey,
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          linkToMetaKey: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), archiveTitle.options.linkTo == 'customUrl' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom URL"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: linkPickerPosttitle ? "!bg-gray-400" : '',
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
      onClick: ev => {
        setLinkPickerPosttitle(prev => !prev);
      }
    }), archiveTitle.options.customUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: "!text-red-500 ml-2",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
      onClick: ev => {
        var options = { ...archiveTitle.options,
          customUrl: ''
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
        setLinkPickerPosttitle(false);
      }
    }), linkPickerPosttitle && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Popover, {
      position: "bottom right"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.__experimentalLinkControl, {
      settings: [],
      value: archiveTitle.options.customUrl,
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          customUrl: newVal.url
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "p-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: "font-bold"
    }, "Linked to:"), " ", archiveTitle.options.customUrl.length != 0 ? archiveTitle.options.customUrl : 'No link', " ")))), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: archiveTitle.options.tag,
      options: [{
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          tag: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Link Target"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: archiveTitle.options.linkTarget,
      options: [{
        label: 'Choose...',
        value: ''
      }, {
        label: '_self',
        value: '_self'
      }, {
        label: '_blank',
        value: '_blank'
      }, {
        label: '_parent',
        value: '_parent'
      }, {
        label: '_top',
        value: '_top'
      }],
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          linkTarget: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Attributes"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: " cursor-pointer px-3 text-white py-1 bg-blue-600",
      onClick: ev => {
        var sdsd = archiveTitle.options.linkAttr.concat({
          id: '',
          val: ''
        });
        var options = { ...archiveTitle.options,
          linkAttr: sdsd
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
        linkAttrObj();
      }
    }, "Add")), archiveTitle.options.linkAttr.map((x, i) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
        className: "my-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Name",
        value: archiveTitle.options.linkAttr[i].id,
        onChange: newVal => {
          archiveTitle.options.linkAttr[i].id = newVal;
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = { ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: { ...archiveTitle,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Value",
        value: x.val,
        onChange: newVal => {
          archiveTitle.options.linkAttr[i].val = newVal;
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = { ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: { ...archiveTitle,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
        className: "text-lg cursor-pointer px-3 text-white py-1 bg-red-400 icon-close",
        onClick: ev => {
          archiveTitle.options.linkAttr.splice(i, 1);
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = { ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: { ...archiveTitle,
              options: options
            }
          });
        }
      })));
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: wrapper,
      onChange: onChangeStyleArchiveTitle,
      onAdd: onAddStyleArchiveTitle,
      onRemove: onRemoveStyleArchiveTitle
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_18__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: onChangeIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Icon postion"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: 'Choose Position',
        value: ''
      }, {
        label: 'Before Archive Title',
        value: 'beforeArchiveTitle'
      }, {
        label: 'After Archive Title',
        value: 'afterArchiveTitle'
      }, {
        label: 'Before Prefix',
        value: 'beforePrefix'
      }, {
        label: 'After Prefix',
        value: 'afterPrefix'
      }, {
        label: 'Before Postfix',
        value: 'beforePostfix'
      }, {
        label: 'After Postfix',
        value: 'afterPostfix'
      }],
      onChange: newVal => {
        var options = { ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: wrapper,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Prefix",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Prefix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: prefix.options.text,
      onChange: newVal => {
        var options = { ...prefix.options,
          text: newVal
        };
        setAttributes({
          prefix: {
            styles: prefix.styles,
            options: options
          }
        }); // setAttributes({ prefix: { text: newVal, class: prefix.options.class, color: prefix.color, backgroundColor: prefix.backgroundColor } })
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: wrapper,
      onChange: onChangeStylePrefix,
      onAdd: onAddStylePrefix,
      onRemove: onRemoveStylePrefix
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Postfix",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Postfix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: postfix.options.text,
      onChange: newVal => {
        var options = { ...postfix.options,
          text: newVal
        };
        setAttributes({
          postfix: { ...postfix,
            options: options
          }
        }); // setAttributes({ postfix: { text: newVal, class: prefix.options.class, color: postfix.color, backgroundColor: postfix.backgroundColor } })
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: wrapper,
      onChange: onChangeStylePostfix,
      onAdd: onAddStylePostfix,
      onRemove: onRemoveStylePostfix
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Title Wrapper"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, wrapperSelector, '{/* your CSS here*/}'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Title link"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, archiveTitleSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Prefix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, prefixSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Postfix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, postfixSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_14__["default"], {
      utm: {
        utm_source: 'BlockPostTitle',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, wrapper.options.tag && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(CustomTag, {
      className: [blockId]
    }, icon.options.position == 'beforePrefix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: prefix.options.class
    }, prefix.options.text), icon.options.position == 'afterPrefix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("a", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      className: "archiveTitle",
      onClick: handleLinkClick
    }, linkAttrItems, {
      target: archiveTitle.options.linkTarget,
      href: postUrl
    }), icon.options.position == 'beforeArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == 'afterArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, icon.options.position == 'beforeArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == 'afterArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), postfix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: postfix.options.class
    }, postfix.options.text), icon.options.position == 'afterPostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), wrapper.options.tag.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: prefix.options.class
    }, prefix.options.text), icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("a", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      className: "archiveTitle",
      onClick: handleLinkClick
    }, linkAttrItems, {
      target: archiveTitle.options.linkTarget,
      href: postUrl
    }), "A", icon.options.position == 'beforeArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == 'afterArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: [blockId]
    }, icon.options.position == 'beforeArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == 'afterArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }))))];
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/archive-title/index.js":
/*!*******************************************!*\
  !*** ./src/blocks/archive-title/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link-off.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_css_display__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/css-display */ "./src/components/css-display/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");














const {
  RawHTML
} = wp.element;














var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__.registerBlockType)("post-grid/archive-title", {
  title: "Archive Title",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#2563eb',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("svg", {
      width: "500",
      height: "500",
      viewBox: "0 0 500 500",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M25 95C25 92.2386 27.2386 90 30 90H470C472.761 90 475 92.2386 475 95V145C475 147.761 472.761 150 470 150H30C27.2386 150 25 147.761 25 145V95Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M25 234C25 231.239 27.2386 229 30 229H470C472.761 229 475 231.239 475 234V254C475 256.761 472.761 259 470 259H30C27.2386 259 25 256.761 25 254V234Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M25 298C25 295.239 27.2386 293 30 293H470C472.761 293 475 295.239 475 298V318C475 320.761 472.761 323 470 323H30C27.2386 323 25 320.761 25 318V298Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M25 362C25 359.239 27.2386 357 30 357H366C368.761 357 371 359.239 371 362V382C371 384.761 368.761 387 366 387H30C27.2386 387 25 384.761 25 382V362Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    archiveTitle: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          archiveType: 'auto',
          customLabel: 'Archive: %s',
          dateFormat: '',
          linkTo: '',
          // postUrl, customField, authorUrl, authorLink, homeUrl, custom
          linkToUrl: '',
          linkToMetaKey: '',
          linkTarget: '_blank',
          linkAttr: [],
          customUrl: '',
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          }
        }
      }
    },
    icon: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'far fa-calendar-alt',
          position: 'beforeArchiveTitle',

          /*before, after, prefix, postfix */
          class: 'postdate-icon'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          }
        }
      }
    },
    prefix: {
      type: 'object',
      default: {
        options: {
          text: '',
          class: 'prefix'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          }
        }
      }
    },
    postfix: {
      type: 'object',
      default: {
        options: {
          text: '',
          class: 'prefix'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          }
        }
      }
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    let archiveTitle = attributes.archiveTitle;
    var wrapper = attributes.wrapper;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var icon = attributes.icon;
    var prefix = attributes.prefix;
    var postfix = attributes.postfix;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType'];
    const [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(myStore.getBreakPoint());
    const [customTags, setCustomTags] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
    const [linkPickerPosttitle, setLinkPickerPosttitle] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    var archiveTypes = {
      'auto': {
        label: 'Auto Detect',
        value: 'auto'
      } // 'author': { label: 'Author', value: 'author' },
      // 'category': { label: 'Category', value: 'category' },
      // 'tag': { label: 'Tag', value: 'tag' },
      // 'taxonomy': { label: 'Taxonomy', value: 'taxonomy' },
      // 'search': { label: 'Search', value: 'search' },
      // 'index': { label: 'Index', value: 'index' },
      // 'year': { label: 'Year', value: 'year' },
      // 'month': { label: 'Month', value: 'month' },
      // 'date': { label: 'Date', value: 'date' },
      // 'wcCatalog': { label: 'WooCommerce Catalog', value: 'wcCatalog' },
      // 'wcSearch': { label: 'WooCommerce Search', value: 'wcSearch' },

    };
    var archiveLinkToArgsBasic = {
      none: {
        label: 'No Link',
        value: ''
      },
      archiveUrl: {
        label: 'Archive URL',
        value: 'archiveUrl'
      },
      homeUrl: {
        label: 'Home URL',
        value: 'homeUrl'
      },
      customUrl: {
        label: 'Custom',
        value: 'customUrl'
      }
    };
    let archiveLinkToArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__.applyFilters)('archiveLinkToArgs', archiveLinkToArgsBasic);
    var dateFormats = {
      'Y-M-d': {
        label: '2022-May-25',
        value: 'Y-M-d'
      },
      'Y-m-d': {
        label: '2022-05-25',
        value: 'Y-m-d'
      },
      'd-m-y': {
        label: '25-05-2022',
        value: 'd-m-y'
      },
      'd/m/y': {
        label: '25/05/2022',
        value: 'd/m/y'
      },
      'y-m-d': {
        label: '2022-05-25',
        value: 'y-m-d'
      },
      'y/m/d': {
        label: '2022/05/25',
        value: 'y/m/d'
      },
      'D M y': {
        label: 'Sun May 2022',
        value: 'D M y'
      },
      'D M d, y': {
        label: 'Sun May 11, 2022',
        value: 'D M d, y'
      },
      'M D d, y': {
        label: 'May Sun 11, 2022',
        value: 'M D d, y'
      },
      'M d, y': {
        label: 'May 11, 2022',
        value: 'M d, y'
      },
      'd M y': {
        label: '25 May 2022',
        value: 'd M y'
      }
    };
    const [archiveTitleEdited, setarchiveTitleEdited] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('Hello %s');

    function onChangeIcon(arg) {
      var options = { ...icon.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        icon: { ...icon,
          options: options
        }
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      console.log(archiveTitle);
      var archiveType = archiveTitle.options.archiveType;

      if (archiveType == 'auto') {
        //archiveTitleEdited = archiveTitle.options.customLabel;
        setarchiveTitleEdited(archiveTitle.options.customLabel);
      }
    }, [archiveTitle]);

    function setFieldLinkTo(option, index) {
      var options = { ...archiveTitle.options,
        linkTo: option.value
      };
      setAttributes({
        archiveTitle: { ...archiveTitle,
          options: options
        }
      });
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ wrapper: { ...wrapper } });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      // if (blockCssY.items[wrapperSelector] == undefined) {
      //   blockCssY.items[wrapperSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[wrapperSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[wrapperSelector][key] != undefined) {
      //   delete blockCssY.items[wrapperSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // sudoScourceX[key] = {};
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStyleArchiveTitle(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, archiveTitle);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        archiveTitle: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...archiveTitle[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ archiveTitle: { ...archiveTitle } });
    }

    function onRemoveStyleArchiveTitle(sudoScource, key) {
      var object = myStore.deletePropertyDeep(archiveTitle, [sudoScource, key, breakPointX]);
      setAttributes({
        archiveTitle: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...archiveTitle[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // archiveTitle[sudoScource] = sudoScourceX;
      // setAttributes({ archiveTitle: { ...archiveTitle } });
      // if (blockCssY.items[archiveTitleSelector] == undefined) {
      //   blockCssY.items[archiveTitleSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[archiveTitleSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[archiveTitleSelector][key] != undefined) {
      //   delete blockCssY.items[archiveTitleSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleArchiveTitle(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, archiveTitle);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        archiveTitle: object
      });
    }

    function onChangeStyleIcon(sudoScource, newVal, attr) {
      // var sudoScourceX = { ...icon[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ icon: { ...icon } });
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(icon, [sudoScource, key, breakPointX]);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...icon[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // icon[sudoScource] = sudoScourceX;
      // setAttributes({ icon: { ...icon } });
      // if (blockCssY.items[iconSelector] == undefined) {
      //   blockCssY.items[iconSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[iconSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[iconSelector][key] != undefined) {
      //   delete blockCssY.items[iconSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleIcon(sudoScource, key) {
      // var sudoScourceX = { ...icon[sudoScource] }
      // sudoScourceX[key] = {};
      // icon[sudoScource] = sudoScourceX;
      // setAttributes({ icon: { ...icon } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        icon: object
      });
    }

    function onChangeStylePrefix(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, prefix);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        prefix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...prefix[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ prefix: { ...prefix } });
    }

    function onRemoveStylePrefix(sudoScource, key) {
      var object = myStore.deletePropertyDeep(prefix, [sudoScource, key, breakPointX]);
      setAttributes({
        prefix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...prefix[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // prefix[sudoScource] = sudoScourceX;
      // //sudoScourceX[attr][breakPointX] = newVal;
      // setAttributes({ prefix: { ...prefix } });
      // if (blockCssY.items[prefixSelector] == undefined) {
      //   blockCssY.items[prefixSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[prefixSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[prefixSelector][key] != undefined) {
      //   delete blockCssY.items[prefixSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStylePrefix(sudoScource, key) {
      var sudoScourceX = { ...prefix[sudoScource]
      };
      sudoScourceX[key] = {};
      prefix[sudoScource] = sudoScourceX;
      setAttributes({
        prefix: { ...prefix
        }
      });
    }

    function onChangeStylePostfix(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, postfix);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        postfix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); //  var sudoScourceX = { ...postfix[sudoScource] }
      //       var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      //       sudoScourceX[attr][breakPointX] = newVal;
      //       if (blockCssY.items[elementSelector] == undefined) {
      //         blockCssY.items[elementSelector] = {};
      //       }
      //       Object.entries(sudoScourceX).map(args => {
      //         var argAttr = myStore.cssAttrParse(args[0]);
      //         var argAttrVal = args[1];
      //         blockCssY.items[elementSelector][argAttr] = argAttrVal;
      //       })
      //       setAttributes({ blockCssY: { items: blockCssY.items } });
      //       setAttributes({ postfix: { ...postfix } });
    }

    function onRemoveStylePostfix(sudoScource, key) {
      var object = myStore.deletePropertyDeep(postfix, [sudoScource, key, breakPointX]);
      setAttributes({
        postfix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...postfix[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // postfix[sudoScource] = sudoScourceX;
      // //sudoScourceX[attr][breakPointX] = newVal;
      // setAttributes({ postfix: { ...postfix } });
      // if (blockCssY.items[postfixSelector] == undefined) {
      //   blockCssY.items[postfixSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[postfixSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[postfixSelector][key] != undefined) {
      //   delete blockCssY.items[postfixSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStylePostfix(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, postfix);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        postfix: object
      });
    }

    function onChangeIconTypo(typoX) {
      setAttributes({
        icon: { ...icon,
          styles: typoX
        }
      });
      var newValuesObjX = {};
      var itemsX = blockCssY.items;

      if (typoX.fontSize[breakPointX] != undefined) {
        var fontSizeVal = typoX.fontSize[breakPointX].val ? typoX.fontSize[breakPointX].val : 16;
        var fontSizeUnit = typoX.fontSize[breakPointX].unit ? typoX.fontSize[breakPointX].unit : 'px';
        var fontSizeX = blockCssY.items[iconSelector] != undefined ? blockCssY.items[iconSelector]['font-size'] : {};
        fontSizeX[breakPointX] = fontSizeVal + fontSizeUnit; //blockCssY.items[iconSelector] = { ...blockCssY.items[iconSelector], 'font-size': fontSizeX };

        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'font-size': fontSizeX
        };
      }

      if (typoX.lineHeight[breakPointX] != undefined) {
        var lineHeightVal = typoX.lineHeight[breakPointX].val ? typoX.lineHeight[breakPointX].val : 16;
        var lineHeightUnit = typoX.lineHeight[breakPointX].unit ? typoX.lineHeight[breakPointX].unit : 'px';
        var lineHeightX = blockCssY.items[iconSelector]['line-height'] != undefined ? blockCssY.items[iconSelector]['line-height'] : {};
        lineHeightX[breakPointX] = lineHeightVal + lineHeightUnit; //blockCssY.items[iconSelector] = { ...blockCssY.items[iconSelector], 'line-height': lineHeightX };

        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'line-height': lineHeightX
        };
      }

      if (typoX.fontWeight[breakPointX] != undefined) {
        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'font-weight': typoX.fontWeight
        };
      }

      if (typoX.textDecoration[breakPointX] != undefined) {
        var str = {};
        var textDecorationX = typoX.textDecoration[breakPointX];
        var textDecorationXStr = textDecorationX.length > 0 ? textDecorationX.join(' ') : '';
        str[breakPointX] = textDecorationXStr;
        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'text-decoration': str
        };
      } //setAttributes({ blockCssY: { items: blockCssY.items } });


      setAttributes({
        blockCssY: {
          items: itemsX
        }
      });
    }

    String.prototype.strtr = function (dic) {
      const str = this.toString(),
            makeToken = inx => `{{###~${inx}~###}}`,
            tokens = Object.keys(dic).map((key, inx) => ({
        key,
        val: dic[key],
        token: makeToken(inx)
      })),
            tokenizedStr = tokens.reduce((carry, entry) => carry.replace(new RegExp(entry.key, "g"), entry.token), str);

      return tokens.reduce((carry, entry) => carry.replace(new RegExp(entry.token, "g"), entry.val), tokenizedStr);
    };

    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('');
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      var iconSrc = icon.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      console.log(iconHtml);
      setIconHtml(iconHtml);
    }, [icon]);
    const [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__.useEntityProp)('postType', postType, 'link', postId);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      }); // setAttributes({ archiveTitle: archiveTitle });
      // setAttributes({ wrapper: wrapper });
      //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      customTags['currentYear'] = '2022';
      customTags['currentMonth'] = '07';
      customTags['currentDay'] = '27';
      customTags['currentDate'] = '27';
      customTags['currentTime'] = '27';
      customTags['postPublishDate'] = '123';
      customTags['postModifiedDate'] = '123';
      customTags['termId'] = '';
      customTags['termTitle'] = '';
      customTags['termDescription'] = '';
      customTags['termPostCount'] = '';
      customTags['postTagTitle'] = 'First Tag Title';
      customTags['postTagsTitle'] = 'First Tag Title';
      customTags['postCategoryTitle'] = 'First Category Title';
      customTags['postCategoriesTitle'] = 'First Categories Title';
      customTags['postTermTitle'] = 'First Term Title';
      customTags['postTermsTitle'] = 'List of all terms title';
      customTags['postId'] = '123';
      customTags['postStatus'] = '123';
      customTags['authorId'] = '123';
      customTags['authorName'] = 'Nur Hasan';
      customTags['authorFirstName'] = 'Nur';
      customTags['authorLastName'] = 'Hasan';
      customTags['authorDescription'] = 'Hasan';
      customTags['excerpt'] = 'Here is the post excerpt';
      customTags['rankmathTitle'] = 'Hasan';
      customTags['rankmathPermalink'] = 'Hasan';
      customTags['rankmathExcerpt'] = 'Hasan';
      customTags['rankmathFocusKeyword'] = 'Hasan';
      customTags['rankmathFocusKeywords'] = 'Hasan';
      customTags['rankmathOrgname'] = 'Hasan';
      customTags['rankmathOrgurl'] = 'Hasan';
      customTags['rankmathOrglogo'] = 'Hasan';
      customTags['siteTitle'] = '';
      customTags['siteDescription'] = '';
      customTags['siteTagline'] = '';
      customTags['postMeta'] = '';
      customTags['separator'] = '';
      customTags['searchTerms'] = '';
      customTags['counter'] = '1';
    }, [clientId]); // Wrapper CSS Class Selectors

    const wrapperSelector = blockClass;
    var archiveTitleSelector = '';

    if (wrapper.options.tag.length != 0) {
      if (archiveTitle.options.linkTo.length > 0) {
        archiveTitleSelector = blockClass + ' a';
      } else {
        archiveTitleSelector = blockClass; //archiveTitleSelector = blockClass + ' .archiveTitle';
      }
    } else {
      archiveTitleSelector = blockClass;
    }

    const prefixSelector = blockClass + ' .prefix';
    const postfixSelector = blockClass + ' .postfix';
    const iconSelector = blockClass + ' .postdate-icon';
    var breakPointList = [{
      label: 'Select..',
      icon: '',
      value: ''
    }];

    for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_9__["default"]) {
      var item = _breakpoints__WEBPACK_IMPORTED_MODULE_9__["default"][x];
      breakPointList.push({
        label: item.name,
        icon: item.icon,
        value: item.id
      });
    }

    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }

    function paddingControl(nextValues) {
      var responsive = archiveTitle.styles.padding;
      responsive[breakPointX] = nextValues;
      var styles = { ...archiveTitle.styles,
        padding: responsive
      };
      setAttributes({
        archiveTitle: { ...archiveTitle,
          styles: styles
        }
      });
      blockCssY.items[archiveTitleSelector] = blockCssY.items[archiveTitleSelector] != undefined ? blockCssY.items[archiveTitleSelector] : {};
      nextValues.top = nextValues.top == undefined ? '0px' : nextValues.top;
      nextValues.right = nextValues.right == undefined ? '0px' : nextValues.right;
      nextValues.bottom = nextValues.bottom == undefined ? '0px' : nextValues.bottom;
      nextValues.left = nextValues.left == undefined ? '0px' : nextValues.left;

      if (nextValues.top != undefined) {
        var paddingTop = blockCssY.items[archiveTitleSelector]['padding-top'] != undefined ? blockCssY.items[archiveTitleSelector]['padding-top'] : {};
        paddingTop[breakPointX] = nextValues.top;
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'padding-top': paddingTop
        };
      }

      if (nextValues.right != undefined) {
        var paddingRight = blockCssY.items[archiveTitleSelector]['padding-right'] != undefined ? blockCssY.items[archiveTitleSelector]['padding-right'] : {};
        paddingRight[breakPointX] = nextValues.right;
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'padding-right': paddingRight
        };
      }

      if (nextValues.bottom != undefined) {
        var paddingBottom = blockCssY.items[archiveTitleSelector]['padding-bottom'] != undefined ? blockCssY.items[archiveTitleSelector]['padding-bottom'] : {};
        paddingBottom[breakPointX] = nextValues.bottom;
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'padding-bottom': paddingBottom
        };
      }

      if (nextValues.left != undefined) {
        var paddingLeft = blockCssY.items[archiveTitleSelector]['padding-left'] != undefined ? blockCssY.items[archiveTitleSelector]['padding-left'] : {};
        paddingLeft[breakPointX] = nextValues.left;
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'padding-left': paddingLeft
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function marginControl(nextValues) {
      var responsive = archiveTitle.styles.margin;
      responsive[breakPointX] = nextValues;
      var styles = { ...archiveTitle.styles,
        margin: responsive
      };
      setAttributes({
        archiveTitle: { ...archiveTitle,
          styles: styles
        }
      });
      nextValues.top = nextValues.top == undefined ? '0px' : nextValues.top;
      nextValues.right = nextValues.right == undefined ? '0px' : nextValues.right;
      nextValues.bottom = nextValues.bottom == undefined ? '0px' : nextValues.bottom;
      nextValues.left = nextValues.left == undefined ? '0px' : nextValues.left;
      blockCssY.items[archiveTitleSelector] = blockCssY.items[archiveTitleSelector] != undefined ? blockCssY.items[archiveTitleSelector] : {};

      if (nextValues.top != undefined) {
        var marginTop = blockCssY.items[archiveTitleSelector]['margin-top'] != undefined ? blockCssY.items[archiveTitleSelector]['margin-top'] : {};
        marginTop[breakPointX] = nextValues.top;
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'margin-top': marginTop
        };
      }

      if (nextValues.right != undefined) {
        var marginRight = blockCssY.items[archiveTitleSelector]['margin-right'] !== undefined ? blockCssY.items[archiveTitleSelector]['margin-right'] : {};
        marginRight[breakPointX] = nextValues.right;
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'margin-right': marginRight
        };
      }

      if (nextValues.bottom != undefined) {
        var marginBottom = blockCssY.items[archiveTitleSelector]['margin-bottom'] !== undefined ? blockCssY.items[archiveTitleSelector]['margin-bottom'] : {};
        marginBottom[breakPointX] = nextValues.bottom;
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'margin-bottom': marginBottom
        };
      }

      if (nextValues.left != undefined) {
        var marginLeft = blockCssY.items[archiveTitleSelector]['margin-left'] !== undefined ? blockCssY.items[archiveTitleSelector]['margin-left'] : {};
        marginLeft[breakPointX] = nextValues.left;
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'margin-left': marginLeft
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function generateBlockCssY() {
      var reponsiveCssGroups = {};

      for (var selector in blockCssY.items) {
        var attrs = blockCssY.items[selector];

        for (var attr in attrs) {
          var breakpoints = attrs[attr];

          for (var device in breakpoints) {
            var attrValue = breakpoints[device];

            if (reponsiveCssGroups[device] == undefined) {
              reponsiveCssGroups[device] = [];
            }

            if (reponsiveCssGroups[device] == undefined) {
              reponsiveCssGroups[device] = [];
            }

            if (reponsiveCssGroups[device][selector] == undefined) {
              reponsiveCssGroups[device][selector] = [];
            }

            reponsiveCssGroups[device][selector].push({
              'attr': attr,
              'val': attrValue
            });
          }
        }
      } //return false;


      var reponsiveCssMobile = '';

      if (reponsiveCssGroups['Mobile'] != undefined) {
        reponsiveCssMobile += '@media only screen and (min-width: 0px) and (max-width: 360px){';

        for (var selector in reponsiveCssGroups['Mobile']) {
          var attrs = reponsiveCssGroups['Mobile'][selector];
          reponsiveCssMobile += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCssMobile += attrName + ':' + attrValue + ';';
          }

          reponsiveCssMobile += '}';
        }

        reponsiveCssMobile += '}';
      }

      var reponsiveCssTablet = '';

      if (reponsiveCssGroups['Tablet'] != undefined) {
        reponsiveCssTablet += '@media only screen and (min-width: 361px) and (max-width: 780px){';

        for (var selector in reponsiveCssGroups['Tablet']) {
          var attrs = reponsiveCssGroups['Tablet'][selector];
          reponsiveCssTablet += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCssTablet += attrName + ':' + attrValue + ';';
          }

          reponsiveCssTablet += '}';
        }

        reponsiveCssTablet += '}';
      }

      var reponsiveCssDesktop = '';

      if (reponsiveCssGroups['Desktop'] != undefined) {
        reponsiveCssDesktop += '@media only screen and (min-width: 781px){';

        for (var selector in reponsiveCssGroups['Desktop']) {
          var attrs = reponsiveCssGroups['Desktop'][selector];
          reponsiveCssDesktop += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCssDesktop += attrName + ':' + attrValue + ';';
          }

          reponsiveCssDesktop += '}';
        }

        reponsiveCssDesktop += '}';
      }

      var reponsiveCss = reponsiveCssMobile + reponsiveCssTablet + reponsiveCssDesktop;
      var iframe = document.querySelectorAll('[name="editor-canvas"]')[0];

      if (iframe) {
        setTimeout(() => {
          var iframeDocument = iframe.contentDocument;
          var body = iframeDocument.body;
          var divWrap = iframeDocument.getElementById("css-block-" + blockId);

          if (divWrap != undefined) {
            iframeDocument.getElementById("css-block-" + blockId).outerHTML = "";
          }

          var divWrap = '<div id="css-block-' + blockId + '"></div>';
          body.insertAdjacentHTML('beforeend', divWrap);
          var csswrappg = iframeDocument.getElementById('css-block-' + blockId);
          var str = '<style>' + reponsiveCss + customCss + '</style>';
          csswrappg.insertAdjacentHTML('beforeend', str);
        }, 200);
      } else {
        var wpfooter = document.getElementById('wpfooter');
        var divWrap = document.getElementById("css-block-" + blockId);

        if (divWrap != undefined) {
          document.getElementById("css-block-" + blockId).outerHTML = "";
        }

        var divWrap = '<div id="css-block-' + blockId + '"></div>';
        wpfooter.insertAdjacentHTML('beforeend', divWrap);
        var csswrappg = document.getElementById('css-block-' + blockId);
        var str = '<style>' + reponsiveCss + customCss + '</style>';
        csswrappg.insertAdjacentHTML('beforeend', str);
      }
    }

    var [linkAttrItems, setlinkAttrItems] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({}); // Using the hook.

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      //generateBlockCssY()
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      }); //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      linkAttrObj();
    }, [archiveTitle]);

    var linkAttrObj = () => {
      var sdsd = {};
      archiveTitle.options.linkAttr.map(x => {
        if (x.val) sdsd[x.id] = x.val;
      });
      setlinkAttrItems(sdsd);
    };

    const colors = [{
      name: '9DD6DF',
      color: '#9DD6DF'
    }, {
      name: '18978F',
      color: '#18978F'
    }, {
      name: 'A084CF',
      color: '#A084CF'
    }, {
      name: 'DFBB9D',
      color: '#DFBB9D'
    }, {
      name: '774360',
      color: '#774360'
    }, {
      name: '3AB0FF',
      color: '#3AB0FF'
    }, {
      name: '51557E',
      color: '#51557E'
    }];
    const [setSome, setSomeState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
    const [stateX, setStateX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('Old Value');
    const {
      __experimentalSetPreviewDeviceType: setPreviewDeviceType
    } = wp.data.dispatch('core/edit-post');
    var postUrl = archiveTitle.options.customUrl != undefined && archiveTitle.options.customUrl.length > 0 ? archiveTitle.options.customUrl : currentPostUrl;
    const CustomTag = `${wrapper.options.tag}`;
    const CustomTagPostTitle = `${archiveTitle.options.tag}`;

    function onChangeTypo(typoX) {
      setAttributes({
        archiveTitle: { ...archiveTitle,
          styles: typoX
        }
      });
      var newValuesObjX = {};

      if (typoX.fontFamily[breakPointX] != undefined) {
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'font-family': typoX.fontFamily
        };
      }

      if (typoX.fontSize[breakPointX] != undefined) {
        var fontSizeVal = typoX.fontSize[breakPointX].val ? typoX.fontSize[breakPointX].val : 16;
        var fontSizeUnit = typoX.fontSize[breakPointX].unit ? typoX.fontSize[breakPointX].unit : 'px';
        var fontSizeX = blockCssY.items[archiveTitleSelector] != undefined ? blockCssY.items[archiveTitleSelector]['font-size'] : {};
        fontSizeX[breakPointX] = fontSizeVal + fontSizeUnit;
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'font-size': fontSizeX
        };
      }

      if (typoX.lineHeight[breakPointX] != undefined) {
        var lineHeightVal = typoX.lineHeight[breakPointX].val ? typoX.lineHeight[breakPointX].val : 0;
        var lineHeightUnit = typoX.lineHeight[breakPointX].unit ? typoX.lineHeight[breakPointX].unit : 'px';
        var lineHeightX = blockCssY.items[archiveTitleSelector]['line-height'] != undefined ? blockCssY.items[archiveTitleSelector]['line-height'] : {};
        lineHeightX[breakPointX] = lineHeightVal + lineHeightUnit;
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'line-height': lineHeightX
        };
      }

      if (typoX.letterSpacing[breakPointX] != undefined) {
        var letterSpacingVal = typoX.letterSpacing[breakPointX].val ? typoX.letterSpacing[breakPointX].val : 0;
        var letterSpacingUnit = typoX.letterSpacing[breakPointX].unit ? typoX.letterSpacing[breakPointX].unit : 'px';
        var letterSpacingX = blockCssY.items[archiveTitleSelector]['letter-spacing'] != undefined ? blockCssY.items[archiveTitleSelector]['letter-spacing'] : {};
        letterSpacingX[breakPointX] = letterSpacingVal + letterSpacingUnit;
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'letter-spacing': letterSpacingX
        };
      }

      if (typoX.fontWeight[breakPointX] != undefined) {
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'font-weight': typoX.fontWeight
        };
      }

      if (typoX.textDecoration[breakPointX] != undefined) {
        var str = {};
        var textDecorationX = typoX.textDecoration[breakPointX];
        var textDecorationXStr = textDecorationX.length > 0 ? textDecorationX.join(' ') : '';
        str[breakPointX] = textDecorationXStr; //typoX.textDecoration[breakPointX] = typoX.textDecoration[breakPointX].join(' ');

        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'text-decoration': str
        };
      }

      if (typoX.textTransform[breakPointX] != undefined) {
        blockCssY.items[archiveTitleSelector] = { ...blockCssY.items[archiveTitleSelector],
          'text-transform': typoX.textTransform
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function onChangeBreakPoint(x, index) {
      setPreviewDeviceType(x.value);
      var asdsdsd = wp.data.dispatch('postgrid-shop').setBreakPoint(x.value);
      asdsdsd.then(res => {
        setBreakPointX(res.breakpoint); //generateBlockCssY();

        myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      });
    }

    return [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.BlockControls, null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.InspectorControls, {
      key: "general"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "px-3",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'No Wrapper',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'span',
        value: 'SPAN'
      }, {
        label: 'div',
        value: 'DIV'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Archive Title",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Archive Type"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_17__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: archiveTypes,
      buttonTitle: "Choose",
      onChange: (option, index) => {
        var options = { ...archiveTitle.options,
          archiveType: option.value
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      },
      values: ''
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "bg-gray-500 text-white p-3 py-2"
    }, archiveTypes[archiveTitle.options.archiveType].label), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Label"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: archiveTitle.options.customLabel,
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          customLabel: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), (archiveTitle.options.archiveType == 'year' || archiveTitle.options.archiveType == 'month' || archiveTitle.options.archiveType == 'day') && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Date Format"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_17__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: dateFormats,
      buttonTitle: "Choose",
      onChange: (option, index) => {
        var options = { ...archiveTitle.options,
          dateFormat: option.value
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      },
      values: ''
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Format"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: archiveTitle.options.dateFormat,
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          dateFormat: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), dateFormats[archiveTitle.options.dateFormat] != undefined && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "p-2 my-3 bg-gray-500 text-white"
    }, dateFormats[archiveTitle.options.dateFormat].label)), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Link To"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_17__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: archiveLinkToArgs,
      buttonTitle: archiveTitle.options.linkTo.length == 0 ? 'Choose' : archiveLinkToArgs[archiveTitle.options.linkTo].label,
      onChange: setFieldLinkTo,
      values: []
    })), archiveTitle.options.linkTo == 'customUrl' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom URL"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: linkPickerPosttitle ? "!bg-gray-400" : '',
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
      onClick: ev => {
        setLinkPickerPosttitle(prev => !prev);
      }
    }), archiveTitle.options.customUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: "!text-red-500 ml-2",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
      onClick: ev => {
        var options = { ...archiveTitle.options,
          customUrl: ''
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
        setLinkPickerPosttitle(false);
      }
    }), linkPickerPosttitle && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Popover, {
      position: "bottom right"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.__experimentalLinkControl, {
      settings: [],
      value: archiveTitle.options.customUrl,
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          customUrl: newVal.url
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "p-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: "font-bold"
    }, "Linked to:"), " ", archiveTitle.options.customUrl.length != 0 ? archiveTitle.options.customUrl : 'No link', " ")))), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: archiveTitle.options.tag,
      options: [{
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          tag: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Link Target"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: archiveTitle.options.linkTarget,
      options: [{
        label: 'Choose...',
        value: ''
      }, {
        label: '_self',
        value: '_self'
      }, {
        label: '_blank',
        value: '_blank'
      }, {
        label: '_parent',
        value: '_parent'
      }, {
        label: '_top',
        value: '_top'
      }],
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          linkTarget: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Attributes"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: " cursor-pointer px-3 text-white py-1 bg-blue-600",
      onClick: ev => {
        var sdsd = archiveTitle.options.linkAttr.concat({
          id: '',
          val: ''
        });
        var options = { ...archiveTitle.options,
          linkAttr: sdsd
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
        linkAttrObj();
      }
    }, "Add")), archiveTitle.options.linkAttr.map((x, i) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
        className: "my-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Name",
        value: archiveTitle.options.linkAttr[i].id,
        onChange: newVal => {
          archiveTitle.options.linkAttr[i].id = newVal;
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = { ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: { ...archiveTitle,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Value",
        value: x.val,
        onChange: newVal => {
          archiveTitle.options.linkAttr[i].val = newVal;
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = { ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: { ...archiveTitle,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
        className: "text-lg cursor-pointer px-3 text-white py-1 bg-red-400 icon-close",
        onClick: ev => {
          archiveTitle.options.linkAttr.splice(i, 1);
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = { ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: { ...archiveTitle,
              options: options
            }
          });
        }
      })));
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: wrapper,
      onChange: onChangeStyleArchiveTitle,
      onAdd: onAddStyleArchiveTitle,
      onRemove: onRemoveStyleArchiveTitle
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_18__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: onChangeIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Icon postion"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: 'Choose Position',
        value: ''
      }, {
        label: 'Before Archive Title',
        value: 'beforeArchiveTitle'
      }, {
        label: 'After Archive Title',
        value: 'afterArchiveTitle'
      }, {
        label: 'Before Prefix',
        value: 'beforePrefix'
      }, {
        label: 'After Prefix',
        value: 'afterPrefix'
      }, {
        label: 'Before Postfix',
        value: 'beforePostfix'
      }, {
        label: 'After Postfix',
        value: 'afterPostfix'
      }],
      onChange: newVal => {
        var options = { ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: wrapper,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Prefix",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Prefix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: prefix.options.text,
      onChange: newVal => {
        var options = { ...prefix.options,
          text: newVal
        };
        setAttributes({
          prefix: {
            styles: prefix.styles,
            options: options
          }
        }); // setAttributes({ prefix: { text: newVal, class: prefix.options.class, color: prefix.color, backgroundColor: prefix.backgroundColor } })
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: wrapper,
      onChange: onChangeStylePrefix,
      onAdd: onAddStylePrefix,
      onRemove: onRemoveStylePrefix
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Postfix",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Postfix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: postfix.options.text,
      onChange: newVal => {
        var options = { ...postfix.options,
          text: newVal
        };
        setAttributes({
          postfix: { ...postfix,
            options: options
          }
        }); // setAttributes({ postfix: { text: newVal, class: prefix.options.class, color: postfix.color, backgroundColor: postfix.backgroundColor } })
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: wrapper,
      onChange: onChangeStylePostfix,
      onAdd: onAddStylePostfix,
      onRemove: onRemoveStylePostfix
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Title Wrapper"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, wrapperSelector, '{/* your CSS here*/}'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Title link"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, archiveTitleSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Prefix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, prefixSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Postfix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, postfixSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_14__["default"], {
      utm: {
        utm_source: 'BlockPostTitle',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, wrapper.options.tag && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(CustomTag, {
      className: [blockId]
    }, icon.options.position == 'beforePrefix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: prefix.options.class
    }, prefix.options.text), icon.options.position == 'afterPrefix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("a", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      className: "archiveTitle",
      onClick: handleLinkClick
    }, linkAttrItems, {
      target: archiveTitle.options.linkTarget,
      href: postUrl
    }), icon.options.position == 'beforeArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == 'afterArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, icon.options.position == 'beforeArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == 'afterArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), postfix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: postfix.options.class
    }, postfix.options.text), icon.options.position == 'afterPostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), wrapper.options.tag.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: prefix.options.class
    }, prefix.options.text), icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("a", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      className: "archiveTitle",
      onClick: handleLinkClick
    }, linkAttrItems, {
      target: archiveTitle.options.linkTarget,
      href: postUrl
    }), "A", icon.options.position == 'beforeArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == 'afterArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: [blockId]
    }, icon.options.position == 'beforeArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == 'afterArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }))))];
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/breadcrumb/index.js":
/*!****************************************!*\
  !*** ./src/blocks/breadcrumb/index.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/menu.js");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_css_display__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/css-display */ "./src/components/css-display/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
















const {
  RawHTML
} = wp.element;













var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)("post-grid/breadcrumb", {
  title: "Breadcrumb",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#2563eb',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      width: "500",
      height: "500",
      viewBox: "0 0 500 500",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: "M25 249.5C25 246.739 27.2386 244.5 30 244.5H470C472.761 244.5 475 246.739 475 249.5V299.5C475 302.261 472.761 304.5 470 304.5H30C27.2386 304.5 25 302.261 25 299.5V249.5Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: "M25 355.5C25 352.739 27.2386 350.5 30 350.5H470C472.761 350.5 475 352.739 475 355.5V405.5C475 408.261 472.761 410.5 470 410.5H30C27.2386 410.5 25 408.261 25 405.5V355.5Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: "M241 147C241 144.239 243.239 142 246 142H470C472.761 142 475 144.239 475 147V197C475 199.761 472.761 202 470 202H246C243.239 202 241 199.761 241 197V147Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: "M100 132.5C119.569 132.5 135.429 116.72 135.429 97.25C135.429 77.7799 119.569 62 100 62C80.4312 62 64.5714 77.7799 64.5714 97.25C64.5714 116.72 80.4312 132.5 100 132.5ZM124.8 141.312H120.178C114.033 144.121 107.196 145.719 100 145.719C92.8036 145.719 85.9946 144.121 79.8223 141.312H75.2C54.6625 141.312 38 157.891 38 178.325V189.781C38 197.079 43.9509 203 51.2857 203H148.714C156.049 203 162 197.079 162 189.781V178.325C162 157.891 145.337 141.312 124.8 141.312Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    icon: {
      type: 'object',
      default: {
        options: {
          class: 'icon',
          position: 'beforeLabel'
          /*beforeLabel, afterLabel, beforeSeparator, afterSeparator*/

        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    label: {
      type: 'object',
      default: {
        options: {
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    separator: {
      type: 'object',
      default: {
        options: {
          class: '',
          text: '»'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    elements: {
      "type": "object",
      "default": {
        options: {
          linkTarget: '_blank',
          showLabel: true,
          showSeparator: true,
          showIcon: false,
          iconPositon: 'beforeLabel' // beforeLabel, afterLabel, beforeSeparator, afterSeparator

        },
        styles: {
          color: {
            Desktop: '#18978F'
          },
          backgroundColor: {},
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: {
              top: '5px',
              right: '5px',
              bottom: '5px',
              left: '5px'
            }
          },
          display: {},
          borderRadius: {},
          fontSize: {
            Desktop: {
              val: '35'
            }
          }
        },
        items: [{
          id: 'text',
          label: 'Text',
          customText: '',
          url: '',
          siteIcon: {
            library: 'fontAwesome',
            srcType: "class",

            /*class, html, img, svg */
            iconSrc: ''
          },
          options: {
            text: 'You are here: ',
            showSeparator: true
          },
          styles: {
            color: {
              Desktop: ''
            },
            backgroundColor: {},
            padding: {
              Desktop: ''
            },
            margin: {
              Desktop: ''
            }
          }
        }, {
          id: 'homePage',
          label: 'Home Page Link',
          customText: '',
          url: '',
          siteIcon: {
            library: 'fontAwesome',
            srcType: "class",

            /*class, html, img, svg */
            iconSrc: ''
          },
          options: {
            showSeparator: true
          },
          styles: {
            color: {
              Desktop: ''
            },
            backgroundColor: {},
            padding: {
              Desktop: ''
            },
            margin: {
              Desktop: ''
            }
          }
        }, {
          id: 'postTitle',
          label: 'Post Title',
          customText: '',
          url: '',
          siteIcon: {
            library: 'fontAwesome',
            srcType: "class",

            /*class, html, img, svg */
            iconSrc: ''
          },
          options: {
            showSeparator: true
          },
          styles: {
            color: {
              Desktop: ''
            },
            backgroundColor: {},
            padding: {
              Desktop: ''
            },
            margin: {
              Desktop: ''
            }
          }
        }]
      } // avatar, name, description, id

    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var wrapper = attributes.wrapper;
    var elements = attributes.elements;
    var icon = attributes.icon;
    var label = attributes.label;
    var separator = attributes.separator;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType'];
    var wrapperSelector = blockClass; // Wrapper CSS Class Selectors

    var itemSelector = blockClass + ' .item';
    var itemLinkSelector = blockClass + ' .item a';
    var iconSelector = blockClass + ' .item .icon';
    var labelSelector = blockClass + ' .item .label';
    var separatorSelector = blockClass + ' .item .separator';
    var [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(myStore.getBreakPoint());
    var [loading, setLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    var [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_6__.useEntityProp)('postType', postType, 'link', postId);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      }); //generateBlockCssY();

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
        'font-size': {
          "Desktop": "16px"
        }
      };
      blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
        'display': {
          "Desktop": "inline-block"
        }
      };
      blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
        'list-style': {
          "Desktop": "none"
        }
      };
      blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
        'margin-right': {
          "Desktop": "10px"
        }
      };
      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      elements.items.map((x, index) => {
        var styles = x.styles;
        Object.entries(styles).map(y => {
          var attrId = y[0];
          var attrVal = y[1];

          if (Object.keys(attrVal).length != 0) {
            var attrIdX = '';

            if (attrId == 'bgColor') {
              attrIdX = 'background-color';
            } else if (attrId == 'textAlign') {
              attrIdX = 'text-align';
            } else {
              attrIdX = attrId;
            }

            if (blockCssY.items[itemSelector + '.item-' + index + ' a'] == undefined) {
              blockCssY.items[itemSelector + '.item-' + index + ' a'] = {};
              blockCssY.items[itemSelector + '.item-' + index + ' a'][attrIdX] = attrVal;
            } else {
              blockCssY.items[itemSelector + '.item-' + index + ' a'][attrIdX] = attrVal;
            }

            if (blockCssY.items[itemSelector + '.item-' + index] == undefined) {
              blockCssY.items[itemSelector + '.item-' + index] = {};
              blockCssY.items[itemSelector + '.item-' + index][attrIdX] = attrVal;
            } else {
              blockCssY.items[itemSelector + '.item-' + index][attrIdX] = attrVal;
            }

            setAttributes({
              blockCssY: {
                items: blockCssY.items
              }
            });
          }
        });
      });
      setTimeout(x => {//setAttributes({ blockCssY: { items: newValuesObjX } });
      }, 2000);
    }, [elements]);
    var linkElementsArgsBasic = [{
      id: 'text',
      label: 'Text',
      customText: 'You are here: ',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        text: 'You are here: ',
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'homePage',
      label: 'Home Page Link',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'frontPage',
      label: 'Front Page Link',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postsPage',
      label: 'Posts Page Link',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postTitle',
      label: 'Post Title',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postAuthor',
      label: 'Post Author',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postDate',
      label: 'Post Date',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        format: 'Y-m-d',
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postDay',
      label: 'Post Day',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        format: '',
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postMonth',
      label: 'Post Month',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        format: '',
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postYear',
      label: 'Post Year',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        format: '',
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postAncestors',
      isPro: true,
      label: 'Post Ancestors',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true,
        count: ''
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postId',
      label: 'Post Id',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postCategory',
      label: 'Post Category',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postTag',
      label: 'Post Tag',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postCategories',
      isPro: true,
      label: 'Post Categories',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true,
        maxCount: 3
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postTags',
      isPro: true,
      label: 'Post Tags',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true,
        maxCount: 3
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postTerm',
      isPro: true,
      label: 'Post Term',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        taxonomy: '',
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postTerms',
      isPro: true,
      label: 'Post Terms',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        taxonomy: '',
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'termTitle',
      label: 'Term Title',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'termParents',
      isPro: true,
      label: 'Term Parents',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true,
        count: 0
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'termAncestors',
      isPro: true,
      label: 'Term Ancestors',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        taxonomy: '',
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'wcShop',
      label: 'WooCommerce Shop',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'wcAccount',
      label: 'WooCommerce Account',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'wcCart',
      label: 'WooCommerce Cart',
      isPro: true,
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'wcCheckout',
      label: 'WooCommerce Checkout',
      isPro: true,
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'searchText',
      label: 'Search Text',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'archiveTitle',
      label: 'Archive Title',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: '404Text',
      label: '404 Text',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'dateText',
      label: 'Date Text',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true,
        format: 'Y-m-d'
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'monthText',
      label: 'Month Text',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true,
        format: 'Y-m'
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'yearText',
      label: 'Year Text',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true,
        format: 'Y'
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'authorName',
      label: 'Author Name',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }];
    let linkElementsArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__.applyFilters)('linkElementsArgs', linkElementsArgsBasic);
    let isProFeature = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__.applyFilters)('isProFeature', true);

    function addMedia(option, index) {
      //var isExist = elements.items.find(x => x.label === option.label);
      //if (isExist == undefined) {
      //}
      var elementsX = elements.items.push(option);
      setAttributes({
        elements: { ...elements,
          items: elements.items
        }
      });
    }

    var breakPointList = [{
      label: 'Select..',
      icon: '',
      value: ''
    }];

    for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_10__["default"]) {
      var item = _breakpoints__WEBPACK_IMPORTED_MODULE_10__["default"][x];
      breakPointList.push({
        label: item.name,
        icon: item.icon,
        value: item.id
      });
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ wrapper: { ...wrapper } });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      // if (blockCssY.items[wrapperSelector] == undefined) {
      //   blockCssY.items[wrapperSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[wrapperSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[wrapperSelector][key] != undefined) {
      //   delete blockCssY.items[wrapperSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStyleElements(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, elements);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        elements: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...elements[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ elements: { ...elements } });
    }

    function onRemoveStyleElements(sudoScource, key) {
      var object = myStore.deletePropertyDeep(elements, [sudoScource, key, breakPointX]);
      setAttributes({
        elements: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...elements[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // elements[sudoScource] = sudoScourceX;
      // setAttributes({ elements: { ...elements } });
      // if (blockCssY.items[itemSelector] == undefined) {
      //   blockCssY.items[itemSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[itemSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[itemSelector][key] != undefined) {
      //   delete blockCssY.items[itemSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleElements(sudoScource, key) {
      // var sudoScourceX = { ...elements[sudoScource] }
      // sudoScourceX[key] = {};
      // elements[sudoScource] = sudoScourceX;
      // setAttributes({ elements: { ...elements } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, elements);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        elements: object
      });
    }

    function onChangeStyleIcon(sudoScource, newVal, attr) {
      // var sudoScourceX = { ...icon[sudoScource] }
      // var elementSelector = iconSelector;
      // var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ icon: { ...icon } });
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(icon, [sudoScource, key, breakPointX]);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...icon[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // icon[sudoScource] = sudoScourceX;
      // setAttributes({ icon: { ...icon } });
      // if (blockCssY.items[iconSelector] == undefined) {
      //   blockCssY.items[iconSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[iconSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[iconSelector][key] != undefined) {
      //   delete blockCssY.items[iconSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleIcon(sudoScource, key) {
      // var sudoScourceX = { ...icon[sudoScource] }
      // sudoScourceX[key] = {};
      // icon[sudoScource] = sudoScourceX;
      // setAttributes({ icon: { ...icon } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        icon: object
      });
    }

    function onChangeStyleLabel(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, label);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        label: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...label[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, labelSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ label: { ...label } });
    }

    function onRemoveStyleLabel(sudoScource, key) {
      var object = myStore.deletePropertyDeep(label, [sudoScource, key, breakPointX]);
      setAttributes({
        label: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...label[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // label[sudoScource] = sudoScourceX;
      // //sudoScourceX[attr][breakPointX] = newVal;
      // setAttributes({ label: { ...label } });
      // if (blockCssY.items[labelSelector] == undefined) {
      //   blockCssY.items[labelSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[labelSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[labelSelector][key] != undefined) {
      //   delete blockCssY.items[labelSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleLabel(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, label);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        label: object
      });
    }

    function onChangeStyleSeparator(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, separator);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        separator: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, separatorSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...separator[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, separatorSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ separator: { ...separator } });
    }

    function onRemoveStyleSeparator(sudoScource, key) {
      var object = myStore.deletePropertyDeep(separator, [sudoScource, key, breakPointX]);
      setAttributes({
        separator: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, separatorSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...separator[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // separator[sudoScource] = sudoScourceX;
      // //sudoScourceX[attr][breakPointX] = newVal;
      // setAttributes({ separator: { ...separator } });
      // if (blockCssY.items[separatorSelector] == undefined) {
      //   blockCssY.items[separatorSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[separatorSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[separatorSelector][key] != undefined) {
      //   delete blockCssY.items[separatorSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleSeparator(sudoScource, key) {
      // var sudoScourceX = { ...separator[sudoScource] }
      // sudoScourceX[key] = {};
      // separator[sudoScource] = sudoScourceX;
      // setAttributes({ separator: { ...separator } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, separator);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        separator: object
      });
    }

    function paddingControlItems(nextValues) {
      var responsive = elements.styles.padding;
      responsive[breakPointX] = nextValues;
      var styles = { ...elements.styles,
        padding: responsive
      };
      setAttributes({
        elements: { ...elements,
          styles: styles
        }
      });
      blockCssY.items[itemSelector] = blockCssY.items[itemSelector] != undefined ? blockCssY.items[itemSelector] : {};

      if (nextValues.top != undefined) {
        var paddingTop = blockCssY.items[itemSelector]['padding-top'] != undefined ? blockCssY.items[itemSelector]['padding-top'] : {};
        paddingTop[breakPointX] = nextValues.top;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'padding-top': paddingTop
        };
      }

      if (nextValues.right != undefined) {
        var paddingRight = blockCssY.items[itemSelector]['padding-right'] != undefined ? blockCssY.items[itemSelector]['padding-right'] : {};
        paddingRight[breakPointX] = nextValues.right;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'padding-right': paddingRight
        };
      }

      if (nextValues.bottom != undefined) {
        var paddingBottom = blockCssY.items[itemSelector]['padding-bottom'] != undefined ? blockCssY.items[itemSelector]['padding-bottom'] : {};
        paddingBottom[breakPointX] = nextValues.bottom;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'padding-bottom': paddingBottom
        };
      }

      if (nextValues.left != undefined) {
        var paddingLeft = blockCssY.items[itemSelector]['padding-left'] != undefined ? blockCssY.items[itemSelector]['padding-left'] : {};
        paddingLeft[breakPointX] = nextValues.left;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'padding-left': paddingLeft
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function marginControlItems(nextValues) {
      var responsive = elements.styles.margin;
      responsive[breakPointX] = nextValues;
      var styles = { ...elements.styles,
        margin: responsive
      };
      setAttributes({
        elements: { ...elements,
          styles: styles
        }
      });
      blockCssY.items[itemSelector] = blockCssY.items[itemSelector] != undefined ? blockCssY.items[itemSelector] : {};

      if (nextValues.top != undefined) {
        var marginTop = blockCssY.items[itemSelector]['margin-top'] != undefined ? blockCssY.items[itemSelector]['margin-top'] : {};
        marginTop[breakPointX] = nextValues.top;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'margin-top': marginTop
        };
      }

      if (nextValues.right != undefined) {
        var marginRight = blockCssY.items[itemSelector]['margin-right'] !== undefined ? blockCssY.items[itemSelector]['margin-right'] : {};
        marginRight[breakPointX] = nextValues.right;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'margin-right': marginRight
        };
      }

      if (nextValues.bottom != undefined) {
        var marginBottom = blockCssY.items[itemSelector]['margin-bottom'] !== undefined ? blockCssY.items[itemSelector]['margin-bottom'] : {};
        marginBottom[breakPointX] = nextValues.bottom;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'margin-bottom': marginBottom
        };
      }

      if (nextValues.left != undefined) {
        var marginLeft = blockCssY.items[itemSelector]['margin-left'] !== undefined ? blockCssY.items[itemSelector]['margin-left'] : {};
        marginLeft[breakPointX] = nextValues.left;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'margin-left': marginLeft
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function onChangeTypo(typoX) {
      setAttributes({
        elements: { ...elements,
          styles: typoX
        }
      });
      console.log(typoX);

      if (typoX.fontSize[breakPointX] != undefined) {
        var fontSizeVal = typoX.fontSize[breakPointX].val ? typoX.fontSize[breakPointX].val : 16;
        var fontSizeUnit = typoX.fontSize[breakPointX].unit ? typoX.fontSize[breakPointX].unit : 'px';
        var fontSizeX = blockCssY.items[itemSelector] != undefined ? blockCssY.items[itemSelector]['font-size'] : {};
        fontSizeX[breakPointX] = fontSizeVal + fontSizeUnit;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'font-size': fontSizeX
        };
      }

      if (typoX.lineHeight[breakPointX] != undefined) {
        var lineHeightVal = typoX.lineHeight[breakPointX].val ? typoX.lineHeight[breakPointX].val : 0;
        var lineHeightUnit = typoX.lineHeight[breakPointX].unit ? typoX.lineHeight[breakPointX].unit : 'px';
        var lineHeightX = blockCssY.items[itemSelector]['line-height'] != undefined ? blockCssY.items[itemSelector]['line-height'] : {};
        lineHeightX[breakPointX] = lineHeightVal + lineHeightUnit;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'line-height': lineHeightX
        };
      }

      if (typoX.letterSpacing[breakPointX] != undefined) {
        var letterSpacingVal = typoX.letterSpacing[breakPointX].val ? typoX.letterSpacing[breakPointX].val : 0;
        var letterSpacingUnit = typoX.letterSpacing[breakPointX].unit ? typoX.letterSpacing[breakPointX].unit : 'px';
        var letterSpacingX = blockCssY.items[itemSelector]['letter-spacing'] != undefined ? blockCssY.items[itemSelector]['letter-spacing'] : {};
        letterSpacingX[breakPointX] = letterSpacingVal + letterSpacingUnit;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'letter-spacing': letterSpacingX
        };
      }

      if (typoX.fontWeight[breakPointX] != undefined) {
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'font-weight': typoX.fontWeight
        };
      }

      if (typoX.textDecoration[breakPointX] != undefined) {
        var str = {};
        var textDecorationX = typoX.textDecoration[breakPointX];
        var textDecorationXStr = textDecorationX.length > 0 ? textDecorationX.join(' ') : '';
        str[breakPointX] = textDecorationXStr;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'text-decoration': str
        };
      }

      if (typoX.textTransform[breakPointX] != undefined) {
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'text-transform': typoX.textTransform
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function generateBlockCssY() {
      var reponsiveCssGroups = {};

      for (var selector in blockCssY.items) {
        var attrs = blockCssY.items[selector];

        for (var attr in attrs) {
          var breakpoints = attrs[attr];

          for (var device in breakpoints) {
            var attrValue = breakpoints[device];

            if (reponsiveCssGroups[device] == undefined) {
              reponsiveCssGroups[device] = [];
            }

            if (reponsiveCssGroups[device] == undefined) {
              reponsiveCssGroups[device] = [];
            }

            if (reponsiveCssGroups[device][selector] == undefined) {
              reponsiveCssGroups[device][selector] = [];
            }

            reponsiveCssGroups[device][selector].push({
              'attr': attr,
              'val': attrValue
            });
          }
        }
      } //return false;


      var reponsiveCssMobile = '';

      if (reponsiveCssGroups['Mobile'] != undefined) {
        reponsiveCssMobile += '@media only screen and (min-width: 0px) and (max-width: 360px){';

        for (var selector in reponsiveCssGroups['Mobile']) {
          var attrs = reponsiveCssGroups['Mobile'][selector];
          reponsiveCssMobile += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCssMobile += attrName + ':' + attrValue + ';';
          }

          reponsiveCssMobile += '}';
        }

        reponsiveCssMobile += '}';
      }

      var reponsiveCssTablet = '';

      if (reponsiveCssGroups['Tablet'] != undefined) {
        reponsiveCssTablet += '@media only screen and (min-width: 361px) and (max-width: 780px){';

        for (var selector in reponsiveCssGroups['Tablet']) {
          var attrs = reponsiveCssGroups['Tablet'][selector];
          reponsiveCssTablet += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCssTablet += attrName + ':' + attrValue + ';';
          }

          reponsiveCssTablet += '}';
        }

        reponsiveCssTablet += '}';
      }

      var reponsiveCssDesktop = '';

      if (reponsiveCssGroups['Desktop'] != undefined) {
        reponsiveCssDesktop += '@media only screen and (min-width: 781px){';

        for (var selector in reponsiveCssGroups['Desktop']) {
          var attrs = reponsiveCssGroups['Desktop'][selector];
          reponsiveCssDesktop += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCssDesktop += attrName + ':' + attrValue + ';';
          }

          reponsiveCssDesktop += '}';
        }

        reponsiveCssDesktop += '}';
      }

      var reponsiveCss = reponsiveCssMobile + reponsiveCssTablet + reponsiveCssDesktop;
      var iframe = document.querySelectorAll('[name="editor-canvas"]')[0];

      if (iframe) {
        setTimeout(() => {
          var iframeDocument = iframe.contentDocument;
          var body = iframeDocument.body;
          var divWrap = iframeDocument.getElementById("css-block-" + blockId);

          if (divWrap != undefined) {
            iframeDocument.getElementById("css-block-" + blockId).outerHTML = "";
          }

          var divWrap = '<div id="css-block-' + blockId + '"></div>';
          body.insertAdjacentHTML('beforeend', divWrap);
          var csswrappg = iframeDocument.getElementById('css-block-' + blockId);
          var str = '<style>' + reponsiveCss + customCss + '</style>';
          csswrappg.insertAdjacentHTML('beforeend', str);
        }, 200);
      } else {
        var wpfooter = document.getElementById('wpfooter');
        var divWrap = document.getElementById("css-block-" + blockId);

        if (divWrap != undefined) {
          document.getElementById("css-block-" + blockId).outerHTML = "";
        }

        var divWrap = '<div id="css-block-' + blockId + '"></div>';
        wpfooter.insertAdjacentHTML('beforeend', divWrap);
        var csswrappg = document.getElementById('css-block-' + blockId);
        var str = '<style>' + reponsiveCss + customCss + '</style>';
        csswrappg.insertAdjacentHTML('beforeend', str);
      }
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      //generateBlockCssY()
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    const colors = [{
      name: '9DD6DF',
      color: '#9DD6DF'
    }, {
      name: '18978F',
      color: '#18978F'
    }, {
      name: 'A084CF',
      color: '#A084CF'
    }, {
      name: 'DFBB9D',
      color: '#DFBB9D'
    }, {
      name: '774360',
      color: '#774360'
    }, {
      name: '3AB0FF',
      color: '#3AB0FF'
    }, {
      name: '51557E',
      color: '#51557E'
    }];
    const {
      __experimentalSetPreviewDeviceType: setPreviewDeviceType
    } = wp.data.dispatch('core/edit-post');

    function onChangeBreakPoint(x, index) {
      setPreviewDeviceType(x.value);
      var asdsdsd = wp.data.dispatch('postgrid-shop').setBreakPoint(x.value);
      asdsdsd.then(res => {
        setBreakPointX(res.breakpoint); //generateBlockCssY();

        myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      });
    }

    return [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.BlockControls, null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InspectorControls, {
      key: "general"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-3",
      title: "General",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'No Wrapper',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'span',
        value: 'SPAN'
      }, {
        label: 'div',
        value: 'DIV'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: { ...wrapper,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Items",
      initialOpen: true
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Add Element"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_15__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: linkElementsArgs,
      buttonTitle: "Choose",
      onChange: addMedia,
      values: ""
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(react_sortablejs__WEBPACK_IMPORTED_MODULE_3__.ReactSortable, {
      list: elements.items,
      handle: '.handle',
      setList: item => {
        setAttributes({
          elements: { ...elements,
            items: item
          }
        });
      }
    }, elements.items.map((item, index) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      key: item.id,
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "cursor-pointer hover:bg-red-500 hover:text-white px-1 py-1",
        onClick: ev => {
          var elementsX = elements.items.splice(index, 1);
          setAttributes({
            elements: { ...elements,
              items: elements.items
            }
          });
        }
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"], {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"]
      })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "handle cursor-pointer hover:bg-blue-500 hover:text-white px-1 py-1"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"], {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"]
      })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "mx-2"
      }, item.label)),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Custom Label"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: item.customText,
      placeholder: "You Text: %s",
      onChange: newVal => {
        elements.items[index].customText = newVal;
        setAttributes({
          elements: { ...elements,
            items: elements.items
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Please use ", (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, "%s"), " for output")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Custom URL"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: item.url,
      onChange: newVal => {
        elements.items[index].url = newVal;
        setAttributes({
          elements: { ...elements,
            items: elements.items
          }
        });
      }
    })), (item.id == 'postTerms' || item.id == 'postTerm') && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Taxonomy"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: item.options.taxonomy,
      onChange: newVal => {
        elements.items[index].options.taxonomy = newVal;
        setAttributes({
          elements: { ...elements,
            items: elements.items
          }
        });
      }
    })), (item.id == 'termParents' || item.id == 'postAncestors') && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Max Count"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: item.options.count,
      onChange: newVal => {
        elements.items[index].options.count = newVal;
        setAttributes({
          elements: { ...elements,
            items: elements.items
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Use ", (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, "-"), " (negetive sign) to count from end."))), (item.id == 'dateText' || item.id == 'monthText' || item.id == 'yearText' || item.id == 'postDate' || item.id == 'postDay' || item.id == 'postMonth' || item.id == 'postYear') && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Date Format"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: item.options.format,
      onChange: newVal => {
        elements.items[index].options.format = newVal;
        setAttributes({
          elements: { ...elements,
            items: elements.items
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_20__["default"], {
      library: item.siteIcon.library,
      srcType: item.siteIcon.srcType,
      iconSrc: item.siteIcon.iconSrc,
      onChange: arg => {
        //var options = { ...icon.options, srcType: arg.srcType, library: arg.library, iconSrc: arg.iconSrc };
        //setAttributes({ icon: { ...icon, options: options } });
        elements.items[index].siteIcon = {
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          elements: { ...elements,
            items: elements.items
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", null, "Color"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_toggle__WEBPACK_IMPORTED_MODULE_12__["default"], {
      position: "bottom",
      variant: "secondary",
      iconList: breakPointList,
      buttonTitle: "Break Point Switch",
      onChange: onChangeBreakPoint,
      activeIcon: _breakpoints__WEBPACK_IMPORTED_MODULE_10__["default"][breakPointX].icon,
      value: breakPointX
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ColorPalette, {
      value: elements.items[index].styles.color[breakPointX],
      colors: _colors_presets__WEBPACK_IMPORTED_MODULE_14__["default"],
      enableAlpha: true,
      onChange: newVal => {
        var newValuesObj = {};

        if (Object.keys(elements.items[index].styles.color).length == 0) {
          newValuesObj[breakPointX] = newVal;
        } else {
          newValuesObj = elements.items[index].styles.color;
          newValuesObj[breakPointX] = newVal;
        }

        var styles = { ...elements.items[index].styles,
          color: newValuesObj
        };
        elements.items[index].styles = styles;
        setAttributes({
          elements: { ...elements,
            items: elements.items
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", null, "Background Color"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_toggle__WEBPACK_IMPORTED_MODULE_12__["default"], {
      position: "bottom",
      variant: "secondary",
      iconList: breakPointList,
      buttonTitle: "Break Point Switch",
      onChange: onChangeBreakPoint,
      activeIcon: _breakpoints__WEBPACK_IMPORTED_MODULE_10__["default"][breakPointX].icon,
      value: breakPointX
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ColorPalette, {
      value: elements.items[index].styles.backgroundColor[breakPointX],
      colors: _colors_presets__WEBPACK_IMPORTED_MODULE_14__["default"],
      enableAlpha: true,
      onChange: newVal => {
        var newValuesObj = {};

        if (Object.keys(elements.items[index].styles.backgroundColor).length == 0) {
          newValuesObj[breakPointX] = newVal;
        } else {
          newValuesObj = elements.items[index].styles.backgroundColor;
          newValuesObj[breakPointX] = newVal;
        }

        var styles = { ...elements.items[index].styles,
          backgroundColor: newValuesObj
        };
        elements.items[index].styles = styles;
        setAttributes({
          elements: { ...elements,
            items: elements.items
          }
        }); // var newValuesObjX = {};
        // if (blockCssY.items[itemSelector] == undefined) {
        //   newValuesObjX[itemSelector] = { ...blockCssY.items[itemSelector], 'background-color': newValuesObj };
        // } else {
        //   newValuesObjX[itemSelector] = { ...blockCssY.items[itemSelector], 'background-color': newValuesObj };
        // }
        //setAttributes({ blockCssY: { items: newValuesObjX } });
      }
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      className: "my-3",
      label: "Display Label?",
      help: elements.options.showLabel ? 'Label is displaying' : 'Label is hidden',
      checked: elements.options.showLabel ? true : false,
      onChange: e => {
        var options = { ...elements.options,
          showLabel: elements.options.showLabel ? false : true
        };
        setAttributes({
          elements: { ...elements,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      className: "my-3",
      disabled: isProFeature,
      label: "Display Icon?",
      help: elements.options.showIcon ? 'Icon is displaying' : 'Icon is hidden',
      checked: elements.options.showIcon ? true : false,
      onChange: e => {
        var options = { ...elements.options,
          showIcon: elements.options.showIcon ? false : true
        };
        setAttributes({
          elements: { ...elements,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, isProFeature && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "bg-amber-400 rounded-sm py-1 px-3  text-white hover:text-white"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      target: "_blank",
      href: 'https://pickplugins.com/post-grid/?utm_source=dropdownComponent&utm_term=proFeature&utm_campaign=pluginPostGrid&utm_medium=' + x.label
    }, "Pro")))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      className: "my-3",
      label: "Display Separator?",
      help: elements.options.showSeparator ? 'Separator is displaying' : 'Separator is hidden',
      checked: elements.options.showSeparator ? true : false,
      onChange: e => {
        var options = { ...elements.options,
          showSeparator: elements.options.showSeparator ? false : true
        };
        setAttributes({
          elements: { ...elements,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: elements,
      onChange: onChangeStyleElements,
      onAdd: onAddStyleElements,
      onRemove: onRemoveStyleElements
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Icon position"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: 'Choose Position',
        value: ''
      }, {
        label: 'Before Label',
        value: 'beforeLabel'
      }, {
        label: 'After Label',
        value: 'afterLabel'
      }, {
        label: 'Before Separator',
        value: 'beforeSeparator'
      }, {
        label: 'After Separator',
        value: 'afterSeparator'
      }],
      onChange: newVal => {
        var options = { ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Label",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: label,
      onChange: onChangeStyleLabel,
      onAdd: onAddStyleLabel,
      onRemove: onRemoveStyleLabel
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Separator",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Separator Text"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: separator.options.text,
      onChange: newVal => {
        var options = { ...separator.options,
          text: newVal
        };
        setAttributes({
          separator: { ...separator,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: separator,
      onChange: onChangeStyleSeparator,
      onAdd: onAddStyleSeparator,
      onRemove: onRemoveStyleSeparator
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Wrapper Selector"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, wrapperSelector, '{/* your CSS here*/}'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Item Selector"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, itemSelector, '{}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_17__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_18__["default"], {
      utm: {
        utm_source: 'BlockPostExcerpt',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: blockId
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("ol", null, elements.items.map((x, index) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
        className: 'item item-' + index
      }, x.url.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        href: x.url
      }, elements.options.showIcon && icon.options.position == 'beforeLabel' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      }), elements.options.showLabel && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "label"
      }, x.customText.length > 0 ? x.customText : x.label), elements.options.showIcon && icon.options.position == 'afterLabel' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      })), x.url.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, elements.options.showIcon && icon.options.position == 'beforeLabel' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      }), elements.options.showLabel && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "label"
      }, x.customText.length > 0 ? x.customText : x.label), elements.options.showIcon && icon.options.position == 'afterLabel' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      })), elements.options.showSeparator && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, elements.options.showIcon && icon.options.position == 'beforeSeparator' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      }), elements.items.length > index && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        class: "separator"
      }, separator.options.text), elements.options.showIcon && icon.options.position == 'afterSeparator' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      })));
    })))];
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/divider/index.js":
/*!*************************************!*\
  !*** ./src/blocks/divider/index.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_css_display__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/css-display */ "./src/components/css-display/index.js");
/* harmony import */ var re_resizable__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! re-resizable */ "./node_modules/re-resizable/lib/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");












const {
  RawHTML
} = wp.element;















var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__.registerBlockType)("post-grid/divider", {
  title: "Divider",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#2563eb',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("svg", {
      width: "500",
      height: "500",
      viewBox: "0 0 500 500",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("path", {
      d: "M25 95C25 92.2386 27.2386 90 30 90H470C472.761 90 475 92.2386 475 95V145C475 147.761 472.761 150 470 150H30C27.2386 150 25 147.761 25 145V95Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("path", {
      d: "M25 234C25 231.239 27.2386 229 30 229H470C472.761 229 475 231.239 475 234V254C475 256.761 472.761 259 470 259H30C27.2386 259 25 256.761 25 254V234Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("path", {
      d: "M25 298C25 295.239 27.2386 293 30 293H470C472.761 293 475 295.239 475 298V318C475 320.761 472.761 323 470 323H30C27.2386 323 25 320.761 25 318V298Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("path", {
      d: "M25 362C25 359.239 27.2386 357 30 357H366C368.761 357 371 359.239 371 362V382C371 384.761 368.761 387 366 387H30C27.2386 387 25 384.761 25 382V362Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          display: {}
        }
      }
    },
    divider: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          customUrl: '',
          class: ''
        },
        styles: {
          display: {},
          width: {},
          height: {},
          color: {
            Desktop: ''
          },
          padding: {
            "Desktop": {
              top: '0px',
              right: '0px',
              bottom: '0px',
              left: '0px'
            }
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    let divider = attributes.divider;
    var wrapper = attributes.wrapper;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType'];
    const [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(myStore.getBreakPoint());
    const [paddingTop, setPaddingTop] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(parseInt(divider.styles.padding[breakPointX].top));
    const [paddingBottom, setPaddingBottom] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(parseInt(divider.styles.padding[breakPointX].bottom));
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {//console.log(divider);
    }, [divider]);

    String.prototype.strtr = function (dic) {
      const str = this.toString(),
            makeToken = inx => `{{###~${inx}~###}}`,
            tokens = Object.keys(dic).map((key, inx) => ({
        key,
        val: dic[key],
        token: makeToken(inx)
      })),
            tokenizedStr = tokens.reduce((carry, entry) => carry.replace(new RegExp(entry.key, "g"), entry.token), str);

      return tokens.reduce((carry, entry) => carry.replace(new RegExp(entry.token, "g"), entry.val), tokenizedStr);
    };

    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)('');
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      blockCssY.items[dividerSelector] = { ...blockCssY.items[dividerSelector],
        'background-color': {
          "Desktop": "#dddddd"
        }
      };
    }, [clientId]); // Wrapper CSS Class Selectors

    const wrapperSelector = blockClass;
    var dividerSelector = '';

    if (wrapper.options.tag.length != 0) {
      dividerSelector = blockClass;
    } else {
      dividerSelector = blockClass;
    }

    var breakPointList = [{
      label: 'Select..',
      icon: '',
      value: ''
    }];

    for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"]) {
      var item = _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"][x];
      breakPointList.push({
        label: item.name,
        icon: item.icon,
        value: item.id
      });
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ wrapper: { ...wrapper } });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      // if (blockCssY.items[wrapperSelector] == undefined) {
      //   blockCssY.items[wrapperSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[wrapperSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[wrapperSelector][key] != undefined) {
      //   delete blockCssY.items[wrapperSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // sudoScourceX[key] = {};
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function paddingControl(nextValues) {
      var responsive = divider.styles.padding;
      responsive[breakPointX] = nextValues;
      var styles = { ...divider.styles,
        padding: responsive
      };
      setAttributes({
        divider: { ...divider,
          styles: styles
        }
      });
      blockCssY.items[dividerSelector] = blockCssY.items[dividerSelector] != undefined ? blockCssY.items[dividerSelector] : {};
      nextValues.top = nextValues.top == undefined ? '0px' : nextValues.top;
      nextValues.right = nextValues.right == undefined ? '0px' : nextValues.right;
      nextValues.bottom = nextValues.bottom == undefined ? '0px' : nextValues.bottom;
      nextValues.left = nextValues.left == undefined ? '0px' : nextValues.left;

      if (nextValues.top != undefined) {
        var paddingTop = blockCssY.items[dividerSelector]['padding-top'] != undefined ? blockCssY.items[dividerSelector]['padding-top'] : {};
        paddingTop[breakPointX] = nextValues.top;
        blockCssY.items[dividerSelector] = { ...blockCssY.items[dividerSelector],
          'padding-top': paddingTop
        };
      }

      if (nextValues.right != undefined) {
        var paddingRight = blockCssY.items[dividerSelector]['padding-right'] != undefined ? blockCssY.items[dividerSelector]['padding-right'] : {};
        paddingRight[breakPointX] = nextValues.right;
        blockCssY.items[dividerSelector] = { ...blockCssY.items[dividerSelector],
          'padding-right': paddingRight
        };
      }

      if (nextValues.bottom != undefined) {
        var paddingBottom = blockCssY.items[dividerSelector]['padding-bottom'] != undefined ? blockCssY.items[dividerSelector]['padding-bottom'] : {};
        paddingBottom[breakPointX] = nextValues.bottom;
        blockCssY.items[dividerSelector] = { ...blockCssY.items[dividerSelector],
          'padding-bottom': paddingBottom
        };
      }

      if (nextValues.left != undefined) {
        var paddingLeft = blockCssY.items[dividerSelector]['padding-left'] != undefined ? blockCssY.items[dividerSelector]['padding-left'] : {};
        paddingLeft[breakPointX] = nextValues.left;
        blockCssY.items[dividerSelector] = { ...blockCssY.items[dividerSelector],
          'padding-left': paddingLeft
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function marginControl(nextValues) {
      var responsive = divider.styles.margin;
      responsive[breakPointX] = nextValues;
      var styles = { ...divider.styles,
        margin: responsive
      };
      setAttributes({
        divider: { ...divider,
          styles: styles
        }
      });
      nextValues.top = nextValues.top == undefined ? '0px' : nextValues.top;
      nextValues.right = nextValues.right == undefined ? '0px' : nextValues.right;
      nextValues.bottom = nextValues.bottom == undefined ? '0px' : nextValues.bottom;
      nextValues.left = nextValues.left == undefined ? '0px' : nextValues.left;
      blockCssY.items[dividerSelector] = blockCssY.items[dividerSelector] != undefined ? blockCssY.items[dividerSelector] : {};

      if (nextValues.top != undefined) {
        var marginTop = blockCssY.items[dividerSelector]['margin-top'] != undefined ? blockCssY.items[dividerSelector]['margin-top'] : {};
        marginTop[breakPointX] = nextValues.top;
        blockCssY.items[dividerSelector] = { ...blockCssY.items[dividerSelector],
          'margin-top': marginTop
        };
      }

      if (nextValues.right != undefined) {
        var marginRight = blockCssY.items[dividerSelector]['margin-right'] !== undefined ? blockCssY.items[dividerSelector]['margin-right'] : {};
        marginRight[breakPointX] = nextValues.right;
        blockCssY.items[dividerSelector] = { ...blockCssY.items[dividerSelector],
          'margin-right': marginRight
        };
      }

      if (nextValues.bottom != undefined) {
        var marginBottom = blockCssY.items[dividerSelector]['margin-bottom'] !== undefined ? blockCssY.items[dividerSelector]['margin-bottom'] : {};
        marginBottom[breakPointX] = nextValues.bottom;
        blockCssY.items[dividerSelector] = { ...blockCssY.items[dividerSelector],
          'margin-bottom': marginBottom
        };
      }

      if (nextValues.left != undefined) {
        var marginLeft = blockCssY.items[dividerSelector]['margin-left'] !== undefined ? blockCssY.items[dividerSelector]['margin-left'] : {};
        marginLeft[breakPointX] = nextValues.left;
        blockCssY.items[dividerSelector] = { ...blockCssY.items[dividerSelector],
          'margin-left': marginLeft
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function generateBlockCssY() {
      var reponsiveCssGroups = {};

      for (var selector in blockCssY.items) {
        var attrs = blockCssY.items[selector];

        for (var attr in attrs) {
          var breakpoints = attrs[attr];

          for (var device in breakpoints) {
            var attrValue = breakpoints[device];

            if (reponsiveCssGroups[device] == undefined) {
              reponsiveCssGroups[device] = [];
            }

            if (reponsiveCssGroups[device] == undefined) {
              reponsiveCssGroups[device] = [];
            }

            if (reponsiveCssGroups[device][selector] == undefined) {
              reponsiveCssGroups[device][selector] = [];
            }

            reponsiveCssGroups[device][selector].push({
              'attr': attr,
              'val': attrValue
            });
          }
        }
      } //return false;


      var reponsiveCssMobile = '';

      if (reponsiveCssGroups['Mobile'] != undefined) {
        reponsiveCssMobile += '@media only screen and (min-width: 0px) and (max-width: 360px){';

        for (var selector in reponsiveCssGroups['Mobile']) {
          var attrs = reponsiveCssGroups['Mobile'][selector];
          reponsiveCssMobile += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCssMobile += attrName + ':' + attrValue + ';';
          }

          reponsiveCssMobile += '}';
        }

        reponsiveCssMobile += '}';
      }

      var reponsiveCssTablet = '';

      if (reponsiveCssGroups['Tablet'] != undefined) {
        reponsiveCssTablet += '@media only screen and (min-width: 361px) and (max-width: 780px){';

        for (var selector in reponsiveCssGroups['Tablet']) {
          var attrs = reponsiveCssGroups['Tablet'][selector];
          reponsiveCssTablet += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCssTablet += attrName + ':' + attrValue + ';';
          }

          reponsiveCssTablet += '}';
        }

        reponsiveCssTablet += '}';
      }

      var reponsiveCssDesktop = '';

      if (reponsiveCssGroups['Desktop'] != undefined) {
        reponsiveCssDesktop += '@media only screen and (min-width: 781px){';

        for (var selector in reponsiveCssGroups['Desktop']) {
          var attrs = reponsiveCssGroups['Desktop'][selector];
          reponsiveCssDesktop += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCssDesktop += attrName + ':' + attrValue + ';';
          }

          reponsiveCssDesktop += '}';
        }

        reponsiveCssDesktop += '}';
      }

      var reponsiveCss = reponsiveCssMobile + reponsiveCssTablet + reponsiveCssDesktop;
      var iframe = document.querySelectorAll('[name="editor-canvas"]')[0];

      if (iframe) {
        setTimeout(() => {
          var iframeDocument = iframe.contentDocument;
          var body = iframeDocument.body;
          var divWrap = iframeDocument.getElementById("css-block-" + blockId);

          if (divWrap != undefined) {
            iframeDocument.getElementById("css-block-" + blockId).outerHTML = "";
          }

          var divWrap = '<div id="css-block-' + blockId + '"></div>';
          body.insertAdjacentHTML('beforeend', divWrap);
          var csswrappg = iframeDocument.getElementById('css-block-' + blockId);
          var str = '<style>' + reponsiveCss + customCss + '</style>';
          csswrappg.insertAdjacentHTML('beforeend', str);
        }, 200);
      } else {
        var wpfooter = document.getElementById('wpfooter');
        var divWrap = document.getElementById("css-block-" + blockId);

        if (divWrap != undefined) {
          document.getElementById("css-block-" + blockId).outerHTML = "";
        }

        var divWrap = '<div id="css-block-' + blockId + '"></div>';
        wpfooter.insertAdjacentHTML('beforeend', divWrap);
        var csswrappg = document.getElementById('css-block-' + blockId);
        var str = '<style>' + reponsiveCss + customCss + '</style>';
        csswrappg.insertAdjacentHTML('beforeend', str);
      }
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
      //generateBlockCssY()
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      }); //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {}, [divider]);
    const colors = [{
      name: '9DD6DF',
      color: '#9DD6DF'
    }, {
      name: '18978F',
      color: '#18978F'
    }, {
      name: 'A084CF',
      color: '#A084CF'
    }, {
      name: 'DFBB9D',
      color: '#DFBB9D'
    }, {
      name: '774360',
      color: '#774360'
    }, {
      name: '3AB0FF',
      color: '#3AB0FF'
    }, {
      name: '51557E',
      color: '#51557E'
    }];
    const [setSome, setSomeState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)({});
    const [stateX, setStateX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)('Old Value');
    const {
      __experimentalSetPreviewDeviceType: setPreviewDeviceType
    } = wp.data.dispatch('core/edit-post');
    const CustomTag = `${wrapper.options.tag}`;
    const CustomTagPostTitle = `${divider.options.tag}`;

    function onChangeTypo(typoX) {
      setAttributes({
        divider: { ...divider,
          styles: typoX
        }
      });
      var newValuesObjX = {};

      if (typoX.fontFamily[breakPointX] != undefined) {
        blockCssY.items[dividerSelector] = { ...blockCssY.items[dividerSelector],
          'font-family': typoX.fontFamily
        };
      }

      if (typoX.fontSize[breakPointX] != undefined) {
        var fontSizeVal = typoX.fontSize[breakPointX].val ? typoX.fontSize[breakPointX].val : 16;
        var fontSizeUnit = typoX.fontSize[breakPointX].unit ? typoX.fontSize[breakPointX].unit : 'px';
        var fontSizeX = blockCssY.items[dividerSelector] != undefined ? blockCssY.items[dividerSelector]['font-size'] : {};
        fontSizeX[breakPointX] = fontSizeVal + fontSizeUnit;
        blockCssY.items[dividerSelector] = { ...blockCssY.items[dividerSelector],
          'font-size': fontSizeX
        };
      }

      if (typoX.lineHeight[breakPointX] != undefined) {
        var lineHeightVal = typoX.lineHeight[breakPointX].val ? typoX.lineHeight[breakPointX].val : 0;
        var lineHeightUnit = typoX.lineHeight[breakPointX].unit ? typoX.lineHeight[breakPointX].unit : 'px';
        var lineHeightX = blockCssY.items[dividerSelector]['line-height'] != undefined ? blockCssY.items[dividerSelector]['line-height'] : {};
        lineHeightX[breakPointX] = lineHeightVal + lineHeightUnit;
        blockCssY.items[dividerSelector] = { ...blockCssY.items[dividerSelector],
          'line-height': lineHeightX
        };
      }

      if (typoX.letterSpacing[breakPointX] != undefined) {
        var letterSpacingVal = typoX.letterSpacing[breakPointX].val ? typoX.letterSpacing[breakPointX].val : 0;
        var letterSpacingUnit = typoX.letterSpacing[breakPointX].unit ? typoX.letterSpacing[breakPointX].unit : 'px';
        var letterSpacingX = blockCssY.items[dividerSelector]['letter-spacing'] != undefined ? blockCssY.items[dividerSelector]['letter-spacing'] : {};
        letterSpacingX[breakPointX] = letterSpacingVal + letterSpacingUnit;
        blockCssY.items[dividerSelector] = { ...blockCssY.items[dividerSelector],
          'letter-spacing': letterSpacingX
        };
      }

      if (typoX.fontWeight[breakPointX] != undefined) {
        blockCssY.items[dividerSelector] = { ...blockCssY.items[dividerSelector],
          'font-weight': typoX.fontWeight
        };
      }

      if (typoX.textDecoration[breakPointX] != undefined) {
        var str = {};
        var textDecorationX = typoX.textDecoration[breakPointX];
        var textDecorationXStr = textDecorationX.length > 0 ? textDecorationX.join(' ') : '';
        str[breakPointX] = textDecorationXStr; //typoX.textDecoration[breakPointX] = typoX.textDecoration[breakPointX].join(' ');

        blockCssY.items[dividerSelector] = { ...blockCssY.items[dividerSelector],
          'text-decoration': str
        };
      }

      if (typoX.textTransform[breakPointX] != undefined) {
        blockCssY.items[dividerSelector] = { ...blockCssY.items[dividerSelector],
          'text-transform': typoX.textTransform
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function onChangeBreakPoint(x, index) {
      setPreviewDeviceType(x.value);
      var asdsdsd = wp.data.dispatch('postgrid-shop').setBreakPoint(x.value);
      asdsdsd.then(res => {
        setBreakPointX(res.breakpoint); //generateBlockCssY();

        myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      });
    }

    return [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.BlockControls, null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InspectorControls, {
      key: "general"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("div", {
      className: "px-3",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'No Wrapper',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'span',
        value: 'SPAN'
      }, {
        label: 'div',
        value: 'DIV'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_21__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
      title: "Divider",
      initialOpen: false
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("p", {
      className: "font-bold"
    }, "Title Wrapper"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("code", null, wrapperSelector, '{/* your CSS here*/}'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("p", {
      className: "font-bold"
    }, "Title link"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)("code", null, dividerSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_13__["default"], {
      utm: {
        utm_source: 'BlockPostTitle',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)(re_resizable__WEBPACK_IMPORTED_MODULE_18__.Resizable, {
      className: [blockId],
      style: {},
      onResizeStop: (e, direction, ref, d) => {
        console.log(direction);
        console.log(d);
        console.log(paddingTop);
        console.log(paddingBottom);

        if (direction == 'top') {
          setPaddingTop(paddingTop + d.height);
        }

        if (direction == 'bottom') {
          setPaddingBottom(paddingBottom + d.height);
        }
      }
    }, JSON.stringify(paddingTop), " - ", JSON.stringify(paddingBottom))];
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    var attributes = props.attributes;
    var wrapper = attributes.wrapper;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    const redBackground = {
      backgroundColor: '#ddd',
      position: 'relative'
    };
    const blockProps = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps.save({
      style: redBackground
    });
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InnerBlocks.Content, null);
  }
});

/***/ }),

/***/ "./src/blocks/icon/index.js":
/*!**********************************!*\
  !*** ./src/blocks/icon/index.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link-off.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_css_display__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/css-display */ "./src/components/css-display/index.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");














const {
  RawHTML
} = wp.element;














var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__.registerBlockType)("post-grid/icon", {
  title: "Icon/Button/Link",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#2563eb',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("svg", {
      width: "24",
      height: "24",
      viewBox: "0 0 24 24",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M10.4211 13.1053V21.5263H2V13.1053H10.4211ZM8.31579 15.2105H4.10526V19.4211H8.31579V15.2105ZM11.4737 1L17.2632 10.4737H5.68421L11.4737 1ZM11.4737 5.06316L9.45263 8.36842H13.4947L11.4737 5.06316ZM17.2632 12.5789C19.8947 12.5789 22 14.6842 22 17.3158C22 19.9474 19.8947 22.0526 17.2632 22.0526C14.6316 22.0526 12.5263 19.9474 12.5263 17.3158C12.5263 14.6842 14.6316 12.5789 17.2632 12.5789ZM17.2632 14.6842C16.5652 14.6842 15.8959 14.9615 15.4024 15.455C14.9088 15.9485 14.6316 16.6179 14.6316 17.3158C14.6316 18.0137 14.9088 18.6831 15.4024 19.1766C15.8959 19.6701 16.5652 19.9474 17.2632 19.9474C17.9611 19.9474 18.6304 19.6701 19.124 19.1766C19.6175 18.6831 19.8947 18.0137 19.8947 17.3158C19.8947 16.6179 19.6175 15.9485 19.124 15.455C18.6304 14.9615 17.9611 14.6842 17.2632 14.6842Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: '',
          attr: []
        },
        styles: {
          color: {
            Desktop: ''
          },
          borderRadius: {}
        }
      }
    },
    text: {
      type: 'object',
      default: {
        options: {
          text: 'Custom Text',
          isLink: true,
          linkTo: 'postUrl',

          /*postUrl, homeUrl, authorUrl, authorLink, mailTo, custom, customField */
          linkToAuthorMeta: '',
          linkToCustomMeta: '',
          linkTarget: '_blank',
          customUrl: '',
          linkAttr: [],
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          }
        }
      }
    },
    icon: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'fas fa-check-circle',
          position: 'beforeText',

          /*before, after, prefix, postfix */
          class: 'text-icon'
        },
        styles: {
          color: {
            Desktop: ''
          }
        }
      }
    },
    prefix: {
      type: 'object',
      default: {
        options: {
          text: '',
          class: 'prefix'
        },
        styles: {
          color: {
            Desktop: ''
          }
        }
      }
    },
    postfix: {
      type: 'object',
      default: {
        options: {
          text: '',
          class: 'postfix'
        },
        styles: {
          color: {
            Desktop: ''
          }
        }
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    linkAttr: {
      "type": "array",
      "default": []
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var wrapper = attributes.wrapper;
    var text = attributes.text;
    var icon = attributes.icon;
    var prefix = attributes.prefix;
    var postfix = attributes.postfix;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType'];
    const [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(myStore.getBreakPoint());
    const [isLoading, setisLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [postGridData, setPostGridData] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(window.PostGridPluginData);
    const [currentPostContent, setCurrentpostContent] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__.useEntityProp)('postType', postType, 'content', postId);
    const [customFields, setCustomFields] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
    const [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__.useEntityProp)('postType', postType, 'link', postId);
    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(''); // Wrapper CSS Class Selectors

    const wrapperSelector = blockClass;
    const textSelector = blockClass + ' .text';
    const iconSelector = blockClass + ' .text-icon';
    const prefixSelector = blockClass + ' .prefix';
    const postfixSelector = blockClass + ' .postfix';

    function getMetaField(metaKey) {
      _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_7___default()({
        path: '/post-grid/v2/get_post_meta',
        method: 'POST',
        data: {
          postId: postId,
          meta_key: metaKey
        }
      }).then(res => {
        if (res['meta_value'] != undefined && res['meta_value'].length > 0) {
          customFields[metaKey] = res['meta_value'];
          setCustomFields({});
          setCustomFields(customFields);
        }
      });
    }

    var linkToArgs = {
      postUrl: {
        label: 'Post URL',
        value: 'postUrl'
      },
      homeUrl: {
        label: 'Home URL',
        value: 'homeUrl'
      },
      authorUrl: {
        label: 'Author URL',
        value: 'authorUrl'
      },
      authorLink: {
        label: 'Author Link',
        value: 'authorLink'
      },
      authorMail: {
        label: 'Author Mail',
        value: 'authorMail',
        isPro: true
      },
      authorMeta: {
        label: 'Author Meta',
        value: 'authorMeta',
        isPro: true
      },
      customField: {
        label: 'Custom Field',
        value: 'customField',
        isPro: true
      },
      customUrl: {
        label: 'Custom URL',
        value: 'customUrl',
        isPro: true
      }
    };
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      }); //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);
    const [linkPickerExcerpt, setLinkPickerExcerpt] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [linkPickerText, setLinkPickerText] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      }); //generateBlockCssY();

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      var iconSrc = icon.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      setIconHtml(iconHtml);
    }, [icon]);
    var breakPointList = [{
      label: 'Select..',
      icon: '',
      value: ''
    }];

    for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_9__["default"]) {
      var item = _breakpoints__WEBPACK_IMPORTED_MODULE_9__["default"][x];
      breakPointList.push({
        label: item.name,
        icon: item.icon,
        value: item.id
      });
    }

    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }

    function setFieldLinkTo(option, index) {
      var options = { ...text.options,
        linkTo: option.value
      };
      setAttributes({
        text: { ...text,
          options: options
        }
      });
    }

    function onChangeIcon(arg) {
      var options = { ...icon.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        icon: { ...icon,
          options: options
        }
      });
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ wrapper: { ...wrapper } });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      // if (blockCssY.items[wrapperSelector] == undefined) {
      //   blockCssY.items[wrapperSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[wrapperSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[wrapperSelector][key] != undefined) {
      //   delete blockCssY.items[wrapperSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // sudoScourceX[key] = {};
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStyleText(sudoScource, newVal, attr) {
      // var sudoScourceX = { ...text[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, textSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ text: { ...text } });
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, text);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        text: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, textSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleText(sudoScource, key) {
      var object = myStore.deletePropertyDeep(text, [sudoScource, key, breakPointX]);
      setAttributes({
        text: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, textSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...text[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // text[sudoScource] = sudoScourceX;
      // setAttributes({ text: { ...text } });
      // if (blockCssY.items[textSelector] == undefined) {
      //   blockCssY.items[textSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[textSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[textSelector][key] != undefined) {
      //   delete blockCssY.items[textSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleText(sudoScource, key) {
      // var sudoScourceX = { ...text[sudoScource] }
      // sudoScourceX[key] = {};
      // text[sudoScource] = sudoScourceX;
      // setAttributes({ text: { ...text } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, text);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        text: object
      });
    }

    function onChangeStyleIcon(sudoScource, newVal, attr) {
      // var sudoScourceX = { ...icon[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ icon: { ...icon } });
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(icon, [sudoScource, key, breakPointX]);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...icon[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // icon[sudoScource] = sudoScourceX;
      // setAttributes({ icon: { ...icon } });
      // if (blockCssY.items[iconSelector] == undefined) {
      //   blockCssY.items[iconSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[iconSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[iconSelector][key] != undefined) {
      //   delete blockCssY.items[iconSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        icon: object
      });
    }

    function onChangeStylePrefix(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, prefix);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        prefix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...prefix[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ prefix: { ...prefix } });
    }

    function onRemoveStylePrefix(sudoScource, key) {
      var object = myStore.deletePropertyDeep(prefix, [sudoScource, key, breakPointX]);
      setAttributes({
        prefix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...prefix[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // prefix[sudoScource] = sudoScourceX;
      // //sudoScourceX[attr][breakPointX] = newVal;
      // setAttributes({ prefix: { ...prefix } });
      // if (blockCssY.items[prefixSelector] == undefined) {
      //   blockCssY.items[prefixSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[prefixSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[prefixSelector][key] != undefined) {
      //   delete blockCssY.items[prefixSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStylePrefix(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, prefix);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        prefix: object
      });
    }

    function onChangeStylePostfix(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, postfix);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        postfix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var sudoScourceX = { ...postfix[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      // setAttributes({ postfix: { ...postfix } });
    }

    function onRemoveStylePostfix(sudoScource, key) {
      var object = myStore.deletePropertyDeep(postfix, [sudoScource, key, breakPointX]);
      setAttributes({
        postfix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...postfix[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // postfix[sudoScource] = sudoScourceX;
      // //sudoScourceX[attr][breakPointX] = newVal;
      // setAttributes({ postfix: { ...postfix } });
      // if (blockCssY.items[postfixSelector] == undefined) {
      //   blockCssY.items[postfixSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[postfixSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[postfixSelector][key] != undefined) {
      //   delete blockCssY.items[postfixSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStylePostfix(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, postfix);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        postfix: object
      });
    }

    function onChangeIconTypo(typoX) {
      setAttributes({
        icon: { ...icon,
          styles: typoX
        }
      });
      var newValuesObjX = {};
      var itemsX = blockCssY.items;

      if (typoX.fontSize[breakPointX] != undefined) {
        var fontSizeVal = typoX.fontSize[breakPointX].val ? typoX.fontSize[breakPointX].val : 16;
        var fontSizeUnit = typoX.fontSize[breakPointX].unit ? typoX.fontSize[breakPointX].unit : 'px';
        var fontSizeX = blockCssY.items[iconSelector] != undefined ? blockCssY.items[iconSelector]['font-size'] : {};
        fontSizeX[breakPointX] = fontSizeVal + fontSizeUnit; //blockCssY.items[iconSelector] = { ...blockCssY.items[iconSelector], 'font-size': fontSizeX };

        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'font-size': fontSizeX
        };
      }

      if (typoX.lineHeight[breakPointX] != undefined) {
        var lineHeightVal = typoX.lineHeight[breakPointX].val ? typoX.lineHeight[breakPointX].val : 16;
        var lineHeightUnit = typoX.lineHeight[breakPointX].unit ? typoX.lineHeight[breakPointX].unit : 'px';
        var lineHeightX = blockCssY.items[iconSelector]['line-height'] != undefined ? blockCssY.items[iconSelector]['line-height'] : {};
        lineHeightX[breakPointX] = lineHeightVal + lineHeightUnit; //blockCssY.items[iconSelector] = { ...blockCssY.items[iconSelector], 'line-height': lineHeightX };

        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'line-height': lineHeightX
        };
      }

      if (typoX.fontWeight[breakPointX] != undefined) {
        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'font-weight': typoX.fontWeight
        };
      }

      if (typoX.textDecoration[breakPointX] != undefined) {
        var str = {};
        var textDecorationX = typoX.textDecoration[breakPointX];
        var textDecorationXStr = textDecorationX.length > 0 ? textDecorationX.join(' ') : '';
        str[breakPointX] = textDecorationXStr;
        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'text-decoration': str
        };
      } //setAttributes({ blockCssY: { items: blockCssY.items } });


      setAttributes({
        blockCssY: {
          items: itemsX
        }
      });
    }

    function onChangeTextTypo(typoX) {
      setAttributes({
        text: { ...text,
          styles: typoX
        }
      });
      var newValuesObjX = {};
      var itemsX = blockCssY.items;

      if (typoX.fontFamily[breakPointX] != undefined) {
        itemsX[textSelector] = { ...blockCssY.items[textSelector],
          'font-family': typoX.fontFamily
        };
      } else {
        //typoX.fontFamily[breakPointX] = {};
        itemsX[textSelector] = { ...blockCssY.items[textSelector],
          'font-family': typoX.fontFamily
        };
      }

      if (typoX.fontSize[breakPointX] != undefined) {
        var fontSizeVal = typoX.fontSize[breakPointX].val ? typoX.fontSize[breakPointX].val : 16;
        var fontSizeUnit = typoX.fontSize[breakPointX].unit ? typoX.fontSize[breakPointX].unit : 'px';
        var fontSizeX = blockCssY.items[textSelector]['font-size'] != undefined ? blockCssY.items[textSelector]['font-size'] : {};
        fontSizeX[breakPointX] = fontSizeVal + fontSizeUnit; //blockCssY.items[textSelector] = { ...blockCssY.items[textSelector], 'font-size': fontSizeX };

        itemsX[textSelector] = { ...blockCssY.items[textSelector],
          'font-size': fontSizeX
        };
      }

      if (typoX.lineHeight[breakPointX] != undefined) {
        var lineHeightVal = typoX.lineHeight[breakPointX].val ? typoX.lineHeight[breakPointX].val : 16;
        var lineHeightUnit = typoX.lineHeight[breakPointX].unit ? typoX.lineHeight[breakPointX].unit : 'px';
        var lineHeightX = blockCssY.items[textSelector]['line-height'] != undefined ? blockCssY.items[textSelector]['line-height'] : {};
        lineHeightX[breakPointX] = lineHeightVal + lineHeightUnit; //blockCssY.items[textSelector] = { ...blockCssY.items[textSelector], 'line-height': lineHeightX };

        itemsX[textSelector] = { ...blockCssY.items[textSelector],
          'line-height': lineHeightX
        };
      }

      if (typoX.letterSpacing[breakPointX] != undefined) {
        var letterSpacingVal = typoX.letterSpacing[breakPointX].val ? typoX.letterSpacing[breakPointX].val : 0;
        var letterSpacingUnit = typoX.letterSpacing[breakPointX].unit ? typoX.letterSpacing[breakPointX].unit : 'px';
        var letterSpacingX = blockCssY.items[textSelector]['letter-spacing'] != undefined ? blockCssY.items[textSelector]['letter-spacing'] : {};
        letterSpacingX[breakPointX] = letterSpacingVal + letterSpacingUnit; //blockCssY.items[textSelector] = { ...blockCssY.items[textSelector], 'letter-spacing': letterSpacingX };

        itemsX[textSelector] = { ...blockCssY.items[textSelector],
          'letter-spacing': letterSpacingX
        };
      }

      if (typoX.fontWeight[breakPointX] != undefined) {
        itemsX[textSelector] = { ...blockCssY.items[textSelector],
          'font-weight': typoX.fontWeight
        };
      }

      if (typoX.textDecoration[breakPointX] != undefined) {
        var str = {};
        var textDecorationX = typoX.textDecoration[breakPointX];
        var textDecorationXStr = textDecorationX.length > 0 ? textDecorationX.join(' ') : '';
        str[breakPointX] = textDecorationXStr;
        itemsX[textSelector] = { ...blockCssY.items[textSelector],
          'text-decoration': str
        };
      }

      if (typoX.textTransform[breakPointX] != undefined) {
        itemsX[textSelector] = { ...blockCssY.items[textSelector],
          'text-transform': typoX.textTransform
        };
      } //setAttributes({ blockCssY: { items: blockCssY.items } });


      setAttributes({
        blockCssY: {
          items: itemsX
        }
      });
    }

    function onChangeWrapTypo(typoX) {
      setAttributes({
        wrapper: { ...wrapper,
          styles: typoX
        }
      });
      var newValuesObjX = {};
      var itemsX = blockCssY.items;

      if (typoX.fontFamily[breakPointX] != undefined) {
        itemsX[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'font-family': typoX.fontFamily
        };
      } else {
        //typoX.fontFamily[breakPointX] = {};
        itemsX[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'font-family': typoX.fontFamily
        };
      }

      if (typoX.fontSize[breakPointX] != undefined) {
        var fontSizeVal = typoX.fontSize[breakPointX].val ? typoX.fontSize[breakPointX].val : 16;
        var fontSizeUnit = typoX.fontSize[breakPointX].unit ? typoX.fontSize[breakPointX].unit : 'px';
        var fontSizeX = blockCssY.items[wrapperSelector]['font-size'] != undefined ? blockCssY.items[wrapperSelector]['font-size'] : {};
        fontSizeX[breakPointX] = fontSizeVal + fontSizeUnit; //blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector], 'font-size': fontSizeX };

        itemsX[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'font-size': fontSizeX
        };
      }

      if (typoX.lineHeight[breakPointX] != undefined) {
        var lineHeightVal = typoX.lineHeight[breakPointX].val ? typoX.lineHeight[breakPointX].val : 16;
        var lineHeightUnit = typoX.lineHeight[breakPointX].unit ? typoX.lineHeight[breakPointX].unit : 'px';
        var lineHeightX = blockCssY.items[wrapperSelector]['line-height'] != undefined ? blockCssY.items[wrapperSelector]['line-height'] : {};
        lineHeightX[breakPointX] = lineHeightVal + lineHeightUnit; //blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector], 'line-height': lineHeightX };

        itemsX[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'line-height': lineHeightX
        };
      }

      if (typoX.letterSpacing[breakPointX] != undefined) {
        var letterSpacingVal = typoX.letterSpacing[breakPointX].val ? typoX.letterSpacing[breakPointX].val : 0;
        var letterSpacingUnit = typoX.letterSpacing[breakPointX].unit ? typoX.letterSpacing[breakPointX].unit : 'px';
        var letterSpacingX = blockCssY.items[wrapperSelector]['letter-spacing'] != undefined ? blockCssY.items[wrapperSelector]['letter-spacing'] : {};
        letterSpacingX[breakPointX] = letterSpacingVal + letterSpacingUnit; //blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector], 'letter-spacing': letterSpacingX };

        itemsX[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'letter-spacing': letterSpacingX
        };
      }

      if (typoX.fontWeight[breakPointX] != undefined) {
        itemsX[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'font-weight': typoX.fontWeight
        };
      }

      if (typoX.textDecoration[breakPointX] != undefined) {
        var str = {};
        var textDecorationX = typoX.textDecoration[breakPointX];
        var textDecorationXStr = textDecorationX.length > 0 ? textDecorationX.join(' ') : '';
        str[breakPointX] = textDecorationXStr;
        itemsX[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'text-decoration': str
        };
      }

      if (typoX.textTransform[breakPointX] != undefined) {
        itemsX[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'text-transform': typoX.textTransform
        };
      } //setAttributes({ blockCssY: { items: blockCssY.items } });


      setAttributes({
        blockCssY: {
          items: itemsX
        }
      });
    }

    function paddingControlWrapper(nextValues) {
      var responsive = wrapper.styles.padding;
      responsive[breakPointX] = nextValues;
      var styles = { ...wrapper.styles,
        padding: responsive
      };
      setAttributes({
        wrapper: { ...wrapper,
          styles: styles
        }
      });
      var itemsX = { ...blockCssY.items
      };
      nextValues.top = nextValues.top == undefined ? '0px' : nextValues.top;
      nextValues.right = nextValues.right == undefined ? '0px' : nextValues.right;
      nextValues.bottom = nextValues.bottom == undefined ? '0px' : nextValues.bottom;
      nextValues.left = nextValues.left == undefined ? '0px' : nextValues.left;
      blockCssY.items[wrapperSelector] = blockCssY.items[wrapperSelector] != undefined ? blockCssY.items[wrapperSelector] : {};

      if (nextValues.top != undefined) {
        var paddingTop = blockCssY.items[wrapperSelector]['padding-top'] != undefined ? blockCssY.items[wrapperSelector]['padding-top'] : {};
        paddingTop[breakPointX] = nextValues.top;
        blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'padding-top': paddingTop
        };
      }

      if (nextValues.right != undefined) {
        var paddingRight = blockCssY.items[wrapperSelector]['padding-right'] != undefined ? blockCssY.items[wrapperSelector]['padding-right'] : {};
        paddingRight[breakPointX] = nextValues.right;
        blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'padding-right': paddingRight
        };
      }

      if (nextValues.bottom != undefined) {
        var paddingBottom = blockCssY.items[wrapperSelector]['padding-bottom'] != undefined ? blockCssY.items[wrapperSelector]['padding-bottom'] : {};
        paddingBottom[breakPointX] = nextValues.bottom;
        blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'padding-bottom': paddingBottom
        };
      }

      if (nextValues.left != undefined) {
        var paddingLeft = blockCssY.items[wrapperSelector]['padding-left'] != undefined ? blockCssY.items[wrapperSelector]['padding-left'] : {};
        paddingLeft[breakPointX] = nextValues.left;
        blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'padding-left': paddingLeft
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function paddingControlText(nextValues) {
      var responsive = text.styles.padding;
      responsive[breakPointX] = nextValues;
      var styles = { ...text.styles,
        padding: responsive
      };
      setAttributes({
        text: { ...text,
          styles: styles
        }
      });
      var itemsX = { ...blockCssY.items
      };
      nextValues.top = nextValues.top == undefined ? '0px' : nextValues.top;
      nextValues.right = nextValues.right == undefined ? '0px' : nextValues.right;
      nextValues.bottom = nextValues.bottom == undefined ? '0px' : nextValues.bottom;
      nextValues.left = nextValues.left == undefined ? '0px' : nextValues.left;
      blockCssY.items[textSelector] = blockCssY.items[textSelector] != undefined ? blockCssY.items[textSelector] : {};

      if (nextValues.top != undefined) {
        var paddingTop = blockCssY.items[textSelector]['padding-top'] != undefined ? blockCssY.items[textSelector]['padding-top'] : {};
        paddingTop[breakPointX] = nextValues.top;
        blockCssY.items[textSelector] = { ...blockCssY.items[textSelector],
          'padding-top': paddingTop
        };
      }

      if (nextValues.right != undefined) {
        var paddingRight = blockCssY.items[textSelector]['padding-right'] != undefined ? blockCssY.items[textSelector]['padding-right'] : {};
        paddingRight[breakPointX] = nextValues.right;
        blockCssY.items[textSelector] = { ...blockCssY.items[textSelector],
          'padding-right': paddingRight
        };
      }

      if (nextValues.bottom != undefined) {
        var paddingBottom = blockCssY.items[textSelector]['padding-bottom'] != undefined ? blockCssY.items[textSelector]['padding-bottom'] : {};
        paddingBottom[breakPointX] = nextValues.bottom;
        blockCssY.items[textSelector] = { ...blockCssY.items[textSelector],
          'padding-bottom': paddingBottom
        };
      }

      if (nextValues.left != undefined) {
        var paddingLeft = blockCssY.items[textSelector]['padding-left'] != undefined ? blockCssY.items[textSelector]['padding-left'] : {};
        paddingLeft[breakPointX] = nextValues.left;
        blockCssY.items[textSelector] = { ...blockCssY.items[textSelector],
          'padding-left': paddingLeft
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function marginControlWrapper(nextValues) {
      var responsive = wrapper.styles.margin;
      responsive[breakPointX] = nextValues;
      var styles = { ...wrapper.styles,
        margin: responsive
      };
      setAttributes({
        wrapper: { ...wrapper,
          styles: styles
        }
      });
      var itemsX = { ...blockCssY.items
      };
      nextValues.top = nextValues.top == undefined ? '0px' : nextValues.top;
      nextValues.right = nextValues.right == undefined ? '0px' : nextValues.right;
      nextValues.bottom = nextValues.bottom == undefined ? '0px' : nextValues.bottom;
      nextValues.left = nextValues.left == undefined ? '0px' : nextValues.left;
      blockCssY.items[wrapperSelector] = blockCssY.items[wrapperSelector] != undefined ? blockCssY.items[wrapperSelector] : {};

      if (nextValues.top != undefined) {
        var marginTop = blockCssY.items[wrapperSelector]['margin-top'] != undefined ? blockCssY.items[wrapperSelector]['margin-top'] : {};
        marginTop[breakPointX] = nextValues.top;
        blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'margin-top': marginTop
        };
      }

      if (nextValues.right != undefined) {
        var marginRight = blockCssY.items[wrapperSelector]['margin-right'] !== undefined ? blockCssY.items[wrapperSelector]['margin-right'] : {};
        marginRight[breakPointX] = nextValues.right;
        blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'margin-right': marginRight
        };
      }

      if (nextValues.bottom != undefined) {
        var marginBottom = blockCssY.items[wrapperSelector]['margin-bottom'] !== undefined ? blockCssY.items[wrapperSelector]['margin-bottom'] : {};
        marginBottom[breakPointX] = nextValues.bottom;
        blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'margin-bottom': marginBottom
        };
      }

      if (nextValues.left != undefined) {
        var marginLeft = blockCssY.items[wrapperSelector]['margin-left'] !== undefined ? blockCssY.items[wrapperSelector]['margin-left'] : {};
        marginLeft[breakPointX] = nextValues.left;
        blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'margin-left': marginLeft
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function marginControlText(nextValues) {
      var responsive = text.styles.margin;
      responsive[breakPointX] = nextValues;
      var styles = { ...text.styles,
        margin: responsive
      };
      setAttributes({
        text: { ...text,
          styles: styles
        }
      });
      var itemsX = { ...blockCssY.items
      };
      nextValues.top = nextValues.top == undefined ? '0px' : nextValues.top;
      nextValues.right = nextValues.right == undefined ? '0px' : nextValues.right;
      nextValues.bottom = nextValues.bottom == undefined ? '0px' : nextValues.bottom;
      nextValues.left = nextValues.left == undefined ? '0px' : nextValues.left;
      blockCssY.items[textSelector] = blockCssY.items[textSelector] != undefined ? blockCssY.items[textSelector] : {};

      if (nextValues.top != undefined) {
        var marginTop = blockCssY.items[textSelector]['margin-top'] != undefined ? blockCssY.items[textSelector]['margin-top'] : {};
        marginTop[breakPointX] = nextValues.top;
        blockCssY.items[textSelector] = { ...blockCssY.items[textSelector],
          'margin-top': marginTop
        };
      }

      if (nextValues.right != undefined) {
        var marginRight = blockCssY.items[textSelector]['margin-right'] !== undefined ? blockCssY.items[textSelector]['margin-right'] : {};
        marginRight[breakPointX] = nextValues.right;
        blockCssY.items[textSelector] = { ...blockCssY.items[textSelector],
          'margin-right': marginRight
        };
      }

      if (nextValues.bottom != undefined) {
        var marginBottom = blockCssY.items[textSelector]['margin-bottom'] !== undefined ? blockCssY.items[textSelector]['margin-bottom'] : {};
        marginBottom[breakPointX] = nextValues.bottom;
        blockCssY.items[textSelector] = { ...blockCssY.items[textSelector],
          'margin-bottom': marginBottom
        };
      }

      if (nextValues.left != undefined) {
        var marginLeft = blockCssY.items[textSelector]['margin-left'] !== undefined ? blockCssY.items[textSelector]['margin-left'] : {};
        marginLeft[breakPointX] = nextValues.left;
        blockCssY.items[textSelector] = { ...blockCssY.items[textSelector],
          'margin-left': marginLeft
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function generateBlockCssY() {
      var reponsiveCssGroups = {};
      var reponsiveCss = '';

      for (var selector in blockCssY.items) {
        var attrs = blockCssY.items[selector];

        for (var attr in attrs) {
          var breakpoints = attrs[attr];

          for (var device in breakpoints) {
            var attrValue = breakpoints[device];

            if (reponsiveCssGroups[device] == undefined) {
              reponsiveCssGroups[device] = [];
            }

            if (reponsiveCssGroups[device][selector] == undefined) {
              reponsiveCssGroups[device][selector] = [];
            }

            reponsiveCssGroups[device][selector].push({
              'attr': attr,
              'val': attrValue
            });
          }
        }
      }

      if (reponsiveCssGroups['Mobile'] != undefined) {
        reponsiveCss += '@media only screen and (min-width: 0px) and (max-width: 360px){';

        for (var selector in reponsiveCssGroups['Mobile']) {
          var attrs = reponsiveCssGroups['Mobile'][selector];
          reponsiveCss += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCss += attrName + ':' + attrValue + ';';
          }

          reponsiveCss += '}';
        }

        reponsiveCss += '}';
      }

      if (reponsiveCssGroups['Tablet'] != undefined) {
        reponsiveCss += '@media only screen and (min-width: 361px) and (max-width: 780px){';

        for (var selector in reponsiveCssGroups['Tablet']) {
          var attrs = reponsiveCssGroups['Tablet'][selector];
          reponsiveCss += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCss += attrName + ':' + attrValue + ';';
          }

          reponsiveCss += '}';
        }

        reponsiveCss += '}';
      }

      if (reponsiveCssGroups['Desktop'] != undefined) {
        reponsiveCss += '@media only screen and (min-width: 781px){';

        for (var selector in reponsiveCssGroups['Desktop']) {
          var attrs = reponsiveCssGroups['Desktop'][selector];
          reponsiveCss += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCss += attrName + ':' + attrValue + ';';
          }

          reponsiveCss += '}';
        }

        reponsiveCss += '}';
      }

      var iframe = document.querySelectorAll('[name="editor-canvas"]')[0];

      if (iframe) {
        setTimeout(() => {
          var iframeDocument = iframe.contentDocument;
          var body = iframeDocument.body;
          var divWrap = iframeDocument.getElementById("css-block-" + blockId);

          if (divWrap != undefined) {
            iframeDocument.getElementById("css-block-" + blockId).outerHTML = "";
          }

          var divWrap = '<div id="css-block-' + blockId + '"></div>';
          body.insertAdjacentHTML('beforeend', divWrap);
          var csswrappg = iframeDocument.getElementById('css-block-' + blockId);
          var str = '<style>' + reponsiveCss + customCss + '</style>';
          csswrappg.insertAdjacentHTML('beforeend', str);
        }, 200);
      } else {
        var wpfooter = document.getElementById('wpfooter');
        var divWrap = document.getElementById("css-block-" + blockId);

        if (divWrap != undefined) {
          document.getElementById("css-block-" + blockId).outerHTML = "";
        }

        var divWrap = '<div id="css-block-' + blockId + '"></div>';
        wpfooter.insertAdjacentHTML('beforeend', divWrap);
        var csswrappg = document.getElementById('css-block-' + blockId);
        var str = '<style>' + reponsiveCss + customCss + '</style>';
        csswrappg.insertAdjacentHTML('beforeend', str);
      }
    }

    var [linkAttrItemsText, setlinkAttrItemsText] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({}); // Using the hook.

    var [wrapAttrItems, setwrapAttrItems] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({}); // Using the hook.

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      //generateBlockCssY()
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      var sdsd = {};
      text.options.linkAttr.map(x => {
        if (x.val) sdsd[x.id] = x.val;
      });
      setlinkAttrItemsText(sdsd);
    }, [text]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      var sdsd = {};

      if (wrapper.options.attr != undefined) {
        wrapper.options.attr.map(x => {
          if (x.val) sdsd[x.id] = x.val;
        });
      }

      setwrapAttrItems(sdsd);
    }, [wrapper]);
    const colors = [{
      name: '9DD6DF',
      color: '#9DD6DF'
    }, {
      name: '18978F',
      color: '#18978F'
    }, {
      name: 'A084CF',
      color: '#A084CF'
    }, {
      name: 'DFBB9D',
      color: '#DFBB9D'
    }, {
      name: '774360',
      color: '#774360'
    }, {
      name: '3AB0FF',
      color: '#3AB0FF'
    }, {
      name: '51557E',
      color: '#51557E'
    }];
    const [setSome, setSomeState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
    const [stateX, setStateX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('Old Value');
    const {
      __experimentalSetPreviewDeviceType: setPreviewDeviceType
    } = wp.data.dispatch('core/edit-post');
    var postUrl = text.options.customUrl != undefined && text.options.customUrl.length > 0 ? text.options.customUrl : currentPostUrl;
    const CustomTag = `${wrapper.options.tag}`;

    function onChangeBreakPoint(x, index) {
      setPreviewDeviceType(x.value);
      var asdsdsd = wp.data.dispatch('postgrid-shop').setBreakPoint(x.value);
      asdsdsd.then(res => {
        setBreakPointX(res.breakpoint); //generateBlockCssY();

        myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      });
    }

    return [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.BlockControls, null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.InspectorControls, {
      key: "general"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "px-3",
      title: "General",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'No Wrapper',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }, {
        label: 'BUTTON',
        value: 'button'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: { ...wrapper,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Attributes"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: " cursor-pointer px-3 text-white py-1 bg-blue-600",
      onClick: ev => {
        if (wrapper.options.attr == undefined) {
          wrapper.options.attr = {};
        }

        var sdsd = wrapper.options.attr.concat({
          id: '',
          val: ''
        });
        var options = { ...wrapper.options,
          attr: sdsd
        };
        setAttributes({
          wrapper: { ...wrapper,
            options: options
          }
        });
      }
    }, "Add")), wrapper.options.attr != undefined && wrapper.options.attr.map((x, i) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
        className: "my-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
        placeholder: "Name",
        className: "mr-2",
        value: wrapper.options.attr[i].id,
        onChange: newVal => {
          wrapper.options.attr[i].id = newVal;
          var ssdsd = wrapper.options.attr.concat([]);
          var options = { ...wrapper.options,
            attr: ssdsd
          };
          setAttributes({
            wrapper: { ...wrapper,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Value",
        value: x.val,
        onChange: newVal => {
          wrapper.options.attr[i].val = newVal;
          var ssdsd = wrapper.options.attr.concat([]);
          var options = { ...wrapper.options,
            attr: ssdsd
          };
          setAttributes({
            wrapper: { ...wrapper,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
        className: "text-lg cursor-pointer px-3 text-white py-1 bg-red-400 icon-close",
        onClick: ev => {
          wrapper.options.attr.splice(i, 1);
          var ssdsd = wrapper.options.attr.concat([]);
          var options = { ...wrapper.options,
            attr: ssdsd
          };
          setAttributes({
            wrapper: { ...wrapper,
              options: options
            }
          });
        }
      })));
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
      title: "Text",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Text"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
      value: text.options.text,
      onChange: newVal => {
        var options = { ...text.options,
          text: newVal
        };
        setAttributes({
          text: { ...text,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.ToggleControl, {
      label: "Linked to URL?",
      help: text.options.isLink ? 'Linked to URL?' : 'Not Linked.',
      checked: text.options.isLink ? true : false,
      onChange: e => {
        var options = { ...text.options,
          isLink: text.options.isLink ? false : true
        };
        setAttributes({
          text: { ...text,
            options: options
          }
        });
      }
    }), text.options.isLink && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Link To"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_19__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: linkToArgs,
      buttonTitle: "Choose",
      onChange: setFieldLinkTo,
      values: []
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "bg-gray-500 p-2 my-3 text-white"
    }, linkToArgs[text.options.linkTo] != undefined ? linkToArgs[text.options.linkTo].label : ''), text.options.linkTo == 'authorMeta' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Author Meta Key"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
      value: text.options.linkToAuthorMeta,
      onChange: newVal => {
        var options = { ...text.options,
          linkToAuthorMeta: newVal
        };
        setAttributes({
          text: { ...text,
            options: options
          }
        });
      }
    })), text.options.linkTo == 'customField' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Meta Key"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
      value: text.options.linkToAuthorMeta,
      onChange: newVal => {
        var options = { ...text.options,
          linkToAuthorMeta: newVal
        };
        setAttributes({
          text: { ...text,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Link Target"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
      label: "",
      value: text.options.linkTarget,
      options: [{
        label: '_self',
        value: '_self'
      }, {
        label: '_blank',
        value: '_blank'
      }, {
        label: '_parent',
        value: '_parent'
      }, {
        label: '_top',
        value: '_top'
      }],
      onChange: newVal => {
        var options = { ...text.options,
          linkTarget: newVal
        };
        setAttributes({
          text: { ...text,
            options: options
          }
        });
      }
    }))), text.options.linkTo == 'customUrl' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Url"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Button, {
      className: linkPickerText ? "!bg-gray-400" : '',
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
      onClick: ev => {
        setLinkPickerText(prev => !prev);
      }
    }), text.options.customUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Button, {
      className: "!text-red-500 ml-2",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
      onClick: ev => {
        var options = { ...text.options,
          customUrl: ''
        };
        setAttributes({
          text: { ...text,
            options: options
          }
        });
      }
    }), linkPickerText && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Popover, {
      position: "bottom right"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.__experimentalLinkControl, {
      settings: [],
      value: text.options.customUrl,
      onChange: newVal => {
        var options = { ...text.options,
          customUrl: newVal.url
        };
        setAttributes({
          text: { ...text,
            options: options
          }
        }); //setLinkPickerText(false)
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "p-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: "font-bold"
    }, "Linked to:"), " ", text.options.customUrl.length != 0 ? text.options.customUrl : 'No link', " ")))), text.options.isLink && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Attributes"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: " cursor-pointer px-3 text-white py-1 bg-blue-600",
      onClick: ev => {
        var sdsd = text.options.linkAttr.concat({
          id: '',
          val: ''
        });
        var options = { ...text.options,
          linkAttr: sdsd
        };
        setAttributes({
          text: { ...text,
            options: options
          }
        });
      }
    }, "Add")), text.options.linkAttr != undefined && text.options.linkAttr.map((x, i) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
        className: "my-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
        placeholder: "Name",
        className: "mr-2",
        value: text.options.linkAttr[i].id,
        onChange: newVal => {
          text.options.linkAttr[i].id = newVal;
          var ssdsd = text.options.linkAttr.concat([]);
          var options = { ...text.options,
            linkAttr: ssdsd
          };
          setAttributes({
            text: { ...text,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Value",
        value: x.val,
        onChange: newVal => {
          text.options.linkAttr[i].val = newVal;
          var ssdsd = text.options.linkAttr.concat([]);
          var options = { ...text.options,
            linkAttr: ssdsd
          };
          setAttributes({
            text: { ...text,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
        className: "text-lg cursor-pointer px-3 text-white py-1 bg-red-400 icon-close",
        onClick: ev => {
          text.options.linkAttr.splice(i, 1);
          var ssdsd = text.options.linkAttr.concat([]);
          var options = { ...text.options,
            linkAttr: ssdsd
          };
          setAttributes({
            text: { ...text,
              options: options
            }
          });
        }
      })));
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: text,
      onChange: onChangeStyleText,
      onAdd: onAddStyleText,
      onRemove: onRemoveStyleText
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
      title: "Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_13__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: onChangeIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Icon postion"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: 'Choose Position',
        value: ''
      }, {
        label: 'Before Text',
        value: 'beforeText'
      }, {
        label: 'After Text',
        value: 'afterText'
      }, {
        label: 'Before Prefix',
        value: 'beforePrefix'
      }, {
        label: 'After Prefix',
        value: 'afterPrefix'
      }, {
        label: 'Before Postfix',
        value: 'beforePostfix'
      }, {
        label: 'After Postfix',
        value: 'afterPostfix'
      }, {
        label: 'Before Link',
        value: 'beforeLink'
      }, {
        label: 'After Link',
        value: 'afterLink'
      }],
      onChange: newVal => {
        var options = { ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
      title: "Prefix",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Prefix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
      value: prefix.options.text,
      onChange: newVal => {
        var options = { ...prefix.options,
          text: newVal
        };
        setAttributes({
          prefix: { ...prefix,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: prefix,
      onChange: onChangeStylePrefix,
      onAdd: onAddStylePrefix,
      onRemove: onRemoveStylePrefix
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
      title: "Postfix",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Postfix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
      value: postfix.options.text,
      onChange: newVal => {
        var options = { ...postfix.options,
          text: newVal
        };
        setAttributes({
          postfix: { ...postfix,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: postfix,
      onChange: onChangeStylePostfix,
      onAdd: onAddStylePostfix,
      onRemove: onRemoveStylePostfix
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Wrapper"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, wrapperSelector, '{/* your CSS here*/}'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Text"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, textSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Prefix Selector"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, prefixSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Postfix Selector"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, postfixSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "px-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_14__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_15__["default"], {
      utm: {
        utm_source: 'BlockReadMore',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    })))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, wrapper.options.tag && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(CustomTag, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      className: [blockId]
    }, wrapAttrItems), icon.options.position == 'beforePrefix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: prefix.options.class
    }, prefix.options.text), icon.options.position == 'afterPrefix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), text.options.isLink && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, icon.options.position == 'beforeLink' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("a", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      className: "text",
      onClick: handleLinkClick
    }, linkAttrItemsText, {
      target: text.options.linkTarget,
      href: postUrl
    }), icon.options.position == 'beforeText' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.RichText, {
      tagName: 'span',
      value: text.options.text,
      allowedFormats: ['core/bold', 'core/italic', 'core/link'],
      onChange: content => {
        var options = { ...text.options,
          text: content
        };
        setAttributes({
          text: { ...text,
            options: options
          }
        });
      },
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Start Writing...')
    }), icon.options.position == 'afterText' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), icon.options.position == 'afterLink' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), !text.options.isLink && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, icon.options.position == 'beforeText' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.RichText, {
      className: "text",
      tagName: 'span',
      value: text.options.text,
      allowedFormats: ['core/bold', 'core/italic', 'core/link'],
      onChange: content => {
        var options = { ...text.options,
          text: content
        };
        setAttributes({
          text: { ...text,
            options: options
          }
        });
      },
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Start Writing...')
    }), icon.options.position == 'afterText' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), postfix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: postfix.options.class
    }, postfix.options.text), icon.options.position == 'afterPostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), wrapper.options.tag.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: prefix.options.class
    }, prefix.options.text), icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), text.options.isLink && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, icon.options.position == 'beforeLink' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("a", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      className: "text",
      onClick: handleLinkClick
    }, linkAttrItemsText, {
      target: text.options.linkTarget,
      href: postUrl
    }), icon.options.position == 'beforeText' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.RichText, {
      tagName: 'span',
      value: text.options.text,
      allowedFormats: ['core/bold', 'core/italic', 'core/link'],
      onChange: content => {
        var options = { ...text.options,
          text: content
        };
        setAttributes({
          text: { ...text,
            options: options
          }
        });
      },
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Start Writing...')
    }), icon.options.position == 'afterText' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), icon.options.position == 'afterLink' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), !text.options.isLink && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, icon.options.position == 'beforeText' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.RichText, {
      className: "text",
      tagName: 'span',
      value: text.options.text,
      allowedFormats: ['core/bold', 'core/italic', 'core/link'],
      onChange: content => {
        var options = { ...text.options,
          text: content
        };
        setAttributes({
          text: { ...text,
            options: options
          }
        });
      },
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Start Writing...')
    }), icon.options.position == 'afterText' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), postfix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: postfix.options.class
    }, postfix.options.text), icon.options.position == 'afterPostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })))];
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/image/index.js":
/*!***********************************!*\
  !*** ./src/blocks/image/index.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link-off.js");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_toggle__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/toggle */ "./src/components/toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_css_display__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/css-display */ "./src/components/css-display/index.js");
/* harmony import */ var _placeholder_jpg__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./placeholder.jpg */ "./src/blocks/image/placeholder.jpg");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
















const {
  RawHTML
} = wp.element;














var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__.registerBlockType)("post-grid/image", {
  title: "Image",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#2563eb',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("svg", {
      width: "24",
      height: "24",
      viewBox: "0 0 24 24",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M20.125 5H3.875C2.83945 5 2 5.83945 2 6.875V18.125C2 19.1605 2.83945 20 3.875 20H20.125C21.1605 20 22 19.1605 22 18.125V6.875C22 5.83945 21.1605 5 20.125 5ZM19.8906 18.125H4.10938C4.04721 18.125 3.9876 18.1003 3.94365 18.0564C3.89969 18.0124 3.875 17.9528 3.875 17.8906V7.10938C3.875 7.04721 3.89969 6.9876 3.94365 6.94365C3.9876 6.89969 4.04721 6.875 4.10938 6.875H19.8906C19.9528 6.875 20.0124 6.89969 20.0564 6.94365C20.1003 6.9876 20.125 7.04721 20.125 7.10938V17.8906C20.125 17.9528 20.1003 18.0124 20.0564 18.0564C20.0124 18.1003 19.9528 18.125 19.8906 18.125V18.125ZM7 8.4375C6.13707 8.4375 5.4375 9.13707 5.4375 10C5.4375 10.8629 6.13707 11.5625 7 11.5625C7.86293 11.5625 8.5625 10.8629 8.5625 10C8.5625 9.13707 7.86293 8.4375 7 8.4375ZM5.75 16.25H18.25V13.125L14.8314 9.70645C14.6484 9.5234 14.3516 9.5234 14.1685 9.70645L9.5 14.375L7.95645 12.8314C7.7734 12.6484 7.4766 12.6484 7.29352 12.8314L5.75 14.375V16.25Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: '',
          useAsBackground: 'no'
        },
        styles: {
          width: {},
          height: {},
          overflow: {},
          color: {
            Desktop: ''
          },
          bgColor: {},
          bgImage: {},
          bgPosition: {},
          bgSize: {},
          display: {},
          borderRadius: {},
          padding: {
            Desktop: ''
          },
          margin: {}
        }
      }
    },
    image: {
      type: 'object',
      default: {
        options: {
          imgSrcType: 'media',

          /*media, customField, customUrl, imgId */
          imgSrcMetaKey: '',
          imgSrcMetaKeyType: 'ID',
          //ID, URL,
          imgSrcImgId: '',
          srcUrl: '',
          srcId: '',
          tag: 'div',
          linkTo: '',
          // postUrl, customField, authorUrl, authorLink, homeUrl, custom
          linkToMetaKey: '',
          linkTocustomUrl: '',
          altTextSrc: 'imgAltText',
          // imgAltText, imgTitle, imgCaption, imgDescription imgName, imgSlug, postTitle, excerpt, postSlug, customField, custom
          altTextCustom: '',
          altTextMetaKey: '',
          linkTarget: '_blank',
          linkAttr: [],
          class: '',
          size: {
            "Desktop": "full",
            "Tablet": "full",
            "Mobile": "full"
          }
        },
        styles: {
          display: {},
          width: {},
          height: {},
          filter: {},
          objectFit: {},
          padding: {
            Desktop: ''
          },
          margin: {}
        },
        hoverStyles: {
          filter: {}
        }
      }
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    let image = attributes.image;
    var wrapper = attributes.wrapper;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var demoImg = 'src/blocks/post-featured-image/placeholder.jpg';
    var postId = context['postId'];
    var postType = context['postType'];
    const [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(myStore.getBreakPoint());
    const [loading, setLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [linkPickerPosttitle, setLinkPickerPosttitle] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [linkPickerSrcUrl, setlinkPickerSrcUrl] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [postImage, setPostImage] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const [imageObj, setImageObj] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({}); //{src:'', altText:'', sizes:{}}

    const [imageSizes, setImageSizes] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
    let filterArgsBasic = [{
      label: 'Blur',
      isPro: false,
      value: 'blur',
      val: '',
      unit: 'px'
    }, {
      label: 'Brightness',
      isPro: false,
      value: 'brightness',
      val: '10',
      unit: '%'
    }, {
      label: 'Contrast',
      isPro: true,
      value: 'contrast',
      val: '10',
      unit: '%'
    }, {
      label: 'Grayscale',
      isPro: true,
      value: 'grayscale',
      val: '10',
      unit: '%'
    }, {
      label: 'Hue-rotate',
      isPro: true,
      value: 'hue-rotate',
      val: '10',
      unit: 'deg'
    }, {
      label: 'Invert',
      isPro: true,
      value: 'invert',
      val: '10',
      unit: '%'
    }, {
      label: 'Opacity',
      isPro: true,
      value: 'opacity',
      val: '10',
      unit: '%'
    }, {
      label: 'Saturate',
      isPro: true,
      value: 'saturate',
      val: '10',
      unit: '%'
    }, {
      label: 'Sepia',
      value: 'sepia',
      val: '10',
      unit: '%'
    }];
    let filterArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__.applyFilters)('imageFilterArgs', filterArgsBasic);
    var linkToArgsBasic = {
      postUrl: {
        label: 'Post URL',
        value: 'postUrl'
      },
      homeUrl: {
        label: 'Home URL',
        value: 'homeUrl'
      },
      authorUrl: {
        label: 'Author URL',
        value: 'authorUrl'
      },
      authorLink: {
        label: 'Author Link',
        value: 'authorLink'
      },
      authorMail: {
        label: 'Author Mail',
        value: 'authorMail',
        isPro: true
      },
      authorMeta: {
        label: 'Author Meta',
        value: 'authorMeta',
        isPro: true
      },
      customField: {
        label: 'Custom Field',
        value: 'customField',
        isPro: true
      },
      customUrl: {
        label: 'Custom URL',
        value: 'customUrl',
        isPro: true
      }
    };
    let linkToArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__.applyFilters)('linkToArgs', linkToArgsBasic);
    var customTagArgsBasic = {
      h1: {
        label: 'H1',
        value: 'h1'
      },
      h2: {
        label: 'H2',
        value: 'h2'
      },
      h3: {
        label: 'H3',
        value: 'h3'
      },
      h4: {
        label: 'H4',
        value: 'h4'
      },
      h5: {
        label: 'H5',
        value: 'h5'
      },
      h6: {
        label: 'H6',
        value: 'h6'
      },
      span: {
        label: 'SPAN',
        value: 'span'
      },
      div: {
        label: 'DIV',
        value: 'div'
      },
      p: {
        label: 'P',
        value: 'p'
      }
    };
    let customTagArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__.applyFilters)('customTagArgs', customTagArgsBasic);
    var altTextSrcArgsBasic = {
      'none': {
        label: 'No Alt Text',
        value: ''
      },
      'imgAltText': {
        label: 'Image Alt Text',
        value: 'imgAltText'
      },
      'imgTitle': {
        label: 'Image Title',
        value: 'imgTitle'
      },
      'imgCaption': {
        label: 'Image Caption',
        value: 'imgCaption'
      },
      'imgDescription': {
        label: 'Image Description',
        value: 'imgDescription'
      },
      'imgSlug': {
        label: 'Image Slug',
        value: 'imgSlug'
      },
      'postTitle': {
        label: 'Post Title',
        value: 'postTitle'
      },
      'postSlug': {
        label: 'Post Slug',
        value: 'postSlug'
      },
      'excerpt': {
        label: 'Post Excerpt',
        value: 'excerpt',
        isPro: true
      },
      'customField': {
        label: 'Post Custom Field',
        value: 'customField',
        isPro: true
      },
      'custom': {
        label: 'Custom',
        value: 'custom',
        isPro: true
      }
    };
    let altTextSrcArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__.applyFilters)('altTextSrcArgs', altTextSrcArgsBasic);
    const ALLOWED_MEDIA_TYPES = ['image'];
    const [currentPostImageId, setCurrentPostImageId] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(image.options.srcId);
    const [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__.useEntityProp)('postType', postType, 'link', postId);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      if (currentPostImageId.length != 0) {
        setLoading(true);
        _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_11___default()({
          path: '/wp/v2/media/' + currentPostImageId,
          method: 'POST',
          data: {
            id: currentPostImageId
          }
        }).then(res => {
          setPostImage(res);
          var options = { ...image.options,
            srcUrl: res.source_url,
            srcId: res.id
          };
          setAttributes({
            image: { ...image,
              options: options
            }
          });
          setLoading(false);
          var imgSizes = [];
          Object.keys(res.media_details.sizes).map(x => {
            var height = res.media_details.sizes[x].height;
            var width = res.media_details.sizes[x].width; //var crop = res[x].crop

            imgSizes.push({
              label: x + "(" + width + "*" + height + ")",
              value: x,
              height: height,
              width: width
            });
          });
          setImageSizes(imgSizes);
        }); // apiFetch({
        //   path: '/post-grid/v2/get_image_sizes',
        //   method: 'POST',
        //   data: {},
        // }).then((res) => {
        //   var imgSizes = [];
        //   Object.keys(res).map(x => {
        //     var height = res[x].height
        //     var width = res[x].width
        //     var crop = res[x].crop
        //     imgSizes.push({ label: x + "(" + width + "*" + height + ")", value: x, height: height, width: width, crop: crop });
        //   })
        //   setImageSizes(imgSizes)
        // });
      }
    }, [currentPostImageId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      if (image.options.imgSrcMetaKey.length != 0) {
        setLoading(true);
        _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_11___default()({
          path: '/post-grid/v2/get_post_meta',
          method: 'POST',
          data: {
            postId: postId,
            meta_key: image.options.imgSrcMetaKey,
            type: 'string',
            template: ''
          }
        }).then(res => {
          var metaKeyType = image.options.imgSrcMetaKeyType != undefined ? image.options.imgSrcMetaKeyType : 'ID';

          if (metaKeyType == 'ID') {
            setCurrentPostImageId(res.meta_value);
          } else {//setPostImage(res)
          }

          setLoading(false);
        });
      }
    }, [image.options.imgSrcMetaKey, image.options.imgSrcMetaKeyType, image.options.imgSrcType]);

    function setFeaturedImageSize(option, index) {
      var newValuesObj = {};

      if (Object.keys(image.options.size).length == 0) {
        newValuesObj[breakPointX] = option.value;
      } else {
        newValuesObj = image.options.size;
        newValuesObj[breakPointX] = option.value;
      }

      var options = { ...image.options,
        size: newValuesObj
      };
      setAttributes({
        image: { ...image,
          options: options
        }
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      }); // setAttributes({ image: image });
      // setAttributes({ wrapper: wrapper });
      //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      blockCssY.items[imgSelector] = { ...blockCssY.items[imgSelector],
        'width': {
          "Desktop": "100%"
        }
      };
      blockCssY.items[imgSelector] = { ...blockCssY.items[imgSelector],
        'height': {
          "Desktop": "auto"
        }
      };
      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }, [clientId]); // Wrapper CSS Class Selectors

    const wrapperSelector = blockClass;
    var linkSelector = '';

    if (wrapper.options.tag.length != 0) {
      if (image.options.linkTo.length > 0) {
        linkSelector = blockClass + ' a';
      } else {
        linkSelector = blockClass;
      }
    } else {
      linkSelector = blockClass;
    }

    var imgSelector = blockClass + ' img';
    var breakPointList = [{
      label: 'Select..',
      icon: '',
      value: ''
    }];

    for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_9__["default"]) {
      var item = _breakpoints__WEBPACK_IMPORTED_MODULE_9__["default"][x];
      breakPointList.push({
        label: item.name,
        icon: item.icon,
        value: item.id
      });
    }

    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, wrapper);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ wrapper: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      // if (blockCssY.items[wrapperSelector] == undefined) {
      //   blockCssY.items[wrapperSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[wrapperSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[wrapperSelector][key] != undefined) {
      //   delete blockCssY.items[wrapperSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // sudoScourceX[key] = {};
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStyleImage(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, image);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        image: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, imgSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, image);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ image: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, imgSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleImage(sudoScource, key) {
      var object = myStore.deletePropertyDeep(image, [sudoScource, key, breakPointX]);
      setAttributes({
        image: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, imgSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...image[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // image[sudoScource] = sudoScourceX;
      // setAttributes({ image: { ...image } });
      // if (blockCssY.items[imgSelector] == undefined) {
      //   blockCssY.items[imgSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[imgSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[imgSelector][key] != undefined) {
      //   delete blockCssY.items[imgSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleImage(sudoScource, key) {
      // var sudoScourceX = { ...image[sudoScource] }
      // sudoScourceX[key] = {};
      // image[sudoScource] = sudoScourceX;
      // setAttributes({ image: { ...image } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, image);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        image: object
      });
    }

    var [linkAttrItems, setlinkAttrItems] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({}); // Using the hook.

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      //generateBlockCssY()
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      }); //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      linkAttrObj();
    }, [image]);

    var linkAttrObj = () => {
      var sdsd = {};
      image.options.linkAttr.map(x => {
        if (x.val) sdsd[x.id] = x.val;
      });
      setlinkAttrItems(sdsd);
    };

    const colors = [{
      name: '9DD6DF',
      color: '#9DD6DF'
    }, {
      name: '18978F',
      color: '#18978F'
    }, {
      name: 'A084CF',
      color: '#A084CF'
    }, {
      name: 'DFBB9D',
      color: '#DFBB9D'
    }, {
      name: '774360',
      color: '#774360'
    }, {
      name: '3AB0FF',
      color: '#3AB0FF'
    }, {
      name: '51557E',
      color: '#51557E'
    }];
    const [setSome, setSomeState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
    const [stateX, setStateX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('Old Value');
    const {
      __experimentalSetPreviewDeviceType: setPreviewDeviceType
    } = wp.data.dispatch('core/edit-post');
    var postUrl = image.options.linkTocustomUrl != undefined && image.options.linkTocustomUrl.length > 0 ? image.options.linkTocustomUrl : currentPostUrl;
    const CustomTag = `${wrapper.options.tag}`;
    const CustomTagPostTitle = `${image.options.tag}`;

    function onChangeBreakPoint(x, index) {
      setPreviewDeviceType(x.value);
      var asdsdsd = wp.data.dispatch('postgrid-shop').setBreakPoint(x.value);
      asdsdsd.then(res => {
        setBreakPointX(res.breakpoint); //generateBlockCssY();

        myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      });
    }

    return [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.BlockControls, null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.InspectorControls, {
      key: "general"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'No Wrapper',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Image as Background"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: wrapper.options.useAsBackground,
      options: [{
        label: 'No',
        value: 'no'
      }, {
        label: 'Yes',
        value: 'yes'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          useAsBackground: newVal
        };
        var styles = { ...wrapper.styles,
          bgImage: {}
        };

        if (newVal == 'no') {
          setAttributes({
            wrapper: { ...wrapper,
              options: options,
              styles: styles
            }
          });
          var itemsX = { ...blockCssY.items
          };
          itemsX[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
            'background-image': {}
          };
          setAttributes({
            blockCssY: {
              items: itemsX
            }
          });
        }

        if (newVal == 'yes') {
          var newValuesObj = {};

          if (Object.keys(wrapper.styles.bgImage).length == 0) {
            newValuesObj[breakPointX] = 'url("' + postImage.guid.rendered + '")';
          } else {
            newValuesObj = wrapper.styles.bgImage;
            newValuesObj[breakPointX] = 'url("' + postImage.guid.rendered + '")';
          }

          var styles = { ...wrapper.styles,
            bgImage: newValuesObj
          };
          setAttributes({
            wrapper: { ...wrapper,
              styles: styles,
              options: options
            }
          });
          var itemsX = { ...blockCssY.items
          };
          itemsX[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
            'background-image': newValuesObj
          };
          setAttributes({
            blockCssY: {
              items: itemsX
            }
          });
        }
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", null, "Width"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_icon_toggle__WEBPACK_IMPORTED_MODULE_12__["default"], {
      position: "bottom",
      variant: "secondary",
      iconList: breakPointList,
      buttonTitle: "Break Point Switch",
      onChange: onChangeBreakPoint,
      activeIcon: _breakpoints__WEBPACK_IMPORTED_MODULE_9__["default"][breakPointX].icon,
      value: breakPointX
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: wrapper.styles.width[breakPointX] != undefined ? wrapper.styles.width[breakPointX].val : 10,
      type: "number",
      onChange: newVal => {
        var newValuesObj = {};

        if (Object.keys(wrapper.styles.width).length == 0) {
          newValuesObj[breakPointX] = {
            val: newVal,
            unit: 'em'
          };
        } else {
          newValuesObj = wrapper.styles.width;
          var unit = newValuesObj[breakPointX] != undefined ? newValuesObj[breakPointX].unit : 'em';
          newValuesObj[breakPointX] = {
            val: newVal,
            unit: unit
          };
        }

        var styles = { ...wrapper.styles,
          width: newValuesObj
        };
        setAttributes({
          wrapper: { ...wrapper,
            styles: styles
          }
        });
        var heightVal = newValuesObj[breakPointX].val ? newValuesObj[breakPointX].val : 10;
        var heightUnit = newValuesObj[breakPointX].unit ? newValuesObj[breakPointX].unit : 'em';
        var heightX = blockCssY.items[wrapperSelector] != undefined ? blockCssY.items[wrapperSelector] : {};
        heightX[breakPointX] = heightVal + heightUnit;
        blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'width': heightX
        };
        setAttributes({
          blockCssY: {
            items: blockCssY.items
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      className: "mb-0",
      value: wrapper.styles.width[breakPointX] != undefined ? wrapper.styles.width[breakPointX].unit : 'em',
      options: [{
        label: 'fr',
        value: 'fr'
      }, {
        label: 'px',
        value: 'px'
      }, {
        label: '%',
        value: '%'
      }, {
        label: 'em',
        value: 'em'
      }],
      onChange: newVal => {
        var newValuesObj = {};

        if (Object.keys(wrapper.styles.width).length == 0) {
          newValuesObj[breakPointX] = {
            val: 10,
            unit: newVal
          };
        } else {
          newValuesObj = wrapper.styles.width;
          var val = newValuesObj[breakPointX] != undefined ? newValuesObj[breakPointX].val : 10;
          newValuesObj[breakPointX] = {
            val: val,
            unit: newVal
          };
        }

        var styles = { ...wrapper.styles,
          width: newValuesObj
        };
        setAttributes({
          wrapper: { ...wrapper,
            styles: styles
          }
        });
        var heightVal = newValuesObj[breakPointX].val ? newValuesObj[breakPointX].val : 10;
        var heightUnit = newValuesObj[breakPointX].unit ? newValuesObj[breakPointX].unit : 'em';
        var heightX = blockCssY.items[wrapperSelector] != undefined ? blockCssY.items[wrapperSelector] : {};
        heightX[breakPointX] = heightVal + heightUnit;
        blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'width': heightX
        };
        setAttributes({
          blockCssY: {
            items: blockCssY.items
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", null, "Height"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_icon_toggle__WEBPACK_IMPORTED_MODULE_12__["default"], {
      position: "bottom",
      variant: "secondary",
      iconList: breakPointList,
      buttonTitle: "Break Point Switch",
      onChange: onChangeBreakPoint,
      activeIcon: _breakpoints__WEBPACK_IMPORTED_MODULE_9__["default"][breakPointX].icon,
      value: breakPointX
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: wrapper.styles.height[breakPointX] != undefined ? wrapper.styles.height[breakPointX].val : 10,
      type: "number",
      onChange: newVal => {
        var newValuesObj = {};

        if (Object.keys(wrapper.styles.height).length == 0) {
          newValuesObj[breakPointX] = {
            val: newVal,
            unit: 'em'
          };
        } else {
          newValuesObj = wrapper.styles.height;
          var unit = newValuesObj[breakPointX] != undefined ? newValuesObj[breakPointX].unit : 'em';
          newValuesObj[breakPointX] = {
            val: newVal,
            unit: unit
          };
        }

        var styles = { ...wrapper.styles,
          height: newValuesObj
        };
        setAttributes({
          wrapper: { ...wrapper,
            styles: styles
          }
        });
        var heightVal = newValuesObj[breakPointX].val ? newValuesObj[breakPointX].val : 10;
        var heightUnit = newValuesObj[breakPointX].unit ? newValuesObj[breakPointX].unit : 'em';
        var heightX = blockCssY.items[wrapperSelector] != undefined ? blockCssY.items[wrapperSelector] : {};
        heightX[breakPointX] = heightVal + heightUnit;
        blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'height': heightX
        };
        setAttributes({
          blockCssY: {
            items: blockCssY.items
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      className: "mb-0",
      value: wrapper.styles.height[breakPointX] != undefined ? wrapper.styles.height[breakPointX].unit : 'em',
      options: [{
        label: 'fr',
        value: 'fr'
      }, {
        label: 'px',
        value: 'px'
      }, {
        label: '%',
        value: '%'
      }, {
        label: 'em',
        value: 'em'
      }],
      onChange: newVal => {
        var newValuesObj = {};

        if (Object.keys(wrapper.styles.height).length == 0) {
          newValuesObj[breakPointX] = {
            val: 10,
            unit: newVal
          };
        } else {
          newValuesObj = wrapper.styles.height;
          var val = newValuesObj[breakPointX] != undefined ? newValuesObj[breakPointX].val : 10;
          newValuesObj[breakPointX] = {
            val: val,
            unit: newVal
          };
        }

        var styles = { ...wrapper.styles,
          height: newValuesObj
        };
        setAttributes({
          wrapper: { ...wrapper,
            styles: styles
          }
        });
        var heightVal = newValuesObj[breakPointX].val ? newValuesObj[breakPointX].val : 10;
        var heightUnit = newValuesObj[breakPointX].unit ? newValuesObj[breakPointX].unit : 'em';
        var heightX = blockCssY.items[wrapperSelector] != undefined ? blockCssY.items[wrapperSelector] : {};
        heightX[breakPointX] = heightVal + heightUnit;
        blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'height': heightX
        };
        setAttributes({
          blockCssY: {
            items: blockCssY.items
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", null, "Overflow "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_icon_toggle__WEBPACK_IMPORTED_MODULE_12__["default"], {
      position: "bottom",
      variant: "secondary",
      iconList: breakPointList,
      buttonTitle: "Break Point Switch",
      onChange: onChangeBreakPoint,
      activeIcon: _breakpoints__WEBPACK_IMPORTED_MODULE_9__["default"][breakPointX].icon,
      value: breakPointX
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      className: "mb-0",
      value: wrapper.styles.overflow[breakPointX] != undefined ? wrapper.styles.overflow[breakPointX] : 'hidden',
      options: [{
        label: 'scroll',
        value: 'scroll'
      }, {
        label: 'hidden',
        value: 'hidden'
      }, {
        label: 'auto',
        value: 'auto'
      }, {
        label: 'clip',
        value: 'clip'
      }, {
        label: 'visible',
        value: 'visible'
      }],
      onChange: newVal => {
        var newValuesObj = {};

        if (Object.keys(wrapper.styles.overflow).length == 0) {
          newValuesObj[breakPointX] = newVal;
        } else {
          newValuesObj = wrapper.styles.overflow;
          newValuesObj[breakPointX] = newVal;
        }

        var styles = { ...wrapper.styles,
          overflow: newValuesObj
        };
        setAttributes({
          wrapper: { ...wrapper,
            styles: styles
          }
        });
        var itemsX = { ...blockCssY.items
        };
        itemsX[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'overflow': newValuesObj
        };
        setAttributes({
          blockCssY: {
            items: itemsX
          }
        });
      }
    })), wrapper.options.useAsBackground == 'yes' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", null, "Background Position "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_icon_toggle__WEBPACK_IMPORTED_MODULE_12__["default"], {
      position: "bottom",
      variant: "secondary",
      iconList: breakPointList,
      buttonTitle: "Break Point Switch",
      onChange: onChangeBreakPoint,
      activeIcon: _breakpoints__WEBPACK_IMPORTED_MODULE_9__["default"][breakPointX].icon,
      value: breakPointX
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      className: "mb-0",
      value: wrapper.styles.bgPosition[breakPointX] != undefined ? wrapper.styles.bgPosition[breakPointX] : 'hidden',
      options: [{
        label: 'left top',
        value: 'left top'
      }, {
        label: 'left center',
        value: 'left center'
      }, {
        label: 'left bottom',
        value: 'left bottom'
      }, {
        label: 'right top',
        value: 'right top'
      }, {
        label: 'right center',
        value: 'right center'
      }, {
        label: 'right bottom',
        value: 'right bottom'
      }, {
        label: 'center top',
        value: 'center top'
      }, {
        label: 'center center',
        value: 'center center'
      }, {
        label: 'center bottom',
        value: 'center bottom'
      }],
      onChange: newVal => {
        var newValuesObj = {};

        if (Object.keys(wrapper.styles.bgPosition).length == 0) {
          newValuesObj[breakPointX] = newVal;
        } else {
          newValuesObj = wrapper.styles.bgPosition;
          newValuesObj[breakPointX] = newVal;
        }

        var styles = { ...wrapper.styles,
          bgPosition: newValuesObj
        };
        setAttributes({
          wrapper: { ...wrapper,
            styles: styles
          }
        });
        var itemsX = { ...blockCssY.items
        };
        itemsX[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'background-position': newValuesObj
        };
        setAttributes({
          blockCssY: {
            items: itemsX
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", null, "Background Size "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_icon_toggle__WEBPACK_IMPORTED_MODULE_12__["default"], {
      position: "bottom",
      variant: "secondary",
      iconList: breakPointList,
      buttonTitle: "Break Point Switch",
      onChange: onChangeBreakPoint,
      activeIcon: _breakpoints__WEBPACK_IMPORTED_MODULE_9__["default"][breakPointX].icon,
      value: breakPointX
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      className: "mb-0",
      value: wrapper.styles.bgSize[breakPointX] != undefined ? wrapper.styles.bgSize[breakPointX] : 'hidden',
      options: [{
        label: 'auto',
        value: 'auto'
      }, {
        label: 'cover',
        value: 'cover'
      }, {
        label: 'contain',
        value: 'contain'
      }],
      onChange: newVal => {
        var newValuesObj = {};

        if (Object.keys(wrapper.styles.bgSize).length == 0) {
          newValuesObj[breakPointX] = newVal;
        } else {
          newValuesObj = wrapper.styles.bgSize;
          newValuesObj[breakPointX] = newVal;
        }

        var styles = { ...wrapper.styles,
          bgSize: newValuesObj
        };
        setAttributes({
          wrapper: { ...wrapper,
            styles: styles
          }
        });
        var itemsX = { ...blockCssY.items
        };
        itemsX[wrapperSelector] = { ...blockCssY.items[wrapperSelector],
          'background-size': newValuesObj
        };
        setAttributes({
          blockCssY: {
            items: itemsX
          }
        });
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Image",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Image Sources"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: image.options.imgSrcType,
      options: [{
        label: 'Media',
        value: 'media'
      }, {
        label: 'Custom Field',
        value: 'customField'
      }, {
        label: 'Image Source URL',
        value: 'customUrl'
      } // { label: 'Image ID', value: 'imgId' },
      ],
      onChange: newVal => {
        var options = { ...image.options,
          imgSrcType: newVal
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      }
    })), image.options.srcUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("img", {
      src: image.options.srcUrl,
      alt: ""
    }), image.options.srcUrl.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("img", {
      src: _placeholder_jpg__WEBPACK_IMPORTED_MODULE_20__,
      alt: ""
    }), image.options.imgSrcType == 'media' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "mt-5",
      for: ""
    }, "Choose Image"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.MediaUploadCheck, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.MediaUpload, {
      class: "bg-blue-500",
      onSelect: media => {
        // media.id
        setCurrentPostImageId(media.id);
        var options = { ...image.options,
          srcUrl: media.url,
          srcId: media.id
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      },
      onClose: () => {},
      allowedTypes: ALLOWED_MEDIA_TYPES,
      value: image.options.srcId,
      render: _ref => {
        let {
          open
        } = _ref;
        return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
          className: "my-3 bg-blue-500 text-white border border-solid border-gray-300 text-center w-full",
          onClick: open
        }, "Open Media Library");
      }
    }))), image.options.imgSrcType == 'customField' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Field Key"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: image.options.imgSrcMetaKey,
      onChange: newVal => {
        var options = { ...image.options,
          imgSrcMetaKey: newVal
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Metakey Type"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: image.options.imgSrcMetaKeyType,
      options: [{
        label: 'ID',
        value: 'ID'
      }, {
        label: 'URL',
        value: 'URL'
      }],
      onChange: newVal => {
        var options = { ...image.options,
          imgSrcMetaKeyType: newVal
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      }
    }))), image.options.imgSrcType == 'customUrl' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Image URL"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: linkPickerSrcUrl ? "!bg-gray-400" : '',
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
      onClick: ev => {
        setlinkPickerSrcUrl(prev => !prev);
      }
    }), image.options.srcUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: "!text-red-500 ml-2",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
      onClick: ev => {
        var options = { ...image.options,
          srcUrl: ''
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
        setlinkPickerSrcUrl(false);
      }
    }), linkPickerSrcUrl && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Popover, {
      position: "bottom right"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.__experimentalLinkControl, {
      settings: [],
      value: image.options.srcUrl,
      onChange: newVal => {
        var options = { ...image.options,
          srcUrl: newVal.url
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
        setImageObj({ ...imageObj,
          src: newVal.url
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "p-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: "font-bold"
    }, "Image Source URL:"), " ", image.options.srcUrl.length != 0 ? image.options.srcUrl : 'No link', " "))))), image.options.imgSrcType == 'imgId' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Image ID"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: image.options.imgSrcImgId,
      onChange: newVal => {
        var options = { ...image.options,
          imgSrcImgId: newVal
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      }
    })), (image.options.imgSrcType == 'media' || image.options.imgSrcType == 'customField') && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Thumbnail Size"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_16__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: imageSizes,
      buttonTitle: "Choose",
      onChange: setFeaturedImageSize,
      values: image.options.size[breakPointX]
    })), image.options.size[breakPointX] != undefined && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "bg-gray-400 text-white px-3 py-2 my-3"
    }, " ", image.options.size[breakPointX])), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", null, "Link To"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_16__["default"], {
      position: "bottom right",
      variant: "secondary",
      buttonTitle: image.options.linkTo.length == 0 ? 'Choose' : linkToArgs[image.options.linkTo].label,
      options: linkToArgs,
      onChange: (option, index) => {
        var options = { ...image.options,
          linkTo: option.value
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      },
      values: ""
    })), image.options.linkTo == 'customField' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Field Key"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: image.options.linkToMetaKey,
      onChange: newVal => {
        var options = { ...image.options,
          linkToMetaKey: newVal
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      }
    })), image.options.linkTo == 'customUrl' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom URL"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: linkPickerPosttitle ? "!bg-gray-400" : '',
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
      onClick: ev => {
        setLinkPickerPosttitle(prev => !prev);
      }
    }), image.options.linkTocustomUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: "!text-red-500 ml-2",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
      onClick: ev => {
        var options = { ...image.options,
          linkTocustomUrl: ''
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
        setLinkPickerPosttitle(false);
      }
    }), linkPickerPosttitle && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Popover, {
      position: "bottom right"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.__experimentalLinkControl, {
      settings: [],
      value: image.options.linkTocustomUrl,
      onChange: newVal => {
        var options = { ...image.options,
          linkTocustomUrl: newVal.url
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "p-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: "font-bold"
    }, "Linked to:"), " ", image.options.linkTocustomUrl.length != 0 ? image.options.linkTocustomUrl : 'No link', " ")))), image.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", null, "Custom Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_16__["default"], {
      position: "bottom right",
      variant: "secondary",
      buttonTitle: image.options.tag.length == 0 ? 'Choose' : customTagArgs[image.options.tag].label,
      options: customTagArgs,
      onChange: (option, index) => {
        var options = { ...image.options,
          tag: option.value
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      },
      values: ""
    })), image.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Link Target"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: image.options.linkTarget,
      options: [{
        label: 'Choose...',
        value: ''
      }, {
        label: '_self',
        value: '_self'
      }, {
        label: '_blank',
        value: '_blank'
      }, {
        label: '_parent',
        value: '_parent'
      }, {
        label: '_top',
        value: '_top'
      }],
      onChange: newVal => {
        var options = { ...image.options,
          linkTarget: newVal
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Attributes"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: " cursor-pointer px-3 text-white py-1 bg-blue-600",
      onClick: ev => {
        var sdsd = image.options.linkAttr.concat({
          id: '',
          val: ''
        });
        var options = { ...image.options,
          linkAttr: sdsd
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
        linkAttrObj();
      }
    }, "Add")), image.options.linkAttr.map((x, i) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
        className: "my-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        placeholder: "Name",
        className: "mr-2",
        value: image.options.linkAttr[i].id,
        onChange: newVal => {
          image.options.linkAttr[i].id = newVal;
          var ssdsd = image.options.linkAttr.concat([]);
          var options = { ...image.options,
            linkAttr: ssdsd
          };
          setAttributes({
            image: { ...image,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Value",
        value: x.val,
        onChange: newVal => {
          image.options.linkAttr[i].val = newVal;
          var ssdsd = image.options.linkAttr.concat([]);
          var options = { ...image.options,
            linkAttr: ssdsd
          };
          setAttributes({
            image: { ...image,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
        className: "text-lg cursor-pointer px-3 text-white py-1 bg-red-400 icon-close",
        onClick: ev => {
          image.options.linkAttr.splice(i, 1);
          var ssdsd = image.options.linkAttr.concat([]);
          var options = { ...image.options,
            linkAttr: ssdsd
          };
          setAttributes({
            image: { ...image,
              options: options
            }
          });
        }
      })));
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", null, "Alt Text Source"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_16__["default"], {
      position: "bottom right",
      variant: "secondary",
      buttonTitle: image.options.altTextSrc.length == 0 ? 'Choose' : altTextSrcArgs[image.options.altTextSrc].label,
      options: altTextSrcArgs,
      onChange: (option, index) => {
        var options = { ...image.options,
          altTextSrc: option.value
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      },
      values: ""
    })), image.options.altTextSrc == 'customField' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", null, "Custom Field"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_16__["default"], {
      position: "bottom right",
      variant: "secondary",
      buttonTitle: 'Choose',
      options: [{
        label: 'Custom',
        value: ''
      }, {
        label: 'Yoast meta',
        value: '_yoast_wpseo_metadesc'
      }, {
        label: 'Rank Math meta',
        value: 'rank_math_description'
      }, {
        label: 'AIO SEO meta',
        value: '_aioseo_og_description'
      }, {
        label: 'SEOPress meta',
        value: '_seopress_titles_desc'
      }, {
        label: 'WP Meta SEO meta',
        value: '_metaseo_metadesc'
      }, {
        label: 'The SEO Framework meta',
        value: '_genesis_description'
      }, {
        label: 'SEO SIMPLE PACK meta',
        value: 'ssp_meta_description'
      }],
      onChange: (option, index) => {
        var options = { ...image.options,
          altTextMetaKey: option.value
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      },
      values: ""
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Field Key"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: image.options.altTextMetaKey,
      onChange: newVal => {
        var options = { ...image.options,
          altTextMetaKey: newVal
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      }
    }))), image.options.altTextSrc == 'custom' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Alt Text"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: image.options.altTextCustom,
      onChange: newVal => {
        var options = { ...image.options,
          altTextCustom: newVal
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: wrapper,
      onChange: onChangeStyleImage,
      onAdd: onAddStyleImage,
      onRemove: onRemoveStyleImage
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Title Wrapper"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, wrapperSelector, '{/* your CSS here*/}'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Title link"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, linkSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "px-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_14__["default"], {
      utm: {
        utm_source: 'BlockImage',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, loading && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Spinner, null), wrapper.options.useAsBackground == 'yes' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(CustomTag, {
      className: [blockId]
    }), !loading && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: [blockId]
    }, (image.options.imgSrcType == 'media' || image.options.imgSrcType == 'customField') && postImage == null && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Image Sources"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: image.options.imgSrcType,
      options: [{
        label: 'Media',
        value: 'media'
      }, {
        label: 'Custom Field',
        value: 'customField'
      }, {
        label: 'Image Source URL',
        value: 'customUrl'
      } // { label: 'Image ID', value: 'imgId' },
      ],
      onChange: newVal => {
        var options = { ...image.options,
          imgSrcType: newVal
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      }
    })), image.options.imgSrcType == 'media' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "mt-5",
      for: ""
    }, "Choose Image"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.MediaUploadCheck, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.MediaUpload, {
      class: "bg-blue-500",
      onSelect: media => {
        // media.id
        setCurrentPostImageId(media.id);
        var options = { ...image.options,
          srcUrl: media.url,
          srcId: media.id
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      },
      onClose: () => {},
      allowedTypes: ALLOWED_MEDIA_TYPES,
      value: image.options.srcId,
      render: _ref2 => {
        let {
          open
        } = _ref2;
        return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
          className: "my-3 bg-blue-500 text-white border border-solid border-gray-300 text-center w-full",
          onClick: open
        }, "Open Media Library");
      }
    }))), image.options.imgSrcType == 'customField' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Field Key"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: image.options.imgSrcMetaKey,
      onChange: newVal => {
        var options = { ...image.options,
          imgSrcMetaKey: newVal
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Metakey Type"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: image.options.imgSrcMetaKeyType,
      options: [{
        label: 'ID',
        value: 'ID'
      }, {
        label: 'URL',
        value: 'URL'
      }],
      onChange: newVal => {
        var options = { ...image.options,
          imgSrcMetaKeyType: newVal
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
      }
    })))), image.options.imgSrcType == 'customUrl' && image.options.srcUrl.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, image.options.imgSrcType == 'customUrl' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Image URL"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: linkPickerSrcUrl ? "!bg-gray-400" : '',
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
      onClick: ev => {
        setlinkPickerSrcUrl(prev => !prev);
      }
    }), image.options.srcUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: "!text-red-500 ml-2",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
      onClick: ev => {
        var options = { ...image.options,
          srcUrl: ''
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
        setlinkPickerSrcUrl(false);
      }
    }), linkPickerSrcUrl && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Popover, {
      position: "bottom right"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.__experimentalLinkControl, {
      settings: [],
      value: image.options.srcUrl,
      onChange: newVal => {
        var options = { ...image.options,
          srcUrl: newVal.url
        };
        setAttributes({
          image: { ...image,
            options: options
          }
        });
        setImageObj({ ...imageObj,
          src: newVal.url
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "p-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: "font-bold"
    }, "Image Source URL:"), " ", image.options.srcUrl.length != 0 ? image.options.srcUrl : 'No link', " "))))))), wrapper.options.useAsBackground == 'no' && wrapper.options.tag && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(CustomTag, {
      className: [blockId]
    }, image.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("a", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      onClick: handleLinkClick
    }, linkAttrItems, {
      href: postUrl,
      target: image.options.linkTarget
    }), postImage != null && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("img", {
      src: postImage != null && postImage.media_details.sizes[image.options.size[breakPointX]] != undefined ? postImage.media_details.sizes[image.options.size[breakPointX]].source_url : '',
      alt: postImage.alt_text
    }), postImage != null && postImage.media_details.sizes[image.options.size[breakPointX]] == undefined && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, postImage != null && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("img", {
      src: postImage != null && postImage.guid.rendered != undefined ? postImage.guid.rendered : '',
      alt: postImage.alt_text
    }))), image.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (image.options.imgSrcType == 'media' || image.options.imgSrcType == 'customField') && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, postImage != null && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("img", {
      src: postImage != null && postImage.media_details.sizes[image.options.size[breakPointX]] != undefined ? postImage.media_details.sizes[image.options.size[breakPointX]].source_url : '',
      alt: postImage.alt_text
    }), postImage != null && postImage.media_details.sizes[image.options.size[breakPointX]] == undefined && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, postImage != null && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("img", {
      src: postImage != null && postImage.guid.rendered != undefined ? postImage.guid.rendered : '',
      alt: postImage.alt_text
    }))), image.options.imgSrcType == 'customUrl' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("img", {
      src: image.options.srcUrl,
      alt: image.options.altTextCustom
    }))), wrapper.options.useAsBackground == 'no' && wrapper.options.tag.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, image.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("a", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      onClick: handleLinkClick,
      className: [blockId]
    }, linkAttrItems, {
      href: postUrl,
      target: image.options.linkTarget
    }), postImage != null && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("img", {
      src: postImage != null && postImage.media_details.sizes[image.options.size[breakPointX]] != undefined ? postImage.media_details.sizes[image.options.size[breakPointX]].source_url : '',
      alt: postImage.alt_text
    }), postImage != null && postImage.media_details.sizes[image.options.size[breakPointX]] == undefined && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, postImage != null && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("img", {
      src: postImage != null && postImage.guid.rendered != undefined ? postImage.guid.rendered : '',
      alt: postImage.alt_text
    })))), wrapper.options.useAsBackground == 'no' && wrapper.options.tag.length == 0 && image.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, image.options.tag.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(CustomTagPostTitle, {
      className: blockId
    }, postImage != null && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("img", {
      src: postImage != null && postImage.media_details.sizes[image.options.size[breakPointX]] != undefined ? postImage.media_details.sizes[image.options.size[breakPointX]].source_url : '',
      alt: postImage.alt_text
    }), postImage != null && postImage.media_details.sizes[image.options.size[breakPointX]] == undefined && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, postImage != null && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("img", {
      src: postImage != null && postImage.guid.rendered != undefined ? postImage.guid.rendered : '',
      alt: postImage.alt_text
    }))), image.options.tag.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: blockId
    }, postImage != null && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("img", {
      src: postImage != null && postImage.media_details.sizes[image.options.size[breakPointX]] != undefined ? postImage.media_details.sizes[image.options.size[breakPointX]].source_url : '',
      alt: postImage.alt_text
    }), postImage != null && postImage.media_details.sizes[image.options.size[breakPointX]] == undefined && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, postImage != null && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("img", {
      src: postImage != null && postImage.guid.rendered != undefined ? postImage.guid.rendered : '',
      alt: postImage.alt_text
    })))))];
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/layer/index.js":
/*!***********************************!*\
  !*** ./src/blocks/layer/index.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");













const {
  RawHTML
} = wp.element;











var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)("post-grid/layer", {
  title: "Layer",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#2563eb',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      width: "24",
      height: "24",
      viewBox: "0 0 24 24",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      "fill-rule": "evenodd",
      "clip-rule": "evenodd",
      d: "M12 19.798L20.4452 14.1678C20.9047 13.8615 21.5256 13.9856 21.8319 14.4452C22.1164 14.8719 22.0297 15.4377 21.6479 15.7616L21.5546 15.8319L12.5547 21.8318C12.2561 22.0309 11.8772 22.053 11.5608 21.8982L11.4453 21.8318L2.4454 15.8319C1.98588 15.5256 1.8617 14.9047 2.16805 14.4452C2.45252 14.0185 3.00818 13.8809 3.45402 14.1087L3.55479 14.1678L12 19.798L20.4452 14.1678L12 19.798ZM12.5547 2.16795L21.5546 8.16788C22.1483 8.5637 22.1483 9.43615 21.5546 9.83197L12.5547 15.8319C12.2188 16.0558 11.7812 16.0558 11.4453 15.8319L2.4454 9.83197C1.85167 9.43615 1.85167 8.5637 2.4454 8.16788L11.4453 2.16795C11.7812 1.94402 12.2188 1.94402 12.5547 2.16795ZM12 4.20183L4.80285 8.99993L12 13.798L19.1971 8.99993L12 4.20183Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          content: '',
          tag: 'div',
          class: 'pg-layers'
        },
        styles: {
          color: {
            Desktop: ''
          },
          bgColor: {},
          position: {},
          zIndex: {},
          top: {},
          right: {},
          bottom: {},
          left: {}
        }
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var wrapper = attributes.wrapper;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType'];
    const [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(myStore.getBreakPoint());
    const [isLoading, setisLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [postGridData, setPostGridData] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(window.PostGridPluginData); // Wrapper CSS Class Selectors

    var wrapperSelector = blockClass;
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      }); //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      }); //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);
    var breakPointList = [{
      label: 'Select..',
      icon: '',
      value: ''
    }];

    for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"]) {
      var item = _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"][x];
      breakPointList.push({
        label: item.name,
        icon: item.icon,
        value: item.id
      });
    }

    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, wrapper);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ wrapper: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      // if (blockCssY.items[wrapperSelector] == undefined) {
      //   blockCssY.items[wrapperSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[wrapperSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[wrapperSelector][key] != undefined) {
      //   delete blockCssY.items[wrapperSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // sudoScourceX[key] = {};
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      //generateBlockCssY()
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    const colors = [{
      name: '9DD6DF',
      color: '#9DD6DF'
    }, {
      name: '18978F',
      color: '#18978F'
    }, {
      name: 'A084CF',
      color: '#A084CF'
    }, {
      name: 'DFBB9D',
      color: '#DFBB9D'
    }, {
      name: '774360',
      color: '#774360'
    }, {
      name: '3AB0FF',
      color: '#3AB0FF'
    }, {
      name: '51557E',
      color: '#51557E'
    }];
    const [setSome, setSomeState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)({});
    const [stateX, setStateX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('Old Value');
    const {
      __experimentalSetPreviewDeviceType: setPreviewDeviceType
    } = wp.data.dispatch('core/edit-post');

    function onChangeBreakPoint(x, index) {
      setPreviewDeviceType(x.value);
      var asdsdsd = wp.data.dispatch('postgrid-shop').setBreakPoint(x.value);
      asdsdsd.then(res => {
        setBreakPointX(res.breakpoint); //generateBlockCssY();

        myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      });
    }

    return [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.BlockControls, null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InspectorControls, {
      key: "general"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-3",
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_16__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_19__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_20__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: { ...wrapper,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_18__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Text "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, wrapperSelector, '{}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_13__["default"], {
      utm: {
        utm_source: 'BlockText',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    })))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: [blockId]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InnerBlocks, null)))];
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    var attributes = props.attributes;
    var wrapper = attributes.wrapper;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    const redBackground = {
      backgroundColor: '#d99',
      position: 'absolute'
    };
    const blockProps = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps.save({
      style: redBackground
    });
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InnerBlocks.Content, null); //return null;
  }
});

/***/ }),

/***/ "./src/blocks/layers/index.js":
/*!************************************!*\
  !*** ./src/blocks/layers/index.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");















const {
  RawHTML
} = wp.element;










var myStore = wp.data.select('postgrid-shop');

function SaveComponent() {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InnerBlocks.Content, null);
}

function EditComponent() {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    style: {
      backgroundColor: "#333",
      padding: "35px"
    }
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InnerBlocks, null));
}

(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)("post-grid/layers", {
  title: "Layers",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#2563eb',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      width: "24",
      height: "24",
      viewBox: "0 0 24 24",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: "M3 2V11.5H12.5V2H3ZM14.875 6.75V13.875H7.75V16.25H17.25V6.75H14.875ZM19.625 11.5V18.625H12.5V21H22V11.5H19.625Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          content: '',
          tag: 'div',
          class: 'pg-layers'
        },
        styles: {
          color: {
            Desktop: ''
          },
          bgColor: {},
          display: {},
          position: {},
          overflow: {}
        }
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var wrapper = attributes.wrapper;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType'];
    const [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(myStore.getBreakPoint());
    const [isLoading, setisLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [postGridData, setPostGridData] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(window.PostGridPluginData); // Wrapper CSS Class Selectors

    var wrapperSelector = blockClass;
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      }); //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      }); //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);
    var breakPointList = [{
      label: 'Select..',
      icon: '',
      value: ''
    }];

    for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"]) {
      var item = _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"][x];
      breakPointList.push({
        label: item.name,
        icon: item.icon,
        value: item.id
      });
    }

    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, wrapper);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ wrapper: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      // if (blockCssY.items[wrapperSelector] == undefined) {
      //   blockCssY.items[wrapperSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[wrapperSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[wrapperSelector][key] != undefined) {
      //   delete blockCssY.items[wrapperSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // sudoScourceX[key] = {};
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      //generateBlockCssY()
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    const colors = [{
      name: '9DD6DF',
      color: '#9DD6DF'
    }, {
      name: '18978F',
      color: '#18978F'
    }, {
      name: 'A084CF',
      color: '#A084CF'
    }, {
      name: 'DFBB9D',
      color: '#DFBB9D'
    }, {
      name: '774360',
      color: '#774360'
    }, {
      name: '3AB0FF',
      color: '#3AB0FF'
    }, {
      name: '51557E',
      color: '#51557E'
    }];
    const [setSome, setSomeState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)({});
    const [stateX, setStateX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('Old Value');
    const {
      __experimentalSetPreviewDeviceType: setPreviewDeviceType
    } = wp.data.dispatch('core/edit-post');

    function onChangeBreakPoint(x, index) {
      setPreviewDeviceType(x.value);
      var asdsdsd = wp.data.dispatch('postgrid-shop').setBreakPoint(x.value);
      asdsdsd.then(res => {
        setBreakPointX(res.breakpoint); //generateBlockCssY();

        myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      });
    }

    return [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.BlockControls, null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InspectorControls, {
      key: "general"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-3",
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_16__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_19__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_20__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: { ...wrapper,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_18__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Text "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, wrapperSelector, '{}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_13__["default"], {
      utm: {
        utm_source: 'BlockText',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    })))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: [blockId]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InnerBlocks, null)))];
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    var attributes = props.attributes;
    var wrapper = attributes.wrapper;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    const redBackground = {
      backgroundColor: '#ddd',
      position: 'relative'
    };
    const blockProps = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps.save({
      style: redBackground
    });
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InnerBlocks.Content, null); //return null;
  }
});

/***/ }),

/***/ "./src/blocks/list/index.js":
/*!**********************************!*\
  !*** ./src/blocks/list/index.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_css_display__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/css-display */ "./src/components/css-display/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");














const {
  RawHTML
} = wp.element;












var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)("post-grid/list", {
  title: "List",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#2563eb',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      width: "24",
      height: "24",
      viewBox: "0 0 24 24",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: "M4.71554 16.5689H7.43108C8.12739 16.5689 8.70128 17.0931 8.77972 17.7683L8.78885 17.9267V20.6422C8.78885 21.3386 8.26469 21.9124 7.58942 21.9909L7.43108 22H4.71554C4.01923 22 3.44534 21.4759 3.36691 20.8006L3.35777 20.6422V17.9267C3.35777 17.2304 3.88193 16.6565 4.5572 16.5781L4.71554 16.5689H7.43108H4.71554ZM21.0088 17.9267C21.7587 17.9267 22.3666 18.5346 22.3666 19.2845C22.3666 20.0344 21.7587 20.6422 21.0088 20.6422H12.8622C12.1123 20.6422 11.5044 20.0344 11.5044 19.2845C11.5044 18.5346 12.1123 17.9267 12.8622 17.9267H21.0088ZM7.43108 17.9267H4.71554V20.6422H7.43108V17.9267ZM7.43108 9.78007C8.18095 9.78007 8.78885 10.388 8.78885 11.1378V13.8534C8.78885 14.6032 8.18095 15.2111 7.43108 15.2111H4.71554C3.96567 15.2111 3.35777 14.6032 3.35777 13.8534V11.1378C3.35777 10.388 3.96567 9.78007 4.71554 9.78007H7.43108ZM21.0088 11.1378C21.7587 11.1378 22.3666 11.7457 22.3666 12.4956C22.3666 13.1919 21.8424 13.7658 21.1671 13.8442L21.0088 13.8534H12.8622C12.1123 13.8534 11.5044 13.2455 11.5044 12.4956C11.5044 11.7993 12.0286 11.2254 12.7038 11.147L12.8622 11.1378H21.0088ZM7.43108 11.1378H4.71554V13.8534H7.43108V11.1378ZM8.48289 3.29826C8.84442 3.65979 8.87728 4.22553 8.58149 4.62418L8.48289 4.73839L5.09616 8.12512C4.90519 8.31611 4.64617 8.42338 4.3761 8.42338C4.16004 8.42338 3.95105 8.35473 3.77832 8.22948L3.65603 8.12512L2.29826 6.76735C1.90058 6.36967 1.90058 5.72491 2.29826 5.32722C2.65979 4.96569 3.22552 4.93283 3.62418 5.22862L3.73839 5.32722L4.3761 5.96492L7.04276 3.29826C7.44044 2.90058 8.0852 2.90058 8.48289 3.29826V3.29826ZM21.0088 4.34899C21.7587 4.34899 22.3666 4.95689 22.3666 5.70676C22.3666 6.40306 21.8424 6.97696 21.1671 7.05539L21.0088 7.06453H12.8622C12.1123 7.06453 11.5044 6.45663 11.5044 5.70676C11.5044 5.01045 12.0286 4.43655 12.7038 4.35812L12.8622 4.34899H21.0088Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'ul',
          class: 'pg-accordion'
        },
        styles: {
          color: {
            Desktop: ''
          },
          bgColor: {},
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          display: {}
        }
      }
    },
    items: {
      type: 'array',
      default: [{
        text: '',
        icon: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'fas fa-chevron-right'
        },
        styles: {}
      }]
    },
    item: {
      type: 'object',
      default: {
        options: {
          text: '',
          tag: 'li',
          counter: false,
          reversed: false,
          start: 1,
          type: '1',
          class: 'item'
        },
        styles: {
          color: {
            Desktop: ''
          },
          bgColor: {},
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          display: {},
          listStyle: {},
          listStylePosition: {},
          listStyleType: {}
        }
      }
    },
    icon: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'fas fa-chevron-right',
          class: 'icon',
          positon: 'before'
        },
        styles: {
          color: {
            Desktop: ''
          },
          bgColor: {},
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          display: {},
          fontSize: {
            Desktop: ''
          },
          lineHeight: {},
          // { val: '18', unit: 'px' }
          fontWeight: {
            "Desktop": "700"
          },
          textDecoration: {} //overline, line-through, underline

        }
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var items = attributes.items;
    var wrapper = attributes.wrapper;
    var item = attributes.item;
    var icon = attributes.icon;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType'];
    const [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(myStore.getBreakPoint());
    const [isLoading, setisLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [postGridData, setPostGridData] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(window.PostGridPluginData);
    const [isOpen, setisOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false); // Wrapper CSS Class Selectors

    var wrapperSelector = blockClass;
    var itemSelector = blockClass + ' .item';
    const iconSelector = blockClass + ' .icon';
    const CustomTag = `${wrapper.options.tag}`;
    const CustomTagItem = `${item.options.tag}`;
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      }); //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      }); //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);
    var breakPointList = [{
      label: 'Select..',
      icon: '',
      value: ''
    }];

    for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"]) {
      var itemX = _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"][x];
      breakPointList.push({
        label: itemX.name,
        icon: itemX.icon,
        value: itemX.id
      });
    }

    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      var iconSrc = icon.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      setIconHtml(iconHtml);
    }, [icon]);

    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }

    function onChangeIcon(arg) {
      var options = { ...icon.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        icon: { ...icon,
          options: options
        }
      });
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = sudoScource + '.' + attr + '.' + breakPointX;
      let obj = Object.assign({}, wrapper);
      const updatedObj = myStore.setPropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: updatedObj
      });
      var sudoScourceX = { ...updatedObj[sudoScource]
      };
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      sudoScourceX[attr][breakPointX] = newVal;

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      Object.entries(sudoScourceX).map(args => {
        var argAttr = myStore.cssAttrParse(args[0]);
        var argAttrVal = args[1];
        blockCssY.items[elementSelector][argAttr] = argAttrVal;
      });
      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      // if (blockCssY.items[wrapperSelector] == undefined) {
      //   blockCssY.items[wrapperSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[wrapperSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[wrapperSelector][key] != undefined) {
      //   delete blockCssY.items[wrapperSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // sudoScourceX[key] = {};
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStyleItem(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, item);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        item: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, item);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ item: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleItem(sudoScource, key) {
      var object = myStore.deletePropertyDeep(item, [sudoScource, key, breakPointX]);
      setAttributes({
        item: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...item[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // item[sudoScource] = sudoScourceX;
      // setAttributes({ item: { ...item } });
      // if (blockCssY.items[itemSelector] == undefined) {
      //   blockCssY.items[itemSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[itemSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[itemSelector][key] != undefined) {
      //   delete blockCssY.items[itemSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleItem(sudoScource, key) {
      var sudoScourceX = { ...item[sudoScource]
      };
      sudoScourceX[key] = {};
      item[sudoScource] = sudoScourceX;
      setAttributes({
        item: { ...item
        }
      });
    }

    function onChangeStyleIcon(sudoScource, newVal, attr) {
      // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, icon);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ icon: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(icon, [sudoScource, key, breakPointX]);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...icon[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // icon[sudoScource] = sudoScourceX;
      // setAttributes({ icon: { ...icon } });
      // if (blockCssY.items[iconSelector] == undefined) {
      //   blockCssY.items[iconSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[iconSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[iconSelector][key] != undefined) {
      //   delete blockCssY.items[iconSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        icon: object
      });
    }

    function onChangeIconTypo(typoX) {
      setAttributes({
        icon: { ...icon,
          styles: typoX
        }
      });
      var newValuesObjX = {};
      var itemsX = blockCssY.items;

      if (typoX.fontSize[breakPointX] != undefined) {
        var fontSizeVal = typoX.fontSize[breakPointX].val ? typoX.fontSize[breakPointX].val : 16;
        var fontSizeUnit = typoX.fontSize[breakPointX].unit ? typoX.fontSize[breakPointX].unit : 'px';
        var fontSizeX = blockCssY.items[iconSelector] != undefined ? blockCssY.items[iconSelector]['font-size'] : {};
        fontSizeX[breakPointX] = fontSizeVal + fontSizeUnit; //blockCssY.items[iconSelector] = { ...blockCssY.items[iconSelector], 'font-size': fontSizeX };

        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'font-size': fontSizeX
        };
      }

      if (typoX.lineHeight[breakPointX] != undefined) {
        var lineHeightVal = typoX.lineHeight[breakPointX].val ? typoX.lineHeight[breakPointX].val : 16;
        var lineHeightUnit = typoX.lineHeight[breakPointX].unit ? typoX.lineHeight[breakPointX].unit : 'px';
        var lineHeightX = blockCssY.items[iconSelector]['line-height'] != undefined ? blockCssY.items[iconSelector]['line-height'] : {};
        lineHeightX[breakPointX] = lineHeightVal + lineHeightUnit; //blockCssY.items[iconSelector] = { ...blockCssY.items[iconSelector], 'line-height': lineHeightX };

        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'line-height': lineHeightX
        };
      }

      if (typoX.fontWeight[breakPointX] != undefined) {
        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'font-weight': typoX.fontWeight
        };
      }

      if (typoX.textDecoration[breakPointX] != undefined) {
        var str = {};
        var textDecorationX = typoX.textDecoration[breakPointX];
        var textDecorationXStr = textDecorationX.length > 0 ? textDecorationX.join(' ') : '';
        str[breakPointX] = textDecorationXStr;
        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'text-decoration': str
        };
      } //setAttributes({ blockCssY: { items: blockCssY.items } });


      setAttributes({
        blockCssY: {
          items: itemsX
        }
      });
    }

    function paddingControlHeader(nextValues) {
      var responsive = item.styles.padding;
      responsive[breakPointX] = nextValues;
      var styles = { ...item.styles,
        padding: responsive
      };
      setAttributes({
        item: { ...item,
          styles: styles
        }
      });
      var itemsX = { ...blockCssY.items
      };
      nextValues.top = nextValues.top == undefined ? '0px' : nextValues.top;
      nextValues.right = nextValues.right == undefined ? '0px' : nextValues.right;
      nextValues.bottom = nextValues.bottom == undefined ? '0px' : nextValues.bottom;
      nextValues.left = nextValues.left == undefined ? '0px' : nextValues.left;
      blockCssY.items[itemSelector] = blockCssY.items[itemSelector] != undefined ? blockCssY.items[itemSelector] : {};

      if (nextValues.top != undefined) {
        var paddingTop = blockCssY.items[itemSelector]['padding-top'] != undefined ? blockCssY.items[itemSelector]['padding-top'] : {};
        paddingTop[breakPointX] = nextValues.top;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'padding-top': paddingTop
        }; //itemsX[itemSelector] = { ...blockCssY.items[itemSelector], 'padding-top': paddingTop };
      }

      if (nextValues.right != undefined) {
        var paddingRight = blockCssY.items[itemSelector]['padding-right'] != undefined ? blockCssY.items[itemSelector]['padding-right'] : {};
        paddingRight[breakPointX] = nextValues.right;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'padding-right': paddingRight
        }; //itemsX[itemSelector] = { ...blockCssY.items[itemSelector], 'padding-right': paddingRight };
      }

      if (nextValues.bottom != undefined) {
        var paddingBottom = blockCssY.items[itemSelector]['padding-bottom'] != undefined ? blockCssY.items[itemSelector]['padding-bottom'] : {};
        paddingBottom[breakPointX] = nextValues.bottom;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'padding-bottom': paddingBottom
        }; //itemsX[itemSelector] = { ...blockCssY.items[itemSelector], 'padding-bottom': paddingBottom };
      }

      if (nextValues.left != undefined) {
        var paddingLeft = blockCssY.items[itemSelector]['padding-left'] != undefined ? blockCssY.items[itemSelector]['padding-left'] : {};
        paddingLeft[breakPointX] = nextValues.left;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'padding-left': paddingLeft
        }; //itemsX[itemSelector] = { ...blockCssY.items[itemSelector], 'padding-left': paddingLeft };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      }); //setAttributes({ blockCssY: { items: itemsX } });
    }

    function marginControlHeader(nextValues) {
      var responsive = item.styles.margin;
      responsive[breakPointX] = nextValues;
      var styles = { ...item.styles,
        margin: responsive
      };
      setAttributes({
        item: { ...item,
          styles: styles
        }
      });
      var itemsX = { ...blockCssY.items
      };
      nextValues.top = nextValues.top == undefined ? '0px' : nextValues.top;
      nextValues.right = nextValues.right == undefined ? '0px' : nextValues.right;
      nextValues.bottom = nextValues.bottom == undefined ? '0px' : nextValues.bottom;
      nextValues.left = nextValues.left == undefined ? '0px' : nextValues.left;
      blockCssY.items[itemSelector] = blockCssY.items[itemSelector] != undefined ? blockCssY.items[itemSelector] : {};

      if (nextValues.top != undefined) {
        var marginTop = blockCssY.items[itemSelector]['margin-top'] != undefined ? blockCssY.items[itemSelector]['margin-top'] : {};
        marginTop[breakPointX] = nextValues.top;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'margin-top': marginTop
        }; //itemsX[itemSelector] = { ...blockCssY.items[itemSelector], 'margin-top': marginTop };
      }

      if (nextValues.right != undefined) {
        var marginRight = blockCssY.items[itemSelector]['margin-right'] !== undefined ? blockCssY.items[itemSelector]['margin-right'] : {};
        marginRight[breakPointX] = nextValues.right;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'margin-right': marginRight
        }; //itemsX[itemSelector] = { ...blockCssY.items[itemSelector], 'margin-right': marginRight };
      }

      if (nextValues.bottom != undefined) {
        var marginBottom = blockCssY.items[itemSelector]['margin-bottom'] !== undefined ? blockCssY.items[itemSelector]['margin-bottom'] : {};
        marginBottom[breakPointX] = nextValues.bottom;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'margin-bottom': marginBottom
        }; //itemsX[itemSelector] = { ...blockCssY.items[itemSelector], 'margin-bottom': marginBottom };
      }

      if (nextValues.left != undefined) {
        var marginLeft = blockCssY.items[itemSelector]['margin-left'] !== undefined ? blockCssY.items[itemSelector]['margin-left'] : {};
        marginLeft[breakPointX] = nextValues.left;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'margin-left': marginLeft
        }; //itemsX[itemSelector] = { ...blockCssY.items[itemSelector], 'margin-left': marginLeft };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      }); //setAttributes({ blockCssY: { items: itemsX } });
    }

    function generateBlockCssY() {
      var reponsiveCssGroups = {};
      var reponsiveCss = '';

      for (var selector in blockCssY.items) {
        var attrs = blockCssY.items[selector];

        for (var attr in attrs) {
          var breakpoints = attrs[attr];

          for (var device in breakpoints) {
            var attrValue = breakpoints[device];

            if (reponsiveCssGroups[device] == undefined) {
              reponsiveCssGroups[device] = [];
            }

            if (reponsiveCssGroups[device][selector] == undefined) {
              reponsiveCssGroups[device][selector] = [];
            }

            reponsiveCssGroups[device][selector].push({
              'attr': attr,
              'val': attrValue
            });
          }
        }
      }

      if (reponsiveCssGroups['Mobile'] != undefined) {
        reponsiveCss += '@media only screen and (min-width: 0px) and (max-width: 360px){';

        for (var selector in reponsiveCssGroups['Mobile']) {
          var attrs = reponsiveCssGroups['Mobile'][selector];
          reponsiveCss += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCss += attrName + ':' + attrValue + ';';
          }

          reponsiveCss += '}';
        }

        reponsiveCss += '}';
      }

      if (reponsiveCssGroups['Tablet'] != undefined) {
        reponsiveCss += '@media only screen and (min-width: 361px) and (max-width: 780px){';

        for (var selector in reponsiveCssGroups['Tablet']) {
          var attrs = reponsiveCssGroups['Tablet'][selector];
          reponsiveCss += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCss += attrName + ':' + attrValue + ';';
          }

          reponsiveCss += '}';
        }

        reponsiveCss += '}';
      }

      if (reponsiveCssGroups['Desktop'] != undefined) {
        reponsiveCss += '@media only screen and (min-width: 781px){';

        for (var selector in reponsiveCssGroups['Desktop']) {
          var attrs = reponsiveCssGroups['Desktop'][selector];
          reponsiveCss += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCss += attrName + ':' + attrValue + ';';
          }

          reponsiveCss += '}';
        }

        reponsiveCss += '}';
      }

      var iframe = document.querySelectorAll('[name="editor-canvas"]')[0];

      if (iframe) {
        setTimeout(() => {
          var iframeDocument = iframe.contentDocument;
          var body = iframeDocument.body;
          var divWrap = iframeDocument.getElementById("css-block-" + blockId);

          if (divWrap != undefined) {
            iframeDocument.getElementById("css-block-" + blockId).outerHTML = "";
          }

          var divWrap = '<div id="css-block-' + blockId + '"></div>';
          body.insertAdjacentHTML('beforeend', divWrap);
          var csswrappg = iframeDocument.getElementById('css-block-' + blockId);
          var str = '<style>' + reponsiveCss + customCss + '</style>';
          csswrappg.insertAdjacentHTML('beforeend', str);
        }, 200);
      } else {
        var wpfooter = document.getElementById('wpfooter');
        var divWrap = document.getElementById("css-block-" + blockId);

        if (divWrap != undefined) {
          document.getElementById("css-block-" + blockId).outerHTML = "";
        }

        var divWrap = '<div id="css-block-' + blockId + '"></div>';
        wpfooter.insertAdjacentHTML('beforeend', divWrap);
        var csswrappg = document.getElementById('css-block-' + blockId);
        var str = '<style>' + reponsiveCss + customCss + '</style>';
        csswrappg.insertAdjacentHTML('beforeend', str);
      }
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      //generateBlockCssY()
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    const colors = [{
      name: '9DD6DF',
      color: '#9DD6DF'
    }, {
      name: '18978F',
      color: '#18978F'
    }, {
      name: 'A084CF',
      color: '#A084CF'
    }, {
      name: 'DFBB9D',
      color: '#DFBB9D'
    }, {
      name: '774360',
      color: '#774360'
    }, {
      name: '3AB0FF',
      color: '#3AB0FF'
    }, {
      name: '51557E',
      color: '#51557E'
    }];
    const [setSome, setSomeState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)({});
    const [stateX, setStateX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('Old Value');
    const {
      __experimentalSetPreviewDeviceType: setPreviewDeviceType
    } = wp.data.dispatch('core/edit-post');

    function onChangeBreakPoint(x, index) {
      setPreviewDeviceType(x.value);
      var asdsdsd = wp.data.dispatch('postgrid-shop').setBreakPoint(x.value);
      asdsdsd.then(res => {
        setBreakPointX(res.breakpoint); //generateBlockCssY();

        myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      });
    }

    return [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.BlockControls, null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InspectorControls, {
      key: "general"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-2",
      title: "Items",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'No Wrapper',
        value: ''
      }, {
        label: 'Ul',
        value: 'ul'
      }, {
        label: 'Ol',
        value: 'ol'
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'Span',
        value: 'SPAN'
      }, {
        label: 'Div',
        value: 'DIV'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: { ...wrapper,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_20__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Items",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: item.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'li',
        value: 'li'
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...item.options,
          tag: newVal
        };
        setAttributes({
          item: { ...item,
            options: options
          }
        });
      }
    })), wrapper.options.tag == 'ol' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.ToggleControl, {
      label: "Reversed?",
      help: item.options.reversed ? 'Counter reversed?' : 'No reversed',
      checked: item.options.reversed ? true : false,
      onChange: e => {
        var options = { ...item.options,
          reversed: item.options.reversed ? false : true
        };
        setAttributes({
          item: { ...item,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Counter start with"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
      value: item.options.start,
      onChange: newVal => {
        var options = { ...item.options,
          start: newVal
        };
        setAttributes({
          item: { ...item,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Ordered list type?"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: item.options.type,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'Decimal numbers (1, 2, 3, 4)',
        value: '1'
      }, {
        label: 'Alphabetically ordered list',
        value: 'a'
      }, {
        label: 'Alphabetically ordered list, uppercase',
        value: 'A'
      }, {
        label: 'Roman numbers, lowercase (i, ii, iii, iv)',
        value: 'i'
      }, {
        label: 'Roman numbers, uppercase (I, II, III, IV)',
        value: 'I'
      }],
      onChange: newVal => {
        var options = { ...item.options,
          type: newVal
        };
        setAttributes({
          item: { ...item,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "List style type?"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: item.styles.listStyleType[breakPointX],
      options: [{
        label: 'Select..',
        value: ''
      }, {
        label: 'disc',
        value: 'disc'
      }, {
        label: 'armenian',
        value: 'armenian'
      }, {
        label: 'circle',
        value: 'circle'
      }, {
        label: 'cjk-ideographic',
        value: 'cjk-ideographic'
      }, {
        label: 'decimal',
        value: 'decimal'
      }, {
        label: 'decimal-leading-zero',
        value: 'decimal-leading-zero'
      }, {
        label: 'georgian',
        value: 'georgian'
      }, {
        label: 'hebrew',
        value: 'hebrew'
      }, {
        label: 'hiragana',
        value: 'hiragana'
      }, {
        label: 'hiragana-iroha',
        value: 'hiragana-iroha'
      }, {
        label: 'katakana',
        value: 'katakana'
      }, {
        label: 'katakana-iroha',
        value: 'katakana-iroha'
      }, {
        label: 'lower-alpha',
        value: 'lower-alpha'
      }, {
        label: 'lower-greek',
        value: 'lower-greek'
      }, {
        label: 'lower-latin',
        value: 'lower-latin'
      }, {
        label: 'lower-roman',
        value: 'lower-roman'
      }, {
        label: 'square',
        value: 'square'
      }, {
        label: 'upper-alpha',
        value: 'upper-alpha'
      }, {
        label: 'upper-greek',
        value: 'upper-greek'
      }, {
        label: 'upper-latin',
        value: 'upper-latin'
      }, {
        label: 'upper-roman',
        value: 'upper-roman'
      }, {
        label: 'none',
        value: 'none'
      }],
      onChange: newVal => {
        var newValuesObj = {};

        if (Object.keys(item.styles.listStyleType).length == 0) {
          newValuesObj[breakPointX] = newVal;
        } else {
          newValuesObj = item.styles.listStyleType;
          newValuesObj[breakPointX] = newVal;
        }

        var styles = { ...item.styles,
          listStyleType: newValuesObj
        };
        setAttributes({
          item: { ...item,
            styles: styles
          }
        });
        var newValuesObjX = {};

        if (blockCssY.items[itemSelector] == undefined) {
          newValuesObjX[itemSelector] = { ...blockCssY.items[itemSelector],
            'list-style-type': newValuesObj
          };
        } else {
          newValuesObjX[itemSelector] = { ...blockCssY.items[itemSelector],
            'list-style-type': newValuesObj
          };
        }

        setAttributes({
          blockCssY: {
            items: newValuesObjX
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "List style position?"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: item.styles.listStylePosition[breakPointX],
      options: [{
        label: 'Select..',
        value: ''
      }, {
        label: 'inside',
        value: 'inside'
      }, {
        label: 'outside',
        value: 'outside'
      }],
      onChange: newVal => {
        var newValuesObj = {};

        if (Object.keys(item.styles.listStylePosition).length == 0) {
          newValuesObj[breakPointX] = newVal;
        } else {
          newValuesObj = item.styles.listStylePosition;
          newValuesObj[breakPointX] = newVal;
        }

        var styles = { ...item.styles,
          listStylePosition: newValuesObj
        };
        setAttributes({
          item: { ...item,
            styles: styles
          }
        });
        var newValuesObjX = {};

        if (blockCssY.items[itemSelector] == undefined) {
          newValuesObjX[itemSelector] = { ...blockCssY.items[itemSelector],
            'list-style-position': newValuesObj
          };
        } else {
          newValuesObjX[itemSelector] = { ...blockCssY.items[itemSelector],
            'list-style-position': newValuesObj
          };
        }

        setAttributes({
          blockCssY: {
            items: newValuesObjX
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_20__["default"], {
      obj: item,
      onChange: onChangeStyleItem,
      onAdd: onAddStyleItem,
      onRemove: onRemoveStyleItem
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_16__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: onChangeIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Icon postion"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: 'Choose...',
        value: ''
      }, {
        label: 'Left',
        value: 'left'
      }, {
        label: 'Before Text',
        value: 'before'
      }, {
        label: 'After Text',
        value: 'after'
      }, {
        label: 'Right',
        value: 'right'
      }],
      onChange: newVal => {
        var options = { ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_19__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_20__["default"], {
      obj: wrapper,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Text "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, wrapperSelector, '{}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_13__["default"], {
      utm: {
        utm_source: 'BlockText',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, wrapper.options.tag && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(CustomTag, {
      className: [blockId],
      reversed: item.options.reversed ? 'reversed' : '',
      start: item.options.start
    }, items.map((itemX, i) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(CustomTagItem, {
        className: ` cursor-pointer ${item.options.class}`,
        onClick: ev => {
          var ssdsd = items.concat([]);
          setAttributes({
            items: ssdsd
          });
        }
      }, icon.options.position == 'left' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "icon",
        dangerouslySetInnerHTML: {
          __html: iconHtml
        }
      })), icon.options.position == 'before' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "icon",
        dangerouslySetInnerHTML: {
          __html: iconHtml
        }
      })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.RichText, {
        tagName: "span",
        value: itemX.text,
        allowedFormats: ['core/bold', 'core/italic', 'core/link'],
        onChange: content => {
          console.log('#onChange');
          items[i].text = content;
          var ssdsd = items.concat([]);
          setAttributes({
            items: ssdsd
          });
        },
        placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Start Writing...')
      }), icon.options.position == 'after' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "icon",
        dangerouslySetInnerHTML: {
          __html: iconHtml
        }
      })), icon.options.position == 'right' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "icon float-right",
        dangerouslySetInnerHTML: {
          __html: iconHtml
        }
      })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "text-lg cursor-pointer px-2 text-red-500  py-1 float-right icon-close",
        onClick: ev => {
          items.splice(i, 1);
          var ssdsd = items.concat([]);
          setAttributes({
            items: ssdsd
          });
          ev.preventDefault();
        }
      })));
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: [blockId]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "bg-blue-500 p-2 px-5 text-white my-4 text-center cursor-pointer",
      onClick: ev => {
        var itemx = items.concat({
          text: '',
          icon: {
            library: 'fontAwesome',
            srcType: "class",

            /*class, html, img, svg */
            iconSrc: 'fas fa-chevron-right'
          },
          styles: {}
        });
        setAttributes({
          items: itemx
        });
      }
    }, "Add")))];
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/post-author-fields/index.js":
/*!************************************************!*\
  !*** ./src/blocks/post-author-fields/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link-off.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_css_display__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/css-display */ "./src/components/css-display/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
















const {
  RawHTML
} = wp.element;













var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__.registerBlockType)("post-grid/post-author-fields", {
  title: "Author Fields",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#2563eb',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      width: "500",
      height: "500",
      viewBox: "0 0 500 500",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: "M25 249.5C25 246.739 27.2386 244.5 30 244.5H470C472.761 244.5 475 246.739 475 249.5V299.5C475 302.261 472.761 304.5 470 304.5H30C27.2386 304.5 25 302.261 25 299.5V249.5Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: "M241 147C241 144.239 243.239 142 246 142H470C472.761 142 475 144.239 475 147V197C475 199.761 472.761 202 470 202H246C243.239 202 241 199.761 241 197V147Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: "M100 132.5C119.569 132.5 135.429 116.72 135.429 97.25C135.429 77.7799 119.569 62 100 62C80.4312 62 64.5714 77.7799 64.5714 97.25C64.5714 116.72 80.4312 132.5 100 132.5ZM124.8 141.312H120.178C114.033 144.121 107.196 145.719 100 145.719C92.8036 145.719 85.9946 144.121 79.8223 141.312H75.2C54.6625 141.312 38 157.891 38 178.325V189.781C38 197.079 43.9509 203 51.2857 203H148.714C156.049 203 162 197.079 162 189.781V178.325C162 157.891 145.337 141.312 124.8 141.312Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    field: {
      type: 'object',
      default: {
        options: {
          isLink: false,
          linkTo: 'postUrl',

          /*postUrl, homeUrl, authorUrl, authorLink, mailTo, custom */
          linkToMeta: '',
          linkTarget: '',
          avatarSize: '',
          dateFormat: '',
          customUrl: '',
          prefix: '',
          postfix: '',
          linkAttr: []
        },
        styles: {}
      }
    },
    icon: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: '',
          position: 'beforePostDate',

          /*before, after, prefix, postfix */
          class: 'icon'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          display: {},
          fontSize: {
            Desktop: ''
          },
          lineHeight: {},
          // { val: '18', unit: 'px' }
          fontWeight: {
            "Desktop": "700"
          },
          textDecoration: {} //overline, line-through, underline

        }
      }
    },
    metaKey: {
      "type": "string",
      "default": ''
    },
    frontText: {
      type: 'object',
      default: {
        options: {
          text: 'Author: ',
          class: 'inline-block'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          },
          lineHeight: {},
          // { val: '18', unit: 'px' }
          letterSpacing: {},
          // { val: '18', unit: 'px' }
          fontFamily: {},
          fontWeight: {},
          textDecoration: {},
          //overline, line-through, underline
          textTransform: {}
        }
      }
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var wrapper = attributes.wrapper;
    var frontText = attributes.frontText;
    var blockCssY = attributes.blockCssY;
    var customCss = attributes.customCss;
    var metaKey = attributes.metaKey;
    var field = attributes.field;
    var icon = attributes.icon;
    var postId = context['postId'];
    var postType = context['postType'];
    const [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(myStore.getBreakPoint());
    const [linkPickerPosttitle, setLinkPickerPosttitle] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    var userFields = [{
      label: "ID",
      key: 'id'
    }, {
      label: "login",
      key: 'login'
    }, {
      label: "Nick name",
      key: 'nickname'
    }, {
      label: "Email",
      key: 'email'
    }, {
      label: "URL",
      key: 'url'
    }, {
      label: "Registered",
      key: 'registered'
    }, {
      label: "Display name",
      key: 'display_name'
    }, {
      label: "First name",
      key: 'first_name'
    }, {
      label: "Last name",
      key: 'last_name'
    }, {
      label: "Description",
      key: 'description'
    }, // { label: "Avatar URL", key: 'avatar_url' },
    {
      label: "Avatar",
      key: 'avatar'
    } // { label: "Profile Link", key: 'link' },
    ];
    var linkToArgsBasic = {
      postUrl: {
        label: 'Post URL',
        value: 'postUrl'
      },
      homeUrl: {
        label: 'Home URL',
        value: 'homeUrl'
      },
      authorUrl: {
        label: 'Author URL',
        value: 'authorUrl'
      },
      authorLink: {
        label: 'Author Link',
        value: 'authorLink'
      },
      authorMail: {
        label: 'Author Mail',
        value: 'authorMail',
        isPro: true
      },
      authorMeta: {
        label: 'Author Meta',
        value: 'authorMeta',
        isPro: true
      },
      customField: {
        label: 'Custom Field',
        value: 'customField',
        isPro: true
      },
      customUrl: {
        label: 'Custom URL',
        value: 'customUrl',
        isPro: true
      }
    };
    let linkToArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__.applyFilters)('linkToArgs', linkToArgsBasic); // Wrapper CSS Class Selectors

    const wrapperSelector = blockClass;
    const fieldSelector = blockClass + ' .fieldVal';
    const frontTextSelector = blockClass + ' .frontText';
    const iconSelector = blockClass + ' .icon';
    var breakPointList = [];

    for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_9__["default"]) {
      var item = _breakpoints__WEBPACK_IMPORTED_MODULE_9__["default"][x];
      breakPointList.push({
        label: item.name,
        icon: item.icon,
        value: item.id
      });
    }

    const [postAuthorData, setpostAuthorData] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)([]); // Using the hook.

    const [loading, setLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false); // Using the hook.

    const [postAuthorX, setpostAuthorX] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_2__.useEntityProp)('postType', postType, 'author', postId);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      if (metaKey.length == 0) return;
      setpostAuthorData([]);
      setLoading(true);
      _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1___default()({
        path: '/post-grid/v2/get_user_data',
        method: 'POST',
        data: {
          id: postAuthorX,
          fields: []
        }
      }).then(res => {
        setpostAuthorData(res);
        setLoading(false);
      });
    }, [metaKey]);
    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      var iconSrc = icon.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      setIconHtml(iconHtml);
    }, [icon]);

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, wrapper);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ wrapper: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      // if (blockCssY.items[wrapperSelector] == undefined) {
      //   blockCssY.items[wrapperSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[wrapperSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[wrapperSelector][key] != undefined) {
      //   delete blockCssY.items[wrapperSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // sudoScourceX[key] = {};
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStyleField(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, field);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        field: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, fieldSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, field);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ field: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, fieldSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleField(sudoScource, key) {
      var object = myStore.deletePropertyDeep(field, [sudoScource, key, breakPointX]);
      setAttributes({
        field: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, fieldSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...field[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // field[sudoScource] = sudoScourceX;
      // setAttributes({ field: { ...field } });
      // if (blockCssY.items[fieldSelector] == undefined) {
      //   blockCssY.items[fieldSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[fieldSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[fieldSelector][key] != undefined) {
      //   delete blockCssY.items[fieldSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleField(sudoScource, key) {
      // var sudoScourceX = { ...field[sudoScource] }
      // sudoScourceX[key] = {};
      // field[sudoScource] = sudoScourceX;
      // setAttributes({ field: { ...field } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, field);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        field: object
      });
    }

    function onChangeStyleIcon(sudoScource, newVal, attr) {
      // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, icon);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ icon: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = iconSelector;
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(icon, [sudoScource, key, breakPointX]);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...icon[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // icon[sudoScource] = sudoScourceX;
      // setAttributes({ icon: { ...icon } });
      // if (blockCssY.items[iconSelector] == undefined) {
      //   blockCssY.items[iconSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[iconSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[iconSelector][key] != undefined) {
      //   delete blockCssY.items[iconSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        icon: object
      });
    }

    function onChangeStyleFrontText(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, frontText);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        frontText: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, frontTextSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, frontText);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ frontText: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = frontTextSelector;
      // var elementSelector = myStore.getElementSelector(sudoScource, frontTextSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleFrontText(sudoScource, key) {
      var object = myStore.deletePropertyDeep(frontText, [sudoScource, key, breakPointX]);
      setAttributes({
        frontText: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, frontTextSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...frontText[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // frontText[sudoScource] = sudoScourceX;
      // setAttributes({ frontText: { ...frontText } });
      // if (blockCssY.items[frontTextSelector] == undefined) {
      //   blockCssY.items[frontTextSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[frontTextSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[frontTextSelector][key] != undefined) {
      //   delete blockCssY.items[frontTextSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleFrontText(sudoScource, key) {
      // var sudoScourceX = { ...frontText[sudoScource] }
      // sudoScourceX[key] = {};
      // frontText[sudoScource] = sudoScourceX;
      // setAttributes({ frontText: { ...frontText } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, frontText);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        frontText: object
      });
    }

    function setFieldLinkTo(option, index) {
      var options = { ...field.options,
        linkTo: option.value
      };
      setAttributes({
        field: { ...field,
          options: options
        }
      });
    }

    function setUserField(option, index) {
      setAttributes({
        metaKey: option.key
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      }); //generateBlockCssY();

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [clientId]);

    function onChangeIcon(arg) {
      var options = { ...icon.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        icon: { ...icon,
          options: options
        }
      });
    }

    function onChangeIconTypo(typoX) {
      setAttributes({
        icon: { ...icon,
          styles: typoX
        }
      });
      var newValuesObjX = {};
      var itemsX = blockCssY.items;

      if (typoX.fontSize[breakPointX] != undefined) {
        var fontSizeVal = typoX.fontSize[breakPointX].val ? typoX.fontSize[breakPointX].val : 16;
        var fontSizeUnit = typoX.fontSize[breakPointX].unit ? typoX.fontSize[breakPointX].unit : 'px';
        var fontSizeX = blockCssY.items[iconSelector] != undefined ? blockCssY.items[iconSelector]['font-size'] : {};
        fontSizeX[breakPointX] = fontSizeVal + fontSizeUnit; //blockCssY.items[iconSelector] = { ...blockCssY.items[iconSelector], 'font-size': fontSizeX };

        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'font-size': fontSizeX
        };
      }

      if (typoX.lineHeight[breakPointX] != undefined) {
        var lineHeightVal = typoX.lineHeight[breakPointX].val ? typoX.lineHeight[breakPointX].val : 16;
        var lineHeightUnit = typoX.lineHeight[breakPointX].unit ? typoX.lineHeight[breakPointX].unit : 'px';
        var lineHeightX = blockCssY.items[iconSelector]['line-height'] != undefined ? blockCssY.items[iconSelector]['line-height'] : {};
        lineHeightX[breakPointX] = lineHeightVal + lineHeightUnit; //blockCssY.items[iconSelector] = { ...blockCssY.items[iconSelector], 'line-height': lineHeightX };

        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'line-height': lineHeightX
        };
      }

      if (typoX.fontWeight[breakPointX] != undefined) {
        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'font-weight': typoX.fontWeight
        };
      }

      if (typoX.textDecoration[breakPointX] != undefined) {
        var str = {};
        var textDecorationX = typoX.textDecoration[breakPointX];
        var textDecorationXStr = textDecorationX.length > 0 ? textDecorationX.join(' ') : '';
        str[breakPointX] = textDecorationXStr;
        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'text-decoration': str
        };
      } //setAttributes({ blockCssY: { items: blockCssY.items } });


      setAttributes({
        blockCssY: {
          items: itemsX
        }
      });
    }

    function paddingControlItems(nextValues) {
      var responsive = field.styles.padding;
      responsive[breakPointX] = nextValues;
      var styles = { ...field.styles,
        padding: responsive
      };
      setAttributes({
        field: { ...field,
          styles: styles
        }
      });
      blockCssY.items[fieldSelector] = blockCssY.items[fieldSelector] != undefined ? blockCssY.items[fieldSelector] : {};
      nextValues.top = nextValues.top == undefined ? '0px' : nextValues.top;
      nextValues.right = nextValues.right == undefined ? '0px' : nextValues.right;
      nextValues.bottom = nextValues.bottom == undefined ? '0px' : nextValues.bottom;
      nextValues.left = nextValues.left == undefined ? '0px' : nextValues.left;

      if (nextValues.top != undefined) {
        var paddingTop = blockCssY.items[fieldSelector]['padding-top'] != undefined ? blockCssY.items[fieldSelector]['padding-top'] : {};
        paddingTop[breakPointX] = nextValues.top;
        blockCssY.items[fieldSelector] = { ...blockCssY.items[fieldSelector],
          'padding-top': paddingTop
        };
      }

      if (nextValues.right != undefined) {
        var paddingRight = blockCssY.items[fieldSelector]['padding-right'] != undefined ? blockCssY.items[fieldSelector]['padding-right'] : {};
        paddingRight[breakPointX] = nextValues.right;
        blockCssY.items[fieldSelector] = { ...blockCssY.items[fieldSelector],
          'padding-right': paddingRight
        };
      }

      if (nextValues.bottom != undefined) {
        var paddingBottom = blockCssY.items[fieldSelector]['padding-bottom'] != undefined ? blockCssY.items[fieldSelector]['padding-bottom'] : {};
        paddingBottom[breakPointX] = nextValues.bottom;
        blockCssY.items[fieldSelector] = { ...blockCssY.items[fieldSelector],
          'padding-bottom': paddingBottom
        };
      }

      if (nextValues.left != undefined) {
        var paddingLeft = blockCssY.items[fieldSelector]['padding-left'] != undefined ? blockCssY.items[fieldSelector]['padding-left'] : {};
        paddingLeft[breakPointX] = nextValues.left;
        blockCssY.items[fieldSelector] = { ...blockCssY.items[fieldSelector],
          'padding-left': paddingLeft
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function marginControlItems(nextValues) {
      var responsive = field.styles.margin;
      responsive[breakPointX] = nextValues;
      var styles = { ...field.styles,
        margin: responsive
      };
      setAttributes({
        field: { ...field,
          styles: styles
        }
      });
      nextValues.top = nextValues.top == undefined ? '0px' : nextValues.top;
      nextValues.right = nextValues.right == undefined ? '0px' : nextValues.right;
      nextValues.bottom = nextValues.bottom == undefined ? '0px' : nextValues.bottom;
      nextValues.left = nextValues.left == undefined ? '0px' : nextValues.left;
      blockCssY.items[fieldSelector] = blockCssY.items[fieldSelector] != undefined ? blockCssY.items[fieldSelector] : {};

      if (nextValues.top != undefined) {
        var marginTop = blockCssY.items[fieldSelector]['margin-top'] != undefined ? blockCssY.items[fieldSelector]['margin-top'] : {};
        marginTop[breakPointX] = nextValues.top;
        blockCssY.items[fieldSelector] = { ...blockCssY.items[fieldSelector],
          'margin-top': marginTop
        };
      }

      if (nextValues.right != undefined) {
        var marginRight = blockCssY.items[fieldSelector]['margin-right'] !== undefined ? blockCssY.items[fieldSelector]['margin-right'] : {};
        marginRight[breakPointX] = nextValues.right;
        blockCssY.items[fieldSelector] = { ...blockCssY.items[fieldSelector],
          'margin-right': marginRight
        };
      }

      if (nextValues.bottom != undefined) {
        var marginBottom = blockCssY.items[fieldSelector]['margin-bottom'] !== undefined ? blockCssY.items[fieldSelector]['margin-bottom'] : {};
        marginBottom[breakPointX] = nextValues.bottom;
        blockCssY.items[fieldSelector] = { ...blockCssY.items[fieldSelector],
          'margin-bottom': marginBottom
        };
      }

      if (nextValues.left != undefined) {
        var marginLeft = blockCssY.items[fieldSelector]['margin-left'] !== undefined ? blockCssY.items[fieldSelector]['margin-left'] : {};
        marginLeft[breakPointX] = nextValues.left;
        blockCssY.items[fieldSelector] = { ...blockCssY.items[fieldSelector],
          'margin-left': marginLeft
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function onChangeTypo(typoX) {
      setAttributes({
        field: { ...field,
          styles: typoX
        }
      });

      if (typoX.fontFamily[breakPointX] != undefined) {
        blockCssY.items[fieldSelector] = { ...blockCssY.items[fieldSelector],
          'font-family': typoX.fontFamily
        };
      }

      if (typoX.fontSize[breakPointX] != undefined) {
        var fontSizeVal = typoX.fontSize[breakPointX].val ? typoX.fontSize[breakPointX].val : 16;
        var fontSizeUnit = typoX.fontSize[breakPointX].unit ? typoX.fontSize[breakPointX].unit : 'px';
        var fontSizeX = blockCssY.items[fieldSelector] != undefined ? blockCssY.items[fieldSelector]['font-size'] : {};
        fontSizeX[breakPointX] = fontSizeVal + fontSizeUnit;
        blockCssY.items[fieldSelector] = { ...blockCssY.items[fieldSelector],
          'font-size': fontSizeX
        };
      }

      if (typoX.lineHeight[breakPointX] != undefined) {
        var lineHeightVal = typoX.lineHeight[breakPointX].val ? typoX.lineHeight[breakPointX].val : 0;
        var lineHeightUnit = typoX.lineHeight[breakPointX].unit ? typoX.lineHeight[breakPointX].unit : 'px';
        var lineHeightX = blockCssY.items[fieldSelector]['line-height'] != undefined ? blockCssY.items[fieldSelector]['line-height'] : {};
        lineHeightX[breakPointX] = lineHeightVal + lineHeightUnit;
        blockCssY.items[fieldSelector] = { ...blockCssY.items[fieldSelector],
          'line-height': lineHeightX
        };
      }

      if (typoX.letterSpacing[breakPointX] != undefined) {
        var letterSpacingVal = typoX.letterSpacing[breakPointX].val ? typoX.letterSpacing[breakPointX].val : 0;
        var letterSpacingUnit = typoX.letterSpacing[breakPointX].unit ? typoX.letterSpacing[breakPointX].unit : 'px';
        var letterSpacingX = blockCssY.items[fieldSelector]['letter-spacing'] != undefined ? blockCssY.items[fieldSelector]['letter-spacing'] : {};
        letterSpacingX[breakPointX] = letterSpacingVal + letterSpacingUnit;
        blockCssY.items[fieldSelector] = { ...blockCssY.items[fieldSelector],
          'letter-spacing': letterSpacingX
        };
      }

      if (typoX.fontWeight[breakPointX] != undefined) {
        blockCssY.items[fieldSelector] = { ...blockCssY.items[fieldSelector],
          'font-weight': typoX.fontWeight
        };
      }

      if (typoX.textDecoration[breakPointX] != undefined) {
        var str = {};
        var textDecorationX = typoX.textDecoration[breakPointX];
        var textDecorationXStr = textDecorationX.length > 0 ? textDecorationX.join(' ') : '';
        str[breakPointX] = textDecorationXStr;
        blockCssY.items[fieldSelector] = { ...blockCssY.items[fieldSelector],
          'text-decoration': str
        };
      }

      if (typoX.textTransform[breakPointX] != undefined) {
        blockCssY.items[fieldSelector] = { ...blockCssY.items[fieldSelector],
          'text-transform': typoX.textTransform
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function onChangeTypoFrontText(typoX) {
      setAttributes({
        frontText: { ...frontText,
          styles: typoX
        }
      });

      if (typoX.fontFamily[breakPointX] != undefined) {
        blockCssY.items[frontTextSelector] = { ...blockCssY.items[frontTextSelector],
          'font-family': typoX.fontFamily
        };
      }

      if (typoX.fontSize[breakPointX] != undefined) {
        var fontSizeVal = typoX.fontSize[breakPointX].val ? typoX.fontSize[breakPointX].val : 16;
        var fontSizeUnit = typoX.fontSize[breakPointX].unit ? typoX.fontSize[breakPointX].unit : 'px';
        var fontSizeX = blockCssY.items[frontTextSelector]['font-size'] != undefined ? blockCssY.items[frontTextSelector]['font-size'] : {};
        fontSizeX[breakPointX] = fontSizeVal + fontSizeUnit;
        blockCssY.items[frontTextSelector] = { ...blockCssY.items[frontTextSelector],
          'font-size': fontSizeX
        };
      }

      if (typoX.lineHeight[breakPointX] != undefined) {
        var lineHeightVal = typoX.lineHeight[breakPointX].val ? typoX.lineHeight[breakPointX].val : 0;
        var lineHeightUnit = typoX.lineHeight[breakPointX].unit ? typoX.lineHeight[breakPointX].unit : 'px';
        var lineHeightX = blockCssY.items[frontTextSelector]['line-height'] != undefined ? blockCssY.items[frontTextSelector]['line-height'] : {};
        lineHeightX[breakPointX] = lineHeightVal + lineHeightUnit;
        blockCssY.items[frontTextSelector] = { ...blockCssY.items[frontTextSelector],
          'line-height': lineHeightX
        };
      }

      if (typoX.letterSpacing[breakPointX] != undefined) {
        var letterSpacingVal = typoX.letterSpacing[breakPointX].val ? typoX.letterSpacing[breakPointX].val : 0;
        var letterSpacingUnit = typoX.letterSpacing[breakPointX].unit ? typoX.letterSpacing[breakPointX].unit : 'px';
        var letterSpacingX = blockCssY.items[frontTextSelector]['letter-spacing'] != undefined ? blockCssY.items[frontTextSelector]['letter-spacing'] : {};
        letterSpacingX[breakPointX] = letterSpacingVal + letterSpacingUnit;
        blockCssY.items[frontTextSelector] = { ...blockCssY.items[frontTextSelector],
          'letter-spacing': letterSpacingX
        };
      }

      if (typoX.fontWeight[breakPointX] != undefined) {
        blockCssY.items[frontTextSelector] = { ...blockCssY.items[frontTextSelector],
          'font-weight': typoX.fontWeight
        };
      }

      if (typoX.textDecoration[breakPointX] != undefined) {
        var str = {};
        var textDecorationX = typoX.textDecoration[breakPointX];
        var textDecorationXStr = textDecorationX.length > 0 ? textDecorationX.join(' ') : '';
        str[breakPointX] = textDecorationXStr; //typoX.textDecoration[breakPointX] = typoX.textDecoration[breakPointX].join(' ');

        blockCssY.items[frontTextSelector] = { ...blockCssY.items[frontTextSelector],
          'text-decoration': str
        };
      }

      if (typoX.textTransform[breakPointX] != undefined) {
        blockCssY.items[frontTextSelector] = { ...blockCssY.items[frontTextSelector],
          'text-transform': typoX.textTransform
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function generateBlockCssY() {
      var reponsiveCssGroups = {};

      for (var selector in blockCssY.items) {
        var attrs = blockCssY.items[selector];

        for (var attr in attrs) {
          var breakpoints = attrs[attr];

          for (var device in breakpoints) {
            var attrValue = breakpoints[device];

            if (reponsiveCssGroups[device] == undefined) {
              reponsiveCssGroups[device] = [];
            }

            if (reponsiveCssGroups[device] == undefined) {
              reponsiveCssGroups[device] = [];
            }

            if (reponsiveCssGroups[device][selector] == undefined) {
              reponsiveCssGroups[device][selector] = [];
            }

            reponsiveCssGroups[device][selector].push({
              'attr': attr,
              'val': attrValue
            });
          }
        }
      } //return false;


      var reponsiveCssMobile = '';

      if (reponsiveCssGroups['Mobile'] != undefined) {
        reponsiveCssMobile += '@media only screen and (min-width: 0px) and (max-width: 360px){';

        for (var selector in reponsiveCssGroups['Mobile']) {
          var attrs = reponsiveCssGroups['Mobile'][selector];
          reponsiveCssMobile += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCssMobile += attrName + ':' + attrValue + ';';
          }

          reponsiveCssMobile += '}';
        }

        reponsiveCssMobile += '}';
      }

      var reponsiveCssTablet = '';

      if (reponsiveCssGroups['Tablet'] != undefined) {
        reponsiveCssTablet += '@media only screen and (min-width: 361px) and (max-width: 780px){';

        for (var selector in reponsiveCssGroups['Tablet']) {
          var attrs = reponsiveCssGroups['Tablet'][selector];
          reponsiveCssTablet += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCssTablet += attrName + ':' + attrValue + ';';
          }

          reponsiveCssTablet += '}';
        }

        reponsiveCssTablet += '}';
      }

      var reponsiveCssDesktop = '';

      if (reponsiveCssGroups['Desktop'] != undefined) {
        reponsiveCssDesktop += '@media only screen and (min-width: 781px){';

        for (var selector in reponsiveCssGroups['Desktop']) {
          var attrs = reponsiveCssGroups['Desktop'][selector];
          reponsiveCssDesktop += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCssDesktop += attrName + ':' + attrValue + ';';
          }

          reponsiveCssDesktop += '}';
        }

        reponsiveCssDesktop += '}';
      }

      var reponsiveCss = reponsiveCssMobile + reponsiveCssTablet + reponsiveCssDesktop;
      var iframe = document.querySelectorAll('[name="editor-canvas"]')[0];

      if (iframe) {
        setTimeout(() => {
          var iframeDocument = iframe.contentDocument;
          var body = iframeDocument.body;
          var divWrap = iframeDocument.getElementById("css-block-" + blockId);

          if (divWrap != undefined) {
            iframeDocument.getElementById("css-block-" + blockId).outerHTML = "";
          }

          var divWrap = '<div id="css-block-' + blockId + '"></div>';
          body.insertAdjacentHTML('beforeend', divWrap);
          var csswrappg = iframeDocument.getElementById('css-block-' + blockId);
          var str = '<style>' + reponsiveCss + customCss + '</style>';
          csswrappg.insertAdjacentHTML('beforeend', str);
        }, 200);
      } else {
        var wpfooter = document.getElementById('wpfooter');
        var divWrap = document.getElementById("css-block-" + blockId);

        if (divWrap != undefined) {
          document.getElementById("css-block-" + blockId).outerHTML = "";
        }

        var divWrap = '<div id="css-block-' + blockId + '"></div>';
        wpfooter.insertAdjacentHTML('beforeend', divWrap);
        var csswrappg = document.getElementById('css-block-' + blockId);
        var str = '<style>' + reponsiveCss + customCss + '</style>';
        csswrappg.insertAdjacentHTML('beforeend', str);
      }
    }

    var [linkAttrItems, setlinkAttrItems] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)({}); // Using the hook.

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      //generateBlockCssY()
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      linkAttrObj(); //generateBlockCssY();

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [field]);

    var linkAttrObj = () => {
      var sdsd = {};
      field.options.linkAttr.map(x => {
        if (x.val) sdsd[x.id] = x.val;
      });
      setlinkAttrItems(sdsd);
    };

    const colors = [{
      name: '9DD6DF',
      color: '#9DD6DF'
    }, {
      name: '18978F',
      color: '#18978F'
    }, {
      name: 'A084CF',
      color: '#A084CF'
    }, {
      name: 'DFBB9D',
      color: '#DFBB9D'
    }, {
      name: '774360',
      color: '#774360'
    }, {
      name: '3AB0FF',
      color: '#3AB0FF'
    }, {
      name: '51557E',
      color: '#51557E'
    }];
    const {
      __experimentalSetPreviewDeviceType: setPreviewDeviceType
    } = wp.data.dispatch('core/edit-post');
    const post = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_6__.useSelect)(select => select('core').getEntityRecord('postType', context['postType'], context['postId']));
    const termstaxonomy = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_6__.useSelect)(select => select('core').getEntityRecords('taxonomy', 'category', [4, 5]));

    function onChangeBreakPoint(x, index) {
      setPreviewDeviceType(x.value);
      var asdsdsd = wp.data.dispatch('postgrid-shop').setBreakPoint(x.value);
      asdsdsd.then(res => {
        setBreakPointX(res.breakpoint); //generateBlockCssY()

        myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      });
    }

    return [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.BlockControls, null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.InspectorControls, {
      key: "general"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Select User Field"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_15__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: userFields,
      buttonTitle: "Choose",
      onChange: setUserField,
      values: metaKey
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Custom Field"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: metaKey,
      onChange: newVal => {
        setAttributes({
          metaKey: newVal
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Class"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: wrapper.options.class,
      onChange: newVal => {
        var options = { ...wrapper.options,
          class: newVal
        };
        setAttributes({
          wrapper: { ...wrapper,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Field Settings",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'style',
        title: 'Style',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: "Is linked?",
      help: field.options != undefined && field.options.isLink ? 'User field is linked' : 'User field is not linked',
      checked: field.options != undefined && field.options.isLink ? true : false,
      onChange: e => {
        var options = { ...field.options,
          isLink: field.options.isLink ? false : true
        };
        setAttributes({
          field: { ...field,
            options: options
          }
        });
      }
    }), field.options.isLink && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Link To"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_15__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: linkToArgs,
      buttonTitle: "Choose",
      onChange: setFieldLinkTo,
      values: metaKey
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "bg-gray-500 p-2 my-3 text-white"
    }, linkToArgs[field.options.linkTo] != undefined ? linkToArgs[field.options.linkTo].label : ''), field.options.linkTo == 'authorMeta' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Author Meta Key"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: field.options.linkToMeta,
      onChange: newVal => {
        var options = { ...field.options,
          linkToMeta: newVal
        };
        setAttributes({
          field: { ...field,
            options: options
          }
        });
      }
    })), field.options.linkTo == 'customField' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Custom Meta Key"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: field.options.linkToAuthorMeta,
      onChange: newVal => {
        var options = { ...field.options,
          linkToAuthorMeta: newVal
        };
        setAttributes({
          field: { ...field,
            options: options
          }
        });
      }
    })), field.options.linkTo == 'customUrl' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Custom Url"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: linkPickerPosttitle ? "!bg-gray-400" : '',
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
      onClick: ev => {
        setLinkPickerPosttitle(prev => !prev);
      }
    }), field.options.customUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: "!text-red-500 ml-2",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
      onClick: ev => {
        var options = { ...field.options,
          customUrl: ''
        };
        setAttributes({
          field: { ...field,
            options: options
          }
        });
        setLinkPickerPosttitle(false);
      }
    }), linkPickerPosttitle && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Popover, {
      position: "bottom right"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.__experimentalLinkControl, {
      settings: [],
      value: field.options.customUrl,
      onChange: newVal => {
        var options = { ...field.options,
          customUrl: newVal.url
        };
        setAttributes({
          field: { ...field,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "p-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "font-bold"
    }, "Linked to:"), " ", field.options.customUrl.length != 0 ? field.options.customUrl : 'No link', " "))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Link Target"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: field.options.linkTarget,
      options: [{
        label: '_self',
        value: '_self'
      }, {
        label: '_blank',
        value: '_blank'
      }, {
        label: '_parent',
        value: '_parent'
      }, {
        label: '_top',
        value: '_top'
      }],
      onChange: newVal => {
        var options = { ...field.options,
          linkTarget: newVal
        };
        setAttributes({
          field: { ...field,
            options: options
          }
        });
      }
    }))), field.options.linkTo == 'custom' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Custom URL"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: field.options.customUrl,
      onChange: newVal => {
        var options = { ...field.options,
          customUrl: newVal
        };
        setAttributes({
          field: { ...field,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Prefix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: field.options.prefix,
      onChange: newVal => {
        var options = { ...field.options,
          prefix: newVal
        };
        setAttributes({
          field: { ...field,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Postfix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: field.options.postfix,
      onChange: newVal => {
        var options = { ...field.options,
          postfix: newVal
        };
        setAttributes({
          field: { ...field,
            options: options
          }
        });
      }
    })), field.options.isLink && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Link Attributes"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: " cursor-pointer px-3 text-white py-1 bg-blue-600",
      onClick: ev => {
        var sdsd = field.options.linkAttr.concat({
          id: '',
          val: ''
        });
        var options = { ...field.options,
          linkAttr: sdsd
        };
        setAttributes({
          field: { ...field,
            options: options
          }
        });
        linkAttrObj();
      }
    }, "Add")), field.options.linkAttr.length > 0 && field.options.linkAttr.map((x, i) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "my-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        className: "mr-2",
        value: field.options.linkAttr[i].id,
        onChange: newVal => {
          field.options.linkAttr[i].id = newVal;
          var ssdsd = field.options.linkAttr.concat([]);
          var options = { ...field.options,
            linkAttr: ssdsd
          };
          setAttributes({
            field: { ...field,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        className: "mr-2",
        value: x.val,
        onChange: newVal => {
          field.options.linkAttr[i].val = newVal;
          var ssdsd = field.options.linkAttr.concat([]);
          var options = { ...field.options,
            linkAttr: ssdsd
          };
          setAttributes({
            field: { ...field,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "text-lg cursor-pointer px-3 text-white py-1 bg-red-400 icon-close",
        onClick: ev => {
          field.options.linkAttr.splice(i, 1);
          var ssdsd = field.options.linkAttr.concat([]);
          var options = { ...field.options,
            linkAttr: ssdsd
          };
          setAttributes({
            field: { ...field,
              options: options
            }
          });
        }
      })));
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "style"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
      obj: field,
      onChange: onChangeStyleField,
      onAdd: onAddStyleField,
      onRemove: onRemoveStyleField
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "animation"
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_18__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: onChangeIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Icon postion"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: 'Choose Position',
        value: ''
      }, {
        label: 'Before Front text',
        value: 'beforeFronttext'
      }, {
        label: 'After Front text',
        value: 'afterFronttext'
      }, {
        label: 'Before Field',
        value: 'beforeField'
      }, {
        label: 'After Field',
        value: 'afterField'
      }],
      onChange: newVal => {
        var options = { ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
      obj: wrapper,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Front Text",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Front Text"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: frontText.options.text,
      onChange: newVal => {
        var options = { ...frontText.options,
          text: newVal
        };
        setAttributes({
          frontText: { ...frontText,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
      obj: wrapper,
      onChange: onChangeStyleFrontText,
      onAdd: onAddStyleFrontText,
      onRemove: onRemoveStyleFrontText
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Wrapper"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, wrapperSelector, '{/* your CSS here*/}'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Field Selector"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, fieldSelector, '{}', " ")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, ".pg-postAuthor a", '{/* your CSS here*/}'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Front Text"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, frontTextSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_19__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_20__["default"], {
      utm: {
        utm_source: 'BlockPostTitle',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, metaKey.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Select User Field"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_15__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: userFields,
      buttonTitle: "Choose",
      onChange: setUserField,
      values: metaKey
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Custom Field"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: metaKey,
      onChange: newVal => {
        setAttributes({
          metaKey: newVal
        });
      }
    }))), loading && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Spinner, null), metaKey.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: [blockId]
    }, icon.options.position == 'beforeFronttext' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), frontText.options.text.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "frontText"
    }, frontText.options.text), icon.options.position == 'afterFronttext' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), icon.options.position == 'beforeField' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), !field.options.isLink && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, field.options.prefix.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "prefix"
    }, field.options.prefix), metaKey == 'avatar' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      className: "fieldVal",
      src: postAuthorData['avatar_url'],
      alt: postAuthorData['display_name']
    }), metaKey != 'avatar' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "fieldVal"
    }, postAuthorData[metaKey]), field.options.postfix.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "postfix"
    }, field.options.postfix)), field.options.isLink && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      href: "#",
      target: field.options.linkTarget
    }, field.options.prefix.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "prefix"
    }, field.options.prefix), metaKey == 'avatar' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      className: "fieldVal",
      src: postAuthorData['avatar_url'],
      alt: postAuthorData['display_name']
    }), metaKey != 'avatar' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "fieldVal"
    }, postAuthorData[metaKey]), field.options.postfix.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "postfix"
    }, field.options.postfix)), icon.options.position == 'afterField' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })))];
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/post-author/index.js":
/*!*****************************************!*\
  !*** ./src/blocks/post-author/index.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link-off.js");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_css_display__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/css-display */ "./src/components/css-display/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
















const {
  RawHTML
} = wp.element;












var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)("post-grid/post-author", {
  title: "Post Author",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#2563eb',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      width: "500",
      height: "500",
      viewBox: "0 0 500 500",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: "M25 249.5C25 246.739 27.2386 244.5 30 244.5H470C472.761 244.5 475 246.739 475 249.5V299.5C475 302.261 472.761 304.5 470 304.5H30C27.2386 304.5 25 302.261 25 299.5V249.5Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: "M25 355.5C25 352.739 27.2386 350.5 30 350.5H470C472.761 350.5 475 352.739 475 355.5V405.5C475 408.261 472.761 410.5 470 410.5H30C27.2386 410.5 25 408.261 25 405.5V355.5Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: "M241 147C241 144.239 243.239 142 246 142H470C472.761 142 475 144.239 475 147V197C475 199.761 472.761 202 470 202H246C243.239 202 241 199.761 241 197V147Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: "M100 132.5C119.569 132.5 135.429 116.72 135.429 97.25C135.429 77.7799 119.569 62 100 62C80.4312 62 64.5714 77.7799 64.5714 97.25C64.5714 116.72 80.4312 132.5 100 132.5ZM124.8 141.312H120.178C114.033 144.121 107.196 145.719 100 145.719C92.8036 145.719 85.9946 144.121 79.8223 141.312H75.2C54.6625 141.312 38 157.891 38 178.325V189.781C38 197.079 43.9509 203 51.2857 203H148.714C156.049 203 162 197.079 162 189.781V178.325C162 157.891 145.337 141.312 124.8 141.312Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    elements: {
      "type": "object",
      "default": {
        items: [{
          id: 'avatar',
          label: "Avatar"
        }, {
          id: 'name',
          label: "Name"
        }, {
          id: 'description',
          label: "Description"
        }]
      } // avatar, name, description, id

    },
    avatar: {
      "type": "object",
      "default": {
        options: {
          class: 'avatar',
          size: '48',
          default: ''
        },
        styles: {
          display: {},
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          verticalAlign: {},
          borderRadius: {}
        }
      }
    },
    name: {
      "type": "object",
      "default": {
        options: {
          class: 'name',
          prefix: '',
          postfix: '',
          linkTo: '',
          linkToMeta: '',
          customUrl: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          verticalAlign: {},
          fontSize: {
            Desktop: ''
          }
        }
      }
    },
    description: {
      "type": "object",
      "default": {
        options: {
          class: 'description',
          prefix: '',
          postfix: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          verticalAlign: {},
          fontSize: {
            Desktop: ''
          },
          lineHeight: {},
          // { val: '18', unit: 'px' }
          letterSpacing: {},
          // { val: '18', unit: 'px' }
          fontFamily: {},
          fontWeight: {},
          textDecoration: {},
          //overline, line-through, underline
          textTransform: {}
        }
      }
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    linkAttr: {
      "type": "array",
      "default": []
    },
    blockCss: {
      "type": "object",
      "default": {
        items: {}
      }
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var wrapper = attributes.wrapper;
    var elements = attributes.elements;
    var avatar = attributes.avatar;
    var description = attributes.description;
    var name = attributes.name;
    var linkAttr = attributes.linkAttr;
    var blockCss = attributes.blockCss;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType'];
    var wrapperSelector = blockClass; // Wrapper CSS Class Selectors

    var nameSelector = blockClass + ' .name';
    var descriptionSelector = blockClass + ' .description';
    var avatarSelector = blockClass + ' .avatar';
    var avatarImgSelector = blockClass + ' .avatar img';
    var [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(myStore.getBreakPoint());
    var [postAuthor, setPostAuthor] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)({});
    var [html, setHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)({});
    var [loading, setLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [linkPickerPosttitle, setLinkPickerPosttitle] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    var [postAuthorId, setPostAuthorId] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_6__.useEntityProp)('postType', postType, 'author', postId);
    var [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_6__.useEntityProp)('postType', postType, 'link', postId);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      }); //generateBlockCssY();

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
        path: '/wp/v2/users/' + postAuthorId,
        method: 'GET'
      }).then(res => {
        setPostAuthor(res);
      });
    }, [postAuthorId]);
    var linkToArgsBasic = {
      postUrl: {
        label: 'Post URL',
        value: 'postUrl'
      },
      homeUrl: {
        label: 'Home URL',
        value: 'homeUrl'
      },
      authorUrl: {
        label: 'Author URL',
        value: 'authorUrl'
      },
      authorLink: {
        label: 'Author Link',
        value: 'authorLink'
      },
      authorMail: {
        label: 'Author Mail',
        value: 'authorMail',
        isPro: true
      },
      authorMeta: {
        label: 'Author Meta',
        value: 'authorMeta',
        isPro: true
      },
      customField: {
        label: 'Custom Field',
        value: 'customField',
        isPro: true
      },
      customUrl: {
        label: 'Custom URL',
        value: 'customUrl',
        isPro: true
      }
    };
    let linkToArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__.applyFilters)('linkToArgs', linkToArgsBasic);
    var userFields = [{
      id: 'avatar',
      label: "Avatar"
    }, {
      id: 'name',
      label: "Name"
    }, {
      id: 'description',
      label: "Description"
    }];

    function setUserField(option, index) {
      //var isExist = elements.items.find(x => x.label === option.label);
      //if (isExist == undefined) {
      //}
      var elementsX = elements.items.push(option);
      setAttributes({
        elements: {
          items: elements.items
        }
      });
    }

    function generatehtml() {
      var nameHtml = postAuthor.name != undefined ? `<span className='prefix'>${name.options.prefix}</span>${postAuthor.name}<span className='postfix'>${name.options.postfix}</span>` : 'Author Name 1';

      if (name.options.linkTo == 'postUrl') {
        nameHtml = `<span className='prefix'>${name.options.prefix}</span><a href="${currentPostUrl}">${postAuthor.name != undefined ? postAuthor.name : 'Author Name'}</a><span className='postfix'>${name.options.postfix}</span>`;
      }

      if (name.options.linkTo == 'authorUrl') {
        nameHtml = `<span className='prefix'>${name.options.prefix}</span><a href="${postAuthor.url}">${postAuthor.name != undefined ? postAuthor.name : 'Author Name'}</a><span className='postfix'>${name.options.postfix}</span>`;
      }

      if (name.options.linkTo == 'authorLink') {
        nameHtml = `<span className='prefix'>${name.options.prefix}</span><a href="${postAuthor.link}">${postAuthor.name != undefined ? postAuthor.name : 'Author Name'}</a><span className='postfix'>${name.options.postfix}</span>`;
      }

      if (name.options.linkTo == 'authorMeta') {
        nameHtml = `<span className='prefix'>${name.options.prefix}</span><a href="${postAuthor.link}">${postAuthor.name != undefined ? postAuthor.name : 'Author Name'}</a><span className='postfix'>${name.options.postfix}</span>`;
      }

      if (name.options.linkTo == 'customUrl') {
        nameHtml = `<span className='prefix'>${name.options.prefix}</span><a href="${name.options.customUrl}">${postAuthor.name != undefined ? postAuthor.name : 'Author Name'}</a><span className='postfix'>${name.options.postfix}</span>`;
      }

      html.name = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RawHTML, {
        class: name.options.class
      }, nameHtml);
      html.description = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RawHTML, {
        class: description.options.class
      }, postAuthor.description != undefined ? postAuthor.description : 'Author description');

      if (postAuthor.avatar_urls != undefined) {
        var avatarHtml = `<img alt='' src=${postAuthor.avatar_urls != undefined ? postAuthor.avatar_urls[avatar.options.size] : ''} />`;
        html.avatar = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RawHTML, {
          class: avatar.options.class
        }, avatarHtml, " ");
      }

      setTimeout(x => {
        setHtml(html);
      }, 100);
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setTimeout(() => {
        generatehtml();
      }, 1000);
    }, [postAuthor]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      generatehtml();
    }, [name]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      generatehtml();
    }, [description]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      generatehtml();
    }, [avatar]);
    var breakPointList = [{
      label: 'Select..',
      icon: '',
      value: ''
    }];

    for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_10__["default"]) {
      var item = _breakpoints__WEBPACK_IMPORTED_MODULE_10__["default"][x];
      breakPointList.push({
        label: item.name,
        icon: item.icon,
        value: item.id
      });
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, wrapper);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ wrapper: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      // if (blockCssY.items[wrapperSelector] == undefined) {
      //   blockCssY.items[wrapperSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[wrapperSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[wrapperSelector][key] != undefined) {
      //   delete blockCssY.items[wrapperSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // sudoScourceX[key] = {};
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStyleElements(sudoScource, newVal, attr) {
      var path = sudoScource + '.' + attr + '.' + breakPointX;
      let obj = Object.assign({}, elements);
      const updatedObj = myStore.setPropertyDeep(obj, path, newVal);
      setAttributes({
        elements: updatedObj
      });
      var sudoScourceX = { ...updatedObj[sudoScource]
      };
      var elementSelector = redmoreSelector;
      var elementSelector = myStore.getElementSelector(sudoScource, redmoreSelector);
      sudoScourceX[attr][breakPointX] = newVal;

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      Object.entries(sudoScourceX).map(args => {
        var argAttr = myStore.cssAttrParse(args[0]);
        var argAttrVal = args[1];
        blockCssY.items[elementSelector][argAttr] = argAttrVal;
      });
      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function onRemoveStyleElements(sudoScource, key) {
      var object = myStore.deletePropertyDeep(elements, [sudoScource, key, breakPointX]);
      setAttributes({
        elements: object
      });
      var elementSelectorX = myStore.getElementSelector(sudoScource, elementSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelectorX, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...elements[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // elements[sudoScource] = sudoScourceX;
      // setAttributes({ elements: { ...elements } });
      // if (blockCssY.items[redmoreSelector] == undefined) {
      //   blockCssY.items[redmoreSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[redmoreSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[redmoreSelector][key] != undefined) {
      //   delete blockCssY.items[redmoreSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleElements(sudoScource, key) {
      // var sudoScourceX = { ...elements[sudoScource] }
      // sudoScourceX[key] = {};
      // elements[sudoScource] = sudoScourceX;
      // setAttributes({ elements: { ...elements } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, elements);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        elements: object
      });
    }

    function onChangeStyleAvatar(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, avatar);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        avatar: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, avatarSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, avatar);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ avatar: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, avatarSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleAvatar(sudoScource, key) {
      var object = myStore.deletePropertyDeep(avatar, [sudoScource, key, breakPointX]);
      setAttributes({
        avatar: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, avatarSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...avatar[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // avatar[sudoScource] = sudoScourceX;
      // setAttributes({ avatar: { ...avatar } });
      // if (blockCssY.items[avatarSelector] == undefined) {
      //   blockCssY.items[avatarSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[avatarSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[avatarSelector][key] != undefined) {
      //   delete blockCssY.items[avatarSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleAvatar(sudoScource, key) {
      // var sudoScourceX = { ...avatar[sudoScource] }
      // sudoScourceX[key] = {};
      // avatar[sudoScource] = sudoScourceX;
      // setAttributes({ avatar: { ...avatar } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, avatar);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        avatar: object
      });
    }

    function onChangeStyleName(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, name);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        name: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, nameSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, name);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ name: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var sudoScourceX = { ...name[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, nameSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleName(sudoScource, key) {
      var object = myStore.deletePropertyDeep(name, [sudoScource, key, breakPointX]);
      setAttributes({
        name: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, nameSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...name[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // name[sudoScource] = sudoScourceX;
      // setAttributes({ name: { ...name } });
      // if (blockCssY.items[nameSelector] == undefined) {
      //   blockCssY.items[nameSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[nameSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[nameSelector][key] != undefined) {
      //   delete blockCssY.items[nameSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleName(sudoScource, key) {
      // var sudoScourceX = { ...name[sudoScource] }
      // sudoScourceX[key] = {};
      // name[sudoScource] = sudoScourceX;
      // setAttributes({ name: { ...name } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, name);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        name: object
      });
    }

    function onChangeStyleDescription(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, description);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        description: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, descriptionSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, description);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ description: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, descriptionSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleDescription(sudoScource, key) {
      var object = myStore.deletePropertyDeep(description, [sudoScource, key, breakPointX]);
      setAttributes({
        description: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, descriptionSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...description[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // description[sudoScource] = sudoScourceX;
      // setAttributes({ description: { ...description } });
      // if (blockCssY.items[descriptionSelector] == undefined) {
      //   blockCssY.items[descriptionSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[descriptionSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[descriptionSelector][key] != undefined) {
      //   delete blockCssY.items[descriptionSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleDescription(sudoScource, key) {
      // var sudoScourceX = { ...description[sudoScource] }
      // sudoScourceX[key] = {};
      // description[sudoScource] = sudoScourceX;
      // setAttributes({ description: { ...description } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, description);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        description: object
      });
    }

    var [linkAttrItems, setlinkAttrItems] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)({}); // Using the hook.

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      //generateBlockCssY()
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      linkAttrObj();
    }, [linkAttr]);

    var linkAttrObj = () => {
      var sdsd = {};
      linkAttr.map(x => {
        if (x.val) sdsd[x.id] = x.val;
      });
      setlinkAttrItems(sdsd); //return sdsd;
    };

    const colors = [{
      name: '9DD6DF',
      color: '#9DD6DF'
    }, {
      name: '18978F',
      color: '#18978F'
    }, {
      name: 'A084CF',
      color: '#A084CF'
    }, {
      name: 'DFBB9D',
      color: '#DFBB9D'
    }, {
      name: '774360',
      color: '#774360'
    }, {
      name: '3AB0FF',
      color: '#3AB0FF'
    }, {
      name: '51557E',
      color: '#51557E'
    }]; //const [blockCss, setBlockCss] = useState({ items: {} });

    const [setSome, setSomeState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)({});
    const [stateX, setStateX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('Old Value');
    const {
      __experimentalSetPreviewDeviceType: setPreviewDeviceType
    } = wp.data.dispatch('core/edit-post');
    const CustomTag = `${wrapper.tag}`;

    function onChangeBreakPoint(x, index) {
      setPreviewDeviceType(x.value);
      var asdsdsd = wp.data.dispatch('postgrid-shop').setBreakPoint(x.value);
      asdsdsd.then(res => {
        setBreakPointX(res.breakpoint); //generateBlockCssY();

        myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      });
    }

    return [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.BlockControls, null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InspectorControls, {
      key: "general"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-3",
      title: "General",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'No Wrapper',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'span',
        value: 'SPAN'
      }, {
        label: 'div',
        value: 'DIV'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: { ...wrapper,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Elements",
      initialOpen: true
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: elements,
      onChange: onChangeStyleElements,
      onAdd: onAddStyleElements,
      onRemove: onRemoveStyleElements
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Add User Field"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_15__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: userFields,
      buttonTitle: "Choose",
      onChange: setUserField,
      values: ""
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(react_sortablejs__WEBPACK_IMPORTED_MODULE_3__.ReactSortable, {
      list: elements.items,
      setList: item => {
        setAttributes({
          elements: {
            items: item
          }
        });
      }
    }, elements.items.map((item, index) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      key: item.id,
      className: "flex items-center"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      onClick: ev => {
        var elementsX = elements.items.splice(index, 1);
        setAttributes({
          elements: {
            items: elements.items
          }
        });
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"], {
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"]
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "cursor-move"
    }, item.label))))), elements.items.find(x => x.label === 'Avatar') && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Avatar",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Avatar Size"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: avatar.options.size,
      options: [{
        label: 'Select..',
        value: ''
      }, {
        label: '24',
        value: '24'
      }, {
        label: '48',
        value: '48'
      }, {
        label: '96',
        value: '96'
      }],
      onChange: newVal => {
        var options = { ...avatar.options,
          size: newVal
        };
        setAttributes({
          avatar: { ...avatar,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Avatar Class"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: avatar.options.class,
      onChange: newVal => {
        var options = { ...avatar.options,
          class: newVal
        };
        setAttributes({
          avatar: { ...avatar,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: avatar,
      onChange: onChangeStyleAvatar,
      onAdd: onAddStyleAvatar,
      onRemove: onRemoveStyleAvatar
    })))), elements.items.find(x => x.label === 'Name') && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Name",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Name Class"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: name.options.class,
      onChange: newVal => {
        var options = { ...name.options,
          class: newVal
        };
        setAttributes({
          name: { ...name,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", null, "Link To"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_15__["default"], {
      position: "bottom right",
      variant: "secondary",
      buttonTitle: name.options.linkTo.length == 0 ? 'Choose' : linkToArgs[name.options.linkTo].label,
      options: linkToArgs,
      onChange: (option, index) => {
        var options = { ...name.options,
          linkTo: option.value
        };
        setAttributes({
          name: { ...name,
            options: options
          }
        });
      },
      values: ""
    })), (name.options.linkTo == 'authorMeta' || name.options.linkTo == 'customField') && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, name.options.linkTo == 'authorMeta' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, "Author Meta Key"), name.options.linkTo == 'customField' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, "Post Meta Key")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: name.options.linkToMeta,
      onChange: newVal => {
        var options = { ...name.options,
          linkToMeta: newVal
        };
        setAttributes({
          name: { ...name,
            options: options
          }
        });
      }
    })), name.options.linkTo == 'customUrl' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Custom Url"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: linkPickerPosttitle ? "!bg-gray-400" : '',
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
      onClick: ev => {
        setLinkPickerPosttitle(prev => !prev);
      }
    }), name.options.customUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: "!text-red-500 ml-2",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
      onClick: ev => {
        var options = { ...name.options,
          customUrl: ''
        };
        setAttributes({
          name: { ...name,
            options: options
          }
        });
        setLinkPickerPosttitle(false);
      }
    }), linkPickerPosttitle && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Popover, {
      position: "bottom right"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.__experimentalLinkControl, {
      settings: [],
      value: name.options.customUrl,
      onChange: newVal => {
        var options = { ...name.options,
          customUrl: newVal.url
        };
        setAttributes({
          name: { ...name,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "p-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "font-bold"
    }, "Linked to:"), " ", name.options.customUrl.length != 0 ? name.options.customUrl : 'No link', " "))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Prefix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: name.options.prefix,
      onChange: newVal => {
        var options = { ...name.options,
          prefix: newVal
        };
        setAttributes({
          name: { ...name,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Postfix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: name.options.postfix,
      onChange: newVal => {
        var options = { ...name.options,
          postfix: newVal
        };
        setAttributes({
          name: { ...name,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: name,
      onChange: onChangeStyleName,
      onAdd: onAddStyleName,
      onRemove: onRemoveStyleName
    })))), elements.items.find(x => x.label === 'Description') && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Description",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Description Class"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: description.options.class,
      onChange: newVal => {
        var options = { ...description.options,
          class: newVal
        };
        setAttributes({
          description: { ...description,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: description,
      onChange: onChangeStyleDescription,
      onAdd: onAddStyleDescription,
      onRemove: onRemoveStyleDescription
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Wrapper Selector"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, wrapperSelector, '{/* your CSS here*/}'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Name Selector"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, nameSelector, '{}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Description Selector"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, descriptionSelector, '{}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Avatar Selector "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, avatarSelector, '{}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_17__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_18__["default"], {
      utm: {
        utm_source: 'BlockPostExcerpt',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: blockId
    }, elements.items.map(x => {
      return html[x.id];
    }))];
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/post-categories/index.js":
/*!*********************************************!*\
  !*** ./src/blocks/post-categories/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_css_display__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/css-display */ "./src/components/css-display/index.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
















const {
  RawHTML
} = wp.element;













var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__.registerBlockType)("post-grid/post-categories", {
  title: "Post Categories",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#2563eb',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("svg", {
      width: "500",
      height: "500",
      viewBox: "0 0 500 500",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M38 209.5C38 206.739 40.2386 204.5 43 204.5H483C485.761 204.5 488 206.739 488 209.5V259.5C488 262.261 485.761 264.5 483 264.5H43C40.2386 264.5 38 262.261 38 259.5V209.5Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M38 315.5C38 312.739 40.2386 310.5 43 310.5H365C367.761 310.5 370 312.739 370 315.5V365.5C370 368.261 367.761 370.5 365 370.5H43C40.2386 370.5 38 368.261 38 365.5V315.5Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M129.861 115.454C128.257 117.058 127.356 119.233 127.356 121.501C127.356 123.769 128.257 125.944 129.861 127.548C131.465 129.151 133.64 130.052 135.908 130.052C138.176 130.052 140.351 129.151 141.955 127.548C143.558 125.944 144.459 123.769 144.459 121.501C144.459 119.233 143.558 117.058 141.955 115.454C140.351 113.85 138.176 112.949 135.908 112.949C133.64 112.949 131.465 113.85 129.861 115.454ZM71.4472 153.066C68.5447 153.066 65.6018 151.977 63.3443 149.72C61.1271 147.503 59.9983 144.6 60.0386 141.657V101.344C60.0386 98.4418 61.1271 95.4989 63.3443 93.2817C65.5615 91.0645 68.4641 89.9357 71.4472 89.9357L127.805 89.9357C130.788 89.9357 133.69 91.0645 135.908 93.2817L156.064 113.438C160.539 117.913 160.539 125.089 156.064 129.563L135.908 149.72C133.69 151.937 130.788 153.066 127.885 153.066H71.4472ZM110.712 161.128V169.191H55.322C52.3792 169.231 49.4363 168.062 47.2191 165.845C45.0019 163.628 43.8731 160.725 43.8731 157.823L43.8731 114.446L51.9357 114.446L52.2582 160.806L110.712 161.128Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          class: ''
        },
        styles: {
          display: {},
          color: {
            Desktop: ''
          },
          bgColor: {},
          padding: {
            Desktop: ''
          },
          margin: {}
        }
      }
    },
    items: {
      type: 'object',
      default: {
        options: {
          prefix: '',
          postfix: '',
          maxCount: 99,
          postCount: false,
          class: ' item ',
          linkTarget: '',
          linkAttr: []
        },
        styles: {
          display: {},
          color: {
            Desktop: ''
          },
          bgColor: {},
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          },
          lineHeight: {},
          // { val: '18', unit: 'px' }
          letterSpacing: {},
          // { val: '18', unit: 'px' }
          fontFamily: {},
          fontWeight: {},
          textDecoration: {},
          //overline, line-through, underline
          textTransform: {}
        }
      }
    },
    icon: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: '',
          position: 'beforeFronttext',

          /*before, after, prefix, postfix */
          class: 'icon'
        },
        styles: {
          color: {
            Desktop: ''
          },
          bgColor: {},
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          display: {},
          fontSize: {
            Desktop: ''
          },
          lineHeight: {},
          // { val: '18', unit: 'px' }
          fontWeight: {
            "Desktop": "700"
          },
          textDecoration: {} //overline, line-through, underline

        }
      }
    },
    termTitle: {
      type: 'object',
      default: {
        options: {
          class: 'inline-block',
          text: ', '
        },
        styles: {
          color: {
            Desktop: ''
          },
          bgColor: {},
          padding: {
            Desktop: ''
          },
          margin: {}
        }
      }
    },
    separator: {
      type: 'object',
      default: {
        options: {
          class: 'inline-block',
          text: ', '
        },
        styles: {
          color: {
            Desktop: ''
          },
          bgColor: {},
          padding: {
            Desktop: ''
          },
          margin: {}
        }
      }
    },
    frontText: {
      type: 'object',
      default: {
        options: {
          text: 'Categories: ',
          class: 'inline-block'
        },
        styles: {
          color: {
            Desktop: ''
          },
          bgColor: {},
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          },
          lineHeight: {},
          // { val: '18', unit: 'px' }
          letterSpacing: {},
          // { val: '18', unit: 'px' }
          fontFamily: {},
          fontWeight: {},
          textDecoration: {},
          //overline, line-through, underline
          textTransform: {}
        }
      }
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var wrapper = attributes.wrapper;
    var items = attributes.items;
    var separator = attributes.separator;
    var frontText = attributes.frontText;
    var icon = attributes.icon;
    var blockCssY = attributes.blockCssY;
    var customCss = attributes.customCss;
    var postId = context['postId'];
    var postType = context['postType'];
    const [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(myStore.getBreakPoint()); // Wrapper CSS Class Selectors

    const wrapperSelector = blockClass;
    const itemSelector = blockClass + ' .item';
    const itemTitleSelector = blockClass + ' .termTitle';
    const separatorSelector = blockClass + ' .separator';
    const frontTextSelector = blockClass + ' .frontText';
    const postCountSelector = blockClass + ' .postCount';
    const iconSelector = blockClass + ' .icon';
    var breakPointList = [];

    for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_10__["default"]) {
      var item = _breakpoints__WEBPACK_IMPORTED_MODULE_10__["default"][x];
      breakPointList.push({
        label: item.name,
        icon: item.icon,
        value: item.id
      });
    }

    var dummyCats = [{
      "id": 1,
      "count": 1,
      "description": "",
      "link": "#",
      "name": "Category 1",
      "slug": "category-1",
      "taxonomy": "category_tax"
    }, {
      "id": 2,
      "count": 1,
      "description": "",
      "link": "#",
      "name": "Category 2",
      "slug": "category-2",
      "taxonomy": "category_tax"
    }, {
      "id": 3,
      "count": 1,
      "description": "",
      "link": "#",
      "name": "Category 3",
      "slug": "category-3",
      "taxonomy": "category_tax"
    }, {
      "id": 4,
      "count": 1,
      "description": "",
      "link": "#",
      "name": "Category 4",
      "slug": "category-4",
      "taxonomy": "category_tax"
    }, {
      "id": 5,
      "count": 1,
      "description": "",
      "link": "#",
      "name": "Category 5",
      "slug": "category-5",
      "taxonomy": "category_tax"
    }, {
      "id": 6,
      "count": 1,
      "description": "",
      "link": "#",
      "name": "Category 6",
      "slug": "category-6",
      "taxonomy": "category_tax"
    }];
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      }); // setAttributes({ postTitle: postTitle });
      // setAttributes({ wrapper: wrapper });
      //generateBlockCssY()

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [clientId]);
    const [categoryCount, setcategoryCount] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(0); // Using the hook.

    const [postCategoriesData, setPostCategoriesData] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)([]); // Using the hook.

    const [categories, setCategories] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)([]); // Using the hook.

    const [postCategoriesX, setPostCategoriesX] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_3__.useEntityProp)('postType', postType, 'categories', postId);
    var iconPositonArgsBasic = {
      none: {
        label: 'Choose Position',
        value: ''
      },
      beforeFronttext: {
        label: 'Before Front text',
        value: 'beforeFronttext'
      },
      afterFronttext: {
        label: 'After Front text',
        value: 'afterFronttext'
      },
      beforeItems: {
        label: 'Before Items',
        value: 'beforeItems'
      },
      afterItems: {
        label: 'After Items',
        value: 'afterItems'
      },
      beforeItem: {
        label: 'Before Each Items',
        value: 'beforeItem',
        isPro: true
      },
      afterItem: {
        label: 'After Each Items',
        value: 'afterItem',
        isPro: true
      }
    };
    let iconPositonArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__.applyFilters)('iconPositonArgs', iconPositonArgsBasic);

    function setIconPosition(option, index) {
      var options = { ...icon.options,
        position: option.value
      };
      setAttributes({
        icon: { ...icon,
          options: options
        }
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setPostCategoriesData([]);
      setCategories([]);
      setcategoryCount(categories.length - 1);

      if (postCategoriesX != undefined) {
        for (x in postCategoriesX) {
          var catId = postCategoriesX[x];
          var assd = x;

          if (x) {
            _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
              path: '/wp/v2/categories/' + catId,
              method: 'GET'
            }).then(res => {
              setPostCategoriesData(current => [...current, res]);
              setCategories(current => [...current, res]);
            });
          }
        }
      } else {
        setPostCategoriesData(dummyCats);
        setCategories(dummyCats);
      }
    }, [postCategoriesX]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      var asdasd = postCategoriesData.slice(0, items.options.maxCount);
      setCategories(asdasd);
    }, [postCategoriesData]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      if (postCategoriesX != undefined && postCategoriesX.length > 0) {
        var maxCount = items.options.maxCount.length > 0 ? items.options.maxCount : 99;
        setcategoryCount(categories.length - 1);
        var asdasd = postCategoriesData.slice(0, maxCount);
        setCategories(asdasd);
      } else {
        var asdasd = dummyCats.slice(0, maxCount);
        setCategories(asdasd);
      }
    }, [items]);
    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('');
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      var iconSrc = icon.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      setIconHtml(iconHtml);
    }, [icon]);

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, wrapper);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ wrapper: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      // if (blockCssY.items[wrapperSelector] == undefined) {
      //   blockCssY.items[wrapperSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[wrapperSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[wrapperSelector][key] != undefined) {
      //   delete blockCssY.items[wrapperSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // sudoScourceX[key] = {};
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStyleItems(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, item);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        item: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, items);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ items: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleItems(sudoScource, key) {
      var object = myStore.deletePropertyDeep(items, [sudoScource, key, breakPointX]);
      setAttributes({
        items: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...items[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // items[sudoScource] = sudoScourceX;
      // setAttributes({ items: { ...items } });
      // if (blockCssY.items[itemSelector] == undefined) {
      //   blockCssY.items[itemSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[itemSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[itemSelector][key] != undefined) {
      //   delete blockCssY.items[itemSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleItems(sudoScource, key) {
      // var sudoScourceX = { ...items[sudoScource] }
      // sudoScourceX[key] = {};
      // items[sudoScource] = sudoScourceX;
      // setAttributes({ items: { ...items } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, items);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        items: object
      });
    }

    function onChangeStyleIcon(sudoScource, newVal, attr) {
      // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, icon);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ icon: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(icon, [sudoScource, key, breakPointX]);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...icon[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // icon[sudoScource] = sudoScourceX;
      // setAttributes({ icon: { ...icon } });
      // if (blockCssY.items[iconSelector] == undefined) {
      //   blockCssY.items[iconSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[iconSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[iconSelector][key] != undefined) {
      //   delete blockCssY.items[iconSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        icon: object
      });
    }

    function onChangeStyleFrontText(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, frontText);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        frontText: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, frontTextSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, frontText);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ frontText: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, frontTextSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleFrontText(sudoScource, key) {
      var object = myStore.deletePropertyDeep(frontText, [sudoScource, key, breakPointX]);
      setAttributes({
        frontText: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, frontTextSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...frontText[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // frontText[sudoScource] = sudoScourceX;
      // setAttributes({ frontText: { ...frontText } });
      // if (blockCssY.items[frontTextSelector] == undefined) {
      //   blockCssY.items[frontTextSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[frontTextSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[frontTextSelector][key] != undefined) {
      //   delete blockCssY.items[frontTextSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleFrontText(sudoScource, key) {
      // var sudoScourceX = { ...frontText[sudoScource] }
      // sudoScourceX[key] = {};
      // frontText[sudoScource] = sudoScourceX;
      // setAttributes({ frontText: { ...frontText } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, frontText);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        frontText: object
      });
    }

    function onChangeStyleSeparator(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, separator);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        separator: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, separatorSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, separator);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ separator: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, separatorSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleSeparator(sudoScource, key) {
      var object = myStore.deletePropertyDeep(separator, [sudoScource, key, breakPointX]);
      setAttributes({
        separator: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, separatorSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...separator[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // separator[sudoScource] = sudoScourceX;
      // setAttributes({ separator: { ...separator } });
      // if (blockCssY.items[separatorSelector] == undefined) {
      //   blockCssY.items[separatorSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[separatorSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[separatorSelector][key] != undefined) {
      //   delete blockCssY.items[separatorSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleSeparator(sudoScource, key) {
      // var sudoScourceX = { ...separator[sudoScource] }
      // sudoScourceX[key] = {};
      // separator[sudoScource] = sudoScourceX;
      // setAttributes({ separator: { ...separator } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, separator);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        separator: object
      });
    }

    function paddingControlItems(nextValues) {
      var responsive = items.styles.padding;
      responsive[breakPointX] = nextValues;
      var styles = { ...items.styles,
        padding: responsive
      };
      setAttributes({
        items: { ...items,
          styles: styles
        }
      });
      blockCssY.items[itemSelector] = blockCssY.items[itemSelector] != undefined ? blockCssY.items[itemSelector] : {};
      nextValues.top = nextValues.top == undefined ? '0px' : nextValues.top;
      nextValues.right = nextValues.right == undefined ? '0px' : nextValues.right;
      nextValues.bottom = nextValues.bottom == undefined ? '0px' : nextValues.bottom;
      nextValues.left = nextValues.left == undefined ? '0px' : nextValues.left;

      if (nextValues.top != undefined) {
        var paddingTop = blockCssY.items[itemSelector]['padding-top'] != undefined ? blockCssY.items[itemSelector]['padding-top'] : {};
        paddingTop[breakPointX] = nextValues.top;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'padding-top': paddingTop
        };
      }

      if (nextValues.right != undefined) {
        var paddingRight = blockCssY.items[itemSelector]['padding-right'] != undefined ? blockCssY.items[itemSelector]['padding-right'] : {};
        paddingRight[breakPointX] = nextValues.right;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'padding-right': paddingRight
        };
      }

      if (nextValues.bottom != undefined) {
        var paddingBottom = blockCssY.items[itemSelector]['padding-bottom'] != undefined ? blockCssY.items[itemSelector]['padding-bottom'] : {};
        paddingBottom[breakPointX] = nextValues.bottom;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'padding-bottom': paddingBottom
        };
      }

      if (nextValues.left != undefined) {
        var paddingLeft = blockCssY.items[itemSelector]['padding-left'] != undefined ? blockCssY.items[itemSelector]['padding-left'] : {};
        paddingLeft[breakPointX] = nextValues.left;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'padding-left': paddingLeft
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function marginControlItems(nextValues) {
      var responsive = items.styles.margin;
      responsive[breakPointX] = nextValues;
      var styles = { ...items.styles,
        margin: responsive
      };
      setAttributes({
        items: { ...items,
          styles: styles
        }
      });
      nextValues.top = nextValues.top == undefined ? '0px' : nextValues.top;
      nextValues.right = nextValues.right == undefined ? '0px' : nextValues.right;
      nextValues.bottom = nextValues.bottom == undefined ? '0px' : nextValues.bottom;
      nextValues.left = nextValues.left == undefined ? '0px' : nextValues.left;
      blockCssY.items[itemSelector] = blockCssY.items[itemSelector] != undefined ? blockCssY.items[itemSelector] : {};

      if (nextValues.top != undefined) {
        var marginTop = blockCssY.items[itemSelector]['margin-top'] != undefined ? blockCssY.items[itemSelector]['margin-top'] : {};
        marginTop[breakPointX] = nextValues.top;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'margin-top': marginTop
        };
      }

      if (nextValues.right != undefined) {
        var marginRight = blockCssY.items[itemSelector]['margin-right'] !== undefined ? blockCssY.items[itemSelector]['margin-right'] : {};
        marginRight[breakPointX] = nextValues.right;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'margin-right': marginRight
        };
      }

      if (nextValues.bottom != undefined) {
        var marginBottom = blockCssY.items[itemSelector]['margin-bottom'] !== undefined ? blockCssY.items[itemSelector]['margin-bottom'] : {};
        marginBottom[breakPointX] = nextValues.bottom;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'margin-bottom': marginBottom
        };
      }

      if (nextValues.left != undefined) {
        var marginLeft = blockCssY.items[itemSelector]['margin-left'] !== undefined ? blockCssY.items[itemSelector]['margin-left'] : {};
        marginLeft[breakPointX] = nextValues.left;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'margin-left': marginLeft
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function onChangeTypo(typoX) {
      setAttributes({
        items: { ...items,
          styles: typoX
        }
      });
      var newValuesObjX = {};

      if (typoX.fontFamily[breakPointX] != undefined) {
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'font-family': typoX.fontFamily
        };
      }

      if (typoX.fontSize[breakPointX] != undefined) {
        var fontSizeVal = typoX.fontSize[breakPointX].val ? typoX.fontSize[breakPointX].val : 16;
        var fontSizeUnit = typoX.fontSize[breakPointX].unit ? typoX.fontSize[breakPointX].unit : 'px';
        var fontSizeX = blockCssY.items[itemSelector] != undefined ? blockCssY.items[itemSelector]['font-size'] : {};
        fontSizeX[breakPointX] = fontSizeVal + fontSizeUnit;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'font-size': fontSizeX
        };
      }

      if (typoX.lineHeight[breakPointX] != undefined) {
        var lineHeightVal = typoX.lineHeight[breakPointX].val ? typoX.lineHeight[breakPointX].val : 0;
        var lineHeightUnit = typoX.lineHeight[breakPointX].unit ? typoX.lineHeight[breakPointX].unit : 'px';
        var lineHeightX = blockCssY.items[itemSelector]['line-height'] != undefined ? blockCssY.items[itemSelector]['line-height'] : {};
        lineHeightX[breakPointX] = lineHeightVal + lineHeightUnit;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'line-height': lineHeightX
        };
      }

      if (typoX.letterSpacing[breakPointX] != undefined) {
        var letterSpacingVal = typoX.letterSpacing[breakPointX].val ? typoX.letterSpacing[breakPointX].val : 0;
        var letterSpacingUnit = typoX.letterSpacing[breakPointX].unit ? typoX.letterSpacing[breakPointX].unit : 'px';
        var letterSpacingX = blockCssY.items[itemSelector]['letter-spacing'] != undefined ? blockCssY.items[itemSelector]['letter-spacing'] : {};
        letterSpacingX[breakPointX] = letterSpacingVal + letterSpacingUnit;
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'letter-spacing': letterSpacingX
        };
      }

      if (typoX.fontWeight[breakPointX] != undefined) {
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'font-weight': typoX.fontWeight
        };
      }

      if (typoX.textDecoration[breakPointX] != undefined) {
        var str = {};
        var textDecorationX = typoX.textDecoration[breakPointX];
        var textDecorationXStr = textDecorationX.length > 0 ? textDecorationX.join(' ') : '';
        str[breakPointX] = textDecorationXStr; //typoX.textDecoration[breakPointX] = typoX.textDecoration[breakPointX].join(' ');

        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'text-decoration': str
        };
      }

      if (typoX.textTransform[breakPointX] != undefined) {
        blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
          'text-transform': typoX.textTransform
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function onChangeIcon(arg) {
      var options = { ...icon.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        icon: { ...icon,
          options: options
        }
      });
    }

    function onChangeIconTypo(typoX) {
      setAttributes({
        icon: { ...icon,
          styles: typoX
        }
      });
      var newValuesObjX = {};
      var itemsX = blockCssY.items;

      if (typoX.fontSize[breakPointX] != undefined) {
        var fontSizeVal = typoX.fontSize[breakPointX].val ? typoX.fontSize[breakPointX].val : 16;
        var fontSizeUnit = typoX.fontSize[breakPointX].unit ? typoX.fontSize[breakPointX].unit : 'px';
        var fontSizeX = blockCssY.items[iconSelector] != undefined ? blockCssY.items[iconSelector]['font-size'] : {};

        if (fontSizeX[breakPointX] == undefined) {
          fontSizeX[breakPointX] = '';
        }

        fontSizeX[breakPointX] = fontSizeVal + fontSizeUnit; //blockCssY.items[iconSelector] = { ...blockCssY.items[iconSelector], 'font-size': fontSizeX };

        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'font-size': fontSizeX
        };
      }

      if (typoX.lineHeight[breakPointX] != undefined) {
        var lineHeightVal = typoX.lineHeight[breakPointX].val ? typoX.lineHeight[breakPointX].val : 16;
        var lineHeightUnit = typoX.lineHeight[breakPointX].unit ? typoX.lineHeight[breakPointX].unit : 'px';
        var lineHeightX = blockCssY.items[iconSelector]['line-height'] != undefined ? blockCssY.items[iconSelector]['line-height'] : {};
        lineHeightX[breakPointX] = lineHeightVal + lineHeightUnit; //blockCssY.items[iconSelector] = { ...blockCssY.items[iconSelector], 'line-height': lineHeightX };

        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'line-height': lineHeightX
        };
      }

      if (typoX.fontWeight[breakPointX] != undefined) {
        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'font-weight': typoX.fontWeight
        };
      }

      if (typoX.textDecoration[breakPointX] != undefined) {
        var str = {};
        var textDecorationX = typoX.textDecoration[breakPointX];
        var textDecorationXStr = textDecorationX.length > 0 ? textDecorationX.join(' ') : '';
        str[breakPointX] = textDecorationXStr;
        itemsX[iconSelector] = { ...blockCssY.items[iconSelector],
          'text-decoration': str
        };
      } //setAttributes({ blockCssY: { items: blockCssY.items } });


      setAttributes({
        blockCssY: {
          items: itemsX
        }
      });
    }

    function onChangeTypoFrontText(typoX) {
      setAttributes({
        frontText: { ...frontText,
          styles: typoX
        }
      });
      var newValuesObjX = {};

      if (typoX.fontFamily[breakPointX] != undefined) {
        blockCssY.items[frontTextSelector] = { ...blockCssY.items[frontTextSelector],
          'font-family': typoX.fontFamily
        };
      }

      if (typoX.fontSize[breakPointX] != undefined) {
        var fontSizeVal = typoX.fontSize[breakPointX].val ? typoX.fontSize[breakPointX].val : 16;
        var fontSizeUnit = typoX.fontSize[breakPointX].unit ? typoX.fontSize[breakPointX].unit : 'px';
        var fontSizeX = blockCssY.items[frontTextSelector]['font-size'] != undefined ? blockCssY.items[frontTextSelector]['font-size'] : {};
        fontSizeX[breakPointX] = fontSizeVal + fontSizeUnit;
        blockCssY.items[frontTextSelector] = { ...blockCssY.items[frontTextSelector],
          'font-size': fontSizeX
        };
      }

      if (typoX.lineHeight[breakPointX] != undefined) {
        var lineHeightVal = typoX.lineHeight[breakPointX].val ? typoX.lineHeight[breakPointX].val : 0;
        var lineHeightUnit = typoX.lineHeight[breakPointX].unit ? typoX.lineHeight[breakPointX].unit : 'px';
        var lineHeightX = blockCssY.items[frontTextSelector]['line-height'] != undefined ? blockCssY.items[frontTextSelector]['line-height'] : {};
        lineHeightX[breakPointX] = lineHeightVal + lineHeightUnit;
        blockCssY.items[frontTextSelector] = { ...blockCssY.items[frontTextSelector],
          'line-height': lineHeightX
        };
      }

      if (typoX.letterSpacing[breakPointX] != undefined) {
        var letterSpacingVal = typoX.letterSpacing[breakPointX].val ? typoX.letterSpacing[breakPointX].val : 0;
        var letterSpacingUnit = typoX.letterSpacing[breakPointX].unit ? typoX.letterSpacing[breakPointX].unit : 'px';
        var letterSpacingX = blockCssY.items[frontTextSelector]['letter-spacing'] != undefined ? blockCssY.items[frontTextSelector]['letter-spacing'] : {};
        letterSpacingX[breakPointX] = letterSpacingVal + letterSpacingUnit;
        blockCssY.items[frontTextSelector] = { ...blockCssY.items[frontTextSelector],
          'letter-spacing': letterSpacingX
        };
      }

      if (typoX.fontWeight[breakPointX] != undefined) {
        blockCssY.items[frontTextSelector] = { ...blockCssY.items[frontTextSelector],
          'font-weight': typoX.fontWeight
        };
      }

      if (typoX.textDecoration[breakPointX] != undefined) {
        var str = {};
        var textDecorationX = typoX.textDecoration[breakPointX];
        var textDecorationXStr = textDecorationX.length > 0 ? textDecorationX.join(' ') : '';
        str[breakPointX] = textDecorationXStr; //typoX.textDecoration[breakPointX] = typoX.textDecoration[breakPointX].join(' ');

        blockCssY.items[frontTextSelector] = { ...blockCssY.items[frontTextSelector],
          'text-decoration': str
        };
      }

      if (typoX.textTransform[breakPointX] != undefined) {
        blockCssY.items[frontTextSelector] = { ...blockCssY.items[frontTextSelector],
          'text-transform': typoX.textTransform
        };
      }

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      //generateBlockCssY()
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);

    function generateBlockCssY() {
      var reponsiveCssGroups = {};

      for (var selector in blockCssY.items) {
        var attrs = blockCssY.items[selector];

        for (var attr in attrs) {
          var breakpoints = attrs[attr];

          for (var device in breakpoints) {
            var attrValue = breakpoints[device];

            if (reponsiveCssGroups[device] == undefined) {
              reponsiveCssGroups[device] = [];
            }

            if (reponsiveCssGroups[device] == undefined) {
              reponsiveCssGroups[device] = [];
            }

            if (reponsiveCssGroups[device][selector] == undefined) {
              reponsiveCssGroups[device][selector] = [];
            }

            reponsiveCssGroups[device][selector].push({
              'attr': attr,
              'val': attrValue
            });
          }
        }
      } //return false;


      var reponsiveCssMobile = '';

      if (reponsiveCssGroups['Mobile'] != undefined) {
        reponsiveCssMobile += '@media only screen and (min-width: 0px) and (max-width: 360px){';

        for (var selector in reponsiveCssGroups['Mobile']) {
          var attrs = reponsiveCssGroups['Mobile'][selector];
          reponsiveCssMobile += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCssMobile += attrName + ':' + attrValue + ';';
          }

          reponsiveCssMobile += '}';
        }

        reponsiveCssMobile += '}';
      }

      var reponsiveCssTablet = '';

      if (reponsiveCssGroups['Tablet'] != undefined) {
        reponsiveCssTablet += '@media only screen and (min-width: 361px) and (max-width: 780px){';

        for (var selector in reponsiveCssGroups['Tablet']) {
          var attrs = reponsiveCssGroups['Tablet'][selector];
          reponsiveCssTablet += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCssTablet += attrName + ':' + attrValue + ';';
          }

          reponsiveCssTablet += '}';
        }

        reponsiveCssTablet += '}';
      }

      var reponsiveCssDesktop = '';

      if (reponsiveCssGroups['Desktop'] != undefined) {
        reponsiveCssDesktop += '@media only screen and (min-width: 781px){';

        for (var selector in reponsiveCssGroups['Desktop']) {
          var attrs = reponsiveCssGroups['Desktop'][selector];
          reponsiveCssDesktop += selector + '{';

          for (var index in attrs) {
            var attr = attrs[index];
            var attrName = attr.attr;
            var attrValue = attr.val;
            reponsiveCssDesktop += attrName + ':' + attrValue + ';';
          }

          reponsiveCssDesktop += '}';
        }

        reponsiveCssDesktop += '}';
      }

      var reponsiveCss = reponsiveCssMobile + reponsiveCssTablet + reponsiveCssDesktop;
      var iframe = document.querySelectorAll('[name="editor-canvas"]')[0];

      if (iframe) {
        setTimeout(() => {
          var iframeDocument = iframe.contentDocument;
          var body = iframeDocument.body;
          var divWrap = iframeDocument.getElementById("css-block-" + blockId);

          if (divWrap != undefined) {
            iframeDocument.getElementById("css-block-" + blockId).outerHTML = "";
          }

          var divWrap = '<div id="css-block-' + blockId + '"></div>';
          body.insertAdjacentHTML('beforeend', divWrap);
          var csswrappg = iframeDocument.getElementById('css-block-' + blockId);
          var str = '<style>' + reponsiveCss + customCss + '</style>';
          csswrappg.insertAdjacentHTML('beforeend', str);
        }, 200);
      } else {
        var wpfooter = document.getElementById('wpfooter');
        var divWrap = document.getElementById("css-block-" + blockId);

        if (divWrap != undefined) {
          document.getElementById("css-block-" + blockId).outerHTML = "";
        }

        var divWrap = '<div id="css-block-' + blockId + '"></div>';
        wpfooter.insertAdjacentHTML('beforeend', divWrap);
        var csswrappg = document.getElementById('css-block-' + blockId);
        var str = '<style>' + reponsiveCss + customCss + '</style>';
        csswrappg.insertAdjacentHTML('beforeend', str);
      }
    }

    var [linkAttrItems, setlinkAttrItems] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({}); // Using the hook.

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      linkAttrObj(); //generateBlockCssY();

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [items]);

    var linkAttrObj = () => {
      var sdsd = {};
      items.options.linkAttr.map(x => {
        if (x.val) sdsd[x.id] = x.val;
      });
      setlinkAttrItems(sdsd);
    };

    const colors = [{
      name: '9DD6DF',
      color: '#9DD6DF'
    }, {
      name: '18978F',
      color: '#18978F'
    }, {
      name: 'A084CF',
      color: '#A084CF'
    }, {
      name: 'DFBB9D',
      color: '#DFBB9D'
    }, {
      name: '774360',
      color: '#774360'
    }, {
      name: '3AB0FF',
      color: '#3AB0FF'
    }, {
      name: '51557E',
      color: '#51557E'
    }];
    const {
      __experimentalSetPreviewDeviceType: setPreviewDeviceType
    } = wp.data.dispatch('core/edit-post');
    const post = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_6__.useSelect)(select => select('core').getEntityRecord('postType', context['postType'], context['postId']));
    const termstaxonomy = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_6__.useSelect)(select => select('core').getEntityRecords('taxonomy', 'category', [4, 5]));

    function onChangeBreakPoint(x, index) {
      setPreviewDeviceType(x.value);
      var asdsdsd = wp.data.dispatch('postgrid-shop').setBreakPoint(x.value);
      asdsdsd.then(res => {
        setBreakPointX(res.breakpoint); //generateBlockCssY()

        myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      });
    }

    return [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.BlockControls, null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InspectorControls, {
      key: "general"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Items Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Wrapper Class"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: wrapper.options.class,
      onChange: newVal => {
        var options = { ...wrapper.options,
          class: newVal
        };
        setAttributes({
          wrapper: { ...wrapper,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Items",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
      label: "Display Post Count",
      help: items.options.postCount ? 'Post Count Enabled' : 'Post Count Disabled',
      checked: items.options.postCount ? true : false,
      onChange: e => {
        var options = { ...items.options,
          postCount: items.options.postCount ? false : true
        };
        setAttributes({
          items: { ...items,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Item Class"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: items.options.class,
      onChange: newVal => {
        var options = { ...items.options,
          class: newVal
        };
        setAttributes({
          items: { ...items,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Max Count"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: items.options.maxCount,
      onChange: newVal => {
        var options = { ...items.options,
          maxCount: newVal
        };
        setAttributes({
          items: { ...items,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Link Target"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: items.options.linkTarget,
      options: [{
        label: '_self',
        value: '_self'
      }, {
        label: '_blank',
        value: '_blank'
      }, {
        label: '_parent',
        value: '_parent'
      }, {
        label: '_top',
        value: '_top'
      }],
      onChange: newVal => {
        var options = { ...items.options,
          linkTarget: newVal
        };
        setAttributes({
          items: { ...items,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Prefix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: items.options.prefix,
      onChange: newVal => {
        var options = { ...items.options,
          prefix: newVal
        };
        setAttributes({
          items: { ...items,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Postfix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: items.options.postfix,
      onChange: newVal => {
        var options = { ...items.options,
          postfix: newVal
        };
        setAttributes({
          items: { ...items,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Attributes"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: " cursor-pointer px-3 text-white py-1 bg-blue-600",
      onClick: ev => {
        var sdsd = items.options.linkAttr.concat({
          id: '',
          val: ''
        });
        var options = { ...items.options,
          linkAttr: sdsd
        };
        setAttributes({
          items: { ...items,
            options: options
          }
        });
        linkAttrObj();
      }
    }, "Add")), items.options.linkAttr.length > 0 && items.options.linkAttr.map((x, i) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
        className: "my-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        placeholder: "Name",
        className: "mr-2",
        value: items.options.linkAttr[i].id,
        onChange: newVal => {
          items.options.linkAttr[i].id = newVal;
          var ssdsd = items.options.linkAttr.concat([]);
          var options = { ...items.options,
            linkAttr: ssdsd
          };
          setAttributes({
            items: { ...items,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Value",
        value: x.val,
        onChange: newVal => {
          items.options.linkAttr[i].val = newVal;
          var ssdsd = items.options.linkAttr.concat([]);
          var options = { ...items.options,
            linkAttr: ssdsd
          };
          setAttributes({
            items: { ...items,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
        className: "text-lg cursor-pointer px-3 text-white py-1 bg-red-400 icon-close",
        onClick: ev => {
          items.options.linkAttr.splice(i, 1);
          var ssdsd = items.options.linkAttr.concat([]);
          var options = { ...items.options,
            linkAttr: ssdsd
          };
          setAttributes({
            items: { ...items,
              options: options
            }
          });
        }
      })));
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: items,
      onChange: onChangeStyleItems,
      onAdd: onAddStyleItems,
      onRemove: onRemoveStyleItems
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_20__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: onChangeIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Icon position"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_17__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: iconPositonArgs,
      buttonTitle: icon.options.position.length == 0 ? 'Choose' : iconPositonArgs[icon.options.position].label,
      onChange: setIconPosition,
      values: []
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Front Text",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Front Text"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: frontText.options.text,
      onChange: newVal => {
        var options = { ...frontText.options,
          text: newVal
        };
        setAttributes({
          frontText: { ...frontText,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: frontText,
      onChange: onChangeStyleFrontText,
      onAdd: onAddStyleFrontText,
      onRemove: onRemoveStyleFrontText
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Separator",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Separator"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: separator.options.text,
      onChange: newVal => {
        var options = { ...separator.options,
          text: newVal
        };
        setAttributes({
          separator: { ...separator,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: separator,
      onChange: onChangeStyleSeparator,
      onAdd: onAddStyleSeparator,
      onRemove: onRemoveStyleSeparator
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Items Wrapper"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, wrapperSelector, '{/* your CSS here*/}'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Caetgory Items"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, itemSelector, '{}', " ")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, ".pg-postCategories a", '{/* your CSS here*/}'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Separator"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, separatorSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Front Text"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, frontTextSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Post Count"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, postCountSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "px-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_18__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_19__["default"], {
      utm: {
        utm_source: 'BlockPostTitle',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    })))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, categories.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, "No Categories Found"), categories.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: [blockId]
    }, icon.options.position == 'beforeFronttext' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: "frontText inline-block"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(RawHTML, null, frontText.options.text)), icon.options.position == 'afterFronttext' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), icon.options.position == 'beforeItems' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), categories.map((x, index) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("a", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
        onClick: ev => ev.preventDefault(),
        target: items.options.linkTarget,
        title: x.name
      }, linkAttrItems, {
        className: items.options.class,
        href: x.link
      }), icon.options.position == 'beforeItem' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
        className: icon.options.class,
        dangerouslySetInnerHTML: {
          __html: iconHtml
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
        className: "termTitle"
      }, items.options.prefix, x.name, items.options.postfix), items.options.postCount == true && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
        className: "postCount"
      }, "(", x.count, ")"), icon.options.position == 'afterItem' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
        className: icon.options.class,
        dangerouslySetInnerHTML: {
          __html: iconHtml
        }
      })), categories.length > index + 1 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
        className: "separator",
        dangerouslySetInnerHTML: {
          __html: separator.options.text
        }
      }));
    }), icon.options.position == 'afterItems' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })))];
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/post-comment-count/index.js":
/*!************************************************!*\
  !*** ./src/blocks/post-comment-count/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link-off.js");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_css_display__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/css-display */ "./src/components/css-display/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
















const {
  RawHTML
} = wp.element;













var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__.registerBlockType)("post-grid/post-comment-count", {
  title: "Post Comment Count",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#2563eb',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("svg", {
      width: "500",
      height: "500",
      viewBox: "0 0 500 500",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M25 95C25 92.2386 27.2386 90 30 90H470C472.761 90 475 92.2386 475 95V145C475 147.761 472.761 150 470 150H30C27.2386 150 25 147.761 25 145V95Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M25 234C25 231.239 27.2386 229 30 229H470C472.761 229 475 231.239 475 234V254C475 256.761 472.761 259 470 259H30C27.2386 259 25 256.761 25 254V234Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M25 298C25 295.239 27.2386 293 30 293H470C472.761 293 475 295.239 475 298V318C475 320.761 472.761 323 470 323H30C27.2386 323 25 320.761 25 318V298Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M25 362C25 359.239 27.2386 357 30 357H366C368.761 357 371 359.239 371 362V382C371 384.761 368.761 387 366 387H30C27.2386 387 25 384.761 25 382V362Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          }
        }
      }
    },
    commentCount: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          status: 'approved',
          customLabel: 'Count: %s',
          linkTo: '',
          // postUrl, customField, authorUrl, authorLink, homeUrl, custom
          linkToUrl: '',
          linkToMetaKey: '',
          linkTarget: '_blank',
          linkAttr: [],
          customUrl: '',
          class: 'commentCount'
        },
        styles: {
          color: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          }
        }
      }
    },
    icon: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'far fa-calendar-alt',
          position: 'beforeCommentCount',

          /*before, after, prefix, postfix */
          class: 'commentCount-icon'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          }
        }
      }
    },
    prefix: {
      type: 'object',
      default: {
        options: {
          text: '',
          class: 'prefix'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          }
        }
      }
    },
    postfix: {
      type: 'object',
      default: {
        options: {
          text: '',
          class: 'postfix'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          }
        }
      }
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    let commentCount = attributes.commentCount;
    var wrapper = attributes.wrapper;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var icon = attributes.icon;
    var prefix = attributes.prefix;
    var postfix = attributes.postfix;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType'];
    const [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(myStore.getBreakPoint());
    const [linkPickerPosttitle, setLinkPickerPosttitle] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    var [currentCommentCount, setcurrentCommentCount] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({
      approved: 0,
      moderated: 0,
      spam: 0,
      total_comments: 0,
      trash: 0,
      'post-trashed': 0,
      all: 0
    });
    var [commentCountEdited, setcommentCountEdited] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(commentCount.options.customLabel);
    var linkToArgsBasic = {
      postUrl: {
        label: 'Post URL',
        value: 'postUrl'
      },
      homeUrl: {
        label: 'Home URL',
        value: 'homeUrl'
      },
      authorUrl: {
        label: 'Author URL',
        value: 'authorUrl'
      },
      authorLink: {
        label: 'Author Link',
        value: 'authorLink'
      },
      authorMail: {
        label: 'Author Mail',
        value: 'authorMail',
        isPro: true
      },
      authorMeta: {
        label: 'Author Meta',
        value: 'authorMeta',
        isPro: true
      },
      customField: {
        label: 'Custom Field',
        value: 'customField',
        isPro: true
      },
      customUrl: {
        label: 'Custom URL',
        value: 'customUrl',
        isPro: true
      }
    };
    let linkToArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_7__.applyFilters)('linkToArgs', linkToArgsBasic);

    function setFieldLinkTo(option, index) {
      var options = { ...commentCount.options,
        linkTo: option.value
      };
      setAttributes({
        commentCount: { ...commentCount,
          options: options
        }
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
        path: '/post-grid/v2/get_comment_count',
        method: 'POST',
        data: {
          id: postId
        }
      }).then(res => {
        setcurrentCommentCount(res);
        setcommentCountEdited(commentCount.options.customLabel.replace('%s', res[commentCount.options.status]));
      });
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setcommentCountEdited(commentCount.options.customLabel.replace('%s', currentCommentCount[commentCount.options.status]));
    }, [commentCount]); // Wrapper CSS Class Selectors

    const wrapperSelector = blockClass;
    var commentCountSelector = blockClass + ' .commentCount';
    const prefixSelector = blockClass + ' .prefix';
    const postfixSelector = blockClass + ' .postfix';
    const iconSelector = blockClass + ' .commentCount-icon';

    function onChangeIcon(arg) {
      var options = { ...icon.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        icon: { ...icon,
          options: options
        }
      });
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, wrapper);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ wrapper: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      // if (blockCssY.items[wrapperSelector] == undefined) {
      //   blockCssY.items[wrapperSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[wrapperSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[wrapperSelector][key] != undefined) {
      //   delete blockCssY.items[wrapperSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // sudoScourceX[key] = {};
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStyleCommentCount(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, commentCount);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        commentCount: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, commentCountSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, commentCount);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ commentCount: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, commentCountSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleCommentCount(sudoScource, key) {
      var object = myStore.deletePropertyDeep(commentCount, [sudoScource, key, breakPointX]);
      setAttributes({
        frontText: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, commentCountSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...commentCount[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // commentCount[sudoScource] = sudoScourceX;
      // setAttributes({ commentCount: { ...commentCount } });
      // if (blockCssY.items[commentCountSelector] == undefined) {
      //   blockCssY.items[commentCountSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[commentCountSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[commentCountSelector][key] != undefined) {
      //   delete blockCssY.items[wrapperSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleCommentCount(sudoScource, key) {
      // var sudoScourceX = { ...commentCount[sudoScource] }
      // sudoScourceX[key] = {};
      // commentCount[sudoScource] = sudoScourceX;
      // setAttributes({ commentCount: { ...commentCount } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, commentCount);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        commentCount: object
      });
    }

    function onChangeStyleIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, icon);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ icon: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = iconSelector;
      // var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(icon, [sudoScource, key, breakPointX]);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...icon[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // icon[sudoScource] = sudoScourceX;
      // setAttributes({ icon: { ...icon } });
      // if (blockCssY.items[iconSelector] == undefined) {
      //   blockCssY.items[iconSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[iconSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[iconSelector][key] != undefined) {
      //   delete blockCssY.items[iconSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        icon: object
      });
    }

    function onChangeStylePrefix(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, prefix);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        prefix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, prefix);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ prefix: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = prefixSelector;
      // var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStylePrefix(sudoScource, key) {
      var object = myStore.deletePropertyDeep(prefix, [sudoScource, key, breakPointX]);
      setAttributes({
        prefix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...prefix[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // prefix[sudoScource] = sudoScourceX;
      // //sudoScourceX[attr][breakPointX] = newVal;
      // setAttributes({ prefix: { ...prefix } });
      // if (blockCssY.items[prefixSelector] == undefined) {
      //   blockCssY.items[prefixSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[prefixSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[prefixSelector][key] != undefined) {
      //   delete blockCssY.items[prefixSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStylePrefix(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, prefix);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        prefix: object
      });
    }

    function onChangeStylePostfix(sudoScource, newVal, attr) {
      var path = sudoScource + '.' + attr + '.' + breakPointX;
      let obj = Object.assign({}, postfix);
      const updatedObj = myStore.setPropertyDeep(obj, path, newVal);
      setAttributes({
        postfix: updatedObj
      });
      var sudoScourceX = { ...updatedObj[sudoScource]
      };
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      sudoScourceX[attr][breakPointX] = newVal;

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      Object.entries(sudoScourceX).map(args => {
        var argAttr = myStore.cssAttrParse(args[0]);
        var argAttrVal = args[1];
        blockCssY.items[elementSelector][argAttr] = argAttrVal;
      });
      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function onRemoveStylePostfix(sudoScource, key) {
      var object = myStore.deletePropertyDeep(postfix, [sudoScource, key, breakPointX]);
      setAttributes({
        postfix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...postfix[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // postfix[sudoScource] = sudoScourceX;
      // //sudoScourceX[attr][breakPointX] = newVal;
      // setAttributes({ postfix: { ...postfix } });
      // if (blockCssY.items[postfixSelector] == undefined) {
      //   blockCssY.items[postfixSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[postfixSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[postfixSelector][key] != undefined) {
      //   delete blockCssY.items[postfixSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStylePostfix(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, postfix);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        postfix: object
      });
    }

    String.prototype.strtr = function (dic) {
      const str = this.toString(),
            makeToken = inx => `{{###~${inx}~###}}`,
            tokens = Object.keys(dic).map((key, inx) => ({
        key,
        val: dic[key],
        token: makeToken(inx)
      })),
            tokenizedStr = tokens.reduce((carry, entry) => carry.replace(new RegExp(entry.key, "g"), entry.token), str);

      return tokens.reduce((carry, entry) => carry.replace(new RegExp(entry.token, "g"), entry.val), tokenizedStr);
    };

    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('');
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      var iconSrc = icon.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      setIconHtml(iconHtml);
    }, [icon]);
    const [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_6__.useEntityProp)('postType', postType, 'link', postId);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      }); // setAttributes({ commentCount: commentCount });
      // setAttributes({ wrapper: wrapper });

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [clientId]);
    var breakPointList = [{
      label: 'Select..',
      icon: '',
      value: ''
    }];

    for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_10__["default"]) {
      var item = _breakpoints__WEBPACK_IMPORTED_MODULE_10__["default"][x];
      breakPointList.push({
        label: item.name,
        icon: item.icon,
        value: item.id
      });
    }

    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }

    var [linkAttrItems, setlinkAttrItems] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({}); // Using the hook.

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      linkAttrObj();
    }, [commentCount]);

    var linkAttrObj = () => {
      var sdsd = {};
      commentCount.options.linkAttr.map(x => {
        if (x.val) sdsd[x.id] = x.val;
      });
      setlinkAttrItems(sdsd);
    };

    const colors = [{
      name: '9DD6DF',
      color: '#9DD6DF'
    }, {
      name: '18978F',
      color: '#18978F'
    }, {
      name: 'A084CF',
      color: '#A084CF'
    }, {
      name: 'DFBB9D',
      color: '#DFBB9D'
    }, {
      name: '774360',
      color: '#774360'
    }, {
      name: '3AB0FF',
      color: '#3AB0FF'
    }, {
      name: '51557E',
      color: '#51557E'
    }];
    const [setSome, setSomeState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
    const [stateX, setStateX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('Old Value');
    const {
      __experimentalSetPreviewDeviceType: setPreviewDeviceType
    } = wp.data.dispatch('core/edit-post');
    var postUrl = commentCount.options.customUrl != undefined && commentCount.options.customUrl.length > 0 ? commentCount.options.customUrl : currentPostUrl;
    const CustomTag = `${wrapper.options.tag}`;
    const CustomTagPostTitle = `${commentCount.options.tag}`;
    return [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.BlockControls, null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.InspectorControls, {
      key: "general"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "px-3",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'No Wrapper',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'span',
        value: 'SPAN'
      }, {
        label: 'div',
        value: 'DIV'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: { ...wrapper,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Comment Count",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Comment Status"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.SelectControl, {
      label: "",
      value: commentCount.options.status,
      options: [{
        label: 'Approved',
        value: 'approved'
      }, {
        label: 'Moderated',
        value: 'moderated'
      }, {
        label: 'Spam',
        value: 'spam'
      }, {
        label: 'Trash',
        value: 'trash'
      }, {
        label: 'Post trashed',
        value: 'post-trashed'
      }, {
        label: 'Total Comments',
        value: 'total_comments'
      }, {
        label: 'All',
        value: 'all'
      }],
      onChange: newVal => {
        var options = { ...commentCount.options,
          status: newVal
        };
        setAttributes({
          commentCount: { ...commentCount,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Label"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      className: "mr-2",
      value: commentCount.options.customLabel,
      onChange: newVal => {
        var options = { ...commentCount.options,
          customLabel: newVal
        };
        setAttributes({
          commentCount: { ...commentCount,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Link To"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_18__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: linkToArgs,
      buttonTitle: commentCount.options.linkTo.length == 0 ? 'Choose' : linkToArgs[commentCount.options.linkTo].label,
      onChange: setFieldLinkTo,
      values: []
    })), commentCount.options.linkTo == 'customField' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Field Key"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      className: "mr-2",
      value: commentCount.options.linkToMetaKey,
      onChange: newVal => {
        var options = { ...commentCount.options,
          linkToMetaKey: newVal
        };
        setAttributes({
          commentCount: { ...commentCount,
            options: options
          }
        });
      }
    })), commentCount.options.linkTo == 'customUrl' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom URL"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.Button, {
      className: linkPickerPosttitle ? "!bg-gray-400" : '',
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
      onClick: ev => {
        setLinkPickerPosttitle(prev => !prev);
      }
    }), commentCount.options.customUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.Button, {
      className: "!text-red-500 ml-2",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
      onClick: ev => {
        var options = { ...commentCount.options,
          customUrl: ''
        };
        setAttributes({
          commentCount: { ...commentCount,
            options: options
          }
        });
        setLinkPickerPosttitle(false);
      }
    }), linkPickerPosttitle && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.Popover, {
      position: "bottom right"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_9__.__experimentalLinkControl, {
      settings: [],
      value: commentCount.options.customUrl,
      onChange: newVal => {
        var options = { ...commentCount.options,
          customUrl: newVal.url
        };
        setAttributes({
          commentCount: { ...commentCount,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "p-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: "font-bold"
    }, "Linked to:"), " ", commentCount.options.customUrl.length != 0 ? commentCount.options.customUrl : 'No link', " ")))), commentCount.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.SelectControl, {
      label: "",
      value: commentCount.options.tag,
      options: [{
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...commentCount.options,
          tag: newVal
        };
        setAttributes({
          commentCount: { ...commentCount,
            options: options
          }
        });
      }
    })), commentCount.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Link Target"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.SelectControl, {
      label: "",
      value: commentCount.options.linkTarget,
      options: [{
        label: 'Choose...',
        value: ''
      }, {
        label: '_self',
        value: '_self'
      }, {
        label: '_blank',
        value: '_blank'
      }, {
        label: '_parent',
        value: '_parent'
      }, {
        label: '_top',
        value: '_top'
      }],
      onChange: newVal => {
        var options = { ...commentCount.options,
          linkTarget: newVal
        };
        setAttributes({
          commentCount: { ...commentCount,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Attributes"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: " cursor-pointer px-3 text-white py-1 bg-blue-600",
      onClick: ev => {
        var sdsd = commentCount.options.linkAttr.concat({
          id: '',
          val: ''
        });
        var options = { ...commentCount.options,
          linkAttr: sdsd
        };
        setAttributes({
          commentCount: { ...commentCount,
            options: options
          }
        });
        linkAttrObj();
      }
    }, "Add")), commentCount.options.linkAttr.map((x, i) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
        className: "my-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
        placeholder: "Name",
        className: "mr-2",
        value: commentCount.options.linkAttr[i].id,
        onChange: newVal => {
          commentCount.options.linkAttr[i].id = newVal;
          var ssdsd = commentCount.options.linkAttr.concat([]);
          var options = { ...commentCount.options,
            linkAttr: ssdsd
          };
          setAttributes({
            commentCount: { ...commentCount,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Value",
        value: x.val,
        onChange: newVal => {
          commentCount.options.linkAttr[i].val = newVal;
          var ssdsd = commentCount.options.linkAttr.concat([]);
          var options = { ...commentCount.options,
            linkAttr: ssdsd
          };
          setAttributes({
            commentCount: { ...commentCount,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
        className: "text-lg cursor-pointer px-3 text-white py-1 bg-red-400 icon-close",
        onClick: ev => {
          commentCount.options.linkAttr.splice(i, 1);
          var ssdsd = commentCount.options.linkAttr.concat([]);
          var options = { ...commentCount.options,
            linkAttr: ssdsd
          };
          setAttributes({
            commentCount: { ...commentCount,
              options: options
            }
          });
        }
      })));
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: commentCount,
      onChange: onChangeStyleCommentCount,
      onAdd: onAddStyleCommentCount,
      onRemove: onRemoveStyleCommentCount
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_19__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: onChangeIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Icon postion"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: 'Choose Position',
        value: ''
      }, {
        label: 'Before Comment Count',
        value: 'beforeCommentCount'
      }, {
        label: 'After Comment Count',
        value: 'afterCommentCount'
      }, {
        label: 'Before Prefix',
        value: 'beforePrefix'
      }, {
        label: 'After Prefix',
        value: 'afterPrefix'
      }, {
        label: 'Before Postfix',
        value: 'beforePostfix'
      }, {
        label: 'After Postfix',
        value: 'afterPostfix'
      }],
      onChange: newVal => {
        var options = { ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Prefix",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Prefix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      value: prefix.options.text,
      onChange: newVal => {
        var options = { ...prefix.options,
          text: newVal
        };
        setAttributes({
          prefix: {
            styles: prefix.styles,
            options: options
          }
        }); // setAttributes({ prefix: { text: newVal, class: prefix.options.class, color: prefix.color, backgroundColor: prefix.backgroundColor } })
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: prefix,
      onChange: onChangeStylePrefix,
      onAdd: onAddStylePrefix,
      onRemove: onRemoveStylePrefix
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Postfix",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Postfix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      value: postfix.options.text,
      onChange: newVal => {
        var options = { ...postfix.options,
          text: newVal
        };
        setAttributes({
          postfix: { ...postfix,
            options: options
          }
        }); // setAttributes({ postfix: { text: newVal, class: prefix.options.class, color: postfix.color, backgroundColor: postfix.backgroundColor } })
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: postfix,
      onChange: onChangeStylePostfix,
      onAdd: onAddStylePostfix,
      onRemove: onRemoveStylePostfix
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Title Wrapper"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, wrapperSelector, '{/* your CSS here*/}'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Title link"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, commentCountSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Prefix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, prefixSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Postfix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, postfixSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_14__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_15__["default"], {
      utm: {
        utm_source: 'BlockPostTitle',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, wrapper.options.tag && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(CustomTag, {
      className: [blockId]
    }, icon.options.position == 'beforePrefix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: prefix.options.class
    }, prefix.options.text), icon.options.position == 'afterPrefix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), commentCount.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("a", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      className: "commentCount",
      onClick: handleLinkClick
    }, linkAttrItems, {
      target: commentCount.options.linkTarget,
      href: postUrl
    }), icon.options.position == 'beforeCommentCount' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: commentCount.options.class
    }, commentCountEdited), icon.options.position == 'afterCommentCount' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), commentCount.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, icon.options.position == 'beforeCommentCount' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: commentCount.options.class
    }, commentCountEdited), icon.options.position == 'afterCommentCount' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), postfix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: postfix.options.class
    }, postfix.options.text), icon.options.position == 'afterPostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), wrapper.options.tag.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: prefix.options.class
    }, prefix.options.text), icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), commentCount.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("a", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      className: "commentCount",
      onClick: handleLinkClick
    }, linkAttrItems, {
      target: commentCount.options.linkTarget,
      href: postUrl
    }), "A", icon.options.position == 'beforeCommentCount' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: commentCount.options.class
    }, commentCountEdited), icon.options.position == 'afterCommentCount' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), commentCount.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: [blockId]
    }, icon.options.position == 'beforeCommentCount' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: commentCount.options.class
    }, commentCountEdited), icon.options.position == 'afterCommentCount' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }))))];
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/post-date/index.js":
/*!***************************************!*\
  !*** ./src/blocks/post-date/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link-off.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_css_display__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/css-display */ "./src/components/css-display/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");














const {
  RawHTML
} = wp.element;














var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__.registerBlockType)("post-grid/post-date", {
  title: "Post Date",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#2563eb',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("svg", {
      width: "500",
      height: "500",
      viewBox: "0 0 500 500",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M25 95C25 92.2386 27.2386 90 30 90H470C472.761 90 475 92.2386 475 95V145C475 147.761 472.761 150 470 150H30C27.2386 150 25 147.761 25 145V95Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M25 234C25 231.239 27.2386 229 30 229H470C472.761 229 475 231.239 475 234V254C475 256.761 472.761 259 470 259H30C27.2386 259 25 256.761 25 254V234Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M25 298C25 295.239 27.2386 293 30 293H470C472.761 293 475 295.239 475 298V318C475 320.761 472.761 323 470 323H30C27.2386 323 25 320.761 25 318V298Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      d: "M25 362C25 359.239 27.2386 357 30 357H366C368.761 357 371 359.239 371 362V382C371 384.761 368.761 387 366 387H30C27.2386 387 25 384.761 25 382V362Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    postDate: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          dateFormat: 'Y-m-d',
          linkTo: '',
          // postUrl, customField, authorUrl, authorLink, homeUrl, custom
          linkToUrl: '',
          linkToMetaKey: '',
          linkTarget: '_blank',
          linkAttr: [],
          customUrl: '',
          class: ''
        },
        styles: {
          display: {},
          width: {},
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          },
          lineHeight: {},
          // { val: '18', unit: 'px' }
          letterSpacing: {},
          // { val: '18', unit: 'px' }
          fontFamily: {},
          fontWeight: {},
          textDecoration: {},
          //overline, line-through, underline
          textTransform: {}
        }
      }
    },
    icon: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'far fa-calendar-alt',
          position: 'beforePostDate',

          /*before, after, prefix, postfix */
          class: 'postdate-icon'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          display: {},
          fontSize: {
            Desktop: ''
          },
          lineHeight: {},
          // { val: '18', unit: 'px' }
          fontWeight: {
            "Desktop": "700"
          },
          textDecoration: {} //overline, line-through, underline

        }
      }
    },
    prefix: {
      type: 'object',
      default: {
        options: {
          text: '',
          class: 'prefix'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          }
        }
      }
    },
    postfix: {
      type: 'object',
      default: {
        options: {
          text: '',
          class: 'prefix'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          }
        }
      }
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    let postDate = attributes.postDate;
    var wrapper = attributes.wrapper;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var icon = attributes.icon;
    var prefix = attributes.prefix;
    var postfix = attributes.postfix;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType'];
    const [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(myStore.getBreakPoint());
    const [customTags, setCustomTags] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
    const [linkPickerPosttitle, setLinkPickerPosttitle] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [dateObj, setdateObj] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
    const [formatedPostDate, setformatedPostDate] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)("");
    var linkToArgsBasic = {
      postUrl: {
        label: 'Post URL',
        value: 'postUrl'
      },
      homeUrl: {
        label: 'Home URL',
        value: 'homeUrl'
      },
      authorUrl: {
        label: 'Author URL',
        value: 'authorUrl'
      },
      authorLink: {
        label: 'Author Link',
        value: 'authorLink'
      },
      authorMail: {
        label: 'Author Mail',
        value: 'authorMail',
        isPro: true
      },
      authorMeta: {
        label: 'Author Meta',
        value: 'authorMeta',
        isPro: true
      },
      customField: {
        label: 'Custom Field',
        value: 'customField',
        isPro: true
      },
      customUrl: {
        label: 'Custom URL',
        value: 'customUrl',
        isPro: true
      }
    };
    let linkToArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__.applyFilters)('linkToArgs', linkToArgsBasic);
    var dateFormats = {
      'Y-M-d': {
        label: '2022-May-25',
        value: 'Y-M-d'
      },
      'Y-m-d': {
        label: '2022-05-25',
        value: 'Y-m-d'
      },
      'd-m-y': {
        label: '25-05-2022',
        value: 'd-m-y'
      },
      'd/m/y': {
        label: '25/05/2022',
        value: 'd/m/y'
      },
      'y-m-d': {
        label: '2022-05-25',
        value: 'y-m-d'
      },
      'y/m/d': {
        label: '2022/05/25',
        value: 'y/m/d'
      },
      'D M y': {
        label: 'Sun May 2022',
        value: 'D M y'
      },
      'D M d, y': {
        label: 'Sun May 11, 2022',
        value: 'D M d, y'
      },
      'M D d, y': {
        label: 'May Sun 11, 2022',
        value: 'M D d, y'
      },
      'M d, y': {
        label: 'May 11, 2022',
        value: 'M d, y'
      },
      'd M y': {
        label: '25 May 2022',
        value: 'd M y'
      }
    };
    var dateNames = ["Satureday", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday"];
    var dateNamesShort = ["Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri"];
    var MonthNames = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
    var MonthNamesShort = ["Jan", "Feb", "Mar", "Apr", "May", "June", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    const [currentPostDate, setcurrentPostDate] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__.useEntityProp)('postType', postType, 'date', postId);
    const [postDateEdited, setpostDateEdited] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(currentPostDate);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      var dateFormat = postDate.options.dateFormat;
      var dateFormat = dateFormat.replace("d", "{d}");
      var dateFormat = dateFormat.replace("D", "{D}");
      var dateFormat = dateFormat.replace("M", "{M}");
      var dateFormat = dateFormat.replace("m", "{m}");
      var dateFormat = dateFormat.replace("y", "{y}");
      var dateFormat = dateFormat.replace("Y", "{Y}");
      var dateFormat = dateFormat.replace("h", "{h}");
      var dateFormat = dateFormat.replace("H", "{H}");
      var dateFormat = dateFormat.replace("i", "{i}");
      var dateFormat = dateFormat.replace("s", "{s}");
      var dateFormat = dateFormat.replace("A", "{A}");
      var dateFormat = dateFormat.replace("a", "{a}");
      const date = new Date(currentPostDate);
      var amOrPm = date.getHours() < 12 ? "AM" : "PM";
      dateObj["{d}"] = date.getDate();
      dateObj["{D}"] = dateNamesShort[date.getDay()];
      dateObj["{M}"] = MonthNamesShort[date.getMonth()];
      dateObj["{m}"] = date.getMonth() + 1;
      dateObj["{y}"] = date.getFullYear();
      dateObj['{Y}'] = date.getFullYear();
      dateObj["{h}"] = date.getHours();
      dateObj["{H}"] = date.getHours();
      dateObj["{i}"] = date.getMinutes();
      dateObj["{s}"] = date.getSeconds();
      dateObj["{A}"] = amOrPm;
      dateObj["{a}"] = amOrPm.toLowerCase();
      setpostDateEdited(dateFormat.strtr(dateObj));
    }, [currentPostDate, postDate.options.dateFormat]);

    function onChangeIcon(arg) {
      var options = { ...icon.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        icon: { ...icon,
          options: options
        }
      });
    }

    function setFieldLinkTo(option, index) {
      var options = { ...postDate.options,
        linkTo: option.value
      };
      setAttributes({
        postDate: { ...postDate,
          options: options
        }
      });
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, wrapper);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ wrapper: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...wrapper[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      // if (blockCssY.items[wrapperSelector] == undefined) {
      //   blockCssY.items[wrapperSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[wrapperSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[wrapperSelector][key] != undefined) {
      //   delete blockCssY.items[wrapperSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleWrapper(sudoScource, key) {
      // var sudoScourceX = { ...wrapper[sudoScource] }
      // sudoScourceX[key] = {};
      // wrapper[sudoScource] = sudoScourceX;
      // setAttributes({ wrapper: { ...wrapper } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStylePostDate(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, postDate);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        postDate: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postDateSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, postDate);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ postDate: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, postDateSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStylePostDate(sudoScource, key) {
      var object = myStore.deletePropertyDeep(postDate, [sudoScource, key, breakPointX]);
      setAttributes({
        postDate: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postDateSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...postDate[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // postDate[sudoScource] = sudoScourceX;
      // setAttributes({ postDate: { ...postDate } });
      // if (blockCssY.items[postDateSelector] == undefined) {
      //   blockCssY.items[postDateSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[postDateSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[postDateSelector][key] != undefined) {
      //   delete blockCssY.items[postDateSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStylePostDate(sudoScource, key) {
      // var sudoScourceX = { ...postDate[sudoScource] }
      // sudoScourceX[key] = {};
      // postDate[sudoScource] = sudoScourceX;
      // setAttributes({ postDate: { ...postDate } });
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, postDate);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        postDate: object
      });
    }

    function onChangeStyleIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, icon);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ icon: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStyleIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(icon, [sudoScource, key, breakPointX]);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...icon[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // icon[sudoScource] = sudoScourceX;
      // setAttributes({ icon: { ...icon } });
      // if (blockCssY.items[iconSelector] == undefined) {
      //   blockCssY.items[iconSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[iconSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[iconSelector][key] != undefined) {
      //   delete blockCssY.items[iconSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        icon: object
      });
    }

    function onChangeStylePrefix(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, prefix);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        prefix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(attr);

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(blockCssY.items, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      }); // var path = sudoScource + '.' + attr + '.' + breakPointX
      // let obj = Object.assign({}, prefix);
      // const updatedObj = myStore.setPropertyDeep(obj, path, newVal)
      // setAttributes({ prefix: updatedObj });
      // var sudoScourceX = { ...updatedObj[sudoScource] }
      // var sudoScourceX = { ...prefix[sudoScource] }
      // var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      // sudoScourceX[attr][breakPointX] = newVal;
      // if (blockCssY.items[elementSelector] == undefined) {
      //   blockCssY.items[elementSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[elementSelector][argAttr] = argAttrVal;
      // })
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onRemoveStylePrefix(sudoScource, key) {
      var object = myStore.deletePropertyDeep(prefix, [sudoScource, key, breakPointX]);
      setAttributes({
        prefix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      }); // var sudoScourceX = { ...prefix[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // prefix[sudoScource] = sudoScourceX;
      // //sudoScourceX[attr][breakPointX] = newVal;
      // setAttributes({ prefix: { ...prefix } });
      // if (blockCssY.items[prefixSelector] == undefined) {
      //   blockCssY.items[prefixSelector] = {};
      // }
      // Object.entries(sudoScourceX).map(args => {
      //   var argAttr = myStore.cssAttrParse(args[0]);
      //   var argAttrVal = args[1];
      //   blockCssY.items[prefixSelector][argAttr] = argAttrVal;
      // })
      // if (blockCssY.items[prefixSelector][key] != undefined) {
      //   delete blockCssY.items[prefixSelector][key];
      // }
      // setAttributes({ blockCssY: { items: blockCssY.items } });
    }

    function onAddStylePrefix(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, prefix);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        prefix: object
      });
    }

    function onChangeStylePostfix(sudoScource, newVal, attr) {
      var path = sudoScource + '.' + attr + '.' + breakPointX;
      let obj = Object.assign({}, postfix);
      const updatedObj = myStore.setPropertyDeep(obj, path, newVal);
      setAttributes({
        postfix: updatedObj
      });
      var sudoScourceX = { ...updatedObj[sudoScource]
      };
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      sudoScourceX[attr][breakPointX] = newVal;

      if (blockCssY.items[elementSelector] == undefined) {
        blockCssY.items[elementSelector] = {};
      }

      Object.entries(sudoScourceX).map(args => {
        var argAttr = myStore.cssAttrParse(args[0]);
        var argAttrVal = args[1];
        blockCssY.items[elementSelector][argAttr] = argAttrVal;
      });
      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }

    function onRemoveStylePostfix(sudoScource, key) {// var sudoScourceX = { ...postfix[sudoScource] }
      // if (sudoScourceX[key] != undefined) {
      //   delete sudoScourceX[key];
      // }
      // postfix[sudoScource] = sudoScourceX;
      // //sudoScourceX[attr][breakPointX]