<?php
/*
 * Plugin Name:		Highlight Searched Terms in Results
 * Description:		Add support for highlighting search results
 * Text Domain:		highlight-search-terms-results
 * Domain Path:		/languages
 * Version:		1.04
 * WordPress URI:	https://wordpress.org/plugins/highlight-search-terms-results/
 * Plugin URI:		https://puvox.software/software/wordpress-plugins/?plugin=highlight-search-terms-results
 * Contributors: 	puvoxsoftware,ttodua
 * Author:		Puvox.software
 * Author URI:		https://puvox.software/
 * Donate Link:		https://paypal.me/Puvox
 * License:		GPL-3.0
 * License URI:		https://www.gnu.org/licenses/gpl-3.0.html
 
 * @copyright:		Puvox.software
*/


namespace HighlightSearchTermsResults
{
  if (!defined('ABSPATH')) exit;
  require_once( __DIR__."/library.php" );
  require_once( __DIR__."/library_wp.php" );
  
  class PluginClass extends \Puvox\wp_plugin
  {

	public function declare_settings()
	{
		$this->initial_static_options	= 
		[
			'has_pro_version'        => 0, 
            'show_opts'              => true, 
            'show_rating_message'    => true, 
            'show_donation_footer'   => true, 
            'show_donation_popup'    => true, 
            'menu_pages'             => [
                'first' =>[
                    'title'           => 'Highlight Searched Terms', 
                    'default_managed' => 'network',            // network | singlesite
                    'required_role'   => 'install_plugins',
                    'level'           => 'submenu', 
                    'page_title'      => 'Highlight Searched Terms in Results',
                    'tabs'            => [],
                ],
            ]
		];

		$this->initial_user_options		= 
		[	
			'enable_for_feeds'	=> true,
			'background_color'	=> '#EBBABA',
			'tooltip_to_search'	=> 'Use &quot;double quoted&quot; for exact sentence match',
			'tooltip_css'		=> false,
		]; 
	}

	public function __construct_my()
	{
		add_filter('the_content',		[$this, 'highlight_results']);
		add_filter('the_excerpt',		[$this, 'highlight_results']);
		add_filter('the_title',			[$this, 'highlight_results']);
		if ($this->opts['enable_for_feeds'])
		{
			add_filter('the_content_rss',	[$this, 'highlight_results']);
			add_filter('the_content_feed',	[$this, 'highlight_results']);
			add_filter('the_excerpt_rss',	[$this, 'highlight_results']);
			add_filter('the_excerpt_feed',	[$this, 'highlight_results']);
			add_filter('the_title_rss',		[$this, 'highlight_results']);
			add_filter('the_title_feed',	[$this, 'highlight_results']);
		}
		
		add_filter('get_search_form',	[$this, 'get_search_form']);
		
		add_action('wp_head', function(){ if (is_search()) echo '<style>.search_matched_phrase{background:'.($this->opts['background_color']).'; padding:2px; font-weight:bold; } </style>'; } );
	}

	// ============================================================================================================== //

	// Add Bold to searched term
	public function highlight_results($text){
		 if(!is_admin() && is_search()){
			 $sr = get_query_var('s');
			 $keys = array_filter(explode(" ",$sr));
			 $text = preg_replace_callback('/('.implode('|', $keys) .')/iu', function ($matches) { return '<span class="search_matched_phrase">'.$matches[1].'</span>'; } , $text);
		 }
		 return $text;
	}
	
	// add tooltip
	// TODO: better- https://stackoverflow.com/questions/19480010/
	public function get_search_form($form){
		
		if ($this->opts['tooltip_css'])
			$form = preg_replace('/\<input(.*?)name\=\"s\"(.*?)\>/', "<span class=\"HSTR_tooltip\">$0<span class=\"HSTR_tooltiptext\">".($this->opts['tooltip_to_search']). "</span></span>", $form);
		else
			$form = preg_replace('/name\=\"s\"/', "$1 title=\"".($this->opts['tooltip_to_search'])."\"", $form);
		return $form;
	}
	
 
	// =================================== Options page ================================ //
	public function opts_page_output()
	{
		$this->settings_page_part("start", 'first');
		?>

		<style> 
		</style>

		<?php if ($this->active_tab=="Options") 
		{ 
			//if form updated
			if( $this->checkSubmission() )
			{ 
				$this->opts['enable_for_feeds']	= !empty($_POST[ $this->plugin_slug ]['enable_for_feeds']) ;  
				$this->opts['background_color']	= "#". sanitize_key($_POST[ $this->plugin_slug ]['background_color']) ;  
				$this->opts['tooltip_to_search']= stripslashes( htmlentities( sanitize_text_field($_POST[ $this->plugin_slug ]['tooltip_to_search']) ) ) ; 
				//$this->opts['tooltip_css']		= !empty($_POST[ $this->plugin_slug ]['tooltip_css']); 
				$this->update_opts();  
			}
			?>
 
			<form class="mainForm" method="post" action="">

			<table class="form-table">
				<tr class="def">
					<th scope="row">
						<label for="enable_for_feeds">
							<?php _e('Enable also inside <code>rss,feed</code>:', 'search-results-highlight');?>
						</label>
					</th>
					<td>
						<fieldset>
							<div class="clearboth"></div>
							<div class="">
								<input name="<?php echo $this->plugin_slug;?>[enable_for_feeds]" type="checkbox" <?php checked($this->opts['enable_for_feeds']);?> > 
							</div>
						</fieldset>
					</td>
				</tr>
				<tr class="def">
					<th scope="row">
						<label for="background_color">
							<?php _e('Choose color of highligh:', 'search-results-highlight');?>
						</label>
					</th>
					<td>
						<fieldset>
							<div class="clearboth"></div>
							<div class="">
								<input name="<?php echo $this->plugin_slug;?>[background_color]" type="color" value="<?php echo ($this->opts['background_color']);?>" > 
							</div>
						</fieldset>
					</td>
				</tr>
				<tr class="def">
					<th scope="row">
						<label for="tooltip_to_search">
							<?php _e('Add tooltip onto search field (shows up on mouseover):', 'search-results-highlight');?>
						</label>
					</th>
					<td>
						<fieldset>
							<div class="clearboth"></div>
							<div class="">
								<input name="<?php echo $this->plugin_slug;?>[tooltip_to_search]" type="text" class="large-text" value="<?php echo ($this->opts['tooltip_to_search']);?>" title="<?php echo ($this->opts['tooltip_to_search']);?>" > 
								<p class="description">
								( <?php _e('Mouseover the above field itself, to see how it will show up on search-field', 'search-results-highlight');?> )
								</p>
								<!-- ( <?php _e('Use CSS instead of "title" tag', 'search-results-highlight');?> <input name="<?php echo $this->plugin_slug;?>[tooltip_css]" type="checkbox" <?php checked($this->opts['tooltip_css']);?> > ) -->
							</div>
						</fieldset>
					</td>
				</tr>
				<tr class="def">
					<th scope="row">
						<?php _e('Change styling', 'search-results-highlight');?>
					</th>
					<td>
						<?php _e('To change the styling further, you can go to <code>Customizer&gt;Additional CSS&gt;</code> add your definition:<code>.search_matched_phrase{background:red;}</code>', 'search-results-highlight');?>
					</td>
				</tr>
			</table>
			
			<?php $this->nonceSubmit(); ?>

			</form> 
		<?php 
		}
		

		$this->settings_page_part("end", '');
	} 





  } // End Of Class

  $GLOBALS[__NAMESPACE__] = new PluginClass();

 
} // End Of NameSpace

?>