<?php
class Logger {
    private $log_file;

    public function __construct() {
        // Set up the log file path.
        $this->log_file = plugin_dir_path(__FILE__) . 'logs/hubspot_logs.txt';       
    }

    // Function to display the log viewer page
    public function log_viewer_page() {        
        $logs = '';        
        $logs.='<div class="wrap">
                <h2>HubSpot Logs</h2>
                <div class="code-editor">
                    <pre>
                    <code>';  
                foreach ($this->get_logs() as $log) {
                    $logs.=" esc_html($log) . '<br>'";
                }                              
        $logs.='</code></pre></div></div>';       
    }


    private function display_logs() {
        if (isset($_POST['clear_logs'])) {
            // Clear the logs if the "Clear Logs" button is clicked.
            $this->clear_logs();
        }

        echo '<div class="wrap">';
        echo '<form method="post">';
        echo '<h2>HubSpot Logs</h2>';
        echo '<input type="hidden" name="clear_logs" value="1" />';
        echo '<p><strong>Logs:</strong></p>';
        //echo '<pre>';
        echo '<code>';
        $logs = $this->get_logs();
        foreach ($logs as $log) {
            echo esc_html($log) . "<br>";
        }
        echo '</code>';
        //echo '</pre>';
        echo '<input type="submit" class="button" value="Clear Logs" />';
        echo '</form>';
        echo '</div>';
    }

    public function log($message) {
        // Log a message to the log file.
        $timestamp = date('Y-m-d H:i:s');
        $log_message = "[$timestamp] $message\n";
        file_put_contents($this->log_file, $log_message, FILE_APPEND);
    }

    private function get_logs() {
        // Retrieve and return logs from the log file.
        if (file_exists($this->log_file) && is_readable($this->log_file)) {
            return explode("\n", file_get_contents($this->log_file));
        }
        return array();
    }

    private function clear_logs( WP_User  $currentuser  ) {
        // Clear the log file.
        file_put_contents($this->log_file, '');
        $this->log( "Logs cleared by ".$this->current_user->user_email );
    }
    
}
