/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@splidejs/react-splide/dist/js/react-splide.esm.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@splidejs/react-splide/dist/js/react-splide.esm.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Splide": () => (/* binding */ Splide2),
/* harmony export */   "SplideSlide": () => (/* binding */ SplideSlide),
/* harmony export */   "SplideTrack": () => (/* binding */ SplideTrack)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// node_modules/@splidejs/splide/dist/js/splide.esm.js
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", { writable: false });
  return Constructor;
}
var MEDIA_PREFERS_REDUCED_MOTION = "(prefers-reduced-motion: reduce)";
var CREATED = 1;
var MOUNTED = 2;
var IDLE = 3;
var MOVING = 4;
var SCROLLING = 5;
var DRAGGING = 6;
var DESTROYED = 7;
var STATES = {
  CREATED,
  MOUNTED,
  IDLE,
  MOVING,
  SCROLLING,
  DRAGGING,
  DESTROYED
};
function empty(array) {
  array.length = 0;
}
function slice(arrayLike, start, end) {
  return Array.prototype.slice.call(arrayLike, start, end);
}
function apply(func) {
  return func.bind.apply(func, [null].concat(slice(arguments, 1)));
}
var nextTick = setTimeout;
var noop = function noop2() {
};
function raf(func) {
  return requestAnimationFrame(func);
}
function typeOf(type, subject) {
  return typeof subject === type;
}
function isObject(subject) {
  return !isNull(subject) && typeOf("object", subject);
}
var isArray = Array.isArray;
var isFunction = apply(typeOf, "function");
var isString = apply(typeOf, "string");
var isUndefined = apply(typeOf, "undefined");
function isNull(subject) {
  return subject === null;
}
function isHTMLElement(subject) {
  try {
    return subject instanceof (subject.ownerDocument.defaultView || window).HTMLElement;
  } catch (e) {
    return false;
  }
}
function toArray(value) {
  return isArray(value) ? value : [value];
}
function forEach(values, iteratee) {
  toArray(values).forEach(iteratee);
}
function includes(array, value) {
  return array.indexOf(value) > -1;
}
function push(array, items) {
  array.push.apply(array, toArray(items));
  return array;
}
function toggleClass(elm, classes, add) {
  if (elm) {
    forEach(classes, function(name) {
      if (name) {
        elm.classList[add ? "add" : "remove"](name);
      }
    });
  }
}
function addClass(elm, classes) {
  toggleClass(elm, isString(classes) ? classes.split(" ") : classes, true);
}
function append(parent, children2) {
  forEach(children2, parent.appendChild.bind(parent));
}
function before(nodes, ref) {
  forEach(nodes, function(node) {
    var parent = (ref || node).parentNode;
    if (parent) {
      parent.insertBefore(node, ref);
    }
  });
}
function matches(elm, selector) {
  return isHTMLElement(elm) && (elm["msMatchesSelector"] || elm.matches).call(elm, selector);
}
function children(parent, selector) {
  var children2 = parent ? slice(parent.children) : [];
  return selector ? children2.filter(function(child2) {
    return matches(child2, selector);
  }) : children2;
}
function child(parent, selector) {
  return selector ? children(parent, selector)[0] : parent.firstElementChild;
}
var ownKeys = Object.keys;
function forOwn(object, iteratee, right) {
  if (object) {
    (right ? ownKeys(object).reverse() : ownKeys(object)).forEach(function(key) {
      key !== "__proto__" && iteratee(object[key], key);
    });
  }
  return object;
}
function assign(object) {
  slice(arguments, 1).forEach(function(source) {
    forOwn(source, function(value, key) {
      object[key] = source[key];
    });
  });
  return object;
}
function merge(object) {
  slice(arguments, 1).forEach(function(source) {
    forOwn(source, function(value, key) {
      if (isArray(value)) {
        object[key] = value.slice();
      } else if (isObject(value)) {
        object[key] = merge({}, isObject(object[key]) ? object[key] : {}, value);
      } else {
        object[key] = value;
      }
    });
  });
  return object;
}
function omit(object, keys) {
  forEach(keys || ownKeys(object), function(key) {
    delete object[key];
  });
}
function removeAttribute(elms, attrs) {
  forEach(elms, function(elm) {
    forEach(attrs, function(attr) {
      elm && elm.removeAttribute(attr);
    });
  });
}
function setAttribute(elms, attrs, value) {
  if (isObject(attrs)) {
    forOwn(attrs, function(value2, name) {
      setAttribute(elms, name, value2);
    });
  } else {
    forEach(elms, function(elm) {
      isNull(value) || value === "" ? removeAttribute(elm, attrs) : elm.setAttribute(attrs, String(value));
    });
  }
}
function create(tag, attrs, parent) {
  var elm = document.createElement(tag);
  if (attrs) {
    isString(attrs) ? addClass(elm, attrs) : setAttribute(elm, attrs);
  }
  parent && append(parent, elm);
  return elm;
}
function style(elm, prop, value) {
  if (isUndefined(value)) {
    return getComputedStyle(elm)[prop];
  }
  if (!isNull(value)) {
    elm.style[prop] = "" + value;
  }
}
function display(elm, display2) {
  style(elm, "display", display2);
}
function focus(elm) {
  elm["setActive"] && elm["setActive"]() || elm.focus({
    preventScroll: true
  });
}
function getAttribute(elm, attr) {
  return elm.getAttribute(attr);
}
function hasClass(elm, className) {
  return elm && elm.classList.contains(className);
}
function rect(target) {
  return target.getBoundingClientRect();
}
function remove(nodes) {
  forEach(nodes, function(node) {
    if (node && node.parentNode) {
      node.parentNode.removeChild(node);
    }
  });
}
function parseHtml(html) {
  return child(new DOMParser().parseFromString(html, "text/html").body);
}
function prevent(e, stopPropagation) {
  e.preventDefault();
  if (stopPropagation) {
    e.stopPropagation();
    e.stopImmediatePropagation();
  }
}
function query(parent, selector) {
  return parent && parent.querySelector(selector);
}
function queryAll(parent, selector) {
  return selector ? slice(parent.querySelectorAll(selector)) : [];
}
function removeClass(elm, classes) {
  toggleClass(elm, classes, false);
}
function timeOf(e) {
  return e.timeStamp;
}
function unit(value) {
  return isString(value) ? value : value ? value + "px" : "";
}
var PROJECT_CODE = "splide";
var DATA_ATTRIBUTE = "data-" + PROJECT_CODE;
function assert(condition, message) {
  if (!condition) {
    throw new Error("[" + PROJECT_CODE + "] " + (message || ""));
  }
}
var min = Math.min;
var max = Math.max;
var floor = Math.floor;
var ceil = Math.ceil;
var abs = Math.abs;
function approximatelyEqual(x, y, epsilon) {
  return abs(x - y) < epsilon;
}
function between(number, x, y, exclusive) {
  var minimum = min(x, y);
  var maximum = max(x, y);
  return exclusive ? minimum < number && number < maximum : minimum <= number && number <= maximum;
}
function clamp(number, x, y) {
  var minimum = min(x, y);
  var maximum = max(x, y);
  return min(max(minimum, number), maximum);
}
function sign(x) {
  return +(x > 0) - +(x < 0);
}
function format(string, replacements) {
  forEach(replacements, function(replacement) {
    string = string.replace("%s", "" + replacement);
  });
  return string;
}
function pad(number) {
  return number < 10 ? "0" + number : "" + number;
}
var ids = {};
function uniqueId(prefix) {
  return "" + prefix + pad(ids[prefix] = (ids[prefix] || 0) + 1);
}
function EventBinder() {
  var listeners = [];
  function bind(targets, events, callback, options) {
    forEachEvent(targets, events, function(target, event, namespace) {
      var isEventTarget = "addEventListener" in target;
      var remover = isEventTarget ? target.removeEventListener.bind(target, event, callback, options) : target["removeListener"].bind(target, callback);
      isEventTarget ? target.addEventListener(event, callback, options) : target["addListener"](callback);
      listeners.push([target, event, namespace, callback, remover]);
    });
  }
  function unbind(targets, events, callback) {
    forEachEvent(targets, events, function(target, event, namespace) {
      listeners = listeners.filter(function(listener) {
        if (listener[0] === target && listener[1] === event && listener[2] === namespace && (!callback || listener[3] === callback)) {
          listener[4]();
          return false;
        }
        return true;
      });
    });
  }
  function dispatch(target, type, detail) {
    var e;
    var bubbles = true;
    if (typeof CustomEvent === "function") {
      e = new CustomEvent(type, {
        bubbles,
        detail
      });
    } else {
      e = document.createEvent("CustomEvent");
      e.initCustomEvent(type, bubbles, false, detail);
    }
    target.dispatchEvent(e);
    return e;
  }
  function forEachEvent(targets, events, iteratee) {
    forEach(targets, function(target) {
      target && forEach(events, function(events2) {
        events2.split(" ").forEach(function(eventNS) {
          var fragment = eventNS.split(".");
          iteratee(target, fragment[0], fragment[1]);
        });
      });
    });
  }
  function destroy() {
    listeners.forEach(function(data) {
      data[4]();
    });
    empty(listeners);
  }
  return {
    bind,
    unbind,
    dispatch,
    destroy
  };
}
var EVENT_MOUNTED = "mounted";
var EVENT_READY = "ready";
var EVENT_MOVE = "move";
var EVENT_MOVED = "moved";
var EVENT_CLICK = "click";
var EVENT_ACTIVE = "active";
var EVENT_INACTIVE = "inactive";
var EVENT_VISIBLE = "visible";
var EVENT_HIDDEN = "hidden";
var EVENT_REFRESH = "refresh";
var EVENT_UPDATED = "updated";
var EVENT_RESIZE = "resize";
var EVENT_RESIZED = "resized";
var EVENT_DRAG = "drag";
var EVENT_DRAGGING = "dragging";
var EVENT_DRAGGED = "dragged";
var EVENT_SCROLL = "scroll";
var EVENT_SCROLLED = "scrolled";
var EVENT_OVERFLOW = "overflow";
var EVENT_DESTROY = "destroy";
var EVENT_ARROWS_MOUNTED = "arrows:mounted";
var EVENT_ARROWS_UPDATED = "arrows:updated";
var EVENT_PAGINATION_MOUNTED = "pagination:mounted";
var EVENT_PAGINATION_UPDATED = "pagination:updated";
var EVENT_NAVIGATION_MOUNTED = "navigation:mounted";
var EVENT_AUTOPLAY_PLAY = "autoplay:play";
var EVENT_AUTOPLAY_PLAYING = "autoplay:playing";
var EVENT_AUTOPLAY_PAUSE = "autoplay:pause";
var EVENT_LAZYLOAD_LOADED = "lazyload:loaded";
var EVENT_SLIDE_KEYDOWN = "sk";
var EVENT_SHIFTED = "sh";
var EVENT_END_INDEX_CHANGED = "ei";
function EventInterface(Splide22) {
  var bus = Splide22 ? Splide22.event.bus : document.createDocumentFragment();
  var binder = EventBinder();
  function on(events, callback) {
    binder.bind(bus, toArray(events).join(" "), function(e) {
      callback.apply(callback, isArray(e.detail) ? e.detail : []);
    });
  }
  function emit(event) {
    binder.dispatch(bus, event, slice(arguments, 1));
  }
  if (Splide22) {
    Splide22.event.on(EVENT_DESTROY, binder.destroy);
  }
  return assign(binder, {
    bus,
    on,
    off: apply(binder.unbind, bus),
    emit
  });
}
function RequestInterval(interval, onInterval, onUpdate, limit) {
  var now = Date.now;
  var startTime;
  var rate = 0;
  var id;
  var paused = true;
  var count = 0;
  function update() {
    if (!paused) {
      rate = interval ? min((now() - startTime) / interval, 1) : 1;
      onUpdate && onUpdate(rate);
      if (rate >= 1) {
        onInterval();
        startTime = now();
        if (limit && ++count >= limit) {
          return pause();
        }
      }
      id = raf(update);
    }
  }
  function start(resume) {
    resume || cancel();
    startTime = now() - (resume ? rate * interval : 0);
    paused = false;
    id = raf(update);
  }
  function pause() {
    paused = true;
  }
  function rewind() {
    startTime = now();
    rate = 0;
    if (onUpdate) {
      onUpdate(rate);
    }
  }
  function cancel() {
    id && cancelAnimationFrame(id);
    rate = 0;
    id = 0;
    paused = true;
  }
  function set(time) {
    interval = time;
  }
  function isPaused() {
    return paused;
  }
  return {
    start,
    rewind,
    pause,
    cancel,
    set,
    isPaused
  };
}
function State(initialState) {
  var state = initialState;
  function set(value) {
    state = value;
  }
  function is(states) {
    return includes(toArray(states), state);
  }
  return {
    set,
    is
  };
}
function Throttle(func, duration) {
  var interval = RequestInterval(duration || 0, func, null, 1);
  return function() {
    interval.isPaused() && interval.start();
  };
}
function Media(Splide22, Components2, options) {
  var state = Splide22.state;
  var breakpoints = options.breakpoints || {};
  var reducedMotion = options.reducedMotion || {};
  var binder = EventBinder();
  var queries = [];
  function setup() {
    var isMin = options.mediaQuery === "min";
    ownKeys(breakpoints).sort(function(n, m) {
      return isMin ? +n - +m : +m - +n;
    }).forEach(function(key) {
      register(breakpoints[key], "(" + (isMin ? "min" : "max") + "-width:" + key + "px)");
    });
    register(reducedMotion, MEDIA_PREFERS_REDUCED_MOTION);
    update();
  }
  function destroy(completely) {
    if (completely) {
      binder.destroy();
    }
  }
  function register(options2, query2) {
    var queryList = matchMedia(query2);
    binder.bind(queryList, "change", update);
    queries.push([options2, queryList]);
  }
  function update() {
    var destroyed = state.is(DESTROYED);
    var direction = options.direction;
    var merged = queries.reduce(function(merged2, entry) {
      return merge(merged2, entry[1].matches ? entry[0] : {});
    }, {});
    omit(options);
    set(merged);
    if (options.destroy) {
      Splide22.destroy(options.destroy === "completely");
    } else if (destroyed) {
      destroy(true);
      Splide22.mount();
    } else {
      direction !== options.direction && Splide22.refresh();
    }
  }
  function reduce(enable) {
    if (matchMedia(MEDIA_PREFERS_REDUCED_MOTION).matches) {
      enable ? merge(options, reducedMotion) : omit(options, ownKeys(reducedMotion));
    }
  }
  function set(opts, base, notify) {
    merge(options, opts);
    base && merge(Object.getPrototypeOf(options), opts);
    if (notify || !state.is(CREATED)) {
      Splide22.emit(EVENT_UPDATED, options);
    }
  }
  return {
    setup,
    destroy,
    reduce,
    set
  };
}
var ARROW = "Arrow";
var ARROW_LEFT = ARROW + "Left";
var ARROW_RIGHT = ARROW + "Right";
var ARROW_UP = ARROW + "Up";
var ARROW_DOWN = ARROW + "Down";
var RTL = "rtl";
var TTB = "ttb";
var ORIENTATION_MAP = {
  width: ["height"],
  left: ["top", "right"],
  right: ["bottom", "left"],
  x: ["y"],
  X: ["Y"],
  Y: ["X"],
  ArrowLeft: [ARROW_UP, ARROW_RIGHT],
  ArrowRight: [ARROW_DOWN, ARROW_LEFT]
};
function Direction(Splide22, Components2, options) {
  function resolve(prop, axisOnly, direction) {
    direction = direction || options.direction;
    var index = direction === RTL && !axisOnly ? 1 : direction === TTB ? 0 : -1;
    return ORIENTATION_MAP[prop] && ORIENTATION_MAP[prop][index] || prop.replace(/width|left|right/i, function(match, offset) {
      var replacement = ORIENTATION_MAP[match.toLowerCase()][index] || match;
      return offset > 0 ? replacement.charAt(0).toUpperCase() + replacement.slice(1) : replacement;
    });
  }
  function orient(value) {
    return value * (options.direction === RTL ? 1 : -1);
  }
  return {
    resolve,
    orient
  };
}
var ROLE = "role";
var TAB_INDEX = "tabindex";
var DISABLED = "disabled";
var ARIA_PREFIX = "aria-";
var ARIA_CONTROLS = ARIA_PREFIX + "controls";
var ARIA_CURRENT = ARIA_PREFIX + "current";
var ARIA_SELECTED = ARIA_PREFIX + "selected";
var ARIA_LABEL = ARIA_PREFIX + "label";
var ARIA_LABELLEDBY = ARIA_PREFIX + "labelledby";
var ARIA_HIDDEN = ARIA_PREFIX + "hidden";
var ARIA_ORIENTATION = ARIA_PREFIX + "orientation";
var ARIA_ROLEDESCRIPTION = ARIA_PREFIX + "roledescription";
var ARIA_LIVE = ARIA_PREFIX + "live";
var ARIA_BUSY = ARIA_PREFIX + "busy";
var ARIA_ATOMIC = ARIA_PREFIX + "atomic";
var ALL_ATTRIBUTES = [ROLE, TAB_INDEX, DISABLED, ARIA_CONTROLS, ARIA_CURRENT, ARIA_LABEL, ARIA_LABELLEDBY, ARIA_HIDDEN, ARIA_ORIENTATION, ARIA_ROLEDESCRIPTION];
var CLASS_PREFIX = PROJECT_CODE + "__";
var STATUS_CLASS_PREFIX = "is-";
var CLASS_ROOT = PROJECT_CODE;
var CLASS_TRACK = CLASS_PREFIX + "track";
var CLASS_LIST = CLASS_PREFIX + "list";
var CLASS_SLIDE = CLASS_PREFIX + "slide";
var CLASS_CLONE = CLASS_SLIDE + "--clone";
var CLASS_CONTAINER = CLASS_SLIDE + "__container";
var CLASS_ARROWS = CLASS_PREFIX + "arrows";
var CLASS_ARROW = CLASS_PREFIX + "arrow";
var CLASS_ARROW_PREV = CLASS_ARROW + "--prev";
var CLASS_ARROW_NEXT = CLASS_ARROW + "--next";
var CLASS_PAGINATION = CLASS_PREFIX + "pagination";
var CLASS_PAGINATION_PAGE = CLASS_PAGINATION + "__page";
var CLASS_PROGRESS = CLASS_PREFIX + "progress";
var CLASS_PROGRESS_BAR = CLASS_PROGRESS + "__bar";
var CLASS_TOGGLE = CLASS_PREFIX + "toggle";
var CLASS_TOGGLE_PLAY = CLASS_TOGGLE + "__play";
var CLASS_TOGGLE_PAUSE = CLASS_TOGGLE + "__pause";
var CLASS_SPINNER = CLASS_PREFIX + "spinner";
var CLASS_SR = CLASS_PREFIX + "sr";
var CLASS_INITIALIZED = STATUS_CLASS_PREFIX + "initialized";
var CLASS_ACTIVE = STATUS_CLASS_PREFIX + "active";
var CLASS_PREV = STATUS_CLASS_PREFIX + "prev";
var CLASS_NEXT = STATUS_CLASS_PREFIX + "next";
var CLASS_VISIBLE = STATUS_CLASS_PREFIX + "visible";
var CLASS_LOADING = STATUS_CLASS_PREFIX + "loading";
var CLASS_FOCUS_IN = STATUS_CLASS_PREFIX + "focus-in";
var CLASS_OVERFLOW = STATUS_CLASS_PREFIX + "overflow";
var STATUS_CLASSES = [CLASS_ACTIVE, CLASS_VISIBLE, CLASS_PREV, CLASS_NEXT, CLASS_LOADING, CLASS_FOCUS_IN, CLASS_OVERFLOW];
var CLASSES = {
  slide: CLASS_SLIDE,
  clone: CLASS_CLONE,
  arrows: CLASS_ARROWS,
  arrow: CLASS_ARROW,
  prev: CLASS_ARROW_PREV,
  next: CLASS_ARROW_NEXT,
  pagination: CLASS_PAGINATION,
  page: CLASS_PAGINATION_PAGE,
  spinner: CLASS_SPINNER
};
function closest(from, selector) {
  if (isFunction(from.closest)) {
    return from.closest(selector);
  }
  var elm = from;
  while (elm && elm.nodeType === 1) {
    if (matches(elm, selector)) {
      break;
    }
    elm = elm.parentElement;
  }
  return elm;
}
var FRICTION = 5;
var LOG_INTERVAL = 200;
var POINTER_DOWN_EVENTS = "touchstart mousedown";
var POINTER_MOVE_EVENTS = "touchmove mousemove";
var POINTER_UP_EVENTS = "touchend touchcancel mouseup click";
function Elements(Splide22, Components2, options) {
  var _EventInterface = EventInterface(Splide22), on = _EventInterface.on, bind = _EventInterface.bind;
  var root = Splide22.root;
  var i18n = options.i18n;
  var elements = {};
  var slides = [];
  var rootClasses = [];
  var trackClasses = [];
  var track;
  var list;
  var isUsingKey;
  function setup() {
    collect();
    init();
    update();
  }
  function mount() {
    on(EVENT_REFRESH, destroy);
    on(EVENT_REFRESH, setup);
    on(EVENT_UPDATED, update);
    bind(document, POINTER_DOWN_EVENTS + " keydown", function(e) {
      isUsingKey = e.type === "keydown";
    }, {
      capture: true
    });
    bind(root, "focusin", function() {
      toggleClass(root, CLASS_FOCUS_IN, !!isUsingKey);
    });
  }
  function destroy(completely) {
    var attrs = ALL_ATTRIBUTES.concat("style");
    empty(slides);
    removeClass(root, rootClasses);
    removeClass(track, trackClasses);
    removeAttribute([track, list], attrs);
    removeAttribute(root, completely ? attrs : ["style", ARIA_ROLEDESCRIPTION]);
  }
  function update() {
    removeClass(root, rootClasses);
    removeClass(track, trackClasses);
    rootClasses = getClasses(CLASS_ROOT);
    trackClasses = getClasses(CLASS_TRACK);
    addClass(root, rootClasses);
    addClass(track, trackClasses);
    setAttribute(root, ARIA_LABEL, options.label);
    setAttribute(root, ARIA_LABELLEDBY, options.labelledby);
  }
  function collect() {
    track = find("." + CLASS_TRACK);
    list = child(track, "." + CLASS_LIST);
    assert(track && list, "A track/list element is missing.");
    push(slides, children(list, "." + CLASS_SLIDE + ":not(." + CLASS_CLONE + ")"));
    forOwn({
      arrows: CLASS_ARROWS,
      pagination: CLASS_PAGINATION,
      prev: CLASS_ARROW_PREV,
      next: CLASS_ARROW_NEXT,
      bar: CLASS_PROGRESS_BAR,
      toggle: CLASS_TOGGLE
    }, function(className, key) {
      elements[key] = find("." + className);
    });
    assign(elements, {
      root,
      track,
      list,
      slides
    });
  }
  function init() {
    var id = root.id || uniqueId(PROJECT_CODE);
    var role = options.role;
    root.id = id;
    track.id = track.id || id + "-track";
    list.id = list.id || id + "-list";
    if (!getAttribute(root, ROLE) && root.tagName !== "SECTION" && role) {
      setAttribute(root, ROLE, role);
    }
    setAttribute(root, ARIA_ROLEDESCRIPTION, i18n.carousel);
    setAttribute(list, ROLE, "presentation");
  }
  function find(selector) {
    var elm = query(root, selector);
    return elm && closest(elm, "." + CLASS_ROOT) === root ? elm : void 0;
  }
  function getClasses(base) {
    return [base + "--" + options.type, base + "--" + options.direction, options.drag && base + "--draggable", options.isNavigation && base + "--nav", base === CLASS_ROOT && CLASS_ACTIVE];
  }
  return assign(elements, {
    setup,
    mount,
    destroy
  });
}
var SLIDE = "slide";
var LOOP = "loop";
var FADE = "fade";
function Slide$1(Splide22, index, slideIndex, slide) {
  var event = EventInterface(Splide22);
  var on = event.on, emit = event.emit, bind = event.bind;
  var Components = Splide22.Components, root = Splide22.root, options = Splide22.options;
  var isNavigation = options.isNavigation, updateOnMove = options.updateOnMove, i18n = options.i18n, pagination = options.pagination, slideFocus = options.slideFocus;
  var resolve = Components.Direction.resolve;
  var styles = getAttribute(slide, "style");
  var label = getAttribute(slide, ARIA_LABEL);
  var isClone = slideIndex > -1;
  var container = child(slide, "." + CLASS_CONTAINER);
  var destroyed;
  function mount() {
    if (!isClone) {
      slide.id = root.id + "-slide" + pad(index + 1);
      setAttribute(slide, ROLE, pagination ? "tabpanel" : "group");
      setAttribute(slide, ARIA_ROLEDESCRIPTION, i18n.slide);
      setAttribute(slide, ARIA_LABEL, label || format(i18n.slideLabel, [index + 1, Splide22.length]));
    }
    listen();
  }
  function listen() {
    bind(slide, "click", apply(emit, EVENT_CLICK, self));
    bind(slide, "keydown", apply(emit, EVENT_SLIDE_KEYDOWN, self));
    on([EVENT_MOVED, EVENT_SHIFTED, EVENT_SCROLLED], update);
    on(EVENT_NAVIGATION_MOUNTED, initNavigation);
    if (updateOnMove) {
      on(EVENT_MOVE, onMove);
    }
  }
  function destroy() {
    destroyed = true;
    event.destroy();
    removeClass(slide, STATUS_CLASSES);
    removeAttribute(slide, ALL_ATTRIBUTES);
    setAttribute(slide, "style", styles);
    setAttribute(slide, ARIA_LABEL, label || "");
  }
  function initNavigation() {
    var controls = Splide22.splides.map(function(target) {
      var Slide2 = target.splide.Components.Slides.getAt(index);
      return Slide2 ? Slide2.slide.id : "";
    }).join(" ");
    setAttribute(slide, ARIA_LABEL, format(i18n.slideX, (isClone ? slideIndex : index) + 1));
    setAttribute(slide, ARIA_CONTROLS, controls);
    setAttribute(slide, ROLE, slideFocus ? "button" : "");
    slideFocus && removeAttribute(slide, ARIA_ROLEDESCRIPTION);
  }
  function onMove() {
    if (!destroyed) {
      update();
    }
  }
  function update() {
    if (!destroyed) {
      var curr = Splide22.index;
      updateActivity();
      updateVisibility();
      toggleClass(slide, CLASS_PREV, index === curr - 1);
      toggleClass(slide, CLASS_NEXT, index === curr + 1);
    }
  }
  function updateActivity() {
    var active = isActive();
    if (active !== hasClass(slide, CLASS_ACTIVE)) {
      toggleClass(slide, CLASS_ACTIVE, active);
      setAttribute(slide, ARIA_CURRENT, isNavigation && active || "");
      emit(active ? EVENT_ACTIVE : EVENT_INACTIVE, self);
    }
  }
  function updateVisibility() {
    var visible = isVisible();
    var hidden = !visible && (!isActive() || isClone);
    if (!Splide22.state.is([MOVING, SCROLLING])) {
      setAttribute(slide, ARIA_HIDDEN, hidden || "");
    }
    setAttribute(queryAll(slide, options.focusableNodes || ""), TAB_INDEX, hidden ? -1 : "");
    if (slideFocus) {
      setAttribute(slide, TAB_INDEX, hidden ? -1 : 0);
    }
    if (visible !== hasClass(slide, CLASS_VISIBLE)) {
      toggleClass(slide, CLASS_VISIBLE, visible);
      emit(visible ? EVENT_VISIBLE : EVENT_HIDDEN, self);
    }
    if (!visible && document.activeElement === slide) {
      var Slide2 = Components.Slides.getAt(Splide22.index);
      Slide2 && focus(Slide2.slide);
    }
  }
  function style$1(prop, value, useContainer) {
    style(useContainer && container || slide, prop, value);
  }
  function isActive() {
    var curr = Splide22.index;
    return curr === index || options.cloneStatus && curr === slideIndex;
  }
  function isVisible() {
    if (Splide22.is(FADE)) {
      return isActive();
    }
    var trackRect = rect(Components.Elements.track);
    var slideRect = rect(slide);
    var left = resolve("left", true);
    var right = resolve("right", true);
    return floor(trackRect[left]) <= ceil(slideRect[left]) && floor(slideRect[right]) <= ceil(trackRect[right]);
  }
  function isWithin(from, distance) {
    var diff = abs(from - index);
    if (!isClone && (options.rewind || Splide22.is(LOOP))) {
      diff = min(diff, Splide22.length - diff);
    }
    return diff <= distance;
  }
  var self = {
    index,
    slideIndex,
    slide,
    container,
    isClone,
    mount,
    destroy,
    update,
    style: style$1,
    isWithin
  };
  return self;
}
function Slides(Splide22, Components2, options) {
  var _EventInterface2 = EventInterface(Splide22), on = _EventInterface2.on, emit = _EventInterface2.emit, bind = _EventInterface2.bind;
  var _Components2$Elements = Components2.Elements, slides = _Components2$Elements.slides, list = _Components2$Elements.list;
  var Slides2 = [];
  function mount() {
    init();
    on(EVENT_REFRESH, destroy);
    on(EVENT_REFRESH, init);
  }
  function init() {
    slides.forEach(function(slide, index) {
      register(slide, index, -1);
    });
  }
  function destroy() {
    forEach$1(function(Slide2) {
      Slide2.destroy();
    });
    empty(Slides2);
  }
  function update() {
    forEach$1(function(Slide2) {
      Slide2.update();
    });
  }
  function register(slide, index, slideIndex) {
    var object = Slide$1(Splide22, index, slideIndex, slide);
    object.mount();
    Slides2.push(object);
    Slides2.sort(function(Slide1, Slide2) {
      return Slide1.index - Slide2.index;
    });
  }
  function get(excludeClones) {
    return excludeClones ? filter(function(Slide2) {
      return !Slide2.isClone;
    }) : Slides2;
  }
  function getIn(page) {
    var Controller2 = Components2.Controller;
    var index = Controller2.toIndex(page);
    var max2 = Controller2.hasFocus() ? 1 : options.perPage;
    return filter(function(Slide2) {
      return between(Slide2.index, index, index + max2 - 1);
    });
  }
  function getAt(index) {
    return filter(index)[0];
  }
  function add(items, index) {
    forEach(items, function(slide) {
      if (isString(slide)) {
        slide = parseHtml(slide);
      }
      if (isHTMLElement(slide)) {
        var ref = slides[index];
        ref ? before(slide, ref) : append(list, slide);
        addClass(slide, options.classes.slide);
        observeImages(slide, apply(emit, EVENT_RESIZE));
      }
    });
    emit(EVENT_REFRESH);
  }
  function remove$1(matcher) {
    remove(filter(matcher).map(function(Slide2) {
      return Slide2.slide;
    }));
    emit(EVENT_REFRESH);
  }
  function forEach$1(iteratee, excludeClones) {
    get(excludeClones).forEach(iteratee);
  }
  function filter(matcher) {
    return Slides2.filter(isFunction(matcher) ? matcher : function(Slide2) {
      return isString(matcher) ? matches(Slide2.slide, matcher) : includes(toArray(matcher), Slide2.index);
    });
  }
  function style2(prop, value, useContainer) {
    forEach$1(function(Slide2) {
      Slide2.style(prop, value, useContainer);
    });
  }
  function observeImages(elm, callback) {
    var images = queryAll(elm, "img");
    var length = images.length;
    if (length) {
      images.forEach(function(img) {
        bind(img, "load error", function() {
          if (!--length) {
            callback();
          }
        });
      });
    } else {
      callback();
    }
  }
  function getLength(excludeClones) {
    return excludeClones ? slides.length : Slides2.length;
  }
  function isEnough() {
    return Slides2.length > options.perPage;
  }
  return {
    mount,
    destroy,
    update,
    register,
    get,
    getIn,
    getAt,
    add,
    remove: remove$1,
    forEach: forEach$1,
    filter,
    style: style2,
    getLength,
    isEnough
  };
}
function Layout(Splide22, Components2, options) {
  var _EventInterface3 = EventInterface(Splide22), on = _EventInterface3.on, bind = _EventInterface3.bind, emit = _EventInterface3.emit;
  var Slides2 = Components2.Slides;
  var resolve = Components2.Direction.resolve;
  var _Components2$Elements2 = Components2.Elements, root = _Components2$Elements2.root, track = _Components2$Elements2.track, list = _Components2$Elements2.list;
  var getAt = Slides2.getAt, styleSlides = Slides2.style;
  var vertical;
  var rootRect;
  var overflow;
  function mount() {
    init();
    bind(window, "resize load", Throttle(apply(emit, EVENT_RESIZE)));
    on([EVENT_UPDATED, EVENT_REFRESH], init);
    on(EVENT_RESIZE, resize);
  }
  function init() {
    vertical = options.direction === TTB;
    style(root, "maxWidth", unit(options.width));
    style(track, resolve("paddingLeft"), cssPadding(false));
    style(track, resolve("paddingRight"), cssPadding(true));
    resize(true);
  }
  function resize(force) {
    var newRect = rect(root);
    if (force || rootRect.width !== newRect.width || rootRect.height !== newRect.height) {
      style(track, "height", cssTrackHeight());
      styleSlides(resolve("marginRight"), unit(options.gap));
      styleSlides("width", cssSlideWidth());
      styleSlides("height", cssSlideHeight(), true);
      rootRect = newRect;
      emit(EVENT_RESIZED);
      if (overflow !== (overflow = isOverflow())) {
        toggleClass(root, CLASS_OVERFLOW, overflow);
        emit(EVENT_OVERFLOW, overflow);
      }
    }
  }
  function cssPadding(right) {
    var padding = options.padding;
    var prop = resolve(right ? "right" : "left");
    return padding && unit(padding[prop] || (isObject(padding) ? 0 : padding)) || "0px";
  }
  function cssTrackHeight() {
    var height = "";
    if (vertical) {
      height = cssHeight();
      assert(height, "height or heightRatio is missing.");
      height = "calc(" + height + " - " + cssPadding(false) + " - " + cssPadding(true) + ")";
    }
    return height;
  }
  function cssHeight() {
    return unit(options.height || rect(list).width * options.heightRatio);
  }
  function cssSlideWidth() {
    return options.autoWidth ? null : unit(options.fixedWidth) || (vertical ? "" : cssSlideSize());
  }
  function cssSlideHeight() {
    return unit(options.fixedHeight) || (vertical ? options.autoHeight ? null : cssSlideSize() : cssHeight());
  }
  function cssSlideSize() {
    var gap = unit(options.gap);
    return "calc((100%" + (gap && " + " + gap) + ")/" + (options.perPage || 1) + (gap && " - " + gap) + ")";
  }
  function listSize() {
    return rect(list)[resolve("width")];
  }
  function slideSize(index, withoutGap) {
    var Slide2 = getAt(index || 0);
    return Slide2 ? rect(Slide2.slide)[resolve("width")] + (withoutGap ? 0 : getGap()) : 0;
  }
  function totalSize(index, withoutGap) {
    var Slide2 = getAt(index);
    if (Slide2) {
      var right = rect(Slide2.slide)[resolve("right")];
      var left = rect(list)[resolve("left")];
      return abs(right - left) + (withoutGap ? 0 : getGap());
    }
    return 0;
  }
  function sliderSize(withoutGap) {
    return totalSize(Splide22.length - 1) - totalSize(0) + slideSize(0, withoutGap);
  }
  function getGap() {
    var Slide2 = getAt(0);
    return Slide2 && parseFloat(style(Slide2.slide, resolve("marginRight"))) || 0;
  }
  function getPadding(right) {
    return parseFloat(style(track, resolve("padding" + (right ? "Right" : "Left")))) || 0;
  }
  function isOverflow() {
    return Splide22.is(FADE) || sliderSize(true) > listSize();
  }
  return {
    mount,
    resize,
    listSize,
    slideSize,
    sliderSize,
    totalSize,
    getPadding,
    isOverflow
  };
}
var MULTIPLIER = 2;
function Clones(Splide22, Components2, options) {
  var event = EventInterface(Splide22);
  var on = event.on;
  var Elements2 = Components2.Elements, Slides2 = Components2.Slides;
  var resolve = Components2.Direction.resolve;
  var clones = [];
  var cloneCount;
  function mount() {
    on(EVENT_REFRESH, remount);
    on([EVENT_UPDATED, EVENT_RESIZE], observe);
    if (cloneCount = computeCloneCount()) {
      generate(cloneCount);
      Components2.Layout.resize(true);
    }
  }
  function remount() {
    destroy();
    mount();
  }
  function destroy() {
    remove(clones);
    empty(clones);
    event.destroy();
  }
  function observe() {
    var count = computeCloneCount();
    if (cloneCount !== count) {
      if (cloneCount < count || !count) {
        event.emit(EVENT_REFRESH);
      }
    }
  }
  function generate(count) {
    var slides = Slides2.get().slice();
    var length = slides.length;
    if (length) {
      while (slides.length < count) {
        push(slides, slides);
      }
      push(slides.slice(-count), slides.slice(0, count)).forEach(function(Slide2, index) {
        var isHead = index < count;
        var clone = cloneDeep(Slide2.slide, index);
        isHead ? before(clone, slides[0].slide) : append(Elements2.list, clone);
        push(clones, clone);
        Slides2.register(clone, index - count + (isHead ? 0 : length), Slide2.index);
      });
    }
  }
  function cloneDeep(elm, index) {
    var clone = elm.cloneNode(true);
    addClass(clone, options.classes.clone);
    clone.id = Splide22.root.id + "-clone" + pad(index + 1);
    return clone;
  }
  function computeCloneCount() {
    var clones2 = options.clones;
    if (!Splide22.is(LOOP)) {
      clones2 = 0;
    } else if (isUndefined(clones2)) {
      var fixedSize = options[resolve("fixedWidth")] && Components2.Layout.slideSize(0);
      var fixedCount = fixedSize && ceil(rect(Elements2.track)[resolve("width")] / fixedSize);
      clones2 = fixedCount || options[resolve("autoWidth")] && Splide22.length || options.perPage * MULTIPLIER;
    }
    return clones2;
  }
  return {
    mount,
    destroy
  };
}
function Move(Splide22, Components2, options) {
  var _EventInterface4 = EventInterface(Splide22), on = _EventInterface4.on, emit = _EventInterface4.emit;
  var set = Splide22.state.set;
  var _Components2$Layout = Components2.Layout, slideSize = _Components2$Layout.slideSize, getPadding = _Components2$Layout.getPadding, totalSize = _Components2$Layout.totalSize, listSize = _Components2$Layout.listSize, sliderSize = _Components2$Layout.sliderSize;
  var _Components2$Directio = Components2.Direction, resolve = _Components2$Directio.resolve, orient = _Components2$Directio.orient;
  var _Components2$Elements3 = Components2.Elements, list = _Components2$Elements3.list, track = _Components2$Elements3.track;
  var Transition;
  function mount() {
    Transition = Components2.Transition;
    on([EVENT_MOUNTED, EVENT_RESIZED, EVENT_UPDATED, EVENT_REFRESH], reposition);
  }
  function reposition() {
    if (!Components2.Controller.isBusy()) {
      Components2.Scroll.cancel();
      jump(Splide22.index);
      Components2.Slides.update();
    }
  }
  function move(dest, index, prev, callback) {
    if (dest !== index && canShift(dest > prev)) {
      cancel();
      translate(shift(getPosition(), dest > prev), true);
    }
    set(MOVING);
    emit(EVENT_MOVE, index, prev, dest);
    Transition.start(index, function() {
      set(IDLE);
      emit(EVENT_MOVED, index, prev, dest);
      callback && callback();
    });
  }
  function jump(index) {
    translate(toPosition(index, true));
  }
  function translate(position, preventLoop) {
    if (!Splide22.is(FADE)) {
      var destination = preventLoop ? position : loop(position);
      style(list, "transform", "translate" + resolve("X") + "(" + destination + "px)");
      position !== destination && emit(EVENT_SHIFTED);
    }
  }
  function loop(position) {
    if (Splide22.is(LOOP)) {
      var index = toIndex(position);
      var exceededMax = index > Components2.Controller.getEnd();
      var exceededMin = index < 0;
      if (exceededMin || exceededMax) {
        position = shift(position, exceededMax);
      }
    }
    return position;
  }
  function shift(position, backwards) {
    var excess = position - getLimit(backwards);
    var size = sliderSize();
    position -= orient(size * (ceil(abs(excess) / size) || 1)) * (backwards ? 1 : -1);
    return position;
  }
  function cancel() {
    translate(getPosition(), true);
    Transition.cancel();
  }
  function toIndex(position) {
    var Slides2 = Components2.Slides.get();
    var index = 0;
    var minDistance = Infinity;
    for (var i = 0; i < Slides2.length; i++) {
      var slideIndex = Slides2[i].index;
      var distance = abs(toPosition(slideIndex, true) - position);
      if (distance <= minDistance) {
        minDistance = distance;
        index = slideIndex;
      } else {
        break;
      }
    }
    return index;
  }
  function toPosition(index, trimming) {
    var position = orient(totalSize(index - 1) - offset(index));
    return trimming ? trim(position) : position;
  }
  function getPosition() {
    var left = resolve("left");
    return rect(list)[left] - rect(track)[left] + orient(getPadding(false));
  }
  function trim(position) {
    if (options.trimSpace && Splide22.is(SLIDE)) {
      position = clamp(position, 0, orient(sliderSize(true) - listSize()));
    }
    return position;
  }
  function offset(index) {
    var focus2 = options.focus;
    return focus2 === "center" ? (listSize() - slideSize(index, true)) / 2 : +focus2 * slideSize(index) || 0;
  }
  function getLimit(max2) {
    return toPosition(max2 ? Components2.Controller.getEnd() : 0, !!options.trimSpace);
  }
  function canShift(backwards) {
    var shifted = orient(shift(getPosition(), backwards));
    return backwards ? shifted >= 0 : shifted <= list[resolve("scrollWidth")] - rect(track)[resolve("width")];
  }
  function exceededLimit(max2, position) {
    position = isUndefined(position) ? getPosition() : position;
    var exceededMin = max2 !== true && orient(position) < orient(getLimit(false));
    var exceededMax = max2 !== false && orient(position) > orient(getLimit(true));
    return exceededMin || exceededMax;
  }
  return {
    mount,
    move,
    jump,
    translate,
    shift,
    cancel,
    toIndex,
    toPosition,
    getPosition,
    getLimit,
    exceededLimit,
    reposition
  };
}
function Controller(Splide22, Components2, options) {
  var _EventInterface5 = EventInterface(Splide22), on = _EventInterface5.on, emit = _EventInterface5.emit;
  var Move2 = Components2.Move;
  var getPosition = Move2.getPosition, getLimit = Move2.getLimit, toPosition = Move2.toPosition;
  var _Components2$Slides = Components2.Slides, isEnough = _Components2$Slides.isEnough, getLength = _Components2$Slides.getLength;
  var omitEnd = options.omitEnd;
  var isLoop = Splide22.is(LOOP);
  var isSlide = Splide22.is(SLIDE);
  var getNext = apply(getAdjacent, false);
  var getPrev = apply(getAdjacent, true);
  var currIndex = options.start || 0;
  var endIndex;
  var prevIndex = currIndex;
  var slideCount;
  var perMove;
  var perPage;
  function mount() {
    init();
    on([EVENT_UPDATED, EVENT_REFRESH, EVENT_END_INDEX_CHANGED], init);
    on(EVENT_RESIZED, onResized);
  }
  function init() {
    slideCount = getLength(true);
    perMove = options.perMove;
    perPage = options.perPage;
    endIndex = getEnd();
    var index = clamp(currIndex, 0, omitEnd ? endIndex : slideCount - 1);
    if (index !== currIndex) {
      currIndex = index;
      Move2.reposition();
    }
  }
  function onResized() {
    if (endIndex !== getEnd()) {
      emit(EVENT_END_INDEX_CHANGED);
    }
  }
  function go(control, allowSameIndex, callback) {
    if (!isBusy()) {
      var dest = parse(control);
      var index = loop(dest);
      if (index > -1 && (allowSameIndex || index !== currIndex)) {
        setIndex(index);
        Move2.move(dest, index, prevIndex, callback);
      }
    }
  }
  function scroll(destination, duration, snap, callback) {
    Components2.Scroll.scroll(destination, duration, snap, function() {
      var index = loop(Move2.toIndex(getPosition()));
      setIndex(omitEnd ? min(index, endIndex) : index);
      callback && callback();
    });
  }
  function parse(control) {
    var index = currIndex;
    if (isString(control)) {
      var _ref = control.match(/([+\-<>])(\d+)?/) || [], indicator = _ref[1], number = _ref[2];
      if (indicator === "+" || indicator === "-") {
        index = computeDestIndex(currIndex + +("" + indicator + (+number || 1)), currIndex);
      } else if (indicator === ">") {
        index = number ? toIndex(+number) : getNext(true);
      } else if (indicator === "<") {
        index = getPrev(true);
      }
    } else {
      index = isLoop ? control : clamp(control, 0, endIndex);
    }
    return index;
  }
  function getAdjacent(prev, destination) {
    var number = perMove || (hasFocus() ? 1 : perPage);
    var dest = computeDestIndex(currIndex + number * (prev ? -1 : 1), currIndex, !(perMove || hasFocus()));
    if (dest === -1 && isSlide) {
      if (!approximatelyEqual(getPosition(), getLimit(!prev), 1)) {
        return prev ? 0 : endIndex;
      }
    }
    return destination ? dest : loop(dest);
  }
  function computeDestIndex(dest, from, snapPage) {
    if (isEnough() || hasFocus()) {
      var index = computeMovableDestIndex(dest);
      if (index !== dest) {
        from = dest;
        dest = index;
        snapPage = false;
      }
      if (dest < 0 || dest > endIndex) {
        if (!perMove && (between(0, dest, from, true) || between(endIndex, from, dest, true))) {
          dest = toIndex(toPage(dest));
        } else {
          if (isLoop) {
            dest = snapPage ? dest < 0 ? -(slideCount % perPage || perPage) : slideCount : dest;
          } else if (options.rewind) {
            dest = dest < 0 ? endIndex : 0;
          } else {
            dest = -1;
          }
        }
      } else {
        if (snapPage && dest !== from) {
          dest = toIndex(toPage(from) + (dest < from ? -1 : 1));
        }
      }
    } else {
      dest = -1;
    }
    return dest;
  }
  function computeMovableDestIndex(dest) {
    if (isSlide && options.trimSpace === "move" && dest !== currIndex) {
      var position = getPosition();
      while (position === toPosition(dest, true) && between(dest, 0, Splide22.length - 1, !options.rewind)) {
        dest < currIndex ? --dest : ++dest;
      }
    }
    return dest;
  }
  function loop(index) {
    return isLoop ? (index + slideCount) % slideCount || 0 : index;
  }
  function getEnd() {
    var end = slideCount - (hasFocus() || isLoop && perMove ? 1 : perPage);
    while (omitEnd && end-- > 0) {
      if (toPosition(slideCount - 1, true) !== toPosition(end, true)) {
        end++;
        break;
      }
    }
    return clamp(end, 0, slideCount - 1);
  }
  function toIndex(page) {
    return clamp(hasFocus() ? page : perPage * page, 0, endIndex);
  }
  function toPage(index) {
    return hasFocus() ? min(index, endIndex) : floor((index >= endIndex ? slideCount - 1 : index) / perPage);
  }
  function toDest(destination) {
    var closest2 = Move2.toIndex(destination);
    return isSlide ? clamp(closest2, 0, endIndex) : closest2;
  }
  function setIndex(index) {
    if (index !== currIndex) {
      prevIndex = currIndex;
      currIndex = index;
    }
  }
  function getIndex(prev) {
    return prev ? prevIndex : currIndex;
  }
  function hasFocus() {
    return !isUndefined(options.focus) || options.isNavigation;
  }
  function isBusy() {
    return Splide22.state.is([MOVING, SCROLLING]) && !!options.waitForTransition;
  }
  return {
    mount,
    go,
    scroll,
    getNext,
    getPrev,
    getAdjacent,
    getEnd,
    setIndex,
    getIndex,
    toIndex,
    toPage,
    toDest,
    hasFocus,
    isBusy
  };
}
var XML_NAME_SPACE = "http://www.w3.org/2000/svg";
var PATH = "m15.5 0.932-4.3 4.38 14.5 14.6-14.5 14.5 4.3 4.4 14.6-14.6 4.4-4.3-4.4-4.4-14.6-14.6z";
var SIZE = 40;
function Arrows(Splide22, Components2, options) {
  var event = EventInterface(Splide22);
  var on = event.on, bind = event.bind, emit = event.emit;
  var classes = options.classes, i18n = options.i18n;
  var Elements2 = Components2.Elements, Controller2 = Components2.Controller;
  var placeholder = Elements2.arrows, track = Elements2.track;
  var wrapper = placeholder;
  var prev = Elements2.prev;
  var next = Elements2.next;
  var created;
  var wrapperClasses;
  var arrows = {};
  function mount() {
    init();
    on(EVENT_UPDATED, remount);
  }
  function remount() {
    destroy();
    mount();
  }
  function init() {
    var enabled = options.arrows;
    if (enabled && !(prev && next)) {
      createArrows();
    }
    if (prev && next) {
      assign(arrows, {
        prev,
        next
      });
      display(wrapper, enabled ? "" : "none");
      addClass(wrapper, wrapperClasses = CLASS_ARROWS + "--" + options.direction);
      if (enabled) {
        listen();
        update();
        setAttribute([prev, next], ARIA_CONTROLS, track.id);
        emit(EVENT_ARROWS_MOUNTED, prev, next);
      }
    }
  }
  function destroy() {
    event.destroy();
    removeClass(wrapper, wrapperClasses);
    if (created) {
      remove(placeholder ? [prev, next] : wrapper);
      prev = next = null;
    } else {
      removeAttribute([prev, next], ALL_ATTRIBUTES);
    }
  }
  function listen() {
    on([EVENT_MOUNTED, EVENT_MOVED, EVENT_REFRESH, EVENT_SCROLLED, EVENT_END_INDEX_CHANGED], update);
    bind(next, "click", apply(go, ">"));
    bind(prev, "click", apply(go, "<"));
  }
  function go(control) {
    Controller2.go(control, true);
  }
  function createArrows() {
    wrapper = placeholder || create("div", classes.arrows);
    prev = createArrow(true);
    next = createArrow(false);
    created = true;
    append(wrapper, [prev, next]);
    !placeholder && before(wrapper, track);
  }
  function createArrow(prev2) {
    var arrow = '<button class="' + classes.arrow + " " + (prev2 ? classes.prev : classes.next) + '" type="button"><svg xmlns="' + XML_NAME_SPACE + '" viewBox="0 0 ' + SIZE + " " + SIZE + '" width="' + SIZE + '" height="' + SIZE + '" focusable="false"><path d="' + (options.arrowPath || PATH) + '" />';
    return parseHtml(arrow);
  }
  function update() {
    if (prev && next) {
      var index = Splide22.index;
      var prevIndex = Controller2.getPrev();
      var nextIndex = Controller2.getNext();
      var prevLabel = prevIndex > -1 && index < prevIndex ? i18n.last : i18n.prev;
      var nextLabel = nextIndex > -1 && index > nextIndex ? i18n.first : i18n.next;
      prev.disabled = prevIndex < 0;
      next.disabled = nextIndex < 0;
      setAttribute(prev, ARIA_LABEL, prevLabel);
      setAttribute(next, ARIA_LABEL, nextLabel);
      emit(EVENT_ARROWS_UPDATED, prev, next, prevIndex, nextIndex);
    }
  }
  return {
    arrows,
    mount,
    destroy,
    update
  };
}
var INTERVAL_DATA_ATTRIBUTE = DATA_ATTRIBUTE + "-interval";
function Autoplay(Splide22, Components2, options) {
  var _EventInterface6 = EventInterface(Splide22), on = _EventInterface6.on, bind = _EventInterface6.bind, emit = _EventInterface6.emit;
  var interval = RequestInterval(options.interval, Splide22.go.bind(Splide22, ">"), onAnimationFrame);
  var isPaused = interval.isPaused;
  var Elements2 = Components2.Elements, _Components2$Elements4 = Components2.Elements, root = _Components2$Elements4.root, toggle = _Components2$Elements4.toggle;
  var autoplay = options.autoplay;
  var hovered;
  var focused;
  var stopped = autoplay === "pause";
  function mount() {
    if (autoplay) {
      listen();
      toggle && setAttribute(toggle, ARIA_CONTROLS, Elements2.track.id);
      stopped || play();
      update();
    }
  }
  function listen() {
    if (options.pauseOnHover) {
      bind(root, "mouseenter mouseleave", function(e) {
        hovered = e.type === "mouseenter";
        autoToggle();
      });
    }
    if (options.pauseOnFocus) {
      bind(root, "focusin focusout", function(e) {
        focused = e.type === "focusin";
        autoToggle();
      });
    }
    if (toggle) {
      bind(toggle, "click", function() {
        stopped ? play() : pause(true);
      });
    }
    on([EVENT_MOVE, EVENT_SCROLL, EVENT_REFRESH], interval.rewind);
    on(EVENT_MOVE, onMove);
  }
  function play() {
    if (isPaused() && Components2.Slides.isEnough()) {
      interval.start(!options.resetProgress);
      focused = hovered = stopped = false;
      update();
      emit(EVENT_AUTOPLAY_PLAY);
    }
  }
  function pause(stop) {
    if (stop === void 0) {
      stop = true;
    }
    stopped = !!stop;
    update();
    if (!isPaused()) {
      interval.pause();
      emit(EVENT_AUTOPLAY_PAUSE);
    }
  }
  function autoToggle() {
    if (!stopped) {
      hovered || focused ? pause(false) : play();
    }
  }
  function update() {
    if (toggle) {
      toggleClass(toggle, CLASS_ACTIVE, !stopped);
      setAttribute(toggle, ARIA_LABEL, options.i18n[stopped ? "play" : "pause"]);
    }
  }
  function onAnimationFrame(rate) {
    var bar = Elements2.bar;
    bar && style(bar, "width", rate * 100 + "%");
    emit(EVENT_AUTOPLAY_PLAYING, rate);
  }
  function onMove(index) {
    var Slide2 = Components2.Slides.getAt(index);
    interval.set(Slide2 && +getAttribute(Slide2.slide, INTERVAL_DATA_ATTRIBUTE) || options.interval);
  }
  return {
    mount,
    destroy: interval.cancel,
    play,
    pause,
    isPaused
  };
}
function Cover(Splide22, Components2, options) {
  var _EventInterface7 = EventInterface(Splide22), on = _EventInterface7.on;
  function mount() {
    if (options.cover) {
      on(EVENT_LAZYLOAD_LOADED, apply(toggle, true));
      on([EVENT_MOUNTED, EVENT_UPDATED, EVENT_REFRESH], apply(cover, true));
    }
  }
  function cover(cover2) {
    Components2.Slides.forEach(function(Slide2) {
      var img = child(Slide2.container || Slide2.slide, "img");
      if (img && img.src) {
        toggle(cover2, img, Slide2);
      }
    });
  }
  function toggle(cover2, img, Slide2) {
    Slide2.style("background", cover2 ? 'center/cover no-repeat url("' + img.src + '")' : "", true);
    display(img, cover2 ? "none" : "");
  }
  return {
    mount,
    destroy: apply(cover, false)
  };
}
var BOUNCE_DIFF_THRESHOLD = 10;
var BOUNCE_DURATION = 600;
var FRICTION_FACTOR = 0.6;
var BASE_VELOCITY = 1.5;
var MIN_DURATION = 800;
function Scroll(Splide22, Components2, options) {
  var _EventInterface8 = EventInterface(Splide22), on = _EventInterface8.on, emit = _EventInterface8.emit;
  var set = Splide22.state.set;
  var Move2 = Components2.Move;
  var getPosition = Move2.getPosition, getLimit = Move2.getLimit, exceededLimit = Move2.exceededLimit, translate = Move2.translate;
  var isSlide = Splide22.is(SLIDE);
  var interval;
  var callback;
  var friction = 1;
  function mount() {
    on(EVENT_MOVE, clear);
    on([EVENT_UPDATED, EVENT_REFRESH], cancel);
  }
  function scroll(destination, duration, snap, onScrolled, noConstrain) {
    var from = getPosition();
    clear();
    if (snap && (!isSlide || !exceededLimit())) {
      var size = Components2.Layout.sliderSize();
      var offset = sign(destination) * size * floor(abs(destination) / size) || 0;
      destination = Move2.toPosition(Components2.Controller.toDest(destination % size)) + offset;
    }
    var noDistance = approximatelyEqual(from, destination, 1);
    friction = 1;
    duration = noDistance ? 0 : duration || max(abs(destination - from) / BASE_VELOCITY, MIN_DURATION);
    callback = onScrolled;
    interval = RequestInterval(duration, onEnd, apply(update, from, destination, noConstrain), 1);
    set(SCROLLING);
    emit(EVENT_SCROLL);
    interval.start();
  }
  function onEnd() {
    set(IDLE);
    callback && callback();
    emit(EVENT_SCROLLED);
  }
  function update(from, to, noConstrain, rate) {
    var position = getPosition();
    var target = from + (to - from) * easing(rate);
    var diff = (target - position) * friction;
    translate(position + diff);
    if (isSlide && !noConstrain && exceededLimit()) {
      friction *= FRICTION_FACTOR;
      if (abs(diff) < BOUNCE_DIFF_THRESHOLD) {
        scroll(getLimit(exceededLimit(true)), BOUNCE_DURATION, false, callback, true);
      }
    }
  }
  function clear() {
    if (interval) {
      interval.cancel();
    }
  }
  function cancel() {
    if (interval && !interval.isPaused()) {
      clear();
      onEnd();
    }
  }
  function easing(t) {
    var easingFunc = options.easingFunc;
    return easingFunc ? easingFunc(t) : 1 - Math.pow(1 - t, 4);
  }
  return {
    mount,
    destroy: clear,
    scroll,
    cancel
  };
}
var SCROLL_LISTENER_OPTIONS = {
  passive: false,
  capture: true
};
function Drag(Splide22, Components2, options) {
  var _EventInterface9 = EventInterface(Splide22), on = _EventInterface9.on, emit = _EventInterface9.emit, bind = _EventInterface9.bind, unbind = _EventInterface9.unbind;
  var state = Splide22.state;
  var Move2 = Components2.Move, Scroll2 = Components2.Scroll, Controller2 = Components2.Controller, track = Components2.Elements.track, reduce = Components2.Media.reduce;
  var _Components2$Directio2 = Components2.Direction, resolve = _Components2$Directio2.resolve, orient = _Components2$Directio2.orient;
  var getPosition = Move2.getPosition, exceededLimit = Move2.exceededLimit;
  var basePosition;
  var baseEvent;
  var prevBaseEvent;
  var isFree;
  var dragging;
  var exceeded = false;
  var clickPrevented;
  var disabled;
  var target;
  function mount() {
    bind(track, POINTER_MOVE_EVENTS, noop, SCROLL_LISTENER_OPTIONS);
    bind(track, POINTER_UP_EVENTS, noop, SCROLL_LISTENER_OPTIONS);
    bind(track, POINTER_DOWN_EVENTS, onPointerDown, SCROLL_LISTENER_OPTIONS);
    bind(track, "click", onClick, {
      capture: true
    });
    bind(track, "dragstart", prevent);
    on([EVENT_MOUNTED, EVENT_UPDATED], init);
  }
  function init() {
    var drag = options.drag;
    disable(!drag);
    isFree = drag === "free";
  }
  function onPointerDown(e) {
    clickPrevented = false;
    if (!disabled) {
      var isTouch = isTouchEvent(e);
      if (isDraggable(e.target) && (isTouch || !e.button)) {
        if (!Controller2.isBusy()) {
          target = isTouch ? track : window;
          dragging = state.is([MOVING, SCROLLING]);
          prevBaseEvent = null;
          bind(target, POINTER_MOVE_EVENTS, onPointerMove, SCROLL_LISTENER_OPTIONS);
          bind(target, POINTER_UP_EVENTS, onPointerUp, SCROLL_LISTENER_OPTIONS);
          Move2.cancel();
          Scroll2.cancel();
          save(e);
        } else {
          prevent(e, true);
        }
      }
    }
  }
  function onPointerMove(e) {
    if (!state.is(DRAGGING)) {
      state.set(DRAGGING);
      emit(EVENT_DRAG);
    }
    if (e.cancelable) {
      if (dragging) {
        Move2.translate(basePosition + constrain(diffCoord(e)));
        var expired = diffTime(e) > LOG_INTERVAL;
        var hasExceeded = exceeded !== (exceeded = exceededLimit());
        if (expired || hasExceeded) {
          save(e);
        }
        clickPrevented = true;
        emit(EVENT_DRAGGING);
        prevent(e);
      } else if (isSliderDirection(e)) {
        dragging = shouldStart(e);
        prevent(e);
      }
    }
  }
  function onPointerUp(e) {
    if (state.is(DRAGGING)) {
      state.set(IDLE);
      emit(EVENT_DRAGGED);
    }
    if (dragging) {
      move(e);
      prevent(e);
    }
    unbind(target, POINTER_MOVE_EVENTS, onPointerMove);
    unbind(target, POINTER_UP_EVENTS, onPointerUp);
    dragging = false;
  }
  function onClick(e) {
    if (!disabled && clickPrevented) {
      prevent(e, true);
    }
  }
  function save(e) {
    prevBaseEvent = baseEvent;
    baseEvent = e;
    basePosition = getPosition();
  }
  function move(e) {
    var velocity = computeVelocity(e);
    var destination = computeDestination(velocity);
    var rewind = options.rewind && options.rewindByDrag;
    reduce(false);
    if (isFree) {
      Controller2.scroll(destination, 0, options.snap);
    } else if (Splide22.is(FADE)) {
      Controller2.go(orient(sign(velocity)) < 0 ? rewind ? "<" : "-" : rewind ? ">" : "+");
    } else if (Splide22.is(SLIDE) && exceeded && rewind) {
      Controller2.go(exceededLimit(true) ? ">" : "<");
    } else {
      Controller2.go(Controller2.toDest(destination), true);
    }
    reduce(true);
  }
  function shouldStart(e) {
    var thresholds = options.dragMinThreshold;
    var isObj = isObject(thresholds);
    var mouse = isObj && thresholds.mouse || 0;
    var touch = (isObj ? thresholds.touch : +thresholds) || 10;
    return abs(diffCoord(e)) > (isTouchEvent(e) ? touch : mouse);
  }
  function isSliderDirection(e) {
    return abs(diffCoord(e)) > abs(diffCoord(e, true));
  }
  function computeVelocity(e) {
    if (Splide22.is(LOOP) || !exceeded) {
      var time = diffTime(e);
      if (time && time < LOG_INTERVAL) {
        return diffCoord(e) / time;
      }
    }
    return 0;
  }
  function computeDestination(velocity) {
    return getPosition() + sign(velocity) * min(abs(velocity) * (options.flickPower || 600), isFree ? Infinity : Components2.Layout.listSize() * (options.flickMaxPages || 1));
  }
  function diffCoord(e, orthogonal) {
    return coordOf(e, orthogonal) - coordOf(getBaseEvent(e), orthogonal);
  }
  function diffTime(e) {
    return timeOf(e) - timeOf(getBaseEvent(e));
  }
  function getBaseEvent(e) {
    return baseEvent === e && prevBaseEvent || baseEvent;
  }
  function coordOf(e, orthogonal) {
    return (isTouchEvent(e) ? e.changedTouches[0] : e)["page" + resolve(orthogonal ? "Y" : "X")];
  }
  function constrain(diff) {
    return diff / (exceeded && Splide22.is(SLIDE) ? FRICTION : 1);
  }
  function isDraggable(target2) {
    var noDrag = options.noDrag;
    return !matches(target2, "." + CLASS_PAGINATION_PAGE + ", ." + CLASS_ARROW) && (!noDrag || !matches(target2, noDrag));
  }
  function isTouchEvent(e) {
    return typeof TouchEvent !== "undefined" && e instanceof TouchEvent;
  }
  function isDragging() {
    return dragging;
  }
  function disable(value) {
    disabled = value;
  }
  return {
    mount,
    disable,
    isDragging
  };
}
var NORMALIZATION_MAP = {
  Spacebar: " ",
  Right: ARROW_RIGHT,
  Left: ARROW_LEFT,
  Up: ARROW_UP,
  Down: ARROW_DOWN
};
function normalizeKey(key) {
  key = isString(key) ? key : key.key;
  return NORMALIZATION_MAP[key] || key;
}
var KEYBOARD_EVENT = "keydown";
function Keyboard(Splide22, Components2, options) {
  var _EventInterface10 = EventInterface(Splide22), on = _EventInterface10.on, bind = _EventInterface10.bind, unbind = _EventInterface10.unbind;
  var root = Splide22.root;
  var resolve = Components2.Direction.resolve;
  var target;
  var disabled;
  function mount() {
    init();
    on(EVENT_UPDATED, destroy);
    on(EVENT_UPDATED, init);
    on(EVENT_MOVE, onMove);
  }
  function init() {
    var keyboard = options.keyboard;
    if (keyboard) {
      target = keyboard === "global" ? window : root;
      bind(target, KEYBOARD_EVENT, onKeydown);
    }
  }
  function destroy() {
    unbind(target, KEYBOARD_EVENT);
  }
  function disable(value) {
    disabled = value;
  }
  function onMove() {
    var _disabled = disabled;
    disabled = true;
    nextTick(function() {
      disabled = _disabled;
    });
  }
  function onKeydown(e) {
    if (!disabled) {
      var key = normalizeKey(e);
      if (key === resolve(ARROW_LEFT)) {
        Splide22.go("<");
      } else if (key === resolve(ARROW_RIGHT)) {
        Splide22.go(">");
      }
    }
  }
  return {
    mount,
    destroy,
    disable
  };
}
var SRC_DATA_ATTRIBUTE = DATA_ATTRIBUTE + "-lazy";
var SRCSET_DATA_ATTRIBUTE = SRC_DATA_ATTRIBUTE + "-srcset";
var IMAGE_SELECTOR = "[" + SRC_DATA_ATTRIBUTE + "], [" + SRCSET_DATA_ATTRIBUTE + "]";
function LazyLoad(Splide22, Components2, options) {
  var _EventInterface11 = EventInterface(Splide22), on = _EventInterface11.on, off = _EventInterface11.off, bind = _EventInterface11.bind, emit = _EventInterface11.emit;
  var isSequential = options.lazyLoad === "sequential";
  var events = [EVENT_MOVED, EVENT_SCROLLED];
  var entries = [];
  function mount() {
    if (options.lazyLoad) {
      init();
      on(EVENT_REFRESH, init);
    }
  }
  function init() {
    empty(entries);
    register();
    if (isSequential) {
      loadNext();
    } else {
      off(events);
      on(events, check);
      check();
    }
  }
  function register() {
    Components2.Slides.forEach(function(Slide2) {
      queryAll(Slide2.slide, IMAGE_SELECTOR).forEach(function(img) {
        var src = getAttribute(img, SRC_DATA_ATTRIBUTE);
        var srcset = getAttribute(img, SRCSET_DATA_ATTRIBUTE);
        if (src !== img.src || srcset !== img.srcset) {
          var className = options.classes.spinner;
          var parent = img.parentElement;
          var spinner = child(parent, "." + className) || create("span", className, parent);
          entries.push([img, Slide2, spinner]);
          img.src || display(img, "none");
        }
      });
    });
  }
  function check() {
    entries = entries.filter(function(data) {
      var distance = options.perPage * ((options.preloadPages || 1) + 1) - 1;
      return data[1].isWithin(Splide22.index, distance) ? load(data) : true;
    });
    entries.length || off(events);
  }
  function load(data) {
    var img = data[0];
    addClass(data[1].slide, CLASS_LOADING);
    bind(img, "load error", apply(onLoad, data));
    setAttribute(img, "src", getAttribute(img, SRC_DATA_ATTRIBUTE));
    setAttribute(img, "srcset", getAttribute(img, SRCSET_DATA_ATTRIBUTE));
    removeAttribute(img, SRC_DATA_ATTRIBUTE);
    removeAttribute(img, SRCSET_DATA_ATTRIBUTE);
  }
  function onLoad(data, e) {
    var img = data[0], Slide2 = data[1];
    removeClass(Slide2.slide, CLASS_LOADING);
    if (e.type !== "error") {
      remove(data[2]);
      display(img, "");
      emit(EVENT_LAZYLOAD_LOADED, img, Slide2);
      emit(EVENT_RESIZE);
    }
    isSequential && loadNext();
  }
  function loadNext() {
    entries.length && load(entries.shift());
  }
  return {
    mount,
    destroy: apply(empty, entries),
    check
  };
}
function Pagination(Splide22, Components2, options) {
  var event = EventInterface(Splide22);
  var on = event.on, emit = event.emit, bind = event.bind;
  var Slides2 = Components2.Slides, Elements2 = Components2.Elements, Controller2 = Components2.Controller;
  var hasFocus = Controller2.hasFocus, getIndex = Controller2.getIndex, go = Controller2.go;
  var resolve = Components2.Direction.resolve;
  var placeholder = Elements2.pagination;
  var items = [];
  var list;
  var paginationClasses;
  function mount() {
    destroy();
    on([EVENT_UPDATED, EVENT_REFRESH, EVENT_END_INDEX_CHANGED], mount);
    var enabled = options.pagination;
    placeholder && display(placeholder, enabled ? "" : "none");
    if (enabled) {
      on([EVENT_MOVE, EVENT_SCROLL, EVENT_SCROLLED], update);
      createPagination();
      update();
      emit(EVENT_PAGINATION_MOUNTED, {
        list,
        items
      }, getAt(Splide22.index));
    }
  }
  function destroy() {
    if (list) {
      remove(placeholder ? slice(list.children) : list);
      removeClass(list, paginationClasses);
      empty(items);
      list = null;
    }
    event.destroy();
  }
  function createPagination() {
    var length = Splide22.length;
    var classes = options.classes, i18n = options.i18n, perPage = options.perPage;
    var max2 = hasFocus() ? Controller2.getEnd() + 1 : ceil(length / perPage);
    list = placeholder || create("ul", classes.pagination, Elements2.track.parentElement);
    addClass(list, paginationClasses = CLASS_PAGINATION + "--" + getDirection());
    setAttribute(list, ROLE, "tablist");
    setAttribute(list, ARIA_LABEL, i18n.select);
    setAttribute(list, ARIA_ORIENTATION, getDirection() === TTB ? "vertical" : "");
    for (var i = 0; i < max2; i++) {
      var li = create("li", null, list);
      var button = create("button", {
        class: classes.page,
        type: "button"
      }, li);
      var controls = Slides2.getIn(i).map(function(Slide2) {
        return Slide2.slide.id;
      });
      var text = !hasFocus() && perPage > 1 ? i18n.pageX : i18n.slideX;
      bind(button, "click", apply(onClick, i));
      if (options.paginationKeyboard) {
        bind(button, "keydown", apply(onKeydown, i));
      }
      setAttribute(li, ROLE, "presentation");
      setAttribute(button, ROLE, "tab");
      setAttribute(button, ARIA_CONTROLS, controls.join(" "));
      setAttribute(button, ARIA_LABEL, format(text, i + 1));
      setAttribute(button, TAB_INDEX, -1);
      items.push({
        li,
        button,
        page: i
      });
    }
  }
  function onClick(page) {
    go(">" + page, true);
  }
  function onKeydown(page, e) {
    var length = items.length;
    var key = normalizeKey(e);
    var dir = getDirection();
    var nextPage = -1;
    if (key === resolve(ARROW_RIGHT, false, dir)) {
      nextPage = ++page % length;
    } else if (key === resolve(ARROW_LEFT, false, dir)) {
      nextPage = (--page + length) % length;
    } else if (key === "Home") {
      nextPage = 0;
    } else if (key === "End") {
      nextPage = length - 1;
    }
    var item = items[nextPage];
    if (item) {
      focus(item.button);
      go(">" + nextPage);
      prevent(e, true);
    }
  }
  function getDirection() {
    return options.paginationDirection || options.direction;
  }
  function getAt(index) {
    return items[Controller2.toPage(index)];
  }
  function update() {
    var prev = getAt(getIndex(true));
    var curr = getAt(getIndex());
    if (prev) {
      var button = prev.button;
      removeClass(button, CLASS_ACTIVE);
      removeAttribute(button, ARIA_SELECTED);
      setAttribute(button, TAB_INDEX, -1);
    }
    if (curr) {
      var _button = curr.button;
      addClass(_button, CLASS_ACTIVE);
      setAttribute(_button, ARIA_SELECTED, true);
      setAttribute(_button, TAB_INDEX, "");
    }
    emit(EVENT_PAGINATION_UPDATED, {
      list,
      items
    }, prev, curr);
  }
  return {
    items,
    mount,
    destroy,
    getAt,
    update
  };
}
var TRIGGER_KEYS = [" ", "Enter"];
function Sync(Splide22, Components2, options) {
  var isNavigation = options.isNavigation, slideFocus = options.slideFocus;
  var events = [];
  function mount() {
    Splide22.splides.forEach(function(target) {
      if (!target.isParent) {
        sync(Splide22, target.splide);
        sync(target.splide, Splide22);
      }
    });
    if (isNavigation) {
      navigate();
    }
  }
  function destroy() {
    events.forEach(function(event) {
      event.destroy();
    });
    empty(events);
  }
  function remount() {
    destroy();
    mount();
  }
  function sync(splide, target) {
    var event = EventInterface(splide);
    event.on(EVENT_MOVE, function(index, prev, dest) {
      target.go(target.is(LOOP) ? dest : index);
    });
    events.push(event);
  }
  function navigate() {
    var event = EventInterface(Splide22);
    var on = event.on;
    on(EVENT_CLICK, onClick);
    on(EVENT_SLIDE_KEYDOWN, onKeydown);
    on([EVENT_MOUNTED, EVENT_UPDATED], update);
    events.push(event);
    event.emit(EVENT_NAVIGATION_MOUNTED, Splide22.splides);
  }
  function update() {
    setAttribute(Components2.Elements.list, ARIA_ORIENTATION, options.direction === TTB ? "vertical" : "");
  }
  function onClick(Slide2) {
    Splide22.go(Slide2.index);
  }
  function onKeydown(Slide2, e) {
    if (includes(TRIGGER_KEYS, normalizeKey(e))) {
      onClick(Slide2);
      prevent(e);
    }
  }
  return {
    setup: apply(Components2.Media.set, {
      slideFocus: isUndefined(slideFocus) ? isNavigation : slideFocus
    }, true),
    mount,
    destroy,
    remount
  };
}
function Wheel(Splide22, Components2, options) {
  var _EventInterface12 = EventInterface(Splide22), bind = _EventInterface12.bind;
  var lastTime = 0;
  function mount() {
    if (options.wheel) {
      bind(Components2.Elements.track, "wheel", onWheel, SCROLL_LISTENER_OPTIONS);
    }
  }
  function onWheel(e) {
    if (e.cancelable) {
      var deltaY = e.deltaY;
      var backwards = deltaY < 0;
      var timeStamp = timeOf(e);
      var _min = options.wheelMinThreshold || 0;
      var sleep = options.wheelSleep || 0;
      if (abs(deltaY) > _min && timeStamp - lastTime > sleep) {
        Splide22.go(backwards ? "<" : ">");
        lastTime = timeStamp;
      }
      shouldPrevent(backwards) && prevent(e);
    }
  }
  function shouldPrevent(backwards) {
    return !options.releaseWheel || Splide22.state.is(MOVING) || Components2.Controller.getAdjacent(backwards) !== -1;
  }
  return {
    mount
  };
}
var SR_REMOVAL_DELAY = 90;
function Live(Splide22, Components2, options) {
  var _EventInterface13 = EventInterface(Splide22), on = _EventInterface13.on;
  var track = Components2.Elements.track;
  var enabled = options.live && !options.isNavigation;
  var sr = create("span", CLASS_SR);
  var interval = RequestInterval(SR_REMOVAL_DELAY, apply(toggle, false));
  function mount() {
    if (enabled) {
      disable(!Components2.Autoplay.isPaused());
      setAttribute(track, ARIA_ATOMIC, true);
      sr.textContent = "\u2026";
      on(EVENT_AUTOPLAY_PLAY, apply(disable, true));
      on(EVENT_AUTOPLAY_PAUSE, apply(disable, false));
      on([EVENT_MOVED, EVENT_SCROLLED], apply(toggle, true));
    }
  }
  function toggle(active) {
    setAttribute(track, ARIA_BUSY, active);
    if (active) {
      append(track, sr);
      interval.start();
    } else {
      remove(sr);
      interval.cancel();
    }
  }
  function destroy() {
    removeAttribute(track, [ARIA_LIVE, ARIA_ATOMIC, ARIA_BUSY]);
    remove(sr);
  }
  function disable(disabled) {
    if (enabled) {
      setAttribute(track, ARIA_LIVE, disabled ? "off" : "polite");
    }
  }
  return {
    mount,
    disable,
    destroy
  };
}
var ComponentConstructors = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  Media,
  Direction,
  Elements,
  Slides,
  Layout,
  Clones,
  Move,
  Controller,
  Arrows,
  Autoplay,
  Cover,
  Scroll,
  Drag,
  Keyboard,
  LazyLoad,
  Pagination,
  Sync,
  Wheel,
  Live
});
var I18N = {
  prev: "Previous slide",
  next: "Next slide",
  first: "Go to first slide",
  last: "Go to last slide",
  slideX: "Go to slide %s",
  pageX: "Go to page %s",
  play: "Start autoplay",
  pause: "Pause autoplay",
  carousel: "carousel",
  slide: "slide",
  select: "Select a slide to show",
  slideLabel: "%s of %s"
};
var DEFAULTS = {
  type: "slide",
  role: "region",
  speed: 400,
  perPage: 1,
  cloneStatus: true,
  arrows: true,
  pagination: true,
  paginationKeyboard: true,
  interval: 5e3,
  pauseOnHover: true,
  pauseOnFocus: true,
  resetProgress: true,
  easing: "cubic-bezier(0.25, 1, 0.5, 1)",
  drag: true,
  direction: "ltr",
  trimSpace: true,
  focusableNodes: "a, button, textarea, input, select, iframe",
  live: true,
  classes: CLASSES,
  i18n: I18N,
  reducedMotion: {
    speed: 0,
    rewindSpeed: 0,
    autoplay: "pause"
  }
};
function Fade(Splide22, Components2, options) {
  var Slides2 = Components2.Slides;
  function mount() {
    EventInterface(Splide22).on([EVENT_MOUNTED, EVENT_REFRESH], init);
  }
  function init() {
    Slides2.forEach(function(Slide2) {
      Slide2.style("transform", "translateX(-" + 100 * Slide2.index + "%)");
    });
  }
  function start(index, done) {
    Slides2.style("transition", "opacity " + options.speed + "ms " + options.easing);
    nextTick(done);
  }
  return {
    mount,
    start,
    cancel: noop
  };
}
function Slide(Splide22, Components2, options) {
  var Move2 = Components2.Move, Controller2 = Components2.Controller, Scroll2 = Components2.Scroll;
  var list = Components2.Elements.list;
  var transition = apply(style, list, "transition");
  var endCallback;
  function mount() {
    EventInterface(Splide22).bind(list, "transitionend", function(e) {
      if (e.target === list && endCallback) {
        cancel();
        endCallback();
      }
    });
  }
  function start(index, done) {
    var destination = Move2.toPosition(index, true);
    var position = Move2.getPosition();
    var speed = getSpeed(index);
    if (abs(destination - position) >= 1 && speed >= 1) {
      if (options.useScroll) {
        Scroll2.scroll(destination, speed, false, done);
      } else {
        transition("transform " + speed + "ms " + options.easing);
        Move2.translate(destination, true);
        endCallback = done;
      }
    } else {
      Move2.jump(index);
      done();
    }
  }
  function cancel() {
    transition("");
    Scroll2.cancel();
  }
  function getSpeed(index) {
    var rewindSpeed = options.rewindSpeed;
    if (Splide22.is(SLIDE) && rewindSpeed) {
      var prev = Controller2.getIndex(true);
      var end = Controller2.getEnd();
      if (prev === 0 && index >= end || prev >= end && index === 0) {
        return rewindSpeed;
      }
    }
    return options.speed;
  }
  return {
    mount,
    start,
    cancel
  };
}
var _Splide = /* @__PURE__ */ function() {
  function _Splide2(target, options) {
    this.event = EventInterface();
    this.Components = {};
    this.state = State(CREATED);
    this.splides = [];
    this._o = {};
    this._E = {};
    var root = isString(target) ? query(document, target) : target;
    assert(root, root + " is invalid.");
    this.root = root;
    options = merge({
      label: getAttribute(root, ARIA_LABEL) || "",
      labelledby: getAttribute(root, ARIA_LABELLEDBY) || ""
    }, DEFAULTS, _Splide2.defaults, options || {});
    try {
      merge(options, JSON.parse(getAttribute(root, DATA_ATTRIBUTE)));
    } catch (e) {
      assert(false, "Invalid JSON");
    }
    this._o = Object.create(merge({}, options));
  }
  var _proto = _Splide2.prototype;
  _proto.mount = function mount(Extensions, Transition) {
    var _this = this;
    var state = this.state, Components2 = this.Components;
    assert(state.is([CREATED, DESTROYED]), "Already mounted!");
    state.set(CREATED);
    this._C = Components2;
    this._T = Transition || this._T || (this.is(FADE) ? Fade : Slide);
    this._E = Extensions || this._E;
    var Constructors = assign({}, ComponentConstructors, this._E, {
      Transition: this._T
    });
    forOwn(Constructors, function(Component, key) {
      var component = Component(_this, Components2, _this._o);
      Components2[key] = component;
      component.setup && component.setup();
    });
    forOwn(Components2, function(component) {
      component.mount && component.mount();
    });
    this.emit(EVENT_MOUNTED);
    addClass(this.root, CLASS_INITIALIZED);
    state.set(IDLE);
    this.emit(EVENT_READY);
    return this;
  };
  _proto.sync = function sync(splide) {
    this.splides.push({
      splide
    });
    splide.splides.push({
      splide: this,
      isParent: true
    });
    if (this.state.is(IDLE)) {
      this._C.Sync.remount();
      splide.Components.Sync.remount();
    }
    return this;
  };
  _proto.go = function go(control) {
    this._C.Controller.go(control);
    return this;
  };
  _proto.on = function on(events, callback) {
    this.event.on(events, callback);
    return this;
  };
  _proto.off = function off(events) {
    this.event.off(events);
    return this;
  };
  _proto.emit = function emit(event) {
    var _this$event;
    (_this$event = this.event).emit.apply(_this$event, [event].concat(slice(arguments, 1)));
    return this;
  };
  _proto.add = function add(slides, index) {
    this._C.Slides.add(slides, index);
    return this;
  };
  _proto.remove = function remove2(matcher) {
    this._C.Slides.remove(matcher);
    return this;
  };
  _proto.is = function is(type) {
    return this._o.type === type;
  };
  _proto.refresh = function refresh() {
    this.emit(EVENT_REFRESH);
    return this;
  };
  _proto.destroy = function destroy(completely) {
    if (completely === void 0) {
      completely = true;
    }
    var event = this.event, state = this.state;
    if (state.is(CREATED)) {
      EventInterface(this).on(EVENT_READY, this.destroy.bind(this, completely));
    } else {
      forOwn(this._C, function(component) {
        component.destroy && component.destroy(completely);
      }, true);
      event.emit(EVENT_DESTROY);
      event.destroy();
      completely && empty(this.splides);
      state.set(DESTROYED);
    }
    return this;
  };
  _createClass(_Splide2, [{
    key: "options",
    get: function get() {
      return this._o;
    },
    set: function set(options) {
      this._C.Media.set(options, true, true);
    }
  }, {
    key: "length",
    get: function get() {
      return this._C.Slides.getLength(true);
    }
  }, {
    key: "index",
    get: function get() {
      return this._C.Controller.getIndex();
    }
  }]);
  return _Splide2;
}();
var Splide = _Splide;
Splide.defaults = {};
Splide.STATES = STATES;

// src/js/components/Splide/Splide.tsx


// src/js/constants/events.ts
var EVENTS = [
  [EVENT_MOUNTED, "onMounted"],
  [EVENT_READY, "onReady"],
  [EVENT_MOVE, "onMove"],
  [EVENT_MOVED, "onMoved"],
  [EVENT_CLICK, "onClick"],
  [EVENT_ACTIVE, "onActive"],
  [EVENT_INACTIVE, "onInactive"],
  [EVENT_VISIBLE, "onVisible"],
  [EVENT_HIDDEN, "onHidden"],
  [EVENT_REFRESH, "onRefresh"],
  [EVENT_UPDATED, "onUpdated"],
  [EVENT_RESIZE, "onResize"],
  [EVENT_RESIZED, "onResized"],
  [EVENT_DRAG, "onDrag"],
  [EVENT_DRAGGING, "onDragging"],
  [EVENT_DRAGGED, "onDragged"],
  [EVENT_SCROLL, "onScroll"],
  [EVENT_SCROLLED, "onScrolled"],
  [EVENT_DESTROY, "onDestroy"],
  [EVENT_ARROWS_MOUNTED, "onArrowsMounted"],
  [EVENT_ARROWS_UPDATED, "onArrowsUpdated"],
  [EVENT_PAGINATION_MOUNTED, "onPaginationMounted"],
  [EVENT_PAGINATION_UPDATED, "onPaginationUpdated"],
  [EVENT_NAVIGATION_MOUNTED, "onNavigationMounted"],
  [EVENT_AUTOPLAY_PLAY, "onAutoplayPlay"],
  [EVENT_AUTOPLAY_PLAYING, "onAutoplayPlaying"],
  [EVENT_AUTOPLAY_PAUSE, "onAutoplayPause"],
  [EVENT_LAZYLOAD_LOADED, "onLazyLoadLoaded"]
];

// src/js/utils/classNames/classNames.ts
function classNames(...classes) {
  return classes.filter(Boolean).join(" ");
}

// src/js/utils/isObject/isObject.ts
function isObject2(subject) {
  return subject !== null && typeof subject === "object";
}

// src/js/utils/isEqualDeep/isEqualDeep.ts
function isEqualDeep(subject1, subject2) {
  if (Array.isArray(subject1) && Array.isArray(subject2)) {
    return subject1.length === subject2.length && !subject1.some((elm, index) => !isEqualDeep(elm, subject2[index]));
  }
  if (isObject2(subject1) && isObject2(subject2)) {
    const keys1 = Object.keys(subject1);
    const keys2 = Object.keys(subject2);
    return keys1.length === keys2.length && !keys1.some((key) => {
      return !Object.prototype.hasOwnProperty.call(subject2, key) || !isEqualDeep(subject1[key], subject2[key]);
    });
  }
  return subject1 === subject2;
}

// src/js/utils/isEqualShallow/isEqualShallow.ts
function isEqualShallow(array1, array2) {
  return array1.length === array2.length && !array1.some((elm, index) => elm !== array2[index]);
}

// src/js/utils/forOwn/forOwn.ts
function forOwn2(object, iteratee) {
  if (object) {
    const keys = Object.keys(object);
    for (let i = 0; i < keys.length; i++) {
      const key = keys[i];
      if (key !== "__proto__") {
        if (iteratee(object[key], key) === false) {
          break;
        }
      }
    }
  }
  return object;
}

// src/js/utils/merge/merge.ts
function merge2(object, source) {
  const merged = object;
  forOwn2(source, (value, key) => {
    if (Array.isArray(value)) {
      merged[key] = value.slice();
    } else if (isObject2(value)) {
      merged[key] = merge2(isObject2(merged[key]) ? merged[key] : {}, value);
    } else {
      merged[key] = value;
    }
  });
  return merged;
}

// src/js/components/SplideTrack/SplideTrack.tsx

var SplideTrack = ({ children: children2, className, ...props }) => {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classNames("splide__track", className),
    ...props
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", {
    className: "splide__list"
  }, children2));
};

// src/js/components/Splide/Splide.tsx
var Splide2 = class extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
  constructor() {
    super(...arguments);
    this.splideRef = react__WEBPACK_IMPORTED_MODULE_0___default().createRef();
    this.slides = [];
  }
  componentDidMount() {
    const { options, extensions, transition } = this.props;
    const { current } = this.splideRef;
    if (current) {
      this.splide = new Splide(current, options);
      this.bind(this.splide);
      this.splide.mount(extensions, transition);
      this.options = merge2({}, options || {});
      this.slides = this.getSlides();
    }
  }
  componentWillUnmount() {
    if (this.splide) {
      this.splide.destroy();
      this.splide = void 0;
    }
    this.options = void 0;
    this.slides.length = 0;
  }
  componentDidUpdate() {
    if (!this.splide) {
      return;
    }
    const { options } = this.props;
    if (options && !isEqualDeep(this.options, options)) {
      this.splide.options = options;
      this.options = merge2({}, options);
    }
    const newSlides = this.getSlides();
    if (!isEqualShallow(this.slides, newSlides)) {
      this.splide.refresh();
      this.slides = newSlides;
    }
  }
  sync(splide) {
    var _a;
    (_a = this.splide) == null ? void 0 : _a.sync(splide);
  }
  go(control) {
    var _a;
    (_a = this.splide) == null ? void 0 : _a.go(control);
  }
  getSlides() {
    var _a;
    if (this.splide) {
      const children2 = (_a = this.splide.Components.Elements) == null ? void 0 : _a.list.children;
      return children2 && Array.prototype.slice.call(children2) || [];
    }
    return [];
  }
  bind(splide) {
    EVENTS.forEach(([event, name]) => {
      const handler = this.props[name];
      if (typeof handler === "function") {
        splide.on(event, (...args) => {
          handler(splide, ...args);
        });
      }
    });
  }
  omit(props, keys) {
    keys.forEach((key) => {
      if (Object.prototype.hasOwnProperty.call(props, key)) {
        delete props[key];
      }
    });
    return props;
  }
  render() {
    const { className, tag: Root = "div", hasTrack = true, children: children2, ...props } = this.props;
    return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Root, {
      className: classNames("splide", className),
      ref: this.splideRef,
      ...this.omit(props, ["options", ...EVENTS.map((event) => event[1])])
    }, hasTrack ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SplideTrack, null, children2) : children2);
  }
};

// src/js/components/SplideSlide/SplideSlide.tsx

var SplideSlide = ({ children: children2, className, ...props }) => {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", {
    className: classNames("splide__slide", className),
    ...props
  }, children2);
};

/*!
 * Splide.js
 * Version  : 4.1.3
 * License  : MIT
 * Copyright: 2022 Naotoshi Fujita
 */


/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/icon/index.js":
/*!******************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/icon/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */

/** @typedef {{icon: JSX.Element, size?: number} & import('@wordpress/primitives').SVGProps} IconProps */

/**
 * Return an SVG icon.
 *
 * @param {IconProps} props icon is the SVG component to render
 *                          size is a number specifiying the icon size in pixels
 *                          Other props will be passed to wrapped SVG component
 *
 * @return {JSX.Element}  Icon component
 */

function Icon(_ref) {
  let {
    icon,
    size = 24,
    ...props
  } = _ref;
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(icon, {
    width: size,
    height: size,
    ...props
  });
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Icon);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/arrow-right.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/arrow-right.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const arrowRight = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "m14.5 6.5-1 1 3.7 3.7H4v1.6h13.2l-3.7 3.7 1 1 5.6-5.5z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (arrowRight);
//# sourceMappingURL=arrow-right.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/chevron-down.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/chevron-down.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const chevronDown = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M17.5 11.6L12 16l-5.5-4.4.9-1.2L12 14l4.5-3.6 1 1.2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (chevronDown);
//# sourceMappingURL=chevron-down.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/chevron-up.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/chevron-up.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const chevronUp = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M6.5 12.4L12 8l5.5 4.4-.9 1.2L12 10l-4.5 3.6-1-1.2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (chevronUp);
//# sourceMappingURL=chevron-up.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/close.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/close.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const close = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M13 11.8l6.1-6.3-1-1-6.1 6.2-6.1-6.2-1 1 6.1 6.3-6.5 6.7 1 1 6.5-6.6 6.5 6.6 1-1z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (close);
//# sourceMappingURL=close.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/cloud.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/cloud.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const cloud = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M17.3 10.1c0-2.5-2.1-4.4-4.8-4.4-2.2 0-4.1 1.4-4.6 3.3h-.2C5.7 9 4 10.7 4 12.8c0 2.1 1.7 3.8 3.7 3.8h9c1.8 0 3.2-1.5 3.2-3.3.1-1.6-1.1-2.9-2.6-3.2zm-.5 5.1h-9c-1.2 0-2.2-1.1-2.2-2.3s1-2.4 2.2-2.4h1.3l.3-1.1c.4-1.3 1.7-2.2 3.2-2.2 1.8 0 3.3 1.3 3.3 2.9v1.3l1.3.2c.8.1 1.4.9 1.4 1.8-.1 1-.9 1.8-1.8 1.8z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (cloud);
//# sourceMappingURL=cloud.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/download.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/download.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const download = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M18 11.3l-1-1.1-4 4V3h-1.5v11.3L7 10.2l-1 1.1 6.2 5.8 5.8-5.8zm.5 3.7v3.5h-13V15H4v5h16v-5h-1.5z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (download);
//# sourceMappingURL=download.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/line-dotted.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/line-dotted.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const lineDotted = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  d: "M5.25 11.25h1.5v1.5h-1.5v-1.5zm3 0h1.5v1.5h-1.5v-1.5zm4.5 0h-1.5v1.5h1.5v-1.5zm1.5 0h1.5v1.5h-1.5v-1.5zm4.5 0h-1.5v1.5h1.5v-1.5z",
  clipRule: "evenodd"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (lineDotted);
//# sourceMappingURL=line-dotted.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/link-off.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/link-off.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const linkOff = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M15.6 7.3h-.7l1.6-3.5-.9-.4-3.9 8.5H9v1.5h2l-1.3 2.8H8.4c-2 0-3.7-1.7-3.7-3.7s1.7-3.7 3.7-3.7H10V7.3H8.4c-2.9 0-5.2 2.3-5.2 5.2 0 2.9 2.3 5.2 5.2 5.2H9l-1.4 3.2.9.4 5.7-12.5h1.4c2 0 3.7 1.7 3.7 3.7s-1.7 3.7-3.7 3.7H14v1.5h1.6c2.9 0 5.2-2.3 5.2-5.2 0-2.9-2.4-5.2-5.2-5.2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (linkOff);
//# sourceMappingURL=link-off.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/link.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/link.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const link = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M15.6 7.2H14v1.5h1.6c2 0 3.7 1.7 3.7 3.7s-1.7 3.7-3.7 3.7H14v1.5h1.6c2.8 0 5.2-2.3 5.2-5.2 0-2.9-2.3-5.2-5.2-5.2zM4.7 12.4c0-2 1.7-3.7 3.7-3.7H10V7.2H8.4c-2.9 0-5.2 2.3-5.2 5.2 0 2.9 2.3 5.2 5.2 5.2H10v-1.5H8.4c-2 0-3.7-1.7-3.7-3.7zm4.6.9h5.3v-1.5H9.3v1.5z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (link);
//# sourceMappingURL=link.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/menu.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/menu.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const menu = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M5 5v1.5h14V5H5zm0 7.8h14v-1.5H5v1.5zM5 19h14v-1.5H5V19z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (menu);
//# sourceMappingURL=menu.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/pencil.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/pencil.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const pencil = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M20.1 5.1L16.9 2 6.2 12.7l-1.3 4.4 4.5-1.3L20.1 5.1zM4 20.8h8v-1.5H4v1.5z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (pencil);
//# sourceMappingURL=pencil.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/plus.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/plus.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const plus = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M18 11.2h-5.2V6h-1.6v5.2H6v1.6h5.2V18h1.6v-5.2H18z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (plus);
//# sourceMappingURL=plus.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/settings.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/settings.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const settings = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M14.5 13.8c-1.1 0-2.1.7-2.4 1.8H4V17h8.1c.3 1 1.3 1.8 2.4 1.8s2.1-.7 2.4-1.8H20v-1.5h-3.1c-.3-1-1.3-1.7-2.4-1.7zM11.9 7c-.3-1-1.3-1.8-2.4-1.8S7.4 6 7.1 7H4v1.5h3.1c.3 1 1.3 1.8 2.4 1.8s2.1-.7 2.4-1.8H20V7h-8.1z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (settings);
//# sourceMappingURL=settings.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/styles.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/styles.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "styles": () => (/* binding */ styles)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const styles = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M12 4c-4.4 0-8 3.6-8 8v.1c0 4.1 3.2 7.5 7.2 7.9h.8c4.4 0 8-3.6 8-8s-3.6-8-8-8zm0 15V5c3.9 0 7 3.1 7 7s-3.1 7-7 7z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (styles);
//# sourceMappingURL=styles.js.map

/***/ }),

/***/ "./node_modules/animejs/lib/anime.es.js":
/*!**********************************************!*\
  !*** ./node_modules/animejs/lib/anime.es.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
 * anime.js v3.2.1
 * (c) 2020 Julian Garnier
 * Released under the MIT license
 * animejs.com
 */

// Defaults

var defaultInstanceSettings = {
  update: null,
  begin: null,
  loopBegin: null,
  changeBegin: null,
  change: null,
  changeComplete: null,
  loopComplete: null,
  complete: null,
  loop: 1,
  direction: 'normal',
  autoplay: true,
  timelineOffset: 0
};

var defaultTweenSettings = {
  duration: 1000,
  delay: 0,
  endDelay: 0,
  easing: 'easeOutElastic(1, .5)',
  round: 0
};

var validTransforms = ['translateX', 'translateY', 'translateZ', 'rotate', 'rotateX', 'rotateY', 'rotateZ', 'scale', 'scaleX', 'scaleY', 'scaleZ', 'skew', 'skewX', 'skewY', 'perspective', 'matrix', 'matrix3d'];

// Caching

var cache = {
  CSS: {},
  springs: {}
};

// Utils

function minMax(val, min, max) {
  return Math.min(Math.max(val, min), max);
}

function stringContains(str, text) {
  return str.indexOf(text) > -1;
}

function applyArguments(func, args) {
  return func.apply(null, args);
}

var is = {
  arr: function (a) { return Array.isArray(a); },
  obj: function (a) { return stringContains(Object.prototype.toString.call(a), 'Object'); },
  pth: function (a) { return is.obj(a) && a.hasOwnProperty('totalLength'); },
  svg: function (a) { return a instanceof SVGElement; },
  inp: function (a) { return a instanceof HTMLInputElement; },
  dom: function (a) { return a.nodeType || is.svg(a); },
  str: function (a) { return typeof a === 'string'; },
  fnc: function (a) { return typeof a === 'function'; },
  und: function (a) { return typeof a === 'undefined'; },
  nil: function (a) { return is.und(a) || a === null; },
  hex: function (a) { return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(a); },
  rgb: function (a) { return /^rgb/.test(a); },
  hsl: function (a) { return /^hsl/.test(a); },
  col: function (a) { return (is.hex(a) || is.rgb(a) || is.hsl(a)); },
  key: function (a) { return !defaultInstanceSettings.hasOwnProperty(a) && !defaultTweenSettings.hasOwnProperty(a) && a !== 'targets' && a !== 'keyframes'; },
};

// Easings

function parseEasingParameters(string) {
  var match = /\(([^)]+)\)/.exec(string);
  return match ? match[1].split(',').map(function (p) { return parseFloat(p); }) : [];
}

// Spring solver inspired by Webkit Copyright © 2016 Apple Inc. All rights reserved. https://webkit.org/demos/spring/spring.js

function spring(string, duration) {

  var params = parseEasingParameters(string);
  var mass = minMax(is.und(params[0]) ? 1 : params[0], .1, 100);
  var stiffness = minMax(is.und(params[1]) ? 100 : params[1], .1, 100);
  var damping = minMax(is.und(params[2]) ? 10 : params[2], .1, 100);
  var velocity =  minMax(is.und(params[3]) ? 0 : params[3], .1, 100);
  var w0 = Math.sqrt(stiffness / mass);
  var zeta = damping / (2 * Math.sqrt(stiffness * mass));
  var wd = zeta < 1 ? w0 * Math.sqrt(1 - zeta * zeta) : 0;
  var a = 1;
  var b = zeta < 1 ? (zeta * w0 + -velocity) / wd : -velocity + w0;

  function solver(t) {
    var progress = duration ? (duration * t) / 1000 : t;
    if (zeta < 1) {
      progress = Math.exp(-progress * zeta * w0) * (a * Math.cos(wd * progress) + b * Math.sin(wd * progress));
    } else {
      progress = (a + b * progress) * Math.exp(-progress * w0);
    }
    if (t === 0 || t === 1) { return t; }
    return 1 - progress;
  }

  function getDuration() {
    var cached = cache.springs[string];
    if (cached) { return cached; }
    var frame = 1/6;
    var elapsed = 0;
    var rest = 0;
    while(true) {
      elapsed += frame;
      if (solver(elapsed) === 1) {
        rest++;
        if (rest >= 16) { break; }
      } else {
        rest = 0;
      }
    }
    var duration = elapsed * frame * 1000;
    cache.springs[string] = duration;
    return duration;
  }

  return duration ? solver : getDuration;

}

// Basic steps easing implementation https://developer.mozilla.org/fr/docs/Web/CSS/transition-timing-function

function steps(steps) {
  if ( steps === void 0 ) steps = 10;

  return function (t) { return Math.ceil((minMax(t, 0.000001, 1)) * steps) * (1 / steps); };
}

// BezierEasing https://github.com/gre/bezier-easing

var bezier = (function () {

  var kSplineTableSize = 11;
  var kSampleStepSize = 1.0 / (kSplineTableSize - 1.0);

  function A(aA1, aA2) { return 1.0 - 3.0 * aA2 + 3.0 * aA1 }
  function B(aA1, aA2) { return 3.0 * aA2 - 6.0 * aA1 }
  function C(aA1)      { return 3.0 * aA1 }

  function calcBezier(aT, aA1, aA2) { return ((A(aA1, aA2) * aT + B(aA1, aA2)) * aT + C(aA1)) * aT }
  function getSlope(aT, aA1, aA2) { return 3.0 * A(aA1, aA2) * aT * aT + 2.0 * B(aA1, aA2) * aT + C(aA1) }

  function binarySubdivide(aX, aA, aB, mX1, mX2) {
    var currentX, currentT, i = 0;
    do {
      currentT = aA + (aB - aA) / 2.0;
      currentX = calcBezier(currentT, mX1, mX2) - aX;
      if (currentX > 0.0) { aB = currentT; } else { aA = currentT; }
    } while (Math.abs(currentX) > 0.0000001 && ++i < 10);
    return currentT;
  }

  function newtonRaphsonIterate(aX, aGuessT, mX1, mX2) {
    for (var i = 0; i < 4; ++i) {
      var currentSlope = getSlope(aGuessT, mX1, mX2);
      if (currentSlope === 0.0) { return aGuessT; }
      var currentX = calcBezier(aGuessT, mX1, mX2) - aX;
      aGuessT -= currentX / currentSlope;
    }
    return aGuessT;
  }

  function bezier(mX1, mY1, mX2, mY2) {

    if (!(0 <= mX1 && mX1 <= 1 && 0 <= mX2 && mX2 <= 1)) { return; }
    var sampleValues = new Float32Array(kSplineTableSize);

    if (mX1 !== mY1 || mX2 !== mY2) {
      for (var i = 0; i < kSplineTableSize; ++i) {
        sampleValues[i] = calcBezier(i * kSampleStepSize, mX1, mX2);
      }
    }

    function getTForX(aX) {

      var intervalStart = 0;
      var currentSample = 1;
      var lastSample = kSplineTableSize - 1;

      for (; currentSample !== lastSample && sampleValues[currentSample] <= aX; ++currentSample) {
        intervalStart += kSampleStepSize;
      }

      --currentSample;

      var dist = (aX - sampleValues[currentSample]) / (sampleValues[currentSample + 1] - sampleValues[currentSample]);
      var guessForT = intervalStart + dist * kSampleStepSize;
      var initialSlope = getSlope(guessForT, mX1, mX2);

      if (initialSlope >= 0.001) {
        return newtonRaphsonIterate(aX, guessForT, mX1, mX2);
      } else if (initialSlope === 0.0) {
        return guessForT;
      } else {
        return binarySubdivide(aX, intervalStart, intervalStart + kSampleStepSize, mX1, mX2);
      }

    }

    return function (x) {
      if (mX1 === mY1 && mX2 === mY2) { return x; }
      if (x === 0 || x === 1) { return x; }
      return calcBezier(getTForX(x), mY1, mY2);
    }

  }

  return bezier;

})();

var penner = (function () {

  // Based on jQuery UI's implemenation of easing equations from Robert Penner (http://www.robertpenner.com/easing)

  var eases = { linear: function () { return function (t) { return t; }; } };

  var functionEasings = {
    Sine: function () { return function (t) { return 1 - Math.cos(t * Math.PI / 2); }; },
    Circ: function () { return function (t) { return 1 - Math.sqrt(1 - t * t); }; },
    Back: function () { return function (t) { return t * t * (3 * t - 2); }; },
    Bounce: function () { return function (t) {
      var pow2, b = 4;
      while (t < (( pow2 = Math.pow(2, --b)) - 1) / 11) {}
      return 1 / Math.pow(4, 3 - b) - 7.5625 * Math.pow(( pow2 * 3 - 2 ) / 22 - t, 2)
    }; },
    Elastic: function (amplitude, period) {
      if ( amplitude === void 0 ) amplitude = 1;
      if ( period === void 0 ) period = .5;

      var a = minMax(amplitude, 1, 10);
      var p = minMax(period, .1, 2);
      return function (t) {
        return (t === 0 || t === 1) ? t : 
          -a * Math.pow(2, 10 * (t - 1)) * Math.sin((((t - 1) - (p / (Math.PI * 2) * Math.asin(1 / a))) * (Math.PI * 2)) / p);
      }
    }
  };

  var baseEasings = ['Quad', 'Cubic', 'Quart', 'Quint', 'Expo'];

  baseEasings.forEach(function (name, i) {
    functionEasings[name] = function () { return function (t) { return Math.pow(t, i + 2); }; };
  });

  Object.keys(functionEasings).forEach(function (name) {
    var easeIn = functionEasings[name];
    eases['easeIn' + name] = easeIn;
    eases['easeOut' + name] = function (a, b) { return function (t) { return 1 - easeIn(a, b)(1 - t); }; };
    eases['easeInOut' + name] = function (a, b) { return function (t) { return t < 0.5 ? easeIn(a, b)(t * 2) / 2 : 
      1 - easeIn(a, b)(t * -2 + 2) / 2; }; };
    eases['easeOutIn' + name] = function (a, b) { return function (t) { return t < 0.5 ? (1 - easeIn(a, b)(1 - t * 2)) / 2 : 
      (easeIn(a, b)(t * 2 - 1) + 1) / 2; }; };
  });

  return eases;

})();

function parseEasings(easing, duration) {
  if (is.fnc(easing)) { return easing; }
  var name = easing.split('(')[0];
  var ease = penner[name];
  var args = parseEasingParameters(easing);
  switch (name) {
    case 'spring' : return spring(easing, duration);
    case 'cubicBezier' : return applyArguments(bezier, args);
    case 'steps' : return applyArguments(steps, args);
    default : return applyArguments(ease, args);
  }
}

// Strings

function selectString(str) {
  try {
    var nodes = document.querySelectorAll(str);
    return nodes;
  } catch(e) {
    return;
  }
}

// Arrays

function filterArray(arr, callback) {
  var len = arr.length;
  var thisArg = arguments.length >= 2 ? arguments[1] : void 0;
  var result = [];
  for (var i = 0; i < len; i++) {
    if (i in arr) {
      var val = arr[i];
      if (callback.call(thisArg, val, i, arr)) {
        result.push(val);
      }
    }
  }
  return result;
}

function flattenArray(arr) {
  return arr.reduce(function (a, b) { return a.concat(is.arr(b) ? flattenArray(b) : b); }, []);
}

function toArray(o) {
  if (is.arr(o)) { return o; }
  if (is.str(o)) { o = selectString(o) || o; }
  if (o instanceof NodeList || o instanceof HTMLCollection) { return [].slice.call(o); }
  return [o];
}

function arrayContains(arr, val) {
  return arr.some(function (a) { return a === val; });
}

// Objects

function cloneObject(o) {
  var clone = {};
  for (var p in o) { clone[p] = o[p]; }
  return clone;
}

function replaceObjectProps(o1, o2) {
  var o = cloneObject(o1);
  for (var p in o1) { o[p] = o2.hasOwnProperty(p) ? o2[p] : o1[p]; }
  return o;
}

function mergeObjects(o1, o2) {
  var o = cloneObject(o1);
  for (var p in o2) { o[p] = is.und(o1[p]) ? o2[p] : o1[p]; }
  return o;
}

// Colors

function rgbToRgba(rgbValue) {
  var rgb = /rgb\((\d+,\s*[\d]+,\s*[\d]+)\)/g.exec(rgbValue);
  return rgb ? ("rgba(" + (rgb[1]) + ",1)") : rgbValue;
}

function hexToRgba(hexValue) {
  var rgx = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
  var hex = hexValue.replace(rgx, function (m, r, g, b) { return r + r + g + g + b + b; } );
  var rgb = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
  var r = parseInt(rgb[1], 16);
  var g = parseInt(rgb[2], 16);
  var b = parseInt(rgb[3], 16);
  return ("rgba(" + r + "," + g + "," + b + ",1)");
}

function hslToRgba(hslValue) {
  var hsl = /hsl\((\d+),\s*([\d.]+)%,\s*([\d.]+)%\)/g.exec(hslValue) || /hsla\((\d+),\s*([\d.]+)%,\s*([\d.]+)%,\s*([\d.]+)\)/g.exec(hslValue);
  var h = parseInt(hsl[1], 10) / 360;
  var s = parseInt(hsl[2], 10) / 100;
  var l = parseInt(hsl[3], 10) / 100;
  var a = hsl[4] || 1;
  function hue2rgb(p, q, t) {
    if (t < 0) { t += 1; }
    if (t > 1) { t -= 1; }
    if (t < 1/6) { return p + (q - p) * 6 * t; }
    if (t < 1/2) { return q; }
    if (t < 2/3) { return p + (q - p) * (2/3 - t) * 6; }
    return p;
  }
  var r, g, b;
  if (s == 0) {
    r = g = b = l;
  } else {
    var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
    var p = 2 * l - q;
    r = hue2rgb(p, q, h + 1/3);
    g = hue2rgb(p, q, h);
    b = hue2rgb(p, q, h - 1/3);
  }
  return ("rgba(" + (r * 255) + "," + (g * 255) + "," + (b * 255) + "," + a + ")");
}

function colorToRgb(val) {
  if (is.rgb(val)) { return rgbToRgba(val); }
  if (is.hex(val)) { return hexToRgba(val); }
  if (is.hsl(val)) { return hslToRgba(val); }
}

// Units

function getUnit(val) {
  var split = /[+-]?\d*\.?\d+(?:\.\d+)?(?:[eE][+-]?\d+)?(%|px|pt|em|rem|in|cm|mm|ex|ch|pc|vw|vh|vmin|vmax|deg|rad|turn)?$/.exec(val);
  if (split) { return split[1]; }
}

function getTransformUnit(propName) {
  if (stringContains(propName, 'translate') || propName === 'perspective') { return 'px'; }
  if (stringContains(propName, 'rotate') || stringContains(propName, 'skew')) { return 'deg'; }
}

// Values

function getFunctionValue(val, animatable) {
  if (!is.fnc(val)) { return val; }
  return val(animatable.target, animatable.id, animatable.total);
}

function getAttribute(el, prop) {
  return el.getAttribute(prop);
}

function convertPxToUnit(el, value, unit) {
  var valueUnit = getUnit(value);
  if (arrayContains([unit, 'deg', 'rad', 'turn'], valueUnit)) { return value; }
  var cached = cache.CSS[value + unit];
  if (!is.und(cached)) { return cached; }
  var baseline = 100;
  var tempEl = document.createElement(el.tagName);
  var parentEl = (el.parentNode && (el.parentNode !== document)) ? el.parentNode : document.body;
  parentEl.appendChild(tempEl);
  tempEl.style.position = 'absolute';
  tempEl.style.width = baseline + unit;
  var factor = baseline / tempEl.offsetWidth;
  parentEl.removeChild(tempEl);
  var convertedUnit = factor * parseFloat(value);
  cache.CSS[value + unit] = convertedUnit;
  return convertedUnit;
}

function getCSSValue(el, prop, unit) {
  if (prop in el.style) {
    var uppercasePropName = prop.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase();
    var value = el.style[prop] || getComputedStyle(el).getPropertyValue(uppercasePropName) || '0';
    return unit ? convertPxToUnit(el, value, unit) : value;
  }
}

function getAnimationType(el, prop) {
  if (is.dom(el) && !is.inp(el) && (!is.nil(getAttribute(el, prop)) || (is.svg(el) && el[prop]))) { return 'attribute'; }
  if (is.dom(el) && arrayContains(validTransforms, prop)) { return 'transform'; }
  if (is.dom(el) && (prop !== 'transform' && getCSSValue(el, prop))) { return 'css'; }
  if (el[prop] != null) { return 'object'; }
}

function getElementTransforms(el) {
  if (!is.dom(el)) { return; }
  var str = el.style.transform || '';
  var reg  = /(\w+)\(([^)]*)\)/g;
  var transforms = new Map();
  var m; while (m = reg.exec(str)) { transforms.set(m[1], m[2]); }
  return transforms;
}

function getTransformValue(el, propName, animatable, unit) {
  var defaultVal = stringContains(propName, 'scale') ? 1 : 0 + getTransformUnit(propName);
  var value = getElementTransforms(el).get(propName) || defaultVal;
  if (animatable) {
    animatable.transforms.list.set(propName, value);
    animatable.transforms['last'] = propName;
  }
  return unit ? convertPxToUnit(el, value, unit) : value;
}

function getOriginalTargetValue(target, propName, unit, animatable) {
  switch (getAnimationType(target, propName)) {
    case 'transform': return getTransformValue(target, propName, animatable, unit);
    case 'css': return getCSSValue(target, propName, unit);
    case 'attribute': return getAttribute(target, propName);
    default: return target[propName] || 0;
  }
}

function getRelativeValue(to, from) {
  var operator = /^(\*=|\+=|-=)/.exec(to);
  if (!operator) { return to; }
  var u = getUnit(to) || 0;
  var x = parseFloat(from);
  var y = parseFloat(to.replace(operator[0], ''));
  switch (operator[0][0]) {
    case '+': return x + y + u;
    case '-': return x - y + u;
    case '*': return x * y + u;
  }
}

function validateValue(val, unit) {
  if (is.col(val)) { return colorToRgb(val); }
  if (/\s/g.test(val)) { return val; }
  var originalUnit = getUnit(val);
  var unitLess = originalUnit ? val.substr(0, val.length - originalUnit.length) : val;
  if (unit) { return unitLess + unit; }
  return unitLess;
}

// getTotalLength() equivalent for circle, rect, polyline, polygon and line shapes
// adapted from https://gist.github.com/SebLambla/3e0550c496c236709744

function getDistance(p1, p2) {
  return Math.sqrt(Math.pow(p2.x - p1.x, 2) + Math.pow(p2.y - p1.y, 2));
}

function getCircleLength(el) {
  return Math.PI * 2 * getAttribute(el, 'r');
}

function getRectLength(el) {
  return (getAttribute(el, 'width') * 2) + (getAttribute(el, 'height') * 2);
}

function getLineLength(el) {
  return getDistance(
    {x: getAttribute(el, 'x1'), y: getAttribute(el, 'y1')}, 
    {x: getAttribute(el, 'x2'), y: getAttribute(el, 'y2')}
  );
}

function getPolylineLength(el) {
  var points = el.points;
  var totalLength = 0;
  var previousPos;
  for (var i = 0 ; i < points.numberOfItems; i++) {
    var currentPos = points.getItem(i);
    if (i > 0) { totalLength += getDistance(previousPos, currentPos); }
    previousPos = currentPos;
  }
  return totalLength;
}

function getPolygonLength(el) {
  var points = el.points;
  return getPolylineLength(el) + getDistance(points.getItem(points.numberOfItems - 1), points.getItem(0));
}

// Path animation

function getTotalLength(el) {
  if (el.getTotalLength) { return el.getTotalLength(); }
  switch(el.tagName.toLowerCase()) {
    case 'circle': return getCircleLength(el);
    case 'rect': return getRectLength(el);
    case 'line': return getLineLength(el);
    case 'polyline': return getPolylineLength(el);
    case 'polygon': return getPolygonLength(el);
  }
}

function setDashoffset(el) {
  var pathLength = getTotalLength(el);
  el.setAttribute('stroke-dasharray', pathLength);
  return pathLength;
}

// Motion path

function getParentSvgEl(el) {
  var parentEl = el.parentNode;
  while (is.svg(parentEl)) {
    if (!is.svg(parentEl.parentNode)) { break; }
    parentEl = parentEl.parentNode;
  }
  return parentEl;
}

function getParentSvg(pathEl, svgData) {
  var svg = svgData || {};
  var parentSvgEl = svg.el || getParentSvgEl(pathEl);
  var rect = parentSvgEl.getBoundingClientRect();
  var viewBoxAttr = getAttribute(parentSvgEl, 'viewBox');
  var width = rect.width;
  var height = rect.height;
  var viewBox = svg.viewBox || (viewBoxAttr ? viewBoxAttr.split(' ') : [0, 0, width, height]);
  return {
    el: parentSvgEl,
    viewBox: viewBox,
    x: viewBox[0] / 1,
    y: viewBox[1] / 1,
    w: width,
    h: height,
    vW: viewBox[2],
    vH: viewBox[3]
  }
}

function getPath(path, percent) {
  var pathEl = is.str(path) ? selectString(path)[0] : path;
  var p = percent || 100;
  return function(property) {
    return {
      property: property,
      el: pathEl,
      svg: getParentSvg(pathEl),
      totalLength: getTotalLength(pathEl) * (p / 100)
    }
  }
}

function getPathProgress(path, progress, isPathTargetInsideSVG) {
  function point(offset) {
    if ( offset === void 0 ) offset = 0;

    var l = progress + offset >= 1 ? progress + offset : 0;
    return path.el.getPointAtLength(l);
  }
  var svg = getParentSvg(path.el, path.svg);
  var p = point();
  var p0 = point(-1);
  var p1 = point(+1);
  var scaleX = isPathTargetInsideSVG ? 1 : svg.w / svg.vW;
  var scaleY = isPathTargetInsideSVG ? 1 : svg.h / svg.vH;
  switch (path.property) {
    case 'x': return (p.x - svg.x) * scaleX;
    case 'y': return (p.y - svg.y) * scaleY;
    case 'angle': return Math.atan2(p1.y - p0.y, p1.x - p0.x) * 180 / Math.PI;
  }
}

// Decompose value

function decomposeValue(val, unit) {
  // const rgx = /-?\d*\.?\d+/g; // handles basic numbers
  // const rgx = /[+-]?\d+(?:\.\d+)?(?:[eE][+-]?\d+)?/g; // handles exponents notation
  var rgx = /[+-]?\d*\.?\d+(?:\.\d+)?(?:[eE][+-]?\d+)?/g; // handles exponents notation
  var value = validateValue((is.pth(val) ? val.totalLength : val), unit) + '';
  return {
    original: value,
    numbers: value.match(rgx) ? value.match(rgx).map(Number) : [0],
    strings: (is.str(val) || unit) ? value.split(rgx) : []
  }
}

// Animatables

function parseTargets(targets) {
  var targetsArray = targets ? (flattenArray(is.arr(targets) ? targets.map(toArray) : toArray(targets))) : [];
  return filterArray(targetsArray, function (item, pos, self) { return self.indexOf(item) === pos; });
}

function getAnimatables(targets) {
  var parsed = parseTargets(targets);
  return parsed.map(function (t, i) {
    return {target: t, id: i, total: parsed.length, transforms: { list: getElementTransforms(t) } };
  });
}

// Properties

function normalizePropertyTweens(prop, tweenSettings) {
  var settings = cloneObject(tweenSettings);
  // Override duration if easing is a spring
  if (/^spring/.test(settings.easing)) { settings.duration = spring(settings.easing); }
  if (is.arr(prop)) {
    var l = prop.length;
    var isFromTo = (l === 2 && !is.obj(prop[0]));
    if (!isFromTo) {
      // Duration divided by the number of tweens
      if (!is.fnc(tweenSettings.duration)) { settings.duration = tweenSettings.duration / l; }
    } else {
      // Transform [from, to] values shorthand to a valid tween value
      prop = {value: prop};
    }
  }
  var propArray = is.arr(prop) ? prop : [prop];
  return propArray.map(function (v, i) {
    var obj = (is.obj(v) && !is.pth(v)) ? v : {value: v};
    // Default delay value should only be applied to the first tween
    if (is.und(obj.delay)) { obj.delay = !i ? tweenSettings.delay : 0; }
    // Default endDelay value should only be applied to the last tween
    if (is.und(obj.endDelay)) { obj.endDelay = i === propArray.length - 1 ? tweenSettings.endDelay : 0; }
    return obj;
  }).map(function (k) { return mergeObjects(k, settings); });
}


function flattenKeyframes(keyframes) {
  var propertyNames = filterArray(flattenArray(keyframes.map(function (key) { return Object.keys(key); })), function (p) { return is.key(p); })
  .reduce(function (a,b) { if (a.indexOf(b) < 0) { a.push(b); } return a; }, []);
  var properties = {};
  var loop = function ( i ) {
    var propName = propertyNames[i];
    properties[propName] = keyframes.map(function (key) {
      var newKey = {};
      for (var p in key) {
        if (is.key(p)) {
          if (p == propName) { newKey.value = key[p]; }
        } else {
          newKey[p] = key[p];
        }
      }
      return newKey;
    });
  };

  for (var i = 0; i < propertyNames.length; i++) loop( i );
  return properties;
}

function getProperties(tweenSettings, params) {
  var properties = [];
  var keyframes = params.keyframes;
  if (keyframes) { params = mergeObjects(flattenKeyframes(keyframes), params); }
  for (var p in params) {
    if (is.key(p)) {
      properties.push({
        name: p,
        tweens: normalizePropertyTweens(params[p], tweenSettings)
      });
    }
  }
  return properties;
}

// Tweens

function normalizeTweenValues(tween, animatable) {
  var t = {};
  for (var p in tween) {
    var value = getFunctionValue(tween[p], animatable);
    if (is.arr(value)) {
      value = value.map(function (v) { return getFunctionValue(v, animatable); });
      if (value.length === 1) { value = value[0]; }
    }
    t[p] = value;
  }
  t.duration = parseFloat(t.duration);
  t.delay = parseFloat(t.delay);
  return t;
}

function normalizeTweens(prop, animatable) {
  var previousTween;
  return prop.tweens.map(function (t) {
    var tween = normalizeTweenValues(t, animatable);
    var tweenValue = tween.value;
    var to = is.arr(tweenValue) ? tweenValue[1] : tweenValue;
    var toUnit = getUnit(to);
    var originalValue = getOriginalTargetValue(animatable.target, prop.name, toUnit, animatable);
    var previousValue = previousTween ? previousTween.to.original : originalValue;
    var from = is.arr(tweenValue) ? tweenValue[0] : previousValue;
    var fromUnit = getUnit(from) || getUnit(originalValue);
    var unit = toUnit || fromUnit;
    if (is.und(to)) { to = previousValue; }
    tween.from = decomposeValue(from, unit);
    tween.to = decomposeValue(getRelativeValue(to, from), unit);
    tween.start = previousTween ? previousTween.end : 0;
    tween.end = tween.start + tween.delay + tween.duration + tween.endDelay;
    tween.easing = parseEasings(tween.easing, tween.duration);
    tween.isPath = is.pth(tweenValue);
    tween.isPathTargetInsideSVG = tween.isPath && is.svg(animatable.target);
    tween.isColor = is.col(tween.from.original);
    if (tween.isColor) { tween.round = 1; }
    previousTween = tween;
    return tween;
  });
}

// Tween progress

var setProgressValue = {
  css: function (t, p, v) { return t.style[p] = v; },
  attribute: function (t, p, v) { return t.setAttribute(p, v); },
  object: function (t, p, v) { return t[p] = v; },
  transform: function (t, p, v, transforms, manual) {
    transforms.list.set(p, v);
    if (p === transforms.last || manual) {
      var str = '';
      transforms.list.forEach(function (value, prop) { str += prop + "(" + value + ") "; });
      t.style.transform = str;
    }
  }
};

// Set Value helper

function setTargetsValue(targets, properties) {
  var animatables = getAnimatables(targets);
  animatables.forEach(function (animatable) {
    for (var property in properties) {
      var value = getFunctionValue(properties[property], animatable);
      var target = animatable.target;
      var valueUnit = getUnit(value);
      var originalValue = getOriginalTargetValue(target, property, valueUnit, animatable);
      var unit = valueUnit || getUnit(originalValue);
      var to = getRelativeValue(validateValue(value, unit), originalValue);
      var animType = getAnimationType(target, property);
      setProgressValue[animType](target, property, to, animatable.transforms, true);
    }
  });
}

// Animations

function createAnimation(animatable, prop) {
  var animType = getAnimationType(animatable.target, prop.name);
  if (animType) {
    var tweens = normalizeTweens(prop, animatable);
    var lastTween = tweens[tweens.length - 1];
    return {
      type: animType,
      property: prop.name,
      animatable: animatable,
      tweens: tweens,
      duration: lastTween.end,
      delay: tweens[0].delay,
      endDelay: lastTween.endDelay
    }
  }
}

function getAnimations(animatables, properties) {
  return filterArray(flattenArray(animatables.map(function (animatable) {
    return properties.map(function (prop) {
      return createAnimation(animatable, prop);
    });
  })), function (a) { return !is.und(a); });
}

// Create Instance

function getInstanceTimings(animations, tweenSettings) {
  var animLength = animations.length;
  var getTlOffset = function (anim) { return anim.timelineOffset ? anim.timelineOffset : 0; };
  var timings = {};
  timings.duration = animLength ? Math.max.apply(Math, animations.map(function (anim) { return getTlOffset(anim) + anim.duration; })) : tweenSettings.duration;
  timings.delay = animLength ? Math.min.apply(Math, animations.map(function (anim) { return getTlOffset(anim) + anim.delay; })) : tweenSettings.delay;
  timings.endDelay = animLength ? timings.duration - Math.max.apply(Math, animations.map(function (anim) { return getTlOffset(anim) + anim.duration - anim.endDelay; })) : tweenSettings.endDelay;
  return timings;
}

var instanceID = 0;

function createNewInstance(params) {
  var instanceSettings = replaceObjectProps(defaultInstanceSettings, params);
  var tweenSettings = replaceObjectProps(defaultTweenSettings, params);
  var properties = getProperties(tweenSettings, params);
  var animatables = getAnimatables(params.targets);
  var animations = getAnimations(animatables, properties);
  var timings = getInstanceTimings(animations, tweenSettings);
  var id = instanceID;
  instanceID++;
  return mergeObjects(instanceSettings, {
    id: id,
    children: [],
    animatables: animatables,
    animations: animations,
    duration: timings.duration,
    delay: timings.delay,
    endDelay: timings.endDelay
  });
}

// Core

var activeInstances = [];

var engine = (function () {
  var raf;

  function play() {
    if (!raf && (!isDocumentHidden() || !anime.suspendWhenDocumentHidden) && activeInstances.length > 0) {
      raf = requestAnimationFrame(step);
    }
  }
  function step(t) {
    // memo on algorithm issue:
    // dangerous iteration over mutable `activeInstances`
    // (that collection may be updated from within callbacks of `tick`-ed animation instances)
    var activeInstancesLength = activeInstances.length;
    var i = 0;
    while (i < activeInstancesLength) {
      var activeInstance = activeInstances[i];
      if (!activeInstance.paused) {
        activeInstance.tick(t);
        i++;
      } else {
        activeInstances.splice(i, 1);
        activeInstancesLength--;
      }
    }
    raf = i > 0 ? requestAnimationFrame(step) : undefined;
  }

  function handleVisibilityChange() {
    if (!anime.suspendWhenDocumentHidden) { return; }

    if (isDocumentHidden()) {
      // suspend ticks
      raf = cancelAnimationFrame(raf);
    } else { // is back to active tab
      // first adjust animations to consider the time that ticks were suspended
      activeInstances.forEach(
        function (instance) { return instance ._onDocumentVisibility(); }
      );
      engine();
    }
  }
  if (typeof document !== 'undefined') {
    document.addEventListener('visibilitychange', handleVisibilityChange);
  }

  return play;
})();

function isDocumentHidden() {
  return !!document && document.hidden;
}

// Public Instance

function anime(params) {
  if ( params === void 0 ) params = {};


  var startTime = 0, lastTime = 0, now = 0;
  var children, childrenLength = 0;
  var resolve = null;

  function makePromise(instance) {
    var promise = window.Promise && new Promise(function (_resolve) { return resolve = _resolve; });
    instance.finished = promise;
    return promise;
  }

  var instance = createNewInstance(params);
  var promise = makePromise(instance);

  function toggleInstanceDirection() {
    var direction = instance.direction;
    if (direction !== 'alternate') {
      instance.direction = direction !== 'normal' ? 'normal' : 'reverse';
    }
    instance.reversed = !instance.reversed;
    children.forEach(function (child) { return child.reversed = instance.reversed; });
  }

  function adjustTime(time) {
    return instance.reversed ? instance.duration - time : time;
  }

  function resetTime() {
    startTime = 0;
    lastTime = adjustTime(instance.currentTime) * (1 / anime.speed);
  }

  function seekChild(time, child) {
    if (child) { child.seek(time - child.timelineOffset); }
  }

  function syncInstanceChildren(time) {
    if (!instance.reversePlayback) {
      for (var i = 0; i < childrenLength; i++) { seekChild(time, children[i]); }
    } else {
      for (var i$1 = childrenLength; i$1--;) { seekChild(time, children[i$1]); }
    }
  }

  function setAnimationsProgress(insTime) {
    var i = 0;
    var animations = instance.animations;
    var animationsLength = animations.length;
    while (i < animationsLength) {
      var anim = animations[i];
      var animatable = anim.animatable;
      var tweens = anim.tweens;
      var tweenLength = tweens.length - 1;
      var tween = tweens[tweenLength];
      // Only check for keyframes if there is more than one tween
      if (tweenLength) { tween = filterArray(tweens, function (t) { return (insTime < t.end); })[0] || tween; }
      var elapsed = minMax(insTime - tween.start - tween.delay, 0, tween.duration) / tween.duration;
      var eased = isNaN(elapsed) ? 1 : tween.easing(elapsed);
      var strings = tween.to.strings;
      var round = tween.round;
      var numbers = [];
      var toNumbersLength = tween.to.numbers.length;
      var progress = (void 0);
      for (var n = 0; n < toNumbersLength; n++) {
        var value = (void 0);
        var toNumber = tween.to.numbers[n];
        var fromNumber = tween.from.numbers[n] || 0;
        if (!tween.isPath) {
          value = fromNumber + (eased * (toNumber - fromNumber));
        } else {
          value = getPathProgress(tween.value, eased * toNumber, tween.isPathTargetInsideSVG);
        }
        if (round) {
          if (!(tween.isColor && n > 2)) {
            value = Math.round(value * round) / round;
          }
        }
        numbers.push(value);
      }
      // Manual Array.reduce for better performances
      var stringsLength = strings.length;
      if (!stringsLength) {
        progress = numbers[0];
      } else {
        progress = strings[0];
        for (var s = 0; s < stringsLength; s++) {
          var a = strings[s];
          var b = strings[s + 1];
          var n$1 = numbers[s];
          if (!isNaN(n$1)) {
            if (!b) {
              progress += n$1 + ' ';
            } else {
              progress += n$1 + b;
            }
          }
        }
      }
      setProgressValue[anim.type](animatable.target, anim.property, progress, animatable.transforms);
      anim.currentValue = progress;
      i++;
    }
  }

  function setCallback(cb) {
    if (instance[cb] && !instance.passThrough) { instance[cb](instance); }
  }

  function countIteration() {
    if (instance.remaining && instance.remaining !== true) {
      instance.remaining--;
    }
  }

  function setInstanceProgress(engineTime) {
    var insDuration = instance.duration;
    var insDelay = instance.delay;
    var insEndDelay = insDuration - instance.endDelay;
    var insTime = adjustTime(engineTime);
    instance.progress = minMax((insTime / insDuration) * 100, 0, 100);
    instance.reversePlayback = insTime < instance.currentTime;
    if (children) { syncInstanceChildren(insTime); }
    if (!instance.began && instance.currentTime > 0) {
      instance.began = true;
      setCallback('begin');
    }
    if (!instance.loopBegan && instance.currentTime > 0) {
      instance.loopBegan = true;
      setCallback('loopBegin');
    }
    if (insTime <= insDelay && instance.currentTime !== 0) {
      setAnimationsProgress(0);
    }
    if ((insTime >= insEndDelay && instance.currentTime !== insDuration) || !insDuration) {
      setAnimationsProgress(insDuration);
    }
    if (insTime > insDelay && insTime < insEndDelay) {
      if (!instance.changeBegan) {
        instance.changeBegan = true;
        instance.changeCompleted = false;
        setCallback('changeBegin');
      }
      setCallback('change');
      setAnimationsProgress(insTime);
    } else {
      if (instance.changeBegan) {
        instance.changeCompleted = true;
        instance.changeBegan = false;
        setCallback('changeComplete');
      }
    }
    instance.currentTime = minMax(insTime, 0, insDuration);
    if (instance.began) { setCallback('update'); }
    if (engineTime >= insDuration) {
      lastTime = 0;
      countIteration();
      if (!instance.remaining) {
        instance.paused = true;
        if (!instance.completed) {
          instance.completed = true;
          setCallback('loopComplete');
          setCallback('complete');
          if (!instance.passThrough && 'Promise' in window) {
            resolve();
            promise = makePromise(instance);
          }
        }
      } else {
        startTime = now;
        setCallback('loopComplete');
        instance.loopBegan = false;
        if (instance.direction === 'alternate') {
          toggleInstanceDirection();
        }
      }
    }
  }

  instance.reset = function() {
    var direction = instance.direction;
    instance.passThrough = false;
    instance.currentTime = 0;
    instance.progress = 0;
    instance.paused = true;
    instance.began = false;
    instance.loopBegan = false;
    instance.changeBegan = false;
    instance.completed = false;
    instance.changeCompleted = false;
    instance.reversePlayback = false;
    instance.reversed = direction === 'reverse';
    instance.remaining = instance.loop;
    children = instance.children;
    childrenLength = children.length;
    for (var i = childrenLength; i--;) { instance.children[i].reset(); }
    if (instance.reversed && instance.loop !== true || (direction === 'alternate' && instance.loop === 1)) { instance.remaining++; }
    setAnimationsProgress(instance.reversed ? instance.duration : 0);
  };

  // internal method (for engine) to adjust animation timings before restoring engine ticks (rAF)
  instance._onDocumentVisibility = resetTime;

  // Set Value helper

  instance.set = function(targets, properties) {
    setTargetsValue(targets, properties);
    return instance;
  };

  instance.tick = function(t) {
    now = t;
    if (!startTime) { startTime = now; }
    setInstanceProgress((now + (lastTime - startTime)) * anime.speed);
  };

  instance.seek = function(time) {
    setInstanceProgress(adjustTime(time));
  };

  instance.pause = function() {
    instance.paused = true;
    resetTime();
  };

  instance.play = function() {
    if (!instance.paused) { return; }
    if (instance.completed) { instance.reset(); }
    instance.paused = false;
    activeInstances.push(instance);
    resetTime();
    engine();
  };

  instance.reverse = function() {
    toggleInstanceDirection();
    instance.completed = instance.reversed ? false : true;
    resetTime();
  };

  instance.restart = function() {
    instance.reset();
    instance.play();
  };

  instance.remove = function(targets) {
    var targetsArray = parseTargets(targets);
    removeTargetsFromInstance(targetsArray, instance);
  };

  instance.reset();

  if (instance.autoplay) { instance.play(); }

  return instance;

}

// Remove targets from animation

function removeTargetsFromAnimations(targetsArray, animations) {
  for (var a = animations.length; a--;) {
    if (arrayContains(targetsArray, animations[a].animatable.target)) {
      animations.splice(a, 1);
    }
  }
}

function removeTargetsFromInstance(targetsArray, instance) {
  var animations = instance.animations;
  var children = instance.children;
  removeTargetsFromAnimations(targetsArray, animations);
  for (var c = children.length; c--;) {
    var child = children[c];
    var childAnimations = child.animations;
    removeTargetsFromAnimations(targetsArray, childAnimations);
    if (!childAnimations.length && !child.children.length) { children.splice(c, 1); }
  }
  if (!animations.length && !children.length) { instance.pause(); }
}

function removeTargetsFromActiveInstances(targets) {
  var targetsArray = parseTargets(targets);
  for (var i = activeInstances.length; i--;) {
    var instance = activeInstances[i];
    removeTargetsFromInstance(targetsArray, instance);
  }
}

// Stagger helpers

function stagger(val, params) {
  if ( params === void 0 ) params = {};

  var direction = params.direction || 'normal';
  var easing = params.easing ? parseEasings(params.easing) : null;
  var grid = params.grid;
  var axis = params.axis;
  var fromIndex = params.from || 0;
  var fromFirst = fromIndex === 'first';
  var fromCenter = fromIndex === 'center';
  var fromLast = fromIndex === 'last';
  var isRange = is.arr(val);
  var val1 = isRange ? parseFloat(val[0]) : parseFloat(val);
  var val2 = isRange ? parseFloat(val[1]) : 0;
  var unit = getUnit(isRange ? val[1] : val) || 0;
  var start = params.start || 0 + (isRange ? val1 : 0);
  var values = [];
  var maxValue = 0;
  return function (el, i, t) {
    if (fromFirst) { fromIndex = 0; }
    if (fromCenter) { fromIndex = (t - 1) / 2; }
    if (fromLast) { fromIndex = t - 1; }
    if (!values.length) {
      for (var index = 0; index < t; index++) {
        if (!grid) {
          values.push(Math.abs(fromIndex - index));
        } else {
          var fromX = !fromCenter ? fromIndex%grid[0] : (grid[0]-1)/2;
          var fromY = !fromCenter ? Math.floor(fromIndex/grid[0]) : (grid[1]-1)/2;
          var toX = index%grid[0];
          var toY = Math.floor(index/grid[0]);
          var distanceX = fromX - toX;
          var distanceY = fromY - toY;
          var value = Math.sqrt(distanceX * distanceX + distanceY * distanceY);
          if (axis === 'x') { value = -distanceX; }
          if (axis === 'y') { value = -distanceY; }
          values.push(value);
        }
        maxValue = Math.max.apply(Math, values);
      }
      if (easing) { values = values.map(function (val) { return easing(val / maxValue) * maxValue; }); }
      if (direction === 'reverse') { values = values.map(function (val) { return axis ? (val < 0) ? val * -1 : -val : Math.abs(maxValue - val); }); }
    }
    var spacing = isRange ? (val2 - val1) / maxValue : val1;
    return start + (spacing * (Math.round(values[i] * 100) / 100)) + unit;
  }
}

// Timeline

function timeline(params) {
  if ( params === void 0 ) params = {};

  var tl = anime(params);
  tl.duration = 0;
  tl.add = function(instanceParams, timelineOffset) {
    var tlIndex = activeInstances.indexOf(tl);
    var children = tl.children;
    if (tlIndex > -1) { activeInstances.splice(tlIndex, 1); }
    function passThrough(ins) { ins.passThrough = true; }
    for (var i = 0; i < children.length; i++) { passThrough(children[i]); }
    var insParams = mergeObjects(instanceParams, replaceObjectProps(defaultTweenSettings, params));
    insParams.targets = insParams.targets || params.targets;
    var tlDuration = tl.duration;
    insParams.autoplay = false;
    insParams.direction = tl.direction;
    insParams.timelineOffset = is.und(timelineOffset) ? tlDuration : getRelativeValue(timelineOffset, tlDuration);
    passThrough(tl);
    tl.seek(insParams.timelineOffset);
    var ins = anime(insParams);
    passThrough(ins);
    children.push(ins);
    var timings = getInstanceTimings(children, params);
    tl.delay = timings.delay;
    tl.endDelay = timings.endDelay;
    tl.duration = timings.duration;
    tl.seek(0);
    tl.reset();
    if (tl.autoplay) { tl.play(); }
    return tl;
  };
  return tl;
}

anime.version = '3.2.1';
anime.speed = 1;
// TODO:#review: naming, documentation
anime.suspendWhenDocumentHidden = true;
anime.running = activeInstances;
anime.remove = removeTargetsFromActiveInstances;
anime.get = getOriginalTargetValue;
anime.set = setTargetsValue;
anime.convertPx = convertPxToUnit;
anime.path = getPath;
anime.setDashoffset = setDashoffset;
anime.stagger = stagger;
anime.timeline = timeline;
anime.easing = parseEasings;
anime.penner = penner;
anime.random = function (min, max) { return Math.floor(Math.random() * (max - min + 1)) + min; };

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (anime);


/***/ }),

/***/ "./src/blocks/accordion-nested-item/index.js":
/*!***************************************************!*\
  !*** ./src/blocks/accordion-nested-item/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");














const {
  RawHTML
} = wp.element;













var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)("post-grid/accordion-nested-item", {
  apiVersion: 2,
  title: "Accordion Item",
  parent: ['post-grid/accordion-nested'],
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#fff',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      y: "6.2",
      width: "36",
      height: "4.21"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      fill: "#8db1ff",
      d: "M4,8.87a.14.14,0,0,1-.1,0L3.13,8a.12.12,0,0,1,0-.17.12.12,0,0,1,.17,0L4,8.55l.64-.75a.13.13,0,0,1,.18,0A.12.12,0,0,1,4.8,8l-.74.86A.12.12,0,0,1,4,8.87Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#8db1ff",
      x: "6.07",
      y: "7.76",
      width: "17.44",
      height: "1.11"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#8db1ff",
      y: "16.16",
      width: "36",
      height: "8.66"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#8db1ff",
      y: "11.18",
      width: "36",
      height: "4.21"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      fill: "#1d4ed8",
      d: "M4,12.73a.12.12,0,0,1,.09,0l.74.86a.12.12,0,0,1,0,.17.13.13,0,0,1-.18,0L4,13.05l-.65.75a.12.12,0,0,1-.17,0,.12.12,0,0,1,0-.17l.74-.86A.14.14,0,0,1,4,12.73Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "6.07",
      y: "12.73",
      width: "17.44",
      height: "1.11"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      y: "25.58",
      width: "36",
      height: "4.21"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      fill: "#8db1ff",
      d: "M4,28.24a.13.13,0,0,1-.1,0l-.74-.86a.14.14,0,0,1,0-.18.12.12,0,0,1,.17,0l.65.75.64-.75a.12.12,0,1,1,.19.16l-.74.86A.11.11,0,0,1,4,28.24Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#8db1ff",
      x: "6.07",
      y: "27.13",
      width: "17.44",
      height: "1.11"
    }))
  },
  attributes: {
    content: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: 'accordion-content'
        },
        styles: {
          backgroundColor: {
            Desktop: ''
          }
        }
      }
    },
    header: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: 'accordion-header'
        },
        styles: {
          backgroundColor: {
            Desktop: ''
          },
          display: {
            Desktop: 'flex'
          }
        }
      }
    },
    headerLabel: {
      type: 'object',
      default: {
        options: {
          text: 'Accordion Header Text',
          tag: 'div',
          class: 'accordion-header-label'
        },
        styles: {
          backgroundColor: {
            Desktop: ''
          }
        }
      }
    },
    labelCounter: {
      type: 'object',
      default: {
        options: {
          position: '',
          tag: 'div',
          class: 'accordion-header-counter'
        },
        styles: {}
      }
    },
    labelIcon: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",
          iconSrc: 'fas fa-angle-down',
          position: 'left',
          enable: false,
          class: 'accordion-icon'
        },
        styles: {}
      }
    },
    icon: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",
          iconSrc: 'fas fa-angle-down',
          position: 'left',
          class: 'accordion-icon'
        },
        styles: {}
      }
    },
    iconToggle: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",
          iconSrc: 'fas fa-angle-up',
          class: 'accordion-icon-toggle'
        },
        styles: {}
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: [],
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var header = attributes.header;
    var headerLabel = attributes.headerLabel;
    var labelCounter = attributes.labelCounter;
    var labelIcon = attributes.labelIcon;
    var content = attributes.content;
    var icon = attributes.icon;
    var iconToggle = attributes.iconToggle;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY; //const [breakPointX, setBreakPointX] = useState(myStore.getBreakPoint());

    var breakPointX = myStore.getBreakPoint();
    const [isLoading, setisLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [toggled, setToggled] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const contentSelector = blockClass + '-accordion-content';
    const headerSelector = blockClass + '-accordion-header';
    const headerLabelSelector = blockClass + '-accordion-header-label';
    const labelIconSelector = blockClass + '-accordion-header-label-icon';
    const labelCounterSelector = blockClass + '-accordion-label-counter';
    const iconSelector = blockClass + '-accordion-icon';
    const iconToggleSelector = blockClass + '-accordion-icon-toggle';
    let isProFeature = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_7__.applyFilters)('isProFeature', true);
    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    const [iconToggleHtml, seticonToggleHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    const [labelIconHtml, setlabelIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      console.log(icon);
      var iconSrc = icon.options.iconSrc;
      var iconHtml = `<span class="accordion-icon ${iconSrc}"></span>`;
      setIconHtml(iconHtml);
    }, [icon, icon.options.iconSrc]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      var iconSrc = iconToggle.options.iconSrc;
      var iconHtml = `<span class="accordion-icon-toggle ${iconSrc}"></span>`;
      seticonToggleHtml(iconHtml);
    }, [iconToggle, iconToggle.options.iconSrc]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      var iconSrc = labelIcon.options.iconSrc;
      var iconHtml = `<span class="accordion-icon-toggle ${iconSrc}"></span>`;
      setlabelIconHtml(iconHtml);
    }, [labelIcon, labelIcon.options.iconSrc]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]); // var breakPointList = [{ label: 'Select..', icon: '', value: '' }];
    // for (var x in breakPoints) {
    //   var item = breakPoints[x];
    //   breakPointList.push({ label: item.name, icon: item.icon, value: item.id })
    // }

    function onChangeStyleHeader(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, header);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        header: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleHeader(sudoScource, key) {
      var object = myStore.deletePropertyDeep(header, [sudoScource, key, breakPointX]);
      setAttributes({
        header: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleHeader(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, header);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        header: object
      });
    }

    function onChangeStyleHeaderLabel(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, headerLabel);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        headerLabel: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerLabelSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleHeaderLabel(sudoScource, key) {
      var object = myStore.deletePropertyDeep(headerLabel, [sudoScource, key, breakPointX]);
      setAttributes({
        headerLabel: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerLabelSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleHeaderLabel(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, headerLabel);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        headerLabel: object
      });
    }

    function onPickCssLibraryHeaderLabel(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        headerLabel[sudoScource] = sudoScourceArgs;
      });
      var headerLabelX = Object.assign({}, headerLabel);
      setAttributes({
        headerLabel: headerLabelX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, headerLabelSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onChangeStyleLabelCounter(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, labelCounter);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        labelCounter: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelCounterSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleLabelCounter(sudoScource, key) {
      var object = myStore.deletePropertyDeep(labelCounter, [sudoScource, key, breakPointX]);
      setAttributes({
        labelCounter: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelCounterSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleLabelCounter(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, labelCounter);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        labelCounter: object
      });
    }

    function onPickCssLibraryLabelCounter(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        labelCounter[sudoScource] = sudoScourceArgs;
      });
      var labelCounterX = Object.assign({}, labelCounter);
      setAttributes({
        labelCounter: labelCounterX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, labelCounterSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onChangeStyleContent(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, content);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        content: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleContent(sudoScource, key) {
      var object = myStore.deletePropertyDeep(content, [sudoScource, key, breakPointX]);
      setAttributes({
        content: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleContent(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, content);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        content: object
      });
    }

    function onChangeStyleIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(icon, [sudoScource, key, breakPointX]);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        icon: object
      });
    }

    function onChangeStyleIconToggle(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, iconToggle);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        iconToggle: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconToggleSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleIconToggle(sudoScource, key) {
      var object = myStore.deletePropertyDeep(iconToggle, [sudoScource, key, breakPointX]);
      setAttributes({
        iconToggle: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconToggleSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleIconToggle(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, iconToggle);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        iconToggle: object
      });
    }

    function onPickCssLibraryIconToggle(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        iconToggle[sudoScource] = sudoScourceArgs;
      });
      var iconToggleX = Object.assign({}, iconToggle);
      setAttributes({
        iconToggle: iconToggleX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, iconToggleSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onPickCssLibraryHeader(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        header[sudoScource] = sudoScourceArgs;
      });
      var headerX = Object.assign({}, header);
      setAttributes({
        header: headerX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    const setActiveTab = uid => {
      //setAttributes({ activeTab: uid });
      //const parentBlock = select('core/block-editor').getBlock(clientId);
      const parentClientId = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.select)('core/block-editor').getBlockHierarchyRootClientId(clientId);
      wp.data.dispatch('core/block-editor').selectBlock(parentClientId); //wp.data.dispatch( 'core/edit-post' ).openGeneralSidebar( 'edit-post/block' )
      // parentBlock.innerBlocks.forEach((innerBlock) => {
      //   dispatch('core/block-editor').updateBlockAttributes(
      //     innerBlock.clientId,
      //     {
      //       activeTab: uid,
      //     }
      //   );
      // });
    };

    function onPickCssLibraryContent(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        content[sudoScource] = sudoScourceArgs;
      });
      var contentX = Object.assign({}, content);
      setAttributes({
        content: contentX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onPickCssLibraryIcon(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        icon[sudoScource] = sudoScourceArgs;
      });
      var iconX = Object.assign({}, icon);
      setAttributes({
        icon: iconX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.useBlockProps)();
    var allowedExtraBlocks = [];
    wp.blocks.getBlockTypes().forEach(function (blockType) {
      if (blockType.name.startsWith('post-grid/accordion-nested')) {
        if (!isProFeature) {
          allowedExtraBlocks.push(blockType.name);
        }
      } else {
        allowedExtraBlocks.push(blockType.name);
      }
    });
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Header",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: header.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...header.options,
          tag: newVal
        };
        setAttributes({
          header: { ...header,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: header,
      onChange: onChangeStyleHeader,
      onAdd: onAddStyleHeader,
      onRemove: onRemoveStyleHeader
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_21__["default"], {
      blockId: blockId,
      obj: header,
      onChange: onPickCssLibraryHeader
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Header Label",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: headerLabel.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }, {
        label: 'a',
        value: 'a'
      }],
      onChange: newVal => {
        var options = { ...headerLabel.options,
          tag: newVal
        };
        setAttributes({
          headerLabel: { ...headerLabel,
            options: options
          }
        });
      }
    })), headerLabel.options.tag == 'a' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Custom Slug"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
      className: "mr-2",
      value: headerLabel.options.slug == undefined ? '' : headerLabel.options.slug,
      onChange: newVal => {
        var options = { ...headerLabel.options,
          slug: newVal
        };
        setAttributes({
          headerLabel: { ...headerLabel,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.ToggleControl, {
      label: "Enable Label Icon?",
      help: labelIcon.options.enable ? 'Label Icon Enabled' : 'Label Icon Disabled.',
      checked: labelIcon.options.enable ? true : false,
      onChange: e => {
        var options = { ...labelIcon.options,
          enable: labelIcon.options.enable ? false : true
        };
        setAttributes({
          labelIcon: { ...labelIcon,
            options: options
          }
        });
      }
    }), labelIcon.options.enable && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_20__["default"], {
      library: labelIcon.options.library,
      srcType: labelIcon.options.srcType,
      iconSrc: labelIcon.options.iconSrc,
      onChange: arg => {
        var options = { ...labelIcon.options,
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          labelIcon: { ...labelIcon,
            options: options
          }
        });
        var childBlocks = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.select)('core/block-editor').getBlocksByClientId(clientId)[0].innerBlocks;
        childBlocks.map(childBlock => {
          var childClientId = childBlock.clientId;
          var childAttributes = childBlock.attributes;
          childAttributes.labelIcon.options.srcType = arg.srcType;
          childAttributes.labelIcon.options.library = arg.library;
          childAttributes.labelIcon.options.iconSrc = arg.iconSrc;
          (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.dispatch)('core/block-editor').updateBlockAttributes(childClientId, childAttributes);
          wp.data.dispatch('core/block-editor').selectBlock(childClientId);
        });
        wp.data.dispatch('core/block-editor').selectBlock(clientId);
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: headerLabel,
      onChange: onChangeStyleHeaderLabel,
      onAdd: onAddStyleHeaderLabel,
      onRemove: onRemoveStyleHeaderLabel
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_21__["default"], {
      blockId: blockId,
      obj: headerLabel,
      onChange: onPickCssLibraryHeaderLabel
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Label Counter",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.ToggleControl, {
      label: "Enable Header Counter?",
      help: labelCounter.options.enable ? 'Header Counter Enabled' : 'Header Counter Disabled.',
      checked: labelCounter.options.enable ? true : false,
      onChange: e => {
        var options = { ...labelCounter.options,
          enable: labelCounter.options.enable ? false : true
        };
        setAttributes({
          labelCounter: { ...labelCounter,
            options: options
          }
        });
        var childBlocks = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.select)('core/block-editor').getBlocksByClientId(clientId)[0].innerBlocks;
        childBlocks.map(childBlock => {
          var childClientId = childBlock.clientId;
          var childAttributes = childBlock.attributes;
          childAttributes.labelCounter.options.enable = labelCounter.options.enable ? true : false;
          (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.dispatch)('core/block-editor').updateBlockAttributes(childClientId, childAttributes);
          wp.data.dispatch('core/block-editor').selectBlock(childClientId);
        });
        wp.data.dispatch('core/block-editor').selectBlock(clientId);
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Counter postion"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: labelCounter.options.position,
      options: [{
        label: 'Choose Position',
        value: ''
      }, {
        label: 'Left',
        value: 'left'
      }, {
        label: 'Right',
        value: 'right'
      }],
      onChange: newVal => {
        var options = { ...labelCounter.options,
          position: newVal
        };
        setAttributes({
          labelCounter: { ...labelCounter,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: labelCounter.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...labelCounter.options,
          tag: newVal
        };
        setAttributes({
          labelCounter: { ...labelCounter,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: labelCounter,
      onChange: onChangeStyleLabelCounter,
      onAdd: onAddStyleLabelCounter,
      onRemove: onRemoveStyleLabelCounter
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_21__["default"], {
      blockId: blockId,
      obj: labelCounter,
      onChange: onPickCssLibraryLabelCounter
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Content",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: content.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...content.options,
          tag: newVal
        };
        setAttributes({
          content: { ...content,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: content,
      onChange: onChangeStyleContent,
      onAdd: onAddStyleContent,
      onRemove: onRemoveStyleContent
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_21__["default"], {
      blockId: blockId,
      obj: content,
      onChange: onPickCssLibraryContent
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_20__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: arg => {
        var options = { ...icon.options,
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Toggled Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_20__["default"], {
      library: iconToggle.options.library,
      srcType: iconToggle.options.srcType,
      iconSrc: iconToggle.options.iconSrc,
      onChange: arg => {
        var options = { ...iconToggle.options,
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          iconToggle: { ...iconToggle,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Icon postion"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: 'Choose Position',
        value: ''
      }, {
        label: 'Left',
        value: 'left'
      }, {
        label: 'Right',
        value: 'right'
      }],
      onChange: newVal => {
        var options = { ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_21__["default"], {
      blockId: blockId,
      obj: icon,
      onChange: onPickCssLibraryIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_14__["default"], {
      utm: {
        utm_source: 'BlockText',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `${blockId}-accordion-header accordion-header ${toggled ? 'accordion-header-active' : ''}`,
      onClick: ev => {
        setToggled(!toggled);
      }
    }, labelCounter.options.position == 'left' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: `${blockId}-accordion-label-counter accordion-label-counter`
    }, attributes.count), icon.options.position == 'left' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, !toggled && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: `${blockId}-accordion-icon accordion-icon}`,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), toggled && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: `${blockId}-accordion-icon-toggle accordion-icon-toggle}`,
      dangerouslySetInnerHTML: {
        __html: iconToggleHtml
      }
    })), labelIcon.options.enable && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: `${blockId}-accordion-header-label-icon accordion-header-label-icon}`,
      dangerouslySetInnerHTML: {
        __html: labelIconHtml
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.RichText, {
      className: `${blockId}-accordion-header-label accordion-header-label`,
      value: headerLabel.options.text,
      allowedFormats: ['core/bold', 'core/italic', 'core/link'],
      onChange: newVal => {
        var options = { ...headerLabel.options,
          text: newVal
        };
        setAttributes({
          headerLabel: { ...headerLabel,
            options: options
          }
        });
      },
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Start Writing...')
    }), icon.options.position == 'right' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, !toggled && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: `${blockId}-accordion-icon accordion-icon}`,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), toggled && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: `${blockId}-accordion-icon-toggle accordion-icon-toggle}`,
      dangerouslySetInnerHTML: {
        __html: iconToggleHtml
      }
    })), labelCounter.options.position == 'right' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: `${blockId}-accordion-label-counter accordion-label-counter`
    }, attributes.count)), toggled && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `${blockId}-accordion-content accordion-content`
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.InnerBlocks, {
      allowedBlocks: allowedExtraBlocks,
      renderAppender: () => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.InnerBlocks.ButtonBlockAppender, null)
    }))));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    const blockProps = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.useBlockProps.save({});
    const {
      children,
      ...innerBlocksProps
    } = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.useInnerBlocksProps.save(blockProps);
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, children);
  }
});

/***/ }),

/***/ "./src/blocks/accordion-nested/index.js":
/*!**********************************************!*\
  !*** ./src/blocks/accordion-nested/index.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_divider__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/divider */ "./src/components/divider/index.js");
/* harmony import */ var _variations__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./variations */ "./src/blocks/accordion-nested/variations.js");

















const {
  RawHTML
} = wp.element;














var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)("post-grid/accordion-nested", {
  apiVersion: 2,
  title: "Accordion",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#fff',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      y: "6.2",
      width: "36",
      height: "4.21"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      fill: "#8db1ff",
      d: "M4,8.87a.14.14,0,0,1-.1,0L3.13,8a.12.12,0,0,1,0-.17.12.12,0,0,1,.17,0L4,8.55l.64-.75a.13.13,0,0,1,.18,0A.12.12,0,0,1,4.8,8l-.74.86A.12.12,0,0,1,4,8.87Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#8db1ff",
      x: "6.07",
      y: "7.76",
      width: "17.44",
      height: "1.11"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#8db1ff",
      y: "16.16",
      width: "36",
      height: "8.66"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#8db1ff",
      y: "11.18",
      width: "36",
      height: "4.21"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      fill: "#1d4ed8",
      d: "M4,12.73a.12.12,0,0,1,.09,0l.74.86a.12.12,0,0,1,0,.17.13.13,0,0,1-.18,0L4,13.05l-.65.75a.12.12,0,0,1-.17,0,.12.12,0,0,1,0-.17l.74-.86A.14.14,0,0,1,4,12.73Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "6.07",
      y: "12.73",
      width: "17.44",
      height: "1.11"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      y: "25.58",
      width: "36",
      height: "4.21"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      fill: "#8db1ff",
      d: "M4,28.24a.13.13,0,0,1-.1,0l-.74-.86a.14.14,0,0,1,0-.18.12.12,0,0,1,.17,0l.65.75.64-.75a.12.12,0,1,1,.19.16l-.74.86A.11.11,0,0,1,4,28.24Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#8db1ff",
      x: "6.07",
      y: "27.13",
      width: "17.44",
      height: "1.11"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          content: '',
          tag: 'div',
          class: ''
        },
        styles: {}
      }
    },
    searchWrap: {
      type: 'object',
      default: {
        options: {
          enable: false,
          contentSrc: ['content', 'label'],
          tag: 'div',
          class: 'accordion-search-wrap'
        },
        styles: {}
      }
    },
    searchInput: {
      type: 'object',
      default: {
        options: {
          tag: 'input',
          type: 'text',
          value: '',
          placeholder: 'Search here...',
          class: 'accordion-search-input'
        },
        styles: {}
      }
    },
    content: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: 'accordion-content'
        },
        styles: {}
      }
    },
    header: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: 'accordion-header'
        },
        styles: {}
      }
    },
    headerActive: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: 'accordion-header'
        },
        styles: {}
      }
    },
    headerLabel: {
      type: 'object',
      default: {
        options: {
          text: 'Accordion Header',
          tag: 'div',
          class: 'accordion-header-label'
        },
        styles: {}
      }
    },
    labelCounter: {
      type: 'object',
      default: {
        options: {
          enable: false,
          position: 'left',
          tag: 'div',
          class: 'label-counter'
        },
        styles: {}
      }
    },
    labelIcon: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'fas fa-angle-down',
          position: 'left',

          /*left, right, before, after */
          class: 'accordion-icon'
        },
        styles: {}
      }
    },
    icon: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'fas fa-angle-down',
          position: 'left',

          /*left, right, before, after */
          class: 'accordion-icon'
        },
        styles: {}
      }
    },
    iconToggle: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'fas fa-angle-up',
          class: 'accordion-icon-toggle'
        },
        styles: {}
      }
    },
    schema: {
      type: 'object',
      default: {
        options: {
          enable: true
        }
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  providesContext: {
    'post-grid/accordion-nested/schema': 'schema'
  },
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var wrapper = attributes.wrapper;
    var header = attributes.header;
    var headerActive = attributes.headerActive;
    var headerLabel = attributes.headerLabel;
    var labelIcon = attributes.labelIcon;
    var labelCounter = attributes.labelCounter;
    var searchWrap = attributes.searchWrap;
    var searchInput = attributes.searchInput;
    var schema = attributes.schema;
    var content = attributes.content;
    var icon = attributes.icon;
    var iconToggle = attributes.iconToggle;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    let isProFeature = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_8__.applyFilters)('isProFeature', true); //const [breakPointX, setBreakPointX] = useState(myStore.getBreakPoint());

    var breakPointX = myStore.getBreakPoint(); // Wrapper CSS Class Selectors

    var wrapperSelector = blockClass;
    const contentSelector = blockClass + ' .accordion-content';
    const headerSelector = blockClass + ' .accordion-header';
    const headerActiveSelector = blockClass + ' .accordion-header-active';
    const headerLabelSelector = blockClass + ' .accordion-header-label';
    const labelIconSelector = blockClass + ' .accordion-label-icon';
    const labelCounterSelector = blockClass + ' .accordion-label-counter';
    const searchWrapSelector = blockClass + '-accordion-search-wrap';
    const searchInputSelector = blockClass + '-accordion-search-input';
    const iconSelector = blockClass + ' .accordion-icon';
    const iconToggleSelector = blockClass + ' .accordion-icon-toggle';
    const {
      replaceInnerBlocks
    } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.store);
    const hasInnerBlocks = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.store).getBlocks(clientId).length > 0, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      var childBlocks = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.select)('core/block-editor').getBlocksByClientId(clientId)[0].innerBlocks;
      childBlocks.map(childBlock => {
        var childClientId = childBlock.clientId;
        var childAttributes = childBlock.attributes;
        childAttributes.icon.options.position = icon.options.position;
        (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.dispatch)('core/block-editor').updateBlockAttributes(childClientId, childAttributes);
        wp.data.dispatch('core/block-editor').selectBlock(childClientId);
      });
      wp.data.dispatch('core/block-editor').selectBlock(clientId);
    }, [icon.options.position]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      var childBlocks = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.select)('core/block-editor').getBlocksByClientId(clientId)[0].innerBlocks;
      childBlocks.map(childBlock => {
        var childClientId = childBlock.clientId;
        var childAttributes = childBlock.attributes;
        childAttributes.labelCounter.options.position = labelCounter.options.position;
        (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.dispatch)('core/block-editor').updateBlockAttributes(childClientId, childAttributes);
        wp.data.dispatch('core/block-editor').selectBlock(childClientId);
      });
      wp.data.dispatch('core/block-editor').selectBlock(clientId);
    }, [labelCounter.options.position]); // var breakPointList = [{ label: 'Select..', icon: '', value: '' }];
    // for (var x in breakPoints) {
    //   var item = breakPoints[x];
    //   breakPointList.push({ label: item.name, icon: item.icon, value: item.id })
    // }

    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStyleHeader(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, header);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        header: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleHeader(sudoScource, key) {
      var object = myStore.deletePropertyDeep(header, [sudoScource, key, breakPointX]);
      setAttributes({
        header: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleHeader(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, header);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        header: object
      });
    }

    function onPickCssLibraryHeader(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        header[sudoScource] = sudoScourceArgs;
      });
      var headerX = Object.assign({}, header);
      setAttributes({
        header: headerX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    } // #########


    function onChangeStyleHeaderActive(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, headerActive);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        headerActive: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerActiveSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleHeaderActive(sudoScource, key) {
      var object = myStore.deletePropertyDeep(headerActive, [sudoScource, key, breakPointX]);
      setAttributes({
        headerActive: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerActiveSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleHeaderActive(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, headerActive);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        headerActive: object
      });
    }

    function onPickCssLibraryHeaderActive(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        headerActive[sudoScource] = sudoScourceArgs;
      });
      var headerActiveX = Object.assign({}, headerActive);
      setAttributes({
        headerActive: headerActiveX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, headerActiveSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    } //########


    function onChangeStyleHeaderLabel(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, headerLabel);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        headerLabel: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerLabelSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleHeaderLabel(sudoScource, key) {
      var object = myStore.deletePropertyDeep(headerLabel, [sudoScource, key, breakPointX]);
      setAttributes({
        headerLabel: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerLabelSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleHeaderLabel(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, headerLabel);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        headerLabel: object
      });
    }

    function onPickCssLibraryHeaderLabel(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        headerLabel[sudoScource] = sudoScourceArgs;
      });
      var headerLabelX = Object.assign({}, headerLabel);
      setAttributes({
        headerLabel: headerLabelX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, headerLabelSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onChangeStyleLabelCounter(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, labelCounter);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        labelCounter: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelCounterSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleLabelCounter(sudoScource, key) {
      var object = myStore.deletePropertyDeep(labelCounter, [sudoScource, key, breakPointX]);
      setAttributes({
        labelCounter: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelCounterSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleLabelCounter(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, labelCounter);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        labelCounter: object
      });
    }

    function onPickCssLibraryLabelCounter(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        labelCounter[sudoScource] = sudoScourceArgs;
      });
      var labelCounterX = Object.assign({}, labelCounter);
      setAttributes({
        labelCounter: labelCounterX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, labelCounterSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onChangeStyleContent(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, content);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        content: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleContent(sudoScource, key) {
      var object = myStore.deletePropertyDeep(content, [sudoScource, key, breakPointX]);
      setAttributes({
        content: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleContent(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, content);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        content: object
      });
    }

    function onChangeStyleIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(icon, [sudoScource, key, breakPointX]);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        icon: object
      });
    }

    function onPickCssLibraryIcon(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        icon[sudoScource] = sudoScourceArgs;
      });
      var iconX = Object.assign({}, icon);
      setAttributes({
        icon: iconX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onChangeStyleIconToggle(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, iconToggle);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        iconToggle: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconToggleSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleIconToggle(sudoScource, key) {
      var object = myStore.deletePropertyDeep(iconToggle, [sudoScource, key, breakPointX]);
      setAttributes({
        iconToggle: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconToggleSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleIconToggle(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, iconToggle);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        iconToggle: object
      });
    }

    function onPickCssLibraryIconToggle(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        iconToggle[sudoScource] = sudoScourceArgs;
      });
      var iconToggleX = Object.assign({}, iconToggle);
      setAttributes({
        iconToggle: iconToggleX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, iconToggleSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onPickCssLibraryContent(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        content[sudoScource] = sudoScourceArgs;
      });
      var contentX = Object.assign({}, content);
      setAttributes({
        content: contentX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onChangeStyleSearchWrap(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, searchWrap);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        searchWrap: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, searchWrapSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleSearchWrap(sudoScource, key) {
      var object = myStore.deletePropertyDeep(searchWrap, [sudoScource, key, breakPointX]);
      setAttributes({
        searchWrap: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, searchWrapSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleSearchWrap(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, searchWrap);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        searchWrap: object
      });
    }

    function onChangeStyleSearchInput(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, searchInput);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        searchInput: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, searchInputSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleSearchInput(sudoScource, key) {
      var object = myStore.deletePropertyDeep(searchInput, [sudoScource, key, breakPointX]);
      setAttributes({
        searchInput: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, searchInputSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleSearchInput(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, searchInput);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        searchInput: object
      });
    }

    const ALLOWED_BLOCKS = ['post-grid/accordion-nested-item'];
    const MY_TEMPLATE = [['post-grid/accordion-nested-item', {}], ['post-grid/accordion-nested-item', {}]];
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps)({
      className: ` ${blockId} pg-accordion-nested`
    });
    const innerBlocksProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useInnerBlocksProps)(blockProps, {
      allowedBlocks: ALLOWED_BLOCKS,
      // __experimentalDirectInsert: true,
      template: MY_TEMPLATE //templateInsertUpdatesSelection: true,

    });
    var childBlocks = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.select)('core/block-editor').getBlocksByClientId(clientId)[0].innerBlocks;
    var count = 0;
    childBlocks.forEach(function (childBlock) {
      count++;
      var childClientId = childBlock.clientId;
      var childAttributes = childBlock.attributes;
      childAttributes.count = count;
      (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.dispatch)('core/block-editor').updateBlockAttributes(childClientId, childAttributes);
    });
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: { ...wrapper,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Header",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: header.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...header.options,
          tag: newVal
        };
        setAttributes({
          header: { ...header,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: header,
      onChange: onChangeStyleHeader,
      onAdd: onAddStyleHeader,
      onRemove: onRemoveStyleHeader
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_20__["default"], {
      blockId: blockId,
      obj: header,
      onChange: onPickCssLibraryHeader
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Header Active",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: headerActive,
      onChange: onChangeStyleHeaderActive,
      onAdd: onAddStyleHeaderActive,
      onRemove: onRemoveStyleHeaderActive
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_20__["default"], {
      blockId: blockId,
      obj: headerActive,
      onChange: onPickCssLibraryHeaderActive
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Header Label",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: headerLabel.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }, {
        label: 'a',
        value: 'a'
      }],
      onChange: newVal => {
        var options = { ...headerLabel.options,
          tag: newVal
        };
        setAttributes({
          headerLabel: { ...headerLabel,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.ToggleControl, {
      label: "Enable Label Icon?",
      help: labelIcon.options.enable ? 'Label Icon Enabled' : 'Label Icon Disabled.',
      checked: labelIcon.options.enable ? true : false,
      onChange: e => {
        var options = { ...labelIcon.options,
          enable: labelIcon.options.enable ? false : true
        };
        setAttributes({
          labelIcon: { ...labelIcon,
            options: options
          }
        });
      }
    }), labelIcon.options.enable && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_21__["default"], {
      library: labelIcon.options.library,
      srcType: labelIcon.options.srcType,
      iconSrc: labelIcon.options.iconSrc,
      onChange: arg => {
        var options = { ...labelIcon.options,
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          labelIcon: { ...labelIcon,
            options: options
          }
        });
        var childBlocks = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.select)('core/block-editor').getBlocksByClientId(clientId)[0].innerBlocks;
        childBlocks.map(childBlock => {
          var childClientId = childBlock.clientId;
          console.log('childClientId', childClientId);
          var childAttributes = childBlock.attributes;
          childAttributes.labelIcon.options.srcType = arg.srcType;
          childAttributes.labelIcon.options.library = arg.library;
          childAttributes.labelIcon.options.iconSrc = arg.iconSrc;
          (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.dispatch)('core/block-editor').updateBlockAttributes(childClientId, childAttributes);
          wp.data.dispatch('core/block-editor').selectBlock(childClientId);
        });
        console.log(clientId);
        wp.data.dispatch('core/block-editor').selectBlock(clientId);
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: headerLabel,
      onChange: onChangeStyleHeaderLabel,
      onAdd: onAddStyleHeaderLabel,
      onRemove: onRemoveStyleHeaderLabel
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_20__["default"], {
      blockId: blockId,
      obj: headerLabel,
      onChange: onPickCssLibraryHeaderLabel
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Label Counter",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Counter postion"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: labelCounter.options.position,
      options: [{
        label: 'Choose Position',
        value: ''
      }, {
        label: 'Left',
        value: 'left'
      }, {
        label: 'Right',
        value: 'right'
      }],
      onChange: newVal => {
        var options = { ...labelCounter.options,
          position: newVal
        };
        setAttributes({
          labelCounter: { ...labelCounter,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: labelCounter.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...labelCounter.options,
          tag: newVal
        };
        setAttributes({
          labelCounter: { ...labelCounter,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: labelCounter,
      onChange: onChangeStyleLabelCounter,
      onAdd: onAddStyleLabelCounter,
      onRemove: onRemoveStyleLabelCounter
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_20__["default"], {
      blockId: blockId,
      obj: labelCounter,
      onChange: onPickCssLibraryLabelCounter
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Content",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: content.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...content.options,
          tag: newVal
        };
        setAttributes({
          content: { ...content,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: content,
      onChange: onChangeStyleContent,
      onAdd: onAddStyleContent,
      onRemove: onRemoveStyleContent
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_20__["default"], {
      blockId: blockId,
      obj: content,
      onChange: onPickCssLibraryContent
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_21__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: arg => {
        var options = { ...icon.options,
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
        var childBlocks = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.select)('core/block-editor').getBlocksByClientId(clientId)[0].innerBlocks;
        childBlocks.map(childBlock => {
          setTimeout(() => {
            var childClientId = childBlock.clientId;
            var childAttributes = childBlock.attributes;
            childAttributes.icon.options.srcType = arg.srcType;
            childAttributes.icon.options.library = arg.library;
            childAttributes.icon.options.iconSrc = arg.iconSrc;
            (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.dispatch)('core/block-editor').updateBlockAttributes(childClientId, childAttributes);
            wp.data.dispatch('core/block-editor').selectBlock(childClientId);
          }, 20, childBlock);
        });
        setTimeout(() => {
          wp.data.dispatch('core/block-editor').selectBlock(clientId);
          console.log('clientId', clientId);
        }, 2000);
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Toggled Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_21__["default"], {
      library: iconToggle.options.library,
      srcType: iconToggle.options.srcType,
      iconSrc: iconToggle.options.iconSrc,
      onChange: arg => {
        var options = { ...iconToggle.options,
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          iconToggle: { ...iconToggle,
            options: options
          }
        });
        var childBlocks = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.select)('core/block-editor').getBlocksByClientId(clientId)[0].innerBlocks;
        childBlocks.map(childBlock => {
          var childClientId = childBlock.clientId;
          var childAttributes = childBlock.attributes;
          childAttributes.iconToggle.options.srcType = arg.srcType;
          childAttributes.iconToggle.options.library = arg.library;
          childAttributes.iconToggle.options.iconSrc = arg.iconSrc;
          (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.dispatch)('core/block-editor').updateBlockAttributes(childClientId, childAttributes); //wp.data.dispatch('core/block-editor').selectBlock(childClientId)
        });
        wp.data.dispatch('core/block-editor').selectBlock(clientId);
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Icon postion"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: 'Choose Position',
        value: ''
      }, {
        label: 'Left',
        value: 'left'
      }, {
        label: 'Right',
        value: 'right'
      }],
      onChange: newVal => {
        var options = { ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_20__["default"], {
      blockId: blockId,
      obj: icon,
      onChange: onPickCssLibraryIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Schema",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.ToggleControl, {
      label: "Enable Schema?",
      help: schema.options.enable ? 'Schema Enabled' : 'Schema Disabled.',
      checked: schema.options.enable ? true : false,
      onChange: e => {
        var options = { ...schema.options,
          enable: schema.options.enable ? false : true
        };
        setAttributes({
          schema: { ...schema,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Search",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.ToggleControl, {
      label: "Enable Search?",
      help: searchWrap.options.enable ? 'Search Enabled' : 'Search Disabled.',
      disabled: isProFeature,
      checked: searchWrap.options.enable ? true : false,
      onChange: e => {
        var options = { ...searchWrap.options,
          enable: searchWrap.options.enable ? false : true
        };
        setAttributes({
          searchWrap: { ...searchWrap,
            options: options
          }
        });
      }
    }), isProFeature && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "bg-amber-400 mx-2 rounded-sm px-3  text-white hover:text-white"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      target: "_blank",
      href: 'https://pickplugins.com/post-grid/?utm_source=search&utm_term=blockaccordion&utm_campaign=pluginPostGrid&utm_medium=search'
    }, "Pro"))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Search Wrap",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: searchWrap,
      onChange: onChangeStyleSearchWrap,
      onAdd: onAddStyleSearchWrap,
      onRemove: onRemoveStyleSearchWrap
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Search Input",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: searchInput,
      onChange: onChangeStyleSearchInput,
      onAdd: onAddStyleSearchInput,
      onRemove: onRemoveStyleSearchInput
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Text "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, wrapperSelector, '{}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_14__["default"], {
      utm: {
        utm_source: 'BlockText',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, !hasInnerBlocks && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", innerBlocksProps, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "border p-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex justify-between mb-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "text-xl rounded-sm"
    }, "Click to pick a variation"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "bg-orange-400 hover:bg-orange-300 px-4 py-1 text-white cursor-pointer",
      onClick: ev => {
        replaceInnerBlocks(clientId, (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.createBlocksFromInnerBlocksTemplate)([['post-grid/accordion-nested-item', {}]]), true);
      }
    }, "Skip")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: ""
    }, _variations__WEBPACK_IMPORTED_MODULE_23__["default"].map(variation => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "text-center inline-block m-4 w-32 align-top p-4 bg-gray-400 cursor-pointer hover:bg-gray-500 relative",
        onClick: ev => {
          if (variation.isPro) {
            alert('Sorry this variation only vailable in pro version');
            return false;
          }

          var atts = variation.atts;
          var wrapper = { ...atts.wrapper
          };
          var searchWrap = { ...atts.searchWrap
          };
          var searchInput = { ...atts.searchInput
          };
          var content = { ...atts.content
          };
          var header = { ...atts.header
          };
          var headerLabel = { ...atts.headerLabel
          };
          var labelCounter = { ...atts.labelCounter
          };
          var labelIcon = { ...atts.labelIcon
          };
          var icon = { ...atts.icon
          };
          var iconToggle = { ...atts.iconToggle
          };
          var blockCssY = { ...atts.blockCssY
          };
          var customCss = { ...atts.customCss
          };
          var blockCssObj = {};
          blockCssObj[wrapperSelector] = wrapper;
          blockCssObj[contentSelector] = content;
          blockCssObj[headerSelector] = header;
          blockCssObj[headerLabelSelector] = headerLabel;
          blockCssObj[labelIconSelector] = labelIcon;
          blockCssObj[labelCounterSelector] = labelCounter;
          blockCssObj[searchWrapSelector] = searchWrap;
          blockCssObj[searchInputSelector] = searchInput;
          blockCssObj[iconSelector] = icon;
          blockCssObj[iconToggleSelector] = iconToggle;
          setAttributes({
            wrapper: wrapper,
            searchWrap: searchWrap,
            searchInput: searchInput,
            content: content,
            header: header,
            headerLabel: headerLabel,
            labelCounter: labelCounter,
            labelIcon: labelIcon,
            icon: icon,
            iconToggle: iconToggle,
            customCss: customCss
          });
          var blockCssRules = myStore.getBlockCssRules(blockCssObj);
          var items = { ...blockCssY.items,
            ...blockCssRules
          };
          setAttributes({
            blockCssY: {
              items: items
            }
          });
          replaceInnerBlocks(clientId, (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.createBlocksFromInnerBlocksTemplate)(variation.innerBlocks), true);
        }
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, variation.icon), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, variation.title), variation.isPro && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "bg-amber-400 rounded-sm text-sm inline-block  bg-opacity-90 text-white hover:text-white absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        className: "block px-3",
        href: 'https://pickplugins.com/post-grid/?utm_source=dropdownComponent&utm_term=proFeature&utm_campaign=pluginPostGrid&utm_medium=' + x.label
      }, "Pro")));
    })))), hasInnerBlocks && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", innerBlocksProps, searchWrap.options.enable && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `${blockId}-accordion-search-wrap`
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
      className: `${blockId}-accordion-search-input my-4`,
      type: searchInput.options.type,
      placeholder: searchInput.options.placeholder,
      value: searchInput.options.value
    })), innerBlocksProps.children)));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    var attributes = props.attributes;
    var blockId = attributes.blockId;
    const blockProps = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps.save({
      className: ` ${blockId} pg-accordion-nested`
    }); //const innerBlocksProps = useInnerBlocksProps.save(blockProps);

    const {
      children,
      ...innerBlocksProps
    } = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useInnerBlocksProps.save(blockProps);
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, children); //return null;
  }
});

/***/ }),

/***/ "./src/blocks/accordion-nested/variations.js":
/*!***************************************************!*\
  !*** ./src/blocks/accordion-nested/variations.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

/**
 * Template option choices for predefined columns layouts.
 */

const variations = [{
  name: 'preset-1',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-1'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-1'),
  isPro: false,
  atts: {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    searchWrap: {
      options: {
        enable: false,
        contentSrc: ['content', 'label'],
        tag: 'div',
        class: 'accordion-search-wrap'
      },
      styles: {}
    },
    searchInput: {
      options: {
        tag: 'input',
        type: 'text',
        value: '',
        placeholder: 'Search here...',
        class: 'accordion-search-input'
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "start"
        },
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {}
    },
    labelCounter: {
      options: {
        enable: false,
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {}
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        class: 'accordion-icon'
      },
      styles: {}
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: "",
    customCss: "",
    blockCssY: {
      items: {}
    }
  },
  innerBlocks: [['post-grid/accordion-nested-item', {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "start"
        },
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {}
    },
    labelCounter: {
      options: {
        enable: false,
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {}
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        class: 'accordion-icon'
      },
      styles: {}
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: {},
    customCss: {},
    blockCssY: {
      items: {}
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 360 236"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    width: "360",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#ffffff",
    d: "M27.66,26.62a1.22,1.22,0,0,1-.93-.43l-7.39-8.63A1.23,1.23,0,0,1,21.21,16l6.45,7.54L34.12,16A1.23,1.23,0,0,1,36,17.56L28.6,26.19A1.24,1.24,0,0,1,27.66,26.62Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "48.66",
    y: "15.53",
    width: "174.4",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    y: "99.56",
    width: "360",
    height: "86.66"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    y: "49.78",
    width: "360",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#3c3c3b",
    d: "M27.66,65.31a1.26,1.26,0,0,1,.94.43L36,74.37A1.23,1.23,0,1,1,34.12,76l-6.46-7.53L21.21,76a1.23,1.23,0,1,1-1.87-1.6l7.39-8.63A1.22,1.22,0,0,1,27.66,65.31Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "48.66",
    y: "65.31",
    width: "174.4",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "193.85",
    width: "360",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#ffffff",
    d: "M27.66,220.47a1.22,1.22,0,0,1-.93-.43l-7.39-8.63a1.23,1.23,0,1,1,1.87-1.6l6.45,7.53,6.46-7.53a1.23,1.23,0,1,1,1.87,1.6L28.6,220A1.24,1.24,0,0,1,27.66,220.47Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "48.66",
    y: "209.38",
    width: "174.4",
    height: "11.09"
  }))
}, {
  name: 'preset-2',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-2'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-2'),
  isPro: false,
  atts: {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    searchWrap: {
      options: {
        enable: false,
        contentSrc: ['content', 'label'],
        tag: 'div',
        class: 'accordion-search-wrap'
      },
      styles: {}
    },
    searchInput: {
      options: {
        tag: 'input',
        type: 'text',
        value: '',
        placeholder: 'Search here...',
        class: 'accordion-search-input'
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "center"
        },
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {}
    },
    labelCounter: {
      options: {
        enable: false,
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {}
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        class: 'accordion-icon'
      },
      styles: {}
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: "",
    customCss: "",
    blockCssY: {
      items: {}
    }
  },
  innerBlocks: [['post-grid/accordion-nested-item', {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "center"
        },
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {}
    },
    labelCounter: {
      options: {
        enable: false,
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {}
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        class: 'accordion-icon'
      },
      styles: {}
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: {},
    customCss: {},
    blockCssY: {
      items: {}
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 360 236"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    width: "360",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#ffffff",
    d: "M86.61,26.62a1.22,1.22,0,0,1-.93-.43l-7.4-8.63A1.23,1.23,0,0,1,80.15,16l6.46,7.54L93.07,16a1.23,1.23,0,0,1,1.87,1.6l-7.39,8.63A1.26,1.26,0,0,1,86.61,26.62Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "107.61",
    y: "15.53",
    width: "174.4",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    y: "99.56",
    width: "360",
    height: "86.66"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    y: "49.78",
    width: "360",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#3c3c3b",
    d: "M86.61,65.31a1.26,1.26,0,0,1,.94.43l7.39,8.63A1.23,1.23,0,1,1,93.07,76l-6.46-7.53L80.15,76a1.22,1.22,0,0,1-1.73.14,1.24,1.24,0,0,1-.14-1.74l7.4-8.63A1.22,1.22,0,0,1,86.61,65.31Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "107.61",
    y: "65.31",
    width: "174.4",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "193.85",
    width: "360",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#ffffff",
    d: "M86.61,220.47a1.22,1.22,0,0,1-.93-.43l-7.4-8.63a1.24,1.24,0,0,1,.14-1.74,1.22,1.22,0,0,1,1.73.14l6.46,7.53,6.46-7.53a1.23,1.23,0,1,1,1.87,1.6L87.55,220A1.26,1.26,0,0,1,86.61,220.47Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "107.61",
    y: "209.38",
    width: "174.4",
    height: "11.09"
  }))
}, {
  name: 'preset-3',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-3'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-3'),
  isPro: false,
  atts: {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    searchWrap: {
      options: {
        enable: false,
        contentSrc: ['content', 'label'],
        tag: 'div',
        class: 'accordion-search-wrap'
      },
      styles: {}
    },
    searchInput: {
      options: {
        tag: 'input',
        type: 'text',
        value: '',
        placeholder: 'Search here...',
        class: 'accordion-search-input'
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "end"
        },
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {}
    },
    labelCounter: {
      options: {
        enable: false,
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {}
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        class: 'accordion-icon'
      },
      styles: {}
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: "",
    customCss: "",
    blockCssY: {
      items: {}
    }
  },
  innerBlocks: [['post-grid/accordion-nested-item', {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "end"
        },
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {}
    },
    labelCounter: {
      options: {
        enable: false,
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {}
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        class: 'accordion-icon'
      },
      styles: {}
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: {},
    customCss: {},
    blockCssY: {
      items: {}
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 360 236"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    width: "360",
    height: "42.15",
    transform: "translate(360 42.15) rotate(-180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#ffffff",
    d: "M332.34,26.62a1.22,1.22,0,0,0,.93-.43l7.39-8.63a1.23,1.23,0,0,0-1.87-1.6l-6.45,7.54L325.88,16a1.23,1.23,0,0,0-1.87,1.6l7.39,8.63A1.24,1.24,0,0,0,332.34,26.62Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "136.94",
    y: "15.53",
    width: "174.4",
    height: "11.09",
    transform: "translate(448.27 42.15) rotate(-180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    y: "99.56",
    width: "360",
    height: "86.66",
    transform: "translate(360 285.78) rotate(-180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    y: "49.78",
    width: "360",
    height: "42.15",
    transform: "translate(360 141.71) rotate(-180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#3c3c3b",
    d: "M332.34,65.31a1.26,1.26,0,0,0-.94.43L324,74.37a1.23,1.23,0,1,0,1.87,1.6l6.46-7.53L338.79,76a1.23,1.23,0,1,0,1.87-1.6l-7.39-8.63A1.22,1.22,0,0,0,332.34,65.31Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "136.94",
    y: "65.31",
    width: "174.4",
    height: "11.09",
    transform: "translate(448.27 141.71) rotate(-180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "193.85",
    width: "360",
    height: "42.15",
    transform: "translate(360 429.85) rotate(-180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#ffffff",
    d: "M332.34,220.47a1.22,1.22,0,0,0,.93-.43l7.39-8.63a1.23,1.23,0,1,0-1.87-1.6l-6.45,7.53-6.46-7.53a1.23,1.23,0,1,0-1.87,1.6L331.4,220A1.24,1.24,0,0,0,332.34,220.47Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "136.94",
    y: "209.38",
    width: "174.4",
    height: "11.09",
    transform: "translate(448.27 429.85) rotate(-180)"
  }))
}, {
  name: 'preset-4',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-4'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-4'),
  isPro: false,
  atts: {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    searchWrap: {
      options: {
        enable: false,
        contentSrc: ['content', 'label'],
        tag: 'div',
        class: 'accordion-search-wrap'
      },
      styles: {}
    },
    searchInput: {
      options: {
        tag: 'input',
        type: 'text',
        value: '',
        placeholder: 'Search here...',
        class: 'accordion-search-input'
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "start"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "width": {
          "Desktop": "100%"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        }
      }
    },
    labelCounter: {
      options: {
        enable: false,
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {}
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        class: 'accordion-icon'
      },
      styles: {
        "fontSize": {
          "Desktop": "25px"
        },
        "display": {
          "Desktop": "inline-block"
        },
        "margin": {
          "Desktop": "0px 10px 0px 10px"
        }
      }
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: "",
    customCss: "",
    blockCssY: {
      items: {}
    }
  },
  innerBlocks: [['post-grid/accordion-nested-item', {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "start"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "width": {
          "Desktop": "100%"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        }
      }
    },
    labelCounter: {
      options: {
        enable: false,
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {}
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        class: 'accordion-icon'
      },
      styles: {
        "fontSize": {
          "Desktop": "25px"
        },
        "display": {
          "Desktop": "inline-block"
        },
        "margin": {
          "Desktop": "0px 10px 0px 10px"
        }
      }
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: {},
    customCss: {},
    blockCssY: {
      items: {}
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 360 236"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "29.73",
    width: "330.38",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "29.73",
    y: "99.56",
    width: "330.38",
    height: "86.66"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "29.73",
    y: "49.78",
    width: "330.38",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "29.73",
    y: "193.85",
    width: "330.38",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#3c3c3b",
    d: "M8.74,26.62a1.24,1.24,0,0,1-.94-.43L.41,17.56a1.21,1.21,0,0,1,.13-1.73A1.23,1.23,0,0,1,2.28,16L8.74,23.5,15.19,16a1.23,1.23,0,0,1,1.87,1.6L9.67,26.19A1.22,1.22,0,0,1,8.74,26.62Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#ffffff",
    d: "M8.74,65.31a1.24,1.24,0,0,1,.93.43l7.39,8.63A1.23,1.23,0,1,1,15.19,76L8.74,68.44,2.28,76a1.23,1.23,0,1,1-1.87-1.6L7.8,65.74A1.24,1.24,0,0,1,8.74,65.31Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#3c3c3b",
    d: "M8.74,220.47A1.24,1.24,0,0,1,7.8,220L.41,211.41a1.23,1.23,0,1,1,1.87-1.6l6.46,7.53,6.45-7.53a1.23,1.23,0,1,1,1.87,1.6L9.67,220A1.22,1.22,0,0,1,8.74,220.47Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "52.54",
    y: "15.53",
    width: "174.4",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "52.54",
    y: "65.31",
    width: "174.4",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "52.54",
    y: "209.38",
    width: "174.4",
    height: "11.09"
  }))
}, {
  name: 'preset-5',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-5'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-5'),
  isPro: false,
  atts: {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    searchWrap: {
      options: {
        enable: false,
        contentSrc: ['content', 'label'],
        tag: 'div',
        class: 'accordion-search-wrap'
      },
      styles: {}
    },
    searchInput: {
      options: {
        tag: 'input',
        type: 'text',
        value: '',
        placeholder: 'Search here...',
        class: 'accordion-search-input'
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "start"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "width": {
          "Desktop": "100%"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        }
      }
    },
    labelCounter: {
      options: {
        enable: false,
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {}
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'right',
        class: 'accordion-icon'
      },
      styles: {
        "fontSize": {
          "Desktop": "25px"
        },
        "display": {
          "Desktop": "inline-block"
        },
        "margin": {
          "Desktop": "0px 10px 0px 10px"
        }
      }
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: "",
    customCss: "",
    blockCssY: {
      items: {}
    }
  },
  innerBlocks: [['post-grid/accordion-nested-item', {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "start"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "width": {
          "Desktop": "100%"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        }
      }
    },
    labelCounter: {
      options: {
        enable: false,
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {}
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'right',
        class: 'accordion-icon'
      },
      styles: {
        "fontSize": {
          "Desktop": "25px"
        },
        "display": {
          "Desktop": "inline-block"
        },
        "margin": {
          "Desktop": "0px 10px 0px 10px"
        }
      }
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: {},
    customCss: {},
    blockCssY: {
      items: {}
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 360 236"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    width: "330.38",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    y: "99.56",
    width: "330.38",
    height: "86.66"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    y: "49.78",
    width: "330.38",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "193.85",
    width: "330.38",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#3c3c3b",
    d: "M351.38,26.62a1.24,1.24,0,0,1-.94-.43l-7.39-8.63a1.23,1.23,0,0,1,1.87-1.6l6.46,7.54L357.83,16a1.23,1.23,0,0,1,1.87,1.6l-7.39,8.63A1.22,1.22,0,0,1,351.38,26.62Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#ffffff",
    d: "M351.38,65.31a1.24,1.24,0,0,1,.93.43l7.39,8.63a1.23,1.23,0,1,1-1.87,1.6l-6.45-7.53L344.92,76a1.23,1.23,0,1,1-1.87-1.6l7.39-8.63A1.24,1.24,0,0,1,351.38,65.31Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#3c3c3b",
    d: "M351.38,220.47a1.24,1.24,0,0,1-.94-.43l-7.39-8.63a1.23,1.23,0,1,1,1.87-1.6l6.46,7.53,6.45-7.53a1.23,1.23,0,1,1,1.87,1.6L352.31,220A1.22,1.22,0,0,1,351.38,220.47Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "129.16",
    y: "15.53",
    width: "174.4",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "129.16",
    y: "65.31",
    width: "174.4",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "129.16",
    y: "209.38",
    width: "174.4",
    height: "11.09"
  }))
}, {
  name: 'preset-6',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-6'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-6'),
  isPro: false,
  atts: {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    searchWrap: {
      options: {
        enable: false,
        contentSrc: ['content', 'label'],
        tag: 'div',
        class: 'accordion-search-wrap'
      },
      styles: {}
    },
    searchInput: {
      options: {
        tag: 'input',
        type: 'text',
        value: '',
        placeholder: 'Search here...',
        class: 'accordion-search-input'
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "start"
        },
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {}
    },
    labelCounter: {
      options: {
        position: 'left',
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {
        "margin": {
          "Desktop": "0px 10px 0px 0px"
        }
      }
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: '',
        class: 'accordion-icon'
      },
      styles: {}
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: "",
    customCss: "",
    blockCssY: {
      items: {}
    }
  },
  innerBlocks: [['post-grid/accordion-nested-item', {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "start"
        },
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {}
    },
    labelCounter: {
      options: {
        position: 'left',
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {
        "margin": {
          "Desktop": "0px 10px 0px 0px"
        }
      }
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: '',
        class: 'accordion-icon'
      },
      styles: {}
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: {},
    customCss: {},
    blockCssY: {
      items: {}
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 360 236"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "0.11",
    width: "360",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "0.11",
    y: "99.56",
    width: "360",
    height: "86.66"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "0.11",
    y: "49.78",
    width: "360",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "0.11",
    y: "193.85",
    width: "360",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "46.54",
    y: "15.53",
    width: "174.4",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "46.54",
    y: "65.31",
    width: "174.4",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "46.54",
    y: "209.38",
    width: "174.4",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#ffffff",
    d: "M17,18.65v-3l4.21-2.48h2.57V29H20.86V16.29Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#3c3c3b",
    d: "M19.21,76.4h6.34v2.5H15.18V76.57a29.76,29.76,0,0,0,4.9-4.32q2.07-2.3,2.07-4.14a2.5,2.5,0,0,0-.71-1.89,2.8,2.8,0,0,0-2-.68A6.05,6.05,0,0,0,15.54,67V64.2a6.74,6.74,0,0,1,2-1,7.65,7.65,0,0,1,2.38-.39,5.58,5.58,0,0,1,3.8,1.28,4.48,4.48,0,0,1,1.47,3.58C25.18,70.56,23.19,73.46,19.21,76.4Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#ffffff",
    d: "M16.06,210.47v-2.75a7.16,7.16,0,0,1,3.48-.9A5.86,5.86,0,0,1,23.46,208a3.89,3.89,0,0,1,1.42,3.11,3.7,3.7,0,0,1-2.5,3.74,3.78,3.78,0,0,1,2.11,1.27,3.69,3.69,0,0,1,.75,2.37,4.08,4.08,0,0,1-1.47,3.25A6.17,6.17,0,0,1,19.66,223a9.93,9.93,0,0,1-4.18-.8v-2.85a8.27,8.27,0,0,0,4,1,3.09,3.09,0,0,0,2.06-.62,2,2,0,0,0,.74-1.59c0-1.41-1.14-2.11-3.43-2.11h-.92v-2.46h.92a3.94,3.94,0,0,0,2.16-.55,1.77,1.77,0,0,0,.88-1.58c0-1.36-.84-2-2.5-2A6.24,6.24,0,0,0,16.06,210.47Z"
  }))
}, {
  name: 'preset-7',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-7'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-7'),
  isPro: false,
  atts: {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    searchWrap: {
      options: {
        enable: false,
        contentSrc: ['content', 'label'],
        tag: 'div',
        class: 'accordion-search-wrap'
      },
      styles: {}
    },
    searchInput: {
      options: {
        tag: 'input',
        type: 'text',
        value: '',
        placeholder: 'Search here...',
        class: 'accordion-search-input'
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "end"
        },
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {}
    },
    labelCounter: {
      options: {
        position: 'right',
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {
        "margin": {
          "Desktop": "0px 0px 0px 10px"
        }
      }
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: '',
        class: 'accordion-icon'
      },
      styles: {}
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: "",
    customCss: "",
    blockCssY: {
      items: {}
    }
  },
  innerBlocks: [['post-grid/accordion-nested-item', {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "end"
        },
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        },
        "margin": {
          "Desktop": "0px 0px 0px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {}
    },
    labelCounter: {
      options: {
        position: 'right',
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {
        "margin": {
          "Desktop": "0px 0px 0px 10px"
        }
      }
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: '',
        class: 'accordion-icon'
      },
      styles: {}
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: {},
    customCss: {},
    blockCssY: {
      items: {}
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 360 236"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    width: "360",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    y: "99.56",
    width: "360",
    height: "86.66"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    y: "49.78",
    width: "360",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "193.85",
    width: "360",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "139.17",
    y: "15.53",
    width: "174.4",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "139.17",
    y: "65.31",
    width: "174.4",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "139.17",
    y: "209.38",
    width: "174.4",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#ffffff",
    d: "M336.36,18.65v-3l4.2-2.48h2.58V29h-2.89V16.29Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#3c3c3b",
    d: "M338.59,76.4h6.34v2.5H334.56V76.57a29.85,29.85,0,0,0,4.91-4.32,6.55,6.55,0,0,0,2.06-4.14,2.49,2.49,0,0,0-.7-1.89,2.8,2.8,0,0,0-2-.68,6,6,0,0,0-3.86,1.5V64.2a6.62,6.62,0,0,1,2-1,7.6,7.6,0,0,1,2.38-.39,5.6,5.6,0,0,1,3.8,1.28,4.48,4.48,0,0,1,1.47,3.58C344.57,70.56,342.58,73.46,338.59,76.4Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#ffffff",
    d: "M335.45,210.47v-2.75a7.15,7.15,0,0,1,3.47-.9,5.82,5.82,0,0,1,3.92,1.22,3.9,3.9,0,0,1,1.43,3.11,3.71,3.71,0,0,1-2.51,3.74,3.77,3.77,0,0,1,2.12,1.27,3.69,3.69,0,0,1,.75,2.37,4.08,4.08,0,0,1-1.47,3.25A6.18,6.18,0,0,1,339,223a9.91,9.91,0,0,1-4.17-.8v-2.85a8.27,8.27,0,0,0,4,1,3.06,3.06,0,0,0,2-.62,2,2,0,0,0,.74-1.59c0-1.41-1.14-2.11-3.42-2.11h-.92v-2.46h.92a3.94,3.94,0,0,0,2.16-.55,1.78,1.78,0,0,0,.87-1.58c0-1.36-.83-2-2.5-2A6.23,6.23,0,0,0,335.45,210.47Z"
  }))
}, {
  name: 'preset-8',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-8'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-8'),
  isPro: true,
  atts: {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    searchWrap: {
      options: {
        enable: false,
        contentSrc: ['content', 'label'],
        tag: 'div',
        class: 'accordion-search-wrap'
      },
      styles: {}
    },
    searchInput: {
      options: {
        tag: 'input',
        type: 'text',
        value: '',
        placeholder: 'Search here...',
        class: 'accordion-search-input'
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "start"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "width": {
          "Desktop": "100%"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        }
      }
    },
    labelCounter: {
      options: {
        position: 'left',
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {
        "margin": {
          "Desktop": "0px 10px 0px 0px"
        }
      }
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: '',
        class: 'accordion-icon'
      },
      styles: {}
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: "",
    customCss: "",
    blockCssY: {
      items: {}
    }
  },
  innerBlocks: [['post-grid/accordion-nested-item', {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "start"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "width": {
          "Desktop": "100%"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        }
      }
    },
    labelCounter: {
      options: {
        position: 'left',
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {
        "margin": {
          "Desktop": "0px 10px 0px 0px"
        }
      }
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: '',
        class: 'accordion-icon'
      },
      styles: {}
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: {},
    customCss: {},
    blockCssY: {
      items: {}
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 360 236"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    class: "cls-1",
    x: "30.65",
    width: "329.35",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "56.55",
    y: "15.53",
    width: "172.07",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "30.65",
    y: "99.56",
    width: "329.35",
    height: "86.66"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "30.65",
    y: "49.78",
    width: "329.35",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    class: "cls-1",
    x: "56.55",
    y: "65.31",
    width: "172.07",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    class: "cls-1",
    x: "30.65",
    y: "193.85",
    width: "329.35",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "56.55",
    y: "209.38",
    width: "172.07",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    class: "cls-1",
    d: "M1.77,18.65v-3l4.15-2.48H8.46V29H5.61V16.29Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#ffffff",
    d: "M4,76.32h6.25v2.5H0V76.49a29.67,29.67,0,0,0,4.84-4.32,6.61,6.61,0,0,0,2-4.14,2.49,2.49,0,0,0-.7-1.89,2.72,2.72,0,0,0-2-.68A5.91,5.91,0,0,0,.36,67V64.12a6.8,6.8,0,0,1,2-1,7.47,7.47,0,0,1,2.35-.39A5.45,5.45,0,0,1,8.42,64a4.51,4.51,0,0,1,1.45,3.58Q9.87,71.93,4,76.32Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    class: "cls-1",
    d: "M.87,210.39v-2.75a7,7,0,0,1,3.43-.9A5.7,5.7,0,0,1,8.17,208a3.9,3.9,0,0,1,1.4,3.11,3.69,3.69,0,0,1-2.47,3.74,3.78,3.78,0,0,1,2.09,1.27,3.75,3.75,0,0,1,.74,2.37,4.09,4.09,0,0,1-1.45,3.25A6,6,0,0,1,4.42,223a9.67,9.67,0,0,1-4.12-.8V219.3a8.11,8.11,0,0,0,3.93,1,3,3,0,0,0,2-.62A2,2,0,0,0,7,218.11C7,216.7,5.86,216,3.61,216H2.7v-2.45h.91A3.88,3.88,0,0,0,5.74,213a1.8,1.8,0,0,0,.86-1.58c0-1.36-.82-2-2.47-2A6.13,6.13,0,0,0,.87,210.39Z"
  }))
}, {
  name: 'preset-9',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-9'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-9'),
  isPro: true,
  atts: {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    searchWrap: {
      options: {
        enable: false,
        contentSrc: ['content', 'label'],
        tag: 'div',
        class: 'accordion-search-wrap'
      },
      styles: {}
    },
    searchInput: {
      options: {
        tag: 'input',
        type: 'text',
        value: '',
        placeholder: 'Search here...',
        class: 'accordion-search-input'
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "end"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "width": {
          "Desktop": "100%"
        },
        "textAlign": {
          "Desktop": "right"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        }
      }
    },
    labelCounter: {
      options: {
        position: 'right',
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {
        "margin": {
          "Desktop": "0px 0px 0px 10px"
        }
      }
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: '',
        class: 'accordion-icon'
      },
      styles: {}
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: "",
    customCss: "",
    blockCssY: {
      items: {}
    }
  },
  innerBlocks: [['post-grid/accordion-nested-item', {
    wrapper: {
      options: {
        tag: 'div',
        class: ''
      },
      styles: {}
    },
    content: {
      options: {
        tag: 'div',
        class: 'accordion-content'
      },
      styles: {}
    },
    header: {
      options: {
        tag: 'div',
        class: 'accordion-header'
      },
      styles: {
        "justifyContent": {
          "Desktop": "end"
        },
        "margin": {
          "Desktop": "0px 0px 1px 0px"
        },
        "display": {
          "Desktop": "flex"
        },
        "alignItems": {
          "Desktop": "center"
        }
      }
    },
    headerLabel: {
      options: {
        text: 'Accordion Header Text',
        tag: 'div',
        class: 'accordion-header-label'
      },
      styles: {
        "backgroundColor": {
          "Desktop": "#18978F"
        },
        "color": {
          "Desktop": "#ffffff"
        },
        "width": {
          "Desktop": "100%"
        },
        "textAlign": {
          "Desktop": "right"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        }
      }
    },
    labelCounter: {
      options: {
        position: 'right',
        tag: 'div',
        class: 'accordion-header-counter'
      },
      styles: {
        "margin": {
          "Desktop": "0px 0px 0px 10px"
        }
      }
    },
    labelIcon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: 'left',
        enable: false,
        class: 'accordion-icon'
      },
      styles: {}
    },
    icon: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-down',
        position: '',
        class: 'accordion-icon'
      },
      styles: {}
    },
    iconToggle: {
      options: {
        library: 'fontAwesome',
        srcType: "class",
        iconSrc: 'fas fa-angle-up',
        class: 'accordion-icon-toggle'
      },
      styles: {}
    },
    blockId: {},
    customCss: {},
    blockCssY: {
      items: {}
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 360 236"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#3c3c3b",
    d: "M351.43,18.57v-3l4.2-2.48h2.57V28.94h-2.89V16.21Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#ffffff",
    d: "M353.66,76.32H360v2.5H349.63V76.49a30.26,30.26,0,0,0,4.91-4.32A6.6,6.6,0,0,0,356.6,68a2.53,2.53,0,0,0-.7-1.89,2.8,2.8,0,0,0-2-.68A6.06,6.06,0,0,0,350,67V64.12a6.92,6.92,0,0,1,2-1,7.56,7.56,0,0,1,2.38-.39,5.6,5.6,0,0,1,3.8,1.28,4.49,4.49,0,0,1,1.47,3.58Q359.64,71.93,353.66,76.32Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#3c3c3b",
    d: "M350.52,210.39v-2.75a7.13,7.13,0,0,1,3.47-.9,5.84,5.84,0,0,1,3.92,1.22,3.89,3.89,0,0,1,1.42,3.11,3.69,3.69,0,0,1-2.5,3.74,3.8,3.8,0,0,1,2.11,1.27,3.64,3.64,0,0,1,.76,2.37,4.08,4.08,0,0,1-1.47,3.25,6.2,6.2,0,0,1-4.12,1.25,9.93,9.93,0,0,1-4.18-.8V219.3a8.31,8.31,0,0,0,4,1,3.08,3.08,0,0,0,2.05-.62,2,2,0,0,0,.74-1.59c0-1.41-1.14-2.11-3.43-2.11h-.92v-2.45h.92a4,4,0,0,0,2.17-.56,1.78,1.78,0,0,0,.87-1.58c0-1.36-.83-2-2.5-2A6.23,6.23,0,0,0,350.52,210.39Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    width: "333.82",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    y: "99.56",
    width: "333.82",
    height: "86.66"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    y: "49.78",
    width: "333.82",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "193.85",
    width: "333.82",
    height: "42.15"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "124.2",
    y: "15.45",
    width: "174.4",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "124.2",
    y: "65.23",
    width: "174.4",
    height: "11.09"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#ffffff",
    x: "124.2",
    y: "209.3",
    width: "174.4",
    height: "11.09"
  }))
}];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (variations);

/***/ }),

/***/ "./src/blocks/accordion/index.js":
/*!***************************************!*\
  !*** ./src/blocks/accordion/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");














const {
  RawHTML
} = wp.element;













var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)("post-grid/accordion", {
  apiVersion: 2,
  title: "Accordion (OLD)",
  parent: ['post-grid/accordion-nested'],
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#fff',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      y: "6.2",
      width: "36",
      height: "4.21"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      fill: "#C5C5C5",
      d: "M4,8.87a.14.14,0,0,1-.1,0L3.13,8a.12.12,0,0,1,0-.17.12.12,0,0,1,.17,0L4,8.55l.64-.75a.13.13,0,0,1,.18,0A.12.12,0,0,1,4.8,8l-.74.86A.12.12,0,0,1,4,8.87Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#C5C5C5",
      x: "6.07",
      y: "7.76",
      width: "17.44",
      height: "1.11"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#C5C5C5",
      y: "16.16",
      width: "36",
      height: "8.66"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#C5C5C5",
      y: "11.18",
      width: "36",
      height: "4.21"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      fill: "#fff",
      d: "M4,12.73a.12.12,0,0,1,.09,0l.74.86a.12.12,0,0,1,0,.17.13.13,0,0,1-.18,0L4,13.05l-.65.75a.12.12,0,0,1-.17,0,.12.12,0,0,1,0-.17l.74-.86A.14.14,0,0,1,4,12.73Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "6.07",
      y: "12.73",
      width: "17.44",
      height: "1.11"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      y: "25.58",
      width: "36",
      height: "4.21"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      fill: "#C5C5C5",
      d: "M4,28.24a.13.13,0,0,1-.1,0l-.74-.86a.14.14,0,0,1,0-.18.12.12,0,0,1,.17,0l.65.75.64-.75a.12.12,0,1,1,.19.16l-.74.86A.11.11,0,0,1,4,28.24Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#C5C5C5",
      x: "6.07",
      y: "27.13",
      width: "17.44",
      height: "1.11"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          content: '',
          tag: 'div',
          class: 'pg-accordion'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    items: {
      type: 'array',
      default: [{
        isActive: false,
        headerText: 'What is Lorem Ipsum?',
        content: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.',
        icon: '',
        iconToggle: '',
        styles: {}
      }]
    },
    header: {
      type: 'object',
      default: {
        options: {
          text: 'What is Lorem Ipsum?',
          tag: 'div',
          class: 'pg-accordion-header'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    headerActive: {
      type: 'object',
      default: {
        options: {
          text: 'What is Lorem Ipsum?',
          tag: 'div',
          class: 'pg-accordion-header '
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    content: {
      type: 'object',
      default: {
        options: {
          text: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.',
          tag: 'div',
          class: 'pg-accordion-content'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    icon: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'fas fa-chevron-right',
          class: 'icon',
          positon: 'beforeHeader',
          enableToggle: 'yes'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          }
        }
      }
    },
    iconToggle: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'fas fa-chevron-down',
          class: 'iconToggle'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          }
        }
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var items = attributes.items;
    var wrapper = attributes.wrapper;
    var header = attributes.header;
    var headerActive = attributes.headerActive;
    var content = attributes.content;
    var icon = attributes.icon;
    var iconToggle = attributes.iconToggle;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType']; //const [breakPointX, setBreakPointX] = useState(myStore.getBreakPoint());

    var breakPointX = myStore.getBreakPoint();
    const [isLoading, setisLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [isOpen, setisOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false); // Wrapper CSS Class Selectors

    var wrapperSelector = blockClass;
    var headerSelector = blockClass + ' .pg-accordion-header';
    var headerActiveSelector = blockClass + ' .pg-accordion-header.active';
    var contentSelector = blockClass + ' .pg-accordion-content .ac-text';
    const iconSelector = blockClass + ' .icon-wrap';
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]); // var breakPointList = [{ label: 'Select..', icon: '', value: '' }];
    // for (var x in breakPoints) {
    //   var item = breakPoints[x];
    //   breakPointList.push({ label: item.name, icon: item.icon, value: item.id })
    // }

    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      var iconSrc = icon.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      setIconHtml(iconHtml);
    }, [icon]);
    const [iconToggleHtml, setIconToggleHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      var iconSrc = iconToggle.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      setIconToggleHtml(iconHtml);
    }, [iconToggle]);

    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }

    function onChangeIcon(arg) {
      var options = { ...icon.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        icon: { ...icon,
          options: options
        }
      });
    }

    function onChangeIconToggle(arg) {
      var options = { ...iconToggle.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        iconToggle: { ...iconToggle,
          options: options
        }
      });
    }

    function onPickCssLibraryHeader(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        header[sudoScource] = sudoScourceArgs;
      });
      var headerX = Object.assign({}, header);
      setAttributes({
        header: headerX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onPickCssLibraryContent(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        content[sudoScource] = sudoScourceArgs;
      });
      var contentX = Object.assign({}, content);
      setAttributes({
        content: contentX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onPickCssLibraryIcon(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        icon[sudoScource] = sudoScourceArgs;
      });
      var iconX = Object.assign({}, icon);
      setAttributes({
        icon: iconX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStyleHeader(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, header);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        header: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleHeader(sudoScource, key) {
      var object = myStore.deletePropertyDeep(header, [sudoScource, key, breakPointX]);
      setAttributes({
        header: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleHeader(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, header);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        header: object
      });
    }

    function onChangeStyleContent(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, content);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        content: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleContent(sudoScource, key) {
      var object = myStore.deletePropertyDeep(content, [sudoScource, key, breakPointX]);
      setAttributes({
        content: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, contentSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleContent(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, content);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        content: object
      });
    }

    function onChangeStyleIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(icon, [sudoScource, key, breakPointX]);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        icon: object
      });
    }

    function onChangeStyleHeaderActive(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, headerActive);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        headerActive: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerActiveSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleHeaderActive(sudoScource, key) {
      var object = myStore.deletePropertyDeep(headerActive, [sudoScource, key, breakPointX]);
      setAttributes({
        headerActive: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, headerActiveSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleHeaderActive(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, headerActive);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        headerActive: object
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-2",
      title: "header",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Header",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: header.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...header.options,
          tag: newVal
        };
        setAttributes({
          header: { ...header,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: header,
      onChange: onChangeStyleHeader,
      onAdd: onAddStyleHeader,
      onRemove: onRemoveStyleHeader
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_20__["default"], {
      blockId: blockId,
      obj: header,
      onChange: onPickCssLibraryHeader
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Header - Active",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: headerActive,
      onChange: onChangeStyleHeaderActive,
      onAdd: onAddStyleHeaderActive,
      onRemove: onRemoveStyleHeaderActive
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Content",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: content.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...content.options,
          tag: newVal
        };
        setAttributes({
          content: { ...content,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: content,
      onChange: onChangeStyleContent,
      onAdd: onAddStyleContent,
      onRemove: onRemoveStyleContent
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_20__["default"], {
      blockId: blockId,
      obj: content,
      onChange: onPickCssLibraryContent
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_16__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: onChangeIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Toggled Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_16__["default"], {
      library: iconToggle.options.library,
      srcType: iconToggle.options.srcType,
      iconSrc: iconToggle.options.iconSrc,
      onChange: onChangeIconToggle
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Icon postion"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: 'Choose...',
        value: ''
      }, {
        label: 'Before Header Text',
        value: 'beforeHeader'
      }, {
        label: 'After Header Text',
        value: 'afterHeader'
      }],
      onChange: newVal => {
        var options = { ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Enable Icon Toggle"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: icon.options.enableToggle,
      options: [{
        label: 'Yes',
        value: 'yes'
      }, {
        label: 'No',
        value: 'no'
      }],
      onChange: newVal => {
        var options = { ...icon.options,
          enableToggle: newVal
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_20__["default"], {
      blockId: blockId,
      obj: icon,
      onChange: onPickCssLibraryIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Text "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, wrapperSelector, '{}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_13__["default"], {
      utm: {
        utm_source: 'BlockText',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: [blockId]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "bg-blue-500 p-2 px-5 text-white my-4 text-center cursor-pointer",
      onClick: ev => {
        var itemx = items.concat({
          isActive: false,
          headerText: 'What is Lorem Ipsum?',
          content: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.',
          icon: '',
          iconToggle: '',
          styles: {}
        });
        setAttributes({
          items: itemx
        });
      }
    }, "Add"), items.map((item, i) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: `${header.options.class} ${items[i].isActive ? 'active' : ''} cursor-pointer`,
        onClick: ev => {
          items[i].isActive = !items[i].isActive;
          var ssdsd = items.concat([]);
          setAttributes({
            items: ssdsd
          });
        }
      }, icon.options.position == 'beforeHeader' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, icon.options.enableToggle == 'yes' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, !items[i].isActive && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "icon-wrap",
        dangerouslySetInnerHTML: {
          __html: iconHtml
        }
      }), items[i].isActive && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "icon-wrap",
        dangerouslySetInnerHTML: {
          __html: iconToggleHtml
        }
      })), icon.options.enableToggle == 'no' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "icon-wrap",
        dangerouslySetInnerHTML: {
          __html: iconHtml
        }
      })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.RichText, {
        tagName: "span",
        value: item.headerText,
        allowedFormats: ['core/bold', 'core/italic', 'core/link'],
        onChange: content => {
          items[i].headerText = content;
          var ssdsd = items.concat([]);
          setAttributes({
            items: ssdsd
          });
        },
        placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Start Writing...')
      }), icon.options.position == 'afterHeader' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, icon.options.enableToggle == 'yes' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, !items[i].isActive && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "icon-wrap float-right",
        dangerouslySetInnerHTML: {
          __html: iconHtml
        }
      }), items[i].isActive && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "icon-wrap float-right",
        dangerouslySetInnerHTML: {
          __html: iconToggleHtml
        }
      })), icon.options.enableToggle == 'no' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "icon-wrap float-right",
        dangerouslySetInnerHTML: {
          __html: iconHtml
        }
      })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "text-lg cursor-pointer px-2 text-red-500  py-1 float-right icon-close",
        onClick: ev => {
          items.splice(i, 1);
          var ssdsd = items.concat([]);
          setAttributes({
            items: ssdsd
          });
          ev.preventDefault();
        }
      })), items[i].isActive && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: content.options.class
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.RichText, {
        className: 'ac-text',
        tagName: "div",
        value: item.content,
        allowedFormats: ['core/bold', 'core/italic', 'core/link'],
        onChange: content => {
          items[i].content = content;
          var ssdsd = items.concat([]);
          setAttributes({
            items: ssdsd
          });
        },
        placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Start Writing...')
      })));
    }))));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/archive-description/index.js":
/*!*************************************************!*\
  !*** ./src/blocks/archive-description/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link-off.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_css_display__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/css-display */ "./src/components/css-display/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");















const {
  RawHTML
} = wp.element;















var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__.registerBlockType)("post-grid/archive-description", {
  apiVersion: 2,
  title: "Archive description",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#fff',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("rect", {
      fill: "#1d4ed8",
      y: "16.57",
      width: "13.97",
      height: "2"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("rect", {
      fill: "#1d4ed8",
      y: "12.32",
      width: "36",
      height: "2"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("rect", {
      fill: "#8db1ff",
      y: "6.41",
      width: "36",
      height: "2.35"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      fill: "#8db1ff",
      d: "M0,22.46v7.13H10.69V22.46Zm9.43,5.87H1.26V23.72H9.43Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      fill: "#8db1ff",
      d: "M12.66,22.46v7.13H23.34V22.46Zm9.42,5.87H13.92V23.72h8.16Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      fill: "#8db1ff",
      d: "M25.31,22.46v7.13H36V22.46Zm9.43,5.87H26.57V23.72h8.17Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    archiveTitle: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          archiveType: 'auto',
          customLabel: 'Archive: %s',
          dateFormat: '',
          linkTo: '',
          // postUrl, customField, authorUrl, authorLink, homeUrl, custom
          linkToUrl: '',
          linkToMetaKey: '',
          linkTarget: '_blank',
          linkAttr: [],
          customUrl: '',
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          }
        }
      }
    },
    icon: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'far fa-calendar-alt',
          position: 'beforeArchiveTitle',

          /*before, after, prefix, postfix */
          class: 'postdate-icon'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          }
        }
      }
    },
    prefix: {
      type: 'object',
      default: {
        options: {
          text: '',
          class: 'prefix'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          }
        }
      }
    },
    postfix: {
      type: 'object',
      default: {
        options: {
          text: '',
          class: 'prefix'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          }
        }
      }
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    let archiveTitle = attributes.archiveTitle;
    var wrapper = attributes.wrapper;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var icon = attributes.icon;
    var prefix = attributes.prefix;
    var postfix = attributes.postfix;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType']; //const [breakPointX, setBreakPointX] = useState(myStore.getBreakPoint());

    var breakPointX = myStore.getBreakPoint();
    const [customTags, setCustomTags] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
    const [linkPickerPosttitle, setLinkPickerPosttitle] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    var archiveLinkToArgsBasic = {
      none: {
        label: 'No Link',
        value: ''
      },
      archiveUrl: {
        label: 'Archive URL',
        value: 'archiveUrl'
      },
      homeUrl: {
        label: 'Home URL',
        value: 'homeUrl'
      },
      customUrl: {
        label: 'Custom',
        value: 'customUrl'
      }
    };
    let archiveLinkToArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__.applyFilters)('archiveLinkToArgs', archiveLinkToArgsBasic);
    var archiveTypes = {
      'auto': {
        label: 'Auto Detect',
        value: 'auto'
      } // 'author': { label: 'Author', value: 'author' },
      // 'category': { label: 'Category', value: 'category' },
      // 'tag': { label: 'Tag', value: 'tag' },
      // 'taxonomy': { label: 'Taxonomy', value: 'taxonomy' },
      // 'search': { label: 'Search', value: 'search' },
      // 'index': { label: 'Index', value: 'index' },
      // 'year': { label: 'Year', value: 'year' },
      // 'month': { label: 'Month', value: 'month' },
      // 'date': { label: 'Date', value: 'date' },
      // 'wcCatalog': { label: 'WooCommerce Catalog', value: 'wcCatalog' },
      // 'wcSearch': { label: 'WooCommerce Search', value: 'wcSearch' },

    };
    var dateFormats = {
      'Y-M-d': {
        label: '2022-May-25',
        value: 'Y-M-d'
      },
      'Y-m-d': {
        label: '2022-05-25',
        value: 'Y-m-d'
      },
      'd-m-y': {
        label: '25-05-2022',
        value: 'd-m-y'
      },
      'd/m/y': {
        label: '25/05/2022',
        value: 'd/m/y'
      },
      'y-m-d': {
        label: '2022-05-25',
        value: 'y-m-d'
      },
      'y/m/d': {
        label: '2022/05/25',
        value: 'y/m/d'
      },
      'D M y': {
        label: 'Sun May 2022',
        value: 'D M y'
      },
      'D M d, y': {
        label: 'Sun May 11, 2022',
        value: 'D M d, y'
      },
      'M D d, y': {
        label: 'May Sun 11, 2022',
        value: 'M D d, y'
      },
      'M d, y': {
        label: 'May 11, 2022',
        value: 'M d, y'
      },
      'd M y': {
        label: '25 May 2022',
        value: 'd M y'
      }
    }; // Wrapper CSS Class Selectors

    const wrapperSelector = blockClass;
    var archiveTitleSelector = '';

    if (wrapper.options.tag.length != 0) {
      if (archiveTitle.options.linkTo.length > 0) {
        archiveTitleSelector = blockClass + ' a';
      } else {
        archiveTitleSelector = blockClass; //archiveTitleSelector = blockClass + ' .archiveTitle';
      }
    } else {
      archiveTitleSelector = blockClass;
    }

    const prefixSelector = blockClass + ' .prefix';
    const postfixSelector = blockClass + ' .postfix';
    const iconSelector = blockClass + ' .postdate-icon';
    const [archiveTitleEdited, setarchiveTitleEdited] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('Hello %s');

    function onChangeIcon(arg) {
      var options = { ...icon.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        icon: { ...icon,
          options: options
        }
      });
    }

    function setFieldLinkTo(option, index) {
      var options = { ...archiveTitle.options,
        linkTo: option.value
      };
      setAttributes({
        archiveTitle: { ...archiveTitle,
          options: options
        }
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      console.log(archiveTitle);
      var archiveType = archiveTitle.options.archiveType;

      if (archiveType == 'auto') {
        //archiveTitleEdited = archiveTitle.options.customLabel;
        setarchiveTitleEdited(archiveTitle.options.customLabel);
      }
    }, [archiveTitle]);

    function onPickCssLibraryWrapper(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        wrapper[sudoScource] = sudoScourceArgs;
      });
      var wrapperX = Object.assign({}, wrapper);
      setAttributes({
        wrapper: wrapperX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onPickCssLibraryArchiveTitle(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        archiveTitle[sudoScource] = sudoScourceArgs;
      });
      var archiveTitleX = Object.assign({}, archiveTitle);
      setAttributes({
        archiveTitle: archiveTitleX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onPickCssLibraryIcon(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        icon[sudoScource] = sudoScourceArgs;
      });
      var iconX = Object.assign({}, icon);
      setAttributes({
        icon: iconX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onPickCssLibraryPrefix(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        prefix[sudoScource] = sudoScourceArgs;
      });
      var prefixX = Object.assign({}, prefix);
      setAttributes({
        prefix: prefixX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onPickCssLibraryPostfix(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        postfix[sudoScource] = sudoScourceArgs;
      });
      var postfixX = Object.assign({}, postfix);
      setAttributes({
        postfix: postfixX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStyleIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(icon, [sudoScource, key, breakPointX]);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        icon: object
      });
    }

    function onChangeStylePrefix(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, prefix);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        prefix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStylePrefix(sudoScource, key) {
      var object = myStore.deletePropertyDeep(prefix, [sudoScource, key, breakPointX]);
      setAttributes({
        prefix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStylePrefix(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, prefix);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        prefix: object
      });
    }

    function onChangeStylePostfix(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, postfix);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        postfix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStylePostfix(sudoScource, key) {
      var object = myStore.deletePropertyDeep(postfix, [sudoScource, key, breakPointX]);
      setAttributes({
        postfix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStylePostfix(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, postfix);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        postfix: object
      });
    }

    function onBulkAddWrapper(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, wrapper);
      obj[sudoScource] = cssObj;
      setAttributes({
        wrapper: obj
      });
      var selector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onBulkAddArchiveTitle(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, archiveTitle);
      obj[sudoScource] = cssObj;
      setAttributes({
        archiveTitle: obj
      });
      var selector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onBulkAddIcon(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, icon);
      obj[sudoScource] = cssObj;
      setAttributes({
        icon: obj
      });
      var selector = myStore.getElementSelector(sudoScource, iconSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onBulkAddPrefix(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, prefix);
      obj[sudoScource] = cssObj;
      setAttributes({
        prefix: obj
      });
      var selector = myStore.getElementSelector(sudoScource, prefixSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onBulkAddPostfix(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, postfix);
      obj[sudoScource] = cssObj;
      setAttributes({
        postfix: obj
      });
      var selector = myStore.getElementSelector(sudoScource, postfixSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    String.prototype.strtr = function (dic) {
      const str = this.toString(),
            makeToken = inx => `{{###~${inx}~###}}`,
            tokens = Object.keys(dic).map((key, inx) => ({
        key,
        val: dic[key],
        token: makeToken(inx)
      })),
            tokenizedStr = tokens.reduce((carry, entry) => carry.replace(new RegExp(entry.key, "g"), entry.token), str);

      return tokens.reduce((carry, entry) => carry.replace(new RegExp(entry.token, "g"), entry.val), tokenizedStr);
    };

    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('');
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      var iconSrc = icon.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      console.log(iconHtml);
      setIconHtml(iconHtml);
    }, [icon]);
    const [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__.useEntityProp)('postType', postType, 'link', postId);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      }); // setAttributes({ archiveTitle: archiveTitle });
      // setAttributes({ wrapper: wrapper });

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      customTags['currentYear'] = '2022';
      customTags['currentMonth'] = '07';
      customTags['currentDay'] = '27';
      customTags['currentDate'] = '27';
      customTags['currentTime'] = '27';
      customTags['postPublishDate'] = '123';
      customTags['postModifiedDate'] = '123';
      customTags['termId'] = '';
      customTags['termTitle'] = '';
      customTags['termDescription'] = '';
      customTags['termPostCount'] = '';
      customTags['postTagTitle'] = 'First Tag Title';
      customTags['postTagsTitle'] = 'First Tag Title';
      customTags['postCategoryTitle'] = 'First Category Title';
      customTags['postCategoriesTitle'] = 'First Categories Title';
      customTags['postTermTitle'] = 'First Term Title';
      customTags['postTermsTitle'] = 'List of all terms title';
      customTags['postId'] = '123';
      customTags['postStatus'] = '123';
      customTags['authorId'] = '123';
      customTags['authorName'] = 'Nur Hasan';
      customTags['authorFirstName'] = 'Nur';
      customTags['authorLastName'] = 'Hasan';
      customTags['authorDescription'] = 'Hasan';
      customTags['excerpt'] = 'Here is the post excerpt';
      customTags['rankmathTitle'] = 'Hasan';
      customTags['rankmathPermalink'] = 'Hasan';
      customTags['rankmathExcerpt'] = 'Hasan';
      customTags['rankmathFocusKeyword'] = 'Hasan';
      customTags['rankmathFocusKeywords'] = 'Hasan';
      customTags['rankmathOrgname'] = 'Hasan';
      customTags['rankmathOrgurl'] = 'Hasan';
      customTags['rankmathOrglogo'] = 'Hasan';
      customTags['siteTitle'] = '';
      customTags['siteDescription'] = '';
      customTags['siteTagline'] = '';
      customTags['postMeta'] = '';
      customTags['separator'] = '';
      customTags['searchTerms'] = '';
      customTags['counter'] = '1';
    }, [clientId]); // var breakPointList = [{ label: 'Select..', icon: '', value: '' }];
    // for (var x in breakPoints) {
    //   var item = breakPoints[x];
    //   breakPointList.push({ label: item.name, icon: item.icon, value: item.id })
    // }

    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onChangeStyleArchiveTitle(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, archiveTitle);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        archiveTitle: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleArchiveTitle(sudoScource, key) {
      var object = myStore.deletePropertyDeep(archiveTitle, [sudoScource, key, breakPointX]);
      setAttributes({
        archiveTitle: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleArchiveTitle(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, archiveTitle);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        archiveTitle: object
      });
    }

    var [linkAttrItems, setlinkAttrItems] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({}); // Using the hook.

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      linkAttrObj();
    }, [archiveTitle]);

    var linkAttrObj = () => {
      var sdsd = {};
      archiveTitle.options.linkAttr.map(x => {
        if (x.val) sdsd[x.id] = x.val;
      });
      setlinkAttrItems(sdsd);
    };

    var postUrl = archiveTitle.options.customUrl != undefined && archiveTitle.options.customUrl.length > 0 ? archiveTitle.options.customUrl : currentPostUrl;
    const CustomTag = `${wrapper.options.tag}`;
    const CustomTagPostTitle = `${archiveTitle.options.tag}`;
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.useBlockProps)({
      className: ` ${blockId} pg-archive-description`
    });
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'span',
        value: 'span'
      }, {
        label: 'div',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper,
      onBulkAdd: onBulkAddWrapper
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_23__["default"], {
      blockId: blockId,
      obj: wrapper,
      onChange: onPickCssLibraryWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Archive Description",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Archive Type"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_17__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: archiveTypes,
      buttonTitle: "Choose",
      onChange: (option, index) => {
        var options = { ...archiveTitle.options,
          archiveType: option.value
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      },
      values: ''
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "bg-gray-500 text-white p-3 py-2"
    }, archiveTypes[archiveTitle.options.archiveType].label), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Label"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: archiveTitle.options.customLabel,
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          customLabel: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), (archiveTitle.options.archiveType == 'year' || archiveTitle.options.archiveType == 'month' || archiveTitle.options.archiveType == 'day') && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Date Format"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_17__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: dateFormats,
      buttonTitle: "Choose",
      onChange: (option, index) => {
        var options = { ...archiveTitle.options,
          dateFormat: option.value
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      },
      values: ''
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Format"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: archiveTitle.options.dateFormat,
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          dateFormat: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), dateFormats[archiveTitle.options.dateFormat] != undefined && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "p-2 my-3 bg-gray-500 text-white"
    }, dateFormats[archiveTitle.options.dateFormat].label)), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Link To"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_17__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: archiveLinkToArgs,
      buttonTitle: archiveTitle.options.linkTo.length == 0 ? 'Choose' : archiveLinkToArgs[archiveTitle.options.linkTo].label,
      onChange: setFieldLinkTo,
      values: []
    })), archiveTitle.options.linkTo == 'customField' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Field Key"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      className: "mr-2",
      value: archiveTitle.options.linkToMetaKey,
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          linkToMetaKey: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), archiveTitle.options.linkTo == 'customUrl' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom URL"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: linkPickerPosttitle ? "!bg-gray-400" : '',
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
      onClick: ev => {
        setLinkPickerPosttitle(prev => !prev);
      }
    }), archiveTitle.options.customUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Button, {
      className: "!text-red-500 ml-2",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
      onClick: ev => {
        var options = { ...archiveTitle.options,
          customUrl: ''
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
        setLinkPickerPosttitle(false);
      }
    }), linkPickerPosttitle && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Popover, {
      position: "bottom right"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_8__.__experimentalLinkControl, {
      settings: [],
      value: archiveTitle.options.customUrl,
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          customUrl: newVal.url
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "p-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: "font-bold"
    }, "Linked to:"), " ", archiveTitle.options.customUrl.length != 0 ? archiveTitle.options.customUrl : 'No link', " ")))), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: archiveTitle.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          tag: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Link Target"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: archiveTitle.options.linkTarget,
      options: [{
        label: 'Choose...',
        value: ''
      }, {
        label: '_self',
        value: '_self'
      }, {
        label: '_blank',
        value: '_blank'
      }, {
        label: '_parent',
        value: '_parent'
      }, {
        label: '_top',
        value: '_top'
      }],
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          linkTarget: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Attributes"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: " cursor-pointer px-3 text-white py-1 bg-blue-600",
      onClick: ev => {
        var sdsd = archiveTitle.options.linkAttr.concat({
          id: '',
          val: ''
        });
        var options = { ...archiveTitle.options,
          linkAttr: sdsd
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
        linkAttrObj();
      }
    }, "Add")), archiveTitle.options.linkAttr.map((x, i) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
        className: "my-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Name",
        value: archiveTitle.options.linkAttr[i].id,
        onChange: newVal => {
          archiveTitle.options.linkAttr[i].id = newVal;
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = { ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: { ...archiveTitle,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Value",
        value: x.val,
        onChange: newVal => {
          archiveTitle.options.linkAttr[i].val = newVal;
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = { ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: { ...archiveTitle,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
        className: "text-lg cursor-pointer px-3 text-white py-1 bg-red-400 icon-close",
        onClick: ev => {
          archiveTitle.options.linkAttr.splice(i, 1);
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = { ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: { ...archiveTitle,
              options: options
            }
          });
        }
      })));
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: archiveTitle,
      onChange: onChangeStyleArchiveTitle,
      onAdd: onAddStyleArchiveTitle,
      onRemove: onRemoveStyleArchiveTitle,
      onBulkAdd: onBulkAddArchiveTitle
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_23__["default"], {
      blockId: blockId,
      obj: archiveTitle,
      onChange: onPickCssLibraryArchiveTitle
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_18__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: onChangeIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Icon postion"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: 'Choose Position',
        value: ''
      }, {
        label: 'Before Archive Title',
        value: 'beforeArchiveTitle'
      }, {
        label: 'After Archive Title',
        value: 'afterArchiveTitle'
      }, {
        label: 'Before Prefix',
        value: 'beforePrefix'
      }, {
        label: 'After Prefix',
        value: 'afterPrefix'
      }, {
        label: 'Before Postfix',
        value: 'beforePostfix'
      }, {
        label: 'After Postfix',
        value: 'afterPostfix'
      }],
      onChange: newVal => {
        var options = { ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon,
      onBulkAdd: onBulkAddIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_23__["default"], {
      blockId: blockId,
      obj: icon,
      onChange: onPickCssLibraryIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Prefix",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Prefix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: prefix.options.text,
      onChange: newVal => {
        var options = { ...prefix.options,
          text: newVal
        };
        setAttributes({
          prefix: {
            styles: prefix.styles,
            options: options
          }
        }); // setAttributes({ prefix: { text: newVal, class: prefix.options.class, color: prefix.color, backgroundColor: prefix.backgroundColor } })
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: prefix,
      onChange: onChangeStylePrefix,
      onAdd: onAddStylePrefix,
      onRemove: onRemoveStylePrefix,
      onBulkAdd: onBulkAddPrefix
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_23__["default"], {
      blockId: blockId,
      obj: prefix,
      onChange: onPickCssLibraryPrefix
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Postfix",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Postfix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
      value: postfix.options.text,
      onChange: newVal => {
        var options = { ...postfix.options,
          text: newVal
        };
        setAttributes({
          postfix: { ...postfix,
            options: options
          }
        }); // setAttributes({ postfix: { text: newVal, class: prefix.options.class, color: postfix.color, backgroundColor: postfix.backgroundColor } })
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: postfix,
      onChange: onChangeStylePostfix,
      onAdd: onAddStylePostfix,
      onRemove: onRemoveStylePostfix,
      onBulkAdd: onBulkAddPostfix
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_23__["default"], {
      blockId: blockId,
      obj: postfix,
      onChange: onPickCssLibraryPostfix
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Title Wrapper"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, wrapperSelector, '{/* your CSS here*/}'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Title link"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, archiveTitleSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Prefix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, prefixSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Postfix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, postfixSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "px-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_14__["default"], {
      utm: {
        utm_source: 'BlockPostTitle',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, wrapper.options.tag && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(CustomTag, blockProps, icon.options.position == 'beforePrefix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: prefix.options.class
    }, prefix.options.text), icon.options.position == 'afterPrefix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("a", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      className: "archiveTitle",
      onClick: handleLinkClick
    }, linkAttrItems, {
      target: archiveTitle.options.linkTarget,
      href: postUrl
    }), icon.options.position == 'beforeArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == 'afterArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, icon.options.position == 'beforeArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == 'afterArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), postfix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: postfix.options.class
    }, postfix.options.text), icon.options.position == 'afterPostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), wrapper.options.tag.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: prefix.options.class
    }, prefix.options.text), icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("a", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      className: "archiveTitle",
      onClick: handleLinkClick
    }, linkAttrItems, {
      target: archiveTitle.options.linkTarget,
      href: postUrl
    }), icon.options.position == 'beforeArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == 'afterArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", blockProps, icon.options.position == 'beforeArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == 'afterArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })))));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/archive-title/index.js":
/*!*******************************************!*\
  !*** ./src/blocks/archive-title/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link-off.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_css_display__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/css-display */ "./src/components/css-display/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");















const {
  RawHTML
} = wp.element;















var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__.registerBlockType)("post-grid/archive-title", {
  apiVersion: 2,
  title: "Archive Title",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#fff',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("rect", {
      fill: "#1d4ed8",
      y: "16.57",
      width: "13.97",
      height: "2"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("rect", {
      fill: "#1d4ed8",
      y: "12.32",
      width: "36",
      height: "2"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("rect", {
      fill: "#1d4ed8",
      y: "6.41",
      width: "36",
      height: "2.35"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      fill: "#8db1ff",
      d: "M0,22.46v7.13H10.69V22.46Zm9.43,5.87H1.26V23.72H9.43Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      fill: "#8db1ff",
      d: "M12.66,22.46v7.13H23.34V22.46Zm9.42,5.87H13.92V23.72h8.16Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("path", {
      fill: "#8db1ff",
      d: "M25.31,22.46v7.13H36V22.46Zm9.43,5.87H26.57V23.72h8.17Z"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    archiveTitle: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          archiveType: 'auto',
          customLabel: 'Archive: %s',
          dateFormat: '',
          linkTo: '',
          // postUrl, customField, authorUrl, authorLink, homeUrl, custom
          linkToUrl: '',
          linkToMetaKey: '',
          linkTarget: '_blank',
          linkAttr: [],
          customUrl: '',
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          }
        }
      }
    },
    icon: {
      type: 'object',
      default: {
        options: {
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'far fa-calendar-alt',
          position: 'beforeArchiveTitle',

          /*before, after, prefix, postfix */
          class: 'postdate-icon'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          }
        }
      }
    },
    prefix: {
      type: 'object',
      default: {
        options: {
          text: '',
          class: 'prefix'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          }
        }
      }
    },
    postfix: {
      type: 'object',
      default: {
        options: {
          text: '',
          class: 'prefix'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          }
        }
      }
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    let archiveTitle = attributes.archiveTitle;
    var wrapper = attributes.wrapper;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var icon = attributes.icon;
    var prefix = attributes.prefix;
    var postfix = attributes.postfix;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType']; //const [breakPointX, setBreakPointX] = useState(myStore.getBreakPoint());

    var breakPointX = myStore.getBreakPoint();
    const [customTags, setCustomTags] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
    const [linkPickerPosttitle, setLinkPickerPosttitle] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    var archiveTypes = {
      'auto': {
        label: 'Auto Detect',
        value: 'auto'
      } // 'author': { label: 'Author', value: 'author' },
      // 'category': { label: 'Category', value: 'category' },
      // 'tag': { label: 'Tag', value: 'tag' },
      // 'taxonomy': { label: 'Taxonomy', value: 'taxonomy' },
      // 'search': { label: 'Search', value: 'search' },
      // 'index': { label: 'Index', value: 'index' },
      // 'year': { label: 'Year', value: 'year' },
      // 'month': { label: 'Month', value: 'month' },
      // 'date': { label: 'Date', value: 'date' },
      // 'wcCatalog': { label: 'WooCommerce Catalog', value: 'wcCatalog' },
      // 'wcSearch': { label: 'WooCommerce Search', value: 'wcSearch' },

    };
    var archiveLinkToArgsBasic = {
      none: {
        label: 'No Link',
        value: ''
      },
      archiveUrl: {
        label: 'Archive URL',
        value: 'archiveUrl'
      },
      homeUrl: {
        label: 'Home URL',
        value: 'homeUrl'
      },
      customUrl: {
        label: 'Custom',
        value: 'customUrl'
      }
    };
    let archiveLinkToArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_6__.applyFilters)('archiveLinkToArgs', archiveLinkToArgsBasic);
    var dateFormats = {
      'Y-M-d': {
        label: '2022-May-25',
        value: 'Y-M-d'
      },
      'Y-m-d': {
        label: '2022-05-25',
        value: 'Y-m-d'
      },
      'd-m-y': {
        label: '25-05-2022',
        value: 'd-m-y'
      },
      'd/m/y': {
        label: '25/05/2022',
        value: 'd/m/y'
      },
      'y-m-d': {
        label: '2022-05-25',
        value: 'y-m-d'
      },
      'y/m/d': {
        label: '2022/05/25',
        value: 'y/m/d'
      },
      'D M y': {
        label: 'Sun May 2022',
        value: 'D M y'
      },
      'D M d, y': {
        label: 'Sun May 11, 2022',
        value: 'D M d, y'
      },
      'M D d, y': {
        label: 'May Sun 11, 2022',
        value: 'M D d, y'
      },
      'M d, y': {
        label: 'May 11, 2022',
        value: 'M d, y'
      },
      'd M y': {
        label: '25 May 2022',
        value: 'd M y'
      }
    };
    const [archiveTitleEdited, setarchiveTitleEdited] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('Hello %s');

    function onChangeIcon(arg) {
      var options = { ...icon.options,
        srcType: arg.srcType,
        library: arg.library,
        iconSrc: arg.iconSrc
      };
      setAttributes({
        icon: { ...icon,
          options: options
        }
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      console.log(archiveTitle);
      var archiveType = archiveTitle.options.archiveType;

      if (archiveType == 'auto') {
        //archiveTitleEdited = archiveTitle.options.customLabel;
        setarchiveTitleEdited(archiveTitle.options.customLabel);
      }
    }, [archiveTitle]);

    function setFieldLinkTo(option, index) {
      var options = { ...archiveTitle.options,
        linkTo: option.value
      };
      setAttributes({
        archiveTitle: { ...archiveTitle,
          options: options
        }
      });
    }

    function onPickCssLibraryWrapper(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        wrapper[sudoScource] = sudoScourceArgs;
      });
      var wrapperX = Object.assign({}, wrapper);
      setAttributes({
        wrapper: wrapperX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onPickCssLibraryArchiveTitle(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        archiveTitle[sudoScource] = sudoScourceArgs;
      });
      var archiveTitleX = Object.assign({}, archiveTitle);
      setAttributes({
        archiveTitle: archiveTitleX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onPickCssLibraryIcon(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        icon[sudoScource] = sudoScourceArgs;
      });
      var iconX = Object.assign({}, icon);
      setAttributes({
        icon: iconX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onPickCssLibraryPrefix(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        prefix[sudoScource] = sudoScourceArgs;
      });
      var prefixX = Object.assign({}, prefix);
      setAttributes({
        prefix: prefixX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onPickCssLibraryPostfix(args) {
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        postfix[sudoScource] = sudoScourceArgs;
      });
      var postfixX = Object.assign({}, postfix);
      setAttributes({
        postfix: postfixX
      });
      var styleObj = {};
      Object.entries(args).map(x => {
        var sudoScource = x[0];
        var sudoScourceArgs = x[1];
        var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
        var sudoObj = {};
        Object.entries(sudoScourceArgs).map(y => {
          var cssPropty = y[0];
          var cssProptyVal = y[1];
          var cssProptyKey = myStore.cssAttrParse(cssPropty);
          sudoObj[cssProptyKey] = cssProptyVal;
        });
        styleObj[elementSelector] = sudoObj;
      });
      var cssItems = Object.assign(blockCssY.items, styleObj);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStyleArchiveTitle(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, archiveTitle);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        archiveTitle: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleArchiveTitle(sudoScource, key) {
      var object = myStore.deletePropertyDeep(archiveTitle, [sudoScource, key, breakPointX]);
      setAttributes({
        archiveTitle: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleArchiveTitle(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, archiveTitle);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        archiveTitle: object
      });
    }

    function onChangeStyleIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(icon, [sudoScource, key, breakPointX]);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        icon: object
      });
    }

    function onChangeStylePrefix(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, prefix);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        prefix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStylePrefix(sudoScource, key) {
      var object = myStore.deletePropertyDeep(prefix, [sudoScource, key, breakPointX]);
      setAttributes({
        prefix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, prefixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStylePrefix(sudoScource, key) {
      var sudoScourceX = { ...prefix[sudoScource]
      };
      sudoScourceX[key] = {};
      prefix[sudoScource] = sudoScourceX;
      setAttributes({
        prefix: { ...prefix
        }
      });
    }

    function onChangeStylePostfix(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, postfix);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        postfix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStylePostfix(sudoScource, key) {
      var object = myStore.deletePropertyDeep(postfix, [sudoScource, key, breakPointX]);
      setAttributes({
        postfix: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, postfixSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStylePostfix(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, postfix);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        postfix: object
      });
    }

    function onBulkAddWrapper(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, wrapper);
      obj[sudoScource] = cssObj;
      setAttributes({
        wrapper: obj
      });
      var selector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onBulkAddArchiveTitle(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, archiveTitle);
      obj[sudoScource] = cssObj;
      setAttributes({
        archiveTitle: obj
      });
      var selector = myStore.getElementSelector(sudoScource, archiveTitleSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onBulkAddIcon(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, icon);
      obj[sudoScource] = cssObj;
      setAttributes({
        icon: obj
      });
      var selector = myStore.getElementSelector(sudoScource, iconSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onBulkAddPrefix(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, prefix);
      obj[sudoScource] = cssObj;
      setAttributes({
        prefix: obj
      });
      var selector = myStore.getElementSelector(sudoScource, prefixSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onBulkAddPostfix(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, postfix);
      obj[sudoScource] = cssObj;
      setAttributes({
        postfix: obj
      });
      var selector = myStore.getElementSelector(sudoScource, postfixSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    String.prototype.strtr = function (dic) {
      const str = this.toString(),
            makeToken = inx => `{{###~${inx}~###}}`,
            tokens = Object.keys(dic).map((key, inx) => ({
        key,
        val: dic[key],
        token: makeToken(inx)
      })),
            tokenizedStr = tokens.reduce((carry, entry) => carry.replace(new RegExp(entry.key, "g"), entry.token), str);

      return tokens.reduce((carry, entry) => carry.replace(new RegExp(entry.token, "g"), entry.val), tokenizedStr);
    };

    const [iconHtml, setIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('');
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      var iconSrc = icon.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      console.log(iconHtml);
      setIconHtml(iconHtml);
    }, [icon]);
    const [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_5__.useEntityProp)('postType', postType, 'link', postId);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      }); // setAttributes({ archiveTitle: archiveTitle });
      // setAttributes({ wrapper: wrapper });

      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      customTags['currentYear'] = '2022';
      customTags['currentMonth'] = '07';
      customTags['currentDay'] = '27';
      customTags['currentDate'] = '27';
      customTags['currentTime'] = '27';
      customTags['postPublishDate'] = '123';
      customTags['postModifiedDate'] = '123';
      customTags['termId'] = '';
      customTags['termTitle'] = '';
      customTags['termDescription'] = '';
      customTags['termPostCount'] = '';
      customTags['postTagTitle'] = 'First Tag Title';
      customTags['postTagsTitle'] = 'First Tag Title';
      customTags['postCategoryTitle'] = 'First Category Title';
      customTags['postCategoriesTitle'] = 'First Categories Title';
      customTags['postTermTitle'] = 'First Term Title';
      customTags['postTermsTitle'] = 'List of all terms title';
      customTags['postId'] = '123';
      customTags['postStatus'] = '123';
      customTags['authorId'] = '123';
      customTags['authorName'] = 'Nur Hasan';
      customTags['authorFirstName'] = 'Nur';
      customTags['authorLastName'] = 'Hasan';
      customTags['authorDescription'] = 'Hasan';
      customTags['excerpt'] = 'Here is the post excerpt';
      customTags['rankmathTitle'] = 'Hasan';
      customTags['rankmathPermalink'] = 'Hasan';
      customTags['rankmathExcerpt'] = 'Hasan';
      customTags['rankmathFocusKeyword'] = 'Hasan';
      customTags['rankmathFocusKeywords'] = 'Hasan';
      customTags['rankmathOrgname'] = 'Hasan';
      customTags['rankmathOrgurl'] = 'Hasan';
      customTags['rankmathOrglogo'] = 'Hasan';
      customTags['siteTitle'] = '';
      customTags['siteDescription'] = '';
      customTags['siteTagline'] = '';
      customTags['postMeta'] = '';
      customTags['separator'] = '';
      customTags['searchTerms'] = '';
      customTags['counter'] = '1';
    }, [clientId]); // Wrapper CSS Class Selectors

    const wrapperSelector = blockClass;
    var archiveTitleSelector = '';

    if (wrapper.options.tag.length != 0) {
      if (archiveTitle.options.linkTo.length > 0) {
        archiveTitleSelector = blockClass + ' a';
      } else {
        archiveTitleSelector = blockClass; //archiveTitleSelector = blockClass + ' .archiveTitle';
      }
    } else {
      archiveTitleSelector = blockClass;
    }

    const prefixSelector = blockClass + ' .prefix';
    const postfixSelector = blockClass + ' .postfix';
    const iconSelector = blockClass + ' .postdate-icon'; // var breakPointList = [{ label: 'Select..', icon: '', value: '' }];
    // for (var x in breakPoints) {
    //   var item = breakPoints[x];
    //   breakPointList.push({ label: item.name, icon: item.icon, value: item.id })
    // }

    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }

    var [linkAttrItems, setlinkAttrItems] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({}); // Using the hook.

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      linkAttrObj();
    }, [archiveTitle]);

    var linkAttrObj = () => {
      var sdsd = {};
      archiveTitle.options.linkAttr.map(x => {
        if (x.val) sdsd[x.id] = x.val;
      });
      setlinkAttrItems(sdsd);
    };

    var postUrl = archiveTitle.options.customUrl != undefined && archiveTitle.options.customUrl.length > 0 ? archiveTitle.options.customUrl : currentPostUrl;
    const CustomTag = `${wrapper.options.tag}`;
    const CustomTagPostTitle = `${archiveTitle.options.tag}`;
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps)({
      className: ` ${blockId} pg-archive-title`
    });
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: {
            styles: wrapper.styles,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper,
      onBulkAdd: onBulkAddWrapper
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_23__["default"], {
      blockId: blockId,
      obj: wrapper,
      onChange: onPickCssLibraryWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Archive Title",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Archive Type"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_17__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: archiveTypes,
      buttonTitle: "Choose",
      onChange: (option, index) => {
        var options = { ...archiveTitle.options,
          archiveType: option.value
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      },
      values: ''
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "bg-gray-500 text-white p-3 py-2"
    }, archiveTypes[archiveTitle.options.archiveType].label), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Label"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      className: "mr-2",
      value: archiveTitle.options.customLabel,
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          customLabel: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), (archiveTitle.options.archiveType == 'year' || archiveTitle.options.archiveType == 'month' || archiveTitle.options.archiveType == 'day') && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Date Format"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_17__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: dateFormats,
      buttonTitle: "Choose",
      onChange: (option, index) => {
        var options = { ...archiveTitle.options,
          dateFormat: option.value
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      },
      values: ''
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Format"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      className: "mr-2",
      value: archiveTitle.options.dateFormat,
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          dateFormat: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), dateFormats[archiveTitle.options.dateFormat] != undefined && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "p-2 my-3 bg-gray-500 text-white"
    }, dateFormats[archiveTitle.options.dateFormat].label)), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Link To"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_17__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: archiveLinkToArgs,
      buttonTitle: archiveTitle.options.linkTo.length == 0 ? 'Choose' : archiveLinkToArgs[archiveTitle.options.linkTo].label,
      onChange: setFieldLinkTo,
      values: []
    })), archiveTitle.options.linkTo == 'customUrl' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom URL"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.Button, {
      className: linkPickerPosttitle ? "!bg-gray-400" : '',
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
      onClick: ev => {
        setLinkPickerPosttitle(prev => !prev);
      }
    }), archiveTitle.options.customUrl.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.Button, {
      className: "!text-red-500 ml-2",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
      onClick: ev => {
        var options = { ...archiveTitle.options,
          customUrl: ''
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
        setLinkPickerPosttitle(false);
      }
    }), linkPickerPosttitle && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.Popover, {
      position: "bottom right"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.__experimentalLinkControl, {
      settings: [],
      value: archiveTitle.options.customUrl,
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          customUrl: newVal.url
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "p-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: "font-bold"
    }, "Linked to:"), " ", archiveTitle.options.customUrl.length != 0 ? archiveTitle.options.customUrl : 'No link', " ")))), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.SelectControl, {
      label: "",
      value: archiveTitle.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          tag: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Link Target"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.SelectControl, {
      label: "",
      value: archiveTitle.options.linkTarget,
      options: [{
        label: 'Choose...',
        value: ''
      }, {
        label: '_self',
        value: '_self'
      }, {
        label: '_blank',
        value: '_blank'
      }, {
        label: '_parent',
        value: '_parent'
      }, {
        label: '_top',
        value: '_top'
      }],
      onChange: newVal => {
        var options = { ...archiveTitle.options,
          linkTarget: newVal
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Custom Attributes"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: " cursor-pointer px-3 text-white py-1 bg-blue-600",
      onClick: ev => {
        var sdsd = archiveTitle.options.linkAttr.concat({
          id: '',
          val: ''
        });
        var options = { ...archiveTitle.options,
          linkAttr: sdsd
        };
        setAttributes({
          archiveTitle: { ...archiveTitle,
            options: options
          }
        });
        linkAttrObj();
      }
    }, "Add")), archiveTitle.options.linkAttr.map((x, i) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
        className: "my-2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Name",
        value: archiveTitle.options.linkAttr[i].id,
        onChange: newVal => {
          archiveTitle.options.linkAttr[i].id = newVal;
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = { ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: { ...archiveTitle,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Value",
        value: x.val,
        onChange: newVal => {
          archiveTitle.options.linkAttr[i].val = newVal;
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = { ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: { ...archiveTitle,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
        className: "text-lg cursor-pointer px-3 text-white py-1 bg-red-400 icon-close",
        onClick: ev => {
          archiveTitle.options.linkAttr.splice(i, 1);
          var ssdsd = archiveTitle.options.linkAttr.concat([]);
          var options = { ...archiveTitle.options,
            linkAttr: ssdsd
          };
          setAttributes({
            archiveTitle: { ...archiveTitle,
              options: options
            }
          });
        }
      })));
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: archiveTitle,
      onChange: onChangeStyleArchiveTitle,
      onAdd: onAddStyleArchiveTitle,
      onRemove: onRemoveStyleArchiveTitle,
      onBulkAdd: onBulkAddArchiveTitle
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_23__["default"], {
      blockId: blockId,
      obj: archiveTitle,
      onChange: onPickCssLibraryArchiveTitle
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_18__["default"], {
      library: icon.options.library,
      srcType: icon.options.srcType,
      iconSrc: icon.options.iconSrc,
      onChange: onChangeIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Icon postion"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: 'Choose Position',
        value: ''
      }, {
        label: 'Before Archive Title',
        value: 'beforeArchiveTitle'
      }, {
        label: 'After Archive Title',
        value: 'afterArchiveTitle'
      }, {
        label: 'Before Prefix',
        value: 'beforePrefix'
      }, {
        label: 'After Prefix',
        value: 'afterPrefix'
      }, {
        label: 'Before Postfix',
        value: 'beforePostfix'
      }, {
        label: 'After Postfix',
        value: 'afterPostfix'
      }],
      onChange: newVal => {
        var options = { ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon,
      onBulkAdd: onBulkAddIcon
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_23__["default"], {
      blockId: blockId,
      obj: icon,
      onChange: onPickCssLibraryIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Prefix",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Prefix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      value: prefix.options.text,
      onChange: newVal => {
        var options = { ...prefix.options,
          text: newVal
        };
        setAttributes({
          prefix: {
            styles: prefix.styles,
            options: options
          }
        }); // setAttributes({ prefix: { text: newVal, class: prefix.options.class, color: prefix.color, backgroundColor: prefix.backgroundColor } })
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: prefix,
      onChange: onChangeStylePrefix,
      onAdd: onAddStylePrefix,
      onRemove: onRemoveStylePrefix,
      onBulkAdd: onBulkAddPrefix
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_23__["default"], {
      blockId: blockId,
      obj: prefix,
      onChange: onPickCssLibraryPrefix
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Postfix",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }, {
        name: 'css',
        title: 'CSS Library',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-css'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("label", {
      for: ""
    }, "Postfix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      value: postfix.options.text,
      onChange: newVal => {
        var options = { ...postfix.options,
          text: newVal
        };
        setAttributes({
          postfix: { ...postfix,
            options: options
          }
        }); // setAttributes({ postfix: { text: newVal, class: prefix.options.class, color: postfix.color, backgroundColor: postfix.backgroundColor } })
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_22__["default"], {
      obj: postfix,
      onChange: onChangeStylePostfix,
      onAdd: onAddStylePostfix,
      onRemove: onRemoveStylePostfix,
      onBulkAdd: onBulkAddPostfix
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_21__["default"], {
      name: "css"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_css_library__WEBPACK_IMPORTED_MODULE_23__["default"], {
      blockId: blockId,
      obj: postfix,
      onChange: onPickCssLibraryPostfix
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Title Wrapper"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, wrapperSelector, '{/* your CSS here*/}'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Title link"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, archiveTitleSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Prefix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, prefixSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", {
      className: "font-bold"
    }, "Postfix"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("code", null, postfixSelector, '{/* your CSS here*/}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", {
      className: "px-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_14__["default"], {
      utm: {
        utm_source: 'BlockPostTitle',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, wrapper.options.tag && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(CustomTag, blockProps, icon.options.position == 'beforePrefix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: prefix.options.class
    }, prefix.options.text), icon.options.position == 'afterPrefix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("a", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      className: "archiveTitle",
      onClick: handleLinkClick
    }, linkAttrItems, {
      target: archiveTitle.options.linkTarget,
      href: postUrl
    }), icon.options.position == 'beforeArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == 'afterArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, icon.options.position == 'beforeArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == 'afterArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), postfix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: postfix.options.class
    }, postfix.options.text), icon.options.position == 'afterPostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), wrapper.options.tag.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefix.options.text && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: prefix.options.class
    }, prefix.options.text), icon.options.position == 'beforePostfix' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitle.options.linkTo.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("a", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      className: "archiveTitle",
      onClick: handleLinkClick
    }, linkAttrItems, {
      target: archiveTitle.options.linkTarget,
      href: postUrl
    }), "A", icon.options.position == 'beforeArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == 'afterArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })), archiveTitle.options.linkTo.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("div", blockProps, icon.options.position == 'beforeArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), archiveTitleEdited, icon.options.position == 'afterArchiveTitle' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)("span", {
      className: icon.options.class,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })))));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/breadcrumb/index.js":
/*!****************************************!*\
  !*** ./src/blocks/breadcrumb/index.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/menu.js");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_css_display__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/css-display */ "./src/components/css-display/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");

















const {
  RawHTML
} = wp.element;













var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)("post-grid/breadcrumb", {
  apiVersion: 2,
  title: "Breadcrumb",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#fff',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      fill: "#1d4ed8",
      d: "M17.55,18a.71.71,0,0,1-.24.53L12.45,22.7a.7.7,0,0,1-.91-1.06L15.79,18l-4.25-3.64a.7.7,0,0,1,.91-1.06l4.86,4.17A.71.71,0,0,1,17.55,18Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      fill: "#1d4ed8",
      d: "M36,18a.69.69,0,0,1-.25.53L30.89,22.7a.7.7,0,1,1-.9-1.06L34.23,18,30,14.36a.7.7,0,1,1,.9-1.06l4.86,4.17A.69.69,0,0,1,36,18Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      y: "15.5",
      width: "10.66",
      height: "5"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#8db1ff",
      x: "2.49",
      y: "17.34",
      width: "5.68",
      height: "1.32"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "19.08",
      y: "15.5",
      width: "10.66",
      height: "5"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#8db1ff",
      x: "21.57",
      y: "17.34",
      width: "5.68",
      height: "1.32"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    icon: {
      type: 'object',
      default: {
        options: {
          class: 'icon',
          position: 'beforeLabel'
          /*beforeLabel, afterLabel, beforeSeparator, afterSeparator*/

        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    label: {
      type: 'object',
      default: {
        options: {
          class: ''
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    separator: {
      type: 'object',
      default: {
        options: {
          class: '',
          text: '»'
        },
        styles: {
          color: {
            Desktop: ''
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          }
        }
      }
    },
    elements: {
      "type": "object",
      "default": {
        options: {
          linkTarget: '_blank',
          showLabel: true,
          showSeparator: true,
          showIcon: false,
          iconPositon: 'beforeLabel' // beforeLabel, afterLabel, beforeSeparator, afterSeparator

        },
        styles: {
          color: {
            Desktop: '#18978F'
          },
          backgroundColor: {
            Desktop: ''
          },
          padding: {
            Desktop: ''
          },
          margin: {
            Desktop: ''
          },
          borderRadius: {
            Desktop: ''
          },
          fontSize: {
            Desktop: ''
          }
        },
        items: [{
          id: 'text',
          label: 'Text',
          customText: '',
          url: '',
          siteIcon: {
            library: 'fontAwesome',
            srcType: "class",

            /*class, html, img, svg */
            iconSrc: ''
          },
          options: {
            text: 'You are here: ',
            showSeparator: true
          },
          styles: {
            color: {
              Desktop: ''
            },
            backgroundColor: {
              Desktop: ''
            },
            padding: {
              Desktop: ''
            },
            margin: {
              Desktop: ''
            }
          }
        }, {
          id: 'homePage',
          label: 'Home Page Link',
          customText: '',
          url: '',
          siteIcon: {
            library: 'fontAwesome',
            srcType: "class",

            /*class, html, img, svg */
            iconSrc: ''
          },
          options: {
            showSeparator: true
          },
          styles: {
            color: {
              Desktop: ''
            },
            backgroundColor: {
              Desktop: ''
            },
            padding: {
              Desktop: ''
            },
            margin: {
              Desktop: ''
            }
          }
        }, {
          id: 'postTitle',
          label: 'Post Title',
          customText: '',
          url: '',
          siteIcon: {
            library: 'fontAwesome',
            srcType: "class",

            /*class, html, img, svg */
            iconSrc: ''
          },
          options: {
            showSeparator: true
          },
          styles: {
            color: {
              Desktop: ''
            },
            backgroundColor: {
              Desktop: ''
            },
            padding: {
              Desktop: ''
            },
            margin: {
              Desktop: ''
            }
          }
        }]
      } // avatar, name, description, id

    },
    schema: {
      type: 'object',
      default: {
        options: {
          enable: true
        }
      }
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var wrapper = attributes.wrapper;
    var elements = attributes.elements;
    var icon = attributes.icon;
    var label = attributes.label;
    var separator = attributes.separator;
    var schema = attributes.schema;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType'];
    var wrapperSelector = blockClass; // Wrapper CSS Class Selectors

    var itemSelector = blockClass + ' .item';
    var itemLinkSelector = blockClass + ' .item a';
    var iconSelector = blockClass + ' .item .icon';
    var labelSelector = blockClass + ' .item .label';
    var separatorSelector = blockClass + ' .item .separator';
    var [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(myStore.getBreakPoint());
    var [loading, setLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    var [currentPostUrl, setCurrentPostUrl] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_7__.useEntityProp)('postType', postType, 'link', postId);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      });
      ;
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
        'font-size': {
          "Desktop": "16px"
        }
      };
      blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
        'display': {
          "Desktop": "inline-block"
        }
      };
      blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
        'list-style': {
          "Desktop": "none"
        }
      };
      blockCssY.items[itemSelector] = { ...blockCssY.items[itemSelector],
        'margin-right': {
          "Desktop": "10px"
        }
      };
      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      });
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      elements.items.map((x, index) => {
        var styles = x.styles;
        Object.entries(styles).map(y => {
          var attrId = y[0];
          var attrVal = y[1];

          if (Object.keys(attrVal).length != 0) {
            var attrIdX = '';

            if (attrId == 'backgroundColor') {
              attrIdX = 'background-color';
            } else if (attrId == 'textAlign') {
              attrIdX = 'text-align';
            } else {
              attrIdX = attrId;
            }

            if (blockCssY.items[itemSelector + '.item-' + index + ' a'] == undefined) {
              blockCssY.items[itemSelector + '.item-' + index + ' a'] = {};
              blockCssY.items[itemSelector + '.item-' + index + ' a'][attrIdX] = attrVal;
            } else {
              blockCssY.items[itemSelector + '.item-' + index + ' a'][attrIdX] = attrVal;
            }

            if (blockCssY.items[itemSelector + '.item-' + index] == undefined) {
              blockCssY.items[itemSelector + '.item-' + index] = {};
              blockCssY.items[itemSelector + '.item-' + index][attrIdX] = attrVal;
            } else {
              blockCssY.items[itemSelector + '.item-' + index][attrIdX] = attrVal;
            }

            setAttributes({
              blockCssY: {
                items: blockCssY.items
              }
            });
          }
        });
      });
      setTimeout(x => {//setAttributes({ blockCssY: { items: newValuesObjX } });
      }, 2000);
    }, [elements]);
    var linkElementsArgsBasic = [{
      id: 'text',
      label: 'Text',
      customText: 'You are here: ',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        text: 'You are here: ',
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'homePage',
      label: 'Home Page Link',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'frontPage',
      label: 'Front Page Link',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postsPage',
      label: 'Posts Page Link',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postTitle',
      label: 'Post Title',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postAuthor',
      label: 'Post Author',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postDate',
      label: 'Post Date',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        format: 'Y-m-d',
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postDay',
      label: 'Post Day',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        format: '',
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postMonth',
      label: 'Post Month',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        format: '',
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postYear',
      label: 'Post Year',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        format: '',
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postAncestors',
      isPro: true,
      label: 'Post Ancestors',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true,
        count: ''
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postId',
      label: 'Post Id',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postCategory',
      label: 'Post Category',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postTag',
      label: 'Post Tag',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postCategories',
      isPro: true,
      label: 'Post Categories',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true,
        maxCount: 3
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postTags',
      isPro: true,
      label: 'Post Tags',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true,
        maxCount: 3
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postTerm',
      isPro: true,
      label: 'Post Term',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        taxonomy: '',
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'postTerms',
      isPro: true,
      label: 'Post Terms',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        taxonomy: '',
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'termTitle',
      label: 'Term Title',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'termParents',
      isPro: true,
      label: 'Term Parents',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true,
        count: 0
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'termAncestors',
      isPro: true,
      label: 'Term Ancestors',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        taxonomy: '',
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'wcShop',
      label: 'WooCommerce Shop',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'wcAccount',
      label: 'WooCommerce Account',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'wcCart',
      label: 'WooCommerce Cart',
      isPro: true,
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'wcCheckout',
      label: 'WooCommerce Checkout',
      isPro: true,
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'searchText',
      label: 'Search Text',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'archiveTitle',
      label: 'Archive Title',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: '404Text',
      label: '404 Text',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'dateText',
      label: 'Date Text',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true,
        format: 'Y-m-d'
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'monthText',
      label: 'Month Text',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true,
        format: 'Y-m'
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'yearText',
      label: 'Year Text',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true,
        format: 'Y'
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }, {
      id: 'authorName',
      label: 'Author Name',
      customText: '%s',
      url: '',
      siteIcon: {
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: ''
      },
      options: {
        showSeparator: true
      },
      styles: {
        color: {
          Desktop: ''
        },
        backgroundColor: {
          Desktop: ''
        },
        padding: {
          Desktop: ''
        },
        margin: {
          Desktop: ''
        }
      }
    }];
    let linkElementsArgs = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_9__.applyFilters)('linkElementsArgs', linkElementsArgsBasic);
    let isProFeature = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_9__.applyFilters)('isProFeature', true);

    function addMedia(option, index) {
      //var isExist = elements.items.find(x => x.label === option.label);
      //if (isExist == undefined) {
      //}
      var elementsX = elements.items.push(option);
      setAttributes({
        elements: { ...elements,
          items: elements.items
        }
      });
    }

    var breakPointList = [{
      label: 'Select..',
      icon: '',
      value: ''
    }];

    for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_10__["default"]) {
      var item = _breakpoints__WEBPACK_IMPORTED_MODULE_10__["default"][x];
      breakPointList.push({
        label: item.name,
        icon: item.icon,
        value: item.id
      });
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onChangeStyleElements(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, elements);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        elements: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleElements(sudoScource, key) {
      var object = myStore.deletePropertyDeep(elements, [sudoScource, key, breakPointX]);
      setAttributes({
        elements: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, itemSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleElements(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, elements);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        elements: object
      });
    }

    function onChangeStyleIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(icon, [sudoScource, key, breakPointX]);
      setAttributes({
        icon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, iconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, icon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        icon: object
      });
    }

    function onChangeStyleLabel(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, label);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        label: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleLabel(sudoScource, key) {
      var object = myStore.deletePropertyDeep(label, [sudoScource, key, breakPointX]);
      setAttributes({
        label: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleLabel(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, label);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        label: object
      });
    }

    function onChangeStyleSeparator(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, separator);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        separator: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, separatorSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleSeparator(sudoScource, key) {
      var object = myStore.deletePropertyDeep(separator, [sudoScource, key, breakPointX]);
      setAttributes({
        separator: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, separatorSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleSeparator(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, separator);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        separator: object
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);

    function onChangeBreakPoint(x, index) {
      var asdsdsd = wp.data.dispatch('postgrid-shop').setBreakPoint(x.value);
      asdsdsd.then(res => {
        setBreakPointX(res.breakpoint);
        myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      });
    }

    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3__.useBlockProps)({
      className: ` ${blockId} pg-breadcrumb`
    });
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: { ...wrapper,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Items",
      initialOpen: true
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Add Element"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_15__["default"], {
      position: "bottom right",
      variant: "secondary",
      options: linkElementsArgs,
      buttonTitle: "Choose",
      onChange: addMedia,
      values: ""
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(react_sortablejs__WEBPACK_IMPORTED_MODULE_4__.ReactSortable, {
      list: elements.items,
      handle: '.handle',
      setList: item => {
        setAttributes({
          elements: { ...elements,
            items: item
          }
        });
      }
    }, elements.items.map((item, index) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      key: item.id,
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "cursor-pointer hover:bg-red-500 hover:text-white px-1 py-1",
        onClick: ev => {
          var elementsX = elements.items.splice(index, 1);
          setAttributes({
            elements: { ...elements,
              items: elements.items
            }
          });
        }
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"], {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"]
      })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "handle cursor-pointer hover:bg-blue-500 hover:text-white px-1 py-1"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"], {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"]
      })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "mx-2"
      }, item.label)),
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Custom Label"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      value: item.customText,
      placeholder: "You Text: %s",
      onChange: newVal => {
        elements.items[index].customText = newVal;
        setAttributes({
          elements: { ...elements,
            items: elements.items
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Please use ", (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, "%s"), " for output")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Custom URL"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      value: item.url,
      onChange: newVal => {
        elements.items[index].url = newVal;
        setAttributes({
          elements: { ...elements,
            items: elements.items
          }
        });
      }
    })), (item.id == 'postTerms' || item.id == 'postTerm') && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Taxonomy"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      value: item.options.taxonomy,
      onChange: newVal => {
        elements.items[index].options.taxonomy = newVal;
        setAttributes({
          elements: { ...elements,
            items: elements.items
          }
        });
      }
    })), (item.id == 'termParents' || item.id == 'postAncestors') && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Max Count"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      value: item.options.count,
      onChange: newVal => {
        elements.items[index].options.count = newVal;
        setAttributes({
          elements: { ...elements,
            items: elements.items
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Use ", (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, "-"), " (negetive sign) to count from end."))), (item.id == 'dateText' || item.id == 'monthText' || item.id == 'yearText' || item.id == 'postDate' || item.id == 'postDay' || item.id == 'postMonth' || item.id == 'postYear') && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Date Format"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      value: item.options.format,
      onChange: newVal => {
        elements.items[index].options.format = newVal;
        setAttributes({
          elements: { ...elements,
            items: elements.items
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_20__["default"], {
      library: item.siteIcon.library,
      srcType: item.siteIcon.srcType,
      iconSrc: item.siteIcon.iconSrc,
      onChange: arg => {
        //var options = { ...icon.options, srcType: arg.srcType, library: arg.library, iconSrc: arg.iconSrc };
        //setAttributes({ icon: { ...icon, options: options } });
        elements.items[index].siteIcon = {
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          elements: { ...elements,
            items: elements.items
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", null, "Color"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_toggle__WEBPACK_IMPORTED_MODULE_12__["default"], {
      position: "bottom",
      variant: "secondary",
      iconList: breakPointList,
      buttonTitle: "Break Point Switch",
      onChange: onChangeBreakPoint,
      activeIcon: _breakpoints__WEBPACK_IMPORTED_MODULE_10__["default"][breakPointX].icon,
      value: breakPointX
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.ColorPalette, {
      value: elements.items[index].styles.color == undefined ? '' : elements.items[index].styles.color[breakPointX],
      colors: _colors_presets__WEBPACK_IMPORTED_MODULE_14__["default"],
      enableAlpha: true,
      onChange: newVal => {
        var newValuesObj = {};

        if (Object.keys(elements.items[index].styles.color).length == 0) {
          newValuesObj[breakPointX] = newVal;
        } else {
          newValuesObj = elements.items[index].styles.color;
          newValuesObj[breakPointX] = newVal;
        }

        var styles = { ...elements.items[index].styles,
          color: newValuesObj
        };
        elements.items[index].styles = styles;
        setAttributes({
          elements: { ...elements,
            items: elements.items
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", null, "Background Color"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_toggle__WEBPACK_IMPORTED_MODULE_12__["default"], {
      position: "bottom",
      variant: "secondary",
      iconList: breakPointList,
      buttonTitle: "Break Point Switch",
      onChange: onChangeBreakPoint,
      activeIcon: _breakpoints__WEBPACK_IMPORTED_MODULE_10__["default"][breakPointX].icon,
      value: breakPointX
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.ColorPalette, {
      value: elements.items[index].styles.backgroundColor == undefined ? '' : elements.items[index].styles.backgroundColor[breakPointX],
      colors: _colors_presets__WEBPACK_IMPORTED_MODULE_14__["default"],
      enableAlpha: true,
      onChange: newVal => {
        var newValuesObj = {};

        if (Object.keys(elements.items[index].styles.backgroundColor).length == 0) {
          newValuesObj[breakPointX] = newVal;
        } else {
          newValuesObj = elements.items[index].styles.backgroundColor;
          newValuesObj[breakPointX] = newVal;
        }

        var styles = { ...elements.items[index].styles,
          backgroundColor: newValuesObj
        };
        elements.items[index].styles = styles;
        setAttributes({
          elements: { ...elements,
            items: elements.items
          }
        }); // var newValuesObjX = {};
        // if (blockCssY.items[itemSelector] == undefined) {
        //   newValuesObjX[itemSelector] = { ...blockCssY.items[itemSelector], 'background-color': newValuesObj };
        // } else {
        //   newValuesObjX[itemSelector] = { ...blockCssY.items[itemSelector], 'background-color': newValuesObj };
        // }
        //setAttributes({ blockCssY: { items: newValuesObjX } });
      }
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.ToggleControl, {
      className: "my-3",
      label: "Display Label?",
      help: elements.options.showLabel ? 'Label is displaying' : 'Label is hidden',
      checked: elements.options.showLabel ? true : false,
      onChange: e => {
        var options = { ...elements.options,
          showLabel: elements.options.showLabel ? false : true
        };
        setAttributes({
          elements: { ...elements,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.ToggleControl, {
      className: "my-3",
      disabled: isProFeature,
      label: "Display Icon?",
      help: elements.options.showIcon ? 'Icon is displaying' : 'Icon is hidden',
      checked: elements.options.showIcon ? true : false,
      onChange: e => {
        var options = { ...elements.options,
          showIcon: elements.options.showIcon ? false : true
        };
        setAttributes({
          elements: { ...elements,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, isProFeature && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "bg-amber-400 rounded-sm py-1 px-3  text-white hover:text-white"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      target: "_blank",
      href: 'https://pickplugins.com/post-grid/?utm_source=dropdownComponent&utm_term=proFeature&utm_campaign=pluginPostGrid&utm_medium=' + x.label
    }, "Pro")))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.ToggleControl, {
      className: "my-3",
      label: "Display Separator?",
      help: elements.options.showSeparator ? 'Separator is displaying' : 'Separator is hidden',
      checked: elements.options.showSeparator ? true : false,
      onChange: e => {
        var options = { ...elements.options,
          showSeparator: elements.options.showSeparator ? false : true
        };
        setAttributes({
          elements: { ...elements,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: elements,
      onChange: onChangeStyleElements,
      onAdd: onAddStyleElements,
      onRemove: onRemoveStyleElements
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Icon position"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.SelectControl, {
      label: "",
      value: icon.options.position,
      options: [{
        label: 'Choose Position',
        value: ''
      }, {
        label: 'Before Label',
        value: 'beforeLabel'
      }, {
        label: 'After Label',
        value: 'afterLabel'
      }, {
        label: 'Before Separator',
        value: 'beforeSeparator'
      }, {
        label: 'After Separator',
        value: 'afterSeparator'
      }],
      onChange: newVal => {
        var options = { ...icon.options,
          position: newVal
        };
        setAttributes({
          icon: { ...icon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: icon,
      onChange: onChangeStyleIcon,
      onAdd: onAddStyleIcon,
      onRemove: onRemoveStyleIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Label",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: label,
      onChange: onChangeStyleLabel,
      onAdd: onAddStyleLabel,
      onRemove: onRemoveStyleLabel
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Separator",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Separator Text"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.__experimentalInputControl, {
      value: separator.options.text,
      onChange: newVal => {
        var options = { ...separator.options,
          text: newVal
        };
        setAttributes({
          separator: { ...separator,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_22__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_23__["default"], {
      obj: separator,
      onChange: onChangeStyleSeparator,
      onAdd: onAddStyleSeparator,
      onRemove: onRemoveStyleSeparator
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Schema",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.ToggleControl, {
      label: "Enable Schema?",
      help: schema.options.enable ? 'Schema Enabled' : 'Schema Disabled.',
      checked: schema.options.enable ? true : false,
      onChange: e => {
        var options = { ...schema.options,
          enable: schema.options.enable ? false : true
        };
        setAttributes({
          schema: { ...schema,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Wrapper Selector"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, wrapperSelector, '{/* your CSS here*/}'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Item Selector"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, itemSelector, '{}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_8__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_17__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_18__["default"], {
      utm: {
        utm_source: 'BlockPostExcerpt',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", blockProps, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("ol", null, elements.items.map((x, index) => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
        className: 'item item-' + index
      }, x.url.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        href: x.url
      }, elements.options.showIcon && icon.options.position == 'beforeLabel' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      }), elements.options.showLabel && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "label"
      }, x.customText.length > 0 ? x.customText : x.label), elements.options.showIcon && icon.options.position == 'afterLabel' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      })), x.url.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, elements.options.showIcon && icon.options.position == 'beforeLabel' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      }), elements.options.showLabel && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "label"
      }, x.customText.length > 0 ? x.customText : x.label), elements.options.showIcon && icon.options.position == 'afterLabel' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      })), elements.options.showSeparator && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, elements.options.showIcon && icon.options.position == 'beforeSeparator' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      }), elements.items.length > index && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        class: "separator"
      }, separator.options.text), elements.options.showIcon && icon.options.position == 'afterSeparator' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: `icon ${x.siteIcon.iconSrc}`
      })));
    }))));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    return null;
  }
});

/***/ }),

/***/ "./src/blocks/content-slider-item/index.js":
/*!*************************************************!*\
  !*** ./src/blocks/content-slider-item/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");













const {
  RawHTML
} = wp.element;













var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)("post-grid/content-slider-item", {
  apiVersion: 2,
  title: "Content Slider Item",
  parent: ['post-grid/content-slider'],
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#fff',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      y: "10.4",
      width: "7.49",
      height: "15.2"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "28.51",
      y: "10.4",
      width: "7.49",
      height: "15.2"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("polygon", {
      fill: "#1d4ed8",
      points: "25.18 26.5 22.47 26.5 22.47 24.7 23.37 24.7 23.37 23.79 25.18 23.79 25.18 26.5"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "16.51",
      y: "24.69",
      width: "2.98",
      height: "1.81"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("polygon", {
      fill: "#1d4ed8",
      points: "13.53 26.5 10.82 26.5 10.82 23.79 12.63 23.79 12.63 24.7 13.53 24.7 13.53 26.5"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "10.82",
      y: "16.07",
      width: "1.81",
      height: "3.86"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("polygon", {
      fill: "#1d4ed8",
      points: "12.63 12.21 10.82 12.21 10.82 9.5 13.53 9.5 13.53 11.3 12.63 11.3 12.63 12.21"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "16.51",
      y: "9.5",
      width: "2.98",
      height: "1.81"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("polygon", {
      fill: "#1d4ed8",
      points: "25.18 12.21 23.37 12.21 23.37 11.3 22.47 11.3 22.47 9.5 25.18 9.5 25.18 12.21"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "23.37",
      y: "16.07",
      width: "1.81",
      height: "3.86"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: 'flex-item-wrap'
        },
        styles: {}
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var wrapper = attributes.wrapper;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType']; //const [breakPointX, setBreakPointX] = useState(myStore.getBreakPoint());

    var breakPointX = myStore.getBreakPoint(); // Wrapper CSS Class Selectors

    var wrapperSelector = blockClass;
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);

    function generateElementSudoCss(obj) {
      var stylesObj = {};
      Object.entries(obj).map(args => {
        var sudoSrc = args[0];
        var sudoArgs = args[1];

        if (sudoSrc != 'options') {
          var selector = myStore.getElementSelector(sudoSrc, wrapperSelector); //console.log(selector);
          //console.log(sudoArgs);

          Object.entries(args[1]).map(x => {
            var attr = x[0];
            var cssPropty = myStore.cssAttrParse(attr);

            if (stylesObj[selector] == undefined) {
              stylesObj[selector] = {};
            }

            if (stylesObj[selector][cssPropty] == undefined) {
              stylesObj[selector][cssPropty] = {};
            }

            stylesObj[selector][cssPropty] = x[1];
          });
        } //console.log(stylesObj);

      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      }; //console.log(cssItemsX);

      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      //console.log(wrapper);
      //setAttributes({ customCss: customCss });
      ///myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      var elementCss = generateElementSudoCss(wrapper); //console.log(elementCss);
    }, [wrapper]); // var breakPointList = [{ label: 'Select..', icon: '', value: '' }];
    // for (var x in breakPoints) {
    //   var item = breakPoints[x];
    //   breakPointList.push({ label: item.name, icon: item.icon, value: item.id })
    // }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onBulkAddWrapper(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, wrapper);
      obj[sudoScource] = cssObj;
      setAttributes({
        wrapper: obj
      });
      var selector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    const MY_TEMPLATE = [//['core/paragraph', { placeholder: '', content: 'Hello Text...' }],
    ];
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps)({
      className: ` ${blockId} pg-content-slider-item splide__slide border border-dashed`
    }); //const isParentOfSelectedBlock = useSelect((select) => select('core/block-editor').hasSelectedInnerBlock(clientId, true))

    const innerBlocksProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useInnerBlocksProps)(blockProps, {
      //allowedBlocks: ALLOWED_BLOCKS,
      template: MY_TEMPLATE,
      //orientation: 'horizontal',
      templateInsertUpdatesSelection: true,
      renderAppender: _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InnerBlocks.ButtonBlockAppender
    });
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InspectorControls, {
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_16__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: { ...wrapper,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_18__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper,
      onBulkAdd: onBulkAddWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Text "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, wrapperSelector, '{}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_13__["default"], {
      utm: {
        utm_source: 'BlockText',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", innerBlocksProps, innerBlocksProps.children));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    var attributes = props.attributes;
    var wrapper = attributes.wrapper;
    var blockId = attributes.blockId;
    const blockProps = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps.save({
      className: ` ${blockId} pg-content-slider-item`
    });
    const {
      children,
      ...innerBlocksProps
    } = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useInnerBlocksProps.save(blockProps);
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, children);
  }
});

/***/ }),

/***/ "./src/blocks/content-slider/index.js":
/*!********************************************!*\
  !*** ./src/blocks/content-slider/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _splidejs_react_splide__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @splidejs/react-splide */ "./node_modules/@splidejs/react-splide/dist/js/react-splide.esm.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _variations__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./variations */ "./src/blocks/content-slider/variations.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _splidejs_splide_dist_css_splide_core_min_css__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @splidejs/splide/dist/css/splide-core.min.css */ "./node_modules/@splidejs/splide/dist/css/splide-core.min.css");


















const {
  RawHTML
} = wp.element;















 //import Splide from '@splidejs/splide';

 //import '@splidejs/splide/dist/css/themes/splide-skyblue.min.css';

var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)("post-grid/content-slider", {
  apiVersion: 2,
  title: "Content Slider",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#fff',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      y: "9.59",
      width: "8.29",
      height: "16.82"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "27.71",
      y: "9.59",
      width: "8.29",
      height: "16.82"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "11.05",
      y: "9.59",
      width: "13.9",
      height: "16.82"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          class: ''
        },
        styles: {}
      }
    },
    navsWrap: {
      type: 'object',
      default: {
        options: {
          class: 'nav-wrap'
        },
        styles: {}
      }
    },
    perv: {
      type: 'object',
      default: {
        options: {
          text: 'Prev',
          class: ''
        },
        styles: {}
      }
    },
    pervIcon: {
      type: 'object',
      default: {
        options: {
          position: 'before',
          class: '',
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'fas fa-chevron-left'
        },
        styles: {}
      }
    },
    next: {
      type: 'object',
      default: {
        options: {
          text: 'Next',
          class: ''
        },
        styles: {}
      }
    },
    nextIcon: {
      type: 'object',
      default: {
        options: {
          position: 'after',
          class: '',
          library: 'fontAwesome',
          srcType: "class",

          /*class, html, img, svg */
          iconSrc: 'fas fa-chevron-right'
        },
        styles: {}
      }
    },
    paginationWrap: {
      type: 'object',
      default: {
        options: {
          tag: 'ul',
          class: ''
        },
        styles: {}
      }
    },
    pagination: {
      type: 'object',
      default: {
        options: {
          tag: 'span',
          class: ''
        },
        styles: {}
      }
    },
    paginationActive: {
      type: 'object',
      default: {
        options: {
          class: ''
        },
        styles: {}
      }
    },
    sliderOptions: {
      type: 'object',
      default: {}
    },
    sliderOptionsRes: {
      type: 'object',
      default: {}
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var wrapper = attributes.wrapper;
    var perv = attributes.perv;
    var next = attributes.next;
    var pagination = attributes.pagination;
    var paginationActive = attributes.paginationActive;
    var pervIcon = attributes.pervIcon;
    var nextIcon = attributes.nextIcon;
    var navsWrap = attributes.navsWrap;
    var paginationWrap = attributes.paginationWrap;
    var sliderOptions = attributes.sliderOptions;
    var sliderOptionsRes = attributes.sliderOptionsRes;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType']; //const [breakPointX, setBreakPointX] = useState(myStore.getBreakPoint());
    //var breakPointX = myStore.getBreakPoint();

    const [breakPointX, setBreakPointX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(myStore != null ? myStore.getBreakPoint() : 'Desktop'); // Wrapper CSS Class Selectors
    //var wrapperSelector = blockClass;

    var wrapperSelector = blockClass + ' .splide';
    var nextSelector = blockClass + ' .splide__arrow--next';
    var pervSelector = blockClass + ' .splide__arrow--prev';
    var nextIconSelector = blockClass + ' .splide__arrow--next .icon';
    var pervIconSelector = blockClass + ' .splide__arrow--prev .icon';
    var navsWrapSelector = blockClass + ' .splide__arrows';
    var paginationWrapSelector = blockClass + ' .splide__pagination';
    var paginationSelector = blockClass + ' .splide__pagination__page';
    var paginationActiveSelector = blockClass + ' .splide__pagination__page.is-active';
    var sliderOptionsArgs = {
      autoplay: {
        label: 'Auto play',
        value: 1
      },
      interval: {
        label: 'Interval',
        value: '500'
      },
      pauseOnHover: {
        label: 'Pause On Hover',
        value: 1
      },
      pauseOnFocus: {
        label: 'Pause On Focus',
        value: 1
      },
      lazyLoad: {
        label: 'Lazy Load',
        value: 1
      },
      preloadPages: {
        label: 'Preload Pages',
        value: 1
      },
      keyboard: {
        label: 'Keyboard',
        value: 1
      },
      wheel: {
        label: 'Wheel',
        value: 1
      },
      direction: {
        label: 'Direction',
        value: 'ltr'
      },
      cover: {
        label: 'Cover',
        value: 0
      },
      rewind: {
        label: 'Rewind',
        value: 0
      },
      speed: {
        label: 'Speed',
        value: 400
      },
      rewindSpeed: {
        label: 'Rewind Speed',
        value: 400
      },
      rewindByDrag: {
        label: 'Rewind By Drag',
        value: 0
      },
      width: {
        label: 'Width',
        value: ''
      },
      height: {
        label: 'Height',
        value: ''
      },
      fixedWidth: {
        label: 'Fixed Width',
        value: ''
      },
      fixedHeight: {
        label: 'Fixed Height',
        value: ''
      },
      heightRatio: {
        label: 'Height Ratio',
        value: ''
      },
      autoWidth: {
        label: 'Auto Width',
        value: 0
      },
      autoHeight: {
        label: 'Auto Height',
        value: 0
      },
      start: {
        label: 'Start',
        value: 0
      },
      perPage: {
        label: 'Per Page',
        value: 3
      },
      perMove: {
        label: 'Per Move',
        value: 3
      },
      focus: {
        label: 'Focus',
        value: 'center'
      },
      gap: {
        label: 'Gap',
        value: '1em'
      },
      padding: {
        label: 'Padding',
        value: ''
      },
      arrows: {
        label: 'Arrows',
        value: 1
      },
      pagination: {
        label: 'Pagination',
        value: 1
      },
      //easing: { label: 'Easing', value: 'cubic-bezier(0.25, 1, 0.5, 1)' },
      paginationKeyboard: {
        label: 'Pagination Keyboard',
        value: 1
      },
      paginationDirection: {
        label: 'Pagination Direction',
        value: 'paginationDirectltrion'
      },
      drag: {
        label: 'Drag',
        value: 1
      },
      noDrag: {
        label: 'No Drag',
        value: 'input, textarea, .rich-text'
      },
      snap: {
        label: 'Snap',
        value: 1
      },
      mediaQuery: {
        label: 'Media Query',
        value: 'max'
      }
    };
    var sliderOptionsArgsRes = {
      rewind: {
        label: 'Rewind',
        value: 0
      },
      speed: {
        label: 'Speed',
        value: 400
      },
      rewindSpeed: {
        label: 'Rewind Speed',
        value: 400
      },
      rewindByDrag: {
        label: 'Rewind By Drag',
        value: 0
      },
      width: {
        label: 'Width',
        value: ''
      },
      height: {
        label: 'Height',
        value: ''
      },
      fixedWidth: {
        label: 'Fixed Width',
        value: ''
      },
      fixedHeight: {
        label: 'Fixed Height',
        value: ''
      },
      heightRatio: {
        label: 'Height Ratio',
        value: ''
      },
      perPage: {
        label: 'Per Page',
        value: 3
      },
      perMove: {
        label: 'Per Move',
        value: 3
      },
      focus: {
        label: 'Focus',
        value: 'center'
      },
      gap: {
        label: 'Gap',
        value: '1em'
      },
      padding: {
        label: 'Padding',
        value: ''
      },
      arrows: {
        label: 'Arrows',
        value: 1
      },
      pagination: {
        label: 'Pagination',
        value: 1
      },
      paginationKeyboard: {
        label: 'Pagination Keyboard',
        value: 1
      },
      paginationDirection: {
        label: 'Pagination Direction',
        value: 'paginationDirectltrion'
      },
      drag: {
        label: 'Drag',
        value: 1
      },
      snap: {
        label: 'Snap',
        value: 1
      },
      keyboard: {
        label: 'Keyboard',
        value: 1
      },
      direction: {
        label: 'Direction',
        value: 'ltr'
      },
      easing: {
        label: 'Easing',
        value: 'cubic-bezier(0.25, 1, 0.5, 1)'
      }
    };

    function onChangeBreakPoint(x, _index) {
      var asdsdsd = wp.data.dispatch('postgrid-shop').setBreakPoint(x.value);
      asdsdsd.then(res => {
        setBreakPointX(res.breakpoint);
        myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      });
      const {
        __experimentalGetPreviewDeviceType: getPreviewDeviceType
      } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.select)('core/edit-post');
      const gutenbergDeviceType = getPreviewDeviceType();
    }

    const {
      replaceInnerBlocks
    } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.store);
    const hasInnerBlocks = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.store).getBlocks(clientId).length > 0, [clientId]); //console.log(JSON.stringify(wp.data.select(blockEditorStore).getBlocks(clientId)));

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      console.log(sliderOptionsRes);
      var args = {};
      Object.entries(sliderOptionsRes).map(item => {
        var id = item[0];
        var vals = item[1];
        Object.entries(vals).map(arg => {
          var view = arg[0];
          var viewVal = arg[1];
          var viewPoint = '';

          if (view == 'Mobile') {
            viewPoint = '360';
          } else if (view == 'Tablet') {
            viewPoint = '780';
          } else if (view == 'Desktop') {
            viewPoint = '1024';
          }

          if (args[viewPoint] == undefined) {
            args[viewPoint] = {};
          }

          if (args[viewPoint][id] == undefined) {
            args[viewPoint][id] = '';
          }

          args[viewPoint][id] = viewVal;
        });
      });
      console.log(args);

      if (Object.entries(args).length > 0) {
        var sliderOptionsX = { ...sliderOptions
        };
        sliderOptionsX['breakpoints'] = args;
        setAttributes({
          sliderOptions: sliderOptionsX
        });
      }
    }, [sliderOptionsRes]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    var breakPointList = [{
      label: 'Select..',
      icon: '',
      value: ''
    }];

    for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"]) {
      var item = _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"][x];
      breakPointList.push({
        label: item.name,
        icon: item.icon,
        value: item.id
      });
    }

    const addSlide = () => {
      var childBlocks = wp.data.select(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.store).getBlocks(clientId);
      const slide = (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.createBlock)('post-grid/content-slider-item');
      const position = childBlocks.length;
      (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.dispatch)('core/block-editor').insertBlock(slide, position, clientId); //setActiveTab(slide.clientId);
    };

    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }

    function applyFlex(attr, newVal) {
      onChangeStyleWrapper('styles', newVal, attr);
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onBulkAddWrapper(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, wrapper);
      obj[sudoScource] = cssObj;
      setAttributes({
        wrapper: obj
      });
      var selector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onChangeStyleNext(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, next);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        next: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, nextSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleNext(sudoScource, key) {
      var object = myStore.deletePropertyDeep(next, [sudoScource, key, breakPointX]);
      setAttributes({
        next: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, nextSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleNext(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, next);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        next: object
      });
    }

    function onBulkAddNext(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, next);
      obj[sudoScource] = cssObj;
      setAttributes({
        next: obj
      });
      var selector = myStore.getElementSelector(sudoScource, nextSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onChangeStylePrev(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, perv);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        perv: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, pervSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStylePrev(sudoScource, key) {
      var object = myStore.deletePropertyDeep(perv, [sudoScource, key, breakPointX]);
      setAttributes({
        perv: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, pervSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStylePrev(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, perv);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        perv: object
      });
    }

    function onBulkAddPrev(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, perv);
      obj[sudoScource] = cssObj;
      setAttributes({
        perv: obj
      });
      var selector = myStore.getElementSelector(sudoScource, pervSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onChangeStylePagination(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, pagination);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        pagination: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, paginationSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStylePagination(sudoScource, key) {
      var object = myStore.deletePropertyDeep(pagination, [sudoScource, key, breakPointX]);
      setAttributes({
        pagination: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, paginationSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStylePagination(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, pagination);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        pagination: object
      });
    }

    function onBulkAddPagination(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, pagination);
      obj[sudoScource] = cssObj;
      setAttributes({
        pagination: obj
      });
      var selector = myStore.getElementSelector(sudoScource, paginationSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onChangeStylePaginationActive(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, paginationActive);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        paginationActive: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, paginationActiveSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStylePaginationActive(sudoScource, key) {
      var object = myStore.deletePropertyDeep(paginationActive, [sudoScource, key, breakPointX]);
      setAttributes({
        paginationActive: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, paginationActiveSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStylePaginationActive(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, paginationActive);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        paginationActive: object
      });
    }

    function onBulkAddPaginationActive(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, paginationActive);
      obj[sudoScource] = cssObj;
      setAttributes({
        paginationActive: obj
      });
      var selector = myStore.getElementSelector(sudoScource, paginationActiveSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onChangeStylePaginationWrap(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, paginationWrap);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        paginationWrap: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, paginationWrapSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStylePaginationWrap(sudoScource, key) {
      var object = myStore.deletePropertyDeep(paginationWrap, [sudoScource, key, breakPointX]);
      setAttributes({
        paginationWrap: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, paginationWrapSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStylePaginationWrap(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, paginationWrap);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        paginationWrap: object
      });
    }

    function onBulkAddPaginationWrap(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, paginationWrap);
      obj[sudoScource] = cssObj;
      setAttributes({
        paginationWrap: obj
      });
      var selector = myStore.getElementSelector(sudoScource, paginationWrapSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onChangeStyleNextIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, nextIcon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        nextIcon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, nextIconSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleNextIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(nextIcon, [sudoScource, key, breakPointX]);
      setAttributes({
        nextIcon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, nextIconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleNextIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, nextIcon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        nextIcon: object
      });
    }

    function onBulkAddNextIcon(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, nextIcon);
      obj[sudoScource] = cssObj;
      setAttributes({
        nextIcon: obj
      });
      var selector = myStore.getElementSelector(sudoScource, nextIconSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onChangeStylePervIcon(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, pervIcon);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        pervIcon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, pervIconSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStylePervIcon(sudoScource, key) {
      var object = myStore.deletePropertyDeep(pervIcon, [sudoScource, key, breakPointX]);
      setAttributes({
        pervIcon: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, pervIconSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStylePervIcon(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, pervIcon);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        pervIcon: object
      });
    }

    function onBulkAddPervIcon(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, pervIcon);
      obj[sudoScource] = cssObj;
      setAttributes({
        pervIcon: obj
      });
      var selector = myStore.getElementSelector(sudoScource, pervIconSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onChangeStyleNavsWrap(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, navsWrap);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        navsWrap: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, navsWrapSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleNavsWrap(sudoScource, key) {
      var object = myStore.deletePropertyDeep(navsWrap, [sudoScource, key, breakPointX]);
      setAttributes({
        navsWrap: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, navsWrapSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleNavsWrap(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, navsWrap);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        navsWrap: object
      });
    }

    function onBulkAddNavsWrap(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, navsWrap);
      obj[sudoScource] = cssObj;
      setAttributes({
        navsWrap: obj
      });
      var selector = myStore.getElementSelector(sudoScource, navsWrapSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    const [nextIconHtml, setNextIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    const [pervIconHtml, setPervIconHtml] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      var iconSrc = nextIcon.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      setNextIconHtml(iconHtml);
    }, [nextIcon.options]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      var iconSrc = pervIcon.options.iconSrc;
      var iconHtml = `<span class="${iconSrc}"></span>`;
      setPervIconHtml(iconHtml);
    }, [pervIcon.options]);
    const ALLOWED_BLOCKS = ['post-grid/content-slider-navs', 'post-grid/content-slider-loop', 'post-grid/content-slider-item'];
    const MY_TEMPLATE = [['post-grid/content-slider-item', {}]];
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps)({
      className: ` ${blockId} pg-content-slider  `
    });
    const innerBlocksProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useInnerBlocksProps)(blockProps, {
      allowedBlocks: ALLOWED_BLOCKS,
      template: MY_TEMPLATE,
      orientation: 'horizontal' //templateInsertUpdatesSelection: true,
      //renderAppender: InnerBlocks.ButtonBlockAppender

    });

    var RemoveSliderArg = function (_ref) {
      let {
        index
      } = _ref;
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "cursor-pointer inline-block hover:bg-red-500 hover:text-white px-1 py-1",
        onClick: ev => {
          var sliderOptionsX = { ...sliderOptions
          };
          delete sliderOptionsX[index];
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"], {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"]
      }));
    };

    var RemoveSliderArgRes = function (_ref2) {
      let {
        index
      } = _ref2;
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "cursor-pointer inline-block hover:bg-red-500 hover:text-white px-1 py-1",
        onClick: ev => {
          console.log(index);
          var sliderOptionsResX = { ...sliderOptionsRes
          };
          delete sliderOptionsResX[index];
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"], {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"]
      }));
    };

    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "bg-blue-600 mx-3 my-2 cursor-pointer hover:text-white font-bold text-[16px] px-5 py-2 block text-center text-white rounded",
      onClick: ev => {
        addSlide();
      }
    }, "Add Slide Item"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Slider Options",
      initialOpen: true
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
      activeTab: "normal",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'normal',
        title: 'Normal',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: 'tab-normal'
      }, {
        name: 'responsive',
        title: 'Responsive',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: 'tab-responsive'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "normal"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", null, "Slider Options"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_18__["default"], {
      position: "bottom right",
      variant: "secondary",
      buttonTitle: 'Choose',
      options: sliderOptionsArgs,
      onChange: (option, index) => {
        var sliderOptionsX = { ...sliderOptions
        };
        sliderOptionsX[index] = option.value;
        setAttributes({
          sliderOptions: sliderOptionsX
        });
      },
      values: ""
    })), Object.entries(sliderOptions).map((item, index) => {
      var id = item[0];
      var value = item[1];
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, id == 'autoplay' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Autoplay?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'rewind' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Rewind?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'interval' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Interval?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value,
        type: "number",
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'speed' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Speed?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value,
        type: "number",
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'rewindSpeed' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Rewind Speed?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value,
        type: "number",
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'start' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Start?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value,
        type: "number",
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'perPage' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Per Page?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value,
        type: "number",
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'perMove' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Per Move?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value,
        type: "number",
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'gap' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Gap?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value,
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'padding' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Padding?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value,
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'focus' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Focus?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value,
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'width' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Width?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value,
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'height' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Height?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value,
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'fixedWidth' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Fixed Width?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value,
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'fixedHeight' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Fixed Height?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value,
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'heightRatio' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Height Ratio?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value,
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'easing' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Easing?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value,
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'pauseOnHover' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Pause On Hover?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'pauseOnFocus' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Pause On Focus?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
        for: ""
      }, "?"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'rewindByDrag' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Rewind By Drag?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'autoWidth' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Auto Width?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'autoHeight' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Auto Height?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'arrows' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Navigation?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'pagination' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Pagination?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'paginationKeyboard' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Pagination Keyboard?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'drag' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Drag?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'snap' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Snap?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'noDrag' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "noDrag?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value,
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'paginationDirection' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Pagination Direction?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'ltr',
          value: 'ltr'
        }, {
          label: 'rtl',
          value: 'rtl'
        }, {
          label: 'ttb',
          value: 'ttb'
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'direction' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Direction?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'ltr',
          value: 'ltr'
        }, {
          label: 'rtl',
          value: 'rtl'
        }, {
          label: 'ttb',
          value: 'ttb'
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'lazyLoad' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "LazyLoad?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }, {
          label: 'Nearby',
          value: 'nearby'
        }, {
          label: 'Sequential',
          value: 'sequential'
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'keyboard' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Keyboard?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }, {
          label: 'global',
          value: 'global'
        }, {
          label: 'focused',
          value: 'focused'
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'mediaQuery' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Media Query?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'min',
          value: 'min'
        }, {
          label: 'max',
          value: 'max'
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'wheel' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Wheel?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })), id == 'cover' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArg, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Cover?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value,
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsX = { ...sliderOptions
          };
          sliderOptionsX[id] = newVal;
          setAttributes({
            sliderOptions: sliderOptionsX
          });
        }
      })));
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "responsive"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", null, "Slider Options"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_dropdown__WEBPACK_IMPORTED_MODULE_18__["default"], {
      position: "bottom right",
      variant: "secondary",
      buttonTitle: 'Choose',
      options: sliderOptionsArgsRes,
      onChange: (option, index) => {
        var sliderOptionsResX = { ...sliderOptionsRes
        };

        if (sliderOptionsResX[index] == undefined) {
          sliderOptionsResX[index] = {};
        }

        if (sliderOptionsResX[index][breakPointX] == undefined) {
          sliderOptionsResX[index][breakPointX] = option.value;
        }

        setAttributes({
          sliderOptionsRes: sliderOptionsResX
        });
      },
      values: ""
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_toggle__WEBPACK_IMPORTED_MODULE_11__["default"], {
      position: "bottom",
      variant: "secondary",
      iconList: breakPointList,
      buttonTitle: "Break Point Switch",
      onChange: onChangeBreakPoint,
      activeIcon: _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"][breakPointX].icon,
      value: breakPointX
    })), Object.entries(sliderOptionsRes).map((item, index) => {
      var id = item[0];
      var value = item[1];
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, id == 'autoplay' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Autoplay?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'rewind' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Rewind?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'interval' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Interval?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        type: "number",
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'speed' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Speed?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        type: "number",
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'rewindSpeed' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Rewind Speed?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        type: "number",
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'start' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Start?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        type: "number",
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'perPage' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Per Page?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        type: "number",
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'perMove' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Per Move?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        type: "number",
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'gap' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Gap?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'padding' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Padding?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'focus' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Focus?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'width' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Width?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'height' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Height?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'fixedWidth' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Fixed Width?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'fixedHeight' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Fixed Height?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'heightRatio' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Height Ratio?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'pauseOnHover' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Pause On Hover?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'pauseOnFocus' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Pause On Focus?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
        for: ""
      }, "?"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'rewindByDrag' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Rewind By Drag?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'autoWidth' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Auto Width?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'autoHeight' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Auto Height?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'arrows' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Navigation?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'pagination' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Pagination?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'paginationKeyboard' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Pagination Keyboard?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'drag' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Drag?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'snap' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Snap?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'noDrag' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "No Drag?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'paginationDirection' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Pagination Direction?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'ltr',
          value: 'ltr'
        }, {
          label: 'rtl',
          value: 'rtl'
        }, {
          label: 'ttb',
          value: 'ttb'
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'direction' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Direction?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'ltr',
          value: 'ltr'
        }, {
          label: 'rtl',
          value: 'rtl'
        }, {
          label: 'ttb',
          value: 'ttb'
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'lazyLoad' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "LazyLoad?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }, {
          label: 'Nearby',
          value: 'nearby'
        }, {
          label: 'Sequential',
          value: 'sequential'
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'keyboard' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Keyboard?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }, {
          label: 'global',
          value: 'global'
        }, {
          label: 'focused',
          value: 'focused'
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'mediaQuery' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Media Query?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'min',
          value: 'min'
        }, {
          label: 'max',
          value: 'max'
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'wheel' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Wheel?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })), id == 'cover' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex items-center"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(RemoveSliderArgRes, {
        index: id
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, "Cover?")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
        label: "",
        value: value[breakPointX] == undefined ? "" : value[breakPointX],
        options: [{
          label: 'True',
          value: 1
        }, {
          label: 'False',
          value: 0
        }],
        onChange: newVal => {
          var sliderOptionsResX = { ...sliderOptionsRes
          };

          if (sliderOptionsResX[id][breakPointX] == undefined) {
            sliderOptionsResX[id][breakPointX] = '';
          }

          sliderOptionsResX[id][breakPointX] = newVal;
          setAttributes({
            sliderOptionsRes: sliderOptionsResX
          });
        }
      })));
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_21__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper,
      onBulkAdd: onBulkAddWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Navigation",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Nav Wrap",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_21__["default"], {
      obj: navsWrap,
      onChange: onChangeStyleNavsWrap,
      onAdd: onAddStyleNavsWrap,
      onRemove: onRemoveStyleNavsWrap,
      onBulkAdd: onBulkAddNavsWrap
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Prev",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Previuos Text"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
      value: perv.options.text,
      onChange: newVal => {
        var options = { ...perv.options,
          text: newVal
        };
        setAttributes({
          perv: { ...perv,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_21__["default"], {
      obj: perv,
      onChange: onChangeStylePrev,
      onAdd: onAddStylePrev,
      onRemove: onRemoveStylePrev,
      onBulkAdd: onBulkAddPrev
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Prev Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_23__["default"], {
      library: pervIcon.options.library,
      srcType: pervIcon.options.srcType,
      iconSrc: pervIcon.options.iconSrc,
      onChange: arg => {
        var options = { ...pervIcon.options,
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          pervIcon: { ...pervIcon,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Icon Position"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: pervIcon.options.position,
      options: [{
        label: 'None',
        value: ''
      }, {
        label: 'After',
        value: 'after'
      }, {
        label: 'Before',
        value: 'before'
      }],
      onChange: newVal => {
        var options = { ...pervIcon.options,
          position: newVal
        };
        setAttributes({
          pervIcon: { ...pervIcon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_21__["default"], {
      obj: pervIcon,
      onChange: onChangeStylePervIcon,
      onAdd: onAddStylePervIcon,
      onRemove: onRemoveStylePervIcon,
      onBulkAdd: onBulkAddPervIcon
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Next",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Previuos Text"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
      value: next.options.text,
      onChange: newVal => {
        var options = { ...next.options,
          text: newVal
        };
        setAttributes({
          next: { ...next,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_21__["default"], {
      obj: next,
      onChange: onChangeStyleNext,
      onAdd: onAddStyleNext,
      onRemove: onRemoveStyleNext,
      onBulkAdd: onBulkAddNext
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Next Icon",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Icon"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_23__["default"], {
      library: nextIcon.options.library,
      srcType: nextIcon.options.srcType,
      iconSrc: nextIcon.options.iconSrc,
      onChange: arg => {
        var options = { ...nextIcon.options,
          srcType: arg.srcType,
          library: arg.library,
          iconSrc: arg.iconSrc
        };
        setAttributes({
          nextIcon: { ...nextIcon,
            options: options
          }
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Icon Position"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: nextIcon.options.position,
      options: [{
        label: 'None',
        value: ''
      }, {
        label: 'After',
        value: 'after'
      }, {
        label: 'Before',
        value: 'before'
      }],
      onChange: newVal => {
        var options = { ...nextIcon.options,
          position: newVal
        };
        setAttributes({
          nextIcon: { ...nextIcon,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_21__["default"], {
      obj: nextIcon,
      onChange: onChangeStyleNextIcon,
      onAdd: onAddStyleNextIcon,
      onRemove: onRemoveStyleNextIcon,
      onBulkAdd: onBulkAddNextIcon
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Pagination",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Pagination Wrap",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_21__["default"], {
      obj: paginationWrap,
      onChange: onChangeStylePaginationWrap,
      onAdd: onAddStylePaginationWrap,
      onRemove: onRemoveStylePaginationWrap,
      onBulkAdd: onBulkAddPaginationWrap
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Pagination Idle",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_21__["default"], {
      obj: pagination,
      onChange: onChangeStylePagination,
      onAdd: onAddStylePagination,
      onRemove: onRemoveStylePagination,
      onBulkAdd: onBulkAddPagination
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Pagination Active",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_20__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_21__["default"], {
      obj: paginationActive,
      onChange: onChangeStylePaginationActive,
      onAdd: onAddStylePaginationActive,
      onRemove: onRemoveStylePaginationActive,
      onBulkAdd: onBulkAddPaginationActive
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: ""
    }, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Text "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, wrapperSelector, '{}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_13__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_14__["default"], {
      utm: {
        utm_source: 'BlockText',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, !hasInnerBlocks && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", innerBlocksProps, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "border p-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex justify-between mb-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "text-xl rounded-sm"
    }, "Click to pick a variation"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "bg-orange-400 hover:bg-orange-300 px-4 py-1 text-white cursor-pointer",
      onClick: ev => {
        replaceInnerBlocks(clientId, (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.createBlocksFromInnerBlocksTemplate)([['post-grid/content-slider-item', {}]]), true);
      }
    }, "Skip")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: ""
    }, _variations__WEBPACK_IMPORTED_MODULE_17__["default"].map(variation => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "text-center inline-block m-4 w-32 align-top p-4 bg-gray-400 cursor-pointer hover:bg-gray-500 relative",
        onClick: ev => {
          if (variation.isPro) {
            alert('Sorry this variation only vailable in pro version');
            return false;
          }

          var atts = variation.atts;
          var wrapper = { ...atts.wrapper
          };
          var paginationWrap = { ...atts.paginationWrap
          };
          var pagination = { ...atts.pagination
          };
          var paginationActive = { ...atts.paginationActive
          };
          var perv = { ...atts.perv
          };
          var next = { ...atts.next
          };
          var pervIcon = { ...atts.pervIcon
          };
          var nextIcon = { ...atts.nextIcon
          };
          var navsWrap = { ...atts.navsWrap
          };
          var blockCssY = { ...atts.blockCssY
          };
          var customCss = { ...atts.customCss
          };
          var sliderOptions = { ...atts.sliderOptions
          };
          var sliderOptionsRes = { ...atts.sliderOptionsRes
          };
          var blockCssObj = {};
          blockCssObj[wrapperSelector] = wrapper;
          blockCssObj[paginationSelector] = pagination;
          blockCssObj[pervIconSelector] = pervIcon;
          blockCssObj[paginationActiveSelector] = paginationActive;
          blockCssObj[nextIconSelector] = nextIcon;
          blockCssObj[pervSelector] = perv;
          blockCssObj[nextSelector] = next;
          blockCssObj[paginationWrapSelector] = paginationWrap;
          blockCssObj[navsWrapSelector] = navsWrap;
          setAttributes({
            wrapper: wrapper,
            perv: perv,
            next: next,
            pagination: pagination,
            pervIcon: pervIcon,
            paginationActive: paginationActive,
            nextIcon: nextIcon,
            paginationWrap: paginationWrap,
            navsWrap: navsWrap,
            customCss: customCss,
            sliderOptions: sliderOptions,
            sliderOptionsRes: sliderOptionsRes
          });
          var blockCssRules = myStore.getBlockCssRules(blockCssObj);
          var items = { ...blockCssY.items,
            ...blockCssRules
          };
          setAttributes({
            blockCssY: {
              items: items
            }
          });
          replaceInnerBlocks(clientId, (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.createBlocksFromInnerBlocksTemplate)(variation.innerBlocks), true);
        }
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, variation.icon), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, variation.title), variation.isPro && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "bg-amber-400 rounded-sm text-sm inline-block  bg-opacity-90 text-white hover:text-white absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        className: "block px-3",
        href: 'https://pickplugins.com/post-grid/?utm_source=dropdownComponent&utm_term=proFeature&utm_campaign=pluginPostGrid&utm_medium=' + x.label
      }, "Pro")));
    })))), hasInnerBlocks && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", innerBlocksProps, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_splidejs_react_splide__WEBPACK_IMPORTED_MODULE_10__.Splide, {
      hasTrack: false,
      options: sliderOptions
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_splidejs_react_splide__WEBPACK_IMPORTED_MODULE_10__.SplideTrack, null, innerBlocksProps.children), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "splide__arrows"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "perv splide__arrow splide__arrow--prev"
    }, pervIcon.options.position == 'before' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "icon",
      dangerouslySetInnerHTML: {
        __html: pervIconHtml
      }
    }), perv.options.text.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, " ", perv.options.text, " "), pervIcon.options.position == 'after' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "icon",
      dangerouslySetInnerHTML: {
        __html: pervIconHtml
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "next splide__arrow splide__arrow--next"
    }, nextIcon.options.position == 'before' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "icon",
      dangerouslySetInnerHTML: {
        __html: nextIconHtml
      }
    }), next.options.text.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, " ", next.options.text, " "), nextIcon.options.position == 'after' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "icon",
      dangerouslySetInnerHTML: {
        __html: nextIconHtml
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", {
      class: "splide__pagination "
    })))));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    var attributes = props.attributes;
    var wrapper = attributes.wrapper;
    var perv = attributes.perv;
    var next = attributes.next;
    var pagination = attributes.pagination;
    var paginationActive = attributes.paginationActive;
    var pervIcon = attributes.pervIcon;
    var nextIcon = attributes.nextIcon;
    var navsWrap = attributes.navsWrap;
    var paginationWrap = attributes.paginationWrap;
    var sliderOptions = attributes.sliderOptions;
    var sliderOptionsRes = attributes.sliderOptionsRes;
    var blockId = attributes.blockId;
    var pervIconHtml = `<span class="${pervIcon.options.iconSrc}"></span>`;
    var nextIconHtml = `<span class="${nextIcon.options.iconSrc}"></span>`;
    const blockProps = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps.save({
      className: ` ${blockId} pg-content-slider`
    });
    const {
      children,
      ...innerBlocksProps
    } = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useInnerBlocksProps.save(blockProps);
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, children); //return null;
  }
});

/***/ }),

/***/ "./src/blocks/content-slider/variations.js":
/*!*************************************************!*\
  !*** ./src/blocks/content-slider/variations.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

/**
 * Template option choices for predefined columns layouts.
 */

const variations = [{
  name: 'preset-1',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-1'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-1'),
  isPro: false,
  atts: {
    wrapper: {
      options: {
        class: ''
      },
      styles: {
        padding: {
          Desktop: '50px 0px 50px 0px'
        }
      }
    },
    navsWrap: {
      options: {
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        position: {
          Desktop: 'absolute'
        },
        left: {
          Desktop: '0px'
        },
        top: {
          Desktop: '0px'
        }
      }
    },
    perv: {
      options: {
        text: 'Prev',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    pervIcon: {
      options: {
        position: 'before',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-left'
      },
      styles: {}
    },
    next: {
      options: {
        text: 'Next',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    nextIcon: {
      options: {
        position: 'after',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-right'
      },
      styles: {}
    },
    paginationWrap: {
      options: {
        tag: 'ul',
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        justifyContent: {
          Desktop: 'center'
        },
        paddingTop: {
          Desktop: '30px'
        }
      }
    },
    pagination: {
      options: {
        tag: 'span',
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        width: {
          Desktop: '15px'
        },
        height: {
          Desktop: '15px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        borderRadius: {
          Desktop: ' 20px 20px 20px 20px'
        }
      }
    },
    paginationActive: {
      options: {
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#0003B6F5'
        }
      }
    },
    sliderOptions: {
      perPage: 3,
      perMove: 1,
      gap: '1em'
    },
    sliderOptionsRes: {}
  },
  innerBlocks: [['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "70.84",
    cy: "73.83",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "76.15",
    cy: "73.83",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "81.45",
    cy: "73.83",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "4.39",
    y: "53.99",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "7.81",
    y: "57.47",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "19.41",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "57.76",
    y: "53.99",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "61.18",
    y: "57.47",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "53.37",
    y: "19.41",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "111.13",
    y: "53.99",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "114.54",
    y: "57.47",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "106.73",
    y: "19.41",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "12.25",
    y: "7.53",
    width: "9.63",
    height: "5.68"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M16.45,11.77a.13.13,0,0,1-.11,0,.15.15,0,0,1,0-.21l1.13-1.14L16.34,9.24A.16.16,0,1,1,16.56,9l1.35,1.35-1.35,1.35A.13.13,0,0,1,16.45,11.77Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "7.53",
    width: "9.63",
    height: "5.68",
    transform: "translate(9.63 20.74) rotate(180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M5.44,9a.16.16,0,0,1,.11,0,.16.16,0,0,1,0,.22L4.41,10.37l1.14,1.14a.16.16,0,1,1-.22.22L4.08,10.48a.16.16,0,0,1,0-.22L5.33,9A.16.16,0,0,1,5.44,9Z"
  }))
}, {
  name: 'preset-2',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-2'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-2'),
  isPro: false,
  atts: {
    wrapper: {
      options: {
        class: ''
      },
      styles: {
        padding: {
          Desktop: '50px 0px 50px 0px'
        }
      }
    },
    navsWrap: {
      options: {
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        position: {
          Desktop: 'absolute'
        },
        left: {
          Desktop: '0px'
        },
        top: {
          Desktop: '0px'
        },
        justifyContent: {
          Desktop: 'center'
        },
        width: {
          Desktop: '100%'
        }
      }
    },
    perv: {
      options: {
        text: 'Prev',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    pervIcon: {
      options: {
        position: 'before',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-left'
      },
      styles: {}
    },
    next: {
      options: {
        text: 'Next',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    nextIcon: {
      options: {
        position: 'after',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-right'
      },
      styles: {}
    },
    paginationWrap: {
      options: {
        tag: 'ul',
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        justifyContent: {
          Desktop: 'center'
        },
        paddingTop: {
          Desktop: '30px'
        }
      }
    },
    pagination: {
      options: {
        tag: 'span',
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        width: {
          Desktop: '15px'
        },
        height: {
          Desktop: '15px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        borderRadius: {
          Desktop: ' 20px 20px 20px 20px'
        }
      }
    },
    paginationActive: {
      options: {
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#0003B6F5'
        }
      }
    },
    sliderOptions: {
      perPage: 3,
      perMove: 1,
      gap: '1em'
    },
    sliderOptionsRes: {}
  },
  innerBlocks: [['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "70.84",
    cy: "73.83",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "76.15",
    cy: "73.83",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "81.45",
    cy: "73.83",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "4.39",
    y: "53.99",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "7.81",
    y: "57.47",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "19.41",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "57.76",
    y: "53.99",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "61.18",
    y: "57.47",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "53.37",
    y: "19.41",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "111.13",
    y: "53.99",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "114.54",
    y: "57.47",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "106.73",
    y: "19.41",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "77.46",
    y: "7.53",
    width: "9.63",
    height: "5.68"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M81.65,11.77a.13.13,0,0,1-.11,0,.14.14,0,0,1,0-.21l1.13-1.14L81.54,9.24A.16.16,0,1,1,81.76,9l1.35,1.35-1.35,1.35A.13.13,0,0,1,81.65,11.77Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "65.2",
    y: "7.53",
    width: "9.63",
    height: "5.68",
    transform: "translate(140.04 20.74) rotate(180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M70.64,9a.16.16,0,0,1,.11,0,.16.16,0,0,1,0,.22l-1.13,1.13,1.13,1.14a.16.16,0,1,1-.22.22l-1.24-1.25a.16.16,0,0,1,0-.22L70.53,9A.16.16,0,0,1,70.64,9Z"
  }))
}, {
  name: 'preset-3',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-3'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-3'),
  isPro: false,
  atts: {
    wrapper: {
      options: {
        class: ''
      },
      styles: {
        padding: {
          Desktop: '50px 0px 50px 0px'
        }
      }
    },
    navsWrap: {
      options: {
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        position: {
          Desktop: 'absolute'
        },
        right: {
          Desktop: '0px'
        },
        top: {
          Desktop: '0px'
        }
      }
    },
    perv: {
      options: {
        text: 'Prev',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    pervIcon: {
      options: {
        position: 'before',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-left'
      },
      styles: {}
    },
    next: {
      options: {
        text: 'Next',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    nextIcon: {
      options: {
        position: 'after',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-right'
      },
      styles: {}
    },
    paginationWrap: {
      options: {
        tag: 'ul',
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        justifyContent: {
          Desktop: 'center'
        },
        paddingTop: {
          Desktop: '30px'
        }
      }
    },
    pagination: {
      options: {
        tag: 'span',
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        width: {
          Desktop: '15px'
        },
        height: {
          Desktop: '15px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        borderRadius: {
          Desktop: ' 20px 20px 20px 20px'
        }
      }
    },
    paginationActive: {
      options: {
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#0003B6F5'
        }
      }
    },
    sliderOptions: {
      perPage: 3,
      perMove: 1,
      gap: '1em'
    },
    sliderOptionsRes: {}
  },
  innerBlocks: [['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "70.84",
    cy: "73.83",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "76.15",
    cy: "73.83",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "81.45",
    cy: "73.83",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "4.39",
    y: "53.99",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "7.81",
    y: "57.47",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "19.41",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "57.76",
    y: "53.99",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "61.18",
    y: "57.47",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "53.37",
    y: "19.41",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "111.13",
    y: "53.99",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "114.54",
    y: "57.47",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "106.73",
    y: "19.41",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "142.66",
    y: "7.53",
    width: "9.63",
    height: "5.68"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M146.85,11.77a.13.13,0,0,1-.11,0,.15.15,0,0,1,0-.21l1.14-1.14-1.14-1.13A.16.16,0,0,1,147,9l1.36,1.35L147,11.72A.13.13,0,0,1,146.85,11.77Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "130.41",
    y: "7.53",
    width: "9.63",
    height: "5.68",
    transform: "translate(270.44 20.74) rotate(180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M135.84,9A.16.16,0,0,1,136,9a.16.16,0,0,1,0,.22l-1.13,1.13L136,11.51a.16.16,0,0,1-.22.22l-1.24-1.25a.16.16,0,0,1,0-.22L135.73,9A.16.16,0,0,1,135.84,9Z"
  }))
}, {
  name: 'preset-4',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-4'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-4'),
  isPro: false,
  atts: {
    wrapper: {
      options: {
        class: ''
      },
      styles: {
        padding: {
          Desktop: '50px 0px 50px 0px'
        }
      }
    },
    navsWrap: {
      options: {
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        position: {
          Desktop: 'absolute'
        },
        left: {
          Desktop: '0px'
        },
        top: {
          Desktop: '0px'
        },
        justifyContent: {
          Desktop: 'space-between'
        },
        width: {
          Desktop: '100%'
        }
      }
    },
    perv: {
      options: {
        text: 'Prev',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    pervIcon: {
      options: {
        position: 'before',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-left'
      },
      styles: {}
    },
    next: {
      options: {
        text: 'Next',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    nextIcon: {
      options: {
        position: 'after',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-right'
      },
      styles: {}
    },
    paginationWrap: {
      options: {
        tag: 'ul',
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        justifyContent: {
          Desktop: 'center'
        },
        paddingTop: {
          Desktop: '30px'
        }
      }
    },
    pagination: {
      options: {
        tag: 'span',
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        width: {
          Desktop: '15px'
        },
        height: {
          Desktop: '15px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        borderRadius: {
          Desktop: ' 20px 20px 20px 20px'
        }
      }
    },
    paginationActive: {
      options: {
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#0003B6F5'
        }
      }
    },
    sliderOptions: {
      perPage: 3,
      perMove: 1,
      gap: '1em'
    },
    sliderOptionsRes: {}
  },
  innerBlocks: [['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "70.84",
    cy: "73.83",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "76.15",
    cy: "73.83",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "81.45",
    cy: "73.83",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "4.39",
    y: "53.99",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "7.81",
    y: "57.47",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "19.41",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "57.76",
    y: "53.99",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "61.18",
    y: "57.47",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "53.37",
    y: "19.41",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "111.13",
    y: "53.99",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "114.54",
    y: "57.47",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "106.73",
    y: "19.41",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "142.66",
    y: "7.53",
    width: "9.63",
    height: "5.68"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M146.85,11.77a.13.13,0,0,1-.11,0,.15.15,0,0,1,0-.21l1.14-1.14-1.14-1.13A.16.16,0,0,1,147,9l1.36,1.35L147,11.72A.13.13,0,0,1,146.85,11.77Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "7.53",
    width: "9.63",
    height: "5.68",
    transform: "translate(9.63 20.74) rotate(180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M5.44,9a.16.16,0,0,1,.11,0,.16.16,0,0,1,0,.22L4.41,10.37l1.14,1.14a.16.16,0,1,1-.22.22L4.08,10.48a.16.16,0,0,1,0-.22L5.33,9A.16.16,0,0,1,5.44,9Z"
  }))
}, {
  name: 'preset-5',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-5'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-5'),
  isPro: false,
  atts: {
    wrapper: {
      options: {
        class: ''
      },
      styles: {
        padding: {
          Desktop: '50px 0px 50px 0px'
        }
      }
    },
    navsWrap: {
      options: {
        class: ''
      },
      styles: {
        "display": {
          "Desktop": "flex"
        },
        "position": {
          "Desktop": "absolute"
        },
        "left": {
          "Desktop": "0px"
        },
        "top": {
          "Desktop": "50%"
        },
        "justifyContent": {
          "Desktop": "space-between"
        },
        "width": {
          "Desktop": "100%"
        },
        "transform": {
          "Desktop": "translateY(-50%) "
        }
      }
    },
    perv: {
      options: {
        text: 'Prev',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    pervIcon: {
      options: {
        position: 'before',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-left'
      },
      styles: {}
    },
    next: {
      options: {
        text: 'Next',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    nextIcon: {
      options: {
        position: 'after',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-right'
      },
      styles: {}
    },
    paginationWrap: {
      options: {
        tag: 'ul',
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        justifyContent: {
          Desktop: 'center'
        },
        paddingTop: {
          Desktop: '30px'
        }
      }
    },
    pagination: {
      options: {
        tag: 'span',
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        width: {
          Desktop: '15px'
        },
        height: {
          Desktop: '15px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        borderRadius: {
          Desktop: ' 20px 20px 20px 20px'
        }
      }
    },
    paginationActive: {
      options: {
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#0003B6F5'
        }
      }
    },
    sliderOptions: {
      perPage: 3,
      perMove: 1,
      gap: '1em'
    },
    sliderOptionsRes: {}
  },
  innerBlocks: [['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "70.84",
    cy: "67.89",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "76.14",
    cy: "67.89",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "81.45",
    cy: "67.89",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "4.39",
    y: "48.05",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "7.81",
    y: "51.53",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "13.47",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "57.76",
    y: "48.05",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "61.18",
    y: "51.53",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "53.37",
    y: "13.47",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "111.13",
    y: "48.05",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "114.54",
    y: "51.53",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "106.73",
    y: "13.47",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "142.66",
    y: "24.82",
    width: "9.63",
    height: "5.68"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M146.85,29.06a.16.16,0,0,1-.11,0,.16.16,0,0,1,0-.22l1.14-1.13-1.14-1.13a.16.16,0,0,1,.22-.22l1.36,1.35L147,29A.16.16,0,0,1,146.85,29.06Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "24.82",
    width: "9.63",
    height: "5.68",
    transform: "translate(9.63 55.32) rotate(180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M5.44,26.26a.16.16,0,0,1,.11,0,.16.16,0,0,1,0,.22L4.41,27.66l1.14,1.13a.16.16,0,0,1-.22.22L4.08,27.77a.16.16,0,0,1,0-.22l1.25-1.24A.16.16,0,0,1,5.44,26.26Z"
  }))
}, {
  name: 'preset-6',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-6'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-6'),
  isPro: false,
  atts: {
    wrapper: {
      options: {
        class: ''
      },
      styles: {
        padding: {
          Desktop: '50px 0px 50px 0px'
        }
      }
    },
    navsWrap: {
      options: {
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        position: {
          Desktop: 'absolute'
        },
        left: {
          Desktop: '0px'
        },
        bottom: {
          Desktop: '0px'
        }
      }
    },
    perv: {
      options: {
        text: 'Prev',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    pervIcon: {
      options: {
        position: 'before',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-left'
      },
      styles: {}
    },
    next: {
      options: {
        text: 'Next',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    nextIcon: {
      options: {
        position: 'after',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-right'
      },
      styles: {}
    },
    paginationWrap: {
      options: {
        tag: 'ul',
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        justifyContent: {
          Desktop: 'center'
        },
        position: {
          Desktop: 'absolute'
        },
        width: {
          Desktop: '100%'
        },
        top: {
          Desktop: '0px'
        },
        left: {
          Desktop: '0px'
        }
      }
    },
    pagination: {
      options: {
        tag: 'span',
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        width: {
          Desktop: '15px'
        },
        height: {
          Desktop: '15px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        borderRadius: {
          Desktop: ' 20px 20px 20px 20px'
        }
      }
    },
    paginationActive: {
      options: {
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#0003B6F5'
        }
      }
    },
    sliderOptions: {
      perPage: 3,
      perMove: 1,
      gap: '1em'
    },
    sliderOptionsRes: {}
  },
  innerBlocks: [['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "70.84",
    cy: "9.35",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "76.15",
    cy: "9.35",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "81.45",
    cy: "9.35",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "4.39",
    y: "52.96",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "7.81",
    y: "56.44",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "18.38",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "57.76",
    y: "52.96",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "61.18",
    y: "56.44",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "53.37",
    y: "18.38",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "111.13",
    y: "52.96",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "114.54",
    y: "56.44",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "106.73",
    y: "18.38",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "12.25",
    y: "68.75",
    width: "9.63",
    height: "5.68"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M16.45,73a.15.15,0,0,1-.11,0,.16.16,0,0,1,0-.22l1.13-1.14-1.13-1.13a.16.16,0,0,1,.22-.22l1.35,1.35L16.56,73A.15.15,0,0,1,16.45,73Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "68.75",
    width: "9.63",
    height: "5.68",
    transform: "translate(9.63 143.19) rotate(180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M5.44,70.19a.16.16,0,0,1,.11,0,.16.16,0,0,1,0,.22L4.41,71.59l1.14,1.14a.16.16,0,0,1-.22.22L4.08,71.7a.16.16,0,0,1,0-.22l1.25-1.24A.16.16,0,0,1,5.44,70.19Z"
  }))
}, {
  name: 'preset-7',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-7'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-7'),
  isPro: true,
  atts: {
    wrapper: {
      options: {
        class: ''
      },
      styles: {
        padding: {
          Desktop: '70px 0px 50px 0px'
        }
      }
    },
    navsWrap: {
      options: {
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        position: {
          Desktop: 'absolute'
        },
        right: {
          Desktop: '0px'
        },
        bottom: {
          Desktop: '0px'
        }
      }
    },
    perv: {
      options: {
        text: 'Prev',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    pervIcon: {
      options: {
        position: 'before',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-left'
      },
      styles: {}
    },
    next: {
      options: {
        text: 'Next',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    nextIcon: {
      options: {
        position: 'after',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-right'
      },
      styles: {}
    },
    paginationWrap: {
      options: {
        tag: 'ul',
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        justifyContent: {
          Desktop: 'center'
        },
        position: {
          Desktop: 'absolute'
        },
        width: {
          Desktop: '100%'
        },
        top: {
          Desktop: '0px'
        },
        left: {
          Desktop: '0px'
        }
      }
    },
    pagination: {
      options: {
        tag: 'span',
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        width: {
          Desktop: '15px'
        },
        height: {
          Desktop: '15px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        borderRadius: {
          Desktop: ' 20px 20px 20px 20px'
        }
      }
    },
    paginationActive: {
      options: {
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#0003B6F5'
        }
      }
    },
    sliderOptions: {
      perPage: 3,
      perMove: 1,
      gap: '1em'
    },
    sliderOptionsRes: {}
  },
  innerBlocks: [['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "70.84",
    cy: "9.35",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "76.15",
    cy: "9.35",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "81.45",
    cy: "9.35",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "4.39",
    y: "52.96",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "7.81",
    y: "56.44",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "18.38",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "57.76",
    y: "52.96",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "61.18",
    y: "56.44",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "53.37",
    y: "18.38",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "111.13",
    y: "52.96",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "114.54",
    y: "56.44",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "106.73",
    y: "18.38",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "142.66",
    y: "68.75",
    width: "9.63",
    height: "5.68"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M146.85,73a.15.15,0,0,1-.11,0,.16.16,0,0,1,0-.22l1.14-1.14-1.14-1.13a.16.16,0,0,1,.22-.22l1.36,1.35L147,73A.15.15,0,0,1,146.85,73Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "130.41",
    y: "68.75",
    width: "9.63",
    height: "5.68",
    transform: "translate(270.44 143.19) rotate(180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M135.84,70.19a.16.16,0,0,1,.11,0,.16.16,0,0,1,0,.22l-1.13,1.13L136,72.73a.16.16,0,0,1-.22.22l-1.24-1.25a.16.16,0,0,1,0-.22l1.24-1.24A.16.16,0,0,1,135.84,70.19Z"
  }))
}, {
  name: 'preset-8',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-8'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-8'),
  isPro: true,
  atts: {
    wrapper: {
      options: {
        class: ''
      },
      styles: {
        padding: {
          Desktop: '50px 0px 50px 0px'
        }
      }
    },
    navsWrap: {
      options: {
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        justifyContent: {
          Desktop: 'center'
        },
        padding: {
          Desktop: '30px 0px 0px 0px'
        }
      }
    },
    perv: {
      options: {
        text: 'Prev',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    pervIcon: {
      options: {
        position: 'before',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-left'
      },
      styles: {}
    },
    next: {
      options: {
        text: 'Next',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    nextIcon: {
      options: {
        position: 'after',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-right'
      },
      styles: {}
    },
    paginationWrap: {
      options: {
        tag: 'ul',
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        justifyContent: {
          Desktop: 'center'
        },
        position: {
          Desktop: 'absolute'
        },
        width: {
          Desktop: '100%'
        },
        top: {
          Desktop: '0px'
        },
        left: {
          Desktop: '0px'
        }
      }
    },
    pagination: {
      options: {
        tag: 'span',
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        width: {
          Desktop: '15px'
        },
        height: {
          Desktop: '15px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        borderRadius: {
          Desktop: ' 20px 20px 20px 20px'
        }
      }
    },
    paginationActive: {
      options: {
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#0003B6F5'
        }
      }
    },
    sliderOptions: {
      perPage: 3,
      perMove: 1,
      gap: '1em'
    },
    sliderOptionsRes: {}
  },
  innerBlocks: [['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "70.84",
    cy: "9.35",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "76.15",
    cy: "9.35",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "81.45",
    cy: "9.35",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "4.39",
    y: "52.96",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "7.81",
    y: "56.44",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "18.38",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "57.76",
    y: "52.96",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "61.18",
    y: "56.44",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "53.37",
    y: "18.38",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "111.13",
    y: "52.96",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "114.54",
    y: "56.44",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "106.73",
    y: "18.38",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "77.46",
    y: "68.75",
    width: "9.63",
    height: "5.68"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M81.65,73a.15.15,0,0,1-.11,0,.16.16,0,0,1,0-.22l1.13-1.14-1.13-1.13a.16.16,0,0,1,.22-.22l1.35,1.35L81.76,73A.15.15,0,0,1,81.65,73Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "65.2",
    y: "68.75",
    width: "9.63",
    height: "5.68",
    transform: "translate(140.04 143.19) rotate(180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M70.64,70.19a.16.16,0,0,1,.11,0,.16.16,0,0,1,0,.22l-1.13,1.13,1.13,1.14a.16.16,0,0,1-.22.22L69.29,71.7a.16.16,0,0,1,0-.22l1.24-1.24A.16.16,0,0,1,70.64,70.19Z"
  }))
}, {
  name: 'preset-9',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-9'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('preset-9'),
  isPro: true,
  atts: {
    wrapper: {
      options: {
        class: ''
      },
      styles: {
        padding: {
          Desktop: '50px 0px 50px 0px'
        }
      }
    },
    navsWrap: {
      options: {
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        position: {
          Desktop: 'absolute'
        },
        left: {
          Desktop: '0px'
        },
        bottom: {
          Desktop: '0px'
        },
        justifyContent: {
          Desktop: 'space-between'
        },
        width: {
          Desktop: '100%'
        }
      }
    },
    perv: {
      options: {
        text: 'Prev',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    pervIcon: {
      options: {
        position: 'before',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-left'
      },
      styles: {}
    },
    next: {
      options: {
        text: 'Next',
        class: ''
      },
      styles: {
        padding: {
          Desktop: '5px 30px 5px 30px'
        },
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        color: {
          Desktop: '#fff'
        }
      }
    },
    nextIcon: {
      options: {
        position: 'after',
        class: '',
        library: 'fontAwesome',
        srcType: "class",

        /*class, html, img, svg */
        iconSrc: 'fas fa-chevron-right'
      },
      styles: {}
    },
    paginationWrap: {
      options: {
        tag: 'ul',
        class: ''
      },
      styles: {
        display: {
          Desktop: 'flex'
        },
        justifyContent: {
          Desktop: 'center'
        },
        position: {
          Desktop: 'absolute'
        },
        width: {
          Desktop: '100%'
        },
        top: {
          Desktop: '0px'
        },
        left: {
          Desktop: '0px'
        }
      }
    },
    pagination: {
      options: {
        tag: 'span',
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#1418FF8F'
        },
        width: {
          Desktop: '15px'
        },
        height: {
          Desktop: '15px'
        },
        margin: {
          Desktop: '0px 10px 0px 0px'
        },
        borderRadius: {
          Desktop: ' 20px 20px 20px 20px'
        }
      }
    },
    paginationActive: {
      options: {
        class: ''
      },
      styles: {
        backgroundColor: {
          Desktop: '#0003B6F5'
        }
      }
    },
    sliderOptions: {
      perPage: 3,
      perMove: 1,
      gap: '1em'
    },
    sliderOptionsRes: {}
  },
  innerBlocks: [['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}], ['post-grid/content-slider-item', {}]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "70.84",
    cy: "9.35",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "76.15",
    cy: "9.35",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    fill: "#3c3c3b",
    cx: "81.45",
    cy: "9.35",
    r: "1.21"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "4.39",
    y: "52.96",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "7.81",
    y: "56.44",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "18.38",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "57.76",
    y: "52.96",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "61.18",
    y: "56.44",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "53.37",
    y: "18.38",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "111.13",
    y: "52.96",
    width: "36.77",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "114.54",
    y: "56.44",
    width: "29.93",
    height: "1.91",
    rx: "0.69"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "106.73",
    y: "18.38",
    width: "45.55",
    height: "28.38"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    x: "142.66",
    y: "68.75",
    width: "9.63",
    height: "5.68"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M146.85,73a.15.15,0,0,1-.11,0,.16.16,0,0,1,0-.22l1.14-1.14-1.14-1.13a.16.16,0,0,1,.22-.22l1.36,1.35L147,73A.15.15,0,0,1,146.85,73Z"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#3c3c3b",
    y: "68.75",
    width: "9.63",
    height: "5.68",
    transform: "translate(9.63 143.19) rotate(180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fill: "#fff",
    d: "M5.44,70.19a.16.16,0,0,1,.11,0,.16.16,0,0,1,0,.22L4.41,71.59l1.14,1.14a.16.16,0,0,1-.22.22L4.08,71.7a.16.16,0,0,1,0-.22l1.25-1.24A.16.16,0,0,1,5.44,70.19Z"
  }))
}];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (variations);

/***/ }),

/***/ "./src/blocks/flex-wrap-item/index.js":
/*!********************************************!*\
  !*** ./src/blocks/flex-wrap-item/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");













const {
  RawHTML
} = wp.element;













var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)("post-grid/flex-wrap-item", {
  apiVersion: 2,
  title: "Flex Item",
  parent: ['post-grid/flex-wrap'],
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#fff',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      y: "10.4",
      width: "7.49",
      height: "15.2"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "28.51",
      y: "10.4",
      width: "7.49",
      height: "15.2"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("polygon", {
      fill: "#1d4ed8",
      points: "25.18 26.5 22.47 26.5 22.47 24.7 23.37 24.7 23.37 23.79 25.18 23.79 25.18 26.5"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "16.51",
      y: "24.69",
      width: "2.98",
      height: "1.81"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("polygon", {
      fill: "#1d4ed8",
      points: "13.53 26.5 10.82 26.5 10.82 23.79 12.63 23.79 12.63 24.7 13.53 24.7 13.53 26.5"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "10.82",
      y: "16.07",
      width: "1.81",
      height: "3.86"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("polygon", {
      fill: "#1d4ed8",
      points: "12.63 12.21 10.82 12.21 10.82 9.5 13.53 9.5 13.53 11.3 12.63 11.3 12.63 12.21"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "16.51",
      y: "9.5",
      width: "2.98",
      height: "1.81"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("polygon", {
      fill: "#1d4ed8",
      points: "25.18 12.21 23.37 12.21 23.37 11.3 22.47 11.3 22.47 9.5 25.18 9.5 25.18 12.21"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "23.37",
      y: "16.07",
      width: "1.81",
      height: "3.86"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: 'flex-item-wrap'
        },
        styles: {
          backgroundColor: {
            Desktop: ''
          },
          flexBasis: {
            Desktop: '0'
          },
          flexGrow: {
            Desktop: '1'
          }
        }
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": false
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var wrapper = attributes.wrapper;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType']; //const [breakPointX, setBreakPointX] = useState(myStore.getBreakPoint());

    var breakPointX = myStore.getBreakPoint(); // Wrapper CSS Class Selectors

    var wrapperSelector = blockClass;
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);

    function generateElementSudoCss(obj) {
      var stylesObj = {};
      Object.entries(obj).map(args => {
        var sudoSrc = args[0];
        var sudoArgs = args[1];

        if (sudoSrc != 'options') {
          var selector = myStore.getElementSelector(sudoSrc, wrapperSelector); //console.log(selector);
          //console.log(sudoArgs);

          Object.entries(args[1]).map(x => {
            var attr = x[0];
            var cssPropty = myStore.cssAttrParse(attr);

            if (stylesObj[selector] == undefined) {
              stylesObj[selector] = {};
            }

            if (stylesObj[selector][cssPropty] == undefined) {
              stylesObj[selector][cssPropty] = {};
            }

            stylesObj[selector][cssPropty] = x[1];
          });
        } //console.log(stylesObj);

      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      }; //console.log(cssItemsX);

      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      //console.log(wrapper);
      //setAttributes({ customCss: customCss });
      ///myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      var elementCss = generateElementSudoCss(wrapper); //console.log(elementCss);
    }, [wrapper]); // var breakPointList = [{ label: 'Select..', icon: '', value: '' }];
    // for (var x in breakPoints) {
    //   var item = breakPoints[x];
    //   breakPointList.push({ label: item.name, icon: item.icon, value: item.id })
    // }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onBulkAddWrapper(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, wrapper);
      obj[sudoScource] = cssObj;
      setAttributes({
        wrapper: obj
      });
      var selector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    const MY_TEMPLATE = [//['core/paragraph', { placeholder: '', content: 'Hello Text...' }],
    ];
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps)({
      className: ` ${blockId} pg-flex-wrap-item border border-dashed`
    }); //const isParentOfSelectedBlock = useSelect((select) => select('core/block-editor').hasSelectedInnerBlock(clientId, true))

    const innerBlocksProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useInnerBlocksProps)(blockProps, {
      //allowedBlocks: ALLOWED_BLOCKS,
      template: MY_TEMPLATE,
      //orientation: 'horizontal',
      templateInsertUpdatesSelection: true,
      renderAppender: _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InnerBlocks.ButtonBlockAppender
    });
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InspectorControls, {
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: ""
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_16__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: { ...wrapper,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_18__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper,
      onBulkAdd: onBulkAddWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Text "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, wrapperSelector, '{}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_13__["default"], {
      utm: {
        utm_source: 'BlockText',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", innerBlocksProps, innerBlocksProps.children));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    var attributes = props.attributes;
    var wrapper = attributes.wrapper;
    var blockId = attributes.blockId;
    const blockProps = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps.save({
      className: ` ${blockId} pg-flex-wrap-item`
    });
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InnerBlocks.Content, null);
  }
});

/***/ }),

/***/ "./src/blocks/flex-wrap/index.js":
/*!***************************************!*\
  !*** ./src/blocks/flex-wrap/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _variations__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./variations */ "./src/blocks/flex-wrap/variations.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");

















const {
  RawHTML
} = wp.element;














var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)("post-grid/flex-wrap", {
  apiVersion: 2,
  title: "Flex Wrap",
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#fff',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      y: "9.59",
      width: "8.29",
      height: "16.82"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "27.71",
      y: "9.59",
      width: "8.29",
      height: "16.82"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#1d4ed8",
      x: "11.05",
      y: "9.59",
      width: "13.9",
      height: "16.82"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: ''
        },
        styles: {
          display: {
            Desktop: 'flex'
          }
        }
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    align: ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var wrapper = attributes.wrapper;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY;
    var postId = context['postId'];
    var postType = context['postType']; //const [breakPointX, setBreakPointX] = useState(myStore.getBreakPoint());

    var breakPointX = myStore.getBreakPoint(); // Wrapper CSS Class Selectors

    var wrapperSelector = blockClass;
    const {
      replaceInnerBlocks
    } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.store);
    const hasInnerBlocks = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.store).getBlocks(clientId).length > 0, [clientId]); //console.log(JSON.stringify(wp.data.select(blockEditorStore).getBlocks(clientId)));

    var icons = {
      bed: '',
      layout: '',
      smiley: '',
      columns: '',
      globe: ''
    };
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss); // blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector], 'display': { "Desktop": "flex" } };
      //blockCssY.items[wrapperSelector] = { ...blockCssY.items[wrapperSelector], 'gap': { "Desktop": "1em" } };

      setAttributes({
        blockCssY: {
          items: blockCssY.items
        }
      }); //setAttributes({ wrapper: { ...wrapper, styles: { display: { Desktop: 'flex' }, gap: { Desktop: '20px' } } } });
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);

    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }

    function applyFlex(attr, newVal) {
      onChangeStyleWrapper('styles', newVal, attr);
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onBulkAddWrapper(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, wrapper);
      obj[sudoScource] = cssObj;
      setAttributes({
        wrapper: obj
      });
      var selector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    const ALLOWED_BLOCKS = ['post-grid/flex-wrap-item'];
    const MY_TEMPLATE = [['post-grid/flex-wrap-item', {}], ['post-grid/flex-wrap-item', {}], ['post-grid/flex-wrap-item', {}]];
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps)({
      className: ` ${blockId} pg-flex-wrap `
    });
    const innerBlocksProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useInnerBlocksProps)(blockProps, {
      allowedBlocks: ALLOWED_BLOCKS,
      //template: MY_TEMPLATE,
      orientation: 'horizontal',
      templateInsertUpdatesSelection: true //renderAppender: InnerBlocks.ButtonBlockAppender

    });
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Flex Options",
      initialOpen: true
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: "",
      className: "block my-3"
    }, "Justify Content"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "grid grid-cols-4 gap-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.justifyContent == undefined ? "bg-[#5655ff]" : wrapper.styles.justifyContent[breakPointX] == 'flex-start' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('justifyContent', 'flex-start');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Flex Start"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "5.5",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "5.5",
      y: "5.5",
      width: "3.67",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "11.44",
      y: "5.5",
      width: "3.67",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "17.39",
      y: "5.5",
      width: "3.67",
      height: "25"
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.justifyContent == undefined ? "bg-[#5655ff]" : wrapper.styles.justifyContent[breakPointX] == 'flex-end' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('justifyContent', 'flex-end');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Flex End"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "5.5",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "14.94",
      y: "5.5",
      width: "3.67",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "20.88",
      y: "5.5",
      width: "3.67",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "26.83",
      y: "5.5",
      width: "3.67",
      height: "25"
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.justifyContent == undefined ? "bg-[#5655ff]" : wrapper.styles.justifyContent[breakPointX] == 'center' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('justifyContent', 'center');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Center"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "5.5",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "10.22",
      y: "5.5",
      width: "3.67",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "16.16",
      y: "5.5",
      width: "3.67",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "22.11",
      y: "5.5",
      width: "3.67",
      height: "25"
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.justifyContent == undefined ? "bg-[#5655ff]" : wrapper.styles.justifyContent[breakPointX] == 'space-between' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('justifyContent', 'space-between');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Space Between"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "5.5",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "5.5",
      y: "5.5",
      width: "3.67",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "16.16",
      y: "5.5",
      width: "3.67",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "26.83",
      y: "5.5",
      width: "3.67",
      height: "25"
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.justifyContent == undefined ? "bg-[#5655ff]" : wrapper.styles.justifyContent[breakPointX] == 'space-around' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('justifyContent', 'space-around');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Space Around"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "5.5",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "7.34",
      y: "5.5",
      width: "3.67",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "16.12",
      y: "5.5",
      width: "3.67",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "24.9",
      y: "5.5",
      width: "3.67",
      height: "25"
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.justifyContent == undefined ? "bg-[#5655ff]" : wrapper.styles.justifyContent[breakPointX] == 'space-evenly' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('justifyContent', 'space-evenly');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Space Evenly"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "5.5",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "9.12",
      y: "5.5",
      width: "3.67",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "16.16",
      y: "5.5",
      width: "3.67",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "23.2",
      y: "5.5",
      width: "3.67",
      height: "25"
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: "",
      className: "my-3 block"
    }, "Align Items"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "grid grid-cols-4 gap-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.alignItems == undefined ? "bg-[#5655ff]" : wrapper.styles.alignItems[breakPointX] == 'flex-start' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('alignItems', 'flex-start');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Flex Start"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "5.5",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "9.12",
      y: "5.5",
      width: "3.67",
      height: "8.88"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "16.16",
      y: "5.5",
      width: "3.67",
      height: "16.42"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "23.2",
      y: "5.5",
      width: "3.67",
      height: "12.5"
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.alignItems == undefined ? "bg-[#5655ff]" : wrapper.styles.alignItems[breakPointX] == 'flex-end' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('alignItems', 'flex-end');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Flex End"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "5.5",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "23.2",
      y: "21.62",
      width: "3.67",
      height: "8.88",
      transform: "translate(50.08 52.12) rotate(180)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "16.16",
      y: "14.08",
      width: "3.67",
      height: "16.42",
      transform: "translate(36 44.58) rotate(180)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "9.12",
      y: "18",
      width: "3.67",
      height: "12.5",
      transform: "translate(21.92 48.5) rotate(180)"
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.alignItems == undefined ? "bg-[#5655ff]" : wrapper.styles.alignItems[breakPointX] == 'center' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('alignItems', 'center');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Center"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "5.5",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "23.2",
      y: "13.56",
      width: "3.67",
      height: "8.88",
      transform: "translate(50.08 36) rotate(180)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "16.16",
      y: "9.79",
      width: "3.67",
      height: "16.42",
      transform: "translate(36 36) rotate(180)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "9.12",
      y: "13.56",
      width: "3.67",
      height: "8.88",
      transform: "translate(21.92 36) rotate(180)"
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.alignItems == undefined ? "bg-[#5655ff]" : wrapper.styles.alignItems[breakPointX] == 'stretch' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('alignItems', 'stretch');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Stretch"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "5.5",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "23.2",
      y: "9.79",
      width: "3.67",
      height: "16.42",
      transform: "translate(50.08 36) rotate(180)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "16.16",
      y: "9.79",
      width: "3.67",
      height: "16.42",
      transform: "translate(36 36) rotate(180)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "9.12",
      y: "9.79",
      width: "3.67",
      height: "16.42",
      transform: "translate(21.92 36) rotate(180)"
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: "",
      className: "my-3 block"
    }, "Flex Direction"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "grid grid-cols-4 gap-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.flexDirection == undefined ? "bg-[#5655ff]" : wrapper.styles.flexDirection[breakPointX] == 'row' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('flexDirection', 'row');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Row"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "5.5",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "5.5",
      y: "9.52",
      width: "3.67",
      height: "16.42"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("polygon", {
      fill: "#fff",
      points: "24.95 12.19 23.25 13.85 25.93 16.51 13.19 16.51 12.33 16.5 12.31 18.91 25.95 18.91 23.29 21.57 24.95 23.27 30.5 17.73 24.95 12.19"
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.flexDirection == undefined ? "bg-[#5655ff]" : wrapper.styles.flexDirection[breakPointX] == 'row-reverse' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('flexDirection', 'row-reverse');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Row Reverse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "5.5",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "26.83",
      y: "9.52",
      width: "3.67",
      height: "16.42",
      transform: "translate(57.33 35.45) rotate(-180)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("polygon", {
      fill: "#fff",
      points: "11.05 12.19 12.75 13.85 10.07 16.51 22.81 16.51 23.67 16.5 23.69 18.91 10.04 18.91 12.71 21.57 11.05 23.27 5.5 17.73 11.05 12.19"
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.flexDirection == undefined ? "bg-[#5655ff]" : wrapper.styles.flexDirection[breakPointX] == 'column' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('flexDirection', 'column');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Column"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "5.5",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "16.16",
      y: "20.45",
      width: "3.67",
      height: "16.42",
      transform: "translate(-10.66 46.66) rotate(-90)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("polygon", {
      fill: "#fff",
      points: "23.54 11.05 21.88 12.75 19.21 10.07 19.21 22.81 19.22 23.67 16.82 23.69 16.81 10.04 14.16 12.71 12.46 11.05 18 5.5 23.54 11.05"
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.flexDirection == undefined ? "bg-[#5655ff]" : wrapper.styles.flexDirection[breakPointX] == 'column-reverse' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('flexDirection', 'column-reverse');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Column-reverse"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "5.5",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "16.16",
      y: "-0.87",
      width: "3.67",
      height: "16.42",
      transform: "translate(25.34 -10.66) rotate(90)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("polygon", {
      fill: "#fff",
      points: "12.46 24.95 14.13 23.25 16.79 25.93 16.79 13.19 16.78 12.33 19.18 12.31 19.19 25.95 21.84 23.29 23.54 24.95 18 30.5 12.46 24.95"
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: "",
      className: "my-3 block"
    }, "Flex Wrap"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "grid grid-cols-4 gap-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.flexWrap == undefined ? "bg-[#5655ff]" : wrapper.styles.flexWrap[breakPointX] == 'wrap' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('flexWrap', 'wrap');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Space"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "6.08",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "16.16",
      y: "1.95",
      width: "3.67",
      height: "25",
      transform: "translate(32.45 -3.55) rotate(90)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("polygon", {
      fill: "#fff",
      points: "16.79 18.15 15.81 19.11 17.35 20.65 6.01 20.65 5.51 20.64 5.5 22.03 17.37 22.03 15.83 23.56 16.79 24.54 19.99 21.35 16.79 18.15"
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.flexWrap == undefined ? "bg-[#5655ff]" : wrapper.styles.flexWrap[breakPointX] == 'wrap-reverse' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('flexWrap', 'wrap-reverse');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Space"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "6.08",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "16.16",
      y: "10.21",
      width: "3.67",
      height: "25",
      transform: "translate(40.71 4.71) rotate(90)"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("polygon", {
      fill: "#fff",
      points: "8.7 19.01 9.68 18.05 8.14 16.51 19.48 16.51 19.98 16.51 19.99 15.13 8.12 15.12 9.66 13.6 8.7 12.61 5.5 15.81 8.7 19.01"
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `hover:bg-[#3737c7] cursor-pointer ${wrapper.styles.flexWrap == undefined ? "bg-[#5655ff]" : wrapper.styles.flexWrap[breakPointX] == 'nowrap' ? "bg-[#1f1f8b]" : "bg-[#5655ff]"}`,
      onClick: ev => {
        applyFlex('flexWrap', 'nowrap');
      }
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Tooltip, {
      text: "Space"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#5655ff",
      x: "5.5",
      y: "6.08",
      width: "25",
      height: "25"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      fill: "#fff",
      x: "16.16",
      y: "5.5",
      width: "3.67",
      height: "25",
      transform: "translate(36) rotate(90)"
    })))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Wrapper Tag"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: wrapper.options.tag,
      options: [{
        label: 'Choose',
        value: ''
      }, {
        label: 'H1',
        value: 'h1'
      }, {
        label: 'H2',
        value: 'h2'
      }, {
        label: 'H3',
        value: 'h3'
      }, {
        label: 'H4',
        value: 'h4'
      }, {
        label: 'H5',
        value: 'h5'
      }, {
        label: 'H6',
        value: 'h6'
      }, {
        label: 'SPAN',
        value: 'span'
      }, {
        label: 'DIV',
        value: 'div'
      }, {
        label: 'P',
        value: 'p'
      }],
      onChange: newVal => {
        var options = { ...wrapper.options,
          tag: newVal
        };
        setAttributes({
          wrapper: { ...wrapper,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper,
      onBulkAdd: onBulkAddWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Custom Style",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: ""
    }, "Please use following class selector to apply your custom CSS"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "my-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "font-bold"
    }, "Text "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("code", null, wrapperSelector, '{}', " "))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.TextareaControl, {
      label: "Custom CSS",
      help: "Do not use 'style' tag",
      value: customCss,
      onChange: value => {
        setAttributes({
          customCss: value
        });
      }
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_contact_support__WEBPACK_IMPORTED_MODULE_13__["default"], {
      utm: {
        utm_source: 'BlockText',
        utm_campaign: 'PostGridCombo',
        utm_content: 'BlockOptions'
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, !hasInnerBlocks && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", innerBlocksProps, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "border p-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex justify-between mb-5"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "text-xl rounded-sm"
    }, "Click to pick a variation"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "bg-orange-400 hover:bg-orange-300 px-4 py-1 text-white cursor-pointer",
      onClick: ev => {
        replaceInnerBlocks(clientId, (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.createBlocksFromInnerBlocksTemplate)([['post-grid/flex-wrap-item', {
          "wrapper": {
            "options": {
              "tag": "div",
              "class": "flex-item-wrap"
            },
            "styles": {
              "flexBasis": {
                "Desktop": "0"
              },
              "flexGrow": {
                "Desktop": "1"
              }
            }
          }
        }], ['post-grid/flex-wrap-item', {
          "wrapper": {
            "options": {
              "tag": "div",
              "class": "flex-item-wrap"
            },
            "styles": {
              "flexBasis": {
                "Desktop": "0"
              },
              "flexGrow": {
                "Desktop": "1"
              }
            }
          }
        }]]), true);
      }
    }, "Skip")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: ""
    }, _variations__WEBPACK_IMPORTED_MODULE_16__["default"].map(variation => {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "text-center inline-block m-4 w-32 align-top p-4 bg-gray-400 cursor-pointer hover:bg-gray-500 relative",
        onClick: ev => {
          if (variation.isPro) {
            alert('Sorry this variation only vailable in pro version');
            return false;
          }

          var atts = variation.atts;
          var wrapper = { ...atts.wrapper
          };
          var blockCssY = { ...atts.blockCssY
          };
          var customCss = { ...atts.customCss
          };
          var blockCssObj = {};
          blockCssObj[wrapperSelector] = wrapper;
          setAttributes({
            wrapper: wrapper,
            customCss: customCss
          });
          var blockCssRules = myStore.getBlockCssRules(blockCssObj);
          var items = { ...blockCssY.items,
            ...blockCssRules
          };
          setAttributes({
            blockCssY: {
              items: items
            }
          });
          replaceInnerBlocks(clientId, (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.createBlocksFromInnerBlocksTemplate)(variation.innerBlocks), true);
        }
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, variation.icon), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, variation.title), variation.isPro && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "bg-amber-400 rounded-sm text-sm inline-block  bg-opacity-90 text-white hover:text-white absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        className: "block px-3",
        href: 'https://pickplugins.com/post-grid/?utm_source=dropdownComponent&utm_term=proFeature&utm_campaign=pluginPostGrid&utm_medium=' + x.label
      }, "Pro")));
    })))), hasInnerBlocks && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", innerBlocksProps, innerBlocksProps.children)));
  },
  save: function (props) {
    // to make a truly dynamic block, we're handling front end by render_callback under index.php file
    var attributes = props.attributes;
    var wrapper = attributes.wrapper;
    var blockId = attributes.blockId;
    const blockProps = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps.save({
      className: ` ${blockId} pg-flex-wrap`
    });
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InnerBlocks.Content, null); //return null;
  }
});

/***/ }),

/***/ "./src/blocks/flex-wrap/variations.js":
/*!********************************************!*\
  !*** ./src/blocks/flex-wrap/variations.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__);


/**
 * WordPress dependencies
 */


let isProFeature = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.applyFilters)('isProFeature', true);
/**
 * Template option choices for predefined columns layouts.
 */

const variations = [{
  name: '1-column',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('1 Col'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('1 Col'),
  isDefault: true,
  isPro: false,
  atts: {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-wrap"
      },
      "styles": {
        "display": {
          "Desktop": "flex"
        },
        "gap": {
          "Desktop": "1em"
        }
      }
    }
  },
  innerBlocks: [['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "flexBasis": {
          "Desktop": "0"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    width: "152.29",
    height: "82.57"
  }))
}, {
  name: '2-columns',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('2-columns'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('2-columns'),
  isPro: false,
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "119.78",
    width: "32.5",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "79.58",
    width: "72.71",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    width: "72.71",
    height: "82.57"
  })),
  atts: {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-wrap"
      },
      "styles": {
        "display": {
          "Desktop": "flex"
        },
        "gap": {
          "Desktop": "1em"
        }
      }
    }
  },
  innerBlocks: [['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "flexBasis": {
          "Desktop": "0"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "flexBasis": {
          "Desktop": "0"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }]],
  scope: ['block']
}, {
  name: '3-columns',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('3-columns'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('3-columns'),
  isPro: false,
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    width: "46.18",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "53.05",
    width: "99.24",
    height: "82.57"
  })),
  atts: {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-wrap"
      },
      "styles": {
        "display": {
          "Desktop": "flex"
        },
        "gap": {
          "Desktop": "1em"
        }
      }
    }
  },
  innerBlocks: [['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "flexBasis": {
          "Desktop": "0"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "flexBasis": {
          "Desktop": "0"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "flexBasis": {
          "Desktop": "0"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    width: "46.18",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "53.05",
    width: "46.18",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "106.1",
    width: "46.18",
    height: "82.57"
  }))
}, {
  name: '4-columns',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('4-columns'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('4-columns'),
  isPro: false,
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    width: "39.15",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "46.02",
    width: "60.25",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "113.14",
    width: "39.15",
    height: "82.57"
  })),
  atts: {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-wrap"
      },
      "styles": {
        "display": {
          "Desktop": "flex"
        },
        "gap": {
          "Desktop": "1em"
        }
      }
    }
  },
  innerBlocks: [['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "25%"
        },
        "flexBasis": {
          "Desktop": "0"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "25%"
        },
        "flexBasis": {
          "Desktop": "0"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "25%"
        },
        "flexBasis": {
          "Desktop": "0"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "25%"
        },
        "flexBasis": {
          "Desktop": "0"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    width: "32.5",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "40.21",
    width: "31.66",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "80.41",
    width: "31.66",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "120.62",
    width: "31.66",
    height: "82.57"
  }))
}, {
  name: '5-columns',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('5-columns'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('5-columns'),
  isPro: false,
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    width: "39.15",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "46.02",
    width: "60.25",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "113.14",
    width: "39.15",
    height: "82.57"
  })),
  atts: {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-wrap"
      },
      "styles": {
        "display": {
          "Desktop": "flex"
        },
        "gap": {
          "Desktop": "1em"
        }
      }
    }
  },
  innerBlocks: [['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "25%"
        },
        "flexBasis": {
          "Desktop": "0"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "25%"
        },
        "flexBasis": {
          "Desktop": "0"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "25%"
        },
        "flexBasis": {
          "Desktop": "0"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "25%"
        },
        "flexBasis": {
          "Desktop": "0"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "25%"
        },
        "flexBasis": {
          "Desktop": "0"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    width: "25.5",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "31.7",
    width: "25.5",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "63.4",
    width: "25.5",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "95.09",
    width: "25.5",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "126.79",
    width: "25.5",
    height: "82.57"
  }))
}, {
  name: '33-66',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('33-66'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('33-66'),
  isDefault: true,
  isPro: !isProFeature ? false : true,
  atts: {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-wrap"
      },
      "styles": {
        "display": {
          "Desktop": "flex"
        },
        "gap": {
          "Desktop": "1em"
        }
      }
    }
  },
  innerBlocks: [['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "33%"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "66%"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    width: "46.18",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "53.05",
    width: "99.24",
    height: "82.57"
  }))
}, {
  name: '66-33',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('66-33'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('66-33'),
  isDefault: true,
  isPro: !isProFeature ? false : true,
  atts: {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-wrap"
      },
      "styles": {
        "display": {
          "Desktop": "flex"
        },
        "gap": {
          "Desktop": "1em"
        }
      }
    }
  },
  innerBlocks: [['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "66%"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "33%"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    width: "99.24",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "106.1",
    width: "46.18",
    height: "82.57"
  }))
}, {
  name: '25-50-25',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('25-50-25'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('25-50-25'),
  isDefault: true,
  isPro: !isProFeature ? false : true,
  atts: {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-wrap"
      },
      "styles": {
        "display": {
          "Desktop": "flex"
        },
        "gap": {
          "Desktop": "1em"
        }
      }
    }
  },
  innerBlocks: [['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "25%"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "50%"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "25%"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    width: "39.15",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "46.02",
    width: "60.25",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "113.14",
    width: "39.15",
    height: "82.57"
  }))
}, {
  name: '25-25-50',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('25-25-50'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('25-25-50'),
  isDefault: true,
  isPro: !isProFeature ? false : true,
  atts: {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-wrap"
      },
      "styles": {
        "display": {
          "Desktop": "flex"
        },
        "gap": {
          "Desktop": "1em"
        }
      }
    }
  },
  innerBlocks: [['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "25%"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "25%"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "50%"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    width: "31.29",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "38.16",
    width: "31.29",
    height: "82.57"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "76.33",
    width: "75.96",
    height: "82.57"
  }))
}, {
  name: '50-25-25',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('50-25-25'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('50-25-25'),
  isDefault: true,
  isPro: !isProFeature ? false : true,
  atts: {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-wrap"
      },
      "styles": {
        "display": {
          "Desktop": "flex"
        },
        "gap": {
          "Desktop": "1em"
        }
      }
    }
  },
  innerBlocks: [['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "50%"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "25%"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }], ['post-grid/flex-wrap-item', {
    "wrapper": {
      "options": {
        "tag": "div",
        "class": "flex-item-wrap"
      },
      "styles": {
        "width": {
          "Desktop": "25%"
        },
        "flexGrow": {
          "Desktop": "1"
        }
      }
    }
  }]],
  scope: ['block'],
  icon: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_1",
    "data-name": "Layer 1",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 152.29 82.57"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "120.99",
    width: "31.29",
    height: "82.57",
    transform: "translate(273.28 82.57) rotate(180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    x: "82.83",
    width: "31.29",
    height: "82.57",
    transform: "translate(196.95 82.57) rotate(180)"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    fill: "#1d4ed8",
    width: "75.96",
    height: "82.57",
    transform: "translate(75.96 82.57) rotate(180)"
  }))
}];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (variations);

/***/ }),

/***/ "./src/blocks/form-field-checkbox/index.js":
/*!*************************************************!*\
  !*** ./src/blocks/form-field-checkbox/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../store */ "./src/store.js");
/* harmony import */ var _components_icon_toggle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../components/icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _components_typography__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/typography */ "./src/components/typography/index.js");
/* harmony import */ var _components_mail_subscribe__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/mail-subscribe */ "./src/components/mail-subscribe/index.js");
/* harmony import */ var _components_contact_support__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/contact-support */ "./src/components/contact-support/index.js");
/* harmony import */ var _components_breakpoint_toggle__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/breakpoint-toggle */ "./src/components/breakpoint-toggle/index.js");
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_css_text_align__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/css-text-align */ "./src/components/css-text-align/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_styles__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../components/styles */ "./src/components/styles/index.js");
/* harmony import */ var _components_css_library__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/css-library */ "./src/components/css-library/index.js");















const {
  RawHTML
} = wp.element;












var myStore = wp.data.select('postgrid-shop');
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)("post-grid/form-field-checkbox", {
  apiVersion: 2,
  title: "Form Field - Checkbox",
  parent: ['post-grid/form-wrap'],
  icon: {
    // Specifying a background color to appear with the icon e.g.: in the inserter.
    background: '#fff',
    // Specifying a color for the icon (optional: if not set, a readable color will be automatically defined)
    foreground: '#fff',
    // Specifying an icon for the block
    src: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 36 36"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      fill: "#1d4ed8",
      d: "M17.53,16.56a1.07,1.07,0,0,0-1.06,1.06v7.93H2.12V11.2h7.93a1.06,1.06,0,0,0,0-2.12H1.81A1.81,1.81,0,0,0,0,10.89v15a1.81,1.81,0,0,0,1.81,1.81h15a1.81,1.81,0,0,0,1.81-1.81V17.62A1.06,1.06,0,0,0,17.53,16.56Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      fill: "#1d4ed8",
      d: "M19,11.63l-3-3a1.07,1.07,0,0,0-1.5,0l-9,9a1.06,1.06,0,0,0-.31.75v3A1.07,1.07,0,0,0,6.3,22.43h3a1.06,1.06,0,0,0,.75-.31l9-9A1.07,1.07,0,0,0,19,11.63Zm-4.5,3L8.86,20.31H7.36v-1.5L13,13.14Zm2.25-2.25-.75.75-1.49-1.49.75-.75Z"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
      fill: "#1d4ed8",
      cx: "24.85",
      cy: "25.36",
      r: "2.31"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
      fill: "#1d4ed8",
      cx: "33.69",
      cy: "25.36",
      r: "2.31"
    }))
  },
  attributes: {
    wrapper: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: ''
        },
        styles: {}
      }
    },
    labelWrap: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          enable: true,
          class: ''
        }
      }
    },
    label: {
      type: 'object',
      default: {
        options: {
          tag: 'label',
          for: 'label',
          enable: true,
          text: 'Your Name',
          class: 'pg-form-field-label'
        },
        styles: {}
      }
    },
    item: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: ''
        },
        styles: {}
      }
    },
    itemLabel: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          class: ''
        },
        styles: {}
      }
    },
    input: {
      type: 'object',
      default: {
        options: {
          value: null,
          name: '',
          required: false,
          disabled: false,
          multiple: false,
          autofocus: null,
          readonly: false,
          args: {
            0: {
              label: 'Option 1',
              value: 'option1',
              readonly: false
            },
            1: {
              label: 'Option 2',
              value: 'option2',
              readonly: false
            },
            2: {
              label: 'Option 3',
              value: 'option3',
              readonly: false
            }
          },
          argsSrc: {
            src: '',
            // posts, users, countryNames, countryCodes, Gender, ageGroups
            taxonomy: '',
            postType: [],
            userRole: []
          },
          id: '',
          class: 'pg-form-field-checkbox',
          postion: 'afterLabel' // beforeLabel, afterLabel, insideLabel

        },
        styles: {}
      }
    },
    inputWrap: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          enable: true,
          class: ''
        },
        styles: {}
      }
    },
    errorWrap: {
      type: 'object',
      default: {
        options: {
          tag: 'div',
          enable: true,
          text: '',
          position: 'afterInput',
          class: ''
        },
        styles: {}
      }
    },
    requiredWrap: {
      type: 'object',
      default: {
        options: {
          tag: 'span',
          enable: true,
          class: ''
        },
        styles: {}
      }
    },
    blockId: {
      "type": "string",
      "default": ''
    },
    customCss: {
      "type": "string",
      "default": ''
    },
    blockCssY: {
      "type": "object",
      "default": {
        items: {}
      }
    }
  },
  usesContext: ["postId", "loopIndex", "postType", "queryId"],
  supports: {
    "align": ["wide", "full"]
  },
  category: "post-grid",
  edit: function (props) {
    var attributes = props.attributes;
    var setAttributes = props.setAttributes;
    var context = props.context;
    var clientId = props.clientId;
    var blockId = attributes.blockId;
    var blockIdX = attributes.blockId ? attributes.blockId : 'pg' + clientId.split('-').pop();
    var blockClass = '.' + blockIdX;
    var wrapper = attributes.wrapper;
    var label = attributes.label;
    var input = attributes.input;
    var item = attributes.item;
    var itemLabel = attributes.itemLabel;
    var inputWrap = attributes.inputWrap;
    var errorWrap = attributes.errorWrap;
    var labelWrap = attributes.labelWrap;
    var customCss = attributes.customCss;
    var blockCssY = attributes.blockCssY; //const [breakPointX, setBreakPointX] = useState(myStore.getBreakPoint());

    var breakPointX = myStore.getBreakPoint();
    const [isLoading, setisLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [pramSrcEnable, setpramSrcEnable] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    var [postTypes, setpostTypes] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)({}); // Using the hook.

    var [userRoles, setuserRoles] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)({}); // Using the hook.

    var [taxonomies, settaxonomies] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)({}); // Using the hook.
    // Wrapper CSS Class Selectors

    var wrapperSelector = blockClass;
    var labelSelector = blockClass + ' label';
    var checkboxSelector = blockClass + ' input[type="checkbox"]';
    var labelWrapSelector = blockClass + ' .label-wrap';
    var inputWrapSelector = blockClass + ' .input-wrap';
    var errorWrapSelector = blockClass + ' .error-wrap';
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        blockId: blockIdX
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
      _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default()({
        path: '/post-grid/v2/post_types',
        method: 'POST',
        data: {}
      }).then(res => {
        var types = [];
        Object.entries(res).map(x => {
          var postTypeId = x[0];
          var postTypeLabel = x[1];
          types.push({
            label: postTypeLabel,
            value: postTypeId
          });
        });
        setpostTypes(types);
      });
      _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default()({
        path: '/post-grid/v2/user_roles_list',
        method: 'POST',
        data: {}
      }).then(res => {
        console.log(res);
        var roles = res.roles == undefined ? [] : res.roles;
        var rolesX = [];
        Object.entries(roles).map(role => {
          var index = role[0];
          var val = role[1];
          rolesX.push({
            label: val,
            value: index
          });
        });
        setuserRoles(rolesX);
      });
      _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_6___default()({
        path: '/post-grid/v2/post_type_objects',
        method: 'POST',
        data: {}
      }).then(res => {
        console.log(res);
        var taxItems = [];
        Object.entries(res).map(arg => {
          var index = arg[0];
          var tax = arg[1];
          taxItems.push({
            label: tax.label,
            value: tax.id
          });
        });
        settaxonomies(taxItems);
      });
    }, [clientId]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      setAttributes({
        customCss: customCss
      });
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [customCss]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockId]);

    function handleLinkClick(ev) {
      ev.stopPropagation();
      ev.preventDefault();
      return false;
    }

    function onChangeStyleWrapper(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleWrapper(sudoScource, key) {
      var object = myStore.deletePropertyDeep(wrapper, [sudoScource, key, breakPointX]);
      setAttributes({
        wrapper: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleWrapper(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, wrapper);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        wrapper: object
      });
    }

    function onBulkAddWrapper(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, wrapper);
      obj[sudoScource] = cssObj;
      setAttributes({
        wrapper: obj
      });
      var selector = myStore.getElementSelector(sudoScource, wrapperSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onChangeStyleLabel(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, label);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        label: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleLabel(sudoScource, key) {
      var object = myStore.deletePropertyDeep(label, [sudoScource, key, breakPointX]);
      setAttributes({
        label: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleLabel(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, label);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        label: object
      });
    }

    function onBulkAddLabel(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, label);
      obj[sudoScource] = cssObj;
      setAttributes({
        label: obj
      });
      var selector = myStore.getElementSelector(sudoScource, labelSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onChangeStyleInput(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, input);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        input: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, checkboxSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleInput(sudoScource, key) {
      var object = myStore.deletePropertyDeep(input, [sudoScource, key, breakPointX]);
      setAttributes({
        input: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, checkboxSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleInput(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, input);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        input: object
      });
    }

    function onBulkAddInput(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, input);
      obj[sudoScource] = cssObj;
      setAttributes({
        input: obj
      });
      var selector = myStore.getElementSelector(sudoScource, checkboxSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onChangeStyleLabelWrap(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, labelWrap);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        labelWrap: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelWrapSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleLabelWrap(sudoScource, key) {
      var object = myStore.deletePropertyDeep(labelWrap, [sudoScource, key, breakPointX]);
      setAttributes({
        labelWrap: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, labelWrapSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleLabelWrap(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, labelWrap);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        labelWrap: object
      });
    }

    function onBulkAddLabelWrap(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, labelWrap);
      obj[sudoScource] = cssObj;
      setAttributes({
        labelWrap: obj
      });
      var selector = myStore.getElementSelector(sudoScource, labelWrapSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onChangeStyleInputWrap(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, inputWrap);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        inputWrap: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, inputWrapSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleInputWrap(sudoScource, key) {
      var object = myStore.deletePropertyDeep(inputWrap, [sudoScource, key, breakPointX]);
      setAttributes({
        inputWrap: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, inputWrapSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleInputWrap(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, inputWrap);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        inputWrap: object
      });
    }

    function onBulkAddInputWrap(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, inputWrap);
      obj[sudoScource] = cssObj;
      setAttributes({
        inputWrap: obj
      });
      var selector = myStore.getElementSelector(sudoScource, inputWrapSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    function onChangeStyleErrorWrap(sudoScource, newVal, attr) {
      var path = [sudoScource, attr, breakPointX];
      let obj = Object.assign({}, errorWrap);
      const object = myStore.updatePropertyDeep(obj, path, newVal);
      setAttributes({
        errorWrap: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, errorWrapSelector);
      var cssPropty = myStore.cssAttrParse(attr);
      let itemsX = Object.assign({}, blockCssY.items);

      if (itemsX[elementSelector] == undefined) {
        itemsX[elementSelector] = {};
      }

      var cssPath = [elementSelector, cssPropty, breakPointX];
      const cssItems = myStore.updatePropertyDeep(itemsX, cssPath, newVal);
      setAttributes({
        blockCssY: {
          items: cssItems
        }
      });
    }

    function onRemoveStyleErrorWrap(sudoScource, key) {
      var object = myStore.deletePropertyDeep(errorWrap, [sudoScource, key, breakPointX]);
      setAttributes({
        errorWrap: object
      });
      var elementSelector = myStore.getElementSelector(sudoScource, errorWrapSelector);
      var cssPropty = myStore.cssAttrParse(key);
      var cssObject = myStore.deletePropertyDeep(blockCssY.items, [elementSelector, cssPropty, breakPointX]);
      setAttributes({
        blockCssY: {
          items: cssObject
        }
      });
    }

    function onAddStyleErrorWrap(sudoScource, key) {
      var path = [sudoScource, key, breakPointX];
      let obj = Object.assign({}, errorWrap);
      const object = myStore.addPropertyDeep(obj, path, '');
      setAttributes({
        errorWrap: object
      });
    }

    function onBulkAddErrorWrap(sudoScource, cssObj) {
      // var path = [sudoScource, attr, breakPointX]
      let obj = Object.assign({}, errorWrap);
      obj[sudoScource] = cssObj;
      setAttributes({
        errorWrap: obj
      });
      var selector = myStore.getElementSelector(sudoScource, errorWrapSelector);
      var stylesObj = {};
      Object.entries(cssObj).map(args => {
        var attr = args[0];
        var cssPropty = myStore.cssAttrParse(attr);

        if (stylesObj[selector] == undefined) {
          stylesObj[selector] = {};
        }

        if (stylesObj[selector][cssPropty] == undefined) {
          stylesObj[selector][cssPropty] = {};
        }

        stylesObj[selector][cssPropty] = args[1];
      });
      var cssItems = { ...blockCssY.items
      };
      var cssItemsX = { ...cssItems,
        ...stylesObj
      };
      setAttributes({
        blockCssY: {
          items: cssItemsX
        }
      });
    }

    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      myStore.generateBlockCss(blockCssY.items, blockId, customCss);
    }, [blockCssY]);
    const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps)({
      className: ` ${blockId} pg-form-field-input`
    });
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InspectorControls, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "px-3",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Wrapper",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: wrapper,
      onChange: onChangeStyleWrapper,
      onAdd: onAddStyleWrapper,
      onRemove: onRemoveStyleWrapper,
      onBulkAdd: onBulkAddWrapper
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Label",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Label Wrap",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: labelWrap,
      onChange: onChangeStyleLabelWrap,
      onAdd: onAddStyleLabelWrap,
      onRemove: onRemoveStyleLabelWrap,
      onBulkAdd: onBulkAddLabelWrap
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Label",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.ToggleControl, {
      className: "my-3",
      label: "Enable?",
      help: label.options.enable ? 'Label Enabled' : 'Label Disabled.',
      checked: label.options.enable ? true : false,
      onChange: e => {
        var options = { ...label.options,
          enable: label.options.enable ? false : true
        };
        setAttributes({
          label: { ...label,
            options: options
          }
        });
      }
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, {
      className: "mb-4"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Label Text"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
      className: "mr-2",
      value: label.options.text,
      onChange: newVal => {
        var options = { ...label.options,
          text: newVal
        };
        setAttributes({
          label: { ...label,
            options: options
          }
        });
      }
    }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: label,
      onChange: onChangeStyleLabel,
      onAdd: onAddStyleLabel,
      onRemove: onRemoveStyleLabel,
      onBulkAdd: onBulkAddLabel
    }))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Input",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Input Wrap",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "styles"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_styles__WEBPACK_IMPORTED_MODULE_19__["default"], {
      obj: inputWrap,
      onChange: onChangeStyleInputWrap,
      onAdd: onAddStyleInputWrap,
      onRemove: onRemoveStyleInputWrap,
      onBulkAdd: onBulkAddInputWrap
    })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelBody, {
      title: "Checkbox",
      initialOpen: false
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
      activeTab: "options",
      orientation: "horizontal",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: 'options',
        title: 'Options',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"],
        className: 'tab-settings'
      }, {
        name: 'styles',
        title: 'Styles',
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"],
        className: 'tab-style'
      }]
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
      name: "options"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "bg-blue-500 px-3 py-2 rounded-sm text-white inline-block my-3 mr-2 cursor-pointer",
      onClick: ev => {
        var options = { ...input.options
        };
        var args = options.args;
        var length = Object.entries(input.options.args).length;
        args[length] = {
          label: '',
          value: ''
        };
        setAttributes({
          input: { ...input,
            options: options
          }
        });
      }
    }, "Add Option"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: " inline-block  mr-2 relative"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "bg-blue-500 px-3 py-2 rounded-sm text-white inline-block my-3 mr-2 cursor-pointer ",
      onClick: ev => {
        setpramSrcEnable(!pramSrcEnable);
      }
    }, "Pram Source"), pramSrcEnable && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.Popover, {
      position: "bottom left"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "p-3 w-64"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Source Type"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: input.options.argsSrc.src,
      options: [{
        label: 'None',
        value: ''
      }, {
        label: 'Taxonomy',
        value: 'taxonomy'
      }, {
        label: 'Posts',
        value: 'posts'
      }, {
        label: 'Users',
        value: 'users'
      }, {
        label: 'Country Names',
        value: 'countryNames'
      }, {
        label: 'Country Codes',
        value: 'countryCodes'
      }, {
        label: 'Gender',
        value: 'gender'
      }, {
        label: 'Age Groups',
        value: 'ageGroups'
      }],
      onChange: newVal => {
        var options = { ...input.options
        };
        var argsSrc = options.argsSrc;
        argsSrc.src = newVal;
        setAttributes({
          input: { ...input,
            options: options
          }
        });
      }
    })), input.options.argsSrc.src == 'posts' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Post Type"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      multiple: true,
      value: input.options.argsSrc.postType,
      options: postTypes,
      onChange: newVal => {
        var options = { ...input.options
        };
        var argsSrc = options.argsSrc;
        argsSrc.postType = newVal;
        setAttributes({
          input: { ...input,
            options: options
          }
        });
      }
    }))), input.options.argsSrc.src == 'taxonomy' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "Choose Taxonomy"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      value: input.options.argsSrc.taxonomy,
      options: taxonomies,
      onChange: newVal => {
        var options = { ...input.options
        };
        var argsSrc = options.argsSrc;
        argsSrc.taxonomy = newVal;
        setAttributes({
          input: { ...input,
            options: options
          }
        });
      }
    }))), input.options.argsSrc.src == 'users' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
      for: ""
    }, "User Role"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.SelectControl, {
      label: "",
      multiple: true,
      value: input.options.argsSrc.userRole,
      options: userRoles,
      onChange: newVal => {
        var options = { ...input.options
        };
        var argsSrc = options.argsSrc;
        argsSrc.userRole = newVal;
        setAttributes({
          input: { ...input,
            options: options
          }
        });
      }
    })))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, input.options.argsSrc.src.length == 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, Object.entries(input.options.args).map(item => {
      var index = item[0];
      var arg = item[1];
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "flex justify-between items-center my-3"
      }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        className: "mr-2",
        value: arg.label,
        placeholder: "Option Label",
        onChange: newVal => {
          var options = { ...input.options
          };
          var args = options.args;
          args[index].label = newVal;
          setAttributes({
            input: { ...input,
              options: options
            }
          });
        }
      }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__.__experimentalInputControl, {
        className: "mr-2",
        placeholder: "Option Value",
        value: arg.value,
        onChange: newVal => {
          var options = { ...input.options
          };
          var args = options.args;
          args[index].value = newVal;
          setAttributes({
