/**
 * WordPress dependencies
 */
import { __ } from '@wordpress/i18n';
import { applyFilters } from '@wordpress/hooks';

let isProFeature = applyFilters('isProFeature', true);



/**
 * Template option choices for predefined columns layouts.
 */
const variations = [

    {
        name: 'layout-1',
        title: __('layout-1'),
        description: __('layout-1'),

        isPro: false,
        //isPro: !isProFeature ? false : true,
        atts: {
            wrapper: { "options": { "tag": "div", "class": "" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "margin": {}, "paddingBottom": { "Desktop": "50px" } } }, progressData: { "type": "horizontal", "animate": "onVisible", "animateDuration": 1, "animateIteration": 2, "animateDelay": 2, "fill": 45, "unit": "%" }, progressInfo: { "options": { "tag": "div", "class": "", "position": "beforeBar" }, "styles": { "display": { "Desktop": "flex" }, "justifyContent": { "Desktop": "space-between" }, "padding": { "Desktop": "10px 0px 10px 0px" } } }, progressBar: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "backgroundColor": { "Desktop": "#9DD6DF" }, "height": { "Desktop": "50px" } } }, progressFill: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "backgroundColor": { "Desktop": "#18978F" }, "height": { "Desktop": "50px" }, "width": { "Desktop": "40%" } } }, progressCount: { "options": { "position": "afterLabel", "class": "" }, "styles": { "color": { "Desktop": "" }, "fontSize": { "Desktop": "" } } }, progressLabel: { "options": { "text": "Digital Marketing", "position": "", "class": "" }, "styles": { "color": { "Desktop": "" }, "fontSize": { "Desktop": "" } } }, icon: { "options": { "library": "fontAwesome", "position": "beforeprogressCount", "srcType": "class", "iconSrc": "far fa-calendar-alt", "class": "number-count-icon" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "fontSize": { "Desktop": "" } } },


            circleMask: {},
            circleOverlay: {},


            blockId: "", customCss: "", blockCssY: { items: {} }
        },
        scope: ['block'],
        icon: (
            <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 75 20"><path fill="#1d1d1b" d="M5.77,5.83a5.27,5.27,0,0,1,.74,0,1.54,1.54,0,0,1,1.09.33,1.26,1.26,0,0,1,.38,1,1.44,1.44,0,0,1-.39,1.05,1.67,1.67,0,0,1-1.19.39c-.25,0-.46,0-.63,0Zm.35,2.39.35,0A1,1,0,0,0,7.61,7.09a1,1,0,0,0-1.09-1,1.82,1.82,0,0,0-.4,0Z" /><path fill="#1d1d1b" d="M8.81,6a.21.21,0,0,1-.22.22A.21.21,0,0,1,8.38,6a.22.22,0,0,1,.22-.22A.21.21,0,0,1,8.81,6ZM8.42,8.49V6.56h.35V8.49Z" /><path fill="#1d1d1b" d="M11,6.56c0,.14,0,.29,0,.53V8.21a1.12,1.12,0,0,1-.28.89,1.05,1.05,0,0,1-.7.23,1.3,1.3,0,0,1-.65-.16l.09-.27a1.11,1.11,0,0,0,.57.15c.36,0,.62-.19.62-.67V8.16h0a.67.67,0,0,1-.61.33.87.87,0,0,1-.82-1,.93.93,0,0,1,.87-1,.64.64,0,0,1,.6.34h0V6.56Zm-.36.76a.78.78,0,0,0,0-.16.52.52,0,0,0-.49-.37c-.34,0-.58.28-.58.73s.19.7.57.7a.52.52,0,0,0,.49-.36.63.63,0,0,0,0-.19Z" /><path fill="#1d1d1b" d="M12,6a.21.21,0,0,1-.22.22A.22.22,0,0,1,11.52,6a.22.22,0,0,1,.22-.22A.21.21,0,0,1,12,6Zm-.39,2.48V6.56h.35V8.49Z" /><path fill="#1d1d1b" d="M12.93,6v.56h.5v.27h-.5v1c0,.24.07.37.26.37l.21,0v.27a1.17,1.17,0,0,1-.31,0,.48.48,0,0,1-.38-.15.7.7,0,0,1-.14-.5v-1h-.3V6.56h.3V6.09Z" /><path fill="#1d1d1b" d="M14.9,8.49l0-.24h0a.74.74,0,0,1-.59.29A.55.55,0,0,1,13.68,8c0-.47.41-.72,1.16-.72v0a.4.4,0,0,0-.44-.45.92.92,0,0,0-.5.15l-.09-.23a1.2,1.2,0,0,1,.64-.18c.59,0,.74.41.74.8V8a2.17,2.17,0,0,0,0,.46Zm-.05-1c-.39,0-.82.06-.82.43a.31.31,0,0,0,.33.34A.49.49,0,0,0,14.83,8a.36.36,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M15.76,5.65h.35V8.49h-.35Z" /><path fill="#1d1d1b" d="M19.83,7.31c0-.38,0-.83,0-1.16h0c-.09.31-.21.65-.34,1L19,8.48H18.7l-.44-1.29c-.13-.38-.23-.72-.31-1h0c0,.33,0,.78-.05,1.19l-.07,1.15h-.33l.19-2.69h.44l.46,1.3c.11.33.2.63.27.91h0c.07-.27.17-.57.29-.91l.48-1.3h.44l.17,2.69H19.9Z" /><path fill="#1d1d1b" d="M21.86,8.49l0-.24h0a.74.74,0,0,1-.59.29A.55.55,0,0,1,20.64,8c0-.47.41-.72,1.16-.72v0a.4.4,0,0,0-.44-.45,1,1,0,0,0-.51.15l-.08-.23a1.2,1.2,0,0,1,.64-.18c.59,0,.74.41.74.8V8a2.17,2.17,0,0,0,0,.46Zm-.05-1c-.39,0-.82.06-.82.43a.31.31,0,0,0,.33.34A.49.49,0,0,0,21.79,8a.36.36,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M22.71,7.16c0-.23,0-.42,0-.6H23v.38h0a.59.59,0,0,1,.54-.43l.1,0v.33h-.12a.49.49,0,0,0-.47.45.78.78,0,0,0,0,.16v1h-.35Z" /><path fill="#1d1d1b" d="M24.39,7.44h0l.18-.21.56-.67h.43l-.75.79.85,1.14h-.43l-.66-.92-.18.2v.72H24V5.65h.35Z" /><path fill="#1d1d1b" d="M26.11,7.59a.62.62,0,0,0,.66.67,1.2,1.2,0,0,0,.54-.1l.06.25a1.5,1.5,0,0,1-.64.12.9.9,0,0,1-1-1,1,1,0,0,1,.91-1,.83.83,0,0,1,.8.92c0,.07,0,.12,0,.16Zm1-.25a.49.49,0,0,0-.49-.57.58.58,0,0,0-.54.57Z" /><path fill="#1d1d1b" d="M28.34,6v.56h.51v.27h-.51v1c0,.24.07.37.27.37l.2,0,0,.27a1.19,1.19,0,0,1-.32,0,.49.49,0,0,1-.38-.15.7.7,0,0,1-.13-.5v-1h-.3V6.56H28V6.09Z" /><path fill="#1d1d1b" d="M29.63,6a.2.2,0,0,1-.22.22.22.22,0,0,1,0-.44A.21.21,0,0,1,29.63,6Zm-.39,2.48V6.56h.35V8.49Z" /><path fill="#1d1d1b" d="M30.18,7.08c0-.2,0-.36,0-.52h.31l0,.32h0a.71.71,0,0,1,.64-.37c.27,0,.69.16.69.83V8.49h-.36V7.38c0-.31-.11-.57-.44-.57a.5.5,0,0,0-.48.36.7.7,0,0,0,0,.16V8.49h-.35Z" /><path fill="#1d1d1b" d="M34.07,6.56c0,.14,0,.29,0,.53V8.21a1.12,1.12,0,0,1-.28.89,1,1,0,0,1-.7.23,1.26,1.26,0,0,1-.64-.16l.08-.27a1.11,1.11,0,0,0,.57.15.59.59,0,0,0,.63-.67V8.16h0a.7.7,0,0,1-.62.33.87.87,0,0,1-.82-1,.94.94,0,0,1,.87-1,.63.63,0,0,1,.6.34h0l0-.29Zm-.37.76a.41.41,0,0,0,0-.16.5.5,0,0,0-.49-.37c-.34,0-.58.28-.58.73s.2.7.58.7a.51.51,0,0,0,.48-.36.63.63,0,0,0,0-.19Z" /><path fill="#1d1d1b" d="M63.53,8.49V7.78H62.32V7.55l1.16-1.66h.38V7.51h.37v.27h-.37v.71Zm0-1V6.64c0-.13,0-.27,0-.41h0c-.08.16-.14.27-.21.39l-.64.88h.85Z" /><path fill="#1d1d1b" d="M66.05,6.19h-1l-.1.67.21,0a1.16,1.16,0,0,1,.56.14.75.75,0,0,1,.37.67.9.9,0,0,1-1,.89,1.31,1.31,0,0,1-.65-.16l.09-.27a1.23,1.23,0,0,0,.56.14.57.57,0,0,0,.61-.56c0-.34-.22-.58-.74-.58a2.87,2.87,0,0,0-.36,0l.16-1.25h1.25Z" /><path fill="#1d1d1b" d="M67.72,6.63c0,.54-.29.81-.62.81s-.61-.25-.61-.78.28-.81.63-.81S67.72,6.13,67.72,6.63Zm-1,0c0,.33.11.58.33.58s.34-.24.34-.59-.09-.58-.34-.58S66.77,6.32,66.77,6.65Zm.3,1.89L68.6,5.85h.22L67.3,8.54Zm2.34-.84c0,.55-.29.82-.62.82s-.6-.26-.61-.78.29-.81.63-.81S69.41,7.21,69.41,7.7Zm-1,0c0,.33.12.58.34.58s.34-.25.34-.59-.1-.58-.34-.58S68.46,7.4,68.46,7.73Z" /><rect fill="#3c4c9b" x="5.46" y="10.86" width="22.15" height="4" /><rect fill="#7480b8" x="27.62" y="10.86" width="41.92" height="4" /></svg>
        ),

    },


    {
        name: 'layout-2',
        title: __('layout-2'),
        description: __('layout-2'),

        isPro: false,
        //isPro: !isProFeature ? false : true,
        atts: {
            wrapper: { "options": { "tag": "div", "class": "" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "margin": {}, "paddingBottom": { "Desktop": "50px" } } }, progressData: { "type": "horizontal", "animate": "onVisible", "animateDuration": 1, "animateIteration": 2, "animateDelay": 2, "fill": 45, "unit": "%" }, progressInfo: { "options": { "tag": "div", "class": "", "position": "beforeBar" }, "styles": { "display": { "Desktop": "flex" }, "justifyContent": { "Desktop": "space-between" }, "paddingBottom": { "Desktop": "10px" } } }, progressBar: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#9DD6DF" } } }, progressFill: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#18978F" }, "width": { "Desktop": "70%" } } }, progressCount: { "options": { "position": "afterLabel", "class": "" }, "styles": { "color": { "Desktop": "" }, "fontSize": { "Desktop": "" } } }, progressLabel: { "options": { "tag": "div", "text": "Digital Marketing", "position": "", "class": "" }, "styles": { "color": {}, "fontSize": {}, "order": { "Desktop": "10" } } }, icon: { "options": { "library": "fontAwesome", "position": "beforeprogressCount", "srcType": "class", "iconSrc": "far fa-calendar-alt", "class": "number-count-icon" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "fontSize": { "Desktop": "" } } },

            circleMask: {},
            circleOverlay: {},


            blockId: "", customCss: "", blockCssY: { items: {} }
        },
        scope: ['block'],
        icon: (
            <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 75 20"><path fill="#1d1d1b" d="M41,5.83a5.27,5.27,0,0,1,.74,0,1.53,1.53,0,0,1,1.09.33,1.26,1.26,0,0,1,.38,1,1.4,1.4,0,0,1-.39,1.05,1.65,1.65,0,0,1-1.19.39,5.41,5.41,0,0,1-.63,0Zm.35,2.39.35,0a1,1,0,0,0,1.15-1.15,1,1,0,0,0-1.09-1,1.93,1.93,0,0,0-.41,0Z" /><path fill="#1d1d1b" d="M44,6a.2.2,0,0,1-.22.22.22.22,0,0,1,0-.44A.21.21,0,0,1,44,6Zm-.39,2.48V6.56H44V8.49Z" /><path fill="#1d1d1b" d="M46.22,6.56c0,.14,0,.29,0,.53V8.21a1.12,1.12,0,0,1-.28.89,1,1,0,0,1-.7.23,1.26,1.26,0,0,1-.64-.16l.09-.27a1,1,0,0,0,.56.15.59.59,0,0,0,.63-.67V8.16h0a.7.7,0,0,1-.62.32.86.86,0,0,1-.82-.94.93.93,0,0,1,.87-1,.63.63,0,0,1,.6.34h0l0-.29Zm-.37.76a.41.41,0,0,0,0-.16.5.5,0,0,0-.49-.37c-.34,0-.57.28-.57.73s.19.7.57.7a.51.51,0,0,0,.48-.36.63.63,0,0,0,0-.19Z" /><path fill="#1d1d1b" d="M47.15,6a.2.2,0,0,1-.22.22.22.22,0,0,1,0-.44A.21.21,0,0,1,47.15,6Zm-.39,2.48V6.56h.35V8.49Z" /><path fill="#1d1d1b" d="M48.12,6v.56h.5v.26h-.5v1c0,.24.07.37.26.37l.21,0v.26a.76.76,0,0,1-.31,0,.49.49,0,0,1-.38-.15.7.7,0,0,1-.13-.5V6.82h-.3V6.56h.3V6.09Z" /><path fill="#1d1d1b" d="M50.09,8.49l0-.24h0a.72.72,0,0,1-.59.29A.55.55,0,0,1,48.87,8c0-.47.41-.72,1.16-.72v0a.4.4,0,0,0-.44-.45.92.92,0,0,0-.5.15L49,6.69a1.14,1.14,0,0,1,.63-.18c.6,0,.74.41.74.79V8a3.13,3.13,0,0,0,0,.46ZM50,7.5c-.38,0-.82.06-.82.44a.31.31,0,0,0,.33.34A.49.49,0,0,0,50,8a.36.36,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M51,5.65h.35V8.49H51Z" /><path fill="#1d1d1b" d="M55,7.31c0-.38,0-.83,0-1.16h0c-.09.31-.2.65-.34,1l-.47,1.31h-.27l-.43-1.29a10.44,10.44,0,0,1-.31-1h0c0,.33,0,.78-.06,1.19L53,8.49h-.33l.19-2.69h.44l.46,1.3A8.89,8.89,0,0,1,54,8h0a8.19,8.19,0,0,1,.28-.91l.48-1.3h.44l.17,2.69h-.34Z" /><path fill="#1d1d1b" d="M57.05,8.49l0-.24h0a.72.72,0,0,1-.59.29A.55.55,0,0,1,55.83,8c0-.47.41-.72,1.16-.72v0a.4.4,0,0,0-.44-.45.92.92,0,0,0-.5.15L56,6.69a1.14,1.14,0,0,1,.63-.18c.6,0,.74.41.74.79V8a3.13,3.13,0,0,0,0,.46Zm0-1c-.38,0-.82.06-.82.44a.31.31,0,0,0,.33.34A.49.49,0,0,0,57,8a.36.36,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M57.91,7.16c0-.23,0-.42,0-.6h.31v.38h0a.59.59,0,0,1,.53-.43l.1,0v.33l-.12,0a.5.5,0,0,0-.47.46.76.76,0,0,0,0,.16v1h-.35Z" /><path fill="#1d1d1b" d="M59.58,7.44h0l.17-.22.57-.66h.42L60,7.35l.86,1.14h-.43l-.67-.93-.18.2v.73h-.35V5.65h.35Z" /><path fill="#1d1d1b" d="M61.3,7.59a.63.63,0,0,0,.67.67,1.18,1.18,0,0,0,.53-.1l.06.25a1.46,1.46,0,0,1-.64.12.89.89,0,0,1-1-1,.94.94,0,0,1,.91-1,.82.82,0,0,1,.8.91.65.65,0,0,1,0,.17Zm1-.25a.51.51,0,0,0-.49-.58.58.58,0,0,0-.54.58Z" /><path fill="#1d1d1b" d="M63.54,6v.56H64v.26h-.5v1c0,.24.06.37.26.37l.2,0,0,.26a.83.83,0,0,1-.31,0,.46.46,0,0,1-.38-.15.7.7,0,0,1-.14-.5V6.82h-.3V6.56h.3V6.09Z" /><path fill="#1d1d1b" d="M64.83,6a.22.22,0,0,1-.23.22A.22.22,0,1,1,64.83,6Zm-.39,2.48V6.56h.35V8.49Z" /><path fill="#1d1d1b" d="M65.37,7.08c0-.2,0-.36,0-.52h.31l0,.32h0a.7.7,0,0,1,.64-.37c.26,0,.68.16.68.83V8.49h-.35V7.38c0-.31-.12-.58-.45-.58a.51.51,0,0,0-.47.36.47.47,0,0,0,0,.17V8.49h-.35Z" /><path fill="#1d1d1b" d="M69.26,6.56c0,.14,0,.29,0,.53V8.21A1.12,1.12,0,0,1,69,9.1a1.06,1.06,0,0,1-.71.23,1.29,1.29,0,0,1-.64-.16l.09-.27a1.11,1.11,0,0,0,.57.15c.36,0,.62-.19.62-.67V8.16h0a.68.68,0,0,1-.61.32.86.86,0,0,1-.83-.94.93.93,0,0,1,.87-1,.66.66,0,0,1,.61.34h0V6.56Zm-.36.76a.78.78,0,0,0,0-.16.52.52,0,0,0-.5-.37c-.33,0-.57.28-.57.73s.19.7.57.7a.52.52,0,0,0,.49-.36.63.63,0,0,0,0-.19Z" /><path fill="#1d1d1b" d="M6.73,8.49V7.78H5.52V7.55L6.68,5.89h.38V7.51h.37v.27H7.06v.71Zm0-1V6.64c0-.14,0-.27,0-.41h0a3.39,3.39,0,0,1-.22.39l-.63.88h.85Z" /><path fill="#1d1d1b" d="M9.25,6.19h-1l-.1.67.22,0A1.06,1.06,0,0,1,8.93,7a.75.75,0,0,1,.37.67.91.91,0,0,1-1,.89,1.31,1.31,0,0,1-.65-.16l.09-.27a1.23,1.23,0,0,0,.56.14.57.57,0,0,0,.61-.56c0-.34-.23-.58-.75-.58a3.25,3.25,0,0,0-.36,0L8,5.89H9.25Z" /><path fill="#1d1d1b" d="M10.92,6.62c0,.55-.29.82-.63.82s-.6-.26-.6-.78.28-.81.62-.81S10.92,6.13,10.92,6.62Zm-.95,0c0,.33.11.58.33.58s.34-.24.34-.59-.09-.58-.34-.58S10,6.32,10,6.65Zm.3,1.89L11.8,5.85H12L10.49,8.54Zm2.34-.84c0,.55-.29.82-.62.82s-.6-.26-.61-.78.29-.82.63-.82S12.61,7.2,12.61,7.7Zm-.95,0c0,.34.12.59.34.59s.33-.25.33-.59-.09-.58-.33-.58S11.66,7.4,11.66,7.72Z" /><rect fill="#3c4c9b" x="5.46" y="10.86" width="46.76" height="4" /><rect fill="#7480b8" x="52.22" y="10.86" width="17.32" height="4" /></svg>
        ),

    },



    {
        name: 'layout-3',
        title: __('layout-3'),
        description: __('layout-3'),

        isPro: false,
        //isPro: !isProFeature ? false : true,
        atts: {
            wrapper: { "options": { "tag": "div", "class": "" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "margin": { "Desktop": "0px 100px 0px 0px" }, "paddingBottom": { "Desktop": "50px" } } }, progressData: { "type": "horizontal", "animate": "onVisible", "animateDuration": 1, "animateIteration": 2, "animateDelay": 2, "fill": 45, "unit": "%" }, progressInfo: { "options": { "tag": "div", "class": "", "position": "afterBar" }, "styles": { "display": { "Desktop": "flex" }, "justifyContent": { "Desktop": "space-between" }, "paddingTop": { "Desktop": "10px" } } }, progressBar: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#9DD6DF" } } }, progressFill: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#18978F" }, "width": { "Desktop": "60%" } } }, progressCount: { "options": { "position": "afterLabel", "class": "" }, "styles": { "color": { "Desktop": "" }, "fontSize": { "Desktop": "" } } }, progressLabel: { "options": { "text": "Digital Marketing", "position": "", "class": "" }, "styles": { "color": { "Desktop": "" }, "fontSize": { "Desktop": "" } } }, icon: { "options": { "library": "fontAwesome", "position": "beforeprogressCount", "srcType": "class", "iconSrc": "far fa-calendar-alt", "class": "number-count-icon" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "fontSize": { "Desktop": "" } } },

            circleMask: {},
            circleOverlay: {},


            blockId: "", customCss: "", blockCssY: { items: {} }
        },
        scope: ['block'],
        icon: (
            <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 75 20"><path fill="#1d1d1b" d="M41,11.45a5.27,5.27,0,0,1,.74,0,1.53,1.53,0,0,1,1.09.33,1.26,1.26,0,0,1,.38,1,1.4,1.4,0,0,1-.39,1.05,1.65,1.65,0,0,1-1.19.39,5.41,5.41,0,0,1-.63,0Zm.35,2.39.35,0a1,1,0,0,0,1.15-1.15,1,1,0,0,0-1.09-1,1.93,1.93,0,0,0-.41,0Z" /><path fill="#1d1d1b" d="M44,11.63a.2.2,0,0,1-.22.22.22.22,0,0,1,0-.44A.21.21,0,0,1,44,11.63Zm-.39,2.48V12.18H44v1.93Z" /><path fill="#1d1d1b" d="M46.22,12.18c0,.14,0,.29,0,.53v1.12a1.12,1.12,0,0,1-.28.89,1,1,0,0,1-.7.23,1.26,1.26,0,0,1-.64-.16l.09-.27a1,1,0,0,0,.56.15.59.59,0,0,0,.63-.67v-.22h0a.7.7,0,0,1-.62.32.86.86,0,0,1-.82-.94.93.93,0,0,1,.87-1,.63.63,0,0,1,.6.34h0l0-.29Zm-.37.76a.41.41,0,0,0,0-.16.5.5,0,0,0-.49-.37c-.34,0-.57.28-.57.73s.19.7.57.7a.51.51,0,0,0,.48-.36.63.63,0,0,0,0-.19Z" /><path fill="#1d1d1b" d="M47.15,11.63a.2.2,0,0,1-.22.22.22.22,0,0,1,0-.44A.21.21,0,0,1,47.15,11.63Zm-.39,2.48V12.18h.35v1.93Z" /><path fill="#1d1d1b" d="M48.12,11.62v.56h.5v.27h-.5v1c0,.24.07.37.26.37l.21,0v.26a.76.76,0,0,1-.31.05.49.49,0,0,1-.38-.15.7.7,0,0,1-.13-.5V12.45h-.3v-.27h.3v-.47Z" /><path fill="#1d1d1b" d="M50.09,14.11l0-.24h0a.72.72,0,0,1-.59.29.55.55,0,0,1-.59-.56c0-.47.41-.72,1.16-.72v0a.4.4,0,0,0-.44-.45.92.92,0,0,0-.5.15L49,12.31a1.14,1.14,0,0,1,.63-.18c.6,0,.74.41.74.79v.73a3.13,3.13,0,0,0,0,.46Zm-.05-1c-.38,0-.82.06-.82.44a.31.31,0,0,0,.33.34.49.49,0,0,0,.47-.33.36.36,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M51,11.27h.35v2.84H51Z" /><path fill="#1d1d1b" d="M55,12.93c0-.38,0-.83,0-1.16h0c-.09.31-.2.65-.34,1l-.47,1.31h-.27l-.43-1.29a10.44,10.44,0,0,1-.31-1h0c0,.33,0,.78-.06,1.19L53,14.11h-.33l.19-2.69h.44l.46,1.3a8.89,8.89,0,0,1,.27.91h0a8.19,8.19,0,0,1,.28-.91l.48-1.3h.44l.17,2.69h-.34Z" /><path fill="#1d1d1b" d="M57.05,14.11l0-.24h0a.72.72,0,0,1-.59.29.55.55,0,0,1-.59-.56c0-.47.41-.72,1.16-.72v0a.4.4,0,0,0-.44-.45.92.92,0,0,0-.5.15L56,12.31a1.14,1.14,0,0,1,.63-.18c.6,0,.74.41.74.79v.73a3.13,3.13,0,0,0,0,.46Zm0-1c-.38,0-.82.06-.82.44a.31.31,0,0,0,.33.34.49.49,0,0,0,.47-.33.36.36,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M57.91,12.78c0-.23,0-.42,0-.6h.31v.38h0a.59.59,0,0,1,.53-.43l.1,0v.33l-.12,0a.5.5,0,0,0-.47.46.76.76,0,0,0,0,.16v1h-.35Z" /><path fill="#1d1d1b" d="M59.58,13.06h0l.17-.22.57-.66h.42L60,13l.86,1.14h-.43l-.67-.93-.18.2v.73h-.35V11.27h.35Z" /><path fill="#1d1d1b" d="M61.3,13.21a.63.63,0,0,0,.67.67,1.18,1.18,0,0,0,.53-.1l.06.25a1.46,1.46,0,0,1-.64.12.89.89,0,0,1-1-1,.94.94,0,0,1,.91-1,.82.82,0,0,1,.8.91.65.65,0,0,1,0,.17Zm1-.25a.51.51,0,0,0-.49-.58.58.58,0,0,0-.54.58Z" /><path fill="#1d1d1b" d="M63.54,11.62v.56H64v.27h-.5v1c0,.24.06.37.26.37l.2,0,0,.26a.83.83,0,0,1-.31.05.46.46,0,0,1-.38-.15.7.7,0,0,1-.14-.5V12.45h-.3v-.27h.3v-.47Z" /><path fill="#1d1d1b" d="M64.83,11.63a.22.22,0,0,1-.23.22.22.22,0,1,1,.23-.22Zm-.39,2.48V12.18h.35v1.93Z" /><path fill="#1d1d1b" d="M65.37,12.7c0-.2,0-.36,0-.52h.31l0,.32h0a.7.7,0,0,1,.64-.37c.26,0,.68.16.68.83v1.15h-.35V13c0-.31-.12-.58-.45-.58a.51.51,0,0,0-.47.36.47.47,0,0,0,0,.17v1.16h-.35Z" /><path fill="#1d1d1b" d="M69.26,12.18c0,.14,0,.29,0,.53v1.12a1.12,1.12,0,0,1-.27.89,1.06,1.06,0,0,1-.71.23,1.29,1.29,0,0,1-.64-.16l.09-.27a1.11,1.11,0,0,0,.57.15c.36,0,.62-.19.62-.67v-.22h0a.68.68,0,0,1-.61.32.86.86,0,0,1-.83-.94.93.93,0,0,1,.87-1,.66.66,0,0,1,.61.34h0v-.29Zm-.36.76a.78.78,0,0,0,0-.16.52.52,0,0,0-.5-.37c-.33,0-.57.28-.57.73s.19.7.57.7a.52.52,0,0,0,.49-.36.63.63,0,0,0,0-.19Z" /><path fill="#1d1d1b" d="M6.73,14.11V13.4H5.52v-.23l1.16-1.66h.38v1.62h.37v.27H7.06v.71Zm0-1v-.87c0-.14,0-.27,0-.41h0a3.39,3.39,0,0,1-.22.39l-.63.88h.85Z" /><path fill="#1d1d1b" d="M9.25,11.81h-1l-.1.67.22,0a1.06,1.06,0,0,1,.56.14.75.75,0,0,1,.37.67.91.91,0,0,1-1,.89A1.31,1.31,0,0,1,7.68,14l.09-.27a1.23,1.23,0,0,0,.56.14.57.57,0,0,0,.61-.56c0-.34-.23-.58-.75-.58a3.25,3.25,0,0,0-.36,0L8,11.51H9.25Z" /><path fill="#1d1d1b" d="M10.92,12.24c0,.55-.29.82-.63.82s-.6-.26-.6-.78.28-.81.62-.81S10.92,11.75,10.92,12.24Zm-.95,0c0,.33.11.58.33.58s.34-.24.34-.59-.09-.58-.34-.58S10,11.94,10,12.27Zm.3,1.89,1.53-2.69H12l-1.53,2.69Zm2.34-.84c0,.55-.29.82-.62.82s-.6-.26-.61-.78.29-.82.63-.82S12.61,12.83,12.61,13.32Zm-.95,0c0,.34.12.59.34.59s.33-.25.33-.59-.09-.58-.33-.58S11.66,13,11.66,13.34Z" /><rect fill="#3c4c9b" x="5.46" y="4.89" width="32.64" height="4" /><rect fill="#7480b8" x="38.1" y="4.89" width="31.43" height="4" /></svg>
        ),

    },

    {
        name: 'layout-4',
        title: __('layout-4'),
        description: __('layout-4'),

        isPro: false,
        //isPro: !isProFeature ? false : true,
        atts: {
            wrapper: { "options": { "tag": "div", "class": "" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "margin": {}, "paddingBottom": { "Desktop": "50px" } } }, progressData: { "type": "horizontal", "animate": "onVisible", "animateDuration": 1, "animateIteration": 2, "animateDelay": 2, "fill": 45, "unit": "%" }, progressInfo: { "options": { "tag": "div", "class": "", "position": "afterBar" }, "styles": { "display": { "Desktop": "flex" }, "justifyContent": { "Desktop": "space-between" }, "paddingTop": { "Desktop": "10px" } } }, progressBar: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#9DD6DF" } } }, progressFill: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#18978F" }, "width": { "Desktop": "80%" } } }, progressCount: { "options": { "position": "afterLabel", "class": "" }, "styles": { "color": { "Desktop": "" }, "fontSize": { "Desktop": "" } } }, progressLabel: { "options": { "tag": "div", "text": "Digital Marketing", "position": "", "class": "" }, "styles": { "color": {}, "fontSize": {}, "order": { "Desktop": "10" } } }, icon: { "options": { "library": "fontAwesome", "position": "beforeprogressCount", "srcType": "class", "iconSrc": "far fa-calendar-alt", "class": "number-count-icon" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "fontSize": { "Desktop": "" } } },

            circleMask: {},
            circleOverlay: {},


            blockId: "", customCss: "", blockCssY: { items: {} }
        },
        scope: ['block'],
        icon: (
            <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 75 20"><path fill="#1d1d1b" d="M6.16,11.45a5.27,5.27,0,0,1,.74,0A1.53,1.53,0,0,1,8,11.73a1.26,1.26,0,0,1,.38,1A1.4,1.4,0,0,1,8,13.75a1.65,1.65,0,0,1-1.19.39c-.25,0-.45,0-.63,0Zm.35,2.39.35,0A1,1,0,0,0,8,12.71a1,1,0,0,0-1.09-1,1.93,1.93,0,0,0-.41,0Z" /><path fill="#1d1d1b" d="M9.2,11.63a.2.2,0,0,1-.22.22.22.22,0,0,1,0-.44A.21.21,0,0,1,9.2,11.63Zm-.39,2.48V12.18h.35v1.93Z" /><path fill="#1d1d1b" d="M11.42,12.18c0,.14,0,.29,0,.53v1.12a1.12,1.12,0,0,1-.28.89,1,1,0,0,1-.7.23,1.26,1.26,0,0,1-.64-.16l.08-.27a1.11,1.11,0,0,0,.57.15.58.58,0,0,0,.63-.67v-.22h0a.7.7,0,0,1-.62.33.87.87,0,0,1-.82-.95.94.94,0,0,1,.87-1,.63.63,0,0,1,.6.34h0l0-.29Zm-.37.76a.41.41,0,0,0,0-.16.5.5,0,0,0-.49-.37c-.34,0-.58.28-.58.73s.2.7.58.7a.51.51,0,0,0,.48-.36.63.63,0,0,0,0-.19Z" /><path fill="#1d1d1b" d="M12.35,11.63a.2.2,0,0,1-.22.22.21.21,0,0,1-.21-.22.22.22,0,0,1,.22-.22A.21.21,0,0,1,12.35,11.63ZM12,14.11V12.18h.35v1.93Z" /><path fill="#1d1d1b" d="M13.32,11.62v.56h.5v.27h-.5v1c0,.24.07.38.26.38a.86.86,0,0,0,.21,0v.27a1.05,1.05,0,0,1-.31,0,.49.49,0,0,1-.38-.15.7.7,0,0,1-.13-.5V12.45h-.3v-.27H13v-.47Z" /><path fill="#1d1d1b" d="M15.29,14.11l0-.24h0a.72.72,0,0,1-.59.29.55.55,0,0,1-.59-.56c0-.47.41-.72,1.16-.72v0a.4.4,0,0,0-.44-.45.92.92,0,0,0-.5.15l-.08-.23a1.14,1.14,0,0,1,.63-.18c.6,0,.74.41.74.8v.72a3.13,3.13,0,0,0,0,.46Zm0-1c-.38,0-.82.06-.82.43a.31.31,0,0,0,.33.34.49.49,0,0,0,.47-.33.36.36,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M16.15,11.27h.35v2.84h-.35Z" /><path fill="#1d1d1b" d="M20.22,12.93c0-.38,0-.83,0-1.16h0c-.09.31-.2.65-.34,1l-.47,1.31h-.27l-.43-1.29c-.13-.38-.24-.72-.32-1h0c0,.33,0,.78-.06,1.19l-.07,1.15h-.33l.19-2.69h.44l.46,1.3a8.89,8.89,0,0,1,.27.91h0a8.19,8.19,0,0,1,.28-.91l.48-1.3h.44l.17,2.69h-.34Z" /><path fill="#1d1d1b" d="M22.25,14.11l0-.24h0a.72.72,0,0,1-.59.29A.55.55,0,0,1,21,13.6c0-.47.41-.72,1.16-.72v0a.4.4,0,0,0-.44-.45.92.92,0,0,0-.5.15l-.08-.23a1.14,1.14,0,0,1,.63-.18c.6,0,.74.41.74.8v.72a3.13,3.13,0,0,0,0,.46Zm-.05-1c-.38,0-.82.06-.82.43a.31.31,0,0,0,.33.34.49.49,0,0,0,.47-.33.36.36,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M23.11,12.78c0-.23,0-.42,0-.6h.31v.38h0a.59.59,0,0,1,.53-.43l.1,0v.33h-.12a.49.49,0,0,0-.47.45.81.81,0,0,0,0,.16v1h-.35Z" /><path fill="#1d1d1b" d="M24.78,13.07h0a1.84,1.84,0,0,1,.17-.22l.57-.67H26L25.2,13l.86,1.14h-.43L25,13.19l-.18.2v.72h-.35V11.27h.35Z" /><path fill="#1d1d1b" d="M26.5,13.21a.62.62,0,0,0,.67.67,1.18,1.18,0,0,0,.53-.1l.06.25a1.46,1.46,0,0,1-.64.12.89.89,0,0,1-.95-1,.94.94,0,0,1,.91-1,.83.83,0,0,1,.8.92.63.63,0,0,1,0,.16Zm1-.25a.5.5,0,0,0-.49-.57.58.58,0,0,0-.54.57Z" /><path fill="#1d1d1b" d="M28.74,11.62v.56h.5v.27h-.5v1c0,.24.06.38.26.38a.77.77,0,0,0,.2,0l0,.27a1.17,1.17,0,0,1-.31,0,.46.46,0,0,1-.38-.15.7.7,0,0,1-.14-.5V12.45h-.3v-.27h.3v-.47Z" /><path fill="#1d1d1b" d="M30,11.63a.22.22,0,0,1-.23.22.22.22,0,1,1,.23-.22Zm-.39,2.48V12.18H30v1.93Z" /><path fill="#1d1d1b" d="M30.57,12.7c0-.2,0-.36,0-.52h.31l0,.32h0a.7.7,0,0,1,.64-.37c.26,0,.68.16.68.83v1.15h-.35V13c0-.31-.12-.57-.45-.57a.49.49,0,0,0-.47.36.38.38,0,0,0,0,.16v1.16h-.35Z" /><path fill="#1d1d1b" d="M34.46,12.18c0,.14,0,.29,0,.53v1.12a1.15,1.15,0,0,1-.27.89,1.06,1.06,0,0,1-.71.23,1.29,1.29,0,0,1-.64-.16l.09-.27a1.11,1.11,0,0,0,.57.15c.36,0,.62-.18.62-.67v-.22h0a.69.69,0,0,1-.61.33.87.87,0,0,1-.83-.95.94.94,0,0,1,.87-1,.66.66,0,0,1,.61.34h0v-.29Zm-.36.76a.78.78,0,0,0,0-.16.52.52,0,0,0-.5-.37c-.33,0-.57.28-.57.73s.19.7.57.7a.52.52,0,0,0,.49-.36.63.63,0,0,0,0-.19Z" /><path fill="#1d1d1b" d="M63.53,14.11v-.7H62.32v-.24l1.16-1.66h.38v1.62h.37v.28h-.37v.7Zm0-1v-.87c0-.13,0-.27,0-.41h0c-.08.16-.14.27-.21.39l-.64.88h.85Z" /><path fill="#1d1d1b" d="M66.05,11.81h-1l-.1.67.21,0a1.16,1.16,0,0,1,.56.14.75.75,0,0,1,.37.67.9.9,0,0,1-1,.89,1.31,1.31,0,0,1-.65-.16l.09-.27a1.23,1.23,0,0,0,.56.14.57.57,0,0,0,.61-.56c0-.34-.22-.58-.74-.58a2.87,2.87,0,0,0-.36,0l.16-1.25h1.25Z" /><path fill="#1d1d1b" d="M67.72,12.25c0,.54-.29.82-.62.82s-.61-.26-.61-.79.28-.81.63-.81S67.72,11.75,67.72,12.25Zm-1,0c0,.33.11.58.33.58s.34-.24.34-.59-.09-.58-.34-.58S66.77,11.94,66.77,12.27Zm.3,1.89,1.53-2.69h.22L67.3,14.16Zm2.34-.84c0,.55-.29.82-.62.82s-.6-.26-.61-.78.29-.81.63-.81S69.41,12.83,69.41,13.32Zm-1,0c0,.33.12.58.34.58s.34-.25.34-.59-.1-.58-.34-.58S68.46,13,68.46,13.35Z" /><rect fill="#3c4c9b" x="5.46" y="4.89" width="39.33" height="4" /><rect fill="#7480b8" x="44.79" y="4.89" width="24.75" height="4" /></svg>
        ),

    },

    {
        name: 'layout-5',
        title: __('layout-5'),
        description: __('layout-5'),

        isPro: false,
        //isPro: !isProFeature ? false : true,
        atts: {
            wrapper: { "options": { "tag": "div", "class": "" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "margin": {}, "paddingBottom": { "Desktop": "50px" } } }, progressData: { "type": "horizontal", "animate": "onVisible", "animateDuration": 1, "animateIteration": 2, "animateDelay": 2, "fill": 45, "unit": "%" }, progressInfo: { "options": { "tag": "div", "class": "", "position": "beforeBar" }, "styles": { "display": {}, "paddingBottom": { "Desktop": "10px" } } }, progressBar: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#9DD6DF" } } }, progressFill: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#18978F" }, "width": { "Desktop": "50%" }, "paddingBottom": {} } }, progressCount: { "options": { "tag": "div", "position": "insideFill", "class": "" }, "styles": { "color": { "Desktop": "#ffffff" }, "fontSize": {}, "padding": { "Desktop": "10px 10px 10px 10px" }, "backgroundColor": {} } }, progressLabel: { "options": { "text": "Digital Marketing", "position": "", "class": "" }, "styles": { "color": { "Desktop": "" }, "fontSize": { "Desktop": "" } } }, icon: { "options": { "library": "fontAwesome", "position": "beforeprogressCount", "srcType": "class", "iconSrc": "far fa-calendar-alt", "class": "number-count-icon" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "fontSize": { "Desktop": "" } } },

            circleMask: {},
            circleOverlay: {},


            blockId: "", customCss: "", blockCssY: { items: {} }
        },
        scope: ['block'],
        icon: (
            <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 75 20"><path fill="#1d1d1b" d="M5.77,5.83a5.27,5.27,0,0,1,.74,0,1.54,1.54,0,0,1,1.09.33,1.26,1.26,0,0,1,.38,1,1.44,1.44,0,0,1-.39,1.05,1.67,1.67,0,0,1-1.19.39c-.25,0-.46,0-.63,0Zm.35,2.39.35,0A1,1,0,0,0,7.61,7.09a1,1,0,0,0-1.09-1,1.82,1.82,0,0,0-.4,0Z" /><path fill="#1d1d1b" d="M8.81,6a.21.21,0,0,1-.22.22A.21.21,0,0,1,8.38,6a.22.22,0,0,1,.22-.22A.21.21,0,0,1,8.81,6ZM8.42,8.49V6.56h.35V8.49Z" /><path fill="#1d1d1b" d="M11,6.56c0,.14,0,.29,0,.53V8.21a1.12,1.12,0,0,1-.28.89,1.05,1.05,0,0,1-.7.23,1.3,1.3,0,0,1-.65-.16l.09-.27a1.11,1.11,0,0,0,.57.15c.36,0,.62-.18.62-.67V8.16h0a.67.67,0,0,1-.61.33.87.87,0,0,1-.82-1,.93.93,0,0,1,.87-1,.64.64,0,0,1,.6.34h0V6.56Zm-.36.76a.78.78,0,0,0,0-.16.52.52,0,0,0-.49-.37c-.34,0-.58.28-.58.73s.19.7.57.7a.52.52,0,0,0,.49-.36.63.63,0,0,0,0-.19Z" /><path fill="#1d1d1b" d="M12,6a.21.21,0,0,1-.22.22A.22.22,0,0,1,11.52,6a.22.22,0,0,1,.22-.22A.21.21,0,0,1,12,6Zm-.39,2.48V6.56h.35V8.49Z" /><path fill="#1d1d1b" d="M12.93,6v.56h.5v.27h-.5v1c0,.24.07.38.26.38a1,1,0,0,0,.21,0v.27a1.17,1.17,0,0,1-.31,0,.48.48,0,0,1-.38-.15.7.7,0,0,1-.14-.5v-1h-.3V6.56h.3V6.09Z" /><path fill="#1d1d1b" d="M14.9,8.49l0-.24h0a.74.74,0,0,1-.59.29A.55.55,0,0,1,13.68,8c0-.47.41-.72,1.16-.72v0a.4.4,0,0,0-.44-.45.92.92,0,0,0-.5.15l-.09-.23a1.2,1.2,0,0,1,.64-.18c.59,0,.74.41.74.8V8a2.17,2.17,0,0,0,0,.46Zm-.05-1c-.39,0-.82.06-.82.43a.31.31,0,0,0,.33.34A.49.49,0,0,0,14.83,8a.36.36,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M15.76,5.65h.35V8.49h-.35Z" /><path fill="#1d1d1b" d="M19.83,7.31c0-.38,0-.83,0-1.16h0c-.09.31-.21.65-.34,1L19,8.48H18.7l-.44-1.29c-.13-.38-.23-.72-.31-1h0c0,.33,0,.78-.05,1.19l-.07,1.15h-.33l.19-2.69h.44l.46,1.3c.11.33.2.63.27.91h0c.07-.27.17-.57.29-.91l.48-1.3h.44l.17,2.69H19.9Z" /><path fill="#1d1d1b" d="M21.86,8.49l0-.24h0a.74.74,0,0,1-.59.29A.55.55,0,0,1,20.64,8c0-.47.41-.72,1.16-.72v0a.4.4,0,0,0-.44-.45,1,1,0,0,0-.51.15l-.08-.23a1.2,1.2,0,0,1,.64-.18c.59,0,.74.41.74.8V8a2.17,2.17,0,0,0,0,.46Zm-.05-1c-.39,0-.82.06-.82.43a.31.31,0,0,0,.33.34A.49.49,0,0,0,21.79,8a.36.36,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M22.71,7.16c0-.23,0-.42,0-.6H23v.38h0a.59.59,0,0,1,.54-.43l.1,0v.33h-.12a.49.49,0,0,0-.47.45.78.78,0,0,0,0,.16v1h-.35Z" /><path fill="#1d1d1b" d="M24.39,7.45h0a1.92,1.92,0,0,1,.18-.22l.56-.67h.43l-.75.79.85,1.14h-.43l-.66-.92-.18.2v.72H24V5.65h.35Z" /><path fill="#1d1d1b" d="M26.11,7.59a.62.62,0,0,0,.66.67,1.2,1.2,0,0,0,.54-.1l.06.25a1.5,1.5,0,0,1-.64.12.9.9,0,0,1-1-1,1,1,0,0,1,.91-1,.83.83,0,0,1,.8.92c0,.07,0,.12,0,.16Zm1-.25a.49.49,0,0,0-.49-.57.58.58,0,0,0-.54.57Z" /><path fill="#1d1d1b" d="M28.34,6v.56h.51v.27h-.51v1c0,.24.07.38.27.38a.77.77,0,0,0,.2,0l0,.27a1.19,1.19,0,0,1-.32,0,.49.49,0,0,1-.38-.15.7.7,0,0,1-.13-.5v-1h-.3V6.56H28V6.09Z" /><path fill="#1d1d1b" d="M29.63,6a.2.2,0,0,1-.22.22.22.22,0,0,1,0-.44A.21.21,0,0,1,29.63,6Zm-.39,2.48V6.56h.35V8.49Z" /><path fill="#1d1d1b" d="M30.18,7.08c0-.2,0-.36,0-.52h.31l0,.32h0a.71.71,0,0,1,.64-.37c.27,0,.69.16.69.83V8.49h-.36V7.38c0-.31-.11-.57-.44-.57a.5.5,0,0,0-.48.36.7.7,0,0,0,0,.16V8.49h-.35Z" /><path fill="#1d1d1b" d="M34.07,6.56c0,.14,0,.29,0,.53V8.21a1.12,1.12,0,0,1-.28.89,1,1,0,0,1-.7.23,1.26,1.26,0,0,1-.64-.16l.08-.27a1.11,1.11,0,0,0,.57.15.58.58,0,0,0,.63-.67V8.16h0a.7.7,0,0,1-.62.33.87.87,0,0,1-.82-1,.94.94,0,0,1,.87-1,.63.63,0,0,1,.6.34h0l0-.29Zm-.37.76a.41.41,0,0,0,0-.16.5.5,0,0,0-.49-.37c-.34,0-.58.28-.58.73s.2.7.58.7a.51.51,0,0,0,.48-.36.63.63,0,0,0,0-.19Z" /><rect fill="#3c4c9b" x="5.46" y="10.86" width="39.33" height="4" /><rect fill="#7480b8" x="44.79" y="10.86" width="24.75" height="4" /><path fill="#fff" d="M7.79,13.45v-.31H7.26V13l.51-.72h.16V13h.16v.12H7.93v.31Zm0-.43v-.56h0l-.1.17L7.42,13h.37Z" /><path fill="#fff" d="M8.88,12.45H8.45l0,.29H8.5a.51.51,0,0,1,.25.06.34.34,0,0,1,.16.29.4.4,0,0,1-.42.39.64.64,0,0,1-.29-.07l0-.12a.5.5,0,0,0,.24.06.25.25,0,0,0,.27-.24c0-.15-.1-.25-.32-.25H8.27l.07-.54h.54Z" /><path fill="#fff" d="M9.61,12.63c0,.24-.12.36-.27.36s-.26-.11-.26-.34.12-.35.27-.35S9.61,12.42,9.61,12.63Zm-.41,0c0,.14.05.25.15.25s.14-.11.14-.26,0-.25-.14-.25S9.2,12.5,9.2,12.65Zm.13.82L10,12.3h.09l-.66,1.17Zm1-.37c0,.24-.12.36-.27.36s-.26-.11-.26-.34.12-.35.27-.35S10.35,12.89,10.35,13.1Zm-.41,0c0,.15.05.26.14.26s.15-.11.15-.26,0-.25-.15-.25S9.94,13,9.94,13.11Z" /></svg>
        ),

    },

    {
        name: 'layout-6',
        title: __('layout-6'),
        description: __('layout-6'),

        isPro: false,
        //isPro: !isProFeature ? false : true,
        atts: {
            wrapper: { "options": { "tag": "div", "class": "" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "margin": {}, "paddingBottom": { "Desktop": "50px" } } }, progressData: { "type": "horizontal", "animate": "onVisible", "animateDuration": 1, "animateIteration": 2, "animateDelay": 2, "fill": 45, "unit": "%" }, progressInfo: { "options": { "tag": "div", "class": "", "position": "beforeBar" }, "styles": { "display": {}, "paddingBottom": { "Desktop": "10px" } } }, progressBar: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#9DD6DF" } } }, progressFill: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#18978F" }, "width": { "Desktop": "50%" }, "paddingBottom": {}, "position": { "Desktop": "relative" } } }, progressCount: { "options": { "tag": "div", "position": "insideFill", "class": "" }, "styles": { "color": { "Desktop": "#ffffff" }, "fontSize": {}, "padding": { "Desktop": "5px 8px 5px 8px" }, "backgroundColor": { "Desktop": "#A084CF" }, "position": { "Desktop": "absolute" }, "right": { "Desktop": "0px" }, "top": { "Desktop": "50%" }, "transform": { "Desktop": "translateY(-50%) " } } }, progressLabel: { "options": { "text": "Digital Marketing", "position": "", "class": "" }, "styles": { "color": { "Desktop": "" }, "fontSize": { "Desktop": "" } } }, icon: { "options": { "library": "fontAwesome", "position": "beforeprogressCount", "srcType": "class", "iconSrc": "far fa-calendar-alt", "class": "number-count-icon" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "fontSize": { "Desktop": "" } } },

            circleMask: {},
            circleOverlay: {},


            blockId: "", customCss: "", blockCssY: { items: {} }
        },
        scope: ['block'],
        icon: (
            <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 75 20"><path fill="#1d1d1b" d="M5.77,5.72a5.15,5.15,0,0,1,.74-.06A1.55,1.55,0,0,1,7.6,6,1.24,1.24,0,0,1,8,7a1.4,1.4,0,0,1-.39,1A1.62,1.62,0,0,1,6.4,8.4a5.53,5.53,0,0,1-.63,0ZM6.12,8.1a1.73,1.73,0,0,0,.35,0A1,1,0,0,0,7.61,7a1,1,0,0,0-1.09-1,1.82,1.82,0,0,0-.4,0Z" /><path fill="#1d1d1b" d="M8.81,5.9a.21.21,0,0,1-.22.22.21.21,0,0,1-.21-.22.22.22,0,0,1,.22-.22A.21.21,0,0,1,8.81,5.9ZM8.42,8.38V6.44h.35V8.38Z" /><path fill="#1d1d1b" d="M11,6.44c0,.14,0,.3,0,.54V8.1a1.1,1.1,0,0,1-.28.88,1,1,0,0,1-.7.23,1.21,1.21,0,0,1-.65-.16l.09-.26a1.11,1.11,0,0,0,.57.15c.36,0,.62-.19.62-.68V8.05h0a.67.67,0,0,1-.61.32.86.86,0,0,1-.82-.94.92.92,0,0,1,.87-1,.64.64,0,0,1,.6.34h0v-.3Zm-.36.77a.78.78,0,0,0,0-.16.51.51,0,0,0-.49-.37c-.34,0-.58.28-.58.73s.19.69.57.69a.51.51,0,0,0,.49-.36.57.57,0,0,0,0-.18Z" /><path fill="#1d1d1b" d="M12,5.9a.22.22,0,0,1-.44,0,.22.22,0,0,1,.22-.22A.22.22,0,0,1,12,5.9Zm-.39,2.48V6.44h.35V8.38Z" /><path fill="#1d1d1b" d="M12.93,5.89v.55h.5v.27h-.5v1c0,.24.06.38.26.38l.2,0,0,.26a.83.83,0,0,1-.31.05.46.46,0,0,1-.38-.15.71.71,0,0,1-.14-.5V6.71h-.3V6.44h.3V6Z" /><path fill="#1d1d1b" d="M14.9,8.38l0-.25h0a.71.71,0,0,1-.59.29.54.54,0,0,1-.59-.55c0-.47.41-.73,1.16-.72v0a.4.4,0,0,0-.44-.45,1.08,1.08,0,0,0-.51.14l-.08-.23a1.27,1.27,0,0,1,.64-.17c.59,0,.74.4.74.79v.72a2.27,2.27,0,0,0,0,.47Zm-.05-1c-.39,0-.82.06-.82.44a.31.31,0,0,0,.33.33.49.49,0,0,0,.47-.32.52.52,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M15.76,5.54h.35V8.38h-.35Z" /><path fill="#1d1d1b" d="M19.83,7.2c0-.38,0-.83,0-1.17h0c-.09.32-.21.65-.34,1L19,8.36H18.7l-.44-1.28C18.13,6.7,18,6.35,18,6h0c0,.34,0,.79-.05,1.19l-.07,1.16h-.33l.19-2.7h.44L18.58,7c.11.33.2.63.27.91h0c.07-.28.17-.57.29-.91l.48-1.31h.44l.17,2.7H19.9Z" /><path fill="#1d1d1b" d="M21.86,8.38l0-.25h0a.71.71,0,0,1-.59.29.54.54,0,0,1-.59-.55c0-.47.41-.73,1.16-.72v0a.4.4,0,0,0-.44-.45,1.08,1.08,0,0,0-.51.14l-.08-.23a1.27,1.27,0,0,1,.64-.17c.59,0,.74.4.74.79v.72a2.27,2.27,0,0,0,0,.47Zm-.05-1c-.39,0-.82.06-.82.44a.31.31,0,0,0,.33.33.49.49,0,0,0,.47-.32.52.52,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M22.71,7.05c0-.23,0-.43,0-.61H23v.38h0a.58.58,0,0,1,.54-.42h.1v.33h-.12a.49.49,0,0,0-.47.45.88.88,0,0,0,0,.17v1h-.35Z" /><path fill="#1d1d1b" d="M24.39,7.33h0l.18-.22.56-.67h.43l-.75.8.85,1.14h-.43l-.66-.93-.18.2v.73H24V5.54h.35Z" /><path fill="#1d1d1b" d="M26.11,7.48a.62.62,0,0,0,.66.67,1.36,1.36,0,0,0,.54-.1l.06.25a1.67,1.67,0,0,1-.64.12.9.9,0,0,1-1-1,.94.94,0,0,1,.91-1,.82.82,0,0,1,.8.91c0,.07,0,.13,0,.17Zm1-.26a.5.5,0,0,0-.49-.57.59.59,0,0,0-.54.57Z" /><path fill="#1d1d1b" d="M28.34,5.89v.55h.51v.27h-.51v1c0,.24.07.38.27.38l.2,0,0,.26a.85.85,0,0,1-.32.05.49.49,0,0,1-.38-.15.71.71,0,0,1-.13-.5V6.71h-.3V6.44H28V6Z" /><path fill="#1d1d1b" d="M29.63,5.9a.2.2,0,0,1-.22.22.22.22,0,0,1,0-.44A.21.21,0,0,1,29.63,5.9Zm-.39,2.48V6.44h.35V8.38Z" /><path fill="#1d1d1b" d="M30.18,7c0-.2,0-.37,0-.53h.31l0,.32h0a.72.72,0,0,1,.64-.36c.27,0,.69.16.69.82V8.38h-.36V7.26c0-.31-.11-.57-.44-.57a.51.51,0,0,0-.48.36.88.88,0,0,0,0,.17V8.38h-.35Z" /><path fill="#1d1d1b" d="M34.07,6.44c0,.14,0,.3,0,.54V8.1a1.1,1.1,0,0,1-.28.88,1,1,0,0,1-.7.23,1.17,1.17,0,0,1-.64-.16l.08-.26a1.11,1.11,0,0,0,.57.15c.36,0,.63-.19.63-.68V8.05h0a.7.7,0,0,1-.62.32.86.86,0,0,1-.82-.94.93.93,0,0,1,.87-1,.63.63,0,0,1,.6.34h0l0-.3Zm-.37.77a.41.41,0,0,0,0-.16.49.49,0,0,0-.49-.37c-.34,0-.58.28-.58.73s.2.69.58.69a.5.5,0,0,0,.48-.36.57.57,0,0,0,0-.18Z" /><rect fill="#3c4c9b" x="5.46" y="10.97" width="39.33" height="4" /><rect fill="#7480b8" x="44.79" y="10.97" width="24.75" height="4" /><rect fill="#fff" x="41.13" y="11.74" width="3.66" height="2.45" /><path fill="#1d1d1b" d="M41.92,13.48v-.31H41.4v-.1l.5-.72h.17v.7h.16v.12h-.16v.31Zm0-.43v-.37c0-.06,0-.12,0-.18h0l-.09.17-.28.38h.37Z" /><path fill="#1d1d1b" d="M43,12.48h-.43l0,.29h.09a.48.48,0,0,1,.24.06.32.32,0,0,1,.16.29.39.39,0,0,1-.42.39.52.52,0,0,1-.28-.07l0-.12a.49.49,0,0,0,.24.07.25.25,0,0,0,.27-.25c0-.14-.1-.25-.33-.25h-.15l.07-.54H43Z" /><path fill="#1d1d1b" d="M43.75,12.67c0,.24-.12.36-.27.36s-.26-.12-.26-.35.12-.35.27-.35S43.75,12.45,43.75,12.67Zm-.41,0c0,.14,0,.25.14.25s.15-.11.15-.25,0-.26-.15-.26S43.34,12.54,43.34,12.68Zm.13.82.67-1.17h.09l-.66,1.17Zm1-.36c0,.23-.13.35-.27.35s-.26-.11-.27-.34.13-.35.28-.35S44.49,12.92,44.49,13.14Zm-.42,0c0,.14.06.25.15.25s.15-.11.15-.26,0-.25-.15-.25S44.07,13,44.07,13.15Z" /></svg>
        ),

    },

    {
        name: 'layout-7',
        title: __('layout-7'),
        description: __('layout-7'),

        isPro: false,
        //isPro: !isProFeature ? false : true,
        atts: {
            wrapper: { "options": { "tag": "div", "class": "" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "margin": {}, "paddingBottom": { "Desktop": "50px" } } }, progressData: { "type": "horizontal", "animate": "onVisible", "animateDuration": 1, "animateIteration": 2, "animateDelay": 2, "fill": 45, "unit": "%" }, progressInfo: { "options": { "tag": "div", "class": "", "position": "beforeBar" }, "styles": { "display": {}, "paddingBottom": { "Desktop": "10px" } } }, progressBar: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#9DD6DF" } } }, progressFill: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#18978F" }, "width": { "Desktop": "75%" }, "paddingBottom": {}, "position": { "Desktop": "relative" } } }, progressCount: { "options": { "tag": "div", "position": "insideFill", "class": "" }, "styles": { "color": { "Desktop": "#ffffff" }, "fontSize": {}, "padding": { "Desktop": "4px 8px 4px 8px" }, "backgroundColor": { "Desktop": "#774360" }, "position": { "Desktop": "absolute" }, "right": { "Desktop": "-14px" }, "top": { "Desktop": "50%" }, "transform": { "Desktop": "translateY(-50%) " }, "borderRadius": { "Desktop": "50px 50px 50px 50px" } } }, progressLabel: { "options": { "text": "Digital Marketing", "position": "", "class": "" }, "styles": { "color": { "Desktop": "" }, "fontSize": { "Desktop": "" } } }, icon: { "options": { "library": "fontAwesome", "position": "beforeprogressCount", "srcType": "class", "iconSrc": "far fa-calendar-alt", "class": "number-count-icon" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "fontSize": { "Desktop": "" } } },

            circleMask: {},
            circleOverlay: {},


            blockId: "", customCss: "", blockCssY: { items: {} }
        },
        scope: ['block'],
        icon: (
            <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 75 20"><path fill="#1d1d1b" d="M5.77,5.72a5.15,5.15,0,0,1,.74-.06A1.55,1.55,0,0,1,7.6,6,1.24,1.24,0,0,1,8,7a1.4,1.4,0,0,1-.39,1A1.62,1.62,0,0,1,6.4,8.4a5.53,5.53,0,0,1-.63,0ZM6.12,8.1a1.73,1.73,0,0,0,.35,0A1,1,0,0,0,7.61,7a1,1,0,0,0-1.09-1,1.82,1.82,0,0,0-.4,0Z" /><path fill="#1d1d1b" d="M8.81,5.9a.21.21,0,0,1-.22.22.21.21,0,0,1-.21-.22.22.22,0,0,1,.22-.22A.21.21,0,0,1,8.81,5.9ZM8.42,8.38V6.44h.35V8.38Z" /><path fill="#1d1d1b" d="M11,6.44c0,.14,0,.3,0,.54V8.1a1.1,1.1,0,0,1-.28.88,1,1,0,0,1-.7.23,1.21,1.21,0,0,1-.65-.16l.09-.26a1.11,1.11,0,0,0,.57.15c.36,0,.62-.19.62-.68V8.05h0a.67.67,0,0,1-.61.32.86.86,0,0,1-.82-.94.92.92,0,0,1,.87-1,.64.64,0,0,1,.6.34h0v-.3Zm-.36.77a.78.78,0,0,0,0-.16.51.51,0,0,0-.49-.37c-.34,0-.58.28-.58.73s.19.69.57.69a.51.51,0,0,0,.49-.36.57.57,0,0,0,0-.18Z" /><path fill="#1d1d1b" d="M12,5.9a.22.22,0,0,1-.44,0,.22.22,0,0,1,.22-.22A.22.22,0,0,1,12,5.9Zm-.39,2.48V6.44h.35V8.38Z" /><path fill="#1d1d1b" d="M12.93,5.89v.55h.5v.27h-.5v1c0,.24.06.38.26.38l.2,0,0,.26a.83.83,0,0,1-.31.05.46.46,0,0,1-.38-.15.71.71,0,0,1-.14-.5V6.71h-.3V6.44h.3V6Z" /><path fill="#1d1d1b" d="M14.9,8.38l0-.25h0a.71.71,0,0,1-.59.29.54.54,0,0,1-.59-.55c0-.47.41-.73,1.16-.72v0a.4.4,0,0,0-.44-.45,1.08,1.08,0,0,0-.51.14l-.08-.23a1.27,1.27,0,0,1,.64-.17c.59,0,.74.4.74.79v.72a2.27,2.27,0,0,0,0,.47Zm-.05-1c-.39,0-.82.06-.82.44a.31.31,0,0,0,.33.33.49.49,0,0,0,.47-.32.52.52,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M15.76,5.54h.35V8.38h-.35Z" /><path fill="#1d1d1b" d="M19.83,7.2c0-.38,0-.83,0-1.17h0c-.09.32-.21.65-.34,1L19,8.36H18.7l-.44-1.28C18.13,6.7,18,6.35,18,6h0c0,.34,0,.79-.05,1.19l-.07,1.16h-.33l.19-2.7h.44L18.58,7c.11.33.2.63.27.91h0c.07-.28.17-.57.29-.91l.48-1.31h.44l.17,2.7H19.9Z" /><path fill="#1d1d1b" d="M21.86,8.38l0-.25h0a.71.71,0,0,1-.59.29.54.54,0,0,1-.59-.55c0-.47.41-.73,1.16-.72v0a.4.4,0,0,0-.44-.45,1.08,1.08,0,0,0-.51.14l-.08-.23a1.27,1.27,0,0,1,.64-.17c.59,0,.74.4.74.79v.72a2.27,2.27,0,0,0,0,.47Zm-.05-1c-.39,0-.82.06-.82.44a.31.31,0,0,0,.33.33.49.49,0,0,0,.47-.32.52.52,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M22.71,7.05c0-.23,0-.43,0-.61H23v.38h0a.58.58,0,0,1,.54-.42h.1v.33h-.12a.49.49,0,0,0-.47.45.88.88,0,0,0,0,.17v1h-.35Z" /><path fill="#1d1d1b" d="M24.39,7.33h0l.18-.22.56-.67h.43l-.75.8.85,1.14h-.43l-.66-.93-.18.2v.73H24V5.54h.35Z" /><path fill="#1d1d1b" d="M26.11,7.48a.62.62,0,0,0,.66.67,1.36,1.36,0,0,0,.54-.1l.06.25a1.67,1.67,0,0,1-.64.12.9.9,0,0,1-1-1,.94.94,0,0,1,.91-1,.82.82,0,0,1,.8.91c0,.07,0,.13,0,.17Zm1-.26a.5.5,0,0,0-.49-.57.59.59,0,0,0-.54.57Z" /><path fill="#1d1d1b" d="M28.34,5.89v.55h.51v.27h-.51v1c0,.24.07.38.27.38l.2,0,0,.26a.85.85,0,0,1-.32.05.49.49,0,0,1-.38-.15.71.71,0,0,1-.13-.5V6.71h-.3V6.44H28V6Z" /><path fill="#1d1d1b" d="M29.63,5.9a.2.2,0,0,1-.22.22.22.22,0,0,1,0-.44A.21.21,0,0,1,29.63,5.9Zm-.39,2.48V6.44h.35V8.38Z" /><path fill="#1d1d1b" d="M30.18,7c0-.2,0-.37,0-.53h.31l0,.32h0a.72.72,0,0,1,.64-.36c.27,0,.69.16.69.82V8.38h-.36V7.26c0-.31-.11-.57-.44-.57a.51.51,0,0,0-.48.36.88.88,0,0,0,0,.17V8.38h-.35Z" /><path fill="#1d1d1b" d="M34.07,6.44c0,.14,0,.3,0,.54V8.1a1.1,1.1,0,0,1-.28.88,1,1,0,0,1-.7.23,1.17,1.17,0,0,1-.64-.16l.08-.26a1.11,1.11,0,0,0,.57.15c.36,0,.63-.19.63-.68V8.05h0a.7.7,0,0,1-.62.32.86.86,0,0,1-.82-.94.93.93,0,0,1,.87-1,.63.63,0,0,1,.6.34h0l0-.3Zm-.37.77a.41.41,0,0,0,0-.16.49.49,0,0,0-.49-.37c-.34,0-.58.28-.58.73s.2.69.58.69a.5.5,0,0,0,.48-.36.57.57,0,0,0,0-.18Z" /><rect fill="#3c4c9b" x="5.46" y="10.97" width="39.33" height="4" /><rect fill="#7480b8" x="44.79" y="10.97" width="24.75" height="4" /><rect fill="#fff" x="42.81" y="11.81" width="3.96" height="2.32" rx="1.07" /><path fill="#1d1d1b" d="M43.75,13.48v-.31h-.52v-.1l.5-.72h.17v.7h.16v.12H43.9v.31Zm0-.43v-.37c0-.06,0-.12,0-.18h0l-.09.17-.28.38h.37Z" /><path fill="#1d1d1b" d="M44.85,12.48h-.43l0,.29h.09a.48.48,0,0,1,.24.06.32.32,0,0,1,.16.29.39.39,0,0,1-.42.39.52.52,0,0,1-.28-.07l0-.12a.49.49,0,0,0,.24.07.25.25,0,0,0,.27-.25c0-.14-.1-.25-.33-.25h-.15l.07-.54h.54Z" /><path fill="#1d1d1b" d="M45.58,12.67c0,.24-.12.36-.27.36s-.26-.12-.26-.35.12-.35.27-.35S45.58,12.45,45.58,12.67Zm-.41,0c0,.14,0,.25.15.25s.14-.1.14-.25,0-.26-.14-.26S45.17,12.54,45.17,12.68Zm.13.82L46,12.33h.09L45.4,13.5Zm1-.36c0,.23-.13.35-.27.35s-.26-.11-.27-.34.13-.35.28-.35S46.32,12.92,46.32,13.14Zm-.42,0c0,.14.06.25.15.25s.15-.11.15-.26,0-.25-.15-.25S45.9,13,45.9,13.15Z" /></svg>
        ),

    },

    {
        name: 'layout-8',
        title: __('layout-8'),
        description: __('layout-8'),

        isPro: false,
        //isPro: !isProFeature ? false : true,
        atts: {
            wrapper: { "options": { "tag": "div", "class": "" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "margin": {}, "paddingBottom": { "Desktop": "50px" } } }, progressData: { "type": "horizontal", "animate": "onVisible", "animateDuration": 1, "animateIteration": 2, "animateDelay": 2, "fill": 45, "unit": "%" }, progressInfo: { "options": { "tag": "div", "class": "", "position": "beforeBar" }, "styles": { "display": {}, "paddingBottom": { "Desktop": "10px" } } }, progressBar: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#9DD6DF" }, "borderRadius": { "Desktop": "50px 50px 50px 50px" } } }, progressFill: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#18978F" }, "width": { "Desktop": "75%" }, "paddingBottom": {}, "position": { "Desktop": "relative" }, "borderRadius": { "Desktop": "50px 50px 50px 50px" } } }, progressCount: { "options": { "tag": "div", "position": "insideFill", "class": "" }, "styles": { "color": { "Desktop": "#ffffff" }, "fontSize": {}, "padding": { "Desktop": "4px 8px 4px 8px" }, "backgroundColor": { "Desktop": "#774360" }, "position": { "Desktop": "absolute" }, "right": { "Desktop": "10px" }, "top": { "Desktop": "50%" }, "transform": { "Desktop": "translateY(-50%) " }, "borderRadius": { "Desktop": "50px 50px 50px 50px" } } }, progressLabel: { "options": { "text": "Digital Marketing", "position": "", "class": "" }, "styles": { "color": { "Desktop": "" }, "fontSize": { "Desktop": "" } } }, icon: { "options": { "library": "fontAwesome", "position": "beforeprogressCount", "srcType": "class", "iconSrc": "far fa-calendar-alt", "class": "number-count-icon" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "fontSize": { "Desktop": "" } } },

            circleMask: {},
            circleOverlay: {},


            blockId: "", customCss: "", blockCssY: { items: {} }
        },
        scope: ['block'],
        icon: (
            <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 75 20"><path fill="#1d1d1b" d="M5.77,5.72a5.15,5.15,0,0,1,.74-.06A1.55,1.55,0,0,1,7.6,6,1.24,1.24,0,0,1,8,7a1.4,1.4,0,0,1-.39,1A1.62,1.62,0,0,1,6.4,8.4a5.53,5.53,0,0,1-.63,0ZM6.12,8.1a1.73,1.73,0,0,0,.35,0A1,1,0,0,0,7.61,7a1,1,0,0,0-1.09-1,1.82,1.82,0,0,0-.4,0Z" /><path fill="#1d1d1b" d="M8.81,5.9a.21.21,0,0,1-.22.22.21.21,0,0,1-.21-.22.22.22,0,0,1,.22-.22A.21.21,0,0,1,8.81,5.9ZM8.42,8.38V6.44h.35V8.38Z" /><path fill="#1d1d1b" d="M11,6.44c0,.14,0,.3,0,.54V8.1a1.1,1.1,0,0,1-.28.88,1,1,0,0,1-.7.23,1.21,1.21,0,0,1-.65-.16l.09-.26a1.11,1.11,0,0,0,.57.15c.36,0,.62-.19.62-.68V8.05h0a.67.67,0,0,1-.61.32.86.86,0,0,1-.82-.94.92.92,0,0,1,.87-1,.64.64,0,0,1,.6.34h0v-.3Zm-.36.77a.78.78,0,0,0,0-.16.51.51,0,0,0-.49-.37c-.34,0-.58.28-.58.73s.19.69.57.69a.51.51,0,0,0,.49-.36.57.57,0,0,0,0-.18Z" /><path fill="#1d1d1b" d="M12,5.9a.22.22,0,0,1-.44,0,.22.22,0,0,1,.22-.22A.22.22,0,0,1,12,5.9Zm-.39,2.48V6.44h.35V8.38Z" /><path fill="#1d1d1b" d="M12.93,5.89v.55h.5v.27h-.5v1c0,.24.06.38.26.38l.2,0,0,.26a.83.83,0,0,1-.31.05.46.46,0,0,1-.38-.15.71.71,0,0,1-.14-.5V6.71h-.3V6.44h.3V6Z" /><path fill="#1d1d1b" d="M14.9,8.38l0-.25h0a.71.71,0,0,1-.59.29.54.54,0,0,1-.59-.55c0-.47.41-.73,1.16-.72v0a.4.4,0,0,0-.44-.45,1.08,1.08,0,0,0-.51.14l-.08-.23a1.27,1.27,0,0,1,.64-.17c.59,0,.74.4.74.79v.72a2.27,2.27,0,0,0,0,.47Zm-.05-1c-.39,0-.82.06-.82.44a.31.31,0,0,0,.33.33.49.49,0,0,0,.47-.32.52.52,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M15.76,5.54h.35V8.38h-.35Z" /><path fill="#1d1d1b" d="M19.83,7.2c0-.38,0-.83,0-1.17h0c-.09.32-.21.65-.34,1L19,8.36H18.7l-.44-1.28C18.13,6.7,18,6.35,18,6h0c0,.34,0,.79-.05,1.19l-.07,1.16h-.33l.19-2.7h.44L18.58,7c.11.33.2.63.27.91h0c.07-.28.17-.57.29-.91l.48-1.31h.44l.17,2.7H19.9Z" /><path fill="#1d1d1b" d="M21.86,8.38l0-.25h0a.71.71,0,0,1-.59.29.54.54,0,0,1-.59-.55c0-.47.41-.73,1.16-.72v0a.4.4,0,0,0-.44-.45,1.08,1.08,0,0,0-.51.14l-.08-.23a1.27,1.27,0,0,1,.64-.17c.59,0,.74.4.74.79v.72a2.27,2.27,0,0,0,0,.47Zm-.05-1c-.39,0-.82.06-.82.44a.31.31,0,0,0,.33.33.49.49,0,0,0,.47-.32.52.52,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M22.71,7.05c0-.23,0-.43,0-.61H23v.38h0a.58.58,0,0,1,.54-.42h.1v.33h-.12a.49.49,0,0,0-.47.45.88.88,0,0,0,0,.17v1h-.35Z" /><path fill="#1d1d1b" d="M24.39,7.33h0l.18-.22.56-.67h.43l-.75.8.85,1.14h-.43l-.66-.93-.18.2v.73H24V5.54h.35Z" /><path fill="#1d1d1b" d="M26.11,7.48a.62.62,0,0,0,.66.67,1.36,1.36,0,0,0,.54-.1l.06.25a1.67,1.67,0,0,1-.64.12.9.9,0,0,1-1-1,.94.94,0,0,1,.91-1,.82.82,0,0,1,.8.91c0,.07,0,.13,0,.17Zm1-.26a.5.5,0,0,0-.49-.57.59.59,0,0,0-.54.57Z" /><path fill="#1d1d1b" d="M28.34,5.89v.55h.51v.27h-.51v1c0,.24.07.38.27.38l.2,0,0,.26a.85.85,0,0,1-.32.05.49.49,0,0,1-.38-.15.71.71,0,0,1-.13-.5V6.71h-.3V6.44H28V6Z" /><path fill="#1d1d1b" d="M29.63,5.9a.2.2,0,0,1-.22.22.22.22,0,0,1,0-.44A.21.21,0,0,1,29.63,5.9Zm-.39,2.48V6.44h.35V8.38Z" /><path fill="#1d1d1b" d="M30.18,7c0-.2,0-.37,0-.53h.31l0,.32h0a.72.72,0,0,1,.64-.36c.27,0,.69.16.69.82V8.38h-.36V7.26c0-.31-.11-.57-.44-.57a.51.51,0,0,0-.48.36.88.88,0,0,0,0,.17V8.38h-.35Z" /><path fill="#1d1d1b" d="M34.07,6.44c0,.14,0,.3,0,.54V8.1a1.1,1.1,0,0,1-.28.88,1,1,0,0,1-.7.23,1.17,1.17,0,0,1-.64-.16l.08-.26a1.11,1.11,0,0,0,.57.15c.36,0,.63-.19.63-.68V8.05h0a.7.7,0,0,1-.62.32.86.86,0,0,1-.82-.94.93.93,0,0,1,.87-1,.63.63,0,0,1,.6.34h0l0-.3Zm-.37.77a.41.41,0,0,0,0-.16.49.49,0,0,0-.49-.37c-.34,0-.58.28-.58.73s.2.69.58.69a.5.5,0,0,0,.48-.36.57.57,0,0,0,0-.18Z" /><path fill="#3c4c9b" d="M38.09,11H67.54a2,2,0,0,1,2,2v0a2,2,0,0,1-2,2H38.09a0,0,0,0,1,0,0V11A0,0,0,0,1,38.09,11Z" /><rect fill="#7480b8" x="5.46" y="10.97" width="39.33" height="4" rx="2" /><rect fill="#fff" x="39.94" y="11.81" width="3.96" height="2.32" rx="1.07" /><path fill="#1d1d1b" d="M40.88,13.48v-.31h-.53v-.1l.51-.72H41v.7h.16v.12H41v.31Zm0-.43V12.5h0l-.1.17-.27.38h.37Z" /><path fill="#1d1d1b" d="M42,12.48h-.44l0,.29h.09a.51.51,0,0,1,.25.06.32.32,0,0,1,.16.29.4.4,0,0,1-.42.39.47.47,0,0,1-.28-.07l0-.12a.5.5,0,0,0,.25.07.25.25,0,0,0,.26-.25c0-.14-.1-.25-.32-.25h-.16l.08-.54H42Z" /><path fill="#1d1d1b" d="M42.71,12.67c0,.24-.13.36-.27.36s-.27-.12-.27-.35.12-.35.27-.35S42.71,12.45,42.71,12.67Zm-.42,0c0,.14.05.25.15.25s.15-.1.15-.25,0-.26-.15-.26S42.29,12.54,42.29,12.68Zm.14.82.66-1.17h.1l-.67,1.17Zm1-.36c0,.23-.12.35-.27.35s-.26-.11-.26-.34.12-.35.27-.35S43.44,12.92,43.44,13.14Zm-.41,0c0,.14,0,.25.15.25s.14-.11.14-.26,0-.25-.14-.25S43,13,43,13.15Z" /></svg>
        ),

    },

    {
        name: 'layout-9',
        title: __('layout-9'),
        description: __('layout-9'),

        isPro: false,
        //isPro: !isProFeature ? false : true,
        atts: {
            wrapper: { "options": { "tag": "div", "class": "" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "margin": {}, "paddingBottom": { "Desktop": "50px" } } }, progressData: { "type": "horizontal", "animate": "onVisible", "animateDuration": 1, "animateIteration": 2, "animateDelay": 2, "fill": 45, "unit": "%" }, progressInfo: { "options": { "tag": "div", "class": "", "position": "beforeBar" }, "styles": { "display": {}, "paddingBottom": { "Desktop": "10px" } } }, progressBar: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#9DD6DF" }, "borderRadius": { "Desktop": "50px 50px 50px 50px" }, "position": { "Desktop": "relative" } } }, progressFill: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#18978F" }, "width": { "Desktop": "75%" }, "paddingBottom": {}, "position": {}, "borderRadius": { "Desktop": "50px 50px 50px 50px" } } }, progressCount: { "options": { "tag": "div", "position": "afterFill", "class": "" }, "styles": { "color": { "Desktop": "#ffffff" }, "fontSize": {}, "padding": { "Desktop": "4px 8px 4px 8px" }, "backgroundColor": { "Desktop": "#774360" }, "position": { "Desktop": "absolute" }, "right": { "Desktop": "10px" }, "top": { "Desktop": "50%" }, "transform": { "Desktop": "translateY(-50%) " }, "borderRadius": { "Desktop": "50px 50px 50px 50px" } } }, progressLabel: { "options": { "text": "Digital Marketing", "position": "", "class": "" }, "styles": { "color": { "Desktop": "" }, "fontSize": { "Desktop": "" } } }, icon: { "options": { "library": "fontAwesome", "position": "beforeprogressCount", "srcType": "class", "iconSrc": "far fa-calendar-alt", "class": "number-count-icon" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "fontSize": { "Desktop": "" } } },

            circleMask: {},
            circleOverlay: {},


            blockId: "", customCss: "", blockCssY: { items: {} }
        },
        scope: ['block'],
        icon: (
            <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 75 20"><path fill="#1d1d1b" d="M5.77,5.72a5.15,5.15,0,0,1,.74-.06A1.55,1.55,0,0,1,7.6,6,1.24,1.24,0,0,1,8,7a1.4,1.4,0,0,1-.39,1A1.62,1.62,0,0,1,6.4,8.4a5.53,5.53,0,0,1-.63,0ZM6.12,8.1a1.73,1.73,0,0,0,.35,0A1,1,0,0,0,7.61,7a1,1,0,0,0-1.09-1,1.82,1.82,0,0,0-.4,0Z" /><path fill="#1d1d1b" d="M8.81,5.9a.2.2,0,0,1-.22.22.21.21,0,0,1-.21-.22.22.22,0,0,1,.22-.22A.21.21,0,0,1,8.81,5.9ZM8.42,8.38V6.44h.35V8.38Z" /><path fill="#1d1d1b" d="M11,6.44c0,.14,0,.3,0,.54V8.1a1.1,1.1,0,0,1-.28.88,1,1,0,0,1-.7.23,1.23,1.23,0,0,1-.65-.16l.09-.26a1.11,1.11,0,0,0,.57.15c.36,0,.62-.19.62-.68V8.05h0a.7.7,0,0,1-.62.32.86.86,0,0,1-.82-.94.92.92,0,0,1,.87-1,.64.64,0,0,1,.6.34h0v-.3Zm-.36.77a.41.41,0,0,0,0-.16.5.5,0,0,0-.49-.37c-.34,0-.58.28-.58.73s.19.69.57.69a.5.5,0,0,0,.49-.36.57.57,0,0,0,0-.18Z" /><path fill="#1d1d1b" d="M12,5.9a.21.21,0,0,1-.22.22.22.22,0,0,1-.22-.22.22.22,0,0,1,.22-.22A.21.21,0,0,1,12,5.9Zm-.39,2.48V6.44h.35V8.38Z" /><path fill="#1d1d1b" d="M12.93,5.89v.55h.5v.27h-.5v1c0,.25.07.38.26.38l.21,0v.26a.8.8,0,0,1-.31.05.48.48,0,0,1-.38-.15.7.7,0,0,1-.14-.5V6.71h-.3V6.44h.3V6Z" /><path fill="#1d1d1b" d="M14.9,8.38l0-.25h0a.71.71,0,0,1-.59.29.55.55,0,0,1-.59-.55c0-.47.41-.73,1.16-.72v0a.4.4,0,0,0-.44-.45,1,1,0,0,0-.5.14l-.08-.23a1.23,1.23,0,0,1,.63-.17c.59,0,.74.4.74.79v.72a2.27,2.27,0,0,0,0,.47Zm-.05-1c-.39,0-.82.06-.82.44a.31.31,0,0,0,.33.33.49.49,0,0,0,.47-.32.52.52,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M15.76,5.54h.35V8.38h-.35Z" /><path fill="#1d1d1b" d="M19.83,7.2c0-.38,0-.83,0-1.17h0c-.09.32-.21.65-.34,1L19,8.36H18.7l-.44-1.28C18.14,6.7,18,6.35,18,6h0c0,.34,0,.79-.05,1.19l-.07,1.16h-.33l.19-2.7h.44L18.58,7c.11.33.2.63.27.91h0c.07-.28.17-.57.29-.91l.48-1.31h.44l.17,2.7H19.9Z" /><path fill="#1d1d1b" d="M21.86,8.38l0-.25h0a.71.71,0,0,1-.59.29.55.55,0,0,1-.59-.55c0-.47.41-.73,1.16-.72v0a.4.4,0,0,0-.44-.45,1,1,0,0,0-.5.14l-.08-.23a1.23,1.23,0,0,1,.63-.17c.59,0,.74.4.74.79v.72a2.27,2.27,0,0,0,0,.47Zm-.05-1c-.39,0-.82.06-.82.44a.31.31,0,0,0,.33.33.49.49,0,0,0,.47-.32.52.52,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M22.72,7.05c0-.23,0-.43,0-.61H23v.38h0a.56.56,0,0,1,.53-.42h.1v.33h-.12a.49.49,0,0,0-.47.45.88.88,0,0,0,0,.17v1h-.34Z" /><path fill="#1d1d1b" d="M24.39,7.33h0l.18-.22.56-.67h.43l-.75.8.85,1.14h-.43l-.66-.93-.18.2v.73H24V5.54h.35Z" /><path fill="#1d1d1b" d="M26.11,7.48a.62.62,0,0,0,.66.67,1.36,1.36,0,0,0,.54-.1l.06.25a1.67,1.67,0,0,1-.64.12.9.9,0,0,1-.95-1,.93.93,0,0,1,.9-1,.82.82,0,0,1,.8.91c0,.07,0,.13,0,.17Zm1-.26a.5.5,0,0,0-.49-.57.57.57,0,0,0-.53.57Z" /><path fill="#1d1d1b" d="M28.34,5.89v.55h.51v.27h-.51v1c0,.25.07.38.27.38l.2,0,0,.26a.83.83,0,0,1-.31.05.46.46,0,0,1-.38-.15.7.7,0,0,1-.14-.5V6.71h-.3V6.44H28V6Z" /><path fill="#1d1d1b" d="M29.63,5.9a.2.2,0,0,1-.22.22.22.22,0,0,1,0-.44A.21.21,0,0,1,29.63,5.9Zm-.39,2.48V6.44h.35V8.38Z" /><path fill="#1d1d1b" d="M30.18,7c0-.2,0-.37,0-.53h.31l0,.32h0a.72.72,0,0,1,.64-.36c.27,0,.69.16.69.82V8.38h-.36V7.26c0-.31-.11-.57-.44-.57a.51.51,0,0,0-.48.36.88.88,0,0,0,0,.17V8.38h-.35Z" /><path fill="#1d1d1b" d="M34.07,6.44c0,.14,0,.3,0,.54V8.1a1.1,1.1,0,0,1-.28.88,1,1,0,0,1-.7.23,1.17,1.17,0,0,1-.64-.16l.09-.26a1,1,0,0,0,.56.15c.36,0,.63-.19.63-.68V8.05h0a.7.7,0,0,1-.62.32.86.86,0,0,1-.82-.94.93.93,0,0,1,.87-1,.63.63,0,0,1,.6.34h0l0-.3Zm-.37.77a.41.41,0,0,0,0-.16.49.49,0,0,0-.49-.37c-.34,0-.57.28-.57.73s.19.69.57.69a.5.5,0,0,0,.48-.36.57.57,0,0,0,0-.18Z" /><path fill="#3c4c9b" d="M38.09,11H67.54a2,2,0,0,1,2,2v0a2,2,0,0,1-2,2H38.09a0,0,0,0,1,0,0V11A0,0,0,0,1,38.09,11Z" /><rect fill="#7480b8" x="5.46" y="10.97" width="39.33" height="4" rx="2" /><rect fill="#fff" x="64.56" y="11.81" width="3.96" height="2.32" rx="1.07" /><path fill="#1d1d1b" d="M65.5,13.48v-.31H65v-.1l.51-.72h.16v.7h.16v.12h-.16v.31Zm0-.43V12.5h0l-.1.17-.27.38h.37Z" /><path fill="#1d1d1b" d="M66.6,12.48h-.44l0,.29h.09a.51.51,0,0,1,.25.06.32.32,0,0,1,.16.29.4.4,0,0,1-.42.39.47.47,0,0,1-.28-.07l0-.12a.5.5,0,0,0,.25.07.25.25,0,0,0,.26-.25c0-.14-.09-.25-.32-.25H66l.08-.54h.54Z" /><path fill="#1d1d1b" d="M67.33,12.67c0,.24-.13.36-.27.36s-.27-.12-.27-.35.12-.35.27-.35S67.33,12.45,67.33,12.67Zm-.42,0c0,.14,0,.25.15.25s.15-.1.15-.25,0-.26-.15-.26S66.91,12.54,66.91,12.68Zm.14.82.66-1.17h.1l-.67,1.17Zm1-.36c0,.23-.12.35-.27.35s-.26-.11-.26-.34.12-.35.27-.35S68.06,12.92,68.06,13.14Zm-.41,0c0,.14,0,.25.15.25s.14-.11.14-.26,0-.25-.14-.25S67.65,13,67.65,13.15Z" /></svg>
        ),

    },

    {
        name: 'layout-10',
        title: __('layout-10'),
        description: __('layout-10'),

        isPro: false,
        //isPro: !isProFeature ? false : true,
        atts: {
            wrapper: { "options": { "tag": "div", "class": "" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "margin": {}, "paddingBottom": { "Desktop": "50px" } } }, progressData: { "type": "horizontal", "animate": "onVisible", "animateDuration": 1, "animateIteration": 2, "animateDelay": 2, "fill": 45, "unit": "%" }, progressInfo: { "options": { "tag": "div", "class": "", "position": "beforeBar" }, "styles": { "display": {}, "paddingBottom": { "Desktop": "10px" } } }, progressBar: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#9DD6DF" }, "borderRadius": { "Desktop": "50px 50px 50px 50px" }, "position": { "Desktop": "relative !important" } } }, progressFill: { "options": { "tag": "div", "class": "" }, "styles": { "color": {}, "fontSize": {}, "height": { "Desktop": "50px" }, "backgroundColor": { "Desktop": "#18978F" }, "width": { "Desktop": "75%" }, "paddingBottom": {}, "position": { "Desktop": "relative" }, "borderRadius": { "Desktop": "50px 50px 50px 50px" } } }, progressCount: { "options": { "tag": "div", "position": "insideFill", "class": "" }, "styles": { "color": { "Desktop": "#ffffff" }, "fontSize": {}, "padding": { "Desktop": "4px 8px 4px 8px" }, "backgroundColor": { "Desktop": "#774360" }, "position": { "Desktop": "absolute" }, "right": {}, "top": { "Desktop": "50%" }, "transform": { "Desktop": "translateY(-50%) " }, "borderRadius": { "Desktop": "50px 50px 50px 50px" }, "left": { "Desktop": "8px" } } }, progressLabel: { "options": { "text": "Digital Marketing", "position": "", "class": "" }, "styles": { "color": { "Desktop": "" }, "fontSize": { "Desktop": "" } } }, icon: { "options": { "library": "fontAwesome", "position": "beforeprogressCount", "srcType": "class", "iconSrc": "far fa-calendar-alt", "class": "number-count-icon" }, "styles": { "color": { "Desktop": "" }, "backgroundColor": { "Desktop": "" }, "fontSize": { "Desktop": "" } } },

            circleMask: {},
            circleOverlay: {},


            blockId: "", customCss: "", blockCssY: { items: {} }
        },
        scope: ['block'],
        icon: (
            <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 75 20"><path fill="#1d1d1b" d="M5.77,5.72a5.15,5.15,0,0,1,.74-.06A1.55,1.55,0,0,1,7.6,6,1.24,1.24,0,0,1,8,7a1.4,1.4,0,0,1-.39,1A1.62,1.62,0,0,1,6.4,8.4a5.53,5.53,0,0,1-.63,0ZM6.12,8.1a1.73,1.73,0,0,0,.35,0A1,1,0,0,0,7.61,7a1,1,0,0,0-1.09-1,1.82,1.82,0,0,0-.4,0Z" /><path fill="#1d1d1b" d="M8.81,5.9a.21.21,0,0,1-.22.22.21.21,0,0,1-.21-.22.22.22,0,0,1,.22-.22A.21.21,0,0,1,8.81,5.9ZM8.42,8.38V6.44h.35V8.38Z" /><path fill="#1d1d1b" d="M11,6.44c0,.14,0,.3,0,.54V8.1a1.1,1.1,0,0,1-.28.88,1,1,0,0,1-.7.23,1.21,1.21,0,0,1-.65-.16l.09-.26a1.11,1.11,0,0,0,.57.15c.36,0,.62-.19.62-.68V8.05h0a.67.67,0,0,1-.61.32.86.86,0,0,1-.82-.94.92.92,0,0,1,.87-1,.65.65,0,0,1,.6.33h0V6.44Zm-.36.77a.78.78,0,0,0,0-.16.51.51,0,0,0-.49-.37c-.34,0-.58.28-.58.73s.19.69.57.69a.51.51,0,0,0,.49-.36.62.62,0,0,0,0-.18Z" /><path fill="#1d1d1b" d="M12,5.9a.22.22,0,0,1-.44,0,.22.22,0,0,1,.22-.22A.22.22,0,0,1,12,5.9Zm-.39,2.48V6.44h.35V8.38Z" /><path fill="#1d1d1b" d="M12.93,5.89v.55h.5v.27h-.5v1c0,.24.06.38.26.38l.2,0,0,.26a.83.83,0,0,1-.31.05.46.46,0,0,1-.38-.15.71.71,0,0,1-.14-.5V6.71h-.3V6.44h.3V6Z" /><path fill="#1d1d1b" d="M14.9,8.38l0-.25h0a.71.71,0,0,1-.59.29.54.54,0,0,1-.59-.55c0-.47.41-.73,1.16-.72v0a.4.4,0,0,0-.44-.45,1.08,1.08,0,0,0-.51.14l-.08-.23a1.27,1.27,0,0,1,.64-.17c.59,0,.74.4.74.79v.72a2.27,2.27,0,0,0,0,.47Zm-.05-1c-.39,0-.82.06-.82.44a.31.31,0,0,0,.33.33.49.49,0,0,0,.47-.32.52.52,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M15.76,5.54h.35V8.38h-.35Z" /><path fill="#1d1d1b" d="M19.83,7.19c0-.37,0-.82,0-1.16h0c-.09.32-.21.65-.34,1L19,8.36H18.7l-.44-1.28C18.13,6.7,18,6.35,18,6h0c0,.34,0,.79-.05,1.19l-.07,1.16h-.33l.19-2.7h.44L18.58,7c.11.33.2.62.27.91h0c.07-.28.17-.57.29-.91l.48-1.31h.44l.17,2.7H19.9Z" /><path fill="#1d1d1b" d="M21.86,8.38l0-.25h0a.71.71,0,0,1-.59.29.54.54,0,0,1-.59-.55c0-.47.41-.73,1.16-.72v0a.4.4,0,0,0-.44-.45,1.08,1.08,0,0,0-.51.14l-.08-.23a1.27,1.27,0,0,1,.64-.17c.59,0,.74.4.74.79v.72a2.27,2.27,0,0,0,0,.47Zm-.05-1c-.39,0-.82.06-.82.44a.31.31,0,0,0,.33.33.49.49,0,0,0,.47-.32.52.52,0,0,0,0-.11Z" /><path fill="#1d1d1b" d="M22.71,7.05c0-.23,0-.43,0-.61H23v.38h0a.58.58,0,0,1,.54-.42h.1v.33h-.12a.49.49,0,0,0-.47.45.88.88,0,0,0,0,.17v1h-.35Z" /><path fill="#1d1d1b" d="M24.39,7.33h0l.18-.22.56-.67h.43l-.75.8.85,1.14h-.43l-.66-.93-.18.2v.73H24V5.54h.35Z" /><path fill="#1d1d1b" d="M26.11,7.48a.62.62,0,0,0,.66.67,1.36,1.36,0,0,0,.54-.1l.06.25a1.67,1.67,0,0,1-.64.12.9.9,0,0,1-1-1,.94.94,0,0,1,.91-1,.82.82,0,0,1,.8.91c0,.07,0,.13,0,.17Zm1-.26a.5.5,0,0,0-.49-.57.59.59,0,0,0-.54.57Z" /><path fill="#1d1d1b" d="M28.34,5.89v.55h.51v.27h-.51v1c0,.24.07.38.27.38l.2,0,0,.26a.85.85,0,0,1-.32.05.49.49,0,0,1-.38-.15.71.71,0,0,1-.13-.5V6.71h-.3V6.44H28V6Z" /><path fill="#1d1d1b" d="M29.63,5.9a.2.2,0,0,1-.22.22.22.22,0,0,1,0-.44A.21.21,0,0,1,29.63,5.9Zm-.39,2.48V6.44h.35V8.38Z" /><path fill="#1d1d1b" d="M30.18,7c0-.2,0-.37,0-.53h.31l0,.32h0a.72.72,0,0,1,.64-.36c.27,0,.69.16.69.82V8.38h-.36V7.26c0-.31-.11-.57-.44-.57a.51.51,0,0,0-.48.36.79.79,0,0,0,0,.17V8.38h-.35Z" /><path fill="#1d1d1b" d="M34.07,6.44c0,.14,0,.3,0,.54V8.1a1.1,1.1,0,0,1-.28.88,1,1,0,0,1-.7.23,1.17,1.17,0,0,1-.64-.16l.08-.26a1.11,1.11,0,0,0,.57.15c.36,0,.63-.19.63-.68V8.05h0a.7.7,0,0,1-.62.32.86.86,0,0,1-.82-.94.93.93,0,0,1,.87-1,.64.64,0,0,1,.6.33h0l0-.29Zm-.37.77a.41.41,0,0,0,0-.16.49.49,0,0,0-.49-.37c-.34,0-.58.28-.58.73s.2.69.58.69a.5.5,0,0,0,.48-.36.62.62,0,0,0,0-.18Z" /><path fill="#3c4c9b" d="M38.09,11H67.54a2,2,0,0,1,2,2v0a2,2,0,0,1-2,2H38.09a0,0,0,0,1,0,0V11a0,0,0,0,1,0,0Z" /><rect fill="#7480b8" x="5.46" y="10.97" width="39.33" height="4" rx="2" /><rect fill="#fff" x="6.45" y="11.81" width="3.96" height="2.32" rx="1.07" /><path fill="#1d1d1b" d="M7.4,13.48v-.31H6.87v-.1l.51-.72h.16v.7H7.7v.12H7.54v.31Zm0-.43V12.5h0l-.1.17L7,13.05H7.4Z" /><path fill="#1d1d1b" d="M8.49,12.48H8.06l0,.29h.09a.45.45,0,0,1,.24.06.33.33,0,0,1,.17.29.4.4,0,0,1-.42.39.54.54,0,0,1-.29-.07l0-.12a.49.49,0,0,0,.24.07.25.25,0,0,0,.27-.25c0-.15-.1-.25-.32-.25H7.88L8,12.35h.54Z" /><path fill="#1d1d1b" d="M9.22,12.67c0,.24-.12.36-.27.36s-.26-.12-.26-.35.12-.35.27-.35S9.22,12.45,9.22,12.67Zm-.41,0c0,.14,0,.25.15.25s.14-.11.14-.25,0-.26-.14-.26S8.81,12.54,8.81,12.68Zm.13.82.67-1.17H9.7L9,13.5Zm1-.36c0,.23-.12.35-.27.35s-.26-.11-.26-.34.12-.35.27-.35S10,12.92,10,13.14Zm-.41,0c0,.14,0,.25.14.25s.15-.11.15-.26,0-.25-.15-.25S9.55,13,9.55,13.15Z" /></svg>
        ),

    },










];

export default variations;