/**
 * @file
 * Attaches behaviors for the Clientside Validation jQuery module.
 */
(function ($, once) {
  // Override clientside validation jquery validation options.
  // We do this to display the error markup same as in inline_form_errors.
  // Using once can not use `window` or `document` directly.
  if (!once('cvjquery', 'html').length) {
    // Early return avoid changing the indentation
    // for the rest of the code.
    return;
  }

  $(document).on('cv-jquery-validate-options-update', function (event, options) {
    options.errorElement = 'strong';
    options.showErrors = function(errorMap, errorList) {
      // First remove all errors.
      for (var i in errorList) {
        $(errorList[i].element).parent().find('.form-item--error-message').remove();
      }

      // Show errors using defaultShowErrors().
      this.defaultShowErrors();

      // Wrap all errors with div.form-item--error-message.
      $(this.currentForm).find('strong.error').each(function () {
        if (!$(this).parent().hasClass('form-item--error-message')) {
          $(this).wrap('<div class="form-item--error-message" role="alert"/>');
        }
      });
    };
  });
})(jQuery, once);
