(function (Handlebars, moment) {

  Handlebars.registerHelper('eq', function (a, b, options) {
    return value(a === b, this, options);
  });
  Handlebars.registerHelper('neq', function (a, b, options) {
    return value(a !== b, this, options);
  });
  Handlebars.registerHelper('gt', function (a, b, options) {
    return value(a > b, this, options);
  });
  Handlebars.registerHelper('gte', function (a, b, options) {
    return value(a >= b, this, options);
  });
  Handlebars.registerHelper('lt', function (a, b, options) {
    return value(a < b, this, options);
  });
  Handlebars.registerHelper('lte', function (a, b, options) {
    return value(a <= b, this, options);
  });
  Handlebars.registerHelper('dateFormat', function (timestamp, format, utc) {
    var mt = moment.unix(timestamp);
    return (utc === true) ? mt.utc().format(format) : mt.format(format);
  });

  function value(val, context, options) {
    if (val) {
      return options.fn(context);
    }
    return options.inverse(context);
  }

})(Handlebars, moment);
