<?php

namespace Drupal\openlayers\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\openlayers\OpenlayersInteractionInterface;

/**
 * Defines the Openlayers Interaction entity.
 *
 * @ConfigEntityType(
 *   id = "openlayers_interaction",
 *   label = @Translation("Openlayers Interaction"),
 *   handlers = {
 *     "list_builder" = "Drupal\openlayers\Controller\OpenlayersInteractionListBuilder",
 *     "form" = {
 *       "add" = "Drupal\openlayers\Form\OpenlayersInteractionAddForm",
 *       "edit" = "Drupal\openlayers\Form\OpenlayersInteractionEditForm",
 *       "delete" = "Drupal\openlayers\Form\OpenlayersInteractionDeleteForm",
 *     }
 *   },
 *   config_prefix = "interaction",
 *   admin_permission = "administer openlayers",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "interaction_type",
 *     "is_configurable"
 *   },
 *   links = {
 *     "edit-form" = "/admin/config/system/openlayers/interaction/{openlayers_interaction}/edit",
 *     "delete-form" = "/admin/config/system/openlayers/interaction/{openlayers_interaction}/delete",
 *   }
 * )
 */
class OpenlayersInteraction extends ConfigEntityBase implements OpenlayersInteractionInterface {

  /**
   * The Example ID.
   *
   * @var string
   */
  public $id;

  /**
   * The Example label.
   *
   * @var string
   */
  public $label;

  // Your specific configuration property get/set methods go here,
  // implementing the interface.
}
