<?php

namespace Drupal\openlayers\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\openlayers\OpenlayersSourceInterface;

/**
 * Defines the Openlayers Source entity.
 *
 * @ConfigEntityType(
 *   id = "openlayers_source",
 *   label = @Translation("Openlayers Source"),
 *   handlers = {
 *     "list_builder" = "Drupal\openlayers\Controller\OpenlayersSourceListBuilder",
 *     "form" = {
 *       "add" = "Drupal\openlayers\Form\OpenlayersSourceAddForm",
 *       "edit" = "Drupal\openlayers\Form\OpenlayersSourceEditForm",
 *       "delete" = "Drupal\openlayers\Form\OpenlayersSourceDeleteForm",
 *     }
 *   },
 *   config_prefix = "source",
 *   admin_permission = "administer openlayers",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "source_type",
 *     "options",
 *   },
 *   links = {
 *     "edit-form" = "/admin/config/system/openlayers/source/{openlayers_source}/edit",
 *     "delete-form" = "/admin/config/system/openlayers/source/{openlayers_source}/delete",
 *   }
 * )
 */
class OpenlayersSource extends ConfigEntityBase implements OpenlayersSourceInterface {

  /**
   * The Example ID.
   *
   * @var string
   */
  public $id;

  /**
   * The Example label.
   *
   * @var string
   */
  public $label;

  // Your specific configuration property get/set methods go here,
  // implementing the interface.
}
