<?php

namespace Drupal\openlayers\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\openlayers\OpenlayersMapInterface;
use Drupal\openlayers\OpenlayersLayerInterface;

/**
 * Provides an edit form for image effects.
 *
 * @internal
 */
class MapLayerEditForm extends MapLayerFormBase {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, OpenlayersMapInterface $map = NULL, $layer = NULL) {
    $form = parent::buildForm($form, $form_state, $map, $layer);
    $form['#title'] = $this->t('Edit %label layer', ['%label' => $this->mapLayer->label()]);
    $form['actions']['submit']['#value'] = $this->t('Update layer');

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  protected function prepareOpenlayersLayer($layer) {
    return $layer;
  }
}
