<?php

namespace Drupal\openlayers\Form;

use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

use Drupal\openlayers\OpenlayersMapInterface;
use Drupal\openlayers\Form\OpenlayersPluginFormBase;
use Drupal\openlayers\ControlPluginManager;

/**
 * Provides an add form for the settings for Openlayers plugins.
 *
 * @internal
 */
class OpenlayersControlPluginAddForm extends OpenlayersPluginFormBase {
  /**
   * The Openlayers plugin manager.
   *
   * @var \Drupal\openlayers\Form\ControlPluginManager
   */
  protected $pluginManager;

  /**
   * Constructs a new OpenlayersPluginAddForm.
   *
   * @param \Drupal\openlayers\Form\ControlPluginManager
   *   The Openlayers plugin manager.
   */
  public function __construct(ControlPluginManager $plugin_manager) {
    $this->pluginManager = $plugin_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('plugin.manager.openlayers.control')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, OpenlayersMapInterface $map = NULL, $plugin_type = NULL, $plugin = NULL) {
    $form = parent::buildForm($form, $form_state, $map, $plugin_type, $plugin);
    
    $form['#title'] = $this->t('Edit %label %type', ['%label' => $this->olPlugin->label(), '%type' => $plugin_type]);
    $form['actions']['submit']['#value'] = $this->t('Add plugin settings');

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  protected function preparePlugin($plugin_type, $plugin) {
    $plugin = $this->pluginManager->createInstance($plugin);
    
    return $plugin;
  }

}
