<?php

namespace Drupal\openlayers;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Manages image effect plugins.
 *
 * @see hook_image_effect_info_alter()
 * @see \Drupal\image\Annotation\ImageEffect
 * @see \Drupal\image\ConfigurableImageEffectInterface
 * @see \Drupal\image\ConfigurableImageEffectBase
 * @see \Drupal\image\ImageEffectInterface
 * @see \Drupal\image\ImageEffectBase
 * @see plugin_api
 */
class InteractionPluginManager extends DefaultPluginManager {

  /**
   * Constructs a new Openlayers Interaction plugin manager.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/OpenlayersInteraction', $namespaces, $module_handler, 'Drupal\openlayers\OpenlayersPluginInterface', 'Drupal\openlayers\Annotation\OpenlayersInteraction');

    $this->alterInfo('openlayers_interaction_plugin_info');
    $this->setCacheBackend($cache_backend, 'openlayers_interaction_plugins');
  }

}
