<?php

namespace Drupal\openlayers;

//use Drupal\Component\Utility\Color;
//use Drupal\Component\Utility\Rectangle;
use Drupal\Core\Form\FormStateInterface;
//use Drupal\Core\Image\ImageInterface;
//use Drupal\image\ConfigurableImageEffectBase;

/**
 * Contains details of how a layers is joined to a map.
 *
 */
//class RotateImageEffect extends ConfigurableImageEffectBase {
class MapLayer {

  public $configuration;

  public function __construct($configuration, $action) {
    if ($action == 'update' || $action == 'delete') {
      $this->id = $configuration['id'];
      $this->uuid = $configuration['uuid'];
      $this->weight = isset($configuration['weight']) ? $configuration['weight'] : 0;
      $this->configuration = isset($configuration['data']) ? $configuration['data'] : [];
    } else {
      $this->id = $configuration;
      $this->uuid = \Drupal::service('uuid')->generate();
      $this->weight = 10;
      $this->configuration = [];      
    }
  }

  /**
   * {@inheritdoc}
   */
  public function id() {
    return $this->id;
  }
  
  /**
   * {@inheritdoc}
   */
  public function label() {
    return \Drupal::config('openlayers.layer.' . $this->id)->get('label');
  }
  
  /**
   * {@inheritdoc}
   */
  public function getUuid() {
    return $this->uuid;
  }

  /**
   * {@inheritdoc}
   */
  public function setWeight($weight) {
    $this->weight = $weight;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getWeight() {
    return $this->weight;
  }
  
  /**
   * {@inheritdoc}
   */
  public function getConfiguration() {
    return [
      'uuid' => $this->getUuid(),
      'id' => $this->id(),
      'weight' => $this->getWeight(),
      'data' => $this->configuration,
    ];
  }
  
  /**
   * {@inheritdoc}
   */
  public function applyEffect(ImageInterface $image) {
    if (!empty($this->configuration['random'])) {
      $degrees = abs((float) $this->configuration['degrees']);
      $this->configuration['degrees'] = rand(-$degrees, $degrees);
    }

    if (!$image->rotate($this->configuration['degrees'], $this->configuration['bgcolor'])) {
      $this->logger->error('Image rotate failed using the %toolkit toolkit on %path (%mimetype, %dimensions)', ['%toolkit' => $image->getToolkitId(), '%path' => $image->getSource(), '%mimetype' => $image->getMimeType(), '%dimensions' => $image->getWidth() . 'x' . $image->getHeight()]);
      return FALSE;
    }
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function transformDimensions(array &$dimensions, $uri) {
    // If the rotate is not random and current dimensions are set,
    // then the new dimensions can be determined.
    if (!$this->configuration['random'] && $dimensions['width'] && $dimensions['height']) {
      $rect = new Rectangle($dimensions['width'], $dimensions['height']);
      $rect = $rect->rotate($this->configuration['degrees']);
      $dimensions['width'] = $rect->getBoundingWidth();
      $dimensions['height'] = $rect->getBoundingHeight();
    }
    else {
      $dimensions['width'] = $dimensions['height'] = NULL;
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getSummary() {
    $summary = [
      '#theme' => 'image_rotate_summary',
      '#data' => $this->configuration,
    ];

    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {      //    TODO: Where is this called from ?
    return [
      'base' => 'base',
      'title' => 'kkkkkk',
      'visible' => 0,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {

    $form['base'] = array(
      '#type' => 'select',
      '#title' => t('Base/Overlay'),
      '#options' => array(
        'base' => 'Base',
        'overlay' => 'Overlay',
      ),
      '#default_value' => isset($this->configuration['base']) ? $this->configuration['base'] : 'base',
      '#description' => t('Each map may have multiple base layers, but only one of them will be shown at a time.'),
      '#size' => 1,
      '#prefix' => '<div class="xxxxx">',
      '#suffix' => '</div>',
      '#required' => TRUE,
    );

    $form['title'] = [
      '#type' => 'textfield',
      '#default_value' => isset($this->configuration['title']) ? $this->configuration['title'] : null,
      '#title' => t('Title'),
      '#description' => t('This is the title of the layer that will be shown in the Layer Switcher.'),
      '#size' => 30,
      '#maxlength' => 30,
    ];
    
    $form['visible'] = array(
      '#type' => 'select',
      '#title' => t('Visible'),
      '#options' => array(
        '1' => 'Yes',
        '0' => 'No',
      ),
      '#size' => 1,
      '#description' => t('Select this option for the base layer to be shown initially in the Layer Switcher.'),
      '#prefix' => '<div class="xxxxx">',
      '#default_value' => isset($this->configuration['visible']) ? $this->configuration['visible'] : 0,
      '#suffix' => '</div>',
      '#required' => TRUE,
    );

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {
    
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    $this->configuration['base'] = $form_state->getValue('base');
    $this->configuration['title'] = $form_state->getValue('title');
    $this->configuration['visible'] = $form_state->getValue('visible');
  }

}
