<?php

namespace Drupal\openlayers;

use Drupal\Core\Form\FormStateInterface;

/**
 * Contains details of how a style is joined to a map.
 *
 */
class MapStyle {

  public $configuration;

  public function __construct($configuration, $action) {
    if ($action == 'update' || $action == 'delete') {
      $this->id = $configuration['id'];
      $this->uuid = $configuration['uuid'];
      $this->configuration = isset($configuration['data']) ? $configuration['data'] : [];
    } else {
      $this->id = $configuration;
      $this->uuid = \Drupal::service('uuid')->generate();
      $this->configuration = [];      
    }
  }

  /**
   * {@inheritdoc}
   */
  public function id() {
    return $this->id;
  }
  
  /**
   * {@inheritdoc}
   */
  public function label() {
    return \Drupal::config('openlayers.style.' . $this->id)->get('label');
  }
  
  /**
   * {@inheritdoc}
   */
  public function getUuid() {
    return $this->uuid;
  }

  /**
   * {@inheritdoc}
   */
  public function getConfiguration() {
    return [
      'uuid' => $this->getUuid(),
      'id' => $this->id(),
      'weight' => $this->getWeight(),
      'data' => $this->configuration,
    ];
  }
  
  /**
   * {@inheritdoc}
   */
/*
  public function getSummary() {
    $summary = [
      '#theme' => 'image_rotate_summary',
      '#data' => $this->configuration,
    ];
//    $summary += parent::getSummary();

    return $summary;
  }
*/
  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {      //    TODO: Where is this called from ?
    return [
      'base' => 'base',
      'title' => 'kkkkkk',
      'visible' => 0,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {

    $form['base'] = array(
      '#type' => 'select',
      '#title' => t('Base/Overlay'),
      '#options' => array(
        'base' => 'Base',
        'overlay' => 'Overlay',
      ),
      '#default_value' => isset($this->configuration['base']) ? $this->configuration['base'] : 'base',
      '#description' => t('Each map may have multiple base layers, but only one of them will be shown at a time.'),
      '#size' => 1,
      '#prefix' => '<div class="xxxxx">',
      '#suffix' => '</div>',
      '#required' => TRUE,
    );

    $form['title'] = [
      '#type' => 'textfield',
      '#default_value' => isset($this->configuration['title']) ? $this->configuration['title'] : null,
      '#title' => t('Title'),
      '#description' => t('This is the title of the layer that will be shown in the Layer Switcher.'),
      '#size' => 30,
      '#maxlength' => 30,
    ];
    
    $form['visible'] = array(
      '#type' => 'select',
      '#title' => t('Visible'),
      '#options' => array(
        '1' => 'Yes',
        '0' => 'No',
      ),
      '#size' => 1,
      '#description' => t('Select this option for the base layer to be shown initially in the Layer Switcher.'),
      '#prefix' => '<div class="xxxxx">',
      '#default_value' => isset($this->configuration['visible']) ? $this->configuration['visible'] : 0,
      '#suffix' => '</div>',
      '#required' => TRUE,
    );

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {
/*
    if (!$form_state->isValueEmpty('bgcolor') && !Color::validateHex($form_state->getValue('bgcolor'))) {
      $form_state->setErrorByName('bgcolor', $this->t('Background color must be a hexadecimal color value.'));
    }
*/
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
//    parent::submitConfigurationForm($form, $form_state);
    $this->configuration['base'] = $form_state->getValue('base');
    $this->configuration['title'] = $form_state->getValue('title');
    $this->configuration['visible'] = $form_state->getValue('visible');
  }

}
