<?php

namespace Drupal\openlayers\Plugin\OpenlayersControl;

use Drupal\Component\Utility\Color;
use Drupal\Component\Utility\Rectangle;
use Drupal\Core\Form\FormStateInterface;
use Drupal\openlayers\OpenlayersConfigurablePluginBase;

/**
 * Defines the Zoom control for an Openlayers map.
 *
 * @OpenlayersControl(
 *   id = "ol_control_zoom",
 *   label = @Translation("Zoom"),
 *   description = @Translation("Define a zoom control."),
 *   type = "control",
 *   ol_id = "Zoom"
 * )
 */
class Zoom extends OpenlayersConfigurablePluginBase {

  /**
   * {@inheritdoc}
   */
  public function getSummary() {
    $summary = [
      '#theme' => 'openlayers_control_summary',
      '#data' => $this->configuration,
    ];
    $summary += parent::getSummary();

    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'className' => 'ol-zoom',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['className'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['className'],
      '#title' => t('Class name'),
      '#description' => t('CSS class name.'),
      '#size' => 50,
      '#maxlength' => 50,
      '#required' => FALSE,
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {

  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);

    $this->configuration['className'] = $form_state->getValue('className');
  }

}
