<?php

namespace Drupal\openlayers\Plugin\OpenlayersStyle;

use Drupal\Component\Utility\Color;
use Drupal\Component\Utility\Rectangle;
use Drupal\Core\Form\FormStateInterface;
use Drupal\openlayers\OpenlayersConfigurablePluginBase;

/**
 * Defines the Line style for Openlayers features.
 *
 * @OpenlayersStyle(
 *   id = "ol_style_stroke",
 *   label = @Translation("Stroke"),
 *   description = @Translation("Define the line style for map features."),
 *   type = "style",
 *   ol_id = "Stroke"
 * )
 */
class Stroke extends OpenlayersConfigurablePluginBase {

  /**
   * {@inheritdoc}
   */
  public function getSummary() {
    $summary = [
      '#theme' => 'openlayers_style_stroke_summary',            //  TODO - ???
      '#data' => $this->configuration,
    ];
    $summary += parent::getSummary();

    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'color' => NULL,
      'lineDash' => NULL,
      'width' => 1,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['color'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['color'],
      '#title' => t('Stroke color'),
      //  TODO - improve description to recognise other valid color formats.
      '#description' => t('The color to be used for line features on the map. Use web-style hex colors (#FFFFFF for white, #000000 for black).'),
      '#size' => 20,
      '#maxlength' => 20,
      '#required' => FALSE,
    ];
    $form['lineDash'] = [
      '#type' => 'number',
      '#default_value' => $this->configuration['lineDash'],
      '#title' => t('Line dash pattern'),
      '#description' => t('The dash pattern to use for line features on the map. Leave blank for no dash.'),
      '#required' => FALSE,
    ];
    $form['width'] = [
      '#type' => 'number',
      '#default_value' => $this->configuration['width'],
      '#title' => t('Stroke width'),
      '#description' => t('The width to be used for line features on the map. Defaults to 1.'),
      '#field_suffix' => 'pixels',
      '#required' => FALSE,
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {
/*
    if (!$form_state->isValueEmpty('color') && !Color::validateHex($form_state->getValue('color'))) {
      $form_state->setErrorByName('color', $this->t('Color must be a hexadecimal color value.'));
    }
*/
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);

    $this->configuration['color'] = $form_state->getValue('color');
    $this->configuration['lineDash'] = $form_state->getValue('lineDash');
    $this->configuration['width'] = $form_state->getValue('width');
  }

}
