<?php

namespace Drupal\openlayers\Controller;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of Openalyers Map configuration entities.
 */
class OpenlayersMapListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Map');
    $header['id'] = $this->t('Machine name');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row['label'] = $entity->label();
    $row['id'] = $entity->id();

    // You probably want a few more properties here...

    return $row + parent::buildRow($entity);
  }
  
  /**
   * This function is a workaround until the core issue (#2950883)) is resolved - https://www.drupal.org/project/drupal/issues/2950883
   * {@inheritdoc}
   */
  public function getDefaultOperations(EntityInterface $entity) {

    $operations = parent::getDefaultOperations($entity);
    
    // Remove destination URL from the edit link to allow editing of map layers.
    if (isset($operations['edit'])) {
      $operations['edit']['url'] = $entity->toUrl('edit-form');
    }

    return $operations;
  }

}