<?php

namespace Drupal\openlayers\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\openlayers\OpenlayersLayerInterface;

/**
 * Defines the Openlayers Layer entity.
 *
 * @ConfigEntityType(
 *   id = "openlayers_layer",
 *   label = @Translation("Openlayers Layer"),
 *   handlers = {
 *     "list_builder" = "Drupal\openlayers\Controller\OpenlayersLayerListBuilder",
 *     "form" = {
 *       "add" = "Drupal\openlayers\Form\OpenlayersLayerAddForm",
 *       "edit" = "Drupal\openlayers\Form\OpenlayersLayerEditForm",
 *       "delete" = "Drupal\openlayers\Form\OpenlayersLayerDeleteForm",
 *     }
 *   },
 *   config_prefix = "layer",
 *   admin_permission = "administer openlayers",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "layer_type",
 *     "is_configurable",
 *     "source",
 *     "base",
 *     "title",
 *     "visible"
 *   },
 *   links = {
 *     "edit-form" = "/admin/config/system/openlayers/layer/{openlayers_layer}/edit",
 *     "delete-form" = "/admin/config/system/openlayers/layer/{openlayers_layer}/delete",
 *   }
 * )
 */
class OpenlayersLayer extends ConfigEntityBase implements OpenlayersLayerInterface {

  /**
   * The Example ID.
   *
   * @var string
   */
  public $id;

  /**
   * The Example label.
   *
   * @var string
   */
  public $label;

  // Your specific configuration property get/set methods go here,
  // implementing the interface.

  /**
   * {@inheritdoc}
   */
  public function id() {
    
    return $this->get('id');
  }

  /**
   * {@inheritdoc}
   */
  public function label() {
    return $this->label;
  }
  
  /**
   * {@inheritdoc}
   */
  public function getName() {
    return $this->get('name');
  }

  /**
   * {@inheritdoc}
   */
  public function getAllSources() {
    $sourceNames = \Drupal::service('config.storage')->listAll('openlayers.source');
    $sources = [];

    foreach ($sourceNames as $sourceName) {
      $sourceLabel = \Drupal::config($sourceName)->get('label');
      $sourceName = str_replace('openlayers.source.', '', $sourceName); 
      $sources[$sourceName] = $sourceLabel;
    }
    return $sources;
  }
  
}
