<?php

namespace Drupal\openlayers\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\openlayers\OpenlayersStyleInterface;

/**
 * Defines the Openlayers Style entity.
 *
 * @ConfigEntityType(
 *   id = "openlayers_style",
 *   label = @Translation("Openlayers Style"),
 *   handlers = {
 *     "list_builder" = "Drupal\openlayers\Controller\OpenlayersStyleListBuilder",
 *     "form" = {
 *       "add" = "Drupal\openlayers\Form\OpenlayersStyleAddForm",
 *       "edit" = "Drupal\openlayers\Form\OpenlayersStyleEditForm",
 *       "delete" = "Drupal\openlayers\Form\OpenlayersStyleDeleteForm",
 *     }
 *   },
 *   config_prefix = "style",
 *   admin_permission = "administer openlayers",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "style_type",
 *     "is_configurable"
 *   },
 *   links = {
 *     "edit-form" = "/admin/config/system/openlayers/style/{openlayers_style}/edit",
 *     "delete-form" = "/admin/config/system/openlayers/style/{openlayers_style}/delete",
 *   }
 * )
 */
class OpenlayersStyle extends ConfigEntityBase implements OpenlayersStyleInterface {

  /**
   * The Example ID.
   *
   * @var string
   */
  public $id;

  /**
   * The Example label.
   *
   * @var string
   */
  public $label;

  // Your specific configuration property get/set methods go here,
  // implementing the interface.
}
