<?php

namespace Drupal\openlayers\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\openlayers\OpenlayersMapInterface;
use Drupal\openlayers\MapControl;

/**
 * Form for deleting a map control.
 *
 * @internal
 */
class MapControlDeleteForm extends ConfirmFormBase {

  /**
   * The map containing the control to be deleted.
   *
   * @var \Drupal\image\ImageControlInterface
   */
  protected $olMap;

  /**
   * The control to be deleted.
   *
   * @var \Drupal\image\ImageEffectInterface
   */
  protected $mapControl;

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you want to delete the %control control from the %map map?',
      ['%map' => $this->olMap->label(), '%control' => $this->mapControl->label()]);
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Delete');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return $this->olMap->toUrl('edit-form');
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ol_control_delete_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, OpenlayersMapInterface $map = NULL, $control = NULL) {
    $this->olMap = $map;
    $this->mapControl = new MapControl($this->olMap->controls[$control], 'delete');

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->olMap->deleteMapControl($this->mapControl);
    $this->olMap->save();
    $this->messenger()->addStatus($this->t('The control %name has been deleted from the map.', ['%name' => $this->mapControl->label()]));
    $form_state->setRedirectUrl($this->olMap->toUrl('edit-form'));
  }

}
