<?php

namespace Drupal\openlayers\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\openlayers\OpenlayersMapInterface;
use Drupal\openlayers\MapInteraction;

/**
 * Form for deleting a map interaction.
 *
 * @internal
 */
class MapInteractionDeleteForm extends ConfirmFormBase {

  /**
   * The map containing the interaction to be deleted.
   *
   * @var \Drupal\image\ImageStyleInterface
   */
  protected $olMap;

  /**
   * The interaction to be deleted.
   *
   * @var \Drupal\image\ImageEffectInterface
   */
  protected $mapInteraction;

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you want to delete the %interaction interaction from the %map map?',
      ['%map' => $this->olMap->label(), '%interaction' => $this->mapInteraction->label()]);
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Delete');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return $this->olMap->toUrl('edit-form');
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ol_interaction_delete_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, OpenlayersMapInterface $map = NULL, $interaction = NULL) {
    $this->olMap = $map;
    $this->mapInteraction = new MapInteraction($this->olMap->interactions[$interaction], 'delete');

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->olMap->deleteMapInteraction($this->mapInteraction);
    $this->olMap->save();
    $this->messenger()->addStatus($this->t('The interaction %name has been deleted from the map.', ['%name' => $this->mapInteraction->label()]));
    $form_state->setRedirectUrl($this->olMap->toUrl('edit-form'));
  }

}
