<?php

namespace Drupal\openlayers\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\openlayers\OpenlayersMapInterface;
use Drupal\openlayers\MapLayer;

/**
 * Form for deleting a layer from a map.
 *
 * @internal
 */
class MapLayerDeleteForm extends ConfirmFormBase {

  /**
   * The map containing the layer to be deleted.
   *
   * @var \Drupal\image\ImageStyleInterface
   */
  protected $olMap;

  /**
   * The layer to be deleted.
   *
   * @var \Drupal\image\ImageEffectInterface
   */
  protected $mapLayer;

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you want to delete the %layer layer from the %map map?',
      ['%map' => $this->olMap->label(), '%layer' => $this->mapLayer->label()]);
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Delete');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return $this->olMap->toUrl('edit-form');
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ol_layer_delete_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, OpenlayersMapInterface $map = NULL, $layer = NULL) {
    $this->olMap = $map;
    $this->mapLayer = new MapLayer($this->olMap->layers[$layer], 'delete');

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->olMap->deleteMapLayer($this->mapLayer);
    $this->olMap->save();
    $this->messenger()->addStatus($this->t('The layer %name has been deleted from the map.', ['%name' => $this->mapLayer->label()]));
    $form_state->setRedirectUrl($this->olMap->toUrl('edit-form'));
  }

}
