<?php

namespace Drupal\openlayers\Form;

use Drupal\Core\Form\FormStateInterface;
//use Drupal\image\ImageEffectManager;
//use Drupal\image\ImageStyleInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

use Drupal\openlayers\OpenlayersMapInterface;
use Drupal\openlayers\Form\OpenlayersPluginFormBase;
use Drupal\openlayers\StylePluginManager;

/**
 * Provides an add form for the settings for Openlayers plugins.
 *
 * @internal
 */
class OpenlayersStylePluginAddForm extends OpenlayersPluginFormBase {
  /**
   * The Openlayers plugin manager.
   *
   * @var \Drupal\openlayers\Form\StylePluginManager
   */
  protected $pluginManager;

  /**
   * Constructs a new OpenlayersPluginAddForm.
   *
   * @param \Drupal\openlayers\Form\StylePluginManager
   *   The Openlayers plugin manager.
   */
  public function __construct(StylePluginManager $plugin_manager) {
    $this->pluginManager = $plugin_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('plugin.manager.openlayers.style')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, OpenlayersMapInterface $map = NULL, $plugin_type = NULL, $plugin = NULL) {
    $form = parent::buildForm($form, $form_state, $map, $plugin_type, $plugin);

    $form['#title'] = $this->t('Edit %label %type', ['%label' => $this->olPlugin->label(), '%type' => $plugin_type]);
    $form['actions']['submit']['#value'] = $this->t('Add plugin settings');

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  protected function preparePlugin($plugin_type, $plugin) {
    $plugin = $this->pluginManager->createInstance($plugin);
    
    return $plugin;
  }

}
