<?php

namespace Drupal\openlayers;

use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a base class for configurable Openlayers plugins.
 *
 * @see \Drupal\image\Annotation\ImageEffect
 * @see \Drupal\image\ConfigurableImageEffectInterface
 * @see \Drupal\image\ImageEffectInterface
 * @see \Drupal\image\ImageEffectBase
 * @see \Drupal\image\ImageEffectManager
 * @see plugin_api
 */
abstract class OpenlayersConfigurablePluginBase extends OpenlayersPluginBase implements OpenlayersConfigurablePluginInterface {

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
  }

}
