<?php

namespace Drupal\openlayers;

use Drupal\Core\Plugin\DefaultLazyPluginCollection;
use Drupal\Component\Utility\Unicode;

/**
 * A collection of Openlayers plugins.
 */
class OpenlayersPluginCollection extends DefaultLazyPluginCollection {

  /**
   * {@inheritdoc}
   *
   * @return \Drupal\image\ImageEffectInterface
   */
  public function &get($instance_id) {
    return parent::get($instance_id);
  }

  /**
   * {@inheritdoc}
   */
  public function sortHelper($aID, $bID) {
    $a_label = $this->get($aID)->label();
    $b_label = $this->get($bID)->label();
    return Unicode::strcasecmp($a_label, $b_label);
  }

}
