<?php

namespace Drupal\openlayers\Plugin\OpenlayersControl;

use Drupal\Component\Utility\Color;
use Drupal\Component\Utility\Rectangle;
use Drupal\Core\Form\FormStateInterface;
use Drupal\openlayers\OpenlayersConfigurablePluginBase;

/**
 * Defines the Full Screen control for an Openlayers map.
 *
 * @OpenlayersControl(
 *   id = "ol_control_fullscreen",
 *   label = @Translation("Full screen"),
 *   description = @Translation("Define a full screen control."),
 *   type = "control",
 *   ol_id = "FullScreen"
 * )
 */
class FullScreen extends OpenlayersConfigurablePluginBase {

  /**
   * {@inheritdoc}
   */
  public function getSummary() {
    $summary = [
      '#theme' => 'openlayers_control_summary',
      '#data' => $this->configuration,
    ];
    $summary += parent::getSummary();

    return $summary;
  }
  
  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'className' => 'ol-full-screen',
/*
      'tipLabel' => 'Full Screen',
      'label' => 'a1',     
*/
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['className'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['className'],
      '#title' => t('Class name'),
      '#description' => t('CSS class name.'),
      '#size' => 50,
      '#maxlength' => 50,
      '#required' => FALSE,
    ];
/*
    $form['tipLabel'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['tipLabel'],
      '#title' => t('Tip label'),
      '#description' => t('Text label to use for the button tip.'),
      '#size' => 100,
      '#maxlength' => 100,
      '#required' => FALSE,
    ];
    $form['label'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['label'],
      '#title' => t('Label'),
      '#description' => t('Text label to use for the button.'),
      '#size' => 100,
      '#maxlength' => 100,
      '#required' => FALSE,
    ];
*/
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {

  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);

    $this->configuration['className'] = $form_state->getValue('className');
/*    
    $this->configuration['collapsible'] = $form_state->getValue('collapsible');
    $this->configuration['collapsed'] = $form_state->getValue('collapsed');
    $this->configuration['tipLabel'] = $form_state->getValue('tipLabel');
    $this->configuration['label'] = $form_state->getValue('label');
    $this->configuration['collapseLabel'] = $form_state->getValue('collapseLabel');
*/
  }

}
