<?php

namespace Drupal\openlayers\Plugin\OpenlayersControl;

use Drupal\Component\Utility\Color;
use Drupal\Component\Utility\Rectangle;
use Drupal\Core\Form\FormStateInterface;
use Drupal\openlayers\OpenlayersConfigurablePluginBase;

/**
 * Defines the Mouse Position control for an Openlayers map.
 *
 * @OpenlayersControl(
 *   id = "ol_control_mouseposition",
 *   label = @Translation("Mouse position"),
 *   description = @Translation("Define a mouse position control."),
 *   type = "control",
 *   ol_id = "MousePosition"
 * )
 */
class MousePosition extends OpenlayersConfigurablePluginBase {

  /**
   * {@inheritdoc}
   */
  public function getSummary() {
    $summary = [
      '#theme' => 'openlayers_control_summary',
      '#data' => $this->configuration,
    ];
    $summary += parent::getSummary();

    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'className' => 'ol-mouse-position',
/*      
      'coordinateFormat' => NULL,
      'projection' => NULL,
*/
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['className'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['className'],
      '#title' => t('Class name'),
      '#description' => t('CSS class name.'),
      '#size' => 50,
      '#maxlength' => 50,
      '#required' => FALSE,
    ];
/*
    $form['coordinateFormat'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['coordinateFormat'],
      '#title' => t('Coordinate format'),
      '#description' => t('Coordinate format.'),
      '#size' => 50,
      '#maxlength' => 50,
      '#required' => FALSE,
    ];
    $form['projection'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['projection'],
      '#title' => t('Projection'),
      '#description' => t('Projection. Default is the view projection.'),
      '#size' => 50,
      '#maxlength' => 50,
      '#required' => FALSE,
    ];
*/    
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {

  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);

    $this->configuration['className'] = $form_state->getValue('className');
/*    
    $this->configuration['collapsible'] = $form_state->getValue('collapsible');
    $this->configuration['collapsed'] = $form_state->getValue('collapsed');
    $this->configuration['tipLabel'] = $form_state->getValue('tipLabel');
    $this->configuration['label'] = $form_state->getValue('label');
    $this->configuration['collapseLabel'] = $form_state->getValue('collapseLabel');
*/
  }

}
