<?php

namespace Drupal\openlayers\Plugin\OpenlayersControl;

use Drupal\Component\Utility\Color;
use Drupal\Component\Utility\Rectangle;
use Drupal\Core\Form\FormStateInterface;
use Drupal\openlayers\OpenlayersConfigurablePluginBase;

/**
 * Defines the Rotate control for an Openlayers map.
 *
 * @OpenlayersControl(
 *   id = "ol_control_rotate",
 *   label = @Translation("Rotate"),
 *   description = @Translation("Define a rotate control."),
 *   type = "control",
 *   ol_id = "Rotate"
 * )
 */
class Rotate extends OpenlayersConfigurablePluginBase {

  /**
   * {@inheritdoc}
   */
  public function getSummary() {
    $summary = [
      '#theme' => 'openlayers_control_summary',            //  TODO - ???
      '#data' => $this->configuration,
    ];
    $summary += parent::getSummary();

    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'className' => 'ol-rotate',
/*      
      'coordinateFormat' => NULL,
      'projection' => NULL,
      'collapsible' => TRUE,
      'collapsed' => FALSE,
      'tipLabel' => 'Attributions',
      'label' => 'aaaaaaaaaaaaaa',
      'collapseLabel' => 'bbbbbbbbbbbbbbbb', 
*/      
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['className'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['className'],
      '#title' => t('Class name'),
      '#description' => t('CSS class name.'),
      '#size' => 50,
      '#maxlength' => 50,
      '#required' => FALSE,
    ];
/*
    $form['collapsible'] = array(
      '#type' => 'checkbox',
      '#title' => $this->t('Collapsible'),
      '#description' => t('Specify if attributions can be collapsed.'),
      '#default_value' => $this->configuration['collapsible'],
    );
    $form['collapsed'] = array(
      '#type' => 'checkbox',
      '#title' => $this->t('Collapsed'),
      '#description' => t('Specify if attributions should be collapsed at startup.'),
      '#default_value' => $this->configuration['collapsed'],        //  Specify if attributions can be collapsed.
    );
    $form['tipLabel'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['tipLabel'],
      '#title' => t('Tip label'),
      '#description' => t('Text label to use for the button tip.'),
      '#size' => 100,
      '#maxlength' => 100,
      '#required' => FALSE,
    ];
    $form['label'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['label'],
      '#title' => t('Label'),
      '#description' => t('Text label to use for the collapsed attributions button.'),
      '#size' => 100,
      '#maxlength' => 100,
      '#required' => FALSE,
    ];
    $form['collapseLabel'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['collapseLabel'],
      '#title' => t('Collapse label'),
      '#description' => t('Text label to use for the expanded attributions button.'),
      '#size' => 100,
      '#maxlength' => 100,
      '#required' => FALSE,
    ];
*/    
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {

  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);

    $this->configuration['className'] = $form_state->getValue('className');
/*
    $this->configuration['collapsible'] = $form_state->getValue('collapsible');
    $this->configuration['collapsed'] = $form_state->getValue('collapsed');
    $this->configuration['tipLabel'] = $form_state->getValue('tipLabel');
    $this->configuration['label'] = $form_state->getValue('label');
    $this->configuration['collapseLabel'] = $form_state->getValue('collapseLabel');
*/
  }

}
